"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticIp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * The abstract base
 */
class ElasticIpBase extends aws_cdk_lib_1.Resource {
    grant(identity, ...actions) {
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions,
            resourceArns: [this.elasticIpArn],
        });
    }
}
/**
 * An EC2 Elastic IP address.
 */
class ElasticIp extends ElasticIpBase {
    /**
     * Import an existing EIP from its ARN.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param arn - The EIP ARN
     * @returns The imported Elastic IP
     */
    static fromElasticIpArn(scope, id, arn) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const parsed = stack.splitArn(arn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
        return new (class ImportedArnEip extends ElasticIpBase {
            constructor() {
                super(...arguments);
                this.allocationId = parsed.resourceName;
                this.elasticIpArn = arn;
            }
        })(scope, id, { environmentFromArn: arn });
    }
    /**
     * Import an existing EIP from the given allocation ID.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param allocationId - The EIP allocation ID.
     * @returns The imported Elastic IP
     */
    static fromAllocationId(scope, id, allocationId) {
        const elasticIpArn = aws_cdk_lib_1.Stack.of(scope).formatArn({
            service: "ec2",
            resource: "elastic-ip",
            resourceName: allocationId,
            arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
        });
        return this.fromElasticIpArn(scope, id, elasticIpArn);
    }
    /**
     * Creates a new Elastic IP address.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { removalPolicy } = props;
        const eip = new aws_ec2_1.CfnEIP(this, "Resource", { domain: "vpc" });
        this.allocationId = eip.attrAllocationId;
        this.elasticIpArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: "ec2",
            resource: "elastic-ip",
            resourceName: this.allocationId,
            arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
        });
        this.publicIp = eip.attrPublicIp;
        if (removalPolicy) {
            this.applyRemovalPolicy(removalPolicy);
        }
    }
}
exports.ElasticIp = ElasticIp;
_a = JSII_RTTI_SYMBOL_1;
ElasticIp[_a] = { fqn: "shady-island.networking.ElasticIp", version: "0.1.63" };
//# sourceMappingURL=data:application/json;base64,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