from fennel._vendor.chardet.sbcharsetprober import SingleByteCharSetModel

# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

GREEK_LANG_MODEL = {
    60: {  # 'e'
        60: 2,  # 'e'
        55: 1,  # 'o'
        58: 2,  # 't'
        36: 1,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 1,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    55: {  # 'o'
        60: 0,  # 'e'
        55: 2,  # 'o'
        58: 2,  # 't'
        36: 1,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 1,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 1,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    58: {  # 't'
        60: 2,  # 'e'
        55: 1,  # 'o'
        58: 1,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 1,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    36: {  # '·'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    61: {  # 'Ά'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 1,  # 'γ'
        21: 2,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 1,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    46: {  # 'Έ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 2,  # 'β'
        20: 2,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 2,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 0,  # 'ο'
        9: 2,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 1,  # 'σ'
        2: 2,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 3,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    54: {  # 'Ό'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 2,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 2,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 2,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    31: {  # 'Α'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 2,  # 'Β'
        43: 2,  # 'Γ'
        41: 1,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 2,  # 'Θ'
        47: 2,  # 'Ι'
        44: 2,  # 'Κ'
        53: 2,  # 'Λ'
        38: 2,  # 'Μ'
        49: 2,  # 'Ν'
        59: 1,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 2,  # 'Π'
        48: 2,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 2,  # 'Υ'
        56: 2,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 2,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 1,  # 'θ'
        5: 0,  # 'ι'
        11: 2,  # 'κ'
        16: 3,  # 'λ'
        10: 2,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 0,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 2,  # 'ς'
        7: 2,  # 'σ'
        2: 0,  # 'τ'
        12: 3,  # 'υ'
        28: 2,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 2,  # 'ύ'
        27: 0,  # 'ώ'
    },
    51: {  # 'Β'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 1,  # 'Ε'
        40: 1,  # 'Η'
        52: 0,  # 'Θ'
        47: 1,  # 'Ι'
        44: 0,  # 'Κ'
        53: 1,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 2,  # 'ή'
        15: 0,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    43: {  # 'Γ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 1,  # 'Α'
        51: 0,  # 'Β'
        43: 2,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 1,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 1,  # 'Κ'
        53: 1,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 1,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 2,  # 'Υ'
        56: 0,  # 'Φ'
        50: 1,  # 'Χ'
        57: 2,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    41: {  # 'Δ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 2,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 2,  # 'ή'
        15: 2,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 1,  # 'ό'
        26: 2,  # 'ύ'
        27: 2,  # 'ώ'
    },
    34: {  # 'Ε'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 2,  # 'Γ'
        41: 2,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 2,  # 'Κ'
        53: 2,  # 'Λ'
        38: 2,  # 'Μ'
        49: 2,  # 'Ν'
        59: 1,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 2,  # 'Π'
        48: 2,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 2,  # 'Υ'
        56: 0,  # 'Φ'
        50: 2,  # 'Χ'
        57: 2,  # 'Ω'
        17: 3,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 3,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 3,  # 'γ'
        21: 2,  # 'δ'
        3: 1,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 1,  # 'θ'
        5: 2,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 2,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 0,  # 'ο'
        9: 3,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 2,  # 'σ'
        2: 2,  # 'τ'
        12: 2,  # 'υ'
        28: 2,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 1,  # 'ύ'
        27: 0,  # 'ώ'
    },
    40: {  # 'Η'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 1,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 2,  # 'Θ'
        47: 0,  # 'Ι'
        44: 2,  # 'Κ'
        53: 0,  # 'Λ'
        38: 2,  # 'Μ'
        49: 2,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 2,  # 'Π'
        48: 2,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 1,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 1,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 1,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    52: {  # 'Θ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 1,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 1,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 2,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 2,  # 'ύ'
        27: 0,  # 'ώ'
    },
    47: {  # 'Ι'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 1,  # 'Β'
        43: 1,  # 'Γ'
        41: 2,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 2,  # 'Κ'
        53: 2,  # 'Λ'
        38: 2,  # 'Μ'
        49: 2,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 0,  # 'Υ'
        56: 2,  # 'Φ'
        50: 0,  # 'Χ'
        57: 2,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 2,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 1,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 2,  # 'σ'
        2: 1,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 1,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    44: {  # 'Κ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 1,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 1,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 1,  # 'Τ'
        45: 2,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 1,  # 'Ω'
        17: 3,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 2,  # 'ό'
        26: 2,  # 'ύ'
        27: 2,  # 'ώ'
    },
    53: {  # 'Λ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 2,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 0,  # 'Τ'
        45: 2,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 2,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 0,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 1,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 2,  # 'ό'
        26: 2,  # 'ύ'
        27: 0,  # 'ώ'
    },
    38: {  # 'Μ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 2,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 2,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 2,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 2,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 3,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 2,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    49: {  # 'Ν'
        60: 2,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 2,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 2,  # 'Ω'
        17: 0,  # 'ά'
        18: 2,  # 'έ'
        22: 0,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 1,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 1,  # 'ω'
        19: 2,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    59: {  # 'Ξ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 1,  # 'Ε'
        40: 1,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 1,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 2,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    39: {  # 'Ο'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 1,  # 'Β'
        43: 2,  # 'Γ'
        41: 2,  # 'Δ'
        34: 2,  # 'Ε'
        40: 1,  # 'Η'
        52: 2,  # 'Θ'
        47: 2,  # 'Ι'
        44: 2,  # 'Κ'
        53: 2,  # 'Λ'
        38: 2,  # 'Μ'
        49: 2,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 2,  # 'Π'
        48: 2,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 2,  # 'Υ'
        56: 2,  # 'Φ'
        50: 2,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 2,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 2,  # 'κ'
        16: 2,  # 'λ'
        10: 2,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 2,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 2,  # 'τ'
        12: 2,  # 'υ'
        28: 1,  # 'φ'
        23: 1,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 2,  # 'ύ'
        27: 0,  # 'ώ'
    },
    35: {  # 'Π'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 2,  # 'Λ'
        38: 1,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 1,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 1,  # 'Χ'
        57: 2,  # 'Ω'
        17: 2,  # 'ά'
        18: 1,  # 'έ'
        22: 1,  # 'ή'
        15: 2,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 2,  # 'ό'
        26: 0,  # 'ύ'
        27: 3,  # 'ώ'
    },
    48: {  # 'Ρ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 1,  # 'Γ'
        41: 1,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 2,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 1,  # 'Τ'
        45: 1,  # 'Υ'
        56: 0,  # 'Φ'
        50: 1,  # 'Χ'
        57: 1,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 2,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 1,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 2,  # 'ύ'
        27: 0,  # 'ώ'
    },
    37: {  # 'Σ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 1,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 2,  # 'Κ'
        53: 0,  # 'Λ'
        38: 2,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 2,  # 'Υ'
        56: 0,  # 'Φ'
        50: 2,  # 'Χ'
        57: 2,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 2,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 2,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 2,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 2,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 2,  # 'ύ'
        27: 2,  # 'ώ'
    },
    33: {  # 'Τ'
        60: 0,  # 'e'
        55: 1,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 2,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 2,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 1,  # 'Τ'
        45: 1,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 2,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 0,  # 'ή'
        15: 2,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 2,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 2,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 2,  # 'ό'
        26: 2,  # 'ύ'
        27: 3,  # 'ώ'
    },
    45: {  # 'Υ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 2,  # 'Γ'
        41: 0,  # 'Δ'
        34: 1,  # 'Ε'
        40: 2,  # 'Η'
        52: 2,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 1,  # 'Λ'
        38: 2,  # 'Μ'
        49: 2,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 2,  # 'Π'
        48: 1,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 1,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 3,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    56: {  # 'Φ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 1,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 1,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 2,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 2,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 1,  # 'ύ'
        27: 1,  # 'ώ'
    },
    50: {  # 'Χ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 1,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 2,  # 'Ε'
        40: 2,  # 'Η'
        52: 0,  # 'Θ'
        47: 2,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 1,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 1,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 1,  # 'Χ'
        57: 1,  # 'Ω'
        17: 2,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 2,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 2,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    57: {  # 'Ω'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 1,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 1,  # 'Λ'
        38: 0,  # 'Μ'
        49: 2,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 2,  # 'Ρ'
        37: 2,  # 'Σ'
        33: 2,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 2,  # 'ρ'
        14: 2,  # 'ς'
        7: 2,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 1,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    17: {  # 'ά'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 3,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 3,  # 'ε'
        32: 3,  # 'ζ'
        13: 0,  # 'η'
        25: 3,  # 'θ'
        5: 2,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 0,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 3,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    18: {  # 'έ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 3,  # 'α'
        29: 2,  # 'β'
        20: 3,  # 'γ'
        21: 2,  # 'δ'
        3: 3,  # 'ε'
        32: 2,  # 'ζ'
        13: 0,  # 'η'
        25: 3,  # 'θ'
        5: 0,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 3,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    22: {  # 'ή'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 1,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 3,  # 'θ'
        5: 0,  # 'ι'
        11: 3,  # 'κ'
        16: 2,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 0,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    15: {  # 'ί'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 3,  # 'α'
        29: 2,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 3,  # 'ε'
        32: 3,  # 'ζ'
        13: 3,  # 'η'
        25: 3,  # 'θ'
        5: 0,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 1,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 3,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    1: {  # 'α'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 2,  # 'έ'
        22: 0,  # 'ή'
        15: 3,  # 'ί'
        1: 0,  # 'α'
        29: 3,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 2,  # 'ε'
        32: 3,  # 'ζ'
        13: 1,  # 'η'
        25: 3,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 2,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 0,  # 'ω'
        19: 2,  # 'ό'
        26: 2,  # 'ύ'
        27: 0,  # 'ώ'
    },
    29: {  # 'β'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 2,  # 'έ'
        22: 3,  # 'ή'
        15: 2,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 2,  # 'γ'
        21: 2,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 3,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 2,  # 'ό'
        26: 2,  # 'ύ'
        27: 2,  # 'ώ'
    },
    20: {  # 'γ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 3,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 3,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 2,  # 'ύ'
        27: 3,  # 'ώ'
    },
    21: {  # 'δ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    3: {  # 'ε'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 3,  # 'ί'
        1: 2,  # 'α'
        29: 3,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 2,  # 'ε'
        32: 2,  # 'ζ'
        13: 0,  # 'η'
        25: 3,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 2,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 3,  # 'ω'
        19: 2,  # 'ό'
        26: 3,  # 'ύ'
        27: 2,  # 'ώ'
    },
    32: {  # 'ζ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 2,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 1,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 2,  # 'ό'
        26: 0,  # 'ύ'
        27: 2,  # 'ώ'
    },
    13: {  # 'η'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 3,  # 'γ'
        21: 2,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 3,  # 'θ'
        5: 0,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 0,  # 'ο'
        9: 2,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    25: {  # 'θ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 2,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 1,  # 'λ'
        10: 3,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    5: {  # 'ι'
        60: 0,  # 'e'
        55: 1,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 1,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 0,  # 'ί'
        1: 3,  # 'α'
        29: 3,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 3,  # 'ε'
        32: 2,  # 'ζ'
        13: 3,  # 'η'
        25: 3,  # 'θ'
        5: 0,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 0,  # 'ύ'
        27: 3,  # 'ώ'
    },
    11: {  # 'κ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 3,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 2,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 2,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 2,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    16: {  # 'λ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 1,  # 'β'
        20: 2,  # 'γ'
        21: 1,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 2,  # 'θ'
        5: 3,  # 'ι'
        11: 2,  # 'κ'
        16: 3,  # 'λ'
        10: 2,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 2,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    10: {  # 'μ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 1,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 3,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 2,  # 'υ'
        28: 3,  # 'φ'
        23: 0,  # 'χ'
        42: 2,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 2,  # 'ύ'
        27: 2,  # 'ώ'
    },
    6: {  # 'ν'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 3,  # 'δ'
        3: 3,  # 'ε'
        32: 2,  # 'ζ'
        13: 3,  # 'η'
        25: 3,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 1,  # 'λ'
        10: 0,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    30: {  # 'ξ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 2,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 2,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 2,  # 'ό'
        26: 3,  # 'ύ'
        27: 1,  # 'ώ'
    },
    4: {  # 'ο'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 2,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 2,  # 'α'
        29: 3,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 3,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 2,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 2,  # 'ω'
        19: 1,  # 'ό'
        26: 3,  # 'ύ'
        27: 2,  # 'ώ'
    },
    9: {  # 'π'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 3,  # 'λ'
        10: 0,  # 'μ'
        6: 2,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 2,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 2,  # 'ύ'
        27: 3,  # 'ώ'
    },
    8: {  # 'ρ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 2,  # 'β'
        20: 3,  # 'γ'
        21: 2,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 3,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 1,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 3,  # 'ο'
        9: 2,  # 'π'
        8: 2,  # 'ρ'
        14: 0,  # 'ς'
        7: 2,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    14: {  # 'ς'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 2,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 0,  # 'θ'
        5: 0,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 0,  # 'τ'
        12: 0,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    7: {  # 'σ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 3,  # 'β'
        20: 0,  # 'γ'
        21: 2,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 3,  # 'θ'
        5: 3,  # 'ι'
        11: 3,  # 'κ'
        16: 2,  # 'λ'
        10: 3,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 3,  # 'φ'
        23: 3,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 2,  # 'ώ'
    },
    2: {  # 'τ'
        60: 0,  # 'e'
        55: 2,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 2,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 3,  # 'ι'
        11: 2,  # 'κ'
        16: 2,  # 'λ'
        10: 3,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 2,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    12: {  # 'υ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 3,  # 'ή'
        15: 2,  # 'ί'
        1: 3,  # 'α'
        29: 2,  # 'β'
        20: 3,  # 'γ'
        21: 2,  # 'δ'
        3: 2,  # 'ε'
        32: 2,  # 'ζ'
        13: 2,  # 'η'
        25: 3,  # 'θ'
        5: 2,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 3,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 2,  # 'ω'
        19: 2,  # 'ό'
        26: 0,  # 'ύ'
        27: 2,  # 'ώ'
    },
    28: {  # 'φ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 3,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 2,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 0,  # 'μ'
        6: 1,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 1,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 2,  # 'ύ'
        27: 2,  # 'ώ'
    },
    23: {  # 'χ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 3,  # 'ά'
        18: 2,  # 'έ'
        22: 3,  # 'ή'
        15: 3,  # 'ί'
        1: 3,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 2,  # 'θ'
        5: 3,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 2,  # 'μ'
        6: 3,  # 'ν'
        30: 0,  # 'ξ'
        4: 3,  # 'ο'
        9: 0,  # 'π'
        8: 3,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 3,  # 'τ'
        12: 3,  # 'υ'
        28: 0,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 3,  # 'ω'
        19: 3,  # 'ό'
        26: 3,  # 'ύ'
        27: 3,  # 'ώ'
    },
    42: {  # 'ψ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 2,  # 'ά'
        18: 2,  # 'έ'
        22: 1,  # 'ή'
        15: 2,  # 'ί'
        1: 2,  # 'α'
        29: 0,  # 'β'
        20: 0,  # 'γ'
        21: 0,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 3,  # 'η'
        25: 0,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 0,  # 'λ'
        10: 0,  # 'μ'
        6: 0,  # 'ν'
        30: 0,  # 'ξ'
        4: 2,  # 'ο'
        9: 0,  # 'π'
        8: 0,  # 'ρ'
        14: 0,  # 'ς'
        7: 0,  # 'σ'
        2: 2,  # 'τ'
        12: 1,  # 'υ'
        28: 0,  # 'φ'
        23: 0,  # 'χ'
        42: 0,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    24: {  # 'ω'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 1,  # 'ά'
        18: 0,  # 'έ'
        22: 2,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 2,  # 'β'
        20: 3,  # 'γ'
        21: 2,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 0,  # 'η'
        25: 3,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 0,  # 'ξ'
        4: 0,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 2,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    19: {  # 'ό'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 3,  # 'β'
        20: 3,  # 'γ'
        21: 3,  # 'δ'
        3: 1,  # 'ε'
        32: 2,  # 'ζ'
        13: 2,  # 'η'
        25: 2,  # 'θ'
        5: 2,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 1,  # 'ξ'
        4: 2,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 3,  # 'χ'
        42: 2,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    26: {  # 'ύ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 2,  # 'α'
        29: 2,  # 'β'
        20: 2,  # 'γ'
        21: 1,  # 'δ'
        3: 3,  # 'ε'
        32: 0,  # 'ζ'
        13: 2,  # 'η'
        25: 3,  # 'θ'
        5: 0,  # 'ι'
        11: 3,  # 'κ'
        16: 3,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 2,  # 'ξ'
        4: 3,  # 'ο'
        9: 3,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 2,  # 'φ'
        23: 2,  # 'χ'
        42: 2,  # 'ψ'
        24: 2,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
    27: {  # 'ώ'
        60: 0,  # 'e'
        55: 0,  # 'o'
        58: 0,  # 't'
        36: 0,  # '·'
        61: 0,  # 'Ά'
        46: 0,  # 'Έ'
        54: 0,  # 'Ό'
        31: 0,  # 'Α'
        51: 0,  # 'Β'
        43: 0,  # 'Γ'
        41: 0,  # 'Δ'
        34: 0,  # 'Ε'
        40: 0,  # 'Η'
        52: 0,  # 'Θ'
        47: 0,  # 'Ι'
        44: 0,  # 'Κ'
        53: 0,  # 'Λ'
        38: 0,  # 'Μ'
        49: 0,  # 'Ν'
        59: 0,  # 'Ξ'
        39: 0,  # 'Ο'
        35: 0,  # 'Π'
        48: 0,  # 'Ρ'
        37: 0,  # 'Σ'
        33: 0,  # 'Τ'
        45: 0,  # 'Υ'
        56: 0,  # 'Φ'
        50: 0,  # 'Χ'
        57: 0,  # 'Ω'
        17: 0,  # 'ά'
        18: 0,  # 'έ'
        22: 0,  # 'ή'
        15: 0,  # 'ί'
        1: 0,  # 'α'
        29: 1,  # 'β'
        20: 0,  # 'γ'
        21: 3,  # 'δ'
        3: 0,  # 'ε'
        32: 0,  # 'ζ'
        13: 1,  # 'η'
        25: 2,  # 'θ'
        5: 2,  # 'ι'
        11: 0,  # 'κ'
        16: 2,  # 'λ'
        10: 3,  # 'μ'
        6: 3,  # 'ν'
        30: 1,  # 'ξ'
        4: 0,  # 'ο'
        9: 2,  # 'π'
        8: 3,  # 'ρ'
        14: 3,  # 'ς'
        7: 3,  # 'σ'
        2: 3,  # 'τ'
        12: 0,  # 'υ'
        28: 1,  # 'φ'
        23: 1,  # 'χ'
        42: 0,  # 'ψ'
        24: 0,  # 'ω'
        19: 0,  # 'ό'
        26: 0,  # 'ύ'
        27: 0,  # 'ώ'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
WINDOWS_1253_GREEK_CHAR_TO_ORDER = {
    0: 255,  # '\x00'
    1: 255,  # '\x01'
    2: 255,  # '\x02'
    3: 255,  # '\x03'
    4: 255,  # '\x04'
    5: 255,  # '\x05'
    6: 255,  # '\x06'
    7: 255,  # '\x07'
    8: 255,  # '\x08'
    9: 255,  # '\t'
    10: 254,  # '\n'
    11: 255,  # '\x0b'
    12: 255,  # '\x0c'
    13: 254,  # '\r'
    14: 255,  # '\x0e'
    15: 255,  # '\x0f'
    16: 255,  # '\x10'
    17: 255,  # '\x11'
    18: 255,  # '\x12'
    19: 255,  # '\x13'
    20: 255,  # '\x14'
    21: 255,  # '\x15'
    22: 255,  # '\x16'
    23: 255,  # '\x17'
    24: 255,  # '\x18'
    25: 255,  # '\x19'
    26: 255,  # '\x1a'
    27: 255,  # '\x1b'
    28: 255,  # '\x1c'
    29: 255,  # '\x1d'
    30: 255,  # '\x1e'
    31: 255,  # '\x1f'
    32: 253,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '%'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 82,  # 'A'
    66: 100,  # 'B'
    67: 104,  # 'C'
    68: 94,  # 'D'
    69: 98,  # 'E'
    70: 101,  # 'F'
    71: 116,  # 'G'
    72: 102,  # 'H'
    73: 111,  # 'I'
    74: 187,  # 'J'
    75: 117,  # 'K'
    76: 92,  # 'L'
    77: 88,  # 'M'
    78: 113,  # 'N'
    79: 85,  # 'O'
    80: 79,  # 'P'
    81: 118,  # 'Q'
    82: 105,  # 'R'
    83: 83,  # 'S'
    84: 67,  # 'T'
    85: 114,  # 'U'
    86: 119,  # 'V'
    87: 95,  # 'W'
    88: 99,  # 'X'
    89: 109,  # 'Y'
    90: 188,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 72,  # 'a'
    98: 70,  # 'b'
    99: 80,  # 'c'
    100: 81,  # 'd'
    101: 60,  # 'e'
    102: 96,  # 'f'
    103: 93,  # 'g'
    104: 89,  # 'h'
    105: 68,  # 'i'
    106: 120,  # 'j'
    107: 97,  # 'k'
    108: 77,  # 'l'
    109: 86,  # 'm'
    110: 69,  # 'n'
    111: 55,  # 'o'
    112: 78,  # 'p'
    113: 115,  # 'q'
    114: 65,  # 'r'
    115: 66,  # 's'
    116: 58,  # 't'
    117: 76,  # 'u'
    118: 106,  # 'v'
    119: 103,  # 'w'
    120: 87,  # 'x'
    121: 107,  # 'y'
    122: 112,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 253,  # '\x7f'
    128: 255,  # '€'
    129: 255,  # None
    130: 255,  # '‚'
    131: 255,  # 'ƒ'
    132: 255,  # '„'
    133: 255,  # '…'
    134: 255,  # '†'
    135: 255,  # '‡'
    136: 255,  # None
    137: 255,  # '‰'
    138: 255,  # None
    139: 255,  # '‹'
    140: 255,  # None
    141: 255,  # None
    142: 255,  # None
    143: 255,  # None
    144: 255,  # None
    145: 255,  # '‘'
    146: 255,  # '’'
    147: 255,  # '“'
    148: 255,  # '”'
    149: 255,  # '•'
    150: 255,  # '–'
    151: 255,  # '—'
    152: 255,  # None
    153: 255,  # '™'
    154: 255,  # None
    155: 255,  # '›'
    156: 255,  # None
    157: 255,  # None
    158: 255,  # None
    159: 255,  # None
    160: 253,  # '\xa0'
    161: 233,  # '΅'
    162: 61,  # 'Ά'
    163: 253,  # '£'
    164: 253,  # '¤'
    165: 253,  # '¥'
    166: 253,  # '¦'
    167: 253,  # '§'
    168: 253,  # '¨'
    169: 253,  # '©'
    170: 253,  # None
    171: 253,  # '«'
    172: 253,  # '¬'
    173: 74,  # '\xad'
    174: 253,  # '®'
    175: 253,  # '―'
    176: 253,  # '°'
    177: 253,  # '±'
    178: 253,  # '²'
    179: 253,  # '³'
    180: 247,  # '΄'
    181: 253,  # 'µ'
    182: 253,  # '¶'
    183: 36,  # '·'
    184: 46,  # 'Έ'
    185: 71,  # 'Ή'
    186: 73,  # 'Ί'
    187: 253,  # '»'
    188: 54,  # 'Ό'
    189: 253,  # '½'
    190: 108,  # 'Ύ'
    191: 123,  # 'Ώ'
    192: 110,  # 'ΐ'
    193: 31,  # 'Α'
    194: 51,  # 'Β'
    195: 43,  # 'Γ'
    196: 41,  # 'Δ'
    197: 34,  # 'Ε'
    198: 91,  # 'Ζ'
    199: 40,  # 'Η'
    200: 52,  # 'Θ'
    201: 47,  # 'Ι'
    202: 44,  # 'Κ'
    203: 53,  # 'Λ'
    204: 38,  # 'Μ'
    205: 49,  # 'Ν'
    206: 59,  # 'Ξ'
    207: 39,  # 'Ο'
    208: 35,  # 'Π'
    209: 48,  # 'Ρ'
    210: 250,  # None
    211: 37,  # 'Σ'
    212: 33,  # 'Τ'
    213: 45,  # 'Υ'
    214: 56,  # 'Φ'
    215: 50,  # 'Χ'
    216: 84,  # 'Ψ'
    217: 57,  # 'Ω'
    218: 120,  # 'Ϊ'
    219: 121,  # 'Ϋ'
    220: 17,  # 'ά'
    221: 18,  # 'έ'
    222: 22,  # 'ή'
    223: 15,  # 'ί'
    224: 124,  # 'ΰ'
    225: 1,  # 'α'
    226: 29,  # 'β'
    227: 20,  # 'γ'
    228: 21,  # 'δ'
    229: 3,  # 'ε'
    230: 32,  # 'ζ'
    231: 13,  # 'η'
    232: 25,  # 'θ'
    233: 5,  # 'ι'
    234: 11,  # 'κ'
    235: 16,  # 'λ'
    236: 10,  # 'μ'
    237: 6,  # 'ν'
    238: 30,  # 'ξ'
    239: 4,  # 'ο'
    240: 9,  # 'π'
    241: 8,  # 'ρ'
    242: 14,  # 'ς'
    243: 7,  # 'σ'
    244: 2,  # 'τ'
    245: 12,  # 'υ'
    246: 28,  # 'φ'
    247: 23,  # 'χ'
    248: 42,  # 'ψ'
    249: 24,  # 'ω'
    250: 64,  # 'ϊ'
    251: 75,  # 'ϋ'
    252: 19,  # 'ό'
    253: 26,  # 'ύ'
    254: 27,  # 'ώ'
    255: 253,  # None
}

WINDOWS_1253_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="windows-1253",
    language="Greek",
    char_to_order_map=WINDOWS_1253_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.982851,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)

ISO_8859_7_GREEK_CHAR_TO_ORDER = {
    0: 255,  # '\x00'
    1: 255,  # '\x01'
    2: 255,  # '\x02'
    3: 255,  # '\x03'
    4: 255,  # '\x04'
    5: 255,  # '\x05'
    6: 255,  # '\x06'
    7: 255,  # '\x07'
    8: 255,  # '\x08'
    9: 255,  # '\t'
    10: 254,  # '\n'
    11: 255,  # '\x0b'
    12: 255,  # '\x0c'
    13: 254,  # '\r'
    14: 255,  # '\x0e'
    15: 255,  # '\x0f'
    16: 255,  # '\x10'
    17: 255,  # '\x11'
    18: 255,  # '\x12'
    19: 255,  # '\x13'
    20: 255,  # '\x14'
    21: 255,  # '\x15'
    22: 255,  # '\x16'
    23: 255,  # '\x17'
    24: 255,  # '\x18'
    25: 255,  # '\x19'
    26: 255,  # '\x1a'
    27: 255,  # '\x1b'
    28: 255,  # '\x1c'
    29: 255,  # '\x1d'
    30: 255,  # '\x1e'
    31: 255,  # '\x1f'
    32: 253,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '%'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 82,  # 'A'
    66: 100,  # 'B'
    67: 104,  # 'C'
    68: 94,  # 'D'
    69: 98,  # 'E'
    70: 101,  # 'F'
    71: 116,  # 'G'
    72: 102,  # 'H'
    73: 111,  # 'I'
    74: 187,  # 'J'
    75: 117,  # 'K'
    76: 92,  # 'L'
    77: 88,  # 'M'
    78: 113,  # 'N'
    79: 85,  # 'O'
    80: 79,  # 'P'
    81: 118,  # 'Q'
    82: 105,  # 'R'
    83: 83,  # 'S'
    84: 67,  # 'T'
    85: 114,  # 'U'
    86: 119,  # 'V'
    87: 95,  # 'W'
    88: 99,  # 'X'
    89: 109,  # 'Y'
    90: 188,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 72,  # 'a'
    98: 70,  # 'b'
    99: 80,  # 'c'
    100: 81,  # 'd'
    101: 60,  # 'e'
    102: 96,  # 'f'
    103: 93,  # 'g'
    104: 89,  # 'h'
    105: 68,  # 'i'
    106: 120,  # 'j'
    107: 97,  # 'k'
    108: 77,  # 'l'
    109: 86,  # 'm'
    110: 69,  # 'n'
    111: 55,  # 'o'
    112: 78,  # 'p'
    113: 115,  # 'q'
    114: 65,  # 'r'
    115: 66,  # 's'
    116: 58,  # 't'
    117: 76,  # 'u'
    118: 106,  # 'v'
    119: 103,  # 'w'
    120: 87,  # 'x'
    121: 107,  # 'y'
    122: 112,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 253,  # '\x7f'
    128: 255,  # '\x80'
    129: 255,  # '\x81'
    130: 255,  # '\x82'
    131: 255,  # '\x83'
    132: 255,  # '\x84'
    133: 255,  # '\x85'
    134: 255,  # '\x86'
    135: 255,  # '\x87'
    136: 255,  # '\x88'
    137: 255,  # '\x89'
    138: 255,  # '\x8a'
    139: 255,  # '\x8b'
    140: 255,  # '\x8c'
    141: 255,  # '\x8d'
    142: 255,  # '\x8e'
    143: 255,  # '\x8f'
    144: 255,  # '\x90'
    145: 255,  # '\x91'
    146: 255,  # '\x92'
    147: 255,  # '\x93'
    148: 255,  # '\x94'
    149: 255,  # '\x95'
    150: 255,  # '\x96'
    151: 255,  # '\x97'
    152: 255,  # '\x98'
    153: 255,  # '\x99'
    154: 255,  # '\x9a'
    155: 255,  # '\x9b'
    156: 255,  # '\x9c'
    157: 255,  # '\x9d'
    158: 255,  # '\x9e'
    159: 255,  # '\x9f'
    160: 253,  # '\xa0'
    161: 233,  # '‘'
    162: 90,  # '’'
    163: 253,  # '£'
    164: 253,  # '€'
    165: 253,  # '₯'
    166: 253,  # '¦'
    167: 253,  # '§'
    168: 253,  # '¨'
    169: 253,  # '©'
    170: 253,  # 'ͺ'
    171: 253,  # '«'
    172: 253,  # '¬'
    173: 74,  # '\xad'
    174: 253,  # None
    175: 253,  # '―'
    176: 253,  # '°'
    177: 253,  # '±'
    178: 253,  # '²'
    179: 253,  # '³'
    180: 247,  # '΄'
    181: 248,  # '΅'
    182: 61,  # 'Ά'
    183: 36,  # '·'
    184: 46,  # 'Έ'
    185: 71,  # 'Ή'
    186: 73,  # 'Ί'
    187: 253,  # '»'
    188: 54,  # 'Ό'
    189: 253,  # '½'
    190: 108,  # 'Ύ'
    191: 123,  # 'Ώ'
    192: 110,  # 'ΐ'
    193: 31,  # 'Α'
    194: 51,  # 'Β'
    195: 43,  # 'Γ'
    196: 41,  # 'Δ'
    197: 34,  # 'Ε'
    198: 91,  # 'Ζ'
    199: 40,  # 'Η'
    200: 52,  # 'Θ'
    201: 47,  # 'Ι'
    202: 44,  # 'Κ'
    203: 53,  # 'Λ'
    204: 38,  # 'Μ'
    205: 49,  # 'Ν'
    206: 59,  # 'Ξ'
    207: 39,  # 'Ο'
    208: 35,  # 'Π'
    209: 48,  # 'Ρ'
    210: 250,  # None
    211: 37,  # 'Σ'
    212: 33,  # 'Τ'
    213: 45,  # 'Υ'
    214: 56,  # 'Φ'
    215: 50,  # 'Χ'
    216: 84,  # 'Ψ'
    217: 57,  # 'Ω'
    218: 120,  # 'Ϊ'
    219: 121,  # 'Ϋ'
    220: 17,  # 'ά'
    221: 18,  # 'έ'
    222: 22,  # 'ή'
    223: 15,  # 'ί'
    224: 124,  # 'ΰ'
    225: 1,  # 'α'
    226: 29,  # 'β'
    227: 20,  # 'γ'
    228: 21,  # 'δ'
    229: 3,  # 'ε'
    230: 32,  # 'ζ'
    231: 13,  # 'η'
    232: 25,  # 'θ'
    233: 5,  # 'ι'
    234: 11,  # 'κ'
    235: 16,  # 'λ'
    236: 10,  # 'μ'
    237: 6,  # 'ν'
    238: 30,  # 'ξ'
    239: 4,  # 'ο'
    240: 9,  # 'π'
    241: 8,  # 'ρ'
    242: 14,  # 'ς'
    243: 7,  # 'σ'
    244: 2,  # 'τ'
    245: 12,  # 'υ'
    246: 28,  # 'φ'
    247: 23,  # 'χ'
    248: 42,  # 'ψ'
    249: 24,  # 'ω'
    250: 64,  # 'ϊ'
    251: 75,  # 'ϋ'
    252: 19,  # 'ό'
    253: 26,  # 'ύ'
    254: 27,  # 'ώ'
    255: 253,  # None
}

ISO_8859_7_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-7",
    language="Greek",
    char_to_order_map=ISO_8859_7_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.982851,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)
