from rich import print
from rich.console import Console
from rich.table import Table
from datetime import datetime
import typer
import time
import base64

def abort(msg):
    print("[bold red]Error:[/bold red] "+msg)
    raise typer.Abort()

def now():
    return int(time.time())

def ts_to_str(ts):
    dt = datetime.fromtimestamp(ts)
    return dt.strftime("%c")

def base64_encode_str(input_str: str):
    input_bytes = input_str.encode("ascii") 
    base64_bytes = base64.b64encode(input_bytes)

    return base64_bytes.decode("ascii")

def base64_decode_str(base64_str: str):
    base64_bytes = base64_str.encode("ascii") 
    output_bytes = base64.b64decode(base64_bytes)
    
    return output_bytes.decode("ascii")

def render_state(state):
    match state:
        case 0:
            return "pending"
        case 1: 
            return "success"
        case _:
            return "failure"

def print_jobs(jobs):
    console = Console()
    header = ["Job Id", "Scheduled", "Recipients", "State"]
    table = Table(*header, expand=False, highlight=True, box=None, title_justify="left", show_lines="True")
    console.print()
    for job in jobs:
        row = []
        for key,val in job.items():
            if key == 'hash':
                row.append(val[:20])
            if key in ['created','scheduled']:
                row.append((ts_to_str(val)))
            if key== 'recipients':
                row.append(str(val))
            if key == 'state':
                row.append(render_state(val))
        table.add_row(*row)
    console.print(table)
    console.print()
