import warnings

from stripe import api_requestor, util
from stripe.api_resources.abstract.api_resource import APIResource


class ListableAPIResource(APIResource):

    @classmethod
    def all(cls, *args, **params):
        warnings.warn("The `all` class method is deprecated and will"
                      "be removed in future versions. Please use the "
                      "`list` class method instead",
                      DeprecationWarning)
        return cls.list(*args, **params)

    @classmethod
    def auto_paging_iter(cls, *args, **params):
        return cls.list(*args, **params).auto_paging_iter()

    @classmethod
    def list(cls, api_key=None, stripe_version=None, stripe_account=None,
             **params):
        requestor = api_requestor.APIRequestor(api_key,
                                               api_base=cls.api_base(),
                                               api_version=stripe_version,
                                               account=stripe_account)
        url = cls.class_url()
        response, api_key = requestor.request('get', url, params)
        stripe_object = util.convert_to_stripe_object(response, api_key,
                                                      stripe_version,
                                                      stripe_account)
        stripe_object._retrieve_params = params
        return stripe_object
