"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkSlackChatBot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chatbot = require("aws-cdk-lib/aws-chatbot");
const sns = require("aws-cdk-lib/aws-sns");
const constructs_1 = require("constructs");
class CdkSlackChatBot extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const topic = new sns.Topic(this, 'Topic', {
            displayName: props.topicName,
        });
        this.topic = topic;
        new chatbot.SlackChannelConfiguration(this, 'MySlackChannel', {
            slackChannelConfigurationName: props.slackChannelConfigName,
            slackWorkspaceId: props.slackWorkSpaceId,
            slackChannelId: props.slackChannelId,
            notificationTopics: [topic],
        });
    }
}
exports.CdkSlackChatBot = CdkSlackChatBot;
_a = JSII_RTTI_SYMBOL_1;
CdkSlackChatBot[_a] = { fqn: "cdk-slack-chatbot.CdkSlackChatBot", version: "1.0.181" };
//# sourceMappingURL=data:application/json;base64,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