import mpmath

import numpy as np


def q_b(m0, m1, m2, n0, n1, n2):
    """Stretch"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)


    return mpmath.sqrt((m0 - n0)**2 + (m1 - n1)**2 + (m2 - n2)**2)


def dq_b(m0, m1, m2, n0, n1, n2):
    """Stretch, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - n0
    x1 = m1 - n1
    x2 = m2 - n2
    x3 = 1/mpmath.sqrt(x0**2 + x1**2 + x2**2)

    return np.array([x0*x3, x1*x3, x2*x3, x3*(-m0 + n0), x3*(-m1 + n1), x3*(-m2 + n2)], dtype=np.float64)


def d2q_b(m0, m1, m2, n0, n1, n2):
    """Stretch, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - n0
    x1 = x0**2
    x2 = m1 - n1
    x3 = x2**2
    x4 = m2 - n2
    x5 = x4**2
    x6 = x1 + x3 + x5
    x7 = 1/mpmath.sqrt(x6)
    x8 = x6**(mpmath.mpf(-3)/mpmath.mpf(2))
    x9 = -m0 + n0
    x10 = x8*x9
    x11 = x0*x10 + x7
    x12 = x10*x2
    x13 = x10*x4
    x14 = -x7
    x15 = -m1 + n1
    x16 = x10*x15
    x17 = -m2 + n2
    x18 = x10*x17
    x19 = x15*x8
    x20 = x0*x19
    x21 = x19*x2 + x7
    x22 = x19*x4
    x23 = x17*x19
    x24 = x17*x8
    x25 = x0*x24
    x26 = x2*x24
    x27 = x24*x4 + x7
    x28 = x0*x8
    x29 = x2*x28
    x30 = x28*x4
    x31 = x2*x4*x8

    return np.array([x11, x12, x13, x14 + x8*x9**2, x16, x18, x20, x21, x22, x16, x14 + x15**2*x8, x23, x25, x26, x27, x18, x23, x14 + x17**2*x8, x1*x8 + x14, x29, x30, x11, x20, x25, x29, x14 + x3*x8, x31, x12, x21, x26, x30, x31, x14 + x5*x8, x13, x22, x27], dtype=np.float64)


def q_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = n0 + x0
    x7 = n1 + x2
    x8 = n2 + x4

    return mpmath.acos((x1*x6 + x3*x7 + x5*x8)/(mpmath.sqrt(x1**2 + x3**2 + x5**2)*mpmath.sqrt(x6**2 + x7**2 + x8**2)))


def dq_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = x1**2 + x3**2 + x5**2
    x7 = n0 + x0
    x8 = n1 + x2
    x9 = n2 + x4
    x10 = x7**2 + x8**2 + x9**2
    x11 = x1*x7 + x3*x8 + x5*x9
    x12 = 1/mpmath.sqrt(1 - x11**2/(x10*x6))
    x13 = 1/mpmath.sqrt(x6)
    x14 = 1/mpmath.sqrt(x10)
    x15 = x13*x14
    x16 = -m0
    x17 = x11*x14/x6**(mpmath.mpf(3)/mpmath.mpf(2))
    x18 = -m1
    x19 = -m2
    x20 = -n0
    x21 = x11*x13/x10**(mpmath.mpf(3)/mpmath.mpf(2))
    x22 = -n1
    x23 = -n2

    return np.array([-x12*(x15*x7 + x17*(o0 + x16)), -x12*(x15*x8 + x17*(o1 + x18)), -x12*(x15*x9 + x17*(o2 + x19)), -x12*(x1*x17 + x15*(2*o0 + x16 + x20) + x21*x7), -x12*(x15*(2*o1 + x18 + x22) + x17*x3 + x21*x8), -x12*(x15*(2*o2 + x19 + x23) + x17*x5 + x21*x9), -x12*(x1*x15 + x21*(o0 + x20)), -x12*(x15*x3 + x21*(o1 + x22)), -x12*(x15*x5 + x21*(o2 + x23))], dtype=np.float64)


def d2q_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = n0 + x0
    x3 = x1*x2
    x4 = -o1
    x5 = m1 + x4
    x6 = n1 + x4
    x7 = x5*x6
    x8 = -o2
    x9 = m2 + x8
    x10 = n2 + x8
    x11 = x10*x9
    x12 = x11 + x3 + x7
    x13 = x12**2
    x14 = x1**2
    x15 = x5**2
    x16 = x9**2
    x17 = x14 + x15 + x16
    x18 = x17**(-1)
    x19 = x2**2
    x20 = x6**2
    x21 = x10**2
    x22 = x19 + x20 + x21
    x23 = x22**(-1)
    x24 = x18*x23
    x25 = -x13*x24 + 1
    x26 = 1/mpmath.sqrt(x25)
    x27 = -m0
    x28 = o0 + x27
    x29 = 1/mpmath.sqrt(x22)
    x30 = x17**(mpmath.mpf(-3)/mpmath.mpf(2))
    x31 = x29*x30
    x32 = x2*x31
    x33 = x12*x31
    x34 = -x33
    x35 = x12*x28
    x36 = 3*m0
    x37 = 3*o0
    x38 = x29/x17**(mpmath.mpf(5)/mpmath.mpf(2))
    x39 = x38*(-x36 + x37)
    x40 = 1/mpmath.sqrt(x17)
    x41 = x29*x40
    x42 = x2*x41 + x28*x33
    x43 = x25**(mpmath.mpf(-3)/mpmath.mpf(2))
    x44 = 2*n0
    x45 = 2*o0
    x46 = -x45
    x47 = (mpmath.mpf(1)/mpmath.mpf(2))*x44 + (mpmath.mpf(1)/mpmath.mpf(2))*x46
    x48 = x12*x24
    x49 = 2*m0
    x50 = -x49
    x51 = (mpmath.mpf(1)/mpmath.mpf(2))*x13
    x52 = x23*x51/x17**2
    x53 = x43*(x47*x48 + x52*(x45 + x50))
    x54 = -m1
    x55 = o1 + x54
    x56 = x12*x39
    x57 = x28*x31
    x58 = x32*x55 + x57*x6
    x59 = x33*x55 + x41*x6
    x60 = -m2
    x61 = o2 + x60
    x62 = x10*x57 + x32*x61
    x63 = x10*x41 + x33*x61
    x64 = -n0
    x65 = x27 + x45 + x64
    x66 = x22**(mpmath.mpf(-3)/mpmath.mpf(2))
    x67 = x40*x66
    x68 = x12*x67
    x69 = x1*x33 + x2*x68 + x41*x65
    x70 = x30*x66
    x71 = x35*x70
    x72 = -x41
    x73 = x33 + x72
    x74 = x19*x67 + x2*x71 + x3*x31 + x57*x65 + x73
    x75 = -n1
    x76 = 2*o1
    x77 = x54 + x75 + x76
    x78 = x2*x67
    x79 = x6*x78
    x80 = x32*x5 + x57*x77 + x6*x71 + x79
    x81 = x33*x5 + x41*x77 + x6*x68
    x82 = -n2
    x83 = 2*o2
    x84 = x60 + x82 + x83
    x85 = x10*x78
    x86 = x10*x71 + x32*x9 + x57*x84 + x85
    x87 = x10*x68 + x33*x9 + x41*x84
    x88 = o0 + x64
    x89 = -x26*(x1*x57 + x41 + x71*x88 + x78*x88)
    x90 = x1*x41 + x68*x88
    x91 = o1 + x75
    x92 = -x26*(x5*x57 + x71*x91 + x78*x91)
    x93 = x41*x5 + x68*x91
    x94 = o2 + x82
    x95 = -x26*(x57*x9 + x71*x94 + x78*x94)
    x96 = x41*x9 + x68*x94
    x97 = 3*m1
    x98 = 3*o1
    x99 = x38*(-x97 + x98)
    x100 = 2*n1
    x101 = -x76
    x102 = x100 + x101
    x103 = (mpmath.mpf(1)/mpmath.mpf(2))*x48
    x104 = 2*m1
    x105 = -x104
    x106 = x43*(x102*x103 + x52*(x105 + x76))
    x107 = x31*x6
    x108 = x12*x99
    x109 = x31*x55
    x110 = x10*x109 + x107*x61
    x111 = x12*x55
    x112 = x111*x70
    x113 = x1*x107 + x109*x65 + x112*x2 + x79
    x114 = x109*x77 + x112*x6 + x20*x67 + x31*x7 + x73
    x115 = x6*x67
    x116 = x10*x115
    x117 = x10*x112 + x107*x9 + x109*x84 + x116
    x118 = -x26*(x1*x109 + x112*x88 + x115*x88)
    x119 = -x26*(x109*x5 + x112*x91 + x115*x91 + x41)
    x120 = -x26*(x109*x9 + x112*x94 + x115*x94)
    x121 = 3*m2
    x122 = 3*o2
    x123 = x38*(-x121 + x122)
    x124 = 2*n2
    x125 = -x83
    x126 = x124 + x125
    x127 = 2*m2
    x128 = -x127
    x129 = x43*(x103*x126 + x52*(x128 + x83))
    x130 = x10*x31
    x131 = x12*x123
    x132 = x31*x61
    x133 = x12*x61
    x134 = x133*x70
    x135 = x1*x130 + x132*x65 + x134*x2 + x85
    x136 = x116 + x130*x5 + x132*x77 + x134*x6
    x137 = x10*x134 + x11*x31 + x132*x84 + x21*x67 + x73
    x138 = x10*x67
    x139 = -x26*(x1*x132 + x134*x88 + x138*x88)
    x140 = -x26*(x132*x5 + x134*x91 + x138*x91)
    x141 = -x26*(x132*x9 + x134*x94 + x138*x94 + x41)
    x142 = x46 + x49
    x143 = x18/x22**2
    x144 = -x44
    x145 = x43*(x103*(4*o0 + x144 + x50) + x13*x143*x47 + x142*x52)
    x146 = -x37
    x147 = x38*(x146 + x36)
    x148 = x1*x31
    x149 = 2*x65
    x150 = x12*x147
    x151 = x12*x2
    x152 = 3*n0
    x153 = x40/x22**(mpmath.mpf(5)/mpmath.mpf(2))
    x154 = x153*(x146 + x152)
    x155 = x12*x70
    x156 = 2*x155
    x157 = -x68
    x158 = x157 + x34 + 2*x41
    x159 = x12*x6
    x160 = x31*x65
    x161 = x1*x70
    x162 = x151*x70
    x163 = x115*x65 + x148*x77 + x159*x161 + x160*x5 + x162*x5 + x77*x78
    x164 = x10*x12
    x165 = x138*x65 + x148*x84 + x160*x9 + x161*x164 + x162*x9 + x78*x84
    x166 = x12*x88
    x167 = x65*x67
    x168 = x68 + x72
    x169 = x14*x31 + x161*x166 + x167*x88 + x168 + x3*x67
    x170 = x12*x91
    x171 = x148*x5
    x172 = x161*x170 + x167*x91 + x171 + x5*x78
    x173 = x12*x94
    x174 = x148*x9
    x175 = x161*x173 + x167*x94 + x174 + x78*x9
    x176 = -x98
    x177 = x38*(x176 + x97)
    x178 = x101 + x104
    x179 = x143*x51
    x180 = -x100
    x181 = x43*(x102*x179 + x103*(4*o1 + x105 + x180) + x178*x52)
    x182 = x12*x177
    x183 = 3*n1
    x184 = x153*(x176 + x183)
    x185 = x31*x5
    x186 = 2*x77
    x187 = x31*x9
    x188 = x5*x70
    x189 = x70*x9
    x190 = x115*x84 + x138*x77 + x159*x189 + x164*x188 + x185*x84 + x187*x77
    x191 = x67*x77
    x192 = x1*x115 + x166*x188 + x171 + x191*x88
    x193 = x15*x31 + x168 + x170*x188 + x191*x91 + x67*x7
    x194 = x185*x9
    x195 = x5*x94
    x196 = x115*x9 + x155*x195 + x191*x94 + x194
    x197 = -x122
    x198 = x38*(x121 + x197)
    x199 = x125 + x127
    x200 = -x124
    x201 = x43*(x103*(4*o2 + x128 + x200) + x126*x179 + x199*x52)
    x202 = x12*x198
    x203 = 3*n2
    x204 = x153*(x197 + x203)
    x205 = 2*x84
    x206 = x67*x84
    x207 = x1*x138 + x166*x189 + x174 + x206*x88
    x208 = x9*x91
    x209 = x138*x5 + x155*x208 + x194 + x206*x91
    x210 = x11*x67 + x16*x31 + x168 + x173*x189 + x206*x94
    x211 = x43*(x103*x142 + x179*(x144 + x45))
    x212 = x153*(-x152 + x37)
    x213 = x1*x67
    x214 = x67*x88
    x215 = x213*x91 + x214*x5
    x216 = x213*x94 + x214*x9
    x217 = x43*(x103*x178 + x179*(x180 + x76))
    x218 = x153*(-x183 + x98)
    x219 = 2*x67
    x220 = x195*x67 + x208*x67
    x221 = x43*(x103*x199 + x179*(x200 + x83))
    x222 = x153*(x122 - x203)

    return np.array([-x26*(2*x28*x32 + x34 + x35*x39) - x42*x53, -x26*(x55*x56 + x58) - x53*x59, -x26*(x56*x61 + x62) - x53*x63, -x26*(x1*x56 + x74) - x53*x69, -x26*(x5*x56 + x80) - x53*x81, -x26*(x56*x9 + x86) - x53*x87, -x53*x90 + x89, -x53*x93 + x92, -x53*x96 + x95, -x106*x42 - x26*(x35*x99 + x58), -x106*x59 - x26*(2*x107*x55 + x108*x55 + x34), -x106*x63 - x26*(x108*x61 + x110), -x106*x69 - x26*(x1*x108 + x113), -x106*x81 - x26*(x108*x5 + x114), -x106*x87 - x26*(x108*x9 + x117), -x106*x90 + x118, -x106*x93 + x119, -x106*x96 + x120, -x129*x42 - x26*(x123*x35 + x62), -x129*x59 - x26*(x110 + x111*x123), -x129*x63 - x26*(2*x130*x61 + x131*x61 + x34), -x129*x69 - x26*(x1*x131 + x135), -x129*x81 - x26*(x131*x5 + x136), -x129*x87 - x26*(x131*x9 + x137), -x129*x90 + x139, -x129*x93 + x140, -x129*x96 + x141, -x145*x42 - x26*(x147*x35 + x74), -x145*x59 - x26*(x111*x147 + x113), -x145*x63 - x26*(x133*x147 + x135), -x145*x69 - x26*(x1*x150 + x148*x149 + x149*x78 + x151*x154 + x156*x3 + x158), -x145*x81 - x26*(x150*x5 + x154*x159 + x163), -x145*x87 - x26*(x150*x9 + x154*x164 + x165), -x145*x90 - x26*(x154*x166 + x169), -x145*x93 - x26*(x154*x170 + x172), -x145*x96 - x26*(x154*x173 + x175), -x181*x42 - x26*(x177*x35 + x80), -x181*x59 - x26*(x111*x177 + x114), -x181*x63 - x26*(x133*x177 + x136), -x181*x69 - x26*(x1*x182 + x151*x184 + x163), -x181*x81 - x26*(x115*x186 + x156*x7 + x158 + x159*x184 + x182*x5 + x185*x186), -x181*x87 - x26*(x164*x184 + x182*x9 + x190), -x181*x90 - x26*(x166*x184 + x192), -x181*x93 - x26*(x170*x184 + x193), -x181*x96 - x26*(x173*x184 + x196), -x201*x42 - x26*(x198*x35 + x86), -x201*x59 - x26*(x111*x198 + x117), -x201*x63 - x26*(x133*x198 + x137), -x201*x69 - x26*(x1*x202 + x151*x204 + x165), -x201*x81 - x26*(x159*x204 + x190 + x202*x5), -x201*x87 - x26*(x11*x156 + x138*x205 + x158 + x164*x204 + x187*x205 + x202*x9), -x201*x90 - x26*(x166*x204 + x207), -x201*x93 - x26*(x170*x204 + x209), -x201*x96 - x26*(x173*x204 + x210), -x211*x42 + x89, x118 - x211*x59, x139 - x211*x63, -x211*x69 - x26*(x151*x212 + x169), -x211*x81 - x26*(x159*x212 + x192), -x211*x87 - x26*(x164*x212 + x207), -x211*x90 - x26*(x157 + x166*x212 + 2*x213*x88), -x211*x93 - x26*(x170*x212 + x215), -x211*x96 - x26*(x173*x212 + x216), -x217*x42 + x92, x119 - x217*x59, x140 - x217*x63, -x217*x69 - x26*(x151*x218 + x172), -x217*x81 - x26*(x159*x218 + x193), -x217*x87 - x26*(x164*x218 + x209), -x217*x90 - x26*(x166*x218 + x215), -x217*x93 - x26*(x157 + x170*x218 + x219*x5*x91), -x217*x96 - x26*(x173*x218 + x220), -x221*x42 + x95, x120 - x221*x59, x141 - x221*x63, -x221*x69 - x26*(x151*x222 + x175), -x221*x81 - x26*(x159*x222 + x196), -x221*x87 - x26*(x164*x222 + x210), -x221*x90 - x26*(x166*x222 + x216), -x221*x93 - x26*(x170*x222 + x220), -x221*x96 - x26*(x157 + x173*x222 + x219*x9*x94)], dtype=np.float64)


def q_a2(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend2"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = n1 + x2
    x4 = m1 + x2
    x5 = -o2
    x6 = m2 + x5
    x7 = n0 + x0
    x8 = n2 + x5

    return mpmath.atan2(mpmath.sqrt((x1*x3 + x4*(-n0 + o0))**2 + (x1*(-n2 + o2) + x6*x7)**2 + (x4*x8 + x6*(-n1 + o1))**2), x1*x7 + x3*x4 + x6*x8)


def dq_a2(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend2, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = n0 + x0
    x2 = m0 + x0
    x3 = -o1
    x4 = n1 + x3
    x5 = m1 + x3
    x6 = -n0
    x7 = x2*x4 + x5*(o0 + x6)
    x8 = -n2
    x9 = -o2
    x10 = m2 + x9
    x11 = x1*x10 + x2*(o2 + x8)
    x12 = n2 + x9
    x13 = -n1
    x14 = x10*(o1 + x13) + x12*x5
    x15 = x11**2 + x14**2 + x7**2
    x16 = mpmath.sqrt(x15)
    x17 = x1*x2 + x10*x12 + x4*x5
    x18 = (x15 + x17**2)**(-1)
    x19 = x16*x18
    x20 = 2*n1
    x21 = 2*o1
    x22 = -x21
    x23 = (mpmath.mpf(1)/mpmath.mpf(2))*x7
    x24 = 2*n2
    x25 = -x24
    x26 = 2*o2
    x27 = (mpmath.mpf(1)/mpmath.mpf(2))*x11
    x28 = x17*x18/x16
    x29 = 2*n0
    x30 = -x29
    x31 = 2*o0
    x32 = -x26
    x33 = (mpmath.mpf(1)/mpmath.mpf(2))*x14
    x34 = -x31
    x35 = -x20
    x36 = 2*m1
    x37 = 2*m2
    x38 = -x37
    x39 = 2*m0
    x40 = -x39
    x41 = -x36

    return np.array([-x1*x19 + x28*(x23*(x20 + x22) + x27*(x25 + x26)), -x19*x4 + x28*(x23*(x30 + x31) + x33*(x24 + x32)), -x12*x19 + x28*(x27*(x29 + x34) + x33*(x21 + x35)), -x19*(-m0 + x31 + x6) + x28*(x23*(x35 + x36) + x27*(x24 + x38)), -x19*(-m1 + x13 + x21) + x28*(x23*(x29 + x40) + x33*(x25 + x37)), -x19*(-m2 + x26 + x8) + x28*(x27*(x30 + x39) + x33*(x20 + x41)), -x19*x2 + x28*(x23*(x21 + x41) + x27*(x32 + x37)), -x19*x5 + x28*(x23*(x34 + x39) + x33*(x26 + x38)), -x10*x19 + x28*(x27*(x31 + x40) + x33*(x22 + x36))], dtype=np.float64)


def d2q_a2(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend2, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o1
    x1 = n1 + x0
    x2 = -n2
    x3 = o2 + x2
    x4 = -o0
    x5 = m0 + x4
    x6 = n0 + x4
    x7 = m1 + x0
    x8 = -o2
    x9 = m2 + x8
    x10 = n2 + x8
    x11 = x1*x7 + x10*x9 + x5*x6
    x12 = x1*x5
    x13 = -n0
    x14 = o0 + x13
    x15 = x14*x7
    x16 = x12 + x15
    x17 = x3*x5
    x18 = x6*x9
    x19 = x17 + x18
    x20 = x10*x7
    x21 = -n1
    x22 = o1 + x21
    x23 = x22*x9
    x24 = x20 + x23
    x25 = x16**2 + x19**2 + x24**2
    x26 = x11**2 + x25
    x27 = x26**(-1)
    x28 = mpmath.sqrt(x25)
    x29 = x28**(-1)
    x30 = x27*x29
    x31 = x11*x30
    x32 = 2*n1
    x33 = 2*o1
    x34 = -x33
    x35 = x32 + x34
    x36 = x16*x35
    x37 = 2*n2
    x38 = -x37
    x39 = 2*o2
    x40 = x19*(x38 + x39)
    x41 = 2*n0
    x42 = 2*o0
    x43 = -x42
    x44 = x41 + x43
    x45 = -x11*x44 - x36 - x40
    x46 = x26**(-2)
    x47 = x28*x46
    x48 = x45*x47
    x49 = (mpmath.mpf(1)/mpmath.mpf(2))*x36
    x50 = (mpmath.mpf(1)/mpmath.mpf(2))*x40
    x51 = x49 + x50
    x52 = x11*x51
    x53 = x27/x25**(mpmath.mpf(3)/mpmath.mpf(2))
    x54 = x53*(-x49 - x50)
    x55 = x29*x46
    x56 = x45*x55
    x57 = x1*x14*x31
    x58 = -x41
    x59 = x16*(x42 + x58)
    x60 = (mpmath.mpf(1)/mpmath.mpf(2))*x59
    x61 = -x39
    x62 = x37 + x61
    x63 = x24*x62
    x64 = (mpmath.mpf(1)/mpmath.mpf(2))*x63
    x65 = x60 + x64
    x66 = x30*x6
    x67 = x65*x66
    x68 = x30*x51
    x69 = x1*x68
    x70 = x11*x65
    x71 = x3*x31*x6
    x72 = x19*x44
    x73 = (mpmath.mpf(1)/mpmath.mpf(2))*x72
    x74 = -x32
    x75 = x24*(x33 + x74)
    x76 = (mpmath.mpf(1)/mpmath.mpf(2))*x75
    x77 = x73 + x76
    x78 = x66*x77
    x79 = x10*x68
    x80 = x11*x77
    x81 = 2*m1
    x82 = x16*(x74 + x81)
    x83 = (mpmath.mpf(1)/mpmath.mpf(2))*x82
    x84 = 2*m2
    x85 = -x84
    x86 = x19*(x37 + x85)
    x87 = (mpmath.mpf(1)/mpmath.mpf(2))*x86
    x88 = x83 + x87
    x89 = x66*x88
    x90 = -m0
    x91 = x13 + x42 + x90
    x92 = x68*x91
    x93 = x11*x88
    x94 = x27*x28
    x95 = m1 + x21
    x96 = -m2
    x97 = n2 + x96
    x98 = x31*(x1*x95 + x3*x97) + x94
    x99 = 2*m0
    x100 = -x99
    x101 = x16*(x100 + x41)
    x102 = (mpmath.mpf(1)/mpmath.mpf(2))*x101
    x103 = x24*(x38 + x84)
    x104 = (mpmath.mpf(1)/mpmath.mpf(2))*x103
    x105 = x102 + x104
    x106 = x105*x66
    x107 = n0 + x90
    x108 = -x12 - x15
    x109 = x31*(x1*x107 + x108)
    x110 = -m1
    x111 = x110 + x21 + x33
    x112 = x111*x68
    x113 = x105*x11
    x114 = m0 + x13
    x115 = x31*(x114*x3 + x19)
    x116 = x19*(x58 + x99)
    x117 = (mpmath.mpf(1)/mpmath.mpf(2))*x116
    x118 = -x81
    x119 = x24*(x118 + x32)
    x120 = (mpmath.mpf(1)/mpmath.mpf(2))*x119
    x121 = x117 + x120
    x122 = x121*x66
    x123 = x2 + x39 + x96
    x124 = x123*x68
    x125 = x11*x121
    x126 = x16*(x118 + x33)
    x127 = (mpmath.mpf(1)/mpmath.mpf(2))*x126
    x128 = x61 + x84
    x129 = x128*x19
    x130 = (mpmath.mpf(1)/mpmath.mpf(2))*x129
    x131 = x127 + x130
    x132 = x131*x66
    x133 = x5*x68
    x134 = x11*x131
    x135 = -x94
    x136 = o1 + x110
    x137 = x135 + x31*(x1*x136 + x3*x9)
    x138 = x31*(2*x12 + x15)
    x139 = x43 + x99
    x140 = x139*x16
    x141 = (mpmath.mpf(1)/mpmath.mpf(2))*x140
    x142 = x24*(x39 + x85)
    x143 = (mpmath.mpf(1)/mpmath.mpf(2))*x142
    x144 = x141 + x143
    x145 = x144*x66
    x146 = x68*x7
    x147 = x11*x144
    x148 = x19*(x100 + x42)
    x149 = (mpmath.mpf(1)/mpmath.mpf(2))*x148
    x150 = x34 + x81
    x151 = x150*x24
    x152 = (mpmath.mpf(1)/mpmath.mpf(2))*x151
    x153 = x149 + x152
    x154 = x153*x66
    x155 = o0 + x90
    x156 = -x17 - x18
    x157 = x31*(x155*x3 + x156)
    x158 = x68*x9
    x159 = x11*x153
    x160 = -x11*x35 - x59 - x63
    x161 = x160*x47
    x162 = x53*(-x60 - x64)
    x163 = x160*x55
    x164 = x10*x22*x31
    x165 = x1*x30
    x166 = x165*x77
    x167 = x30*x65
    x168 = x10*x167
    x169 = x31*(x14*x95 + x16)
    x170 = x165*x88
    x171 = x167*x91
    x172 = x105*x165
    x173 = x111*x167
    x174 = m2 + x2
    x175 = x31*(x10*x174 + x107*x14) + x94
    x176 = x121*x165
    x177 = n1 + x110
    x178 = -x20 - x23
    x179 = x31*(x10*x177 + x178)
    x180 = x123*x167
    x181 = x131*x165
    x182 = x31*(x108 + x136*x14)
    x183 = x167*x5
    x184 = x144*x165
    x185 = x167*x7
    x186 = o2 + x96
    x187 = x135 + x31*(x10*x186 + x14*x5)
    x188 = x31*(2*x20 + x23)
    x189 = x153*x165
    x190 = x167*x9
    x191 = -x11*x62 - x72 - x75
    x192 = x191*x47
    x193 = x53*(-x73 - x76)
    x194 = x191*x55
    x195 = x10*x30
    x196 = x195*x88
    x197 = x31*(x156 + x6*x97)
    x198 = x30*x77
    x199 = x198*x91
    x200 = x31*(x174*x22 + x24)
    x201 = x105*x195
    x202 = x111*x198
    x203 = x121*x195
    x204 = x123*x198
    x205 = x31*(x114*x6 + x177*x22) + x94
    x206 = x31*(x17 + 2*x18)
    x207 = x131*x195
    x208 = x198*x5
    x209 = x144*x195
    x210 = x31*(x178 + x186*x22)
    x211 = x198*x7
    x212 = x153*x195
    x213 = x198*x9
    x214 = x135 + x31*(x155*x6 + x22*x7)
    x215 = -x11*(4*o0 + x100 + x58) - x82 - x86
    x216 = x215*x47
    x217 = x53*(-x83 - x87)
    x218 = x215*x55
    x219 = -2*x94
    x220 = x107*x31*x95
    x221 = x30*x91
    x222 = x105*x221
    x223 = x30*x88
    x224 = x111*x223
    x225 = x114*x31*x97
    x226 = x121*x221
    x227 = x123*x223
    x228 = x131*x221
    x229 = x223*x5
    x230 = x31*(x136*x95 + x9*x97) + x94
    x231 = x31*(x108 + x5*x95)
    x232 = x223*x7
    x233 = x144*x221
    x234 = x31*(x155*x97 + x19)
    x235 = x223*x9
    x236 = x153*x221
    x237 = -x101 - x103 - x11*(4*o1 + x118 + x74)
    x238 = x237*x47
    x239 = x53*(-x102 - x104)
    x240 = x237*x55
    x241 = x174*x177*x31
    x242 = x111*x30
    x243 = x121*x242
    x244 = x105*x30
    x245 = x123*x244
    x246 = x31*(x107*x136 + x16)
    x247 = x244*x5
    x248 = x131*x242
    x249 = x144*x242
    x250 = x244*x7
    x251 = x31*(x107*x5 + x174*x186) + x94
    x252 = x31*(x174*x7 + x178)
    x253 = x244*x9
    x254 = x153*x242
    x255 = -x11*(4*o2 + x38 + x85) - x116 - x119
    x256 = x255*x47
    x257 = x53*(-x117 - x120)
    x258 = x255*x55
    x259 = x31*(x114*x9 + x156)
    x260 = x121*x30
    x261 = x260*x5
    x262 = x123*x30
    x263 = x131*x262
    x264 = x31*(x177*x186 + x24)
    x265 = x260*x7
    x266 = x144*x262
    x267 = x153*x262
    x268 = x260*x9
    x269 = x31*(x114*x155 + x177*x7) + x94
    x270 = -x11*x139 - x126 - x129
    x271 = x270*x47
    x272 = x53*(-x127 - x130)
    x273 = x270*x55
    x274 = x136*x31*x5
    x275 = x30*x5
    x276 = x144*x275
    x277 = x131*x30
    x278 = x277*x7
    x279 = x155*x31*x9
    x280 = x153*x275
    x281 = x277*x9
    x282 = -x11*x150 - x140 - x142
    x283 = x282*x47
    x284 = x53*(-x141 - x143)
    x285 = x282*x55
    x286 = x186*x31*x7
    x287 = x153*x30*x7
    x288 = x144*x30*x9
    x289 = -x11*x128 - x148 - x151
    x290 = x289*x47
    x291 = x53*(-x149 - x152)
    x292 = x289*x55

    return np.array([x31*(x1**2 + x3**2) - x48*x6 + x52*x54 + x52*x56, -x1*x48 + x54*x70 + x56*x70 + x57 + x67 - x69, -x10*x48 + x54*x80 + x56*x80 + x71 + x78 - x79, -x48*x91 + x54*x93 + x56*x93 + x89 - x92 + x98, x106 + x109 - x111*x48 - x112 + x113*x54 + x113*x56, x115 + x122 - x123*x48 - x124 + x125*x54 + x125*x56, x132 - x133 + x134*x54 + x134*x56 + x137 - x48*x5, x138 + x145 - x146 + x147*x54 + x147*x56 - x48*x7, x154 + x157 - x158 + x159*x54 + x159*x56 - x48*x9, -x161*x6 + x162*x52 + x163*x52 + x57 - x67 + x69, -x1*x161 + x162*x70 + x163*x70 + x31*(x10**2 + x14**2), -x10*x161 + x162*x80 + x163*x80 + x164 + x166 - x168, -x161*x91 + x162*x93 + x163*x93 + x169 + x170 - x171, -x111*x161 + x113*x162 + x113*x163 + x172 - x173 + x175, -x123*x161 + x125*x162 + x125*x163 + x176 + x179 - x180, x134*x162 + x134*x163 - x161*x5 + x181 + x182 - x183, x147*x162 + x147*x163 - x161*x7 + x184 - x185 + x187, x159*x162 + x159*x163 - x161*x9 + x188 + x189 - x190, -x192*x6 + x193*x52 + x194*x52 + x71 - x78 + x79, -x1*x192 + x164 - x166 + x168 + x193*x70 + x194*x70, -x10*x192 + x193*x80 + x194*x80 + x31*(x22**2 + x6**2), -x192*x91 + x193*x93 + x194*x93 + x196 + x197 - x199, -x111*x192 + x113*x193 + x113*x194 + x200 + x201 - x202, -x123*x192 + x125*x193 + x125*x194 + x203 - x204 + x205, x134*x193 + x134*x194 - x192*x5 + x206 + x207 - x208, x147*x193 + x147*x194 - x192*x7 + x209 + x210 - x211, x159*x193 + x159*x194 - x192*x9 + x212 - x213 + x214, -x216*x6 + x217*x52 + x218*x52 - x89 + x92 + x98, -x1*x216 + x169 - x170 + x171 + x217*x70 + x218*x70, -x10*x216 - x196 + x197 + x199 + x217*x80 + x218*x80, -x216*x91 + x217*x93 + x218*x93 + x219 + x31*(x95**2 + x97**2), -x111*x216 + x113*x217 + x113*x218 + x220 + x222 - x224, -x123*x216 + x125*x217 + x125*x218 + x225 + x226 - x227, x134*x217 + x134*x218 - x216*x5 + x228 - x229 + x230, x147*x217 + x147*x218 - x216*x7 + x231 - x232 + x233, x159*x217 + x159*x218 - x216*x9 + x234 - x235 + x236, -x106 + x109 + x112 - x238*x6 + x239*x52 + x240*x52, -x1*x238 - x172 + x173 + x175 + x239*x70 + x240*x70, -x10*x238 + x200 - x201 + x202 + x239*x80 + x240*x80, x220 - x222 + x224 - x238*x91 + x239*x93 + x240*x93, -x111*x238 + x113*x239 + x113*x240 + x219 + x31*(x107**2 + x174**2), -x123*x238 + x125*x239 + x125*x240 + x241 + x243 - x245, x134*x239 + x134*x240 - x238*x5 + x246 - x247 + x248, x147*x239 + x147*x240 - x238*x7 + x249 - x250 + x251, x159*x239 + x159*x240 - x238*x9 + x252 - x253 + x254, x115 - x122 + x124 - x256*x6 + x257*x52 + x258*x52, -x1*x256 - x176 + x179 + x180 + x257*x70 + x258*x70, -x10*x256 - x203 + x204 + x205 + x257*x80 + x258*x80, x225 - x226 + x227 - x256*x91 + x257*x93 + x258*x93, -x111*x256 + x113*x257 + x113*x258 + x241 - x243 + x245, -x123*x256 + x125*x257 + x125*x258 + x219 + x31*(x114**2 + x177**2), x134*x257 + x134*x258 - x256*x5 + x259 - x261 + x263, x147*x257 + x147*x258 - x256*x7 + x264 - x265 + x266, x159*x257 + x159*x258 - x256*x9 + x267 - x268 + x269, -x132 + x133 + x137 - x271*x6 + x272*x52 + x273*x52, -x1*x271 - x181 + x182 + x183 + x272*x70 + x273*x70, -x10*x271 + x206 - x207 + x208 + x272*x80 + x273*x80, -x228 + x229 + x230 - x271*x91 + x272*x93 + x273*x93, -x111*x271 + x113*x272 + x113*x273 + x246 + x247 - x248, -x123*x271 + x125*x272 + x125*x273 + x259 + x261 - x263, x134*x272 + x134*x273 - x271*x5 + x31*(x136**2 + x9**2), x147*x272 + x147*x273 - x271*x7 + x274 + x276 - x278, x159*x272 + x159*x273 - x271*x9 + x279 + x280 - x281, x138 - x145 + x146 - x283*x6 + x284*x52 + x285*x52, -x1*x283 - x184 + x185 + x187 + x284*x70 + x285*x70, -x10*x283 - x209 + x210 + x211 + x284*x80 + x285*x80, x231 + x232 - x233 - x283*x91 + x284*x93 + x285*x93, -x111*x283 + x113*x284 + x113*x285 - x249 + x250 + x251, -x123*x283 + x125*x284 + x125*x285 + x264 + x265 - x266, x134*x284 + x134*x285 + x274 - x276 + x278 - x283*x5, x147*x284 + x147*x285 - x283*x7 + x31*(x186**2 + x5**2), x159*x284 + x159*x285 - x283*x9 + x286 + x287 - x288, -x154 + x157 + x158 - x290*x6 + x291*x52 + x292*x52, -x1*x290 + x188 - x189 + x190 + x291*x70 + x292*x70, -x10*x290 - x212 + x213 + x214 + x291*x80 + x292*x80, x234 + x235 - x236 - x290*x91 + x291*x93 + x292*x93, -x111*x290 + x113*x291 + x113*x292 + x252 + x253 - x254, -x123*x290 + x125*x291 + x125*x292 - x267 + x268 + x269, x134*x291 + x134*x292 + x279 - x280 + x281 - x290*x5, x147*x291 + x147*x292 + x286 - x287 + x288 - x290*x7, x159*x291 + x159*x292 - x290*x9 + x31*(x155**2 + x7**2)], dtype=np.float64)


def q_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = p0 + x0
    x2 = m0 + x0
    x3 = -o1
    x4 = m1 + x3
    x5 = -o2
    x6 = m2 + x5
    x7 = p1 + x3
    x8 = p2 + x5
    x9 = 1/mpmath.sqrt(x1**2 + x7**2 + x8**2)
    x10 = x9/mpmath.sqrt(x2**2 + x4**2 + x6**2)
    x11 = x10*x2
    x12 = x10*x4
    x13 = x10*x6
    x14 = n0 - p0
    x15 = n1 - p1
    x16 = n2 - p2
    x17 = x9/mpmath.sqrt(x14**2 + x15**2 + x16**2)
    x18 = x14*x17
    x19 = x15*x17
    x20 = x16*x17

    return mpmath.acos(((-x1*x12 + x11*x7)*(-x1*x19 + x18*x7) + (x1*x13 - x11*x8)*(x1*x20 - x18*x8) + (x12*x8 - x13*x7)*(x19*x8 - x20*x7))/(mpmath.sqrt(1 - (x1*x11 + x12*x7 + x13*x8)**2)*mpmath.sqrt(1 - (-x1*x18 - x19*x7 - x20*x8)**2)))


def dq_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = p0 + x0
    x3 = x1**2
    x4 = -o1
    x5 = m1 + x4
    x6 = x5**2
    x7 = -o2
    x8 = m2 + x7
    x9 = x8**2
    x10 = x3 + x6 + x9
    x11 = 1/mpmath.sqrt(x10)
    x12 = x2**2
    x13 = p1 + x4
    x14 = x13**2
    x15 = p2 + x7
    x16 = x15**2
    x17 = x12 + x14 + x16
    x18 = 1/mpmath.sqrt(x17)
    x19 = x11*x18
    x20 = x19*x2
    x21 = x13*x19
    x22 = x15*x19
    x23 = x1*x20 + x21*x5 + x22*x8
    x24 = 1 - x23**2
    x25 = -p0
    x26 = n0 + x25
    x27 = x26**2
    x28 = -p1
    x29 = n1 + x28
    x30 = x29**2
    x31 = -p2
    x32 = n2 + x31
    x33 = x32**2
    x34 = x27 + x30 + x33
    x35 = 1/mpmath.sqrt(x34)
    x36 = x18*x35
    x37 = x26*x36
    x38 = x29*x36
    x39 = x32*x36
    x40 = -x13*x38 - x15*x39 - x2*x37
    x41 = 1 - x40**2
    x42 = x1*x21 - x20*x5
    x43 = x13*x37 - x2*x38
    x44 = -x1*x22 + x20*x8
    x45 = -x15*x37 + x2*x39
    x46 = -x21*x8 + x22*x5
    x47 = -x13*x39 + x15*x38
    x48 = x42*x43 + x44*x45 + x46*x47
    x49 = 1/mpmath.sqrt(1 - x48**2/(x24*x41))
    x50 = x18/x10**(mpmath.mpf(3)/mpmath.mpf(2))
    x51 = x50*(-m0 + o0)
    x52 = x5*x51
    x53 = x51*x8
    x54 = x1*x13
    x55 = -x22
    x56 = x1*x15
    x57 = 1/mpmath.sqrt(x24)
    x58 = 1/mpmath.sqrt(x41)
    x59 = x57*x58
    x60 = 2*x20
    x61 = x1*x2
    x62 = 2*x61
    x63 = 2*x13
    x64 = 2*x15
    x65 = (mpmath.mpf(1)/mpmath.mpf(2))*x48
    x66 = x23*x58*x65/x24**(mpmath.mpf(3)/mpmath.mpf(2))
    x67 = x50*(-m1 + o1)
    x68 = x67*x8
    x69 = x5*x67
    x70 = -x20
    x71 = 2*x21
    x72 = x50*(-m2 + o2)
    x73 = x5*x72
    x74 = x72*x8
    x75 = -x21
    x76 = 2*x22
    x77 = 2*x37
    x78 = x17**(mpmath.mpf(-3)/mpmath.mpf(2))
    x79 = x12*x78
    x80 = x35*x79
    x81 = 2*x26
    x82 = x2*x78
    x83 = x35*x82
    x84 = x13*x83
    x85 = x29*x84
    x86 = x15*x83
    x87 = x32*x86
    x88 = x40*x57*x65/x41**(mpmath.mpf(3)/mpmath.mpf(2))
    x89 = x1*x19
    x90 = 2*x89
    x91 = x11*x79
    x92 = 2*x1
    x93 = x3*x50
    x94 = 2*x2
    x95 = x5*x50
    x96 = x54*x95
    x97 = x50*x8
    x98 = x56*x97
    x99 = x11*x82
    x100 = x5*x99
    x101 = x100*x13
    x102 = x8*x99
    x103 = x102*x15
    x104 = x29*x86
    x105 = x32*x84
    x106 = x13*x26
    x107 = x106*x83
    x108 = -x39
    x109 = x26*x86
    x110 = x56*x95
    x111 = x100*x15
    x112 = x54*x97
    x113 = x13*x8
    x114 = x113*x99
    x115 = x19*x5
    x116 = x54*x99
    x117 = x61*x95
    x118 = x19*x8
    x119 = -x118
    x120 = x61*x97
    x121 = x56*x99
    x122 = 2*x38
    x123 = x14*x78
    x124 = x123*x35
    x125 = 2*x29
    x126 = x15*x78
    x127 = x126*x35
    x128 = 2*x115
    x129 = x11*x123
    x130 = x50*x6
    x131 = x8*x95
    x132 = x131*x15
    x133 = x11*x126
    x134 = x113*x133
    x135 = x106*x127
    x136 = x13*x29
    x137 = x127*x136
    x138 = -x37
    x139 = x131*x2
    x140 = x133*x54
    x141 = -x89
    x142 = x133*x5
    x143 = x13*x142
    x144 = x113*x95
    x145 = 2*x39
    x146 = x16*x78
    x147 = x146*x35
    x148 = 2*x32
    x149 = 2*x118
    x150 = x11*x146
    x151 = 2*x8
    x152 = x50*x9
    x153 = -x38
    x154 = x13*x32
    x155 = -x115
    x156 = o0 + x25
    x157 = x92*x99
    x158 = x156*x78
    x159 = x11*x158
    x160 = x5*x63
    x161 = x133*x151
    x162 = x2*x36
    x163 = 2*x162
    x164 = x18/x34**(mpmath.mpf(3)/mpmath.mpf(2))
    x165 = x164*x27
    x166 = x164*x32
    x167 = x15*x166
    x168 = x81*x83
    x169 = x158*x35
    x170 = 2*x136
    x171 = x127*x148
    x172 = x164*x29
    x173 = x172*x26
    x174 = x15*x173
    x175 = x156*x29
    x176 = x106*x166
    x177 = x15*x36
    x178 = x166*x26
    x179 = x32*x83
    x180 = x127*x26
    x181 = x13*x36
    x182 = -x181
    x183 = o1 + x28
    x184 = x183*x78
    x185 = x11*x184
    x186 = 2*x181
    x187 = x164*x30
    x188 = x184*x35
    x189 = x172*x32
    x190 = x189*x2
    x191 = x183*x29
    x192 = -x177
    x193 = o2 + x31
    x194 = x193*x78
    x195 = x11*x194
    x196 = 2*x177
    x197 = x164*x33
    x198 = x194*x35
    x199 = x193*x29
    x200 = -x162
    x201 = -n0 + p0
    x202 = x172*x201
    x203 = x164*x201
    x204 = x166*x2
    x205 = x15*x26
    x206 = x26*x94
    x207 = x166*x64
    x208 = -n1 + p1
    x209 = x164*x208
    x210 = x172*x208
    x211 = -n2 + p2
    x212 = x164*x211
    x213 = x172*x211

    return np.array([-x49*(x59*(x43*(-x2*x52 + x21 + x51*x54) + x45*(x2*x53 - x51*x56 + x55) + x47*(-x13*x53 + x15*x52)) + x66*(x51*x62 + x52*x63 + x53*x64 + x60)), -x49*(x59*(x43*(-x2*x69 + x54*x67 + x70) + x45*(x2*x68 - x56*x67) + x47*(-x13*x68 + x15*x69 + x22)) + x66*(x62*x67 + x63*x69 + x64*x68 + x71)), -x49*(x59*(x43*(-x2*x73 + x54*x72) + x45*(x2*x74 + x20 - x56*x72) + x47*(-x13*x74 + x15*x73 + x75)) + x66*(x62*x72 + x63*x73 + x64*x74 + x76)), -x49*(x59*(x42*(x107 - x29*x80 + x38) + x43*(x115 + x116 - x117 + x13*x93 - x5*x91 + x75) + x44*(x108 - x109 + x32*x80) + x45*(x119 + x120 - x121 - x15*x93 + x22 + x8*x91) + x46*(x104 - x105) + x47*(x110 + x111 - x112 - x114)) + x66*(2*x101 + 2*x103 - x60 - x90 + x91*x92 + x93*x94 + 2*x96 + 2*x98) + x88*(x77 - x80*x81 - 2*x85 - 2*x87)), -x49*(x59*(x42*(x124*x26 + x138 - x85) + x43*(x1*x129 - x101 - x130*x2 + x141 + x20 + x96) + x44*(x105 - x135) + x45*(-x110 + x114 + x139 - x140) + x46*(-x124*x32 + x137 + x39) + x47*(x118 - x129*x8 + x130*x15 + x143 - x144 + x55)) + x66*(2*x116 + 2*x117 - x128 + 2*x129*x5 + x130*x63 + 2*x132 + 2*x134 - x71) + x88*(-2*x107 + x122 - x124*x125 - x127*x32*x63)), -x49*(x59*(x42*(-x104 + x135) + x43*(-x111 + x112 - x139 + x140) + x44*(-x147*x26 + x37 + x87) + x45*(-x1*x150 + x103 + x152*x2 + x70 + x89 - x98) + x46*(-x127*x154 + x147*x29 + x153) + x47*(-x13*x152 + x132 - x134 + x150*x5 + x155 + x21)) + x66*(2*x120 + 2*x121 + 2*x143 + 2*x144 - x149 + x150*x151 + x152*x64 - x76) + x88*(-2*x109 - 2*x137 + x145 - x147*x148)), -x49*(x59*(x42*(x106*x169 + x13*x165 + x153 - x173*x2 - x175*x83 + x182) + x43*(-x100*x156 + x155 + x159*x54) + x44*(-x15*x165 + x156*x179 - x156*x180 + x177 + x178*x2 + x39) + x45*(x102*x156 + x118 - x159*x56) + x46*(x127*x175 - x154*x169 + x174 - x176) + x47*(-x113*x159 + x142*x156)) + x66*(x156*x157 + x156*x161 + x159*x160 + x90) + x88*(-x106*x125*x164 - x156*x168 - x156*x171 + x163 - x165*x94 - x167*x81 - x169*x170 - x77)), -x49*(x59*(x42*(x106*x172 + x106*x188 + x162 - x187*x2 - x191*x83 + x37) + x43*(-x100*x183 + x185*x54 + x89) + x44*(-x174 + x179*x183 - x180*x183 + x190) + x45*(x102*x183 - x185*x56) + x46*(x108 + x127*x191 - x136*x166 + x15*x187 - x154*x188 + x192) + x47*(-x113*x185 + x119 + x142*x183)) + x66*(x128 + x157*x183 + x160*x185 + x161*x183) + x88*(-x122 - x125*x167 - x168*x183 - x170*x188 - x171*x183 - x173*x94 + x186 - x187*x63)), -x49*(x59*(x42*(x106*x198 + x176 - x190 - x199*x83) + x43*(-x100*x193 + x195*x54) + x44*(x138 - x15*x178 + x179*x193 - x180*x193 + x197*x2 + x200) + x45*(x102*x193 + x141 - x195*x56) + x46*(x127*x199 - x13*x197 + x15*x189 - x154*x198 + x181 + x38) + x47*(-x113*x195 + x115 + x142*x193)) + x66*(x149 + x157*x193 + x160*x195 + x161*x193) + x88*(-x136*x148*x164 - x145 - x168*x193 - x170*x198 - x171*x193 - x178*x94 + x196 - x197*x64)), -x49*(x59*(x42*(x106*x203 + x181 - x2*x202) + x44*(x192 + x201*x204 - x203*x205) + x46*(x15*x202 - x154*x203)) + x88*(-x163 - x170*x203 - x201*x207 - x203*x206)), -x49*(x59*(x42*(x106*x209 - x2*x210 + x200) + x44*(x204*x208 - x205*x209) + x46*(x15*x210 - x154*x209 + x177)) + x88*(-x170*x209 - x186 - x206*x209 - x207*x208)), -x49*(x59*(x42*(x106*x212 - x2*x213) + x44*(x162 + x204*x211 - x205*x212) + x46*(x15*x213 - x154*x212 + x182)) + x88*(-x170*x212 - x196 - x206*x212 - x207*x211))], dtype=np.float64)


def d2q_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o2
    x1 = p2 + x0
    x2 = -p1
    x3 = n1 + x2
    x4 = -p0
    x5 = n0 + x4
    x6 = x5**2
    x7 = x3**2
    x8 = -p2
    x9 = n2 + x8
    x10 = x9**2
    x11 = x10 + x6 + x7
    x12 = 1/mpmath.sqrt(x11)
    x13 = -o0
    x14 = p0 + x13
    x15 = x14**2
    x16 = -o1
    x17 = p1 + x16
    x18 = x17**2
    x19 = x1**2
    x20 = x15 + x18 + x19
    x21 = 1/mpmath.sqrt(x20)
    x22 = x12*x21
    x23 = x22*x3
    x24 = x22*x9
    x25 = x1*x23 - x17*x24
    x26 = -m0 + o0
    x27 = m1 + x16
    x28 = m0 + x13
    x29 = x28**2
    x30 = x27**2
    x31 = m2 + x0
    x32 = x31**2
    x33 = x29 + x30 + x32
    x34 = x33**(mpmath.mpf(-3)/mpmath.mpf(2))
    x35 = x21*x34
    x36 = x27*x35
    x37 = x1*x36
    x38 = x17*x35
    x39 = x31*x38
    x40 = x26*x37 - x26*x39
    x41 = x25*x40
    x42 = x22*x5
    x43 = -x14*x23 + x17*x42
    x44 = 1/mpmath.sqrt(x33)
    x45 = x21*x44
    x46 = x17*x45
    x47 = x28*x38
    x48 = x14*x36
    x49 = x26*x47 - x26*x48 + x46
    x50 = x43*x49
    x51 = -x1*x42 + x14*x24
    x52 = x1*x45
    x53 = -x52
    x54 = x14*x35
    x55 = x31*x54
    x56 = x1*x35
    x57 = x28*x56
    x58 = x26*x55 - x26*x57 + x53
    x59 = x51*x58
    x60 = x41 + x50 + x59
    x61 = x14*x45
    x62 = x27*x46 + x28*x61 + x31*x52
    x63 = x62**2
    x64 = 1 - x63
    x65 = 1/mpmath.sqrt(x64)
    x66 = -x1*x24 - x14*x42 - x17*x23
    x67 = x66**2
    x68 = 1 - x67
    x69 = 1/mpmath.sqrt(x68)
    x70 = x65*x69
    x71 = 2*x61
    x72 = x26*x54
    x73 = x28*x72
    x74 = x26*x36
    x75 = x17*x74
    x76 = x26*x56
    x77 = 2*x76
    x78 = x31*x77 + x71 + 2*x73 + 2*x75
    x79 = x62*x78
    x80 = x64**(mpmath.mpf(-3)/mpmath.mpf(2))
    x81 = x69*x80
    x82 = x79*x81
    x83 = -x27*x61 + x28*x46
    x84 = -x28*x52 + x31*x61
    x85 = x27*x52 - x31*x46
    x86 = x25*x85 + x43*x83 + x51*x84
    x87 = (mpmath.mpf(1)/mpmath.mpf(2))*x86
    x88 = x60*x70 + x82*x87
    x89 = x86**2
    x90 = x64**(-1)
    x91 = x68**(-1)
    x92 = x90*x91
    x93 = -x89*x92 + 1
    x94 = x93**(mpmath.mpf(-3)/mpmath.mpf(2))
    x95 = (mpmath.mpf(1)/mpmath.mpf(2))*x89
    x96 = x91*x95/x64**2
    x97 = x87*x92
    x98 = x94*(x79*x96 + x97*(2*x41 + 2*x50 + 2*x59))
    x99 = 1/mpmath.sqrt(x93)
    x100 = (mpmath.mpf(3)/mpmath.mpf(4))*x86
    x101 = x100*x63*x69/x64**(mpmath.mpf(5)/mpmath.mpf(2))
    x102 = x81*x87
    x103 = x102*(x31*x76 + x61 + x73 + x75)
    x104 = 3*m0
    x105 = 3*o0
    x106 = x21/x33**(mpmath.mpf(5)/mpmath.mpf(2))
    x107 = x106*(-x104 + x105)
    x108 = x107*x26
    x109 = x108*x27
    x110 = x108*x31
    x111 = -x37
    x112 = x111 + x39
    x113 = x26*x38
    x114 = 2*x113
    x115 = x17*x28
    x116 = -x47
    x117 = x116 + x48
    x118 = -x77
    x119 = x1*x28
    x120 = -x55
    x121 = x120 + x57
    x122 = 2*x14
    x123 = x122*x28
    x124 = 2*x17
    x125 = 2*x1
    x126 = x28*x54
    x127 = 2*x126
    x128 = x17*x36
    x129 = 2*x128
    x130 = x31*x56
    x131 = 2*x130
    x132 = -x127 - x129 - x131
    x133 = x62*x81
    x134 = x133*x87
    x135 = -m1 + o1
    x136 = x135*x55 - x135*x57
    x137 = x136*x51
    x138 = x135*x37 - x135*x39 + x52
    x139 = x138*x25
    x140 = -x61
    x141 = x135*x47 - x135*x48 + x140
    x142 = x141*x43
    x143 = x137 + x139 + x142
    x144 = 2*x46
    x145 = x135*x54
    x146 = 2*x145
    x147 = x135*x56
    x148 = x147*x31
    x149 = x129*x135 + x144 + x146*x28 + 2*x148
    x150 = x133*x149
    x151 = x143*x70 + x150*x87
    x152 = x107*x135
    x153 = x152*x27
    x154 = x152*x31
    x155 = -x147
    x156 = x135*x38
    x157 = -x72
    x158 = x156 + x157
    x159 = x114 + x146
    x160 = (mpmath.mpf(1)/mpmath.mpf(2))*x60
    x161 = (mpmath.mpf(1)/mpmath.mpf(2))*x82
    x162 = x101*x78
    x163 = x143*x161 + x149*x162 + x150*x160
    x164 = -m2 + o2
    x165 = x164*x47 - x164*x48
    x166 = x165*x43
    x167 = x164*x55 - x164*x57 + x61
    x168 = x167*x51
    x169 = -x46
    x170 = x164*x37 - x164*x39 + x169
    x171 = x170*x25
    x172 = x166 + x168 + x171
    x173 = 2*x52
    x174 = x164*x54
    x175 = 2*x174
    x176 = x164*x56
    x177 = x176*x31
    x178 = x129*x164 + x173 + x175*x28 + 2*x177
    x179 = x133*x178
    x180 = x172*x70 + x179*x87
    x181 = x164*x38
    x182 = x107*x164
    x183 = x182*x27
    x184 = -x113
    x185 = x182*x31
    x186 = -x176
    x187 = x186 + x72
    x188 = x175 + x77
    x189 = x160*x179 + x161*x172 + x162*x178
    x190 = 2*x42
    x191 = x20**(mpmath.mpf(-3)/mpmath.mpf(2))
    x192 = x12*x191
    x193 = x15*x192
    x194 = x193*x5
    x195 = x192*x3
    x196 = x14*x195
    x197 = x17*x196
    x198 = x192*x9
    x199 = x14*x198
    x200 = x1*x199
    x201 = x190 - 2*x194 - 2*x197 - 2*x200
    x202 = x201*x66
    x203 = x68**(mpmath.mpf(-3)/mpmath.mpf(2))
    x204 = x203*x65
    x205 = x202*x204
    x206 = 2*x45
    x207 = x206*x28
    x208 = x191*x44
    x209 = x15*x208
    x210 = 2*x209
    x211 = x29*x35
    x212 = x14*x211
    x213 = x31*x57
    x214 = x14*x208
    x215 = x17*x214
    x216 = 2*x215
    x217 = x1*x214
    x218 = 2*x217
    x219 = x129*x28 - x207 + x210*x28 + 2*x212 + 2*x213 + x216*x27 + x218*x31 - x71
    x220 = x133*x219
    x221 = x1*x196
    x222 = x17*x192
    x223 = x222*x9
    x224 = x14*x223
    x225 = x221 - x224
    x226 = x225*x85
    x227 = x222*x5
    x228 = x14*x227
    x229 = -x193*x3 + x228 + x23
    x230 = x229*x83
    x231 = -x24
    x232 = x192*x5
    x233 = x1*x232
    x234 = x14*x233
    x235 = -x234
    x236 = x193*x9 + x231 + x235
    x237 = x236*x84
    x238 = x28*x37
    x239 = x217*x27
    x240 = x31*x47
    x241 = x215*x31
    x242 = x238 + x239 - x240 - x241
    x243 = x242*x25
    x244 = x27*x45
    x245 = x28*x48
    x246 = x215*x28
    x247 = x169 + x246
    x248 = x17*x211 - x209*x27 + x244 - x245 + x247
    x249 = x248*x43
    x250 = x217*x28
    x251 = x31*x45
    x252 = -x251
    x253 = x28*x55
    x254 = x252 + x253
    x255 = -x1*x211 + x209*x31 - x250 + x254 + x52
    x256 = x255*x51
    x257 = x226 + x230 + x237 + x243 + x249 + x256
    x258 = x205*x87 + x220*x87 + x257*x70
    x259 = 2*m0
    x260 = 2*o0
    x261 = -x260
    x262 = x259 + x261
    x263 = x107*x29
    x264 = x27*x28
    x265 = x107*x264
    x266 = x14*x265
    x267 = -x48
    x268 = x191*x34
    x269 = x15*x268
    x270 = x26*x269
    x271 = x14*x268
    x272 = x26*x271
    x273 = x115*x272
    x274 = x184 + x215 + x267 - x27*x270 + x273 + x74
    x275 = x1*x265
    x276 = x28*x31
    x277 = x107*x276
    x278 = x17*x277
    x279 = -x39
    x280 = x27*x272
    x281 = x1*x280
    x282 = x17*x31
    x283 = x272*x282
    x284 = x279 + x281 - x283 + x37
    x285 = -x259 + x260
    x286 = x14*x277
    x287 = x26*x35
    x288 = x287*x31
    x289 = -x288
    x290 = -x217
    x291 = x119*x272
    x292 = x270*x31 + x289 + x290 - x291 + x55 + x76
    x293 = x225*x40 + x229*x49 + x236*x58
    x294 = 4*m0
    x295 = 4*o0
    x296 = -x295
    x297 = x17*x265
    x298 = x1*x277
    x299 = x28*x287
    x300 = 2*x299
    x301 = 2*x28
    x302 = x17*x280
    x303 = x272*x31
    x304 = x1*x303
    x305 = -x206
    x306 = x131 + x305
    x307 = x129 + x210 + x270*x301 - x300 + 2*x302 + 2*x304 + x306 - 2*x72
    x308 = x203*x80
    x309 = x202*x308
    x310 = (mpmath.mpf(1)/mpmath.mpf(4))*x86
    x311 = x310*x79
    x312 = x160*x205 + x160*x220 + x161*x257 + x162*x219 + x309*x311
    x313 = 2*x23
    x314 = x18*x192
    x315 = x3*x314
    x316 = x1*x223
    x317 = -2*x228 + x313 - 2*x315 - 2*x316
    x318 = x204*x66
    x319 = x317*x318
    x320 = x206*x27
    x321 = x18*x208
    x322 = 2*x321
    x323 = x30*x35
    x324 = x17*x323
    x325 = x31*x37
    x326 = x17*x208
    x327 = x1*x326
    x328 = x31*x327
    x329 = -x144 + 2*x245 + 2*x246 + x27*x322 - x320 + 2*x324 + 2*x325 + 2*x328
    x330 = x133*x329
    x331 = x1*x227
    x332 = x224 - x331
    x333 = x332*x84
    x334 = x1*x195
    x335 = x17*x334
    x336 = x24 - x314*x9 + x335
    x337 = x336*x85
    x338 = -x42
    x339 = -x197
    x340 = x314*x5 + x338 + x339
    x341 = x340*x83
    x342 = x31*x48
    x343 = x28*x327
    x344 = -x238 + x241 + x342 - x343
    x345 = x344*x51
    x346 = x215*x27
    x347 = x28*x45
    x348 = -x347
    x349 = x128*x28 + x348
    x350 = -x14*x323 + x28*x321 - x346 + x349 + x61
    x351 = x350*x43
    x352 = x128*x31
    x353 = x27*x327
    x354 = x353 + x53
    x355 = x1*x323 + x251 - x31*x321 - x352 + x354
    x356 = x25*x355
    x357 = x333 + x337 + x341 + x345 + x351 + x356
    x358 = x319*x87 + x330*x87 + x357*x70
    x359 = x107*x30
    x360 = x18*x268
    x361 = x26*x360
    x362 = -x45
    x363 = -x299 + x362
    x364 = x128 + x321
    x365 = x28*x361 - x302 + x363 + x364 + x72
    x366 = x27*x31
    x367 = x107*x366
    x368 = x17*x367
    x369 = x26*x268
    x370 = x1*x27
    x371 = x17*x370
    x372 = x369*x371
    x373 = x288 - x31*x361 + x372 - x76
    x374 = x14*x367
    x375 = -x327
    x376 = x1*x369
    x377 = x115*x376
    x378 = x111 + x283 + x375 - x377
    x379 = x332*x58 + x336*x40 + x340*x49
    x380 = x1*x367
    x381 = 2*x74
    x382 = 2*x48
    x383 = 2*x27
    x384 = x282*x376
    x385 = -x114 + x216 + 2*x273 + x361*x383 - x381 + x382 + 2*x384
    x386 = x308*x66
    x387 = x311*x386
    x388 = x160*x319 + x160*x330 + x161*x357 + x162*x329 + x317*x387
    x389 = 2*x24
    x390 = x19*x192
    x391 = x390*x9
    x392 = -2*x234 - 2*x335 + x389 - 2*x391
    x393 = x318*x392
    x394 = x206*x31
    x395 = x19*x208
    x396 = 2*x395
    x397 = x32*x35
    x398 = x1*x397
    x399 = x129*x31 - x173 + 2*x250 + 2*x253 + x31*x396 + 2*x353 - x394 + 2*x398
    x400 = x133*x399
    x401 = -x221 + x331
    x402 = x401*x83
    x403 = x200 - x390*x5 + x42
    x404 = x403*x84
    x405 = -x23
    x406 = -x316
    x407 = x3*x390 + x405 + x406
    x408 = x407*x85
    x409 = -x239 + x240 - x342 + x343
    x410 = x409*x43
    x411 = x140 + x217*x31
    x412 = x14*x397 - x213 - x28*x395 + x347 + x411
    x413 = x412*x51
    x414 = -x244
    x415 = x325 + x414
    x416 = -x17*x397 + x27*x395 - x328 + x415 + x46
    x417 = x25*x416
    x418 = x402 + x404 + x408 + x410 + x413 + x417
    x419 = x393*x87 + x400*x87 + x418*x70
    x420 = -x281 + x327 + x377 + x39
    x421 = x107*x32
    x422 = -x74
    x423 = x19*x268
    x424 = x26*x423
    x425 = x113 + x27*x424 - x384 + x422
    x426 = x299 + x45
    x427 = -x130 - x395
    x428 = x157 - x28*x424 + x304 + x426 + x427
    x429 = x40*x407 + x401*x49 + x403*x58
    x430 = 2*x55
    x431 = 2*x288
    x432 = 2*x31
    x433 = x118 + x218 + 2*x291 + 2*x372 + x424*x432 + x430 - x431
    x434 = x160*x393 + x160*x400 + x161*x418 + x162*x399 + x387*x392
    x435 = o0 + x4
    x436 = x214*x435
    x437 = 2*x436
    x438 = x326*x435
    x439 = 2*x438
    x440 = x1*x208
    x441 = x435*x440
    x442 = 2*x441
    x443 = x207 + x27*x439 + x28*x437 + x31*x442
    x444 = x133*x443
    x445 = x14*x22
    x446 = 2*x445
    x447 = x11**(mpmath.mpf(-3)/mpmath.mpf(2))
    x448 = x21*x447
    x449 = x448*x6
    x450 = 2*x449
    x451 = x448*x5
    x452 = x3*x451
    x453 = x17*x452
    x454 = x451*x9
    x455 = x1*x454
    x456 = x14*x232
    x457 = 2*x456
    x458 = x17*x195
    x459 = 2*x458
    x460 = x1*x198
    x461 = 2*x460
    x462 = -x14*x450 - x190 - x435*x457 - x435*x459 - x435*x461 + x446 - 2*x453 - 2*x455
    x463 = x318*x462
    x464 = x27*x441 - x31*x438
    x465 = x25*x464
    x466 = x251 - x28*x441 + x31*x436
    x467 = x466*x51
    x468 = -x27*x436 + x28*x438 + x414
    x469 = x43*x468
    x470 = x1*x452
    x471 = x17*x454
    x472 = -x223*x435 + x334*x435 + x470 - x471
    x473 = x472*x85
    x474 = x1*x22
    x475 = x14*x454
    x476 = -x1*x449 + x199*x435 - x233*x435 + x24 + x474 + x475
    x477 = x476*x84
    x478 = x17*x22
    x479 = -x478
    x480 = x14*x452
    x481 = x405 - x480
    x482 = x17*x449 - x196*x435 + x227*x435 + x479 + x481
    x483 = x482*x83
    x484 = x465 + x467 + x469 + x473 + x477 + x483
    x485 = x444*x87 + x463*x87 + x484*x70
    x486 = x369*x435
    x487 = -x441
    x488 = x272*x301
    x489 = x124*x27
    x490 = x376*x432
    x491 = x134*(x206 + x300 + x435*x488 + x435*x490 + x437 + x486*x489) + x160*x444 + x160*x463 + x161*x484 + x162*x443 + x387*x462 + x70*(x25*(-x282*x486 + x370*x486) + x40*x472 + x43*(x115*x486 - x280*x435 + x422 + x438) + x476*x58 + x482*x49 + x51*(-x119*x486 + x288 + x303*x435 + x487))
    x492 = o1 + x2
    x493 = x214*x492
    x494 = 2*x493
    x495 = x326*x492
    x496 = 2*x495
    x497 = x440*x492
    x498 = 2*x497
    x499 = x27*x496 + x28*x494 + x31*x498 + x320
    x500 = x133*x499
    x501 = 2*x478
    x502 = x448*x7
    x503 = 2*x502
    x504 = x3*x448
    x505 = x504*x9
    x506 = x1*x505
    x507 = -x17*x503 - x313 - x457*x492 - x459*x492 - x461*x492 - 2*x480 + x501 - 2*x506
    x508 = x318*x507
    x509 = -x28*x497 + x31*x493
    x510 = x509*x51
    x511 = -x27*x493 + x28*x495 + x347
    x512 = x43*x511
    x513 = x252 + x27*x497 - x31*x495
    x514 = x25*x513
    x515 = x14*x505
    x516 = x199*x492 - x233*x492 - x470 + x515
    x517 = x516*x84
    x518 = -x14*x502 - x196*x492 + x227*x492 + x42 + x445 + x453
    x519 = x518*x83
    x520 = -x474
    x521 = x17*x505
    x522 = x231 - x521
    x523 = x1*x502 - x223*x492 + x334*x492 + x520 + x522
    x524 = x523*x85
    x525 = x510 + x512 + x514 + x517 + x519 + x524
    x526 = x500*x87 + x508*x87 + x525*x70
    x527 = -x497
    x528 = x369*x492
    x529 = x134*(x381 + x488*x492 + x489*x528 + x490*x492 + x494) + x160*x500 + x160*x508 + x161*x525 + x162*x499 + x387*x507 + x70*(x25*(-x282*x528 + x289 + x370*x528) + x40*x523 + x43*(x115*x528 - x280*x492 + x426 + x495) + x49*x518 + x51*(-x119*x528 + x303*x492 + x527) + x516*x58)
    x530 = o2 + x8
    x531 = x214*x530
    x532 = 2*x531
    x533 = x326*x530
    x534 = 2*x533
    x535 = x440*x530
    x536 = 2*x535
    x537 = x27*x534 + x28*x532 + x31*x536 + x394
    x538 = x133*x537
    x539 = 2*x474
    x540 = x10*x448
    x541 = 2*x540
    x542 = -x1*x541 - x389 - x457*x530 - x459*x530 - x461*x530 - 2*x475 - 2*x521 + x539
    x543 = x318*x542
    x544 = -x27*x531 + x28*x533
    x545 = x43*x544
    x546 = x244 + x27*x535 - x31*x533
    x547 = x25*x546
    x548 = -x28*x535 + x31*x531 + x348
    x549 = x51*x548
    x550 = -x196*x530 + x227*x530 + x471 - x515
    x551 = x550*x83
    x552 = -x17*x540 - x223*x530 + x23 + x334*x530 + x478 + x506
    x553 = x552*x85
    x554 = -x445
    x555 = x338 - x455
    x556 = x14*x540 + x199*x530 - x233*x530 + x554 + x555
    x557 = x556*x84
    x558 = x545 + x547 + x549 + x551 + x553 + x557
    x559 = x538*x87 + x543*x87 + x558*x70
    x560 = x369*x530
    x561 = -x535
    x562 = x134*(x431 + x488*x530 + x489*x560 + x490*x530 + x532) + x160*x538 + x160*x543 + x161*x558 + x162*x537 + x387*x542 + x70*(x25*(-x282*x560 + x370*x560 + x74) + x40*x552 + x43*(x115*x560 - x280*x530 + x533) + x49*x550 + x51*(-x119*x560 + x303*x530 + x363 + x561) + x556*x58)
    x563 = -n0 + p0
    x564 = x504*x563
    x565 = x448*x9
    x566 = x563*x565
    x567 = x1*x564 - x17*x566
    x568 = x567*x85
    x569 = x451*x563
    x570 = -x14*x564 + x17*x569 + x478
    x571 = x570*x83
    x572 = -x1*x569 + x14*x566 + x520
    x573 = x572*x84
    x574 = x568 + x571 + x573
    x575 = 2*x569
    x576 = 2*x564
    x577 = 2*x566
    x578 = -x1*x577 - x14*x575 - x17*x576 - x446
    x579 = x318*x578
    x580 = x574*x70 + x579*x87
    x581 = -x99*(x160*x579 + x161*x574 + x387*x578 + x70*(x40*x567 + x49*x570 + x572*x58))
    x582 = -n1 + p1
    x583 = x565*x582
    x584 = x451*x582
    x585 = -x1*x584 + x14*x583
    x586 = x585*x84
    x587 = x504*x582
    x588 = x1*x587 - x17*x583 + x474
    x589 = x588*x85
    x590 = -x14*x587 + x17*x584 + x554
    x591 = x590*x83
    x592 = x586 + x589 + x591
    x593 = 2*x584
    x594 = 2*x587
    x595 = 2*x583
    x596 = -x1*x595 - x14*x593 - x17*x594 - x501
    x597 = x318*x596
    x598 = x592*x70 + x597*x87
    x599 = -x99*(x160*x597 + x161*x592 + x387*x596 + x70*(x40*x588 + x49*x590 + x58*x585))
    x600 = -n2 + p2
    x601 = x451*x600
    x602 = x504*x600
    x603 = -x14*x602 + x17*x601
    x604 = x603*x83
    x605 = x565*x600
    x606 = -x1*x601 + x14*x605 + x445
    x607 = x606*x84
    x608 = x1*x602 - x17*x605 + x479
    x609 = x608*x85
    x610 = x604 + x607 + x609
    x611 = 2*x601
    x612 = 2*x602
    x613 = 2*x605
    x614 = -x1*x613 - x14*x611 - x17*x612 - x539
    x615 = x318*x614
    x616 = x610*x70 + x615*x87
    x617 = -x99*(x160*x615 + x161*x610 + x387*x614 + x70*(x40*x608 + x49*x603 + x58*x606))
    x618 = x62*x96
    x619 = x94*(x149*x618 + x97*(2*x137 + 2*x139 + 2*x142))
    x620 = 3*m1
    x621 = 3*o1
    x622 = x106*(-x620 + x621)
    x623 = x26*x622
    x624 = x14*x623
    x625 = x125*x31
    x626 = x102*(x128*x135 + x145*x28 + x148 + x46)
    x627 = x135*x622
    x628 = x14*x627
    x629 = -x146
    x630 = 2*x147
    x631 = x164*x622
    x632 = x14*x631
    x633 = -x174
    x634 = -x156
    x635 = x176 + x634
    x636 = 2*x181
    x637 = x630 + x636
    x638 = (mpmath.mpf(1)/mpmath.mpf(2))*x150
    x639 = (mpmath.mpf(1)/mpmath.mpf(2))*x143
    x640 = x101*x149
    x641 = x172*x638 + x178*x640 + x179*x639
    x642 = x29*x622
    x643 = x264*x622
    x644 = x135*x269
    x645 = x135*x271
    x646 = x115*x645
    x647 = x135*x36
    x648 = x45 + x647
    x649 = -x126 - x209
    x650 = -x27*x644 + x634 + x646 + x648 + x649
    x651 = x1*x643
    x652 = x276*x622
    x653 = x17*x652
    x654 = x370*x645
    x655 = x282*x645
    x656 = x217 + x57 + x654 - x655
    x657 = x135*x35
    x658 = x31*x657
    x659 = -x658
    x660 = x119*x645
    x661 = x147 + x31*x644 + x659 - x660
    x662 = x136*x236 + x138*x225 + x141*x229
    x663 = 2*x47
    x664 = x28*x657
    x665 = 2*x664
    x666 = x27*x645
    x667 = x31*x645
    x668 = x124*x666 + x125*x667 + x216 + x301*x644 + x629 + x663 - x665
    x669 = x310*x62
    x670 = x149*x669
    x671 = x205*x639 + x219*x640 + x220*x639 + x257*x638 + x309*x670
    x672 = 2*m1
    x673 = 2*o1
    x674 = -x672 + x673
    x675 = x30*x622
    x676 = -x664
    x677 = -x215
    x678 = x135*x360
    x679 = x145 - x17*x666 + x28*x678 + x47 + x676 + x677
    x680 = -x673
    x681 = x672 + x680
    x682 = x366*x622
    x683 = x135*x268
    x684 = x371*x683
    x685 = x155 + x279 - x31*x678 + x327 + x658 + x684
    x686 = x14*x682
    x687 = -x57
    x688 = x1*x683
    x689 = x115*x688
    x690 = x55 + x655 + x687 - x689
    x691 = x136*x332 + x138*x336 + x141*x340
    x692 = 4*m1
    x693 = 4*o1
    x694 = -x693
    x695 = 2*x647
    x696 = x125*x282
    x697 = x127 - 2*x156 + x306 + x322 + x383*x678 + 2*x646 + x683*x696 - x695
    x698 = x386*x670
    x699 = x317*x698 + x319*x639 + x329*x640 + x330*x639 + x357*x638
    x700 = x120 + x290 - x654 + x689
    x701 = x32*x622
    x702 = x135*x423
    x703 = x362 - x647
    x704 = x130 + x395
    x705 = x156 + x27*x702 - x282*x688 + x703 + x704
    x706 = x1*x667 - x145 - x28*x702 + x664
    x707 = x136*x403 + x138*x407 + x141*x401
    x708 = 2*x658
    x709 = 2*x39
    x710 = 2*x327
    x711 = x432*x702 - x630 + 2*x660 + 2*x684 - x708 + x709 + x710
    x712 = x392*x698 + x393*x639 + x399*x640 + x400*x639 + x418*x638
    x713 = x435*x683
    x714 = -x436
    x715 = x301*x645
    x716 = x134*(x435*x715 + x439 + x489*x713 + x625*x713 + x665) + x443*x640 + x444*x639 + x462*x698 + x463*x639 + x484*x638 + x70*(x136*x476 + x138*x472 + x141*x482 + x25*(-x282*x713 + x370*x713 + x441) + x43*(x115*x713 - x435*x666 + x703 + x714) + x51*(-x119*x713 + x435*x667 + x658))
    x717 = x492*x683
    x718 = -x493
    x719 = x134*(x206 + x489*x717 + x492*x715 + x496 + x625*x717 + x695) + x499*x640 + x500*x639 + x507*x698 + x508*x639 + x525*x638 + x70*(x136*x516 + x138*x523 + x141*x518 + x25*(-x282*x717 + x370*x717 + x497 + x659) + x43*(x115*x717 - x492*x666 + x664 + x718) + x51*(-x119*x717 + x492*x667))
    x720 = -x531
    x721 = x530*x683
    x722 = x134*(x489*x721 + x530*x715 + x534 + x625*x721 + x708) + x537*x640 + x538*x639 + x542*x698 + x543*x639 + x558*x638 + x70*(x136*x556 + x138*x552 + x141*x550 + x25*(-x282*x721 + x370*x721 + x535 + x648) + x43*(x115*x721 - x530*x666 + x720) + x51*(-x119*x721 + x530*x667 + x676))
    x723 = -x99*(x574*x638 + x578*x698 + x579*x639 + x70*(x136*x572 + x138*x567 + x141*x570))
    x724 = -x99*(x592*x638 + x596*x698 + x597*x639 + x70*(x136*x585 + x138*x588 + x141*x590))
    x725 = -x99*(x610*x638 + x614*x698 + x615*x639 + x70*(x136*x606 + x138*x608 + x141*x603))
    x726 = x94*(x178*x618 + x97*(2*x166 + 2*x168 + 2*x171))
    x727 = 3*m2
    x728 = 3*o2
    x729 = x106*(-x727 + x728)
    x730 = x26*x729
    x731 = x14*x730
    x732 = x102*(x128*x164 + x174*x28 + x177 + x52)
    x733 = x135*x729
    x734 = x14*x733
    x735 = x164*x729
    x736 = x14*x735
    x737 = -x636
    x738 = x29*x729
    x739 = x264*x729
    x740 = x164*x36
    x741 = x164*x269
    x742 = x164*x271
    x743 = x115*x742
    x744 = -x181 - x27*x741 + x740 + x743
    x745 = x1*x739
    x746 = x276*x729
    x747 = x17*x746
    x748 = x370*x742
    x749 = x282*x742
    x750 = x116 + x677 + x748 - x749
    x751 = x119*x742
    x752 = x164*x35
    x753 = x31*x752
    x754 = x362 - x753
    x755 = x126 + x209
    x756 = x176 + x31*x741 - x751 + x754 + x755
    x757 = x165*x229 + x167*x236 + x170*x225
    x758 = x28*x752
    x759 = 2*x758
    x760 = 2*x57
    x761 = x27*x742
    x762 = x31*x742
    x763 = x124*x761 + x125*x762 - x175 + x218 + x301*x741 - x759 + x760
    x764 = (mpmath.mpf(1)/mpmath.mpf(2))*x172
    x765 = (mpmath.mpf(1)/mpmath.mpf(2))*x179
    x766 = x101*x178
    x767 = x178*x669
    x768 = x205*x764 + x219*x766 + x220*x764 + x257*x765 + x309*x767
    x769 = x30*x729
    x770 = -x758
    x771 = x164*x360
    x772 = -x17*x761 + x174 + x28*x771 + x770
    x773 = x366*x729
    x774 = x164*x268
    x775 = x371*x774
    x776 = x45 + x753
    x777 = -x128 - x321
    x778 = x186 - x31*x771 + x775 + x776 + x777
    x779 = x14*x773
    x780 = x1*x774
    x781 = x115*x780
    x782 = x215 + x48 + x749 - x781
    x783 = x165*x340 + x167*x332 + x170*x336
    x784 = 2*x37
    x785 = 2*x740
    x786 = x383*x771 + x696*x774 + x710 + x737 + 2*x743 + x784 - x785
    x787 = x386*x767
    x788 = x317*x787 + x319*x764 + x329*x766 + x330*x764 + x357*x765
    x789 = x267 + x47 - x748 + x781
    x790 = 2*m2
    x791 = 2*o2
    x792 = -x790 + x791
    x793 = x32*x729
    x794 = -x740
    x795 = x164*x423
    x796 = x181 + x27*x795 - x282*x780 + x37 + x375 + x794
    x797 = -x791
    x798 = x790 + x797
    x799 = x1*x762 + x217 - x28*x795 + x633 + x687 + x758
    x800 = x165*x401 + x167*x403 + x170*x407
    x801 = 4*m2
    x802 = 4*o2
    x803 = -x802
    x804 = 2*x753
    x805 = x127 + x129 - 2*x176 + x305 + x396 + x432*x795 + 2*x751 + 2*x775 - x804
    x806 = x392*x787 + x393*x764 + x399*x766 + x400*x764 + x418*x765
    x807 = x435*x774
    x808 = -x438
    x809 = x301*x742
    x810 = x134*(x435*x809 + x442 + x489*x807 + x625*x807 + x759) + x443*x766 + x444*x764 + x462*x787 + x463*x764 + x484*x765 + x70*(x165*x482 + x167*x476 + x170*x472 + x25*(-x282*x807 + x370*x807 + x808) + x43*(x115*x807 - x435*x761 + x794) + x51*(-x119*x807 + x435*x762 + x436 + x776))
    x811 = x492*x774
    x812 = -x495
    x813 = x134*(x489*x811 + x492*x809 + x498 + x625*x811 + x785) + x499*x766 + x500*x764 + x507*x787 + x508*x764 + x525*x765 + x70*(x165*x518 + x167*x516 + x170*x523 + x25*(-x282*x811 + x370*x811 + x754 + x812) + x43*(x115*x811 - x492*x761 + x758) + x51*(-x119*x811 + x492*x762 + x493))
    x814 = x530*x774
    x815 = -x533
    x816 = x134*(x206 + x489*x814 + x530*x809 + x536 + x625*x814 + x804) + x537*x766 + x538*x764 + x542*x787 + x543*x764 + x558*x765 + x70*(x165*x550 + x167*x556 + x170*x552 + x25*(-x282*x814 + x370*x814 + x740 + x815) + x43*(x115*x814 - x530*x761) + x51*(-x119*x814 + x530*x762 + x531 + x770))
    x817 = -x99*(x574*x765 + x578*x787 + x579*x764 + x70*(x165*x570 + x167*x572 + x170*x567))
    x818 = -x99*(x592*x765 + x596*x787 + x597*x764 + x70*(x165*x590 + x167*x585 + x170*x588))
    x819 = -x99*(x610*x765 + x614*x787 + x615*x764 + x70*(x165*x603 + x167*x606 + x170*x608))
    x820 = x90*x95/x68**2
    x821 = x94*(x202*x820 + x219*x618 + x97*(2*x226 + 2*x230 + 2*x237 + 2*x243 + 2*x249 + 2*x256))
    x822 = -x105
    x823 = x106*(x104 + x822)
    x824 = x26*x823
    x825 = x14*x824
    x826 = -x760
    x827 = x102*(x209*x28 + x212 + x213 + x346 + x349 + x411)
    x828 = x135*x823
    x829 = x14*x828
    x830 = x164*x823
    x831 = x14*x830
    x832 = x100*x65*x67/x68**(mpmath.mpf(5)/mpmath.mpf(2))
    x833 = x204*x87
    x834 = x833*(-x194 - x200 + x339 + x42)
    x835 = 4*p0
    x836 = x296 + x835
    x837 = x20**(mpmath.mpf(-5)/mpmath.mpf(2))
    x838 = 3*p0
    x839 = x837*(x822 + x838)
    x840 = x15*x839
    x841 = x12*x5
    x842 = 2*x841
    x843 = x12*x3
    x844 = x17*x843
    x845 = x122*x839
    x846 = x12*x9
    x847 = x1*x839
    x848 = x846*x847
    x849 = x457 + x459 + x461
    x850 = x318*x87
    x851 = x62*x87
    x852 = -x835
    x853 = x295 + x852
    x854 = x208*x28
    x855 = x268*x29
    x856 = x29*x823
    x857 = x44*x840
    x858 = x264*x823
    x859 = x276*x823
    x860 = x27*x44
    x861 = x17*x860
    x862 = x44*x847
    x863 = x271*x276
    x864 = 4*x1*x863
    x865 = 4*x45
    x866 = x264*x271
    x867 = x214*x28
    x868 = 2*x867
    x869 = x27*x326
    x870 = 2*x869
    x871 = x31*x440
    x872 = 2*x871
    x873 = -x868 - x870 - x872
    x874 = x132 + 4*x17*x866 + x865 + x873
    x875 = x14*x839
    x876 = x1*x875
    x877 = x843*x876
    x878 = x17*x875
    x879 = x846*x878
    x880 = -x334
    x881 = x223 + x880
    x882 = 2*p0
    x883 = x261 + x882
    x884 = x17*x841
    x885 = -x227
    x886 = x196 + x885
    x887 = -x882
    x888 = x260 + x887
    x889 = -x199
    x890 = x233 + x889
    x891 = x1*x858
    x892 = x44*x875
    x893 = x370*x892
    x894 = x17*x859
    x895 = x282*x892
    x896 = x124*x863
    x897 = x125*x866
    x898 = x31*x326
    x899 = x27*x440
    x900 = -x899
    x901 = x898 + x900
    x902 = x112 + x901
    x903 = x28*x36
    x904 = 2*x903
    x905 = x208*x27
    x906 = 2*x269
    x907 = x264*x906
    x908 = x17*x855
    x909 = x122*x908
    x910 = x214*x27
    x911 = x28*x326
    x912 = -x911
    x913 = x910 + x912
    x914 = x117 + x913
    x915 = x208*x31
    x916 = x276*x35
    x917 = 2*x916
    x918 = x1*x855
    x919 = x122*x918
    x920 = x276*x906
    x921 = x28*x440
    x922 = x214*x31
    x923 = -x922
    x924 = x921 + x923
    x925 = x121 + x924
    x926 = x18*x839
    x927 = -x456
    x928 = x458 + x927
    x929 = -x223
    x930 = x847*x884
    x931 = x44*x926
    x932 = x30*x823
    x933 = -x211 - x867
    x934 = x323 + x869
    x935 = x18*x855 - x269*x30 + x755 + x777 + x933 + x934
    x936 = x44*x839
    x937 = x371*x936
    x938 = x17*x366
    x939 = x1*x30
    x940 = x271*x939
    x941 = x276*x360
    x942 = x1*x264
    x943 = x17*x268
    x944 = -x271*x938 + x942*x943
    x945 = x290 + x687 + x916 + x922 + x940 - x941 + x944
    x946 = x366*x823
    x947 = x14*x946
    x948 = x115*x862
    x949 = -x898
    x950 = x31*x36
    x951 = -x950
    x952 = x269*x366
    x953 = x1*x908
    x954 = x17*x863 - x271*x942
    x955 = x327 + x37 + x949 + x951 + x952 - x953 + x954
    x956 = x225*x355 + x229*x350 + x236*x344 + x242*x336 + x248*x340 + x255*x332
    x957 = x122*x936
    x958 = 2*x910
    x959 = -x958
    x960 = -x382
    x961 = x1*x276
    x962 = x124*x268*x961
    x963 = 2*x360
    x964 = x264*x963
    x965 = 2*x911
    x966 = x271*x30
    x967 = x124*x966
    x968 = x271*x366
    x969 = x125*x968
    x970 = -4*x215 - x663 - 4*x903 + x907 + x909 + x959 + x960 + x962 + x964 - x965 + x967 + x969
    x971 = 2*x843
    x972 = 2*x227
    x973 = 2*x196
    x974 = x972 + x973
    x975 = (mpmath.mpf(1)/mpmath.mpf(2))*x257
    x976 = (mpmath.mpf(1)/mpmath.mpf(2))*x357
    x977 = x101*x219
    x978 = x201*x832
    x979 = x309*x669
    x980 = x317*x386
    x981 = x219*x669
    x982 = x205*x976 + x220*x976 + x317*x978 + x319*x975 + x329*x977 + x329*x979 + x330*x975 + x980*x981
    x983 = -x196
    x984 = x19*x839
    x985 = x17*x846
    x986 = -x460
    x987 = x456 + x986
    x988 = x279 + x375 + x899 + x950 - x952 + x953 + x954
    x989 = x44*x984
    x990 = x17*x32
    x991 = -x903
    x992 = -x910
    x993 = x264*x423
    x994 = x271*x990
    x995 = x1*x366
    x996 = x276*x943
    x997 = -x1*x996 + x271*x995
    x998 = x215 + x47 + x991 + x992 + x993 - x994 + x997
    x999 = x14*x32
    x1000 = x31*x44
    x1001 = x211 + x867
    x1002 = -x397 - x871
    x1003 = x1001 + x1002 - x19*x855 + x269*x32 + x649 + x704
    x1004 = x225*x416 + x229*x409 + x236*x412 + x242*x407 + x248*x401 + x255*x403
    x1005 = x125*x32
    x1006 = 2*x921
    x1007 = -x1006
    x1008 = x124*x968
    x1009 = x271*x32
    x1010 = x1009*x125
    x1011 = 2*x922
    x1012 = 2*x423
    x1013 = x1012*x276
    x1014 = x268*x942
    x1015 = x1014*x124
    x1016 = x1007 + x1008 + x1010 - x1011 + x1013 + x1015 - 4*x217 - x430 + x826 - 4*x916 + x919 + x920
    x1017 = 2*x846
    x1018 = x841*x847
    x1019 = x124*x843
    x1020 = 2*x233
    x1021 = 2*x199
    x1022 = x1020 + x1021
    x1023 = (mpmath.mpf(1)/mpmath.mpf(2))*x418
    x1024 = x386*x981
    x1025 = x1023*x205 + x1023*x220 + x1024*x392 + x392*x978 + x393*x975 + x399*x977 + x399*x979 + x400*x975
    x1026 = -x973
    x1027 = x435*x839
    x1028 = x435*x843
    x1029 = x14*x222
    x1030 = -x1029
    x1031 = x191*x447
    x1032 = x1031*x14
    x1033 = x17*x6
    x1034 = x1032*x1033
    x1035 = x1031*x15
    x1036 = x1035*x5
    x1037 = x1036*x3
    x1038 = x195*x435
    x1039 = x1038 + x452
    x1040 = x1030 + x1034 - x1037 + x1039 + x227
    x1041 = x1*x1032
    x1042 = x3*x5
    x1043 = x1041*x1042
    x1044 = x1032*x17
    x1045 = x1044*x9
    x1046 = x1045*x5
    x1047 = x1043 - x1046 + x334 + x929
    x1048 = x846*x875
    x1049 = x14*x192
    x1050 = x1*x1049
    x1051 = -x233
    x1052 = x1036*x9
    x1053 = x1041*x6
    x1054 = -x454
    x1055 = x198*x435
    x1056 = x1054 - x1055
    x1057 = x1050 + x1051 + x1052 - x1053 + x1056
    x1058 = x435*x936
    x1059 = x435*x892
    x1060 = x435*x905
    x1061 = x435*x866
    x1062 = x1060 - x1061 + x435*x908 + x808 + x911 + x991
    x1063 = x1014*x435
    x1064 = x435*x996
    x1065 = x1063 - x1064 + x899 + x949
    x1066 = x435*x915
    x1067 = -x1066
    x1068 = -x921
    x1069 = x435*x863
    x1070 = x1067 + x1068 + x1069 - x435*x918 + x441 + x916
    x1071 = x225*x464 + x229*x468 + x236*x466 + x242*x472 + x248*x482 + x255*x476
    x1072 = x124*x860
    x1073 = x435*x854
    x1074 = x122*x855
    x1075 = x268*x435
    x1076 = x124*x264
    x1077 = x125*x276
    x1078 = x305 + x872
    x1079 = -2*x1073 + x1074*x435 + x1075*x1076 + x1075*x1077 + x1078 + 2*x211 - x437 + x870
    x1080 = x122*x841
    x1081 = x125*x846
    x1082 = 2*x193
    x1083 = 2*x6
    x1084 = x232*x435
    x1085 = 2*x22
    x1086 = -x1085
    x1087 = x1042*x1044
    x1088 = x1086 - 2*x1087 - x461
    x1089 = x1041*x9
    x1090 = x1089*x5
    x1091 = -2*x1090 - x459
    x1092 = -x1035*x1083 + x1082 + 2*x1084 + x1088 + x1091 + x450
    x1093 = (mpmath.mpf(1)/mpmath.mpf(2))*x484
    x1094 = x1024*x462 + x1093*x205 + x1093*x220 + x443*x977 + x443*x979 + x444*x975 + x462*x978 + x463*x975
    x1095 = x492*x839
    x1096 = x492*x843
    x1097 = -x22
    x1098 = x1097 + x193
    x1099 = x195*x492
    x1100 = x1099 + x502
    x1101 = -x1035*x7 + x1087 + x1098 + x1100 + x456
    x1102 = -x1050
    x1103 = x1041*x7
    x1104 = x1045*x3
    x1105 = -x1104
    x1106 = x1102 + x1103 + x1105 + x889
    x1107 = -x505
    x1108 = x198*x492
    x1109 = x1035*x3
    x1110 = x1109*x9
    x1111 = -x1043
    x1112 = x1107 - x1108 + x1110 + x1111
    x1113 = x492*x936
    x1114 = x492*x892
    x1115 = x492*x905
    x1116 = x492*x866
    x1117 = x1001 + x1115 - x1116 + x362 + x492*x908 + x812
    x1118 = -x916
    x1119 = x1014*x492
    x1120 = x492*x996
    x1121 = x1118 + x1119 - x1120 + x923
    x1122 = x492*x915
    x1123 = x492*x863
    x1124 = -x1122 + x1123 - x492*x918 + x497
    x1125 = x225*x513 + x229*x511 + x236*x509 + x242*x523 + x248*x518 + x255*x516
    x1126 = x492*x854
    x1127 = 2*x1126
    x1128 = x268*x492
    x1129 = x1074*x492 + x1076*x1128 + x1077*x1128 - x1127 - x494 + x904 + x958
    x1130 = x232*x492
    x1131 = 2*x1130
    x1132 = x1044*x7
    x1133 = x1089*x3
    x1134 = 2*x452
    x1135 = 2*x1029
    x1136 = x1134 + x1135
    x1137 = x1026 - 2*x1037 + x1131 - 2*x1132 - 2*x1133 + x1136
    x1138 = (mpmath.mpf(1)/mpmath.mpf(2))*x525
    x1139 = x1024*x507 + x1138*x205 + x1138*x220 + x499*x977 + x499*x979 + x500*x975 + x507*x978 + x508*x975
    x1140 = x530*x839
    x1141 = x530*x843
    x1142 = x195*x530
    x1143 = x1046 - x1110 + x1142 + x505
    x1144 = x10*x1044
    x1145 = x1029 + x1133 - x1144 + x196
    x1146 = -x193 + x22
    x1147 = x198*x530
    x1148 = -x1147 - x540
    x1149 = x10*x1035 - x1090 + x1146 + x1148 + x927
    x1150 = x530*x936
    x1151 = x530*x892
    x1152 = x530*x905
    x1153 = x530*x866
    x1154 = x1152 - x1153 + x530*x908 + x815
    x1155 = x1014*x530
    x1156 = x530*x996
    x1157 = x1155 - x1156 + x903 + x910
    x1158 = x530*x915
    x1159 = -x1158
    x1160 = x530*x863
    x1161 = x1159 + x1160 + x45 - x530*x918 + x535 + x933
    x1162 = x225*x546 + x229*x544 + x236*x548 + x242*x552 + x248*x550 + x255*x556
    x1163 = x530*x854
    x1164 = 2*x1163
    x1165 = -x1164
    x1166 = x268*x530
    x1167 = x1011 + x1074*x530 + x1076*x1166 + x1077*x1166 + x1165 - x532 + x917
    x1168 = x232*x530
    x1169 = 2*x1168
    x1170 = x10*x1041
    x1171 = 2*x454
    x1172 = 2*x1050
    x1173 = x1171 + x1172
    x1174 = -x1021 - 2*x1052 - 2*x1104 + x1169 - 2*x1170 + x1173
    x1175 = (mpmath.mpf(1)/mpmath.mpf(2))*x558
    x1176 = x1024*x542 + x1175*x205 + x1175*x220 + x537*x977 + x537*x979 + x538*x975 + x542*x978 + x543*x975
    x1177 = x1041*x3
    x1178 = x1177*x563
    x1179 = x1045*x563
    x1180 = x5*x563
    x1181 = x1044*x1180
    x1182 = -x566
    x1183 = x1035*x9
    x1184 = x1041*x1180
    x1185 = (mpmath.mpf(1)/mpmath.mpf(2))*x574
    x1186 = 2*x1036
    x1187 = x3*x563
    x1188 = x1044*x1187
    x1189 = x1089*x563
    x1190 = x1024*x578 + x1185*x205 + x1185*x220 + x578*x978 + x579*x975 + x70*(x242*x567 + x248*x570 + x255*x572 + x83*(x1029 - x1109*x563 + x1181 + x564) + x84*(x1102 + x1182 + x1183*x563 - x1184) + x85*(x1178 - x1179)) + x850*(-x1082 + x1085 - x1186*x563 - 2*x1188 - 2*x1189 + x575)
    x1191 = -x583
    x1192 = x5*x582
    x1193 = x1041*x1192
    x1194 = x1177*x582
    x1195 = x1045*x582
    x1196 = x1044*x1192
    x1197 = (mpmath.mpf(1)/mpmath.mpf(2))*x592
    x1198 = -x1135
    x1199 = x3*x582
    x1200 = x1044*x1199
    x1201 = x1089*x582
    x1202 = x1024*x596 + x1197*x205 + x1197*x220 + x596*x978 + x597*x975 + x70*(x242*x588 + x248*x590 + x255*x585 + x83*(-x1109*x582 + x1146 + x1196 + x587) + x84*(x1183*x582 + x1191 - x1193) + x85*(x1050 + x1194 - x1195)) + x850*(-x1186*x582 + x1198 - 2*x1200 - 2*x1201 + x593)
    x1203 = x5*x600
    x1204 = x1044*x1203
    x1205 = x1177*x600
    x1206 = x1045*x600
    x1207 = -x605
    x1208 = x1041*x1203
    x1209 = (mpmath.mpf(1)/mpmath.mpf(2))*x610
    x1210 = -x1172
    x1211 = x3*x600
    x1212 = x1044*x1211
    x1213 = x1089*x600
    x1214 = x1024*x614 + x1209*x205 + x1209*x220 + x614*x978 + x615*x975 + x70*(x242*x608 + x248*x603 + x255*x606 + x83*(-x1109*x600 + x1204 + x602) + x84*(x1098 + x1183*x600 + x1207 - x1208) + x85*(x1030 + x1205 - x1206)) + x850*(-x1186*x600 + x1210 - 2*x1212 - 2*x1213 + x611)
    x1215 = x66*x820
    x1216 = x94*(x1215*x317 + x329*x618 + x97*(2*x333 + 2*x337 + 2*x341 + 2*x345 + 2*x351 + 2*x356))
    x1217 = -x621
    x1218 = x106*(x1217 + x620)
    x1219 = x1218*x26
    x1220 = x1219*x14
    x1221 = x102*(x245 + x247 + x27*x321 + x324 + x328 + x415)
    x1222 = x1218*x135
    x1223 = x1222*x14
    x1224 = x1218*x164
    x1225 = x1224*x14
    x1226 = 3*p1
    x1227 = x837*(x1217 + x1226)
    x1228 = x1227*x15
    x1229 = x1227*x14
    x1230 = x1*x1229
    x1231 = x1230*x843
    x1232 = x1229*x985
    x1233 = x1218*x29
    x1234 = x1228*x44
    x1235 = x1229*x44
    x1236 = x1218*x14
    x1237 = x1218*x942
    x1238 = x1235*x370
    x1239 = x1218*x17
    x1240 = x1239*x276
    x1241 = x1235*x282
    x1242 = x122*x1227
    x1243 = x1*x1227
    x1244 = x122*x1243
    x1245 = x833*(-x228 + x23 - x315 + x406)
    x1246 = 4*p1
    x1247 = x1246 + x694
    x1248 = x1227*x18
    x1249 = x124*x846
    x1250 = -x1246
    x1251 = x1250 + x693
    x1252 = x124*x30
    x1253 = x1248*x44
    x1254 = x1218*x122
    x1255 = x1218*x366
    x1256 = x1227*x44
    x1257 = x122*x1256
    x1258 = 4*x943*x995
    x1259 = x1243*x884
    x1260 = 2*p1
    x1261 = -x1260
    x1262 = x1261 + x673
    x1263 = x1260 + x680
    x1264 = x1236*x366
    x1265 = x1243*x44
    x1266 = x115*x1265
    x1267 = x14*x30
    x1268 = x1229*x860
    x1269 = 2*x950
    x1270 = x366*x963
    x1271 = x268*x939
    x1272 = x124*x1271
    x1273 = x1256*x371
    x1274 = x1227*x19
    x1275 = -x458
    x1276 = x1275 + x460
    x1277 = x1068 + x1118 + x217 + x55 - x940 + x941 + x944
    x1278 = x1274*x44
    x1279 = -x323 - x869
    x1280 = x397 + x871
    x1281 = x1279 + x1280 + x30*x423 - x32*x360 + x364 + x427
    x1282 = x267 + x677 + x903 + x911 - x993 + x994 + x997
    x1283 = x332*x412 + x336*x416 + x340*x409 + x344*x403 + x350*x401 + x355*x407
    x1284 = 2*x898
    x1285 = -x1284
    x1286 = -x709
    x1287 = x1012*x366
    x1288 = 2*x899
    x1289 = x268*x990
    x1290 = x125*x1289
    x1291 = x1270 + x1272 + x1285 + x1286 + x1287 - x1288 + x1290 - 4*x327 - x784 + x896 + x897 - 4*x950
    x1292 = x1243*x841
    x1293 = 2*x334
    x1294 = 2*x223
    x1295 = x1293 + x1294
    x1296 = x101*x329
    x1297 = x317*x832
    x1298 = x669*x980
    x1299 = x386*x392
    x1300 = x329*x669
    x1301 = x1023*x319 + x1023*x330 + x1296*x399 + x1297*x392 + x1298*x399 + x1299*x1300 + x393*x976 + x400*x976
    x1302 = x1227*x435
    x1303 = x1031*x18
    x1304 = x22 - x314
    x1305 = -x1084 - x449
    x1306 = -x1087 + x1275 + x1303*x6 + x1304 + x1305
    x1307 = x1303*x5
    x1308 = x1307*x9
    x1309 = x1*x1031
    x1310 = x1309*x17
    x1311 = x1042*x1310
    x1312 = x1055 - x1308 + x1311 + x454
    x1313 = x1229*x435
    x1314 = x1*x222
    x1315 = x1033*x1309
    x1316 = x1046 + x1314 - x1315 + x223
    x1317 = x1256*x435
    x1318 = -x1073
    x1319 = x435*x943
    x1320 = x1279 + x1318 + x1319*x264 - x435*x966 + x436 + x45
    x1321 = x1066 + x1271*x435 - x1319*x366 + x487
    x1322 = x435*x968
    x1323 = -x1063 + x1322 + x898 + x950
    x1324 = x332*x466 + x336*x464 + x340*x468 + x344*x476 + x350*x482 + x355*x472
    x1325 = x1000*x125
    x1326 = 2*x1060
    x1327 = -x1326
    x1328 = x1252*x268
    x1329 = x125*x366
    x1330 = 2*x1061 + x1075*x1329 + x1327 + x1328*x435 - x439 + x904 + x965
    x1331 = x1227*x124
    x1332 = 2*x1038
    x1333 = x1307*x3
    x1334 = x1310*x9
    x1335 = x1334*x5
    x1336 = -2*x1034 + x1136 + x1332 - 2*x1333 - 2*x1335 - x972
    x1337 = x1300*x386
    x1338 = x1093*x319 + x1093*x330 + x1296*x443 + x1297*x462 + x1298*x443 + x1337*x462 + x444*x976 + x463*x976
    x1339 = x1227*x492
    x1340 = -x452
    x1341 = -x1130 + x1340
    x1342 = x1029 - x1132 + x1333 + x1341 + x983
    x1343 = -x1294
    x1344 = -x1314
    x1345 = x1310*x7
    x1346 = x1303*x9
    x1347 = x1346*x3
    x1348 = x1108 + x505
    x1349 = x1344 + x1345 - x1347 + x1348 + x334
    x1350 = x1229*x492
    x1351 = x1051 + x1104 - x1311 + x199
    x1352 = x1256*x492
    x1353 = -x1126
    x1354 = x492*x943
    x1355 = x1353 + x1354*x264 - x492*x966 + x493 + x903 + x992
    x1356 = x1122 + x1271*x492 - x1354*x366 + x527 + x899 + x951
    x1357 = x492*x968
    x1358 = x1068 - x1119 + x1357 + x922
    x1359 = x332*x509 + x336*x513 + x340*x511 + x344*x516 + x350*x518 + x355*x523
    x1360 = x1078 - 2*x1115 + 2*x1116 + x1128*x1329 + x1328*x492 + 2*x323 - x496 + x868
    x1361 = 2*x314
    x1362 = 2*x1303
    x1363 = x1334*x3
    x1364 = -2*x1363 - x457
    x1365 = x1088 + 2*x1099 + x1361 - x1362*x7 + x1364 + x503
    x1366 = x1138*x319 + x1138*x330 + x1296*x499 + x1297*x507 + x1298*x499 + x1337*x507 + x500*x976 + x508*x976
    x1367 = x1227*x530
    x1368 = x1054 + x1105 - x1168 + x1308
    x1369 = x1097 + x314
    x1370 = x1147 + x540
    x1371 = -x10*x1303 + x1363 + x1369 + x1370 + x458
    x1372 = x1229*x530
    x1373 = -x1335
    x1374 = x1030 + x1144 + x1373 + x885
    x1375 = x1256*x530
    x1376 = x530*x943
    x1377 = -x1163 + x1376*x264 - x530*x966 + x531
    x1378 = x1158 + x1271*x530 - x1376*x366 + x362 + x561 + x934
    x1379 = x530*x968
    x1380 = -x1155 + x1379 + x912 + x991
    x1381 = x332*x548 + x336*x546 + x340*x544 + x344*x556 + x350*x550 + x355*x552
    x1382 = 2*x1152
    x1383 = 2*x1153 + x1166*x1329 + x1269 + x1284 + x1328*x530 - x1382 - x534
    x1384 = 2*x1142
    x1385 = x10*x1310
    x1386 = 2*x505
    x1387 = 2*x1314
    x1388 = x1386 + x1387
    x1389 = -2*x1046 + x1343 - 2*x1347 + x1384 - 2*x1385 + x1388
    x1390 = x1175*x319 + x1175*x330 + x1296*x537 + x1297*x542 + x1298*x537 + x1337*x542 + x538*x976 + x543*x976
    x1391 = x1187*x1310
    x1392 = x1180*x1310
    x1393 = -x569
    x1394 = x1334*x563
    x1395 = x1185*x319 + x1185*x330 + x1297*x578 + x1337*x578 + x579*x976 + x70*(x344*x572 + x350*x570 + x355*x567 + x83*(-x1188 + x1307*x563 + x1369 + x1393) + x84*(x1179 + x1344 - x1392) + x85*(-x1346*x563 + x1391 + x566)) + x850*(-2*x1181 - x1187*x1362 + x1198 - 2*x1394 + x576)
    x1396 = x1192*x1310
    x1397 = x1199*x1310
    x1398 = -x584
    x1399 = x1334*x582
    x1400 = x1197*x319 + x1197*x330 + x1297*x596 + x1337*x596 + x597*x976 + x70*(x344*x585 + x350*x590 + x355*x588 + x83*(x1030 - x1200 + x1307*x582 + x1398) + x84*(x1195 - x1396) + x85*(x1314 - x1346*x582 + x1397 + x583)) + x850*(x1085 - 2*x1196 - x1199*x1362 - x1361 - 2*x1399 + x594)
    x1401 = -x601
    x1402 = x1203*x1310
    x1403 = x1211*x1310
    x1404 = -x1387
    x1405 = x1334*x600
    x1406 = x1209*x319 + x1209*x330 + x1297*x614 + x1337*x614 + x615*x976 + x70*(x344*x606 + x350*x603 + x355*x608 + x83*(-x1212 + x1307*x600 + x1401) + x84*(x1029 + x1206 - x1402) + x85*(x1304 - x1346*x600 + x1403 + x605)) + x850*(-2*x1204 - x1211*x1362 + x1404 - 2*x1405 + x612)
    x1407 = x94*(x1215*x392 + x399*x618 + x97*(2*x402 + 2*x404 + 2*x408 + 2*x410 + 2*x413 + 2*x417))
    x1408 = -x728
    x1409 = x106*(x1408 + x727)
    x1410 = x1409*x26
    x1411 = x14*x1410
    x1412 = x102*(x250 + x254 + x31*x395 + x352 + x354 + x398)
    x1413 = x135*x1409
    x1414 = x14*x1413
    x1415 = x1409*x164
    x1416 = x14*x1415
    x1417 = 3*p2
    x1418 = x837*(x1408 + x1417)
    x1419 = x1418*x15
    x1420 = x14*x1418
    x1421 = x1*x1420
    x1422 = x1421*x843
    x1423 = x1420*x985
    x1424 = x1409*x29
    x1425 = x1419*x44
    x1426 = x1420*x44
    x1427 = x14*x1409
    x1428 = x1409*x942
    x1429 = x1426*x370
    x1430 = x1409*x17
    x1431 = x1430*x276
    x1432 = x1426*x282
    x1433 = x122*x1418
    x1434 = x1*x1418
    x1435 = x122*x1434
    x1436 = x833*(x235 + x24 - x335 - x391)
    x1437 = x1418*x18
    x1438 = x1434*x884
    x1439 = x1437*x44
    x1440 = x1420*x860
    x1441 = x1418*x44
    x1442 = x1441*x371
    x1443 = x1427*x366
    x1444 = x1434*x44
    x1445 = x115*x1444
    x1446 = x122*x1409
    x1447 = x122*x1441
    x1448 = 4*p2
    x1449 = x1448 + x803
    x1450 = x1418*x19
    x1451 = x1434*x841
    x1452 = -x1448
    x1453 = x1452 + x802
    x1454 = x1450*x44
    x1455 = x124*x366
    x1456 = 2*p2
    x1457 = x1456 + x797
    x1458 = -x1456
    x1459 = x1458 + x791
    x1460 = x1418*x435
    x1461 = x1111 + x1315 + x1344 + x880
    x1462 = x1031*x19
    x1463 = x1462*x3
    x1464 = x1463*x5
    x1465 = -x1038 + x1340 + x1373 + x1464
    x1466 = x1420*x435
    x1467 = x1097 + x390
    x1468 = x1084 + x449
    x1469 = x1090 - x1462*x6 + x1467 + x1468 + x460
    x1470 = x1441*x435
    x1471 = x1064 - x1322 + x900 + x951
    x1472 = -x1060 + x1075*x995 - x1289*x435 + x438
    x1473 = x1009*x435 + x1073 - x1075*x961 + x1280 + x362 + x714
    x1474 = x401*x468 + x403*x466 + x407*x464 + x409*x482 + x412*x476 + x416*x472
    x1475 = 2*x1066
    x1476 = x1005*x1075 + x1006 + 2*x1069 + x1075*x1455 - x1475 - x442 + x917
    x1477 = x124*x1418
    x1478 = -x1020
    x1479 = 2*x1055
    x1480 = x1462*x5
    x1481 = x1480*x9
    x1482 = -2*x1053 + x1173 - 2*x1311 + x1478 + x1479 - 2*x1481
    x1483 = x101*x399
    x1484 = x392*x832
    x1485 = x1299*x669
    x1486 = x386*x462
    x1487 = x399*x669
    x1488 = x1023*x444 + x1023*x463 + x1093*x393 + x1093*x400 + x1483*x443 + x1484*x462 + x1485*x443 + x1486*x1487
    x1489 = x1418*x492
    x1490 = x1050 - x1103 + x1311 + x233
    x1491 = x22 - x390
    x1492 = -x1099 - x502
    x1493 = -x1363 + x1462*x7 + x1491 + x1492 + x986
    x1494 = x1420*x492
    x1495 = x1130 + x1133 - x1464 + x452
    x1496 = x1441*x492
    x1497 = x1120 - x1357 + x916 + x921
    x1498 = -x1115
    x1499 = x1002 + x1128*x995 - x1289*x492 + x1498 + x45 + x495
    x1500 = x1009*x492 + x1126 - x1128*x961 + x718
    x1501 = x401*x511 + x403*x509 + x407*x513 + x409*x518 + x412*x516 + x416*x523
    x1502 = 2*x1122
    x1503 = -x1502
    x1504 = x1005*x1128 + 2*x1123 + x1128*x1455 + x1269 + x1288 + x1503 - x498
    x1505 = 2*x1108
    x1506 = x1463*x9
    x1507 = -2*x1043 - x1293 - 2*x1345 + x1388 + x1505 - 2*x1506
    x1508 = x1487*x386
    x1509 = x1023*x500 + x1023*x508 + x1138*x393 + x1138*x400 + x1483*x499 + x1484*x507 + x1485*x499 + x1508*x507
    x1510 = x1418*x530
    x1511 = -x1133 + x1335 + x227 + x983
    x1512 = x1107 - x1142
    x1513 = x1314 - x1385 + x1506 + x1512 + x929
    x1514 = x1420*x530
    x1515 = x1168 + x454
    x1516 = x1102 + x1170 - x1481 + x1515 + x199
    x1517 = x1441*x530
    x1518 = x1156 - x1379 + x911 + x992
    x1519 = -x1152
    x1520 = x1166*x995 - x1289*x530 + x1519 + x533 + x949 + x950
    x1521 = x1009*x530 + x1118 + x1163 - x1166*x961 + x720 + x922
    x1522 = x401*x544 + x403*x548 + x407*x546 + x409*x550 + x412*x556 + x416*x552
    x1523 = x1005*x1166 - 2*x1158 + 2*x1160 + x1166*x1455 + x305 + 2*x397 - x536 + x868 + x870
    x1524 = 2*x390
    x1525 = 2*x1462
    x1526 = -x10*x1525 + x1086 + x1091 + 2*x1147 + x1364 + x1524 + x541
    x1527 = x1023*x538 + x1023*x543 + x1175*x393 + x1175*x400 + x1483*x537 + x1484*x542 + x1485*x537 + x1508*x542
    x1528 = -x564
    x1529 = x1525*x9
    x1530 = x1023*x579 + x1185*x393 + x1185*x400 + x1484*x578 + x1508*x578 + x70*(x409*x570 + x412*x572 + x416*x567 + x83*(-x1178 + x1314 + x1392) + x84*(x1189 - x1480*x563 + x1491 + x569) + x85*(-x1394 + x1463*x563 + x1528)) + x850*(-2*x1184 + x1210 - 2*x1391 - x1529*x563 + x577)
    x1531 = -x587
    x1532 = x1023*x597 + x1197*x393 + x1197*x400 + x1484*x596 + x1508*x596 + x70*(x409*x590 + x412*x585 + x416*x588 + x83*(x1102 - x1194 + x1396) + x84*(x1201 - x1480*x582 + x584) + x85*(-x1399 + x1463*x582 + x1467 + x1531)) + x850*(-2*x1193 - 2*x1397 + x1404 - x1529*x582 + x595)
    x1533 = -x602
    x1534 = x1023*x615 + x1209*x393 + x1209*x400 + x1484*x614 + x1508*x614 + x70*(x409*x603 + x412*x606 + x416*x608 + x83*(-x1205 + x1402) + x84*(x1050 + x1213 - x1480*x600 + x601) + x85*(x1344 - x1405 + x1463*x600 + x1533)) + x850*(x1085 - 2*x1208 - 2*x1403 - x1524 - x1529*x600 + x613)
    x1535 = x94*(x1215*x462 + x443*x618 + x97*(2*x465 + 2*x467 + 2*x469 + 2*x473 + 2*x477 + 2*x483))
    x1536 = x102*(x27*x438 + x28*x436 + x31*x441 + x347)
    x1537 = -x838
    x1538 = x837*(x105 + x1537)
    x1539 = x15*x1538
    x1540 = x14*x1538
    x1541 = x1*x1540
    x1542 = x1541*x843
    x1543 = x1540*x985
    x1544 = x1539*x44
    x1545 = x1540*x44
    x1546 = x1545*x370
    x1547 = x1545*x282
    x1548 = x122*x1538
    x1549 = x1*x1538
    x1550 = x122*x1549
    x1551 = x833*(-x14*x449 - x435*x456 - x435*x458 - x435*x460 + x445 - x453 + x555)
    x1552 = x1538*x18
    x1553 = x1549*x884
    x1554 = x1552*x44
    x1555 = x1540*x860
    x1556 = x1538*x44
    x1557 = x1556*x371
    x1558 = x1549*x44
    x1559 = x115*x1558
    x1560 = x122*x1556
    x1561 = x1538*x19
    x1562 = x1561*x44
    x1563 = x1549*x841
    x1564 = x1556*x435
    x1565 = x1538*x435
    x1566 = 4*n0
    x1567 = x14*x448
    x1568 = x1049*x435
    x1569 = x1032*x435
    x1570 = 3*n0
    x1571 = x21/x11**(mpmath.mpf(5)/mpmath.mpf(2))
    x1572 = x1571*(x1537 + x1570)
    x1573 = x14*x1572
    x1574 = x1031*x17
    x1575 = x1574*x435
    x1576 = x1042*x1575
    x1577 = x5*x9
    x1578 = x1309*x435
    x1579 = x1577*x1578
    x1580 = x124*x1572
    x1581 = x1*x1572
    x1582 = x1577*x1581
    x1583 = x124*x1538
    x1584 = x14*x451
    x1585 = 2*x1584
    x1586 = x17*x504
    x1587 = 2*x1586
    x1588 = x1*x565
    x1589 = 2*x1588
    x1590 = x1585 + x1587 + x1589
    x1591 = x1590 + 4*x22 + x849
    x1592 = x1540*x435
    x1593 = x1042*x1581
    x1594 = x1572*x17
    x1595 = x1577*x1594
    x1596 = x1031*x124
    x1597 = x1596*x435
    x1598 = 2*x435
    x1599 = x1042*x1598
    x1600 = x17*x565
    x1601 = x1*x504
    x1602 = -x1601
    x1603 = x1600 + x1602
    x1604 = x1603 + x881
    x1605 = x222*x435
    x1606 = 2*x1605
    x1607 = -x1606
    x1608 = 2*n0
    x1609 = -x1608 + x882
    x1610 = x17*x448
    x1611 = x1031*x1033
    x1612 = x1042*x1573
    x1613 = x14*x504
    x1614 = x17*x451
    x1615 = -x1614
    x1616 = x1613 + x1615
    x1617 = x1616 + x886
    x1618 = -x1032*x1599 - x1332
    x1619 = x1608 + x887
    x1620 = x1*x448
    x1621 = x1*x192
    x1622 = x1621*x435
    x1623 = 2*x1622
    x1624 = x1573*x1577
    x1625 = x1032*x1598
    x1626 = x1577*x1625
    x1627 = x1*x451
    x1628 = x14*x565
    x1629 = -x1628
    x1630 = x1627 + x1629
    x1631 = x1630 + x890
    x1632 = x1538*x492
    x1633 = x435*x7
    x1634 = x1042*x492
    x1635 = x1032*x1634
    x1636 = x1568 + x1584
    x1637 = x222*x492
    x1638 = -x1586 - x1637
    x1639 = -x1032*x1633 + x1468 + x1492 + x1576 + x1611*x492 - x1635 + x1636 + x1638
    x1640 = x3*x9
    x1641 = -x1627
    x1642 = -x1622
    x1643 = x1309*x1634
    x1644 = x1577*x492
    x1645 = x1574*x1644
    x1646 = x1056 + x1309*x1633 - x1575*x1640 + x1641 + x1642 + x1643 - x1645
    x1647 = x1573*x1640
    x1648 = x1540*x492
    x1649 = x1621*x492
    x1650 = x1309*x6
    x1651 = x1032*x1644
    x1652 = x1569*x1640
    x1653 = -x1042*x1578 + x1348 + x1601 + x1649 - x1650*x492 + x1651 + x1652
    x1654 = x1556*x492
    x1655 = x1073 + x1498
    x1656 = x464*x523 + x466*x516 + x468*x518 + x472*x513 + x476*x509 + x482*x511
    x1657 = x1127 + x1326
    x1658 = x124*x7
    x1659 = x1581*x1640
    x1660 = 2*x1614
    x1661 = x1049*x492
    x1662 = 2*x1661
    x1663 = 2*x1613
    x1664 = x1032*x1083
    x1665 = x1596*x1634
    x1666 = 2*x1309
    x1667 = x1309*x1598
    x1668 = -x1131 - x1596*x1633 + x1606 + x1618 - x1640*x1667 - x1644*x1666 + x1660 + x1662 + x1663 - x1664*x492 - x1665 - 4*x452
    x1669 = x101*x443
    x1670 = x462*x832
    x1671 = x386*x507
    x1672 = x443*x669
    x1673 = x1486*x669
    x1674 = x1093*x500 + x1093*x508 + x1138*x444 + x1138*x463 + x1669*x499 + x1670*x507 + x1671*x1672 + x1673*x499
    x1675 = x1538*x530
    x1676 = -x1600
    x1677 = x222*x530
    x1678 = -x1677
    x1679 = x1042*x530
    x1680 = x1032*x1679
    x1681 = x1512 + x1575*x1577 + x1611*x530 - x1652 + x1676 + x1678 - x1680
    x1682 = x10*x17
    x1683 = x1031*x1682
    x1684 = x1309*x1679
    x1685 = x1577*x530
    x1686 = x1039 - x1574*x1685 + x1578*x1640 + x1605 + x1614 - x1683*x435 + x1684
    x1687 = x1540*x530
    x1688 = x10*x1032
    x1689 = x1032*x1685
    x1690 = -x1568 - x1584
    x1691 = x1621*x530
    x1692 = x1588 + x1691
    x1693 = x1305 + x1370 - x1579 - x1650*x530 + x1688*x435 + x1689 + x1690 + x1692
    x1694 = x1556*x530
    x1695 = x1158 + x1318
    x1696 = x464*x552 + x466*x556 + x468*x550 + x472*x546 + x476*x548 + x482*x544
    x1697 = x1164 + x1475
    x1698 = 2*x10
    x1699 = 2*x1628
    x1700 = 2*x1627
    x1701 = x1049*x530
    x1702 = 2*x1701
    x1703 = x10*x1309
    x1704 = -x1169 - x1666*x1685
    x1705 = -x1479 - x1596*x1679 - x1597*x1640 - x1598*x1703 + x1623 - x1626 - x1664*x530 + x1699 + x1700 + x1702 + x1704 - 4*x454
    x1706 = x1672*x386
    x1707 = x1093*x538 + x1093*x543 + x1175*x444 + x1175*x463 + x1669*x537 + x1670*x542 + x1673*x537 + x1706*x542
    x1708 = x1610*x563
    x1709 = -x1708
    x1710 = -x1613
    x1711 = x1180*x1575 - x1187*x1569 + x1528 + x1605 + x1709 + x1710
    x1712 = x563*x9
    x1713 = x1187*x1578 - x1575*x1712 + x1601 + x1676
    x1714 = -x1700
    x1715 = x1620*x563
    x1716 = -x1180*x1578 + x1569*x1712 + x1628 + x1642 + x1715 + x566
    x1717 = x464*x567 + x466*x572 + x468*x570
    x1718 = 2*x1573
    x1719 = 2*x1581
    x1720 = -x1587
    x1721 = x1567*x563
    x1722 = x1086 - x1589
    x1723 = -x1180*x1625 - x1187*x1597 - 2*x1568 - x1667*x1712 + x1720 + 2*x1721 + x1722 - x575
    x1724 = x1093*x579 + x1185*x444 + x1185*x463 + x1670*x578 + x1706*x578
    x1725 = x1610*x582
    x1726 = -x1725
    x1727 = x1097 + x1192*x1575 - x1199*x1569 + x1531 + x1690 + x1726
    x1728 = x582*x9
    x1729 = x1199*x1578 - x1575*x1728 + x1622 + x1627
    x1730 = x1620*x582
    x1731 = -x1192*x1578 + x1569*x1728 + x1730 + x583
    x1732 = x464*x588 + x466*x585 + x468*x590
    x1733 = x1567*x582
    x1734 = 2*x1733
    x1735 = -x1192*x1625 - x1199*x1597 + x1607 - x1660 - x1667*x1728 + x1734 - x593
    x1736 = x1093*x597 + x1197*x444 + x1197*x463 + x1670*x596 + x1706*x596
    x1737 = x1610*x600
    x1738 = x1203*x1575 - x1211*x1569 + x1533 - x1737
    x1739 = x600*x9
    x1740 = x1211*x1578 - x1575*x1739 - x1605 + x1615
    x1741 = x1620*x600
    x1742 = -x1203*x1578 + x1569*x1739 + x1636 + x1741 + x22 + x605
    x1743 = x464*x608 + x466*x606 + x468*x603
    x1744 = x1567*x600
    x1745 = 2*x1744
    x1746 = -x1203*x1625 - x1211*x1597 - x1623 - x1667*x1739 + x1714 + x1745 - x611
    x1747 = x1093*x615 + x1209*x444 + x1209*x463 + x1670*x614 + x1706*x614
    x1748 = x94*(x1215*x507 + x499*x618 + x97*(2*x510 + 2*x512 + 2*x514 + 2*x517 + 2*x519 + 2*x524))
    x1749 = x102*(x244 + x27*x495 + x28*x493 + x31*x497)
    x1750 = -x1226
    x1751 = x837*(x1750 + x621)
    x1752 = x15*x1751
    x1753 = x14*x1751
    x1754 = x1*x1753
    x1755 = x1754*x843
    x1756 = x1753*x985
    x1757 = x1752*x44
    x1758 = x1753*x44
    x1759 = x1758*x370
    x1760 = x1758*x282
    x1761 = x122*x1751
    x1762 = x1*x1751
    x1763 = x122*x1762
    x1764 = x833*(-x17*x502 - x456*x492 - x458*x492 - x460*x492 + x478 + x481 - x506)
    x1765 = x1751*x18
    x1766 = x1762*x884
    x1767 = x1765*x44
    x1768 = x1753*x860
    x1769 = x1751*x44
    x1770 = x1769*x371
    x1771 = x1762*x44
    x1772 = x115*x1771
    x1773 = x122*x1769
    x1774 = x1751*x19
    x1775 = x1774*x44
    x1776 = x1762*x841
    x1777 = 3*n1
    x1778 = x1571*(x1750 + x1777)
    x1779 = x1751*x435
    x1780 = x14*x1778
    x1781 = x1042*x1780
    x1782 = x1*x1778
    x1783 = x1042*x1782
    x1784 = x17*x1778
    x1785 = x1577*x1784
    x1786 = x1577*x1780
    x1787 = x1753*x435
    x1788 = x1769*x435
    x1789 = x124*x1778
    x1790 = x1577*x1782
    x1791 = x124*x1751
    x1792 = x1769*x492
    x1793 = x1751*x492
    x1794 = 4*n1
    x1795 = x492*x7
    x1796 = 4*x1574
    x1797 = x1640*x492
    x1798 = x1309*x1797
    x1799 = x1640*x1782
    x1800 = x1753*x492
    x1801 = x1640*x1780
    x1802 = 2*x1032
    x1803 = 2*n1
    x1804 = x1261 + x1803
    x1805 = 2*x1649
    x1806 = -x1805
    x1807 = x1260 - x1803
    x1808 = -x1505 - x1596*x1797
    x1809 = x1751*x530
    x1810 = x530*x7
    x1811 = -x1032*x1797 - x1032*x1810 + x1515 + x1574*x1679 + x1628 + x1645 + x1701
    x1812 = x1640*x530
    x1813 = x1586 + x1637
    x1814 = -x1588 - x1691
    x1815 = x1100 + x1148 + x1309*x1810 - x1574*x1812 - x1683*x492 + x1798 + x1813 + x1814
    x1816 = x1753*x530
    x1817 = -x1661
    x1818 = x1032*x1812 - x1309*x1644 + x1341 - x1684 + x1688*x492 + x1710 + x1817
    x1819 = x1769*x530
    x1820 = x1115 + x1159
    x1821 = x509*x556 + x511*x550 + x513*x552 + x516*x548 + x518*x544 + x523*x546
    x1822 = x1382 + x1502
    x1823 = 2*x1601
    x1824 = 2*x1677
    x1825 = 2*x1600
    x1826 = x1309*x492
    x1827 = x1666*x1812
    x1828 = -x1384 - x1596*x1810 - 2*x1651 - 2*x1680 - x1698*x1826 + x1805 + x1808 + x1823 + x1824 + x1825 - x1827 - 4*x505
    x1829 = x507*x832
    x1830 = x386*x542
    x1831 = x499*x669
    x1832 = x537*x669
    x1833 = x101*x499*x537 + x1138*x538 + x1138*x543 + x1175*x500 + x1175*x508 + x1671*x1832 + x1829*x542 + x1830*x1831
    x1834 = x1574*x492
    x1835 = x1032*x492
    x1836 = x1180*x1834 - x1187*x1835 + x1721 + x1813 + x22 + x569
    x1837 = x1182 + x1187*x1826 - x1712*x1834 - x1715
    x1838 = -x1180*x1826 + x1602 - x1649 + x1712*x1835
    x1839 = x509*x572 + x511*x570 + x513*x567
    x1840 = 2*x1780
    x1841 = 2*x1782
    x1842 = 2*x1708
    x1843 = -x1663
    x1844 = x1802*x492
    x1845 = x1596*x492
    x1846 = x1666*x492
    x1847 = -x1180*x1844 - x1187*x1845 - x1662 - x1712*x1846 + x1842 + x1843 - x576
    x1848 = x1831*x386
    x1849 = x1138*x579 + x1185*x500 + x1185*x508 + x1829*x578 + x1848*x578
    x1850 = x1192*x1834 - x1199*x1835 + x1614 + x1733 + x1817 + x584
    x1851 = -x1730
    x1852 = x1191 + x1199*x1826 + x1649 + x1676 - x1728*x1834 + x1851
    x1853 = -x1192*x1826 + x1628 + x1641 + x1728*x1835
    x1854 = x509*x585 + x511*x590 + x513*x588
    x1855 = -x1585
    x1856 = -x1192*x1844 - x1199*x1845 - 2*x1637 + x1722 + 2*x1725 - x1728*x1846 + x1855 - x594
    x1857 = x1138*x597 + x1197*x500 + x1197*x508 + x1829*x596 + x1848*x596
    x1858 = x1203*x1834 - x1211*x1835 + x1744 + x601
    x1859 = -x1741
    x1860 = x1097 + x1207 + x1211*x1826 + x1638 - x1739*x1834 + x1859
    x1861 = -x1203*x1826 + x1613 + x1661 + x1739*x1835
    x1862 = x509*x606 + x511*x603 + x513*x608
    x1863 = 2*x1737
    x1864 = -x1203*x1844 - x1211*x1845 - x1739*x1846 + x1806 - x1823 + x1863 - x612
    x1865 = x1138*x615 + x1209*x500 + x1209*x508 + x1829*x614 + x1848*x614
    x1866 = x94*(x1215*x542 + x537*x618 + x97*(2*x545 + 2*x547 + 2*x549 + 2*x551 + 2*x553 + 2*x557))
    x1867 = x102*(x251 + x27*x533 + x28*x531 + x31*x535)
    x1868 = -x1417
    x1869 = x837*(x1868 + x728)
    x1870 = x15*x1869
    x1871 = x14*x1869
    x1872 = x1*x1871
    x1873 = x1872*x843
    x1874 = x1871*x985
    x1875 = x1870*x44
    x1876 = x1871*x44
    x1877 = x1876*x370
    x1878 = x1876*x282
    x1879 = x122*x1869
    x1880 = x1*x1869
    x1881 = x122*x1880
    x1882 = x833*(-x1*x540 - x456*x530 - x458*x530 - x460*x530 + x474 - x475 + x522)
    x1883 = x18*x1869
    x1884 = x1880*x884
    x1885 = x1883*x44
    x1886 = x1871*x860
    x1887 = x1869*x44
    x1888 = x1887*x371
    x1889 = x1880*x44
    x1890 = x115*x1889
    x1891 = x122*x1887
    x1892 = x1869*x19
    x1893 = x1892*x44
    x1894 = x1880*x841
    x1895 = 3*n2
    x1896 = x1571*(x1868 + x1895)
    x1897 = x1869*x435
    x1898 = x14*x1896
    x1899 = x1042*x1898
    x1900 = x1*x1896
    x1901 = x1042*x1900
    x1902 = x17*x1896
    x1903 = x1577*x1902
    x1904 = x1577*x1898
    x1905 = x1871*x435
    x1906 = x1887*x435
    x1907 = x124*x1896
    x1908 = x1577*x1900
    x1909 = x124*x1869
    x1910 = x1869*x492
    x1911 = x1640*x1898
    x1912 = x1871*x492
    x1913 = x1887*x492
    x1914 = x1640*x1900
    x1915 = x1887*x530
    x1916 = x1869*x530
    x1917 = 4*n2
    x1918 = x1871*x530
    x1919 = -x1702
    x1920 = 2*n2
    x1921 = x1456 - x1920
    x1922 = 2*x530
    x1923 = x1458 + x1920
    x1924 = x1574*x530
    x1925 = x1187*x530
    x1926 = -x1032*x1925 + x1180*x1924 + x1600 + x1677
    x1927 = x1309*x1925 + x1708 - x1712*x1924 + x564
    x1928 = -x1721
    x1929 = x1032*x530
    x1930 = x1309*x530
    x1931 = x1097 - x1180*x1930 + x1393 + x1712*x1929 + x1814 + x1928
    x1932 = x544*x570 + x546*x567 + x548*x572
    x1933 = 2*x1898
    x1934 = 2*x1900
    x1935 = 2*x1715
    x1936 = x1802*x530
    x1937 = x1666*x530
    x1938 = -x1180*x1936 - x1596*x1925 - x1699 - x1712*x1937 + x1919 + x1935 - x577
    x1939 = x542*x832
    x1940 = x1832*x386
    x1941 = x1175*x579 + x1185*x538 + x1185*x543 + x1939*x578 + x1940*x578
    x1942 = x1192*x1924 - x1199*x1929 + x1629 - x1701
    x1943 = x1199*x1930 + x1692 + x1725 - x1728*x1924 + x22 + x587
    x1944 = -x1192*x1930 + x1398 + x1728*x1929 - x1733
    x1945 = x544*x590 + x546*x588 + x548*x585
    x1946 = 2*x1730
    x1947 = -x1825
    x1948 = x1596*x530
    x1949 = -x1192*x1936 - x1199*x1948 - x1728*x1937 - x1824 + x1946 + x1947 - x595
    x1950 = x1175*x597 + x1197*x538 + x1197*x543 + x1939*x596 + x1940*x596
    x1951 = x1203*x1924 - x1211*x1929 + x1614 + x1710
    x1952 = x1211*x1930 + x1601 + x1678 + x1737 - x1739*x1924 + x602
    x1953 = -x1744
    x1954 = -x1203*x1930 + x1401 + x1641 + x1701 + x1739*x1929 + x1953
    x1955 = x544*x603 + x546*x608 + x548*x606
    x1956 = x1086 - x1203*x1936 - x1211*x1948 - 2*x1691 + x1720 - x1739*x1937 + 2*x1741 + x1855 - x613
    x1957 = x1175*x615 + x1209*x538 + x1209*x543 + x1939*x614 + x1940*x614
    x1958 = x94*(x1215*x578 + x97*(2*x568 + 2*x571 + 2*x573))
    x1959 = x833*(-x1*x566 - x14*x569 - x17*x564 + x554)
    x1960 = x1571*(-x1570 + x838)
    x1961 = x14*x1960
    x1962 = x1042*x1961
    x1963 = x1*x1960
    x1964 = x1042*x1963
    x1965 = x17*x1960
    x1966 = x1577*x1965
    x1967 = x1577*x1961
    x1968 = x124*x1960
    x1969 = x1577*x1963
    x1970 = x1640*x1961
    x1971 = x1640*x1963
    x1972 = -x1935
    x1973 = 2*x1961
    x1974 = 2*x1963
    x1975 = x1725 + x1928
    x1976 = -x1734
    x1977 = -x1842 + x1976
    x1978 = x578*x832
    x1979 = x1185*x597 + x1197*x579 + x1978*x596
    x1980 = x1721 + x1859
    x1981 = -x1745 + x1972
    x1982 = x1185*x615 + x1209*x579 + x1978*x614
    x1983 = x94*(x1215*x596 + x97*(2*x586 + 2*x589 + 2*x591))
    x1984 = x833*(-x1*x583 - x14*x584 - x17*x587 + x479)
    x1985 = x1571*(x1226 - x1777)
    x1986 = x14*x1985
    x1987 = x1042*x1986
    x1988 = x1*x1985
    x1989 = x1042*x1988
    x1990 = x17*x1985
    x1991 = x1577*x1990
    x1992 = x1577*x1986
    x1993 = x124*x1985
    x1994 = x1577*x1988
    x1995 = x1640*x1986
    x1996 = x1640*x1988
    x1997 = 2*x1986
    x1998 = 2*x1988
    x1999 = x1726 + x1741
    x2000 = -x1863
    x2001 = -x1946 + x2000
    x2002 = x1197*x615 + x1209*x597 + x596*x614*x832
    x2003 = x94*(x1215*x614 + x97*(2*x604 + 2*x607 + 2*x609))
    x2004 = x833*(-x1*x605 - x14*x601 - x17*x602 + x520)
    x2005 = x1571*(x1417 - x1895)
    x2006 = x14*x2005
    x2007 = x1042*x2006
    x2008 = x1*x2005
    x2009 = x1042*x2008
    x2010 = x17*x2005
    x2011 = x1577*x2010
    x2012 = x1577*x2006
    x2013 = x124*x2005
    x2014 = x1577*x2008
    x2015 = x1640*x2006
    x2016 = x1640*x2008
    x2017 = 2*x2006
    x2018 = 2*x2008

    return np.array([-x88*x98 - x99*(x101*x78**2 + x103*x78 + x134*(x108*x123 + x109*x124 + x110*x125 + x132 + 4*x72) + x60*x82 + x70*(x25*(x1*x109 - x110*x17 + x112) + x43*(x108*x115 - x109*x14 + x114 + x117) + x51*(-x108*x119 + x110*x14 + x118 + x121))), -x151*x98 - x99*(x103*x149 + x134*(x123*x152 + x124*x153 + x125*x154 + x159) + x163 + x70*(x25*(x1*x153 - x154*x17 + x76) + x43*(x115*x152 - x14*x153 + x158) + x51*(-x119*x152 + x14*x154 + x155))), -x180*x98 - x99*(x103*x178 + x134*(x123*x182 + x124*x183 + x125*x185 + x188) + x189 + x70*(x25*(x1*x183 - x17*x185 + x184) + x43*(x115*x182 - x14*x183 + x181) + x51*(-x119*x182 + x14*x185 + x187))), -x258*x98 - x99*(x103*x219 + x134*(x122*x263 + 2*x297 + 2*x298 + x307 + x54*(x294 + x296)) + x312 + x70*(x25*(x275 - x278 + x284) + x293 + x43*(x17*x263 + x262*x38 - x266 + x274) + x51*(-x1*x263 + x285*x56 + x286 + x292))), -x358*x98 - x99*(x103*x329 + x134*(x124*x359 + 2*x266 + 2*x380 + x385) + x388 + x70*(x25*(x1*x359 - x368 + x373) + x379 + x43*(-x14*x359 + x297 + x365) + x51*(-x275 + x374 + x378))), -x419*x98 - x99*(x103*x399 + x134*(x125*x421 + 2*x286 + 2*x368 + x433) + x434 + x70*(x25*(-x17*x421 + x380 + x425) + x429 + x43*(x278 - x374 + x420) + x51*(x14*x421 - x298 + x428))), -x485*x98 - x99*(x103*x443 + x491), -x526*x98 - x99*(x103*x499 + x529), -x559*x98 - x99*(x103*x537 + x562), -x580*x98 + x581, -x598*x98 + x599, -x616*x98 + x617, -x619*x88 - x99*(x134*(x123*x623 + x159 + x489*x623 + x623*x625) + x163 + x626*x78 + x70*(x25*(-x282*x623 + x370*x623 + x76) + x43*(x115*x623 + x158 - x27*x624) + x51*(-x119*x623 + x155 + x31*x624))), -x151*x619 - x99*(x101*x149**2 + x134*(x123*x627 + x132 + 4*x156 + x489*x627 + x625*x627) + x143*x150 + x149*x626 + x70*(x25*(x112 - x282*x627 + x370*x627 + x630) + x43*(x115*x627 + x117 - x27*x628 + x629) + x51*(-x119*x627 + x121 + x31*x628))), -x180*x619 - x99*(x134*(x123*x631 + x489*x631 + x625*x631 + x637) + x178*x626 + x641 + x70*(x25*(-x282*x631 + x370*x631 + x635) + x43*(x115*x631 - x27*x632 + x633) + x51*(-x119*x631 + x145 + x31*x632))), -x258*x619 - x99*(x134*(x122*x642 + x124*x643 + x125*x652 + x668) + x219*x626 + x671 + x70*(x25*(x651 - x653 + x656) + x43*(-x14*x643 + x17*x642 + x650) + x51*(-x1*x642 + x14*x652 + x661) + x662)), -x358*x619 - x99*(x134*(x122*x643 + x124*x675 + x125*x682 + x38*(x692 + x694) + x697) + x329*x626 + x699 + x70*(x25*(x1*x675 - x17*x682 + x56*x681 + x685) + x43*(-x14*x675 + x17*x643 + x54*x674 + x679) + x51*(-x651 + x686 + x690) + x691)), -x419*x619 - x99*(x134*(x122*x652 + x124*x682 + x125*x701 + x711) + x399*x626 + x70*(x25*(x1*x682 - x17*x701 + x705) + x43*(x653 - x686 + x700) + x51*(-x1*x652 + x14*x701 + x706) + x707) + x712), -x485*x619 - x99*(x443*x626 + x716), -x526*x619 - x99*(x499*x626 + x719), -x559*x619 - x99*(x537*x626 + x722), -x580*x619 + x723, -x598*x619 + x724, -x616*x619 + x725, -x726*x88 - x99*(x134*(x123*x730 + x188 + x489*x730 + x625*x730) + x189 + x70*(x25*(x184 - x282*x730 + x370*x730) + x43*(x115*x730 + x181 - x27*x731) + x51*(-x119*x730 + x187 + x31*x731)) + x732*x78), -x151*x726 - x99*(x134*(x123*x733 + x489*x733 + x625*x733 + x637) + x149*x732 + x641 + x70*(x25*(-x282*x733 + x370*x733 + x635) + x43*(x115*x733 - x27*x734 + x633) + x51*(-x119*x733 + x145 + x31*x734))), -x180*x726 - x99*(x101*x178**2 + x134*(x123*x735 + x132 + 4*x176 + x489*x735 + x625*x735) + x172*x179 + x178*x732 + x70*(x25*(x112 - x282*x735 + x370*x735 + x737) + x43*(x115*x735 + x117 - x27*x736) + x51*(-x119*x735 + x121 + x175 + x31*x736))), -x258*x726 - x99*(x134*(x122*x738 + x124*x739 + x125*x746 + x763) + x219*x732 + x70*(x25*(x745 - x747 + x750) + x43*(-x14*x739 + x17*x738 + x744) + x51*(-x1*x738 + x14*x746 + x756) + x757) + x768), -x358*x726 - x99*(x134*(x122*x739 + x124*x769 + x125*x773 + x786) + x329*x732 + x70*(x25*(x1*x769 - x17*x773 + x778) + x43*(-x14*x769 + x17*x739 + x772) + x51*(-x745 + x779 + x782) + x783) + x788), -x419*x726 - x99*(x134*(x122*x746 + x124*x773 + x125*x793 + x56*(x801 + x803) + x805) + x399*x732 + x70*(x25*(x1*x773 - x17*x793 + x38*x792 + x796) + x43*(x747 - x779 + x789) + x51*(-x1*x746 + x14*x793 + x54*x798 + x799) + x800) + x806), -x485*x726 - x99*(x443*x732 + x810), -x526*x726 - x99*(x499*x732 + x813), -x559*x726 - x99*(x537*x732 + x816), -x580*x726 + x817, -x598*x726 + x818, -x616*x726 + x819, -x821*x88 - x99*(x134*(x123*x824 + 4*x126 + x307 + x489*x824 + x625*x824) + x312 + x70*(x25*(-x282*x824 + x284 + x370*x824) + x293 + x43*(x115*x824 - x27*x825 + x274 + x663) + x51*(-x119*x824 + x292 + x31*x825 + x826)) + x78*x827), -x151*x821 - x99*(x134*(x123*x828 + x489*x828 + x625*x828 + x668) + x149*x827 + x671 + x70*(x25*(-x282*x828 + x370*x828 + x656) + x43*(x115*x828 - x27*x829 + x650) + x51*(-x119*x828 + x31*x829 + x661) + x662)), -x180*x821 - x99*(x134*(x123*x830 + x489*x830 + x625*x830 + x763) + x178*x827 + x70*(x25*(-x282*x830 + x370*x830 + x750) + x43*(x115*x830 - x27*x831 + x744) + x51*(-x119*x830 + x31*x831 + x756) + x757) + x768), -x258*x821 - x99*(x101*x219**2 + x134*(x122*x31*x862 + x122*x856 + x124*x858 + x125*x859 + 4*x15*x855 - 4*x209 - 4*x211 + x301*x857 + x54*(-x294 + x295) + x845*x861 + x853*x854 + x864 + x874) + x201**2*x832 + x201*x834 + x205*x257 + x219*x309*x851 + x219*x827 + x220*x257 + x70*(2*x225*x242 + 2*x229*x248 + 2*x236*x255 + x25*(x891 + x893 - x894 - x895 - x896 + x897 + x902) + x43*(x115*x892 - x14*x858 + x17*x856 - x216 - x27*x857 + x285*x38 + x883*x905 + x904 - x907 + x909 + x914) + x51*(-x1*x856 - x119*x892 + x14*x859 + x218 + x262*x56 + x31*x857 + x888*x915 - x917 - x919 + x920 + x925) + x83*(x195*x883 - x840*x843 + x875*x884 + x886) + x84*(x198*x888 + x840*x846 - x841*x876 + x890) + x85*(x877 - x879 + x881)) + x850*(-x122*x848 + x232*x836 - x840*x842 - x844*x845 + x849)), -x358*x821 - x99*(x134*(x115*x957 + x122*x858 + x124*x932 + x125*x946 + x383*x931 + x696*x936 + x970) + x317*x834 + x329*x827 + x70*(x25*(x1*x932 - x31*x931 - x823*x938 + x937 + x945) + x43*(-x14*x932 + x17*x858 + x28*x931 - x860*x878 + x935) + x51*(-x891 + x895 + x947 - x948 + x955) + x83*(x841*x926 - x843*x878 + x928) + x84*(x879 + x929 - x930) + x85*(x199 + x844*x847 - x846*x926) + x956) + x850*(-x124*x848 - x845*x884 - x926*x971 + x974) + x982), -x419*x821 - x99*(x1025 + x134*(x1005*x823 + x1016 + x119*x957 + x122*x859 + x124*x946 + x432*x989 + 2*x937) + x392*x834 + x399*x827 + x70*(x1004 + x25*(x1*x946 + x27*x989 - x282*x862 - x823*x990 + x998) + x43*(-x893 + x894 - x947 + x948 + x988) + x51*(-x1*x859 + x1000*x876 + x1003 - x28*x989 + x823*x999) + x83*(x334 - x877 + x930) + x84*(-x841*x984 + x846*x876 + x987) + x85*(x843*x984 - x847*x985 + x983)) + x850*(-x1017*x984 - x1018*x122 - x1019*x847 + x1022)), -x485*x821 - x99*(x1094 + x134*(x1027*x1072 + x1058*x123 + x1058*x625 + x1079 + 4*x867) + x443*x827 + x462*x834 + x70*(x1071 + x25*(-x1058*x282 + x1058*x370 + x1065) + x43*(x1058*x115 - x1059*x27 + x1062 + x959) + x51*(x1011 - x1058*x119 + x1059*x31 + x1070) + x83*(x1026 + x1027*x884 - x1028*x875 + x1040) + x84*(-x1018*x435 + x1021 + x1048*x435 + x1057) + x85*(-x1027*x985 + x1028*x847 + x1047)) + x850*(-x1019*x1027 - x1027*x1080 - x1027*x1081 + x1092 - 4*x456)), -x526*x821 - x99*(x1139 + x134*(x1072*x1095 + x1113*x123 + x1113*x625 + x1129) + x499*x827 + x507*x834 + x70*(x1125 + x25*(-x1113*x282 + x1113*x370 + x1121) + x43*(x1113*x115 - x1114*x27 + x1117) + x51*(-x1113*x119 + x1114*x31 + x1124) + x83*(x1095*x884 - x1096*x875 + x1101) + x84*(-x1018*x492 + x1048*x492 + x1112) + x85*(-x1095*x985 + x1096*x847 + x1106)) + x850*(-x1019*x1095 - x1080*x1095 - x1081*x1095 + x1137)), -x559*x821 - x99*(x1176 + x134*(x1072*x1140 + x1150*x123 + x1150*x625 + x1167) + x537*x827 + x542*x834 + x70*(x1162 + x25*(-x1150*x282 + x1150*x370 + x1157) + x43*(x115*x1150 - x1151*x27 + x1154) + x51*(-x1150*x119 + x1151*x31 + x1161) + x83*(x1140*x884 - x1141*x875 + x1143) + x84*(-x1018*x530 + x1048*x530 + x1149) + x85*(-x1140*x985 + x1141*x847 + x1145)) + x850*(-x1019*x1140 - x1080*x1140 - x1081*x1140 + x1174)), -x580*x821 - x99*(x1190 + x578*x834), -x598*x821 - x99*(x1202 + x596*x834), -x616*x821 - x99*(x1214 + x614*x834), -x1216*x88 - x99*(x1221*x78 + x134*(x1219*x123 + x1219*x489 + x1219*x625 + x385) + x388 + x70*(x25*(-x1219*x282 + x1219*x370 + x373) + x379 + x43*(x115*x1219 - x1220*x27 + x365) + x51*(-x119*x1219 + x1220*x31 + x378))), -x1216*x151 - x99*(x1221*x149 + x134*(x1222*x123 + x1222*x489 + x1222*x625 + 4*x128 + x697) + x699 + x70*(x25*(-x1222*x282 + x1222*x370 + x685 + x784) + x43*(x115*x1222 - x1223*x27 + x679 + x960) + x51*(-x119*x1222 + x1223*x31 + x690) + x691)), -x1216*x180 - x99*(x1221*x178 + x134*(x1224*x123 + x1224*x489 + x1224*x625 + x786) + x70*(x25*(-x1224*x282 + x1224*x370 + x778) + x43*(x115*x1224 - x1225*x27 + x772) + x51*(-x119*x1224 + x1225*x31 + x782) + x783) + x788), -x1216*x258 - x99*(x1221*x219 + x1245*x201 + x134*(x1000*x1244 + x1076*x1218 + x1077*x1218 + x122*x1233 + x1234*x301 + x1242*x861 + x970) + x70*(x25*(x1237 + x1238 - x1240 - x1241 + x945) + x43*(x115*x1235 + x1233*x17 - x1234*x27 - x1236*x264 + x935) + x51*(-x1*x1233 - x119*x1235 + x1234*x31 + x1236*x276 + x955) + x83*(-x1228*x843 + x1229*x884 + x928) + x84*(x1228*x846 - x1230*x841 + x929) + x85*(x1231 - x1232 + x199) + x956) + x850*(-x1228*x842 - x1242*x844 - x1244*x846 + x974) + x982), -x1216*x358 - x99*(x101*x329**2 + x1221*x329 + x1245*x317 + x134*(x115*x1257 + x1218*x1252 + x125*x1255 + x1251*x905 + x1253*x383 + x1254*x264 + x1256*x696 + x1258 + 4*x30*x360 - 4*x321 - 4*x323 + x38*(-x692 + x693) + x874) + x317**2*x832 + x319*x357 + x329*x851*x980 + x330*x357 + x70*(x25*(-x1218*x938 + x1218*x939 - x1253*x31 + x1263*x915 + x1269 - x1270 + x1272 + x1273 + x56*x674 - x710 + x902) + 2*x332*x344 + 2*x336*x355 + 2*x340*x350 + x43*(-x1218*x1267 + x1239*x264 + x1253*x28 + x1262*x854 - x1268*x17 + x216 + x54*x681 - x904 + x914 + x964 - x967) + x51*(x1008 - x1015 - x1237 + x1241 + x1264 - x1266 + x925) + x83*(-x1229*x844 + x1248*x841 + x1262*x232 + x886) + x84*(x1232 - x1259 + x890) + x85*(x1243*x844 - x1248*x846 + x1263*x198 + x881)) + x850*(-x1242*x884 - x1243*x1249 + x1247*x195 - x1248*x971 + x849)), -x1216*x419 - x99*(x1221*x399 + x1245*x392 + x1301 + x134*(x1005*x1218 + x119*x1257 + x124*x1255 + x1254*x276 + 2*x1273 + x1278*x432 + x1291) + x70*(x1283 + x25*(-x1218*x990 + x1218*x995 - x1265*x282 + x1278*x27 + x1281) + x43*(-x1238 + x1240 - x1264 + x1266 + x1277) + x51*(x1000*x1230 - x1218*x961 + x1218*x999 - x1278*x28 + x1282) + x83*(x1051 - x1231 + x1259) + x84*(x1230*x846 - x1274*x841 + x227) + x85*(-x1243*x985 + x1274*x843 + x1276)) + x850*(-x1017*x1274 - x1019*x1243 - x122*x1292 + x1295)), -x1216*x485 - x99*(x1221*x443 + x1245*x462 + x1338 + x134*(x1072*x1302 + x123*x1317 + x1302*x1325 + x1330) + x70*(x1324 + x25*(-x1317*x282 + x1317*x370 + x1321) + x43*(x115*x1317 - x1268*x435 + x1320) + x51*(x1000*x1313 - x119*x1317 + x1323) + x83*(-x1028*x1229 + x1302*x884 + x1306) + x84*(-x1292*x435 + x1313*x846 + x1316) + x85*(x1028*x1243 - x1302*x985 + x1312)) + x850*(-x1028*x1331 - x1080*x1302 - x1081*x1302 + x1336)), -x1216*x526 - x99*(x1221*x499 + x1245*x507 + x134*(x1072*x1339 + x123*x1352 + x1325*x1339 + x1360 + 4*x869) + x1366 + x70*(x1359 + x25*(x1285 - x1352*x282 + x1352*x370 + x1356) + x43*(x115*x1352 - x1268*x492 + x1355 + x965) + x51*(x1000*x1350 - x119*x1352 + x1358) + x83*(-x1096*x1229 + x1339*x884 + x1342 + x972) + x84*(-x1292*x492 + x1350*x846 + x1351) + x85*(x1096*x1243 - x1339*x985 + x1343 + x1349)) + x850*(-x1080*x1339 - x1081*x1339 - x1096*x1331 + x1365 - 4*x458)), -x1216*x559 - x99*(x1221*x537 + x1245*x542 + x134*(x1072*x1367 + x123*x1375 + x1325*x1367 + x1383) + x1390 + x70*(x1381 + x25*(-x1375*x282 + x1375*x370 + x1378) + x43*(x115*x1375 - x1268*x530 + x1377) + x51*(x1000*x1372 - x119*x1375 + x1380) + x83*(-x1141*x1229 + x1367*x884 + x1368) + x84*(-x1292*x530 + x1372*x846 + x1374) + x85*(x1141*x1243 - x1367*x985 + x1371)) + x850*(-x1080*x1367 - x1081*x1367 - x1141*x1331 + x1389)), -x1216*x580 - x99*(x1245*x578 + x1395), -x1216*x598 - x99*(x1245*x596 + x1400), -x1216*x616 - x99*(x1245*x614 + x1406), -x1407*x88 - x99*(x134*(x123*x1410 + x1410*x489 + x1410*x625 + x433) + x1412*x78 + x434 + x70*(x25*(-x1410*x282 + x1410*x370 + x425) + x429 + x43*(x115*x1410 - x1411*x27 + x420) + x51*(-x119*x1410 + x1411*x31 + x428))), -x1407*x151 - x99*(x134*(x123*x1413 + x1413*x489 + x1413*x625 + x711) + x1412*x149 + x70*(x25*(-x1413*x282 + x1413*x370 + x705) + x43*(x115*x1413 - x1414*x27 + x700) + x51*(-x119*x1413 + x1414*x31 + x706) + x707) + x712), -x1407*x180 - x99*(x134*(x123*x1415 + 4*x130 + x1415*x489 + x1415*x625 + x805) + x1412*x178 + x70*(x25*(x1286 - x1415*x282 + x1415*x370 + x796) + x43*(x115*x1415 - x1416*x27 + x789) + x51*(-x119*x1415 + x1416*x31 + x430 + x799) + x800) + x806), -x1407*x258 - x99*(x1025 + x134*(x1000*x1435 + x1016 + x1076*x1409 + x1077*x1409 + x122*x1424 + x1425*x301 + x1433*x861) + x1412*x219 + x1436*x201 + x70*(x1004 + x25*(x1428 + x1429 - x1431 - x1432 + x998) + x43*(x115*x1426 + x1424*x17 - x1425*x27 - x1427*x264 + x988) + x51*(-x1*x1424 + x1003 - x119*x1426 + x1425*x31 + x1427*x276) + x83*(-x1419*x843 + x1420*x884 + x334) + x84*(x1419*x846 - x1421*x841 + x987) + x85*(x1422 - x1423 + x983)) + x850*(x1022 - x1419*x842 - x1433*x844 - x1435*x846)), -x1407*x358 - x99*(x1301 + x134*(x115*x1447 + x1252*x1409 + x1291 + x1329*x1409 + x1439*x383 + x1441*x696 + x1446*x264) + x1412*x329 + x1436*x317 + x70*(x1283 + x25*(x1281 - x1409*x938 + x1409*x939 - x1439*x31 + x1442) + x43*(-x1267*x1409 + x1277 + x1430*x264 + x1439*x28 - x1440*x17) + x51*(x1282 - x1428 + x1432 + x1443 - x1445) + x83*(x1051 - x1420*x844 + x1437*x841) + x84*(x1423 - x1438 + x227) + x85*(x1276 + x1434*x844 - x1437*x846)) + x850*(-x1249*x1434 + x1295 - x1433*x884 - x1437*x971)), -x1407*x419 - x99*(x101*x399**2 + x1299*x399*x851 + x134*(x1005*x1409 + x119*x1447 + x1258 + x132 + x1409*x1455 + 2*x1442 + x1446*x276 + x1453*x915 + x1454*x432 + 4*x32*x423 - 4*x395 - 4*x397 + x56*(-x801 + x802) + x864 + x865 + x873) + x1412*x399 + x1436*x392 + x392**2*x832 + x393*x418 + x400*x418 + x70*(x25*(-x1269 + x1287 - x1290 - x1409*x990 + x1409*x995 - x1444*x282 + x1454*x27 + x1459*x905 + x38*x798 + x710 + x902) + 2*x401*x409 + 2*x403*x412 + 2*x407*x416 + x43*(-x1429 + x1431 - x1443 + x1445 + x914 + x962 - x969) + x51*(x1000*x1421 + x1010 - x1013 - x1409*x961 + x1409*x999 - x1454*x28 + x1457*x854 - x218 + x54*x792 + x917 + x925) + x83*(-x1422 + x1438 + x886) + x84*(x1421*x846 - x1450*x841 + x1457*x232 + x890) + x85*(-x1434*x985 + x1450*x843 + x1459*x195 + x881)) + x850*(-x1017*x1450 - x1019*x1434 - x122*x1451 + x1449*x198 + x849)), -x1407*x485 - x99*(x134*(x1072*x1460 + x123*x1470 + x1325*x1460 + x1476) + x1412*x443 + x1436*x462 + x1488 + x70*(x1474 + x25*(-x1470*x282 + x1470*x370 + x1472) + x43*(x115*x1470 - x1440*x435 + x1471) + x51*(x1000*x1466 - x119*x1470 + x1473) + x83*(-x1028*x1420 + x1460*x884 + x1461) + x84*(-x1451*x435 + x1466*x846 + x1469) + x85*(x1028*x1434 - x1460*x985 + x1465)) + x850*(-x1028*x1477 - x1080*x1460 - x1081*x1460 + x1482)), -x1407*x526 - x99*(x134*(x1072*x1489 + x123*x1496 + x1325*x1489 + x1504) + x1412*x499 + x1436*x507 + x1509 + x70*(x1501 + x25*(-x1496*x282 + x1496*x370 + x1499) + x43*(x115*x1496 - x1440*x492 + x1497) + x51*(x1000*x1494 - x119*x1496 + x1500) + x83*(-x1096*x1420 + x1489*x884 + x1490) + x84*(-x1451*x492 + x1494*x846 + x1495) + x85*(x1096*x1434 - x1489*x985 + x1493)) + x850*(-x1080*x1489 - x1081*x1489 - x1096*x1477 + x1507)), -x1407*x559 - x99*(x134*(x1072*x1510 + x123*x1517 + x1325*x1510 + x1523 + 4*x871) + x1412*x537 + x1436*x542 + x1527 + x70*(x1522 + x25*(x1288 - x1517*x282 + x1517*x370 + x1520) + x43*(x115*x1517 - x1440*x530 + x1518) + x51*(x1000*x1514 + x1007 - x119*x1517 + x1521) + x83*(-x1141*x1420 + x1510*x884 + x1511) + x84*(-x1451*x530 + x1478 + x1514*x846 + x1516) + x85*(x1141*x1434 + x1293 - x1510*x985 + x1513)) + x850*(-x1080*x1510 - x1081*x1510 - x1141*x1477 + x1526 - 4*x460)), -x1407*x580 - x99*(x1436*x578 + x1530), -x1407*x598 - x99*(x1436*x596 + x1532), -x1407*x616 - x99*(x1436*x614 + x1534), -x1535*x88 - x99*(x1536*x78 + x491), -x151*x1535 - x99*(x149*x1536 + x716), -x1535*x180 - x99*(x1536*x178 + x810), -x1535*x258 - x99*(x1094 + x134*(x1000*x1550 + x1079 + x1544*x301 + x1548*x861 + x836*x854) + x1536*x219 + x1551*x201 + x70*(x1071 + x25*(x1065 + x1546 - x1547) + x43*(x1062 + x115*x1545 - x1544*x27 + x888*x905) + x51*(x1070 - x119*x1545 + x1544*x31 + x883*x915) + x83*(x1040 - x1539*x843 + x1540*x884 + x195*x888) + x84*(x1057 + x1539*x846 - x1541*x841 + x198*x883) + x85*(x1047 + x1542 - x1543)) + x850*(x1092 - x1539*x842 - x1548*x844 - x1550*x846 + x232*x853)), -x1535*x358 - x99*(x1338 + x134*(x115*x1560 + x1330 + x1554*x383 + x1556*x696) + x1536*x329 + x1551*x317 + x70*(x1324 + x25*(x1321 - x1554*x31 + x1557) + x43*(x1320 + x1554*x28 - x1555*x17) + x51*(x1323 + x1547 - x1559) + x83*(x1306 - x1540*x844 + x1552*x841) + x84*(x1316 + x1543 - x1553) + x85*(x1312 + x1549*x844 - x1552*x846)) + x850*(-x1249*x1549 + x1336 - x1548*x884 - x1552*x971)), -x1535*x419 - x99*(x134*(x119*x1560 + x1476 + 2*x1557 + x1562*x432) + x1488 + x1536*x399 + x1551*x392 + x70*(x1474 + x25*(x1472 - x1558*x282 + x1562*x27) + x43*(x1471 - x1546 + x1559) + x51*(x1000*x1541 + x1473 - x1562*x28) + x83*(x1461 - x1542 + x1553) + x84*(x1469 + x1541*x846 - x1561*x841) + x85*(x1465 - x1549*x985 + x1561*x843)) + x850*(-x1017*x1561 - x1019*x1549 - x122*x1563 + x1482)), -x1535*x485 - x99*(x101*x443**2 + x134*(x1072*x1565 + 4*x1073 + x123*x1564 + x1325*x1565 + x873) + x1486*x443*x851 + x1536*x443 + x1551*x462 + x444*x484 + x462**2*x832 + x463*x484 + x70*(x25*(-x1564*x282 + x1564*x370 + x901) + x43*(x115*x1564 + x1327 - x1555*x435 + x913) + 2*x464*x472 + 2*x466*x476 + 2*x468*x482 + x51*(x1000*x1592 - x119*x1564 + x1475 + x924) + x83*(-x1028*x1540 + x1033*x1572 - x1134 + x1565*x884 + x1598*x1611 + x1607 + x1609*x1610 - x1612 + x1617 + x1618) + x84*(-x1083*x1578 + x1171 + x1479 - x1563*x435 - x1581*x6 + x1592*x846 + x1619*x1620 + x1623 + x1624 + x1626 + x1631) + x85*(x1028*x1549 + x1309*x1599 - x1565*x985 - x1577*x1597 + x1593 - x1595 + x1604)) + x850*(-x1028*x1583 - x1042*x1580 - x1080*x1565 - x1081*x1565 - x1083*x1573 - 4*x1084 + x1567*(x1566 + x852) + 4*x1568 - 4*x1569*x6 - 4*x1576 - 4*x1579 - 2*x1582 + x1591 - 4*x449)), -x1535*x526 - x99*(x134*(x1072*x1632 + x123*x1654 + x1325*x1632 + x1657) + x1536*x499 + x1551*x507 + x1674 + x70*(x1656 + x25*(x1067 - x1654*x282 + x1654*x370) + x43*(x115*x1654 - x1555*x492 + x1655) + x51*(x1000*x1648 + x1122 - x119*x1654) + x83*(x1042*x1594 - x1096*x1540 - x1573*x7 + x1632*x884 + x1639) + x84*(-x1563*x492 - x1593 + x1647 + x1648*x846 + x1653) + x85*(x1096*x1549 + x1581*x7 - x1594*x1640 - x1632*x985 + x1646)) + x850*(-x1080*x1632 - x1081*x1632 - x1096*x1583 - x1572*x1658 - 2*x1612 - 2*x1659 + x1668)), -x1535*x559 - x99*(x134*(x1072*x1675 + x123*x1694 + x1325*x1675 + x1697) + x1536*x537 + x1551*x542 + x1707 + x70*(x1696 + x25*(x1060 - x1694*x282 + x1694*x370) + x43*(x115*x1694 + x1519 - x1555*x530) + x51*(x1000*x1687 - x119*x1694 + x1695) + x83*(-x1141*x1540 + x1595 - x1647 + x1675*x884 + x1681) + x84*(x10*x1573 - x1563*x530 - x1582 + x1687*x846 + x1693) + x85*(x1141*x1549 - x1572*x1682 + x1659 - x1675*x985 + x1686)) + x850*(-x1080*x1675 - x1081*x1675 - x1141*x1583 - x1580*x1640 - x1581*x1698 - 2*x1624 + x1705)), -x1535*x580 - x99*(x1551*x578 + x1724 + x70*(x1717 + x83*(x1180*x1594 - x1187*x1573 + x1660 + x1711) + x84*(-x1180*x1581 + x1573*x1712 + x1714 + x1716) + x85*(x1187*x1581 - x1594*x1712 + x1713)) + x850*(-x1180*x1718 - x1187*x1580 - 4*x1584 - x1712*x1719 + x1723)), -x1535*x598 - x99*(x1551*x596 + x1736 + x70*(x1732 + x83*(x1192*x1594 - x1199*x1573 + x1727) + x84*(-x1192*x1581 + x1573*x1728 + x1731) + x85*(x1199*x1581 - x1594*x1728 + x1729)) + x850*(-x1192*x1718 - x1199*x1580 - x1719*x1728 + x1735)), -x1535*x616 - x99*(x1551*x614 + x1747 + x70*(x1743 + x83*(x1203*x1594 - x1211*x1573 + x1738) + x84*(-x1203*x1581 + x1573*x1739 + x1742) + x85*(x1211*x1581 - x1594*x1739 + x1740)) + x850*(-x1203*x1718 - x1211*x1580 - x1719*x1739 + x1746)), -x1748*x88 - x99*(x1749*x78 + x529), -x151*x1748 - x99*(x149*x1749 + x719), -x1748*x180 - x99*(x1749*x178 + x813), -x1748*x258 - x99*(x1139 + x134*(x1000*x1763 + x1129 + x1757*x301 + x1761*x861) + x1749*x219 + x1764*x201 + x70*(x1125 + x25*(x1121 + x1759 - x1760) + x43*(x1117 + x115*x1758 - x1757*x27) + x51*(x1124 - x119*x1758 + x1757*x31) + x83*(x1101 - x1752*x843 + x1753*x884) + x84*(x1112 + x1752*x846 - x1754*x841) + x85*(x1106 + x1755 - x1756)) + x850*(x1137 - x1752*x842 - x1761*x844 - x1763*x846)), -x1748*x358 - x99*(x134*(x115*x1773 + x1247*x905 + x1360 + x1767*x383 + x1769*x696) + x1366 + x1749*x329 + x1764*x317 + x70*(x1359 + x25*(x1262*x915 + x1356 - x1767*x31 + x1770) + x43*(x1263*x854 + x1355 - x17*x1768 + x1767*x28) + x51*(x1358 + x1760 - x1772) + x83*(x1263*x232 + x1342 - x1753*x844 + x1765*x841) + x84*(x1351 + x1756 - x1766) + x85*(x1262*x198 + x1349 + x1762*x844 - x1765*x846)) + x850*(-x1249*x1762 + x1251*x195 + x1365 - x1761*x884 - x1765*x971)), -x1748*x419 - x99*(x134*(x119*x1773 + x1504 + 2*x1770 + x1775*x432) + x1509 + x1749*x399 + x1764*x392 + x70*(x1501 + x25*(x1499 - x1771*x282 + x1775*x27) + x43*(x1497 - x1759 + x1772) + x51*(x1000*x1754 + x1500 - x1775*x28) + x83*(x1490 - x1755 + x1766) + x84*(x1495 + x1754*x846 - x1774*x841) + x85*(x1493 - x1762*x985 + x1774*x843)) + x850*(-x1017*x1774 - x1019*x1762 - x122*x1776 + x1507)), -x1748*x485 - x99*(x134*(x1072*x1779 + x123*x1788 + x1325*x1779 + x1657) + x1674 + x1749*x443 + x1764*x462 + x70*(x1656 + x25*(x1067 - x1788*x282 + x1788*x370) + x43*(x115*x1788 + x1655 - x1768*x435) + x51*(x1000*x1787 + x1122 - x119*x1788) + x83*(-x1028*x1753 + x1033*x1778 + x1639 + x1779*x884 - x1781) + x84*(x1653 - x1776*x435 - x1782*x6 + x1786 + x1787*x846) + x85*(x1028*x1762 + x1646 - x1779*x985 + x1783 - x1785)) + x850*(-x1028*x1791 - x1042*x1789 - x1080*x1779 - x1081*x1779 - x1083*x1780 + x1668 - 2*x1790)), -x1748*x526 - x99*(x101*x499**2 + x134*(x1072*x1793 + 4*x1115 + x123*x1792 + x1325*x1793 + x873) + x1671*x499*x851 + x1749*x499 + x1764*x507 + x500*x525 + x507**2*x832 + x508*x525 + x70*(x25*(x1503 - x1792*x282 + x1792*x370 + x901) + x43*(x1127 + x115*x1792 - x1768*x492 + x913) + 2*x509*x516 + x51*(x1000*x1800 - x119*x1792 + x924) + 2*x511*x518 + 2*x513*x523 + x83*(x1042*x1784 - x1096*x1753 + x1131 + x1134 + x1567*x1804 + x1617 + x1662 + x1665 - x1780*x7 + x1793*x884 - x1795*x1802) + x84*(x1631 - 2*x1643 - x1776*x492 - x1783 + x1797*x1802 + x1800*x846 + x1801) + x85*(x1096*x1762 - x1386 + x1604 + x1620*x1807 - x1640*x1784 + x1666*x1795 + x1782*x7 - x1793*x985 + x1806 + x1808)) + x850*(-x1080*x1793 - x1081*x1793 - x1096*x1791 - 4*x1099 + x1591 + x1610*(x1250 + x1794) - 4*x1635 + 4*x1637 - x1658*x1778 - 2*x1781 - x1795*x1796 - 4*x1798 - 2*x1799 - 4*x502)), -x1748*x559 - x99*(x134*(x1072*x1809 + x123*x1819 + x1325*x1809 + x1822) + x1749*x537 + x1764*x542 + x1833 + x70*(x1821 + x25*(-x1819*x282 + x1819*x370 + x1820) + x43*(x115*x1819 + x1163 - x1768*x530) + x51*(x1000*x1816 - x119*x1819 + x1353) + x83*(-x1141*x1753 + x1785 - x1801 + x1809*x884 + x1811) + x84*(x10*x1780 - x1776*x530 - x1790 + x1816*x846 + x1818) + x85*(x1141*x1762 - x1682*x1778 + x1799 - x1809*x985 + x1815)) + x850*(-x1080*x1809 - x1081*x1809 - x1141*x1791 - x1640*x1789 - x1698*x1782 - 2*x1786 + x1828)), -x1748*x580 - x99*(x1764*x578 + x1849 + x70*(x1839 + x83*(x1180*x1784 - x1187*x1780 + x1836) + x84*(-x1180*x1782 + x1712*x1780 + x1838) + x85*(x1187*x1782 - x1712*x1784 + x1837)) + x850*(-x1180*x1840 - x1187*x1789 - x1712*x1841 + x1847)), -x1748*x598 - x99*(x1764*x596 + x1857 + x70*(x1854 + x83*(x1192*x1784 - x1199*x1780 + x1843 + x1850) + x84*(-x1192*x1782 + x1728*x1780 + x1853) + x85*(x1199*x1782 - x1728*x1784 + x1823 + x1852)) + x850*(-x1192*x1840 - x1199*x1789 - 4*x1586 - x1728*x1841 + x1856)), -x1748*x616 - x99*(x1764*x614 + x1865 + x70*(x1862 + x83*(x1203*x1784 - x1211*x1780 + x1858) + x84*(-x1203*x1782 + x1739*x1780 + x1861) + x85*(x1211*x1782 - x1739*x1784 + x1860)) + x850*(-x1203*x1840 - x1211*x1789 - x1739*x1841 + x1864)), -x1866*x88 - x99*(x1867*x78 + x562), -x151*x1866 - x99*(x149*x1867 + x722), -x180*x1866 - x99*(x178*x1867 + x816), -x1866*x258 - x99*(x1176 + x134*(x1000*x1881 + x1167 + x1875*x301 + x1879*x861) + x1867*x219 + x1882*x201 + x70*(x1162 + x25*(x1157 + x1877 - x1878) + x43*(x115*x1876 + x1154 - x1875*x27) + x51*(x1161 - x119*x1876 + x1875*x31) + x83*(x1143 - x1870*x843 + x1871*x884) + x84*(x1149 + x1870*x846 - x1872*x841) + x85*(x1145 + x1873 - x1874)) + x850*(x1174 - x1870*x842 - x1879*x844 - x1881*x846)), -x1866*x358 - x99*(x134*(x115*x1891 + x1383 + x1885*x383 + x1887*x696) + x1390 + x1867*x329 + x1882*x317 + x70*(x1381 + x25*(x1378 - x1885*x31 + x1888) + x43*(x1377 - x17*x1886 + x1885*x28) + x51*(x1380 + x1878 - x1890) + x83*(x1368 - x1871*x844 + x1883*x841) + x84*(x1374 + x1874 - x1884) + x85*(x1371 + x1880*x844 - x1883*x846)) + x850*(-x1249*x1880 + x1389 - x1879*x884 - x1883*x971)), -x1866*x419 - x99*(x134*(x119*x1891 + x1449*x915 + x1523 + 2*x1888 + x1893*x432) + x1527 + x1867*x399 + x1882*x392 + x70*(x1522 + x25*(x1457*x905 + x1520 - x1889*x282 + x1893*x27) + x43*(x1518 - x1877 + x1890) + x51*(x1000*x1872 + x1459*x854 + x1521 - x1893*x28) + x83*(x1511 - x1873 + x1884) + x84*(x1459*x232 + x1516 + x1872*x846 - x1892*x841) + x85*(x1457*x195 + x1513 - x1880*x985 + x1892*x843)) + x850*(-x1017*x1892 - x1019*x1880 - x122*x1894 + x1453*x198 + x1526)), -x1866*x485 - x99*(x134*(x1072*x1897 + x123*x1906 + x1325*x1897 + x1697) + x1707 + x1867*x443 + x1882*x462 + x70*(x1696 + x25*(x1060 - x1906*x282 + x1906*x370) + x43*(x115*x1906 + x1519 - x1886*x435) + x51*(x1000*x1905 - x119*x1906 + x1695) + x83*(-x1028*x1871 + x1033*x1896 + x1681 + x1897*x884 - x1899) + x84*(x1693 - x1894*x435 - x1900*x6 + x1904 + x1905*x846) + x85*(x1028*x1880 + x1686 - x1897*x985 + x1901 - x1903)) + x850*(-x1028*x1909 - x1042*x1907 - x1080*x1897 - x1081*x1897 - x1083*x1898 + x1705 - 2*x1908)), -x1866*x526 - x99*(x134*(x1072*x1910 + x123*x1913 + x1325*x1910 + x1822) + x1833 + x1867*x499 + x1882*x507 + x70*(x1821 + x25*(x1820 - x1913*x282 + x1913*x370) + x43*(x115*x1913 + x1163 - x1886*x492) + x51*(x1000*x1912 - x119*x1913 + x1353) + x83*(x1042*x1902 - x1096*x1871 + x1811 - x1898*x7 + x1910*x884) + x84*(x1818 - x1894*x492 - x1901 + x1911 + x1912*x846) + x85*(x1096*x1880 - x1640*x1902 + x1815 + x1900*x7 - x1910*x985)) + x850*(-x1080*x1910 - x1081*x1910 - x1096*x1909 - x1658*x1896 + x1828 - 2*x1899 - 2*x1914)), -x1866*x559 - x99*(x101*x537**2 + x134*(x1072*x1916 + 4*x1158 + x123*x1915 + x1325*x1916 + x873) + x1830*x537*x851 + x1867*x537 + x1882*x542 + x538*x558 + x542**2*x832 + x543*x558 + x70*(x25*(x1382 - x1915*x282 + x1915*x370 + x901) + x43*(x115*x1915 - x1886*x530 + x913) + x51*(x1000*x1918 + x1165 - x119*x1915 + x924) + 2*x544*x550 + 2*x546*x552 + 2*x548*x556 + x83*(-x1141*x1871 + x1596*x1685 + x1617 - x1802*x1812 + x1903 - x1911 + x1916*x884) + x84*(x10*x1898 - x1171 + x1567*x1921 + x1631 + x1688*x1922 + x1704 - x1894*x530 - x1908 + x1918*x846 + x1919) + x85*(x1141*x1880 + x1384 + x1386 + x1604 + x1610*x1923 - x1682*x1896 - x1683*x1922 + x1824 + x1827 + x1914 - x1916*x985)) + x850*(-x1080*x1916 - x1081*x1916 - x1141*x1909 - 4*x1147 + x1591 + x1620*(x1452 + x1917) - x1640*x1907 - 4*x1689 + 4*x1691 - x1698*x1900 - 4*x1703*x530 - x1796*x1812 - 2*x1904 - 4*x540)), -x1866*x580 - x99*(x1882*x578 + x1941 + x70*(x1932 + x83*(x1180*x1902 - x1187*x1898 + x1926) + x84*(-x1180*x1900 + x1712*x1898 + x1931) + x85*(x1187*x1900 - x1712*x1902 + x1927)) + x850*(-x1180*x1933 - x1187*x1907 - x1712*x1934 + x1938)), -x1866*x598 - x99*(x1882*x596 + x1950 + x70*(x1945 + x83*(x1192*x1902 - x1199*x1898 + x1942) + x84*(-x1192*x1900 + x1728*x1898 + x1944) + x85*(x1199*x1900 - x1728*x1902 + x1943)) + x850*(-x1192*x1933 - x1199*x1907 - x1728*x1934 + x1949)), -x1866*x616 - x99*(x1882*x614 + x1957 + x70*(x1955 + x83*(x1203*x1902 - x1211*x1898 + x1951) + x84*(-x1203*x1900 + x1699 + x1739*x1898 + x1954) + x85*(x1211*x1900 - x1739*x1902 + x1947 + x1952)) + x850*(-x1203*x1933 - x1211*x1907 - 4*x1588 - x1739*x1934 + x1956)), -x1958*x88 + x581, -x151*x1958 + x723, -x180*x1958 + x817, -x1958*x258 - x99*(x1190 + x1959*x201), -x1958*x358 - x99*(x1395 + x1959*x317), -x1958*x419 - x99*(x1530 + x1959*x392), -x1958*x485 - x99*(x1724 + x1959*x462 + x70*(x1717 + x83*(x1033*x1960 + x1610*x1619 + x1711 - x1962) + x84*(x1609*x1620 + x1716 - x1963*x6 + x1967) + x85*(x1713 + x1964 - x1966)) + x850*(-x1042*x1968 - x1083*x1961 + x1567*(-x1566 + x835) + x1723 - 2*x1969)), -x1958*x526 - x99*(x1849 + x1959*x507 + x70*(x1839 + x83*(x1042*x1965 + x1836 - x1961*x7) + x84*(x1838 - x1964 + x1970) + x85*(-x1640*x1965 + x1837 + x1963*x7)) + x850*(-x1658*x1960 + x1847 - 2*x1962 - 2*x1971)), -x1958*x559 - x99*(x1941 + x1959*x542 + x70*(x1932 + x83*(x1926 + x1966 - x1970) + x84*(x10*x1961 + x1931 - x1969) + x85*(-x1682*x1960 + x1927 + x1971)) + x850*(-x1640*x1968 - x1698*x1963 + x1938 - 2*x1967)), -x1958*x580 - x99*(x1959*x578 + x574*x579 + x578**2*x832 + x70*(x83*(x1180*x1965 - x1187*x1961 + x1616 + x1842) + x84*(-x1180*x1963 + x1630 + x1712*x1961 + x1972) + x85*(x1187*x1963 + x1603 - x1712*x1965)) + x850*(-x1180*x1973 - x1187*x1968 + x1590 - x1712*x1974 - 4*x1721)), -x1958*x598 - x99*(x1959*x596 + x1979 + x70*(x83*(x1192*x1965 - x1199*x1961 + x1975) + x84*(-x1192*x1963 + x1728*x1961 + x1851) + x85*(x1199*x1963 + x1715 - x1728*x1965)) + x850*(-x1192*x1973 - x1199*x1968 - x1728*x1974 + x1977)), -x1958*x616 - x99*(x1959*x614 + x1982 + x70*(x83*(x1203*x1965 - x1211*x1961 + x1737) + x84*(-x1203*x1963 + x1739*x1961 + x1980) + x85*(x1211*x1963 + x1709 - x1739*x1965)) + x850*(-x1203*x1973 - x1211*x1968 - x1739*x1974 + x1981)), -x1983*x88 + x599, -x151*x1983 + x724, -x180*x1983 + x818, -x1983*x258 - x99*(x1202 + x1984*x201), -x1983*x358 - x99*(x1400 + x1984*x317), -x1983*x419 - x99*(x1532 + x1984*x392), -x1983*x485 - x99*(x1736 + x1984*x462 + x70*(x1732 + x83*(x1033*x1985 + x1727 - x1987) + x84*(x1731 - x1988*x6 + x1992) + x85*(x1729 + x1989 - x1991)) + x850*(-x1042*x1993 - x1083*x1986 + x1735 - 2*x1994)), -x1983*x526 - x99*(x1857 + x1984*x507 + x70*(x1854 + x83*(x1042*x1990 + x1567*x1807 + x1850 - x1986*x7) + x84*(x1853 - x1989 + x1995) + x85*(x1620*x1804 - x1640*x1990 + x1852 + x1988*x7)) + x850*(x1610*(x1246 - x1794) - x1658*x1985 + x1856 - 2*x1987 - 2*x1996)), -x1983*x559 - x99*(x1950 + x1984*x542 + x70*(x1945 + x83*(x1942 + x1991 - x1995) + x84*(x10*x1986 + x1944 - x1994) + x85*(-x1682*x1985 + x1943 + x1996)) + x850*(-x1640*x1993 - x1698*x1988 + x1949 - 2*x1992)), -x1983*x580 - x99*(x1979 + x1984*x578 + x70*(x83*(x1180*x1990 - x1187*x1986 + x1975) + x84*(-x1180*x1988 + x1712*x1986 + x1851) + x85*(x1187*x1988 - x1712*x1990 + x1715)) + x850*(-x1180*x1997 - x1187*x1993 - x1712*x1998 + x1977)), -x1983*x598 - x99*(x1984*x596 + x592*x597 + x596**2*x832 + x70*(x83*(x1192*x1990 - x1199*x1986 + x1616 + x1976) + x84*(-x1192*x1988 + x1630 + x1728*x1986) + x85*(x1199*x1988 + x1603 - x1728*x1990 + x1946)) + x850*(-x1192*x1997 - x1199*x1993 + x1590 - 4*x1725 - x1728*x1998)), -x1983*x616 - x99*(x1984*x614 + x2002 + x70*(x83*(x1203*x1990 - x1211*x1986 + x1953) + x84*(-x1203*x1988 + x1733 + x1739*x1986) + x85*(x1211*x1988 - x1739*x1990 + x1999)) + x850*(-x1203*x1997 - x1211*x1993 - x1739*x1998 + x2001)), -x2003*x88 + x617, -x151*x2003 + x725, -x180*x2003 + x819, -x2003*x258 - x99*(x1214 + x2004*x201), -x2003*x358 - x99*(x1406 + x2004*x317), -x2003*x419 - x99*(x1534 + x2004*x392), -x2003*x485 - x99*(x1747 + x2004*x462 + x70*(x1743 + x83*(x1033*x2005 + x1738 - x2007) + x84*(x1742 - x2008*x6 + x2012) + x85*(x1740 + x2009 - x2011)) + x850*(-x1042*x2013 - x1083*x2006 + x1746 - 2*x2014)), -x2003*x526 - x99*(x1865 + x2004*x507 + x70*(x1862 + x83*(x1042*x2010 + x1858 - x2006*x7) + x84*(x1861 - x2009 + x2015) + x85*(-x1640*x2010 + x1860 + x2008*x7)) + x850*(-x1658*x2005 + x1864 - 2*x2007 - 2*x2016)), -x2003*x559 - x99*(x1957 + x2004*x542 + x70*(x1955 + x83*(x1951 + x2011 - x2015) + x84*(x10*x2006 + x1567*x1923 + x1954 - x2014) + x85*(x1610*x1921 - x1682*x2005 + x1952 + x2016)) + x850*(x1620*(x1448 - x1917) - x1640*x2013 - x1698*x2008 + x1956 - 2*x2012)), -x2003*x580 - x99*(x1982 + x2004*x578 + x70*(x83*(x1180*x2010 - x1187*x2006 + x1737) + x84*(-x1180*x2008 + x1712*x2006 + x1980) + x85*(x1187*x2008 + x1709 - x1712*x2010)) + x850*(-x1180*x2017 - x1187*x2013 - x1712*x2018 + x1981)), -x2003*x598 - x99*(x2002 + x2004*x596 + x70*(x83*(x1192*x2010 - x1199*x2006 + x1953) + x84*(-x1192*x2008 + x1728*x2006 + x1733) + x85*(x1199*x2008 - x1728*x2010 + x1999)) + x850*(-x1192*x2017 - x1199*x2013 - x1728*x2018 + x2001)), -x2003*x616 - x99*(x2004*x614 + x610*x615 + x614**2*x832 + x70*(x83*(x1203*x2010 - x1211*x2006 + x1616) + x84*(-x1203*x2008 + x1630 + x1739*x2006 + x1745) + x85*(x1211*x2008 + x1603 - x1739*x2010 + x2000)) + x850*(-x1203*x2017 - x1211*x2013 + x1590 - x1739*x2018 - 4*x1741))], dtype=np.float64)


def q_d2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion2"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -m0 + o0
    x1 = -o2 + p2
    x2 = -p2
    x3 = -o1 + p1
    x4 = x1*(-n1 + p1) + x3*(n2 + x2)
    x5 = -o0 + p0
    x6 = mpmath.sqrt(x1**2 + x3**2 + x5**2)
    x7 = -m1 + o1
    x8 = -p0
    x9 = x1*(n0 + x8) + x5*(-n2 + p2)
    x10 = -m2 + o2
    x11 = -p1
    x12 = x3*(-n0 + p0) + x5*(n1 + x11)

    return mpmath.atan2(x0*x4*x6 + x10*x12*x6 + x6*x7*x9, x12*(x0*x3 + x7*(o0 + x8)) + x4*(x1*x7 + x10*(o1 + x11)) + x9*(x0*(o2 + x2) + x10*x5))


def dq_d2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion2, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -n1
    x1 = p1 + x0
    x2 = -o2
    x3 = p2 + x2
    x4 = -p2
    x5 = n2 + x4
    x6 = -o1
    x7 = p1 + x6
    x8 = x1*x3 + x5*x7
    x9 = -o0
    x10 = p0 + x9
    x11 = mpmath.sqrt(x10**2 + x3**2 + x7**2)
    x12 = x11*x8
    x13 = -m0
    x14 = o0 + x13
    x15 = x14*x7
    x16 = -m1
    x17 = o1 + x16
    x18 = -p0
    x19 = o0 + x18
    x20 = x17*x19
    x21 = x15 + x20
    x22 = -n0
    x23 = p0 + x22
    x24 = -p1
    x25 = n1 + x24
    x26 = x10*x25 + x23*x7
    x27 = o2 + x4
    x28 = x14*x27
    x29 = -m2
    x30 = o2 + x29
    x31 = x10*x30
    x32 = x28 + x31
    x33 = n0 + x18
    x34 = -n2
    x35 = p2 + x34
    x36 = x10*x35 + x3*x33
    x37 = x17*x3
    x38 = o1 + x24
    x39 = x30*x38
    x40 = x37 + x39
    x41 = x21*x26 + x32*x36 + x40*x8
    x42 = x12*x14
    x43 = x11*x36
    x44 = x17*x43
    x45 = x11*x26
    x46 = x30*x45
    x47 = (x41**2 + (x42 + x44 + x46)**2)**(-1)
    x48 = x41*x47
    x49 = x47*(-x42 - x44 - x46)
    x50 = x11*x17
    x51 = x11*x30
    x52 = x11**(-1)
    x53 = x19*x52
    x54 = x14*x8
    x55 = x36*x52
    x56 = x26*x30
    x57 = x11*x14
    x58 = x52*x54
    x59 = x17*x55
    x60 = x26*x52
    x61 = x52*x8
    x62 = x52*x56
    x63 = n1 + x6
    x64 = o2 + x34
    x65 = o0 + x22
    x66 = n2 + x2
    x67 = n0 + x9
    x68 = o1 + x0

    return np.array([-x12*x48 + x49*(x26*x38 + x3*x36), -x43*x48 + x49*(x10*x26 + x27*x8), -x45*x48 + x49*(x19*x36 + x7*x8), x48*(x1*x51 + x12 + x20*x55 + x5*x50 + x53*x54 + x53*x56) + x49*(x1*x21 + x26*(p1 + x16) + x32*x5 + x36*(m2 + x4)), x48*(x33*x51 + x35*x57 + x38*x58 + x38*x59 + x39*x60 + x43) + x49*(x21*x33 + x26*(m0 + x18) + x35*x40 + x8*(p2 + x29)), x48*(x23*x50 + x25*x57 + x27*x59 + x27*x62 + x28*x61 + x45) + x49*(x23*x32 + x25*x40 + x36*(p0 + x13) + x8*(m1 + x24)), x48*(x10*x58 + x10*x59 + x31*x60 + x50*x64 + x51*x63) + x49*(x21*x63 + x26*(m1 + x6) + x30*x36 + x32*x64), x48*(x15*x61 + x51*x65 + x57*x66 + x59*x7 + x62*x7) + x49*(x14*x26 + x21*x65 + x40*x66 + x8*(m2 + x2)), x48*(x3*x58 + x3*x62 + x37*x55 + x50*x67 + x57*x68) + x49*(x17*x8 + x32*x67 + x36*(m0 + x9) + x40*x68), x48*(x11*x37 + x11*x39) + x49*(x21*x38 + x3*x32), x48*(x11*x28 + x11*x31) + x49*(x10*x21 + x27*x40), x48*(x11*x15 + x11*x20) + x49*(x19*x32 + x40*x7)], dtype=np.float64)


def d2q_d2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion2, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -n1
    x1 = p1 + x0
    x2 = -o2
    x3 = p2 + x2
    x4 = x1*x3
    x5 = -p2
    x6 = n2 + x5
    x7 = -o1
    x8 = p1 + x7
    x9 = x6*x8
    x10 = x4 + x9
    x11 = -o0
    x12 = p0 + x11
    x13 = x12**2
    x14 = x8**2
    x15 = x3**2
    x16 = x13 + x14 + x15
    x17 = mpmath.sqrt(x16)
    x18 = x10*x17
    x19 = -m0
    x20 = o0 + x19
    x21 = x20*x8
    x22 = -m1
    x23 = o1 + x22
    x24 = -p0
    x25 = o0 + x24
    x26 = x23*x25
    x27 = x21 + x26
    x28 = -n0
    x29 = p0 + x28
    x30 = x29*x8
    x31 = -p1
    x32 = n1 + x31
    x33 = x12*x32
    x34 = x30 + x33
    x35 = o2 + x5
    x36 = x20*x35
    x37 = -m2
    x38 = o2 + x37
    x39 = x12*x38
    x40 = x36 + x39
    x41 = n0 + x24
    x42 = x3*x41
    x43 = -n2
    x44 = p2 + x43
    x45 = x12*x44
    x46 = x42 + x45
    x47 = x23*x3
    x48 = o1 + x31
    x49 = x38*x48
    x50 = x47 + x49
    x51 = x10*x50 + x27*x34 + x40*x46
    x52 = x18*x20
    x53 = x17*x46
    x54 = x23*x53
    x55 = x17*x34
    x56 = x38*x55
    x57 = x52 + x54 + x56
    x58 = x51**2 + x57**2
    x59 = x58**(-2)
    x60 = x34*x48
    x61 = x3*x46
    x62 = 2*x18
    x63 = x59*(-x51*(2*x60 + 2*x61) + x57*x62)
    x64 = x51*x63
    x65 = x60 + x61
    x66 = -x52 - x54 - x56
    x67 = x63*x66
    x68 = x58**(-1)
    x69 = x12*x34
    x70 = x10*x35
    x71 = x69 + x70
    x72 = x68*x71
    x73 = x18*x72
    x74 = x65*x68
    x75 = x53*x74
    x76 = x25*x46
    x77 = x10*x8
    x78 = x76 + x77
    x79 = x68*x78
    x80 = x18*x79
    x81 = x55*x74
    x82 = x17*x6
    x83 = x23*x82
    x84 = x1*x17
    x85 = x38*x84
    x86 = x17**(-1)
    x87 = x10*x86
    x88 = x20*x87
    x89 = x25*x88
    x90 = x46*x86
    x91 = x26*x90
    x92 = x25*x38
    x93 = x34*x86
    x94 = x92*x93
    x95 = x18 + x83 + x85 + x89 + x91 + x94
    x96 = p1 + x22
    x97 = x34*x96
    x98 = m2 + x5
    x99 = x46*x98
    x100 = x1*x27
    x101 = x40*x6
    x102 = x100 + x101 + x97 + x99
    x103 = x102*x68
    x104 = x103*x18
    x105 = x66*x68
    x106 = x51*x68
    x107 = x25*x87
    x108 = x105*(x1*x48 + x3*x6) - x106*x107
    x109 = m0 + x24
    x110 = x109*x34
    x111 = p2 + x37
    x112 = x10*x111
    x113 = x27*x41
    x114 = x44*x50
    x115 = x110 + x112 + x113 + x114
    x116 = x115*x68
    x117 = x116*x18
    x118 = x105*(x34 + x41*x48)
    x119 = x17*x44
    x120 = x48*x87
    x121 = x119*x20
    x122 = x17*x41
    x123 = x122*x38
    x124 = x20*x48
    x125 = x124*x87
    x126 = x23*x90
    x127 = x126*x48
    x128 = x49*x93
    x129 = x121 + x123 + x125 + x127 + x128 + x53
    x130 = p0 + x19
    x131 = x130*x46
    x132 = m1 + x31
    x133 = x10*x132
    x134 = x29*x40
    x135 = x32*x50
    x136 = x131 + x133 + x134 + x135
    x137 = x136*x68
    x138 = x137*x18
    x139 = -x42 - x45
    x140 = x105*(x139 + x29*x3)
    x141 = x17*x32
    x142 = x70*x86
    x143 = x141*x20
    x144 = x17*x29
    x145 = x144*x23
    x146 = x36*x87
    x147 = x23*x35
    x148 = x147*x90
    x149 = x38*x93
    x150 = x149*x35
    x151 = x143 + x145 + x146 + x148 + x150 + x55
    x152 = o2 + x43
    x153 = x152*x17
    x154 = x153*x23
    x155 = n1 + x7
    x156 = x155*x17
    x157 = x156*x38
    x158 = x12*x20
    x159 = x158*x87
    x160 = x12*x90
    x161 = x160*x23
    x162 = x39*x93
    x163 = x154 + x157 + x159 + x161 + x162
    x164 = m1 + x7
    x165 = x164*x34
    x166 = x38*x46
    x167 = x155*x27
    x168 = x152*x40
    x169 = x165 + x166 + x167 + x168
    x170 = x169*x68
    x171 = x170*x18
    x172 = x12*x87
    x173 = x105*(x152*x3 + x155*x48) - x106*x172
    x174 = x20*x34
    x175 = m2 + x2
    x176 = x10*x175
    x177 = o0 + x28
    x178 = x177*x27
    x179 = n2 + x2
    x180 = x179*x50
    x181 = x174 + x176 + x178 + x180
    x182 = x181*x68
    x183 = x18*x182
    x184 = -x30 - x33
    x185 = x105*(x177*x48 + x184)
    x186 = x17*x179
    x187 = x77*x86
    x188 = x186*x20
    x189 = x17*x177
    x190 = x189*x38
    x191 = x21*x87
    x192 = x23*x8
    x193 = x192*x90
    x194 = x8*x93
    x195 = x194*x38
    x196 = x188 + x190 + x191 + x193 + x195
    x197 = m0 + x11
    x198 = x197*x46
    x199 = x10*x23
    x200 = n0 + x11
    x201 = x200*x40
    x202 = o1 + x0
    x203 = x202*x50
    x204 = x198 + x199 + x201 + x203
    x205 = x204*x68
    x206 = x18*x205
    x207 = x105*(x200*x3 + x46)
    x208 = x17*x202
    x209 = x3*x87
    x210 = x20*x208
    x211 = x17*x200
    x212 = x211*x23
    x213 = x20*x209
    x214 = x47*x90
    x215 = x3*x38
    x216 = x215*x93
    x217 = x210 + x212 + x213 + x214 + x216
    x218 = x27*x48
    x219 = x3*x40
    x220 = x218 + x219
    x221 = x220*x68
    x222 = x18*x221
    x223 = x17*x47
    x224 = x17*x49
    x225 = x223 + x224
    x226 = x48**2
    x227 = x105*(x15 + x226)
    x228 = x17*x36
    x229 = x17*x39
    x230 = x228 + x229
    x231 = x12*x27
    x232 = x35*x50
    x233 = x231 + x232
    x234 = x233*x68
    x235 = x18*x234
    x236 = x12*x48
    x237 = x105*x236
    x238 = x17*x35
    x239 = -x106*x238 + x237
    x240 = x17*x21
    x241 = x17*x26
    x242 = x240 + x241
    x243 = x25*x40
    x244 = x50*x8
    x245 = x243 + x244
    x246 = x245*x68
    x247 = x18*x246
    x248 = x25*x3
    x249 = x105*x248
    x250 = x17*x8
    x251 = -x106*x250 + x249
    x252 = 2*x53
    x253 = x59*(x252*x57 - x51*(2*x69 + 2*x70))
    x254 = x253*x51
    x255 = x253*x66
    x256 = x53*x79
    x257 = x55*x72
    x258 = x103*x53
    x259 = x105*(x1*x12 + x184)
    x260 = x76*x86
    x261 = x116*x53
    x262 = x48*x90
    x263 = x105*(x12*x41 + x35*x44) - x106*x262
    x264 = x137*x53
    x265 = x105*(x10 + x32*x35)
    x266 = x35*x90
    x267 = x170*x53
    x268 = x105*(x12*x155 + x34)
    x269 = x182*x53
    x270 = x8*x90
    x271 = x105*(x12*x177 + x179*x35) - x106*x270
    x272 = x205*x53
    x273 = -x4 - x9
    x274 = x105*(x202*x35 + x273)
    x275 = x61*x86
    x276 = x221*x53
    x277 = x17*x3
    x278 = -x106*x277 + x237
    x279 = x234*x53
    x280 = x35**2
    x281 = x105*(x13 + x280)
    x282 = x246*x53
    x283 = x35*x8
    x284 = x105*x283
    x285 = x17*x25
    x286 = -x106*x285 + x284
    x287 = 2*x55
    x288 = x59*(x287*x57 - x51*(2*x76 + 2*x77))
    x289 = x288*x51
    x290 = x288*x66
    x291 = x103*x55
    x292 = x105*(x25*x6 + x46)
    x293 = x25*x93
    x294 = x116*x55
    x295 = x105*(x273 + x44*x8)
    x296 = x60*x86
    x297 = x137*x55
    x298 = x35*x93
    x299 = x105*(x25*x29 + x32*x8) - x106*x298
    x300 = x170*x55
    x301 = x105*(x139 + x152*x25)
    x302 = x69*x86
    x303 = x182*x55
    x304 = x105*(x10 + x179*x8)
    x305 = x205*x55
    x306 = x3*x93
    x307 = x105*(x200*x25 + x202*x8) - x106*x306
    x308 = x221*x55
    x309 = x17*x48
    x310 = -x106*x309 + x249
    x311 = x234*x55
    x312 = x12*x17
    x313 = -x106*x312 + x284
    x314 = x246*x55
    x315 = x25**2
    x316 = x105*(x14 + x315)
    x317 = -x18 - x83 - x85 - x89 - x91 - x94
    x318 = x59*(-x51*(2*x100 + 2*x101 + 2*x97 + 2*x99) - x57*(x62 + 2*x83 + 2*x85 + 2*x89 + 2*x91 + 2*x94))
    x319 = x318*x66
    x320 = x318*x51
    x321 = 2*x1
    x322 = 2*x6
    x323 = x26*x86
    x324 = x86*x92
    x325 = x16**(mpmath.mpf(-3)/mpmath.mpf(2))
    x326 = x25*x325
    x327 = x10*x158
    x328 = x12*x325
    x329 = x328*x46
    x330 = x34*x39
    x331 = x126 + x149 + x88
    x332 = x26*x329 + x326*x327 + x326*x330 + x331
    x333 = x105*(x1*x109 + x41*x96)
    x334 = x317*x68
    x335 = x10*x328
    x336 = x23*x46
    x337 = x124*x335 + x236*x325*x336 + x325*x39*x60
    x338 = x23*x86
    x339 = x338*x6
    x340 = x20*x86
    x341 = x25*x340
    x342 = x1*x86
    x343 = x119 + x120 + x260 + x324*x41 + x339*x48 + x341*x44 + x342*x49 + x82
    x344 = x105*(x130*x6 + x29*x98)
    x345 = x325*x330
    x346 = x147*x329 + x335*x36 + x345*x35
    x347 = x6*x86
    x348 = x38*x86
    x349 = x1*x348
    x350 = x141 + x142 + x147*x347 + x29*x323 + x293 + x32*x341 + x349*x35 + x84
    x351 = x105*(x1*x164 + x152*x98 + x155*x96 + x38*x6)
    x352 = x13*x325
    x353 = x10*x20
    x354 = x34*x38
    x355 = -x126 - x149 - x88
    x356 = x12*x339 + x152*x323 + x155*x324 + x172 + x342*x39 + x355
    x357 = x105*(x1*x20 + x177*x96 + x27 + x34)
    x358 = x192*x329 + x21*x335 + x345*x8
    x359 = x17*x38
    x360 = x177*x324 + x179*x341 + x186 + x187 + x338*x9 + x349*x8 + x359
    x361 = -x36 - x39
    x362 = x105*(x139 + x197*x6 + x200*x98 + x361)
    x363 = x3*x325
    x364 = x3*x345 + x327*x363 + x329*x47
    x365 = x17*x23
    x366 = -x365
    x367 = x200*x323 + x202*x341 + x208 + x209 + x347*x47 + x348*x4 + x366
    x368 = x3*x323
    x369 = x25*x86
    x370 = x105*(x3*x98 + x48*x96) + x106*(x368 + x369*x49)
    x371 = -x21 - x26
    x372 = -x359
    x373 = x105*(x12*x96 + x371) + x106*(x238 + x36*x369 + x369*x39 + x372)
    x374 = x105*(x25*x98 + x40) + x106*(x21*x369 + x250 + x315*x338 + x365)
    x375 = -x121 - x123 - x125 - x127 - x128 - x53
    x376 = x59*(-x51*(2*x110 + 2*x112 + 2*x113 + 2*x114) - x57*(2*x121 + 2*x123 + 2*x125 + 2*x127 + 2*x128 + x252))
    x377 = x376*x51
    x378 = x376*x66
    x379 = x10*x21
    x380 = x325*x8
    x381 = x380*x46
    x382 = x34*x380
    x383 = x26*x381 + x326*x379 + x382*x92
    x384 = 2*x41
    x385 = 2*x44
    x386 = x49*x86
    x387 = x124*x86
    x388 = x325*x48
    x389 = x388*x46
    x390 = x192*x389 + x331 + x379*x388 + x382*x49
    x391 = x105*(x111*x32 + x132*x44)
    x392 = x375*x68
    x393 = x147*x381 + x283*x325*x354 + x325*x36*x77
    x394 = x348*x41
    x395 = x44*x86
    x396 = x338*x48
    x397 = x122 + x144 + x266 + x29*x396 + x296 + x32*x387 + x35*x394 + x36*x395
    x398 = x105*(x109*x155 + x164*x41 + x184 + x371)
    x399 = x39*x86
    x400 = x152*x396 + x153 + x155*x386 + x160 + x340*x45 + x372 + x399*x41
    x401 = x105*(x109*x177 + x111*x179 + x175*x44 + x20*x41)
    x402 = x14*x325
    x403 = x177*x386 + x179*x387 + x21*x395 + x270 + x355 + x394*x8
    x404 = x105*(x10 + x111*x202 + x23*x44 + x50)
    x405 = x215*x382 + x363*x379 + x381*x47
    x406 = x17*x20
    x407 = x3*x340
    x408 = x200*x396 + x202*x387 + x211 + x275 + x348*x42 + x406 + x407*x44
    x409 = x48*x86
    x410 = x105*(x109*x48 + x27) + x106*(x226*x348 + x277 + x359 + x409*x47)
    x411 = x399*x48
    x412 = x105*(x109*x12 + x111*x35) + x106*(x36*x409 + x411)
    x413 = -x47 - x49
    x414 = -x406
    x415 = x105*(x111*x8 + x413) + x106*(x21*x409 + x285 + x323*x48 + x414)
    x416 = -x143 - x145 - x146 - x148 - x150 - x55
    x417 = x59*(-x51*(2*x131 + 2*x133 + 2*x134 + 2*x135) - x57*(2*x143 + 2*x145 + 2*x146 + 2*x148 + 2*x150 + x287))
    x418 = x417*x51
    x419 = x417*x66
    x420 = x26*x325
    x421 = x215*x34
    x422 = x248*x325*x353 + x326*x421 + x420*x61
    x423 = x10*x363
    x424 = x34*x49
    x425 = x124*x423 + x363*x424 + x389*x47
    x426 = 2*x29
    x427 = 2*x32
    x428 = x36*x86
    x429 = x147*x86
    x430 = x325*x35
    x431 = x331 + x36*x423 + x421*x430 + x430*x46*x47
    x432 = x105*(x130*x152 + x29*x38 + x40 + x46)
    x433 = x416*x68
    x434 = x348*x35
    x435 = x12*x338
    x436 = x152*x429 + x155*x434 + x156 + x29*x435 + x302 + x33*x340 + x365
    x437 = x105*(x132*x179 + x175*x32 + x273 + x413)
    x438 = x21*x86
    x439 = x177*x434 + x179*x428 + x189 + x194 + x30*x338 + x32*x438 + x414
    x440 = x105*(x130*x200 + x132*x202 + x197*x29 + x23*x32)
    x441 = x15*x325
    x442 = x47*x86
    x443 = x200*x429 + x202*x428 + x29*x442 + x306 + x32*x407 + x355
    x444 = x105*(x130*x3 + x361) + x106*(x309 + x35*x386 + x35*x442 + x366)
    x445 = x105*(x132*x35 + x50) + x106*(x280*x340 + x312 + x35*x399 + x406)
    x446 = x428*x8
    x447 = x105*(x130*x25 + x132*x8) + x106*(x323*x35 + x446)
    x448 = -x154 - x157 - x159 - x161 - x162
    x449 = 2*x23
    x450 = x59*(-x51*(2*x165 + 2*x166 + 2*x167 + 2*x168) - x57*(2*x154 + 2*x157 + 2*x159 + x160*x449 + 2*x162))
    x451 = x450*x66
    x452 = x450*x51
    x453 = x315*x325
    x454 = x10*x326
    x455 = x124*x454 + x26*x389 + x326*x424
    x456 = x34*x430*x92 + x35*x420*x46 + x36*x454
    x457 = 2*x155
    x458 = 2*x152
    x459 = x105*(x155*x20 + x164*x177)
    x460 = x448*x68
    x461 = x348*x8
    x462 = x158*x86
    x463 = x192*x86
    x464 = x152*x463 + x155*x461 + x177*x399 + x179*x462
    x465 = x105*(x152*x197 + x200*x38)
    x466 = x215*x86
    x467 = x152*x442 + x155*x466 + x200*x435 + x202*x462
    x468 = x105*(x164*x48 + x215) + x106*(x12*x442 + x411)
    x469 = x105*(x12*x164 + x27) + x106*(x12*x428 + x13*x348 + x359)
    x470 = x105*(x361 + x92) + x106*(x12*x323 + x12*x438 + x366)
    x471 = -x188 - x190 - x191 - x193 - x195
    x472 = x59*(-x51*(2*x174 + 2*x176 + 2*x178 + 2*x180) - x57*(2*x188 + 2*x190 + 2*x191 + 2*x193 + 2*x195))
    x473 = x472*x51
    x474 = x472*x66
    x475 = x226*x325
    x476 = x10*x36*x388 + x147*x389 + x424*x430
    x477 = 2*x177
    x478 = 2*x179
    x479 = x105*(x175*x202 + x179*x23)
    x480 = x471*x68
    x481 = x177*x466 + x179*x407 + x200*x463 + x202*x438
    x482 = x105*(x124 + x371) + x106*(x372 + x386*x8 + x442*x8)
    x483 = x105*(x158 + x175*x35) + x106*(x399*x8 + x446)
    x484 = x105*(x175*x8 + x50) + x106*(x14*x340 + x323*x8 + x406)
    x485 = -x210 - x212 - x213 - x214 - x216
    x486 = x59*(-x51*(2*x198 + 2*x199 + 2*x201 + 2*x203) - x57*(2*x210 + 2*x212 + 2*x213 + 2*x214 + 2*x216))
    x487 = x486*x51
    x488 = x486*x66
    x489 = x280*x325
    x490 = 2*x200
    x491 = x485*x68
    x492 = x105*(x197*x3 + x40) + x106*(x15*x338 + x3*x386 + x365)
    x493 = x105*(x147 + x413) + x106*(x3*x399 + x3*x428 + x414)
    x494 = x105*(x192 + x197*x25) + x106*(x3*x438 + x368)
    x495 = -x223 - x224
    x496 = x59*(-x51*(2*x218 + 2*x219) - x57*(2*x223 + 2*x224))
    x497 = x496*x51
    x498 = x496*x66
    x499 = x495*x68
    x500 = -x228 - x229
    x501 = x59*(-x51*(2*x231 + 2*x232) - x57*(2*x228 + 2*x229))
    x502 = x501*x66
    x503 = x501*x51
    x504 = -x240 - x241
    x505 = x59*(-x51*(2*x243 + 2*x244) - x57*(2*x240 + 2*x241))
    x506 = x505*x66
    x507 = x505*x51

    return np.array([-x18*x64 + x65*x67, -x53*x64 + x67*x71 + x73 - x75, -x55*x64 + x67*x78 + x80 - x81, x102*x67 + x104 + x108 + x64*x95 + x74*x95, x106*(-x119 - x120) + x115*x67 + x117 + x118 + x129*x64 + x129*x74, x106*(-x141 - x142) + x136*x67 + x138 + x140 + x151*x64 + x151*x74, x163*x64 + x163*x74 + x169*x67 + x171 + x173, x106*(-x186 - x187) + x181*x67 + x183 + x185 + x196*x64 + x196*x74, x106*(-x208 - x209) + x204*x67 + x206 + x207 + x217*x64 + x217*x74, x220*x67 + x222 + x225*x64 + x225*x74 + x227, x230*x64 + x230*x74 + x233*x67 + x235 + x239, x242*x64 + x242*x74 + x245*x67 + x247 + x251, -x18*x254 + x255*x65 - x73 + x75, -x254*x53 + x255*x71, -x254*x55 + x255*x78 + x256 - x257, x102*x255 + x106*(-x260 - x82) + x254*x95 + x258 + x259 + x72*x95, x115*x255 + x129*x254 + x129*x72 + x261 + x263, x106*(-x144 - x266) + x136*x255 + x151*x254 + x151*x72 + x264 + x265, x106*(-x153 - x160) + x163*x254 + x163*x72 + x169*x255 + x267 + x268, x181*x255 + x196*x254 + x196*x72 + x269 + x271, x106*(-x211 - x275) + x204*x255 + x217*x254 + x217*x72 + x272 + x274, x220*x255 + x225*x254 + x225*x72 + x276 + x278, x230*x254 + x230*x72 + x233*x255 + x279 + x281, x242*x254 + x242*x72 + x245*x255 + x282 + x286, -x18*x289 + x290*x65 - x80 + x81, -x256 + x257 - x289*x53 + x290*x71, -x289*x55 + x290*x78, x102*x290 + x106*(-x293 - x84) + x289*x95 + x291 + x292 + x79*x95, x106*(-x122 - x296) + x115*x290 + x129*x289 + x129*x79 + x294 + x295, x136*x290 + x151*x289 + x151*x79 + x297 + x299, x106*(-x156 - x302) + x163*x289 + x163*x79 + x169*x290 + x300 + x301, x106*(-x189 - x194) + x181*x290 + x196*x289 + x196*x79 + x303 + x304, x204*x290 + x217*x289 + x217*x79 + x305 + x307, x220*x290 + x225*x289 + x225*x79 + x308 + x310, x230*x289 + x230*x79 + x233*x290 + x311 + x313, x242*x289 + x242*x79 + x245*x290 + x314 + x316, -x104 + x108 - x18*x320 + x317*x74 + x319*x65, -x106*x260 - x106*x82 - x258 + x259 + x317*x72 + x319*x71 - x320*x53, -x106*x293 - x106*x84 - x291 + x292 + x317*x79 + x319*x78 - x320*x55, x102*x319 + x103*x317 + x103*x95 + x105*(x321*x96 + x322*x98) + x106*(2*x107 + x321*x324 + x322*x323 + x332) + x320*x95, x103*x129 + x106*(x337 + x343) + x115*x319 + x115*x334 + x129*x320 + x333, x103*x151 + x106*(x346 + x350) + x136*x319 + x136*x334 + x151*x320 + x344, x103*x163 + x106*(x336*x352 + x352*x353 + x352*x354 + x356) + x163*x320 + x169*x319 + x169*x334 + x351, x103*x196 + x106*(x358 + x360) + x181*x319 + x181*x334 + x196*x320 + x357, x103*x217 + x106*(x364 + x367) + x204*x319 + x204*x334 + x217*x320 + x362, x103*x225 + x220*x319 + x220*x334 + x225*x320 + x370, x103*x230 + x230*x320 + x233*x319 + x233*x334 + x373, x103*x242 + x242*x320 + x245*x319 + x245*x334 + x374, -x106*x119 - x106*x120 - x117 + x118 - x18*x377 + x375*x74 + x378*x65, -x261 + x263 + x375*x72 - x377*x53 + x378*x71, -x106*x122 - x106*x296 - x294 + x295 + x375*x79 - x377*x55 + x378*x78, x102*x378 + x103*x375 + x106*(x343 + x383) + x116*x95 + x333 + x377*x95, x105*(x109*x384 + x111*x385) + x106*(2*x262 + x384*x386 + x385*x387 + x390) + x115*x378 + x116*x129 + x116*x375 + x129*x377, x106*(x393 + x397) + x116*x151 + x136*x378 + x136*x392 + x151*x377 + x391, x106*(x358 + x400) + x116*x163 + x163*x377 + x169*x378 + x169*x392 + x398, x106*(x336*x402 + x353*x402 + x354*x402 + x403) + x116*x196 + x181*x378 + x181*x392 + x196*x377 + x401, x106*(x405 + x408) + x116*x217 + x204*x378 + x204*x392 + x217*x377 + x404, x116*x225 + x220*x378 + x220*x392 + x225*x377 + x410, x116*x230 + x230*x377 + x233*x378 + x233*x392 + x412, x116*x242 + x242*x377 + x245*x378 + x245*x392 + x415, -x106*x141 - x106*x142 - x138 + x140 - x18*x418 + x416*x74 + x419*x65, -x106*x144 - x106*x266 - x264 + x265 + x416*x72 - x418*x53 + x419*x71, -x297 + x299 + x416*x79 - x418*x55 + x419*x78, x102*x419 + x103*x416 + x106*(x350 + x422) + x137*x95 + x344 + x418*x95, x106*(x397 + x425) + x115*x419 + x116*x416 + x129*x137 + x129*x418 + x391, x105*(x130*x426 + x132*x427) + x106*(2*x298 + x426*x429 + x427*x428 + x431) + x136*x419 + x137*x151 + x137*x416 + x151*x418, x106*(x364 + x436) + x137*x163 + x163*x418 + x169*x419 + x169*x433 + x432, x106*(x405 + x439) + x137*x196 + x181*x419 + x181*x433 + x196*x418 + x437, x106*(x336*x441 + x353*x441 + x354*x441 + x443) + x137*x217 + x204*x419 + x204*x433 + x217*x418 + x440, x137*x225 + x220*x419 + x220*x433 + x225*x418 + x444, x137*x230 + x230*x418 + x233*x419 + x233*x433 + x445, x137*x242 + x242*x418 + x245*x419 + x245*x433 + x447, -x171 + x173 - x18*x452 + x448*x74 + x451*x65, -x106*x153 - x106*x160 - x267 + x268 + x448*x72 + x451*x71 - x452*x53, -x106*x156 - x106*x302 - x300 + x301 + x448*x79 + x451*x78 - x452*x55, x102*x451 + x103*x448 + x106*(x336*x453 + x353*x453 + x354*x453 + x356) + x170*x95 + x351 + x452*x95, x106*(x400 + x455) + x115*x451 + x116*x448 + x129*x170 + x129*x452 + x398, x106*(x436 + x456) + x136*x451 + x137*x448 + x151*x170 + x151*x452 + x432, x105*(x164*x457 + x38*x458) + x106*(x332 + x399*x457 + x435*x458) + x163*x170 + x163*x452 + x169*x451 + x170*x448, x106*(x383 + x464) + x170*x196 + x181*x451 + x181*x460 + x196*x452 + x459, x106*(x422 + x467) + x170*x217 + x204*x451 + x204*x460 + x217*x452 + x465, x170*x225 + x220*x451 + x220*x460 + x225*x452 + x468, x170*x230 + x230*x452 + x233*x451 + x233*x460 + x469, x170*x242 + x242*x452 + x245*x451 + x245*x460 + x470, -x106*x186 - x106*x187 - x18*x473 - x183 + x185 + x471*x74 + x474*x65, -x269 + x271 + x471*x72 - x473*x53 + x474*x71, -x106*x189 - x106*x194 - x303 + x304 + x471*x79 - x473*x55 + x474*x78, x102*x474 + x103*x471 + x106*(x360 + x455) + x182*x95 + x357 + x473*x95, x106*(x336*x475 + x353*x475 + x354*x475 + x403) + x115*x474 + x116*x471 + x129*x182 + x129*x473 + x401, x106*(x439 + x476) + x136*x474 + x137*x471 + x151*x182 + x151*x473 + x437, x106*(x337 + x464) + x163*x182 + x163*x473 + x169*x474 + x170*x471 + x459, x105*(x175*x478 + x20*x477) + x106*(x390 + x438*x478 + x461*x477) + x181*x474 + x182*x196 + x182*x471 + x196*x473, x106*(x425 + x481) + x182*x217 + x204*x474 + x204*x480 + x217*x473 + x479, x182*x225 + x220*x474 + x220*x480 + x225*x473 + x482, x182*x230 + x230*x473 + x233*x474 + x233*x480 + x483, x182*x242 + x242*x473 + x245*x474 + x245*x480 + x484, -x106*x208 - x106*x209 - x18*x487 - x206 + x207 + x485*x74 + x488*x65, -x106*x211 - x106*x275 - x272 + x274 + x485*x72 - x487*x53 + x488*x71, -x305 + x307 + x485*x79 - x487*x55 + x488*x78, x102*x488 + x103*x485 + x106*(x367 + x456) + x205*x95 + x362 + x487*x95, x106*(x408 + x476) + x115*x488 + x116*x485 + x129*x205 + x129*x487 + x404, x106*(x336*x489 + x353*x489 + x354*x489 + x443) + x136*x488 + x137*x485 + x151*x205 + x151*x487 + x440, x106*(x346 + x467) + x163*x205 + x163*x487 + x169*x488 + x170*x485 + x465, x106*(x393 + x481) + x181*x488 + x182*x485 + x196*x205 + x196*x487 + x479, x105*(x197*x490 + x202*x449) + x106*(2*x202*x407 + x431 + x442*x490) + x204*x488 + x205*x217 + x205*x485 + x217*x487, x205*x225 + x220*x488 + x220*x491 + x225*x487 + x492, x205*x230 + x230*x487 + x233*x488 + x233*x491 + x493, x205*x242 + x242*x487 + x245*x488 + x245*x491 + x494, -x18*x497 - x222 + x227 + x495*x74 + x498*x65, -x276 + x278 + x495*x72 - x497*x53 + x498*x71, -x308 + x310 + x495*x79 - x497*x55 + x498*x78, x102*x498 + x103*x495 + x221*x95 + x370 + x497*x95, x115*x498 + x116*x495 + x129*x221 + x129*x497 + x410, x136*x498 + x137*x495 + x151*x221 + x151*x497 + x444, x163*x221 + x163*x497 + x169*x498 + x170*x495 + x468, x181*x498 + x182*x495 + x196*x221 + x196*x497 + x482, x204*x498 + x205*x495 + x217*x221 + x217*x497 + x492, x220*x498 + x221*x225 + x221*x495 + x225*x497, x221*x230 + x230*x497 + x233*x498 + x233*x499, x221*x242 + x242*x497 + x245*x498 + x245*x499, -x18*x503 - x235 + x239 + x500*x74 + x502*x65, -x279 + x281 + x500*x72 + x502*x71 - x503*x53, -x311 + x313 + x500*x79 + x502*x78 - x503*x55, x102*x502 + x103*x500 + x234*x95 + x373 + x503*x95, x115*x502 + x116*x500 + x129*x234 + x129*x503 + x412, x136*x502 + x137*x500 + x151*x234 + x151*x503 + x445, x163*x234 + x163*x503 + x169*x502 + x170*x500 + x469, x181*x502 + x182*x500 + x196*x234 + x196*x503 + x483, x204*x502 + x205*x500 + x217*x234 + x217*x503 + x493, x220*x502 + x221*x500 + x225*x234 + x225*x503, x230*x234 + x230*x503 + x233*x502 + x234*x500, x234*x242 + x242*x503 + x245*x502 + x246*x500, -x18*x507 - x247 + x251 + x504*x74 + x506*x65, -x282 + x286 + x504*x72 + x506*x71 - x507*x53, -x314 + x316 + x504*x79 + x506*x78 - x507*x55, x102*x506 + x103*x504 + x246*x95 + x374 + x507*x95, x115*x506 + x116*x504 + x129*x246 + x129*x507 + x415, x136*x506 + x137*x504 + x151*x246 + x151*x507 + x447, x163*x246 + x163*x507 + x169*x506 + x170*x504 + x470, x181*x506 + x182*x504 + x196*x246 + x196*x507 + x484, x204*x506 + x205*x504 + x217*x246 + x217*x507 + x494, x220*x506 + x221*x504 + x225*x246 + x225*x507, x230*x246 + x230*x507 + x233*x506 + x234*x504, x242*x246 + x242*x507 + x245*x506 + x246*x504], dtype=np.float64)


def q_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = n0 + x0
    x7 = n1 + x2
    x8 = n2 + x4

    return (p0*(x3*x8 + x5*(-n1 + o1)) + p1*(x1*(-n2 + o2) + x5*x6) + p2*(x1*x7 + x3*(-n0 + o0)))/(mpmath.sqrt(x1**2 + x3**2 + x5**2)*mpmath.sqrt(x6**2 + x7**2 + x8**2))


def dq_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -n2
    x1 = o2 + x0
    x2 = -o1
    x3 = n1 + x2
    x4 = -o0
    x5 = m0 + x4
    x6 = m1 + x2
    x7 = -o2
    x8 = m2 + x7
    x9 = x5**2 + x6**2 + x8**2
    x10 = 1/mpmath.sqrt(x9)
    x11 = n0 + x4
    x12 = n2 + x7
    x13 = x11**2 + x12**2 + x3**2
    x14 = 1/mpmath.sqrt(x13)
    x15 = x10*x14
    x16 = -m0
    x17 = o0 + x16
    x18 = -n1
    x19 = o1 + x18
    x20 = -n0
    x21 = o0 + x20
    x22 = p0*(x12*x6 + x19*x8) + p1*(x1*x5 + x11*x8) + p2*(x21*x6 + x3*x5)
    x23 = x14*x22/x9**(mpmath.mpf(3)/mpmath.mpf(2))
    x24 = -m1
    x25 = o1 + x24
    x26 = -m2
    x27 = o2 + x26
    x28 = x10*x22/x13**(mpmath.mpf(3)/mpmath.mpf(2))

    return np.array([x15*(p1*x1 + p2*x3) + x17*x23, x15*(p0*x12 + p2*x21) + x23*x25, x15*(p0*x19 + p1*x11) + x23*x27, x11*x28 + x15*(p1*(n2 + x26) + p2*(m1 + x18)) + x23*x5, x15*(p0*(m2 + x0) + p2*(n0 + x16)) + x23*x6 + x28*x3, x12*x28 + x15*(p0*(n1 + x24) + p1*(m0 + x20)) + x23*x8, x15*(p1*x8 + p2*x25) + x21*x28, x15*(p0*x27 + p2*x5) + x19*x28, x1*x28 + x15*(p0*x6 + p1*x17)], dtype=np.float64)


def d2q_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -n2
    x1 = o2 + x0
    x2 = -o1
    x3 = n1 + x2
    x4 = p1*x1 + p2*x3
    x5 = -m0
    x6 = o0 + x5
    x7 = -o0
    x8 = m0 + x7
    x9 = m1 + x2
    x10 = -o2
    x11 = m2 + x10
    x12 = x11**2 + x8**2 + x9**2
    x13 = x12**(mpmath.mpf(-3)/mpmath.mpf(2))
    x14 = n0 + x7
    x15 = n2 + x10
    x16 = x14**2 + x15**2 + x3**2
    x17 = 1/mpmath.sqrt(x16)
    x18 = x13*x17
    x19 = x18*x6
    x20 = x15*x9
    x21 = -n1
    x22 = o1 + x21
    x23 = x11*x22
    x24 = x1*x8
    x25 = x11*x14
    x26 = x3*x8
    x27 = -n0
    x28 = o0 + x27
    x29 = x28*x9
    x30 = p0*(x20 + x23) + p1*(x24 + x25) + p2*(x26 + x29)
    x31 = x18*x30
    x32 = -x31
    x33 = x30*x6
    x34 = 3*m0
    x35 = 3*o0
    x36 = x17/x12**(mpmath.mpf(5)/mpmath.mpf(2))
    x37 = x36*(-x34 + x35)
    x38 = -m1
    x39 = o1 + x38
    x40 = x30*x37
    x41 = p0*x15 + p2*x28
    x42 = x18*x4
    x43 = x19*x41 + x39*x42
    x44 = -m2
    x45 = o2 + x44
    x46 = p0*x22 + p1*x14
    x47 = x19*x46 + x42*x45
    x48 = p1*(n2 + x44) + p2*(m1 + x21)
    x49 = 1/mpmath.sqrt(x12)
    x50 = x16**(mpmath.mpf(-3)/mpmath.mpf(2))
    x51 = x49*x50
    x52 = x4*x51
    x53 = x13*x50
    x54 = x33*x53
    x55 = x14*x52 + x14*x54 + x19*x48 + x31 + x42*x8
    x56 = x17*x49
    x57 = p2*x56
    x58 = -x57
    x59 = p0*(m2 + x0) + p2*(n0 + x5)
    x60 = x19*x59 + x3*x52 + x3*x54 + x42*x9 + x58
    x61 = p1*x56
    x62 = p0*(n1 + x38) + p1*(m0 + x27)
    x63 = x11*x42 + x15*x52 + x15*x54 + x19*x62 + x61
    x64 = p1*x11 + p2*x39
    x65 = x19*x64 + x28*x52 + x28*x54
    x66 = p0*x45 + p2*x8
    x67 = x19*x66 + x22*x52 + x22*x54 + x57
    x68 = -x61
    x69 = p0*x9 + p1*x6
    x70 = x1*x52 + x1*x54 + x19*x69 + x68
    x71 = 3*m1
    x72 = 3*o1
    x73 = x36*(-x71 + x72)
    x74 = x18*x39
    x75 = x30*x73
    x76 = x18*x41
    x77 = x45*x76 + x46*x74
    x78 = x41*x51
    x79 = x30*x39
    x80 = x53*x79
    x81 = x14*x78 + x14*x80 + x48*x74 + x57 + x76*x8
    x82 = x3*x78 + x3*x80 + x31 + x59*x74 + x76*x9
    x83 = p0*x56
    x84 = -x83
    x85 = x11*x76 + x15*x78 + x15*x80 + x62*x74 + x84
    x86 = x28*x78 + x28*x80 + x58 + x64*x74
    x87 = x22*x78 + x22*x80 + x66*x74
    x88 = x1*x78 + x1*x80 + x69*x74 + x83
    x89 = 3*m2
    x90 = 3*o2
    x91 = x36*(-x89 + x90)
    x92 = x18*x46
    x93 = x30*x91
    x94 = x18*x45
    x95 = x46*x51
    x96 = x30*x45
    x97 = x53*x96
    x98 = x14*x95 + x14*x97 + x48*x94 + x68 + x8*x92
    x99 = x3*x95 + x3*x97 + x59*x94 + x83 + x9*x92
    x100 = x11*x92 + x15*x95 + x15*x97 + x31 + x62*x94
    x101 = x28*x95 + x28*x97 + x61 + x64*x94
    x102 = x22*x95 + x22*x97 + x66*x94 + x84
    x103 = x1*x95 + x1*x97 + x69*x94
    x104 = -x35
    x105 = x36*(x104 + x34)
    x106 = x18*x8
    x107 = 2*x48
    x108 = x14*x51
    x109 = x105*x30
    x110 = x14*x30
    x111 = 3*n0
    x112 = x49/x16**(mpmath.mpf(5)/mpmath.mpf(2))
    x113 = x112*(x104 + x111)
    x114 = x110*x53
    x115 = x30*x51
    x116 = -x115
    x117 = x116 + x32
    x118 = x113*x30
    x119 = x18*x48
    x120 = x48*x51
    x121 = x30*x53
    x122 = x106*x59 + x108*x59 + x114*x9 + x119*x9 + x120*x3 + x121*x26
    x123 = x121*x8
    x124 = x106*x62 + x108*x62 + x11*x119 + x120*x15 + x121*x25 + x123*x15
    x125 = x106*x64 + x108*x64 + x115 + x120*x28 + x123*x28
    x126 = x106*x66 + x108*x66 + x120*x22 + x123*x22 + x58
    x127 = x1*x120 + x106*x69 + x108*x69 + x121*x24 + x61
    x128 = -x72
    x129 = x36*(x128 + x71)
    x130 = x129*x30
    x131 = 3*n1
    x132 = x112*(x128 + x131)
    x133 = x18*x9
    x134 = 2*x59
    x135 = x3*x51
    x136 = x132*x30
    x137 = x121*x9
    x138 = x11*x18
    x139 = x51*x59
    x140 = x11*x121
    x141 = x121*x20 + x133*x62 + x135*x62 + x138*x59 + x139*x15 + x140*x3
    x142 = x121*x29 + x133*x64 + x135*x64 + x139*x28 + x57
    x143 = x115 + x133*x66 + x135*x66 + x137*x22 + x139*x22
    x144 = x1*x137 + x1*x139 + x133*x69 + x135*x69 + x84
    x145 = -x90
    x146 = x36*(x145 + x89)
    x147 = x146*x30
    x148 = 3*n2
    x149 = x112*(x145 + x148)
    x150 = x149*x30
    x151 = 2*x62
    x152 = x15*x51
    x153 = x51*x62
    x154 = x138*x64 + x140*x28 + x152*x64 + x153*x28 + x68
    x155 = x121*x23 + x138*x66 + x152*x66 + x153*x22 + x83
    x156 = x1*x140 + x1*x153 + x115 + x138*x69 + x152*x69
    x157 = x112*(-x111 + x35)
    x158 = x157*x30
    x159 = x28*x51
    x160 = x51*x64
    x161 = x159*x66 + x160*x22
    x162 = x1*x160 + x159*x69
    x163 = x112*(-x131 + x72)
    x164 = x163*x30
    x165 = x22*x51
    x166 = x1*x51
    x167 = x165*x69 + x166*x66
    x168 = x112*(-x148 + x90)
    x169 = x168*x30

    return np.array([2*x19*x4 + x32 + x33*x37, x39*x40 + x43, x40*x45 + x47, x40*x8 + x55, x40*x9 + x60, x11*x40 + x63, x65, x67, x70, x33*x73 + x43, x32 + x39*x75 + 2*x41*x74, x45*x75 + x77, x75*x8 + x81, x75*x9 + x82, x11*x75 + x85, x86, x87, x88, x33*x91 + x47, x77 + x79*x91, x32 + 2*x45*x92 + x45*x93, x8*x93 + x98, x9*x93 + x99, x100 + x11*x93, x101, x102, x103, x105*x33 + x55, x105*x79 + x81, x105*x96 + x98, x106*x107 + x107*x108 + x109*x8 + x110*x113 + 2*x114*x8 + x117, x109*x9 + x118*x3 + x122, x109*x11 + x118*x15 + x124, x118*x28 + x125, x118*x22 + x126, x1*x118 + x127, x129*x33 + x60, x129*x79 + x82, x129*x96 + x99, x110*x132 + x122 + x130*x8, x117 + x130*x9 + x133*x134 + x134*x135 + x136*x3 + 2*x137*x3, x11*x130 + x136*x15 + x141, x136*x28 + x142, x136*x22 + x143, x1*x136 + x144, x146*x33 + x63, x146*x79 + x85, x100 + x146*x96, x110*x149 + x124 + x147*x8, x141 + x147*x9 + x150*x3, x11*x147 + x117 + x138*x151 + 2*x140*x15 + x15*x150 + x151*x152, x150*x28 + x154, x150*x22 + x155, x1*x150 + x156, x65, x86, x101, x110*x157 + x125, x142 + x158*x3, x15*x158 + x154, x116 + x158*x28 + 2*x159*x64, x158*x22 + x161, x1*x158 + x162, x67, x87, x102, x110*x163 + x126, x143 + x164*x3, x15*x164 + x155, x161 + x164*x28, x116 + x164*x22 + 2*x165*x66, x1*x164 + x167, x70, x88, x103, x110*x168 + x127, x144 + x169*x3, x15*x169 + x156, x162 + x169*x28, x167 + x169*x22, x1*x169 + x116 + 2*x166*x69], dtype=np.float64)


def q_oop(m0, m1, m2, n0, n1, n2, o0, o1, o2, p0, p1, p2):
    """OutOfPlane"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -p0
    x1 = m0 + x0
    x2 = -p2
    x3 = n2 + x2
    x4 = -p1
    x5 = m1 + x4
    x6 = m2 + x2
    x7 = 1/mpmath.sqrt(x1**2 + x5**2 + x6**2)
    x8 = n0 + x0
    x9 = n1 + x4
    x10 = 1/mpmath.sqrt(x3**2 + x8**2 + x9**2)
    x11 = x10*x7
    x12 = x11*x5
    x13 = o1 + x4
    x14 = o0 + x0
    x15 = o2 + x2
    x16 = 1/mpmath.sqrt(x13**2 + x14**2 + x15**2)
    x17 = x16*x7
    x18 = x13*x17
    x19 = x10*x16
    x20 = x19*x9
    x21 = x17*x5
    x22 = x11*x9
    x23 = x13*x19
    x24 = x12*x3 + x15*x20 - x15*x21 + x18*x6 - x22*x6 - x23*x3
    x25 = -x1*x18 + x1*x22 - x12*x8 - x14*x20 + x14*x21 + x23*x8
    x26 = -x1*x11*x3 + x1*x15*x17 + x11*x6*x8 - x14*x17*x6 + x14*x19*x3 - x15*x19*x8
    x27 = x7/mpmath.sqrt(x24**2 + x25**2 + x26**2)

    return x1*x24*x27 + x25*x27*x6 + x26*x27*x5


def dq_oop(m0, m1, m2, n0, n1, n2, o0, o1, o2, p0, p1, p2):
    """OutOfPlane, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -p0
    x1 = n0 + x0
    x2 = x1**2
    x3 = -p1
    x4 = n1 + x3
    x5 = x4**2
    x6 = -p2
    x7 = n2 + x6
    x8 = x7**2
    x9 = x2 + x5 + x8
    x10 = 1/mpmath.sqrt(x9)
    x11 = x10*x7
    x12 = m1 + x3
    x13 = m0 + x0
    x14 = x13**2
    x15 = x12**2
    x16 = m2 + x6
    x17 = x16**2
    x18 = x14 + x15 + x17
    x19 = x18**(mpmath.mpf(-3)/mpmath.mpf(2))
    x20 = x19*(-m0 + p0)
    x21 = x12*x20
    x22 = x11*x21
    x23 = o0 + x0
    x24 = x23**2
    x25 = o1 + x3
    x26 = x25**2
    x27 = o2 + x6
    x28 = x27**2
    x29 = x24 + x26 + x28
    x30 = 1/mpmath.sqrt(x29)
    x31 = x25*x30
    x32 = x16*x20
    x33 = x31*x32
    x34 = x27*x30
    x35 = x21*x34
    x36 = x10*x4
    x37 = x32*x36
    x38 = 1/mpmath.sqrt(x18)
    x39 = x10*x38
    x40 = x39*x4
    x41 = x30*x38
    x42 = x23*x41
    x43 = x10*x30
    x44 = x25*x43
    x45 = x25*x41
    x46 = x1*x39
    x47 = x23*x43
    x48 = x1*x44 + x12*x42 - x12*x46 + x13*x40 - x13*x45 - x4*x47
    x49 = x27*x41
    x50 = x39*x7
    x51 = x27*x43
    x52 = -x1*x51 + x13*x49 - x13*x50 - x16*x42 + x16*x46 + x47*x7
    x53 = -x12*x49 + x12*x50 - x16*x40 + x16*x45 + x4*x51 - x44*x7
    x54 = x48**2 + x52**2 + x53**2
    x55 = 1/mpmath.sqrt(x54)
    x56 = x38*x55
    x57 = x13*x56
    x58 = x53*x56
    x59 = x53*x55
    x60 = x13*x20
    x61 = x52*x55
    x62 = x48*x55
    x63 = x1*x10
    x64 = x32*x63
    x65 = x34*x60
    x66 = x11*x60
    x67 = x23*x30
    x68 = x32*x67
    x69 = x49 - x50
    x70 = x12*x56
    x71 = x36*x60
    x72 = x21*x67
    x73 = x21*x63
    x74 = x31*x60
    x75 = x40 - x45
    x76 = x16*x56
    x77 = x54**(mpmath.mpf(-3)/mpmath.mpf(2))
    x78 = (mpmath.mpf(1)/mpmath.mpf(2))*x53
    x79 = 2*x45
    x80 = 2*x40
    x81 = -x79 + x80
    x82 = (mpmath.mpf(1)/mpmath.mpf(2))*x48
    x83 = 2*x50
    x84 = 2*x49
    x85 = -x83 + x84
    x86 = (mpmath.mpf(1)/mpmath.mpf(2))*x52
    x87 = x77*(-x78*(2*x22 + 2*x33 - 2*x35 - 2*x37) - x82*(2*x71 + 2*x72 - 2*x73 - 2*x74 + x81) - x86*(2*x64 + 2*x65 - 2*x66 - 2*x68 + x85))
    x88 = x13*x38
    x89 = x53*x88
    x90 = x12*x38
    x91 = x52*x90
    x92 = x16*x38
    x93 = x48*x92
    x94 = x19*(-m1 + p1)
    x95 = x13*x94
    x96 = x34*x95
    x97 = x16*x94
    x98 = x63*x97
    x99 = x11*x95
    x100 = x67*x97
    x101 = x52*x56
    x102 = x12*x94
    x103 = x102*x11
    x104 = x31*x97
    x105 = x36*x97
    x106 = x102*x34
    x107 = -x49 + x50
    x108 = x36*x95
    x109 = x102*x67
    x110 = x102*x63
    x111 = x31*x95
    x112 = x42 - x46
    x113 = 2*x46
    x114 = 2*x42
    x115 = -x113 + x114
    x116 = x83 - x84
    x117 = x77*(-x78*(2*x103 + 2*x104 - 2*x105 - 2*x106 + x116) - x82*(2*x108 + 2*x109 - 2*x110 - 2*x111 + x115) - x86*(-2*x100 + 2*x96 + 2*x98 - 2*x99))
    x118 = x19*(-m2 + p2)
    x119 = x118*x13
    x120 = x119*x36
    x121 = x118*x12
    x122 = x121*x67
    x123 = x119*x31
    x124 = x121*x63
    x125 = x48*x56
    x126 = x118*x16
    x127 = x11*x121
    x128 = x126*x31
    x129 = x126*x36
    x130 = x121*x34
    x131 = -x40 + x45
    x132 = x126*x63
    x133 = x119*x34
    x134 = x11*x119
    x135 = x126*x67
    x136 = -x42 + x46
    x137 = x113 - x114
    x138 = x79 - x80
    x139 = x77*(-x78*(2*x127 + 2*x128 - 2*x129 - 2*x130 + x138) - x82*(2*x120 + 2*x122 - 2*x123 - 2*x124) - x86*(2*x132 + 2*x133 - 2*x134 - 2*x135 + x137))
    x140 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x141 = x140*(-n0 + p0)
    x142 = x141*x7
    x143 = x142*x90
    x144 = x141*x4
    x145 = x144*x34
    x146 = x144*x92
    x147 = x142*x31
    x148 = x1*x141
    x149 = x148*x92
    x150 = x142*x67
    x151 = x142*x88
    x152 = x148*x34
    x153 = x16*x39
    x154 = x153 - x51
    x155 = x144*x88
    x156 = x148*x31
    x157 = x148*x90
    x158 = x144*x67
    x159 = x12*x39
    x160 = -x159 + x44
    x161 = 2*x159
    x162 = 2*x44
    x163 = -x161 + x162
    x164 = 2*x51
    x165 = 2*x153
    x166 = -x164 + x165
    x167 = x77*(-x78*(2*x143 + 2*x145 - 2*x146 - 2*x147) - x82*(2*x155 + 2*x156 - 2*x157 - 2*x158 + x163) - x86*(2*x149 + 2*x150 - 2*x151 - 2*x152 + x166))
    x168 = x140*(-n1 + p1)
    x169 = x1*x168
    x170 = x169*x92
    x171 = x168*x7
    x172 = x171*x67
    x173 = x171*x88
    x174 = x169*x34
    x175 = x171*x90
    x176 = x168*x4
    x177 = x176*x34
    x178 = x176*x92
    x179 = x171*x31
    x180 = -x153 + x51
    x181 = x176*x88
    x182 = x169*x31
    x183 = x169*x90
    x184 = x176*x67
    x185 = x13*x39
    x186 = x185 - x47
    x187 = 2*x47
    x188 = 2*x185
    x189 = -x187 + x188
    x190 = x164 - x165
    x191 = x77*(-x78*(2*x175 + 2*x177 - 2*x178 - 2*x179 + x190) - x82*(2*x181 + 2*x182 - 2*x183 - 2*x184 + x189) - x86*(2*x170 + 2*x172 - 2*x173 - 2*x174))
    x192 = x140*(-n2 + p2)
    x193 = x192*x4
    x194 = x193*x88
    x195 = x1*x192
    x196 = x195*x31
    x197 = x195*x90
    x198 = x193*x67
    x199 = x192*x7
    x200 = x199*x90
    x201 = x193*x34
    x202 = x193*x92
    x203 = x199*x31
    x204 = x159 - x44
    x205 = x195*x92
    x206 = x199*x67
    x207 = x199*x88
    x208 = x195*x34
    x209 = -x185 + x47
    x210 = x187 - x188
    x211 = x161 - x162
    x212 = x77*(-x78*(2*x200 + 2*x201 - 2*x202 - 2*x203 + x211) - x82*(2*x194 + 2*x196 - 2*x197 - 2*x198) - x86*(2*x205 + 2*x206 - 2*x207 - 2*x208 + x210))
    x213 = x29**(mpmath.mpf(-3)/mpmath.mpf(2))
    x214 = x213*(-o0 + p0)
    x215 = x214*x25
    x216 = x215*x92
    x217 = x214*x27
    x218 = x217*x36
    x219 = x217*x90
    x220 = x11*x215
    x221 = x217*x88
    x222 = x214*x23
    x223 = x11*x222
    x224 = x222*x92
    x225 = x217*x63
    x226 = x43*x7
    x227 = x16*x41
    x228 = x226 - x227
    x229 = x222*x90
    x230 = x215*x63
    x231 = x215*x88
    x232 = x222*x36
    x233 = x12*x41
    x234 = x4*x43
    x235 = x233 - x234
    x236 = 2*x234
    x237 = 2*x233
    x238 = -x236 + x237
    x239 = 2*x227
    x240 = 2*x226
    x241 = -x239 + x240
    x242 = x77*(-x78*(2*x216 + 2*x218 - 2*x219 - 2*x220) - x82*(2*x229 + 2*x230 - 2*x231 - 2*x232 + x238) - x86*(2*x221 + 2*x223 - 2*x224 - 2*x225 + x241))
    x243 = x213*(-o1 + p1)
    x244 = x243*x27
    x245 = x244*x88
    x246 = x23*x243
    x247 = x11*x246
    x248 = x246*x92
    x249 = x244*x63
    x250 = x243*x25
    x251 = x250*x92
    x252 = x244*x36
    x253 = x244*x90
    x254 = x11*x250
    x255 = -x226 + x227
    x256 = x246*x90
    x257 = x250*x63
    x258 = x250*x88
    x259 = x246*x36
    x260 = x1*x43
    x261 = x13*x41
    x262 = x260 - x261
    x263 = 2*x261
    x264 = 2*x260
    x265 = -x263 + x264
    x266 = x239 - x240
    x267 = x77*(-x78*(2*x251 + 2*x252 - 2*x253 - 2*x254 + x266) - x82*(2*x256 + 2*x257 - 2*x258 - 2*x259 + x265) - x86*(2*x245 + 2*x247 - 2*x248 - 2*x249))
    x268 = x213*(-o2 + p2)
    x269 = x23*x268
    x270 = x269*x90
    x271 = x25*x268
    x272 = x271*x63
    x273 = x271*x88
    x274 = x269*x36
    x275 = x271*x92
    x276 = x268*x27
    x277 = x276*x36
    x278 = x276*x90
    x279 = x11*x271
    x280 = -x233 + x234
    x281 = x276*x88
    x282 = x11*x269
    x283 = x269*x92
    x284 = x276*x63
    x285 = -x260 + x261
    x286 = x263 - x264
    x287 = x236 - x237
    x288 = x77*(-x78*(2*x275 + 2*x277 - 2*x278 - 2*x279 + x287) - x82*(2*x270 + 2*x272 - 2*x273 - 2*x274) - x86*(2*x281 + 2*x282 - 2*x283 - 2*x284 + x286))
    x289 = x14*x19
    x290 = x13*x19
    x291 = x12*x290
    x292 = x16*x290
    x293 = x11*x291
    x294 = x292*x31
    x295 = x1*x140
    x296 = x295*x7
    x297 = x296*x90
    x298 = x213*x23
    x299 = x25*x298
    x300 = x299*x92
    x301 = x295*x4
    x302 = x301*x34
    x303 = x27*x298
    x304 = x303*x36
    x305 = x291*x34
    x306 = x292*x36
    x307 = x303*x90
    x308 = x301*x92
    x309 = x296*x31
    x310 = x11*x299
    x311 = x289*x34
    x312 = x140*x2
    x313 = x312*x92
    x314 = x213*x24
    x315 = x11*x314
    x316 = x11*x289
    x317 = x312*x34
    x318 = x314*x92
    x319 = x292*x63
    x320 = x303*x88
    x321 = x296*x67
    x322 = x292*x67
    x323 = x296*x88
    x324 = x303*x63
    x325 = x289*x36
    x326 = x31*x312
    x327 = x314*x90
    x328 = x289*x31
    x329 = x312*x90
    x330 = x314*x36
    x331 = x291*x67
    x332 = x301*x88
    x333 = x299*x63
    x334 = x291*x63
    x335 = x299*x88
    x336 = x301*x67
    x337 = 2*x293
    x338 = 2*x305
    x339 = 2*x306
    x340 = 2*x294
    x341 = 2*x297
    x342 = 2*x307
    x343 = 2*x308
    x344 = 2*x300
    x345 = 2*x302
    x346 = 2*x309
    x347 = 2*x304
    x348 = 2*x310
    x349 = x77*(-x78*(x337 - x338 - x339 + x340 + x341 - x342 - x343 + x344 + x345 - x346 + x347 - x348) - x82*(x138 + x211 + x287 + 2*x325 + 2*x326 + 2*x327 - 2*x328 - 2*x329 - 2*x330 + 2*x331 + 2*x332 + 2*x333 - 2*x334 - 2*x335 - 2*x336) - x86*(x116 + x190 + x266 + 2*x311 + 2*x313 + 2*x315 - 2*x316 - 2*x317 - 2*x318 + 2*x319 + 2*x320 + 2*x321 - 2*x322 - 2*x323 - 2*x324))
    x350 = x15*x19
    x351 = x12*x16*x19
    x352 = x213*x25*x27
    x353 = x352*x88
    x354 = x351*x63
    x355 = x140*x4*x7
    x356 = x355*x67
    x357 = x355*x88
    x358 = x351*x67
    x359 = x352*x63
    x360 = x11*x350
    x361 = x140*x5
    x362 = x34*x361
    x363 = x213*x26
    x364 = x363*x92
    x365 = x34*x350
    x366 = x361*x92
    x367 = x11*x363
    x368 = x31*x351
    x369 = x355*x90
    x370 = x352*x36
    x371 = x351*x36
    x372 = x352*x90
    x373 = x31*x355
    x374 = x350*x67
    x375 = x361*x88
    x376 = x363*x63
    x377 = x350*x63
    x378 = x361*x67
    x379 = x363*x88
    x380 = x291*x36
    x381 = x299*x90
    x382 = x301*x31
    x383 = x291*x31
    x384 = x301*x90
    x385 = x299*x36
    x386 = 2*x357
    x387 = 2*x353
    x388 = 2*x354
    x389 = 2*x358
    x390 = 2*x359
    x391 = 2*x356
    x392 = x77*(-x78*(x166 + x241 + 2*x360 + 2*x362 + 2*x364 - 2*x365 - 2*x366 - 2*x367 + 2*x368 + 2*x369 + 2*x370 - 2*x371 - 2*x372 - 2*x373 + x85) - x82*(x137 + x210 + x286 + 2*x374 + 2*x375 + 2*x376 - 2*x377 - 2*x378 - 2*x379 + 2*x380 + 2*x381 + 2*x382 - 2*x383 - 2*x384 - 2*x385) - x86*(-x337 + x338 + x343 - x344 - x345 + x348 - x386 + x387 + x388 - x389 - x390 + x391))
    x393 = x17*x19
    x394 = x31*x393
    x395 = x140*x8
    x396 = x395*x90
    x397 = x213*x28
    x398 = x36*x397
    x399 = x36*x393
    x400 = x31*x395
    x401 = x397*x90
    x402 = x11*x351
    x403 = x352*x92
    x404 = x34*x355
    x405 = x34*x351
    x406 = x355*x92
    x407 = x11*x352
    x408 = x393*x63
    x409 = x395*x67
    x410 = x397*x88
    x411 = x393*x67
    x412 = x395*x88
    x413 = x397*x63
    x414 = x292*x34
    x415 = x296*x92
    x416 = x11*x303
    x417 = x11*x292
    x418 = x303*x92
    x419 = x296*x34
    x420 = x77*(-x78*(x163 + x238 + 2*x394 + 2*x396 + 2*x398 - 2*x399 - 2*x400 - 2*x401 + 2*x402 + 2*x403 + 2*x404 - 2*x405 - 2*x406 - 2*x407 + x81) - x82*(x339 - x340 - x341 + x342 + x346 - x347 + x386 - x387 - x388 + x389 + x390 - x391) - x86*(x115 + x189 + x265 + 2*x408 + 2*x409 + 2*x410 - 2*x411 - 2*x412 - 2*x413 + 2*x414 + 2*x415 + 2*x416 - 2*x417 - 2*x418 - 2*x419))

    return np.array([x21*x61 + x32*x62 + x57*(x22 + x33 - x35 - x37) + x58 + x59*x60 + x70*(x64 + x65 - x66 - x68 + x69) + x76*(x71 + x72 - x73 - x74 + x75) + x87*x89 + x87*x91 + x87*x93, x101 + x102*x61 + x117*x89 + x117*x91 + x117*x93 + x57*(x103 + x104 - x105 - x106 + x107) + x59*x95 + x62*x97 + x70*(-x100 + x96 + x98 - x99) + x76*(x108 + x109 - x110 - x111 + x112), x119*x59 + x121*x61 + x125 + x126*x62 + x139*x89 + x139*x91 + x139*x93 + x57*(x127 + x128 - x129 - x130 + x131) + x70*(x132 + x133 - x134 - x135 + x136) + x76*(x120 + x122 - x123 - x124), x167*x89 + x167*x91 + x167*x93 + x57*(x143 + x145 - x146 - x147) + x70*(x149 + x150 - x151 - x152 + x154) + x76*(x155 + x156 - x157 - x158 + x160), x191*x89 + x191*x91 + x191*x93 + x57*(x175 + x177 - x178 - x179 + x180) + x70*(x170 + x172 - x173 - x174) + x76*(x181 + x182 - x183 - x184 + x186), x212*x89 + x212*x91 + x212*x93 + x57*(x200 + x201 - x202 - x203 + x204) + x70*(x205 + x206 - x207 - x208 + x209) + x76*(x194 + x196 - x197 - x198), x242*x89 + x242*x91 + x242*x93 + x57*(x216 + x218 - x219 - x220) + x70*(x221 + x223 - x224 - x225 + x228) + x76*(x229 + x230 - x231 - x232 + x235), x267*x89 + x267*x91 + x267*x93 + x57*(x251 + x252 - x253 - x254 + x255) + x70*(x245 + x247 - x248 - x249) + x76*(x256 + x257 - x258 - x259 + x262), x288*x89 + x288*x91 + x288*x93 + x57*(x275 + x277 - x278 - x279 + x280) + x70*(x281 + x282 - x283 - x284 + x285) + x76*(x270 + x272 - x273 - x274), x289*x59 + x291*x61 + x292*x62 + x349*x89 + x349*x91 + x349*x93 + x57*(x293 + x294 + x297 + x300 + x302 + x304 - x305 - x306 - x307 - x308 - x309 - x310) - x58 + x70*(x107 + x180 + x255 + x311 + x313 + x315 - x316 - x317 - x318 + x319 + x320 + x321 - x322 - x323 - x324) + x76*(x131 + x204 + x280 + x325 + x326 + x327 - x328 - x329 - x330 + x331 + x332 + x333 - x334 - x335 - x336), -x101 + x291*x59 + x350*x61 + x351*x62 + x392*x89 + x392*x91 + x392*x93 + x57*(x154 + x228 + x360 + x362 + x364 - x365 - x366 - x367 + x368 + x369 + x370 - x371 - x372 - x373 + x69) + x70*(-x293 - x300 - x302 + x305 + x308 + x310 + x353 + x354 + x356 - x357 - x358 - x359) + x76*(x136 + x209 + x285 + x374 + x375 + x376 - x377 - x378 - x379 + x380 + x381 + x382 - x383 - x384 - x385), -x125 + x292*x59 + x351*x61 + x393*x62 + x420*x89 + x420*x91 + x420*x93 + x57*(x160 + x235 + x394 + x396 + x398 - x399 - x400 - x401 + x402 + x403 + x404 - x405 - x406 - x407 + x75) + x70*(x112 + x186 + x262 + x408 + x409 + x410 - x411 - x412 - x413 + x414 + x415 + x416 - x417 - x418 - x419) + x76*(-x294 - x297 - x304 + x306 + x307 + x309 - x353 - x354 - x356 + x357 + x358 + x359)], dtype=np.float64)


def d2q_oop(m0, m1, m2, n0, n1, n2, o0, o1, o2, p0, p1, p2):
    """OutOfPlane, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -m0 + p0
    x1 = -p1
    x2 = m1 + x1
    x3 = -p2
    x4 = n2 + x3
    x5 = -p0
    x6 = n0 + x5
    x7 = x6**2
    x8 = n1 + x1
    x9 = x8**2
    x10 = x4**2
    x11 = x10 + x7 + x9
    x12 = 1/mpmath.sqrt(x11)
    x13 = m0 + x5
    x14 = x13**2
    x15 = x2**2
    x16 = m2 + x3
    x17 = x16**2
    x18 = x14 + x15 + x17
    x19 = x18**(mpmath.mpf(-3)/mpmath.mpf(2))
    x20 = x12*x19
    x21 = x20*x4
    x22 = x2*x21
    x23 = x0*x22
    x24 = o1 + x1
    x25 = o0 + x5
    x26 = x25**2
    x27 = x24**2
    x28 = o2 + x3
    x29 = x28**2
    x30 = x26 + x27 + x29
    x31 = 1/mpmath.sqrt(x30)
    x32 = x19*x31
    x33 = x16*x32
    x34 = x24*x33
    x35 = x0*x34
    x36 = x28*x32
    x37 = x2*x36
    x38 = x0*x37
    x39 = x16*x20
    x40 = x39*x8
    x41 = x0*x40
    x42 = x23 + x35 - x38 - x41
    x43 = 1/mpmath.sqrt(x18)
    x44 = x12*x43
    x45 = x44*x8
    x46 = x13*x45
    x47 = x31*x43
    x48 = x25*x47
    x49 = x2*x48
    x50 = x12*x31
    x51 = x24*x50
    x52 = x51*x6
    x53 = x24*x47
    x54 = x13*x53
    x55 = x44*x6
    x56 = x2*x55
    x57 = x25*x50
    x58 = x57*x8
    x59 = x46 + x49 + x52 - x54 - x56 - x58
    x60 = x28*x47
    x61 = x13*x60
    x62 = x16*x55
    x63 = x4*x57
    x64 = x4*x44
    x65 = x13*x64
    x66 = x16*x48
    x67 = x28*x50
    x68 = x6*x67
    x69 = x61 + x62 + x63 - x65 - x66 - x68
    x70 = x2*x64
    x71 = x16*x53
    x72 = x67*x8
    x73 = x2*x60
    x74 = x16*x45
    x75 = x4*x51
    x76 = x70 + x71 + x72 - x73 - x74 - x75
    x77 = x59**2 + x69**2 + x76**2
    x78 = 1/mpmath.sqrt(x77)
    x79 = x43*x78
    x80 = x42*x79
    x81 = x18**(mpmath.mpf(-5)/mpmath.mpf(2))
    x82 = 3*m0
    x83 = 3*p0
    x84 = x81*(-x82 + x83)
    x85 = x0*x84
    x86 = x12*x4
    x87 = x2*x86
    x88 = x85*x87
    x89 = x24*x31
    x90 = x16*x85
    x91 = x89*x90
    x92 = x12*x8
    x93 = x90*x92
    x94 = x28*x31
    x95 = x85*x94
    x96 = x2*x95
    x97 = -x22 + x37
    x98 = -x34 + x40
    x99 = x97 + x98
    x100 = x13*x79
    x101 = x12*x6
    x102 = x101*x90
    x103 = x13*x95
    x104 = x13*x85
    x105 = x104*x86
    x106 = x25*x31
    x107 = x106*x90
    x108 = x13*x21
    x109 = x13*x36
    x110 = x108 - x109
    x111 = x25*x33
    x112 = x39*x6
    x113 = x111 - x112
    x114 = x110 + x113
    x115 = x0*x21
    x116 = 2*x115
    x117 = x0*x36
    x118 = 2*x117
    x119 = -x116 + x118
    x120 = x2*x79
    x121 = x104*x92
    x122 = x2*x85
    x123 = x106*x122
    x124 = x101*x122
    x125 = x104*x89
    x126 = x24*x32
    x127 = x126*x13
    x128 = x20*x8
    x129 = x128*x13
    x130 = x127 - x129
    x131 = x20*x6
    x132 = x131*x2
    x133 = x25*x32
    x134 = x133*x2
    x135 = x132 - x134
    x136 = x130 + x135
    x137 = x0*x126
    x138 = 2*x137
    x139 = x0*x128
    x140 = 2*x139
    x141 = -x138 + x140
    x142 = x16*x79
    x143 = x19*x78
    x144 = x143*x76
    x145 = x0*x144
    x146 = x76*(2*x23 + 2*x35 - 2*x38 - 2*x41)
    x147 = x0*x132
    x148 = x0*x127
    x149 = x0*x129
    x150 = x0*x134
    x151 = 2*x53
    x152 = 2*x45
    x153 = -x151 + x152
    x154 = x59*(-2*x147 - 2*x148 + 2*x149 + 2*x150 + x153)
    x155 = x0*x108
    x156 = x0*x111
    x157 = x0*x112
    x158 = x0*x109
    x159 = 2*x64
    x160 = 2*x60
    x161 = -x159 + x160
    x162 = x69*(-2*x155 - 2*x156 + 2*x157 + 2*x158 + x161)
    x163 = -mpmath.mpf(1)/mpmath.mpf(2)*x146 - mpmath.mpf(1)/mpmath.mpf(2)*x154 - mpmath.mpf(1)/mpmath.mpf(2)*x162
    x164 = x77**(mpmath.mpf(-3)/mpmath.mpf(2))
    x165 = x164*x43
    x166 = x165*x76
    x167 = x163*x166
    x168 = -x23 - x35 + x38 + x41
    x169 = -x45 + x53
    x170 = x147 + x148 - x149 - x150 + x169
    x171 = x45 - x53
    x172 = -x147 - x148 + x149 + x150 + x171
    x173 = x60 - x64
    x174 = -x155 - x156 + x157 + x158 + x173
    x175 = -x60 + x64
    x176 = x155 + x156 - x157 - x158 + x175
    x177 = x22 - x37
    x178 = x34 - x40
    x179 = x177 + x178
    x180 = -x127 + x129
    x181 = -x132 + x134
    x182 = x180 + x181
    x183 = x138 - x140
    x184 = -x108 + x109
    x185 = -x111 + x112
    x186 = x184 + x185
    x187 = x116 - x118
    x188 = x168*x42 + x170*x172 + x174*x176 + x59*(-x121 - x123 + x124 + x125 + x182 + x183) + x69*(-x102 - x103 + x105 + x107 + x186 + x187) + x76*(x179 - x88 - x91 + x93 + x96)
    x189 = x13*x76
    x190 = x165*x189
    x191 = x165*x69
    x192 = x191*x2
    x193 = x165*x59
    x194 = x16*x193
    x195 = x13*x143
    x196 = x0*x195
    x197 = x143*x2
    x198 = x0*x197
    x199 = x143*x16
    x200 = x0*x199
    x201 = x13*x42
    x202 = x163*x165
    x203 = 2*x202
    x204 = x174*x2
    x205 = x16*x172
    x206 = x189*x78
    x207 = x69*x78
    x208 = x59*x78
    x209 = x77**(mpmath.mpf(-5)/mpmath.mpf(2))
    x210 = x209*(-mpmath.mpf(3)/mpmath.mpf(2)*x146 - mpmath.mpf(3)/mpmath.mpf(2)*x154 - mpmath.mpf(3)/mpmath.mpf(2)*x162)
    x211 = x163*x210
    x212 = x189*x43
    x213 = x2*x43
    x214 = x213*x69
    x215 = x16*x43
    x216 = x215*x59
    x217 = x0*x19
    x218 = x189*x217
    x219 = x163*x164
    x220 = 2*x219
    x221 = x2*x217
    x222 = x221*x69
    x223 = x16*x217
    x224 = x223*x59
    x225 = x143*x189
    x226 = x143*x69
    x227 = x2*x226
    x228 = x143*x59
    x229 = x16*x228
    x230 = -x225 - x227 - x229
    x231 = -m1 + p1
    x232 = x231*x84
    x233 = x232*x87
    x234 = x16*x232
    x235 = x234*x89
    x236 = x234*x92
    x237 = x232*x94
    x238 = x2*x237
    x239 = x115 - x117
    x240 = x101*x234
    x241 = x13*x237
    x242 = x13*x232
    x243 = x242*x86
    x244 = x106*x234
    x245 = x231*x36
    x246 = x21*x231
    x247 = x245 - x246
    x248 = x242*x92
    x249 = x2*x232
    x250 = x106*x249
    x251 = x101*x249
    x252 = x242*x89
    x253 = x0*x133
    x254 = x0*x131
    x255 = x253 - x254
    x256 = x128*x231
    x257 = x126*x231
    x258 = x256 - x257
    x259 = x255 + x258
    x260 = x231*x40
    x261 = x231*x37
    x262 = x22*x231
    x263 = x231*x34
    x264 = x173 + x260 + x261 - x262 - x263
    x265 = x108*x231
    x266 = x111*x231
    x267 = x109*x231
    x268 = x112*x231
    x269 = x265 + x266 - x267 - x268
    x270 = x132*x231
    x271 = x127*x231
    x272 = x129*x231
    x273 = x134*x231
    x274 = -x48 + x55
    x275 = x270 + x271 - x272 - x273 + x274
    x276 = -x245 + x246
    x277 = -x115 + x117
    x278 = -x253 + x254
    x279 = -x256 + x257
    x280 = x278 + x279
    x281 = x172*x275 + x174*x269 + x264*x42 + x59*(-x248 - x250 + x251 + x252 + x280) + x69*(-x240 - x241 + x243 + x244 + x276) + x76*(-x233 - x235 + x236 + x238 + x277)
    x282 = -2*x265 - 2*x266 + 2*x267 + 2*x268
    x283 = (mpmath.mpf(1)/mpmath.mpf(2))*x69
    x284 = 2*x55
    x285 = 2*x48
    x286 = -x284 + x285
    x287 = -2*x270 - 2*x271 + 2*x272 + 2*x273 + x286
    x288 = (mpmath.mpf(1)/mpmath.mpf(2))*x59
    x289 = x159 - x160
    x290 = -2*x260 - 2*x261 + 2*x262 + 2*x263 + x289
    x291 = (mpmath.mpf(1)/mpmath.mpf(2))*x76
    x292 = -x282*x283 - x287*x288 - x290*x291
    x293 = x210*x292
    x294 = x175 - x260 - x261 + x262 + x263
    x295 = x294*x79
    x296 = x174*x79
    x297 = x0*x226
    x298 = x144*x231
    x299 = x166*x292
    x300 = x202*x69
    x301 = x195*x42
    x302 = -x265 - x266 + x267 + x268
    x303 = x174*x197
    x304 = x48 - x55
    x305 = -x270 - x271 + x272 + x273 + x304
    x306 = x172*x199
    x307 = x165*x292
    x308 = x13*x202
    x309 = x2*x202
    x310 = x16*x202
    x311 = x164*x292
    x312 = x19*x231
    x313 = x189*x219
    x314 = x2*x312
    x315 = x219*x69
    x316 = x16*x312
    x317 = x219*x59
    x318 = x196*x294 + x198*x302 + x200*x305 + x201*x307 + x204*x307 + x205*x307 + x218*x311 + x222*x311 + x224*x311 + x231*x301 + x231*x303 + x231*x306 + x294*x308 + x295 + x296 + x297 + x298 + x299 + x300 + x302*x309 + x305*x310 + x312*x313 + x314*x315 + x316*x317
    x319 = -m2 + p2
    x320 = x319*x84
    x321 = x320*x87
    x322 = x16*x320
    x323 = x322*x89
    x324 = x322*x92
    x325 = x320*x94
    x326 = x2*x325
    x327 = x137 - x139
    x328 = x101*x322
    x329 = x13*x325
    x330 = x13*x320
    x331 = x330*x86
    x332 = x106*x322
    x333 = x319*x36
    x334 = x21*x319
    x335 = x333 - x334
    x336 = x278 + x335
    x337 = x330*x92
    x338 = x2*x320
    x339 = x106*x338
    x340 = x101*x338
    x341 = x330*x89
    x342 = x128*x319
    x343 = x126*x319
    x344 = x342 - x343
    x345 = x319*x40
    x346 = x319*x37
    x347 = x22*x319
    x348 = x319*x34
    x349 = x171 + x345 + x346 - x347 - x348
    x350 = x127*x319
    x351 = x132*x319
    x352 = x129*x319
    x353 = x134*x319
    x354 = x350 + x351 - x352 - x353
    x355 = x108*x319
    x356 = x111*x319
    x357 = x112*x319
    x358 = x109*x319
    x359 = x304 + x355 + x356 - x357 - x358
    x360 = -x342 + x343
    x361 = -x137 + x139
    x362 = -x333 + x334
    x363 = x255 + x362
    x364 = x172*x354 + x174*x359 + x349*x42 + x59*(-x337 - x339 + x340 + x341 + x360) + x69*(-x328 - x329 + x331 + x332 + x363) + x76*(-x321 - x323 + x324 + x326 + x361)
    x365 = -2*x350 - 2*x351 + 2*x352 + 2*x353
    x366 = x284 - x285
    x367 = -2*x355 - 2*x356 + 2*x357 + 2*x358 + x366
    x368 = x151 - x152
    x369 = -2*x345 - 2*x346 + 2*x347 + 2*x348 + x368
    x370 = -x283*x367 - x288*x365 - x291*x369
    x371 = x210*x370
    x372 = x172*x79
    x373 = x169 - x345 - x346 + x347 + x348
    x374 = x373*x79
    x375 = x0*x228
    x376 = x144*x319
    x377 = x166*x370
    x378 = x202*x59
    x379 = x274 - x355 - x356 + x357 + x358
    x380 = -x350 - x351 + x352 + x353
    x381 = x165*x370
    x382 = x164*x370
    x383 = x19*x319
    x384 = x2*x383
    x385 = x16*x383
    x386 = x196*x373 + x198*x379 + x200*x380 + x201*x381 + x204*x381 + x205*x381 + x218*x382 + x222*x382 + x224*x382 + x301*x319 + x303*x319 + x306*x319 + x308*x373 + x309*x379 + x310*x380 + x313*x383 + x315*x384 + x317*x385 + x372 + x374 + x375 + x376 + x377 + x378
    x387 = -n0 + p0
    x388 = x11**(mpmath.mpf(-3)/mpmath.mpf(2))
    x389 = x388*x43
    x390 = x387*x389
    x391 = x390*x8
    x392 = x16*x391
    x393 = x31*x388
    x394 = x393*x4
    x395 = x24*x394
    x396 = x387*x395
    x397 = x390*x4
    x398 = x2*x397
    x399 = x28*x393
    x400 = x399*x8
    x401 = x387*x400
    x402 = x392 + x396 - x398 - x401
    x403 = x390*x6
    x404 = x2*x403
    x405 = x25*x393
    x406 = x405*x8
    x407 = x387*x406
    x408 = x13*x391
    x409 = x24*x393
    x410 = x409*x6
    x411 = x387*x410
    x412 = x2*x44
    x413 = x412 - x51
    x414 = x404 + x407 - x408 - x411 + x413
    x415 = x13*x397
    x416 = x399*x6
    x417 = x387*x416
    x418 = x16*x403
    x419 = x25*x394
    x420 = x387*x419
    x421 = x16*x44
    x422 = -x421 + x67
    x423 = x415 + x417 - x418 - x420 + x422
    x424 = x387*x388
    x425 = x424*x8
    x426 = x223*x425
    x427 = x4*x424
    x428 = x221*x427
    x429 = x0*x20
    x430 = x2*x429
    x431 = -x391
    x432 = x424*x6
    x433 = x221*x432
    x434 = x13*x217
    x435 = x425*x434
    x436 = x0*x39
    x437 = -x436
    x438 = x427*x434
    x439 = x223*x432
    x440 = x59*(x430 + x431 + x433 - x435) + x69*(x397 + x437 + x438 - x439) + x76*(x426 - x428)
    x441 = x172*x414 + x174*x423 + x402*x42 + x440
    x442 = -2*x392 - 2*x396 + 2*x398 + 2*x401
    x443 = 2*x412
    x444 = 2*x51
    x445 = -x443 + x444
    x446 = -2*x404 - 2*x407 + 2*x408 + 2*x411 + x445
    x447 = 2*x67
    x448 = 2*x421
    x449 = -x447 + x448
    x450 = -2*x415 - 2*x417 + 2*x418 + 2*x420 + x449
    x451 = -x283*x450 - x288*x446 - x291*x442
    x452 = x210*x451
    x453 = -x392 - x396 + x398 + x401
    x454 = x453*x79
    x455 = x166*x451
    x456 = -x397
    x457 = -x430
    x458 = x421 - x67
    x459 = -x415 - x417 + x418 + x420 + x458
    x460 = -x412 + x51
    x461 = -x404 - x407 + x408 + x411 + x460
    x462 = x165*x451
    x463 = x164*x451
    x464 = x100*(-x426 + x428) + x120*(x436 - x438 + x439 + x456) + x142*(x391 - x433 + x435 + x457) + x196*x453 + x198*x459 + x200*x461 + x201*x462 + x204*x462 + x205*x462 + x218*x463 + x222*x463 + x224*x463 + x308*x453 + x309*x459 + x310*x461 + x454 + x455
    x465 = -n1 + p1
    x466 = x389*x465
    x467 = x466*x8
    x468 = x16*x467
    x469 = x395*x465
    x470 = x4*x466
    x471 = x2*x470
    x472 = x400*x465
    x473 = x458 + x468 + x469 - x471 - x472
    x474 = x13*x470
    x475 = x416*x465
    x476 = x466*x6
    x477 = x16*x476
    x478 = x419*x465
    x479 = x474 + x475 - x477 - x478
    x480 = x2*x476
    x481 = x406*x465
    x482 = x13*x467
    x483 = x410*x465
    x484 = x13*x44
    x485 = -x484 + x57
    x486 = x480 + x481 - x482 - x483 + x485
    x487 = x388*x465
    x488 = x487*x8
    x489 = x223*x488
    x490 = x4*x487
    x491 = x221*x490
    x492 = x434*x490
    x493 = x487*x6
    x494 = x223*x493
    x495 = -x467
    x496 = x221*x493
    x497 = x434*x488
    x498 = -x44
    x499 = x13*x429
    x500 = x498 - x499
    x501 = x59*(x495 + x496 - x497 + x500) + x69*(x470 + x492 - x494) + x76*(x436 + x489 - x491)
    x502 = x172*x486 + x174*x479 + x42*x473 + x501
    x503 = -2*x474 - 2*x475 + 2*x477 + 2*x478
    x504 = 2*x57
    x505 = 2*x484
    x506 = -x504 + x505
    x507 = -2*x480 - 2*x481 + 2*x482 + 2*x483 + x506
    x508 = x447 - x448
    x509 = -2*x468 - 2*x469 + 2*x471 + 2*x472 + x508
    x510 = -x283*x503 - x288*x507 - x291*x509
    x511 = x210*x510
    x512 = x422 - x468 - x469 + x471 + x472
    x513 = x512*x79
    x514 = x166*x510
    x515 = -x470
    x516 = x44 + x499
    x517 = -x474 - x475 + x477 + x478
    x518 = x484 - x57
    x519 = -x480 - x481 + x482 + x483 + x518
    x520 = x165*x510
    x521 = x164*x510
    x522 = x100*(x437 - x489 + x491) + x120*(-x492 + x494 + x515) + x142*(x467 - x496 + x497 + x516) + x196*x512 + x198*x517 + x200*x519 + x201*x520 + x204*x520 + x205*x520 + x218*x521 + x222*x521 + x224*x521 + x308*x512 + x309*x517 + x310*x519 + x513 + x514
    x523 = -n2 + p2
    x524 = x389*x523
    x525 = x524*x8
    x526 = x16*x525
    x527 = x395*x523
    x528 = x4*x524
    x529 = x2*x528
    x530 = x400*x523
    x531 = x460 + x526 + x527 - x529 - x530
    x532 = x524*x6
    x533 = x2*x532
    x534 = x406*x523
    x535 = x13*x525
    x536 = x410*x523
    x537 = x533 + x534 - x535 - x536
    x538 = x13*x528
    x539 = x416*x523
    x540 = x16*x532
    x541 = x419*x523
    x542 = x518 + x538 + x539 - x540 - x541
    x543 = x388*x523
    x544 = x543*x8
    x545 = x223*x544
    x546 = x4*x543
    x547 = x221*x546
    x548 = -x525
    x549 = x543*x6
    x550 = x221*x549
    x551 = x434*x544
    x552 = x434*x546
    x553 = x223*x549
    x554 = x59*(x548 + x550 - x551) + x69*(x516 + x528 + x552 - x553) + x76*(x457 + x545 - x547)
    x555 = x172*x537 + x174*x542 + x42*x531 + x554
    x556 = -2*x533 - 2*x534 + 2*x535 + 2*x536
    x557 = x504 - x505
    x558 = -2*x538 - 2*x539 + 2*x540 + 2*x541 + x557
    x559 = x443 - x444
    x560 = -2*x526 - 2*x527 + 2*x529 + 2*x530 + x559
    x561 = -x283*x558 - x288*x556 - x291*x560
    x562 = x210*x561
    x563 = x413 - x526 - x527 + x529 + x530
    x564 = x563*x79
    x565 = x166*x561
    x566 = -x528
    x567 = x485 - x538 - x539 + x540 + x541
    x568 = -x533 - x534 + x535 + x536
    x569 = x165*x561
    x570 = x164*x561
    x571 = x100*(x430 - x545 + x547) + x120*(x500 - x552 + x553 + x566) + x142*(x525 - x550 + x551) + x196*x563 + x198*x567 + x200*x568 + x201*x569 + x204*x569 + x205*x569 + x218*x570 + x222*x570 + x224*x570 + x308*x563 + x309*x567 + x310*x568 + x564 + x565
    x572 = -o0 + p0
    x573 = x30**(mpmath.mpf(-3)/mpmath.mpf(2))
    x574 = x43*x573
    x575 = x572*x574
    x576 = x28*x575
    x577 = x2*x576
    x578 = x12*x573
    x579 = x572*x578
    x580 = x24*x579
    x581 = x4*x580
    x582 = x24*x575
    x583 = x16*x582
    x584 = x28*x579
    x585 = x584*x8
    x586 = x577 + x581 - x583 - x585
    x587 = x13*x582
    x588 = x25*x579
    x589 = x588*x8
    x590 = x25*x575
    x591 = x2*x590
    x592 = x580*x6
    x593 = x50*x8
    x594 = x2*x47
    x595 = x593 - x594
    x596 = x587 + x589 - x591 - x592 + x595
    x597 = x16*x590
    x598 = x584*x6
    x599 = x13*x576
    x600 = x4*x588
    x601 = x16*x47
    x602 = x4*x50
    x603 = x601 - x602
    x604 = x597 + x598 - x599 - x600 + x603
    x605 = x572*x573
    x606 = x28*x605
    x607 = x221*x606
    x608 = x24*x605
    x609 = x223*x608
    x610 = x0*x33
    x611 = -x576
    x612 = x25*x605
    x613 = x223*x612
    x614 = x434*x606
    x615 = x0*x32
    x616 = x2*x615
    x617 = -x616
    x618 = x434*x608
    x619 = x221*x612
    x620 = x59*(x582 + x617 + x618 - x619) + x69*(x610 + x611 + x613 - x614) + x76*(x607 - x609)
    x621 = x172*x596 + x174*x604 + x42*x586 + x620
    x622 = -2*x577 - 2*x581 + 2*x583 + 2*x585
    x623 = 2*x593
    x624 = 2*x594
    x625 = -x623 + x624
    x626 = -2*x587 - 2*x589 + 2*x591 + 2*x592 + x625
    x627 = 2*x601
    x628 = 2*x602
    x629 = -x627 + x628
    x630 = -2*x597 - 2*x598 + 2*x599 + 2*x600 + x629
    x631 = -x283*x630 - x288*x626 - x291*x622
    x632 = x210*x631
    x633 = -x577 - x581 + x583 + x585
    x634 = x633*x79
    x635 = x166*x631
    x636 = -x610
    x637 = -x582
    x638 = -x601 + x602
    x639 = -x597 - x598 + x599 + x600 + x638
    x640 = -x593 + x594
    x641 = -x587 - x589 + x591 + x592 + x640
    x642 = x165*x631
    x643 = x164*x631
    x644 = x100*(-x607 + x609) + x120*(x576 - x613 + x614 + x636) + x142*(x616 - x618 + x619 + x637) + x196*x633 + x198*x639 + x200*x641 + x201*x642 + x204*x642 + x205*x642 + x218*x643 + x222*x643 + x224*x643 + x308*x633 + x309*x639 + x310*x641 + x634 + x635
    x645 = -o1 + p1
    x646 = x574*x645
    x647 = x28*x646
    x648 = x2*x647
    x649 = x578*x645
    x650 = x24*x649
    x651 = x4*x650
    x652 = x24*x646
    x653 = x16*x652
    x654 = x28*x649
    x655 = x654*x8
    x656 = x638 + x648 + x651 - x653 - x655
    x657 = x25*x646
    x658 = x16*x657
    x659 = x6*x654
    x660 = x13*x647
    x661 = x25*x649
    x662 = x4*x661
    x663 = x658 + x659 - x660 - x662
    x664 = x13*x652
    x665 = x661*x8
    x666 = x2*x657
    x667 = x6*x650
    x668 = x13*x47
    x669 = x50*x6
    x670 = x668 - x669
    x671 = x664 + x665 - x666 - x667 + x670
    x672 = x573*x645
    x673 = x28*x672
    x674 = x221*x673
    x675 = x24*x672
    x676 = x223*x675
    x677 = -x647
    x678 = x25*x672
    x679 = x223*x678
    x680 = x434*x673
    x681 = x434*x675
    x682 = x221*x678
    x683 = x13*x615
    x684 = x47 + x683
    x685 = x59*(x652 + x681 - x682 + x684) + x69*(x677 + x679 - x680) + x76*(x636 + x674 - x676)
    x686 = x172*x671 + x174*x663 + x42*x656 + x685
    x687 = -2*x658 - 2*x659 + 2*x660 + 2*x662
    x688 = 2*x668
    x689 = 2*x669
    x690 = -x688 + x689
    x691 = -2*x664 - 2*x665 + 2*x666 + 2*x667 + x690
    x692 = x627 - x628
    x693 = -2*x648 - 2*x651 + 2*x653 + 2*x655 + x692
    x694 = -x283*x687 - x288*x691 - x291*x693
    x695 = x210*x694
    x696 = x603 - x648 - x651 + x653 + x655
    x697 = x696*x79
    x698 = x166*x694
    x699 = -x652
    x700 = -x47
    x701 = -x683 + x700
    x702 = -x658 - x659 + x660 + x662
    x703 = -x668 + x669
    x704 = -x664 - x665 + x666 + x667 + x703
    x705 = x165*x694
    x706 = x164*x694
    x707 = x100*(x610 - x674 + x676) + x120*(x647 - x679 + x680) + x142*(-x681 + x682 + x699 + x701) + x196*x696 + x198*x702 + x200*x704 + x201*x705 + x204*x705 + x205*x705 + x218*x706 + x222*x706 + x224*x706 + x308*x696 + x309*x702 + x310*x704 + x697 + x698
    x708 = -o2 + p2
    x709 = x574*x708
    x710 = x28*x709
    x711 = x2*x710
    x712 = x578*x708
    x713 = x24*x712
    x714 = x4*x713
    x715 = x24*x709
    x716 = x16*x715
    x717 = x28*x712
    x718 = x717*x8
    x719 = x640 + x711 + x714 - x716 - x718
    x720 = x13*x715
    x721 = x25*x712
    x722 = x721*x8
    x723 = x25*x709
    x724 = x2*x723
    x725 = x6*x713
    x726 = x720 + x722 - x724 - x725
    x727 = x16*x723
    x728 = x6*x717
    x729 = x13*x710
    x730 = x4*x721
    x731 = x703 + x727 + x728 - x729 - x730
    x732 = x573*x708
    x733 = x28*x732
    x734 = x221*x733
    x735 = x24*x732
    x736 = x223*x735
    x737 = x434*x735
    x738 = x25*x732
    x739 = x221*x738
    x740 = -x710
    x741 = x223*x738
    x742 = x434*x733
    x743 = x59*(x715 + x737 - x739) + x69*(x701 + x740 + x741 - x742) + x76*(x616 + x734 - x736)
    x744 = x172*x726 + x174*x731 + x42*x719 + x743
    x745 = -2*x720 - 2*x722 + 2*x724 + 2*x725
    x746 = x688 - x689
    x747 = -2*x727 - 2*x728 + 2*x729 + 2*x730 + x746
    x748 = x623 - x624
    x749 = -2*x711 - 2*x714 + 2*x716 + 2*x718 + x748
    x750 = -x283*x747 - x288*x745 - x291*x749
    x751 = x210*x750
    x752 = x595 - x711 - x714 + x716 + x718
    x753 = x752*x79
    x754 = x166*x750
    x755 = -x715
    x756 = x670 - x727 - x728 + x729 + x730
    x757 = -x720 - x722 + x724 + x725
    x758 = x165*x750
    x759 = x164*x750
    x760 = x100*(x617 - x734 + x736) + x120*(x684 + x710 - x741 + x742) + x142*(-x737 + x739 + x755) + x196*x752 + x198*x756 + x200*x757 + x201*x758 + x204*x758 + x205*x758 + x218*x759 + x222*x759 + x224*x759 + x308*x752 + x309*x756 + x310*x757 + x753 + x754
    x761 = 2*m0
    x762 = 2*p0
    x763 = -x762
    x764 = x761 + x763
    x765 = x13*x2
    x766 = x765*x84
    x767 = x766*x86
    x768 = x16*x84
    x769 = x13*x89
    x770 = x768*x769
    x771 = x13*x768
    x772 = x771*x92
    x773 = x766*x94
    x774 = x25*x573
    x775 = x24*x774
    x776 = x223*x775
    x777 = x6*x8
    x778 = x388*x777
    x779 = x223*x778
    x780 = x776 - x779
    x781 = x388*x4
    x782 = x6*x781
    x783 = x221*x782
    x784 = x28*x774
    x785 = x221*x784
    x786 = x783 - x785
    x787 = x179 + x780 + x786
    x788 = -x761 + x762
    x789 = x14*x84
    x790 = x789*x94
    x791 = x12*x789
    x792 = x4*x791
    x793 = x101*x771
    x794 = x106*x771
    x795 = x388*x7
    x796 = x223*x795
    x797 = x26*x573
    x798 = x223*x797
    x799 = x434*x784
    x800 = x434*x782
    x801 = x25*x574
    x802 = x28*x801
    x803 = x389*x6
    x804 = x4*x803
    x805 = x802 - x804
    x806 = x239 + x437 + x610
    x807 = x185 + x796 - x798 + x799 - x800 + x805 + x806
    x808 = x791*x8
    x809 = x789*x89
    x810 = x106*x766
    x811 = x101*x766
    x812 = x221*x797
    x813 = x221*x795
    x814 = x434*x778
    x815 = x434*x775
    x816 = x8*x803
    x817 = x24*x801
    x818 = x816 - x817
    x819 = x327 + x430 + x617
    x820 = x181 + x812 - x813 + x814 - x815 + x818 + x819
    x821 = x76*x78
    x822 = -mpmath.mpf(1)/mpmath.mpf(2)*x23 - mpmath.mpf(1)/mpmath.mpf(2)*x35 + (mpmath.mpf(1)/mpmath.mpf(2))*x38 + (mpmath.mpf(1)/mpmath.mpf(2))*x41
    x823 = x13*x22
    x824 = 2*x823
    x825 = x13*x37
    x826 = 2*x825
    x827 = x13*x40
    x828 = 2*x827
    x829 = x13*x34
    x830 = 2*x829
    x831 = x2*x804
    x832 = 2*x831
    x833 = x2*x802
    x834 = 2*x833
    x835 = x16*x816
    x836 = 2*x835
    x837 = x16*x817
    x838 = 2*x837
    x839 = x400*x6
    x840 = 2*x839
    x841 = x395*x6
    x842 = 2*x841
    x843 = x25*x578
    x844 = x28*x843
    x845 = x8*x844
    x846 = 2*x845
    x847 = x24*x843
    x848 = x4*x847
    x849 = 2*x848
    x850 = x824 - x826 - x828 + x830 + x832 - x834 - x836 + x838 + x840 - x842 + x846 - x849
    x851 = -mpmath.mpf(1)/mpmath.mpf(2)*x70 - mpmath.mpf(1)/mpmath.mpf(2)*x71 - mpmath.mpf(1)/mpmath.mpf(2)*x72 + (mpmath.mpf(1)/mpmath.mpf(2))*x73 + (mpmath.mpf(1)/mpmath.mpf(2))*x74 + (mpmath.mpf(1)/mpmath.mpf(2))*x75
    x852 = 2*x772
    x853 = 2*x773
    x854 = 2*x779
    x855 = 2*x785
    x856 = 2*x767
    x857 = 2*x770
    x858 = 2*x783
    x859 = 2*x776
    x860 = 2*x40
    x861 = 2*x34
    x862 = -x860 + x861
    x863 = 2*x37
    x864 = 2*x22
    x865 = -x863 + x864
    x866 = (mpmath.mpf(1)/mpmath.mpf(2))*x53
    x867 = (mpmath.mpf(1)/mpmath.mpf(2))*x45
    x868 = x866 - x867
    x869 = (mpmath.mpf(1)/mpmath.mpf(2))*x147 + (mpmath.mpf(1)/mpmath.mpf(2))*x148 - mpmath.mpf(1)/mpmath.mpf(2)*x149 - mpmath.mpf(1)/mpmath.mpf(2)*x150 + x868
    x870 = x14*x32
    x871 = x24*x870
    x872 = x389*x7
    x873 = x2*x872
    x874 = x26*x578
    x875 = x8*x874
    x876 = x14*x20
    x877 = x8*x876
    x878 = x393*x7
    x879 = x24*x878
    x880 = x26*x574
    x881 = x2*x880
    x882 = x13*x132
    x883 = x13*x817
    x884 = x406*x6
    x885 = x13*x134
    x886 = x13*x816
    x887 = x6*x847
    x888 = x368 + x559 + x748 - 2*x871 - 2*x873 - 2*x875 + 2*x877 + 2*x879 + 2*x881 - 2*x882 - 2*x883 - 2*x884 + 2*x885 + 2*x886 + 2*x887
    x889 = (mpmath.mpf(1)/mpmath.mpf(2))*x64
    x890 = (mpmath.mpf(1)/mpmath.mpf(2))*x60
    x891 = x889 - x890
    x892 = (mpmath.mpf(1)/mpmath.mpf(2))*x155 + (mpmath.mpf(1)/mpmath.mpf(2))*x156 - mpmath.mpf(1)/mpmath.mpf(2)*x157 - mpmath.mpf(1)/mpmath.mpf(2)*x158 + x891
    x893 = x4*x876
    x894 = x28*x878
    x895 = x16*x880
    x896 = x28*x870
    x897 = x16*x872
    x898 = x4*x874
    x899 = x111*x13
    x900 = x13*x804
    x901 = x6*x844
    x902 = x112*x13
    x903 = x13*x802
    x904 = x419*x6
    x905 = x289 + x508 + x692 - 2*x893 - 2*x894 - 2*x895 + 2*x896 + 2*x897 + 2*x898 - 2*x899 - 2*x900 - 2*x901 + 2*x902 + 2*x903 + 2*x904
    x906 = -mpmath.mpf(1)/mpmath.mpf(2)*x46 - mpmath.mpf(1)/mpmath.mpf(2)*x49 - mpmath.mpf(1)/mpmath.mpf(2)*x52 + (mpmath.mpf(1)/mpmath.mpf(2))*x54 + (mpmath.mpf(1)/mpmath.mpf(2))*x56 + (mpmath.mpf(1)/mpmath.mpf(2))*x58
    x907 = 4*m0
    x908 = 4*p0
    x909 = -x908
    x910 = x907 + x909
    x911 = -x907 + x908
    x912 = 2*x616
    x913 = 2*x430
    x914 = 2*x817
    x915 = 2*x816
    x916 = -x914 + x915
    x917 = 2*x132
    x918 = 2*x134
    x919 = -x917 + x918
    x920 = -mpmath.mpf(1)/mpmath.mpf(2)*x61 - mpmath.mpf(1)/mpmath.mpf(2)*x62 - mpmath.mpf(1)/mpmath.mpf(2)*x63 + (mpmath.mpf(1)/mpmath.mpf(2))*x65 + (mpmath.mpf(1)/mpmath.mpf(2))*x66 + (mpmath.mpf(1)/mpmath.mpf(2))*x68
    x921 = 2*x436
    x922 = 2*x610
    x923 = 2*x111
    x924 = 2*x112
    x925 = -x923 + x924
    x926 = 2*x804
    x927 = 2*x802
    x928 = -x926 + x927
    x929 = x822*x850 + x851*(-x852 - x853 - x854 - x855 + x856 + x857 + x858 + x859 + x862 + x865) + x869*x888 + x892*x905 + x906*(x126*x911 + x128*x910 + x183 + 2*x808 - 2*x809 + 2*x810 - 2*x811 + 2*x812 - 2*x813 + 2*x814 - 2*x815 - x912 + x913 + x916 + x919) + x920*(x187 + x21*x911 + x36*x910 + 2*x790 - 2*x792 + 2*x793 - 2*x794 + 2*x796 - 2*x798 + 2*x799 - 2*x800 - x921 + x922 + x925 + x928)
    x930 = -x283*x905 - x288*x888 - x291*x850
    x931 = x210*x930
    x932 = x823 - x825 - x827 + x829 + x831 - x833 - x835 + x837 + x839 - x841 + x845 - x848
    x933 = x79*x932
    x934 = x14*x143
    x935 = x166*x930
    x936 = x14*x19
    x937 = x76*x936
    x938 = x143*x765
    x939 = x175 + x422 + x603 - x893 - x894 - x895 + x896 + x897 + x898 - x899 - x900 - x901 + x902 + x903 + x904
    x940 = x169 + x413 + x595 - x871 - x873 - x875 + x877 + x879 + x881 - x882 - x883 - x884 + x885 + x886 + x887
    x941 = x165*x930
    x942 = x19*x765
    x943 = x16*x19
    x944 = x13*x943
    x945 = x164*x930
    x946 = -x145 - x167 + x174*x938 + x195*x205 + x196*x932 + x198*x939 + x200*x940 + x201*x941 + x204*x941 + x205*x941 + x218*x945 + x219*x937 + x222*x945 + x224*x945 + x227 + x229 + x308*x932 + x309*x939 + x310*x940 + x315*x942 + x317*x944 + x42*x934 - x80 + x933 + x935
    x947 = x15*x84
    x948 = x86*x947
    x949 = x94*x947
    x950 = x2*x768
    x951 = x89*x950
    x952 = x92*x950
    x953 = x27*x573
    x954 = x223*x953
    x955 = x388*x9
    x956 = x223*x955
    x957 = x781*x8
    x958 = x221*x957
    x959 = x24*x28
    x960 = x573*x959
    x961 = x221*x960
    x962 = x277 + x436 + x636
    x963 = x954 - x956 + x958 - x961 + x962
    x964 = x101*x950
    x965 = x106*x950
    x966 = -x776 + x779
    x967 = x434*x960
    x968 = x434*x957
    x969 = x574*x959
    x970 = x389*x8
    x971 = x4*x970
    x972 = x969 - x971
    x973 = x967 - x968 + x972
    x974 = x966 + x97 + x973
    x975 = x106*x947
    x976 = x101*x947
    x977 = x766*x92
    x978 = x766*x89
    x979 = x434*x955
    x980 = x434*x953
    x981 = x221*x775
    x982 = x221*x778
    x983 = x278 + x500 + x684
    x984 = x389*x9
    x985 = x27*x574
    x986 = x128*x2
    x987 = x126*x2
    x988 = x984 - x985 + x986 - x987
    x989 = x979 - x980 + x981 - x982 + x983 + x988
    x990 = x13*x971
    x991 = 2*x990
    x992 = x13*x969
    x993 = 2*x992
    x994 = x2*x924
    x995 = x2*x923
    x996 = x578*x959
    x997 = x6*x996
    x998 = 2*x997
    x999 = x419*x8
    x1000 = 2*x999
    x1001 = x1000 - x824 + x826 + x836 - x838 - x840 + x849 - x991 + x993 + x994 - x995 - x998
    x1002 = 2*x965
    x1003 = 2*x968
    x1004 = 2*x964
    x1005 = 2*x967
    x1006 = 2*x971
    x1007 = 2*x969
    x1008 = -x1006 + x1007
    x1009 = x863 - x864
    x1010 = x15*x32
    x1011 = x1010*x28
    x1012 = x16*x984
    x1013 = x27*x578
    x1014 = x1013*x4
    x1015 = x15*x20
    x1016 = x1015*x4
    x1017 = x393*x9
    x1018 = x1017*x28
    x1019 = x16*x985
    x1020 = x2*x969
    x1021 = x395*x8
    x1022 = x2*x971
    x1023 = x8*x996
    x1024 = -2*x1011 - 2*x1012 - 2*x1014 + 2*x1016 + 2*x1018 + 2*x1019 - 2*x1020 - 2*x1021 + 2*x1022 + 2*x1023 + x161 - x2*x860 + x2*x861 + x449 + x629
    x1025 = x1015*x6
    x1026 = x1017*x25
    x1027 = x13*x985
    x1028 = x1010*x25
    x1029 = x13*x984
    x1030 = x1013*x6
    x1031 = x127*x2
    x1032 = x8*x847
    x1033 = x129*x2
    x1034 = x410*x8
    x1035 = -2*x1025 - 2*x1026 - 2*x1027 + 2*x1028 + 2*x1029 + 2*x1030 - 2*x1031 - 2*x1032 + 2*x1033 + 2*x1034 + x2*x914 - x2*x915 + x366 + x557 + x746
    x1036 = 2*x499
    x1037 = 2*x253
    x1038 = 2*x254
    x1039 = 2*x683
    x1040 = 2*x44
    x1041 = -x1040
    x1042 = 2*x47
    x1043 = x1041 + x1042
    x1044 = 2*x985
    x1045 = 2*x984
    x1046 = 2*x987
    x1047 = 2*x986
    x1048 = -x1044 + x1045 - x1046 + x1047
    x1049 = x1001*x892 + x1024*x822 + x1035*x869 + x851*(x119 + x921 - x922 + 2*x948 - 2*x949 + 2*x951 - 2*x952 + 2*x954 - 2*x956 + 2*x958 - 2*x961) + x906*(-x1036 - x1037 + x1038 + x1039 + x1043 + x1048 + 2*x975 - 2*x976 + 2*x977 - 2*x978 + 2*x979 - 2*x980 + 2*x981 - 2*x982) + x920*(-x1002 - x1003 + x1004 + x1005 + x1008 + x1009 + x853 + x854 - x856 - x859)
    x1050 = x2*x206
    x1051 = -x1001*x283 - x1024*x291 - x1035*x288
    x1052 = x1051*x210
    x1053 = x2*x34
    x1054 = x2*x40
    x1055 = -x1011 - x1012 - x1014 + x1016 + x1018 + x1019 - x1020 - x1021 + x1022 + x1023 + x1053 - x1054 + x173 + x458 + x638
    x1056 = x1055*x79
    x1057 = x143*x15
    x1058 = x144*x2
    x1059 = x1051*x166
    x1060 = x15*x19
    x1061 = x1060*x69
    x1062 = x112*x2
    x1063 = x111*x2
    x1064 = x1062 - x1063 - x823 + x825 + x835 - x837 - x839 + x848 - x990 + x992 - x997 + x999
    x1065 = x2*x817
    x1066 = x2*x816
    x1067 = -x1025 - x1026 - x1027 + x1028 + x1029 + x1030 - x1031 - x1032 + x1033 + x1034 + x1065 - x1066 + x274 + x485 + x670
    x1068 = x1051*x165
    x1069 = x19*x2
    x1070 = x1051*x164
    x1071 = x2*x943
    x1072 = x1055*x196 + x1055*x308 + x1056 + x1057*x174 + x1058 + x1059 + x1061*x219 + x1064*x198 + x1064*x309 + x1067*x200 + x1067*x310 + x1068*x201 + x1068*x204 + x1068*x205 + x1069*x313 + x1070*x218 + x1070*x222 + x1070*x224 + x1071*x317 + x197*x205 - x296 - x297 - x300 + x42*x938
    x1073 = x17*x84
    x1074 = x1073*x89
    x1075 = x1073*x92
    x1076 = x768*x87
    x1077 = x94*x950
    x1078 = x10*x388
    x1079 = x1078*x221
    x1080 = x29*x573
    x1081 = x1080*x221
    x1082 = x223*x960
    x1083 = x223*x957
    x1084 = x361 + x457 + x616
    x1085 = x1079 - x1081 + x1082 - x1083 + x1084
    x1086 = x101*x1073
    x1087 = x106*x1073
    x1088 = x771*x94
    x1089 = x771*x86
    x1090 = x1080*x434
    x1091 = x1078*x434
    x1092 = x223*x782
    x1093 = x223*x784
    x1094 = x255 + x516 + x701
    x1095 = x29*x574
    x1096 = x10*x389
    x1097 = x16*x36
    x1098 = x39*x4
    x1099 = x1095 - x1096 + x1097 - x1098
    x1100 = x1090 - x1091 + x1092 - x1093 + x1094 + x1099
    x1101 = -x783 + x785
    x1102 = -x969 + x971
    x1103 = x1102 - x967 + x968
    x1104 = x1101 + x1103 + x98
    x1105 = -x1000 + x828 - x830 - x832 + x834 + x842 - x846 + x991 - x993 - x994 + x995 + x998
    x1106 = x1006 - x1007
    x1107 = x860 - x861
    x1108 = x17*x20
    x1109 = x1108*x8
    x1110 = x10*x393
    x1111 = x1110*x24
    x1112 = x1095*x2
    x1113 = x17*x32
    x1114 = x1113*x24
    x1115 = x1096*x2
    x1116 = x29*x578
    x1117 = x1116*x8
    x1118 = x4*x996
    x1119 = x1098*x2
    x1120 = x28*x394
    x1121 = x1120*x8
    x1122 = -x1006*x16 + x1007*x16 - 2*x1109 - 2*x1111 - 2*x1112 + 2*x1114 + 2*x1115 + 2*x1117 - 2*x1118 + 2*x1119 + 2*x1121 + x153 - x16*x863 + x445 + x625
    x1123 = x1113*x25
    x1124 = x1096*x13
    x1125 = x1116*x6
    x1126 = x1108*x6
    x1127 = x1110*x25
    x1128 = x1095*x13
    x1129 = x1098*x13
    x1130 = x1120*x6
    x1131 = x109*x16
    x1132 = x4*x844
    x1133 = -2*x1123 - 2*x1124 - 2*x1125 + 2*x1126 + 2*x1127 + 2*x1128 - 2*x1129 - 2*x1130 + 2*x1131 + 2*x1132 + x16*x926 - x16*x927 + x286 + x506 + x690
    x1134 = -x1042
    x1135 = x1040 + x1134
    x1136 = 2*x1096
    x1137 = 2*x1095
    x1138 = 2*x1098
    x1139 = 2*x1097
    x1140 = -x1136 + x1137 - x1138 + x1139
    x1141 = x1105*x869 + x1122*x822 + x1133*x892 + x851*(2*x1074 - 2*x1075 + 2*x1076 - 2*x1077 + 2*x1079 - 2*x1081 + 2*x1082 - 2*x1083 + x141 + x912 - x913) + x906*(x1002 + x1003 - x1004 - x1005 + x1106 + x1107 + x852 + x855 - x857 - x858) + x920*(x1036 + x1037 - x1038 - x1039 + 2*x1086 - 2*x1087 + 2*x1088 - 2*x1089 + 2*x1090 - 2*x1091 + 2*x1092 - 2*x1093 + x1135 + x1140)
    x1142 = -x1105*x288 - x1122*x291 - x1133*x283
    x1143 = x1142*x210
    x1144 = x16*x969
    x1145 = x16*x37
    x1146 = x16*x971
    x1147 = -x1109 - x1111 - x1112 + x1114 + x1115 + x1117 - x1118 + x1119 + x1121 + x1144 - x1145 - x1146 + x171 + x460 + x640
    x1148 = x1147*x79
    x1149 = x143*x17
    x1150 = x144*x16
    x1151 = x1142*x166
    x1152 = x17*x19
    x1153 = x1152*x59
    x1154 = x16*x804
    x1155 = x16*x802
    x1156 = -x1123 - x1124 - x1125 + x1126 + x1127 + x1128 - x1129 - x1130 + x1131 + x1132 + x1154 - x1155 + x304 + x518 + x703
    x1157 = -x1062 + x1063 + x827 - x829 - x831 + x833 + x841 - x845 + x990 - x992 + x997 - x999
    x1158 = x1142*x165
    x1159 = x1142*x164
    x1160 = x1071*x315 + x1147*x196 + x1147*x308 + x1148 + x1149*x172 + x1150 + x1151 + x1153*x219 + x1156*x198 + x1156*x309 + x1157*x200 + x1157*x310 + x1158*x201 + x1158*x204 + x1158*x205 + x1159*x218 + x1159*x222 + x1159*x224 + x16*x301 + x16*x303 + x313*x943 - x372 - x375 - x378
    x1161 = 3*m1
    x1162 = 3*p1
    x1163 = x81*(-x1161 + x1162)
    x1164 = x0*x1163
    x1165 = x1164*x87
    x1166 = x1164*x16
    x1167 = x1166*x89
    x1168 = x1166*x92
    x1169 = x1164*x94
    x1170 = x1169*x2
    x1171 = x101*x1166
    x1172 = x1169*x13
    x1173 = x1164*x13
    x1174 = x1173*x86
    x1175 = x106*x1166
    x1176 = x1173*x92
    x1177 = x1164*x2
    x1178 = x106*x1177
    x1179 = x101*x1177
    x1180 = x1164*x769
    x1181 = x168*x294 + x170*x305 + x176*x302 + x59*(-x1176 - x1178 + x1179 + x1180 + x280) + x69*(-x1171 - x1172 + x1174 + x1175 + x276) + x76*(-x1165 - x1167 + x1168 + x1170 + x277)
    x1182 = (mpmath.mpf(3)/mpmath.mpf(2))*x69
    x1183 = (mpmath.mpf(3)/mpmath.mpf(2))*x59
    x1184 = (mpmath.mpf(3)/mpmath.mpf(2))*x76
    x1185 = x209*(-x1182*x282 - x1183*x287 - x1184*x290)
    x1186 = x1185*x163
    x1187 = x302*x79
    x1188 = x1163*x231
    x1189 = x1188*x87
    x1190 = x1188*x16
    x1191 = x1190*x89
    x1192 = x1190*x92
    x1193 = x1188*x94
    x1194 = x1193*x2
    x1195 = 2*x245
    x1196 = 2*x246
    x1197 = -x1195 + x1196
    x1198 = x101*x1190
    x1199 = x1193*x13
    x1200 = x1188*x13
    x1201 = x1200*x86
    x1202 = x106*x1190
    x1203 = x1200*x92
    x1204 = x1188*x2
    x1205 = x106*x1204
    x1206 = x101*x1204
    x1207 = x1188*x769
    x1208 = x131*x231
    x1209 = 2*x1208
    x1210 = x133*x231
    x1211 = 2*x1210
    x1212 = -x1209 + x1211
    x1213 = x226*x231
    x1214 = x307*x69
    x1215 = x1209 - x1211
    x1216 = x1195 - x1196
    x1217 = x264*x294 + x269*x302 + x275*x305 + x59*(-x1203 - x1205 + x1206 + x1207 + x1215 + x182) + x69*(-x1198 - x1199 + x1201 + x1202 + x186) + x76*(-x1189 - x1191 + x1192 + x1194 + x1216 + x179)
    x1218 = x195*x231
    x1219 = 2*x294
    x1220 = x197*x231
    x1221 = 2*x302
    x1222 = x199*x231
    x1223 = 2*x305
    x1224 = x13*x307
    x1225 = x2*x307
    x1226 = x16*x307
    x1227 = x1185*x292
    x1228 = x189*x312
    x1229 = 2*x311
    x1230 = x314*x69
    x1231 = x316*x59
    x1232 = x1163*x319
    x1233 = x1232*x87
    x1234 = x1232*x16
    x1235 = x1234*x89
    x1236 = x1234*x92
    x1237 = x1232*x94
    x1238 = x1237*x2
    x1239 = x279 + x362
    x1240 = x101*x1234
    x1241 = x1237*x13
    x1242 = x1232*x13
    x1243 = x1242*x86
    x1244 = x106*x1234
    x1245 = x1208 - x1210
    x1246 = x1242*x92
    x1247 = x1232*x2
    x1248 = x106*x1247
    x1249 = x101*x1247
    x1250 = x1232*x769
    x1251 = x133*x319
    x1252 = x131*x319
    x1253 = x1251 - x1252
    x1254 = -x1251 + x1252
    x1255 = -x1208 + x1210
    x1256 = x258 + x335
    x1257 = x294*x349 + x302*x359 + x305*x354 + x59*(-x1246 - x1248 + x1249 + x1250 + x1254) + x69*(-x1240 - x1241 + x1243 + x1244 + x1255) + x76*(-x1233 - x1235 + x1236 + x1238 + x1256)
    x1258 = x1185*x370
    x1259 = x379*x79
    x1260 = x305*x79
    x1261 = x228*x231
    x1262 = x226*x319
    x1263 = x307*x59
    x1264 = x191*x370
    x1265 = x195*x294
    x1266 = x197*x302
    x1267 = x199*x319
    x1268 = x13*x294
    x1269 = x2*x302
    x1270 = x16*x305
    x1271 = x189*x311
    x1272 = x311*x69
    x1273 = x311*x59
    x1274 = x1218*x373 + x1220*x379 + x1222*x380 + x1224*x373 + x1225*x379 + x1226*x380 + x1228*x382 + x1230*x382 + x1231*x382 + x1259 + x1260 + x1261 + x1262 + x1263 + x1264 + x1265*x319 + x1266*x319 + x1267*x305 + x1268*x381 + x1269*x381 + x1270*x381 + x1271*x383 + x1272*x384 + x1273*x385
    x1275 = x231*x39
    x1276 = -x1275
    x1277 = x13*x312
    x1278 = x1277*x427
    x1279 = x316*x432
    x1280 = x316*x425
    x1281 = x314*x427
    x1282 = x314*x432
    x1283 = x1277*x425
    x1284 = x20*x231
    x1285 = x1284*x2
    x1286 = x1285 + x44
    x1287 = x59*(x1282 - x1283 + x1286 + x403) + x69*(x1276 + x1278 - x1279) + x76*(x1280 - x1281 + x456)
    x1288 = x1287 + x294*x402 + x302*x423 + x305*x414
    x1289 = x1185*x451
    x1290 = x459*x79
    x1291 = x191*x451
    x1292 = -x403
    x1293 = -x1285 + x498
    x1294 = x100*(-x1280 + x1281 + x397) + x120*(x1275 - x1278 + x1279) + x1218*x453 + x1220*x459 + x1222*x461 + x1224*x453 + x1225*x459 + x1226*x461 + x1228*x463 + x1230*x463 + x1231*x463 + x1268*x462 + x1269*x462 + x1270*x462 + x1290 + x1291 + x142*(-x1282 + x1283 + x1292 + x1293)
    x1295 = x1277*x490
    x1296 = x316*x493
    x1297 = x316*x488
    x1298 = x314*x490
    x1299 = x1284*x13
    x1300 = -x1299
    x1301 = x314*x493
    x1302 = x1277*x488
    x1303 = x59*(x1300 + x1301 - x1302 + x476) + x69*(x1295 - x1296) + x76*(x1275 + x1297 - x1298 + x515)
    x1304 = x1303 + x294*x473 + x302*x479 + x305*x486
    x1305 = x1185*x510
    x1306 = x517*x79
    x1307 = x191*x510
    x1308 = -x476
    x1309 = x100*(x1276 - x1297 + x1298 + x470) + x120*(-x1295 + x1296) + x1218*x512 + x1220*x517 + x1222*x519 + x1224*x512 + x1225*x517 + x1226*x519 + x1228*x521 + x1230*x521 + x1231*x521 + x1268*x520 + x1269*x520 + x1270*x520 + x1306 + x1307 + x142*(x1299 - x1301 + x1302 + x1308)
    x1310 = x1277*x546
    x1311 = x316*x549
    x1312 = x314*x549
    x1313 = x1277*x544
    x1314 = x316*x544
    x1315 = x314*x546
    x1316 = x59*(x1312 - x1313 + x532) + x69*(x1299 + x1310 - x1311) + x76*(x1293 + x1314 - x1315 + x566)
    x1317 = x1316 + x294*x531 + x302*x542 + x305*x537
    x1318 = x1185*x561
    x1319 = x567*x79
    x1320 = x191*x561
    x1321 = -x532
    x1322 = x100*(x1286 - x1314 + x1315 + x528) + x120*(x1300 - x1310 + x1311) + x1218*x563 + x1220*x567 + x1222*x568 + x1224*x563 + x1225*x567 + x1226*x568 + x1228*x570 + x1230*x570 + x1231*x570 + x1268*x569 + x1269*x569 + x1270*x569 + x1319 + x1320 + x142*(-x1312 + x1313 + x1321)
    x1323 = x231*x33
    x1324 = x316*x612
    x1325 = x1277*x606
    x1326 = x314*x606
    x1327 = x316*x608
    x1328 = -x590
    x1329 = x1277*x608
    x1330 = x314*x612
    x1331 = x231*x32
    x1332 = x1331*x2
    x1333 = -x1332 + x700
    x1334 = x59*(x1328 + x1329 - x1330 + x1333) + x69*(x1323 + x1324 - x1325) + x76*(x1326 - x1327 + x576)
    x1335 = x1334 + x294*x586 + x302*x604 + x305*x596
    x1336 = x1185*x631
    x1337 = x639*x79
    x1338 = x191*x631
    x1339 = -x1323
    x1340 = x1332 + x47
    x1341 = x100*(-x1326 + x1327 + x611) + x120*(-x1324 + x1325 + x1339) + x1218*x633 + x1220*x639 + x1222*x641 + x1224*x633 + x1225*x639 + x1226*x641 + x1228*x643 + x1230*x643 + x1231*x643 + x1268*x642 + x1269*x642 + x1270*x642 + x1337 + x1338 + x142*(-x1329 + x1330 + x1340 + x590)
    x1342 = x316*x678
    x1343 = x1277*x673
    x1344 = x13*x1331
    x1345 = -x657
    x1346 = x1277*x675
    x1347 = x314*x678
    x1348 = x314*x673
    x1349 = x316*x675
    x1350 = x59*(x1344 + x1345 + x1346 - x1347) + x69*(x1342 - x1343) + x76*(x1339 + x1348 - x1349 + x647)
    x1351 = x1350 + x294*x656 + x302*x663 + x305*x671
    x1352 = x1185*x694
    x1353 = x702*x79
    x1354 = x191*x694
    x1355 = -x1344
    x1356 = x100*(x1323 - x1348 + x1349 + x677) + x120*(-x1342 + x1343) + x1218*x696 + x1220*x702 + x1222*x704 + x1224*x696 + x1225*x702 + x1226*x704 + x1228*x706 + x1230*x706 + x1231*x706 + x1268*x705 + x1269*x705 + x1270*x705 + x1353 + x1354 + x142*(-x1346 + x1347 + x1355 + x657)
    x1357 = x316*x738
    x1358 = x1277*x733
    x1359 = -x723
    x1360 = x1277*x735
    x1361 = x314*x738
    x1362 = x314*x733
    x1363 = x316*x735
    x1364 = x59*(x1359 + x1360 - x1361) + x69*(x1355 + x1357 - x1358) + x76*(x1340 + x1362 - x1363 + x710)
    x1365 = x1364 + x294*x719 + x302*x731 + x305*x726
    x1366 = x1185*x750
    x1367 = x756*x79
    x1368 = x191*x750
    x1369 = x100*(x1333 - x1362 + x1363 + x740) + x120*(x1344 - x1357 + x1358) + x1218*x752 + x1220*x756 + x1222*x757 + x1224*x752 + x1225*x756 + x1226*x757 + x1228*x759 + x1230*x759 + x1231*x759 + x1268*x758 + x1269*x758 + x1270*x758 + x1367 + x1368 + x142*(-x1360 + x1361 + x723)
    x1370 = x1163*x765
    x1371 = x1370*x86
    x1372 = x1163*x16
    x1373 = x1372*x769
    x1374 = x13*x1372
    x1375 = x1374*x92
    x1376 = x1370*x94
    x1377 = x316*x775
    x1378 = x316*x778
    x1379 = x1377 - x1378
    x1380 = x314*x782
    x1381 = x314*x784
    x1382 = -x802 + x804
    x1383 = x1380 - x1381 + x1382
    x1384 = x110 + x1379 + x1383
    x1385 = x1163*x14
    x1386 = x1385*x94
    x1387 = x1385*x86
    x1388 = x101*x1374
    x1389 = x106*x1374
    x1390 = x316*x795
    x1391 = x316*x797
    x1392 = x1277*x784
    x1393 = x1277*x782
    x1394 = x1276 + x1323 + x276
    x1395 = x1390 - x1391 + x1392 - x1393 + x1394
    x1396 = x1385*x92
    x1397 = x1385*x89
    x1398 = x106*x1370
    x1399 = x101*x1370
    x1400 = x314*x797
    x1401 = x314*x795
    x1402 = x1277*x778
    x1403 = x1277*x775
    x1404 = x1286 + x1333 + x279
    x1405 = x13*x133
    x1406 = x13*x131
    x1407 = x1405 - x1406 - x872 + x880
    x1408 = x1400 - x1401 + x1402 - x1403 + x1404 + x1407
    x1409 = -x889 + x890
    x1410 = x1409 + (mpmath.mpf(1)/mpmath.mpf(2))*x260 + (mpmath.mpf(1)/mpmath.mpf(2))*x261 - mpmath.mpf(1)/mpmath.mpf(2)*x262 - mpmath.mpf(1)/mpmath.mpf(2)*x263
    x1411 = 2*x1275
    x1412 = 2*x1323
    x1413 = 2*x1375
    x1414 = 2*x1376
    x1415 = 2*x1378
    x1416 = 2*x1381
    x1417 = 2*x1371
    x1418 = 2*x1373
    x1419 = 2*x1380
    x1420 = 2*x1377
    x1421 = x926 - x927
    x1422 = 2*x109
    x1423 = 2*x108
    x1424 = -x1422 + x1423
    x1425 = (mpmath.mpf(1)/mpmath.mpf(2))*x265 + (mpmath.mpf(1)/mpmath.mpf(2))*x266 - mpmath.mpf(1)/mpmath.mpf(2)*x267 - mpmath.mpf(1)/mpmath.mpf(2)*x268
    x1426 = (mpmath.mpf(1)/mpmath.mpf(2))*x55
    x1427 = (mpmath.mpf(1)/mpmath.mpf(2))*x48
    x1428 = x1426 - x1427
    x1429 = x1428 + (mpmath.mpf(1)/mpmath.mpf(2))*x270 + (mpmath.mpf(1)/mpmath.mpf(2))*x271 - mpmath.mpf(1)/mpmath.mpf(2)*x272 - mpmath.mpf(1)/mpmath.mpf(2)*x273
    x1430 = 2*x256
    x1431 = 2*x1332
    x1432 = 2*x1285
    x1433 = 2*x257
    x1434 = 2*x872
    x1435 = 2*x880
    x1436 = 2*x1406
    x1437 = 2*x1405
    x1438 = -x1434 + x1435 - x1436 + x1437
    x1439 = x1410*x850 + x1425*x905 + x1429*x888 + x851*(-x1413 - x1414 - x1415 - x1416 + x1417 + x1418 + x1419 + x1420 + x1421 + x1424) + x906*(x1135 + 2*x1396 - 2*x1397 + 2*x1398 - 2*x1399 + 2*x1400 - 2*x1401 + 2*x1402 - 2*x1403 - x1430 - x1431 + x1432 + x1433 + x1438) + x920*(x1197 + 2*x1386 - 2*x1387 + 2*x1388 - 2*x1389 + 2*x1390 - 2*x1391 + 2*x1392 - 2*x1393 - x1411 + x1412)
    x1440 = x1185*x930
    x1441 = x79*x939
    x1442 = x13*x226
    x1443 = x191*x930
    x1444 = x1218*x932 + x1220*x939 + x1222*x940 + x1224*x932 + x1225*x939 + x1226*x940 + x1228*x945 + x1230*x945 + x1231*x945 + x1268*x941 + x1269*x941 + x1270*x195 + x1270*x941 + x1272*x942 + x1273*x944 + x1441 + x1442 + x1443 + x294*x934 - x295 - x298 - x299 + x302*x938 + x311*x937
    x1445 = 2*m1
    x1446 = 2*p1
    x1447 = -x1446
    x1448 = x1445 + x1447
    x1449 = -x1445 + x1446
    x1450 = x1163*x15
    x1451 = x1450*x86
    x1452 = x1450*x94
    x1453 = x1372*x2
    x1454 = x1453*x89
    x1455 = x1453*x92
    x1456 = x316*x953
    x1457 = x316*x955
    x1458 = x314*x957
    x1459 = x314*x960
    x1460 = x1275 + x1339 + x247
    x1461 = x1102 + x1456 - x1457 + x1458 - x1459 + x1460 + x178
    x1462 = x101*x1453
    x1463 = x106*x1453
    x1464 = -x1377 + x1378
    x1465 = x1277*x960
    x1466 = x1277*x957
    x1467 = x1465 - x1466
    x1468 = x1464 + x1467 + x186
    x1469 = x106*x1450
    x1470 = x101*x1450
    x1471 = x1370*x92
    x1472 = x1370*x89
    x1473 = x1277*x955
    x1474 = x1277*x953
    x1475 = x314*x775
    x1476 = x314*x778
    x1477 = -x816 + x817
    x1478 = x1245 + x1300 + x1344
    x1479 = x1473 - x1474 + x1475 - x1476 + x1477 + x1478 + x180
    x1480 = 2*x1463
    x1481 = 2*x1466
    x1482 = 2*x1462
    x1483 = 2*x1465
    x1484 = x1422 - x1423
    x1485 = 4*m1
    x1486 = 4*p1
    x1487 = -x1485 + x1486
    x1488 = -x1486
    x1489 = x1485 + x1488
    x1490 = 2*x1299
    x1491 = 2*x1344
    x1492 = x914 - x915
    x1493 = 2*x127
    x1494 = 2*x129
    x1495 = -x1493 + x1494
    x1496 = x1001*x1425 + x1024*x1410 + x1035*x1429 + x851*(x1106 + x1216 + x1411 - x1412 + 2*x1451 - 2*x1452 + 2*x1454 - 2*x1455 + 2*x1456 - 2*x1457 + 2*x1458 - 2*x1459 + x1487*x36 + x1489*x21 + x862) + x906*(x1215 + x131*x1487 + x133*x1489 + 2*x1469 - 2*x1470 + 2*x1471 - 2*x1472 + 2*x1473 - 2*x1474 + 2*x1475 - 2*x1476 - x1490 + x1491 + x1492 + x1495) + x920*(x1414 + x1415 - x1417 - x1420 - x1480 - x1481 + x1482 + x1483 + x1484 + x925)
    x1497 = x1051*x1185
    x1498 = x1064*x79
    x1499 = x1051*x191
    x1500 = x1055*x1218 + x1055*x1224 + x1057*x302 + x1061*x311 + x1064*x1220 + x1064*x1225 + x1067*x1222 + x1067*x1226 + x1068*x1268 + x1068*x1269 + x1068*x1270 + x1069*x1271 + x1070*x1228 + x1070*x1230 + x1070*x1231 + x1071*x1273 - x1187 - x1213 - x1214 + x1270*x197 + x1498 + x1499 + x225 + x229 + x294*x938
    x1501 = x1163*x17
    x1502 = x1501*x89
    x1503 = x1501*x92
    x1504 = x1372*x87
    x1505 = x1453*x94
    x1506 = x1078*x314
    x1507 = x1080*x314
    x1508 = x316*x960
    x1509 = x316*x957
    x1510 = x1293 + x1340 + x258
    x1511 = -x1095 + x1096 - x1097 + x1098
    x1512 = x1506 - x1507 + x1508 - x1509 + x1510 + x1511
    x1513 = x101*x1501
    x1514 = x106*x1501
    x1515 = x1374*x94
    x1516 = x1374*x86
    x1517 = x1080*x1277
    x1518 = x1078*x1277
    x1519 = x316*x782
    x1520 = x316*x784
    x1521 = x1255 + x1299 + x1355
    x1522 = x1517 - x1518 + x1519 - x1520 + x1521
    x1523 = -x1465 + x1466
    x1524 = -x1380 + x1381 + x805
    x1525 = x113 + x1523 + x1524
    x1526 = x923 - x924
    x1527 = x1136 - x1137 + x1138 - x1139
    x1528 = x1105*x1429 + x1122*x1410 + x1133*x1425 + x851*(x1043 + x1430 + x1431 - x1432 - x1433 + 2*x1502 - 2*x1503 + 2*x1504 - 2*x1505 + 2*x1506 - 2*x1507 + 2*x1508 - 2*x1509 + x1527) + x906*(x1413 + x1416 - x1418 - x1419 + x1480 + x1481 - x1482 - x1483 + x1526 + x928) + x920*(x1212 + x1490 - x1491 + 2*x1513 - 2*x1514 + 2*x1515 - 2*x1516 + 2*x1517 - 2*x1518 + 2*x1519 - 2*x1520)
    x1529 = x1142*x1185
    x1530 = x1156*x79
    x1531 = x16*x226
    x1532 = x1142*x191
    x1533 = x1071*x1272 + x1147*x1218 + x1147*x1224 + x1149*x305 + x1153*x311 + x1156*x1220 + x1156*x1225 + x1157*x1222 + x1157*x1226 + x1158*x1268 + x1158*x1269 + x1158*x1270 + x1159*x1228 + x1159*x1230 + x1159*x1231 - x1260 - x1261 - x1263 + x1265*x16 + x1266*x16 + x1271*x943 + x1530 + x1531 + x1532
    x1534 = 3*m2
    x1535 = 3*p2
    x1536 = x81*(-x1534 + x1535)
    x1537 = x0*x1536
    x1538 = x1537*x87
    x1539 = x1537*x16
    x1540 = x1539*x89
    x1541 = x1539*x92
    x1542 = x1537*x94
    x1543 = x1542*x2
    x1544 = x101*x1539
    x1545 = x13*x1542
    x1546 = x13*x1537
    x1547 = x1546*x86
    x1548 = x106*x1539
    x1549 = x1546*x92
    x1550 = x1537*x2
    x1551 = x106*x1550
    x1552 = x101*x1550
    x1553 = x1537*x769
    x1554 = x168*x373 + x170*x380 + x176*x379 + x59*(-x1549 - x1551 + x1552 + x1553 + x360) + x69*(-x1544 - x1545 + x1547 + x1548 + x363) + x76*(-x1538 - x1540 + x1541 + x1543 + x361)
    x1555 = x209*(-x1182*x367 - x1183*x365 - x1184*x369)
    x1556 = x1555*x163
    x1557 = x1536*x231
    x1558 = x1557*x87
    x1559 = x1557*x16
    x1560 = x1559*x89
    x1561 = x1559*x92
    x1562 = x1557*x94
    x1563 = x1562*x2
    x1564 = x101*x1559
    x1565 = x13*x1562
    x1566 = x13*x1557
    x1567 = x1566*x86
    x1568 = x106*x1559
    x1569 = x1566*x92
    x1570 = x1557*x2
    x1571 = x106*x1570
    x1572 = x101*x1570
    x1573 = x1557*x769
    x1574 = x264*x373 + x269*x379 + x275*x380 + x59*(x1254 - x1569 - x1571 + x1572 + x1573) + x69*(x1255 - x1564 - x1565 + x1567 + x1568) + x76*(x1256 - x1558 - x1560 + x1561 + x1563)
    x1575 = x1555*x292
    x1576 = x380*x79
    x1577 = x1536*x319
    x1578 = x1577*x87
    x1579 = x1577*x16
    x1580 = x1579*x89
    x1581 = x1579*x92
    x1582 = x1577*x94
    x1583 = x1582*x2
    x1584 = 2*x342
    x1585 = 2*x343
    x1586 = -x1584 + x1585
    x1587 = x101*x1579
    x1588 = x13*x1582
    x1589 = x13*x1577
    x1590 = x1589*x86
    x1591 = x106*x1579
    x1592 = 2*x1251
    x1593 = 2*x1252
    x1594 = -x1592 + x1593
    x1595 = x1589*x92
    x1596 = x1577*x2
    x1597 = x106*x1596
    x1598 = x101*x1596
    x1599 = x1577*x769
    x1600 = x228*x319
    x1601 = x193*x370
    x1602 = x1592 - x1593
    x1603 = x1584 - x1585
    x1604 = x349*x373 + x354*x380 + x359*x379 + x59*(-x1595 - x1597 + x1598 + x1599 + x182) + x69*(-x1587 - x1588 + x1590 + x1591 + x1602 + x186) + x76*(-x1578 - x1580 + x1581 + x1583 + x1603 + x179)
    x1605 = x195*x319
    x1606 = 2*x373
    x1607 = x197*x319
    x1608 = 2*x379
    x1609 = 2*x380
    x1610 = x13*x381
    x1611 = x2*x381
    x1612 = x16*x381
    x1613 = x1555*x370
    x1614 = x189*x383
    x1615 = 2*x382
    x1616 = x384*x69
    x1617 = x385*x59
    x1618 = x20*x319
    x1619 = x1618*x2
    x1620 = x384*x432
    x1621 = x13*x383
    x1622 = x1621*x425
    x1623 = x385*x425
    x1624 = x384*x427
    x1625 = x1621*x427
    x1626 = x385*x432
    x1627 = x319*x39
    x1628 = -x1627 + x498
    x1629 = x59*(x1619 + x1620 - x1622) + x69*(x1292 + x1625 - x1626 + x1628) + x76*(x1623 - x1624 + x391)
    x1630 = x1629 + x373*x402 + x379*x423 + x380*x414
    x1631 = x1555*x451
    x1632 = x461*x79
    x1633 = x193*x451
    x1634 = x1627 + x44
    x1635 = -x1619
    x1636 = x13*x373
    x1637 = x2*x379
    x1638 = x16*x380
    x1639 = x100*(-x1623 + x1624 + x431) + x120*(-x1625 + x1626 + x1634 + x403) + x1267*x461 + x142*(-x1620 + x1622 + x1635) + x1605*x453 + x1607*x459 + x1610*x453 + x1611*x459 + x1612*x461 + x1614*x463 + x1616*x463 + x1617*x463 + x1632 + x1633 + x1636*x462 + x1637*x462 + x1638*x462
    x1640 = x13*x1618
    x1641 = -x1640
    x1642 = x384*x493
    x1643 = x1621*x488
    x1644 = x1621*x490
    x1645 = x385*x493
    x1646 = x385*x488
    x1647 = x384*x490
    x1648 = x59*(x1641 + x1642 - x1643) + x69*(x1308 + x1644 - x1645) + x76*(x1634 + x1646 - x1647 + x467)
    x1649 = x1648 + x373*x473 + x379*x479 + x380*x486
    x1650 = x1555*x510
    x1651 = x519*x79
    x1652 = x193*x510
    x1653 = x100*(x1628 - x1646 + x1647 + x495) + x120*(-x1644 + x1645 + x476) + x1267*x519 + x142*(x1640 - x1642 + x1643) + x1605*x512 + x1607*x517 + x1610*x512 + x1611*x517 + x1612*x519 + x1614*x521 + x1616*x521 + x1617*x521 + x1636*x520 + x1637*x520 + x1638*x520 + x1651 + x1652
    x1654 = x384*x549
    x1655 = x1621*x544
    x1656 = x1621*x546
    x1657 = x385*x549
    x1658 = x385*x544
    x1659 = x384*x546
    x1660 = x59*(x1654 - x1655) + x69*(x1321 + x1640 + x1656 - x1657) + x76*(x1635 + x1658 - x1659 + x525)
    x1661 = x1660 + x373*x531 + x379*x542 + x380*x537
    x1662 = x1555*x561
    x1663 = x568*x79
    x1664 = x193*x561
    x1665 = x100*(x1619 - x1658 + x1659 + x548) + x120*(x1641 - x1656 + x1657 + x532) + x1267*x568 + x142*(-x1654 + x1655) + x1605*x563 + x1607*x567 + x1610*x563 + x1611*x567 + x1612*x568 + x1614*x570 + x1616*x570 + x1617*x570 + x1636*x569 + x1637*x569 + x1638*x569 + x1663 + x1664
    x1666 = x319*x32
    x1667 = x1666*x2
    x1668 = -x1667
    x1669 = x1621*x608
    x1670 = x384*x612
    x1671 = x384*x606
    x1672 = x385*x608
    x1673 = x385*x612
    x1674 = x1621*x606
    x1675 = x319*x33
    x1676 = x1675 + x47
    x1677 = x59*(x1668 + x1669 - x1670) + x69*(x1673 - x1674 + x1676 + x590) + x76*(x1671 - x1672 + x637)
    x1678 = x1677 + x373*x586 + x379*x604 + x380*x596
    x1679 = x1555*x631
    x1680 = x641*x79
    x1681 = x193*x631
    x1682 = -x1675 + x700
    x1683 = x100*(-x1671 + x1672 + x582) + x120*(x1328 - x1673 + x1674 + x1682) + x1267*x641 + x142*(x1667 - x1669 + x1670) + x1605*x633 + x1607*x639 + x1610*x633 + x1611*x639 + x1612*x641 + x1614*x643 + x1616*x643 + x1617*x643 + x1636*x642 + x1637*x642 + x1638*x642 + x1680 + x1681
    x1684 = x13*x1666
    x1685 = x1621*x675
    x1686 = x384*x678
    x1687 = x385*x678
    x1688 = x1621*x673
    x1689 = x384*x673
    x1690 = x385*x675
    x1691 = x59*(x1684 + x1685 - x1686) + x69*(x1687 - x1688 + x657) + x76*(x1682 + x1689 - x1690 + x699)
    x1692 = x1691 + x373*x656 + x379*x663 + x380*x671
    x1693 = x1555*x694
    x1694 = x704*x79
    x1695 = x193*x694
    x1696 = -x1684
    x1697 = x100*(x1676 - x1689 + x1690 + x652) + x120*(x1345 - x1687 + x1688) + x1267*x704 + x142*(-x1685 + x1686 + x1696) + x1605*x696 + x1607*x702 + x1610*x696 + x1611*x702 + x1612*x704 + x1614*x706 + x1616*x706 + x1617*x706 + x1636*x705 + x1637*x705 + x1638*x705 + x1694 + x1695
    x1698 = x1621*x735
    x1699 = x384*x738
    x1700 = x384*x733
    x1701 = x385*x735
    x1702 = x385*x738
    x1703 = x1621*x733
    x1704 = x59*(x1698 - x1699) + x69*(x1696 + x1702 - x1703 + x723) + x76*(x1667 + x1700 - x1701 + x755)
    x1705 = x1704 + x373*x719 + x379*x731 + x380*x726
    x1706 = x1555*x750
    x1707 = x757*x79
    x1708 = x193*x750
    x1709 = x100*(x1668 - x1700 + x1701 + x715) + x120*(x1359 + x1684 - x1702 + x1703) + x1267*x757 + x142*(-x1698 + x1699) + x1605*x752 + x1607*x756 + x1610*x752 + x1611*x756 + x1612*x757 + x1614*x759 + x1616*x759 + x1617*x759 + x1636*x758 + x1637*x758 + x1638*x758 + x1707 + x1708
    x1710 = x1536*x765
    x1711 = x1710*x86
    x1712 = x1536*x16
    x1713 = x1712*x769
    x1714 = x13*x1712
    x1715 = x1714*x92
    x1716 = x1710*x94
    x1717 = x384*x782
    x1718 = x384*x784
    x1719 = x1717 - x1718
    x1720 = x385*x775
    x1721 = x385*x778
    x1722 = x1477 + x1720 - x1721
    x1723 = x130 + x1719 + x1722
    x1724 = x14*x1536
    x1725 = x1724*x94
    x1726 = x1724*x86
    x1727 = x101*x1714
    x1728 = x106*x1714
    x1729 = x385*x795
    x1730 = x385*x797
    x1731 = x1621*x784
    x1732 = x1621*x782
    x1733 = x1628 + x1676 + x362
    x1734 = -x1405 + x1406 + x872 - x880
    x1735 = x1729 - x1730 + x1731 - x1732 + x1733 + x1734
    x1736 = x1724*x92
    x1737 = x1724*x89
    x1738 = x106*x1710
    x1739 = x101*x1710
    x1740 = x384*x797
    x1741 = x384*x795
    x1742 = x1621*x778
    x1743 = x1621*x775
    x1744 = x1619 + x1668 + x360
    x1745 = x1740 - x1741 + x1742 - x1743 + x1744
    x1746 = -x866 + x867
    x1747 = x1746 + (mpmath.mpf(1)/mpmath.mpf(2))*x345 + (mpmath.mpf(1)/mpmath.mpf(2))*x346 - mpmath.mpf(1)/mpmath.mpf(2)*x347 - mpmath.mpf(1)/mpmath.mpf(2)*x348
    x1748 = 2*x1667
    x1749 = 2*x1619
    x1750 = 2*x1715
    x1751 = 2*x1716
    x1752 = 2*x1721
    x1753 = 2*x1718
    x1754 = 2*x1711
    x1755 = 2*x1713
    x1756 = 2*x1717
    x1757 = 2*x1720
    x1758 = x1493 - x1494
    x1759 = (mpmath.mpf(1)/mpmath.mpf(2))*x350 + (mpmath.mpf(1)/mpmath.mpf(2))*x351 - mpmath.mpf(1)/mpmath.mpf(2)*x352 - mpmath.mpf(1)/mpmath.mpf(2)*x353
    x1760 = -x1426 + x1427
    x1761 = x1760 + (mpmath.mpf(1)/mpmath.mpf(2))*x355 + (mpmath.mpf(1)/mpmath.mpf(2))*x356 - mpmath.mpf(1)/mpmath.mpf(2)*x357 - mpmath.mpf(1)/mpmath.mpf(2)*x358
    x1762 = 2*x1627
    x1763 = 2*x333
    x1764 = 2*x334
    x1765 = 2*x1675
    x1766 = x1434 - x1435 + x1436 - x1437
    x1767 = x1747*x850 + x1759*x888 + x1761*x905 + x851*(x1492 - x1750 - x1751 - x1752 - x1753 + x1754 + x1755 + x1756 + x1757 + x1758) + x906*(x1586 + 2*x1736 - 2*x1737 + 2*x1738 - 2*x1739 + 2*x1740 - 2*x1741 + 2*x1742 - 2*x1743 - x1748 + x1749) + x920*(x1043 + 2*x1725 - 2*x1726 + 2*x1727 - 2*x1728 + 2*x1729 - 2*x1730 + 2*x1731 - 2*x1732 - x1762 - x1763 + x1764 + x1765 + x1766)
    x1768 = x1555*x930
    x1769 = x79*x940
    x1770 = x13*x228
    x1771 = x193*x930
    x1772 = x382*x69
    x1773 = x382*x59
    x1774 = x1267*x940 + x1605*x932 + x1607*x939 + x1610*x932 + x1611*x939 + x1612*x940 + x1614*x945 + x1616*x945 + x1617*x945 + x1636*x941 + x1637*x941 + x1638*x195 + x1638*x941 + x1769 + x1770 + x1771 + x1772*x942 + x1773*x944 + x373*x934 - x374 - x376 - x377 + x379*x938 + x382*x937
    x1775 = x15*x1536
    x1776 = x1775*x86
    x1777 = x1775*x94
    x1778 = x1712*x2
    x1779 = x1778*x89
    x1780 = x1778*x92
    x1781 = x385*x953
    x1782 = x385*x955
    x1783 = x384*x957
    x1784 = x384*x960
    x1785 = x1634 + x1682 + x335
    x1786 = -x984 + x985 - x986 + x987
    x1787 = x1781 - x1782 + x1783 - x1784 + x1785 + x1786
    x1788 = x101*x1778
    x1789 = x106*x1778
    x1790 = x1621*x960
    x1791 = x1621*x957
    x1792 = x1790 - x1791
    x1793 = -x1720 + x1721 + x818
    x1794 = x135 + x1792 + x1793
    x1795 = x106*x1775
    x1796 = x101*x1775
    x1797 = x1710*x92
    x1798 = x1710*x89
    x1799 = x1621*x955
    x1800 = x1621*x953
    x1801 = x384*x775
    x1802 = x384*x778
    x1803 = x1254 + x1641 + x1684
    x1804 = x1799 - x1800 + x1801 - x1802 + x1803
    x1805 = 2*x1640
    x1806 = 2*x1684
    x1807 = 2*x1789
    x1808 = 2*x1791
    x1809 = 2*x1788
    x1810 = 2*x1790
    x1811 = x917 - x918
    x1812 = x1044 - x1045 + x1046 - x1047
    x1813 = x1001*x1761 + x1024*x1747 + x1035*x1759 + x851*(x1135 + x1762 + x1763 - x1764 - x1765 + 2*x1776 - 2*x1777 + 2*x1779 - 2*x1780 + 2*x1781 - 2*x1782 + 2*x1783 - 2*x1784 + x1812) + x906*(x1594 + 2*x1795 - 2*x1796 + 2*x1797 - 2*x1798 + 2*x1799 - 2*x1800 + 2*x1801 - 2*x1802 - x1805 + x1806) + x920*(x1751 + x1752 - x1754 - x1757 - x1807 - x1808 + x1809 + x1810 + x1811 + x916)
    x1814 = x1051*x1555
    x1815 = x1067*x79
    x1816 = x2*x228
    x1817 = x1051*x193
    x1818 = x189*x382
    x1819 = x1055*x1605 + x1055*x1610 + x1057*x379 + x1061*x382 + x1064*x1607 + x1064*x1611 + x1067*x1267 + x1067*x1612 + x1068*x1636 + x1068*x1637 + x1068*x1638 + x1069*x1818 + x1070*x1614 + x1070*x1616 + x1070*x1617 + x1071*x1773 - x1259 - x1262 - x1264 + x1638*x197 + x1815 + x1816 + x1817 + x373*x938
    x1820 = 2*m2
    x1821 = 2*p2
    x1822 = -x1821
    x1823 = x1820 + x1822
    x1824 = -x1820 + x1821
    x1825 = x1536*x17
    x1826 = x1825*x89
    x1827 = x1825*x92
    x1828 = x1712*x87
    x1829 = x1778*x94
    x1830 = x1078*x384
    x1831 = x1080*x384
    x1832 = x385*x960
    x1833 = x385*x957
    x1834 = x1635 + x1667 + x344
    x1835 = x177 + x1830 - x1831 + x1832 - x1833 + x1834 + x972
    x1836 = x101*x1825
    x1837 = x106*x1825
    x1838 = x1714*x94
    x1839 = x1714*x86
    x1840 = x1080*x1621
    x1841 = x1078*x1621
    x1842 = x385*x782
    x1843 = x385*x784
    x1844 = x1253 + x1640 + x1696
    x1845 = x1382 + x184 + x1840 - x1841 + x1842 - x1843 + x1844
    x1846 = -x1717 + x1718
    x1847 = -x1790 + x1791
    x1848 = x182 + x1846 + x1847
    x1849 = 4*m2
    x1850 = 4*p2
    x1851 = -x1850
    x1852 = x1849 + x1851
    x1853 = -x1849 + x1850
    x1854 = x1105*x1759 + x1122*x1747 + x1133*x1761 + x851*(x1008 + x126*x1852 + x128*x1853 + x1603 + x1748 - x1749 + 2*x1826 - 2*x1827 + 2*x1828 - 2*x1829 + 2*x1830 - 2*x1831 + 2*x1832 - 2*x1833 + x865) + x906*(x1495 + x1750 + x1753 - x1755 - x1756 + x1807 + x1808 - x1809 - x1810 + x919) + x920*(x131*x1852 + x133*x1853 + x1421 + x1484 + x1602 + x1805 - x1806 + 2*x1836 - 2*x1837 + 2*x1838 - 2*x1839 + 2*x1840 - 2*x1841 + 2*x1842 - 2*x1843)
    x1855 = x1142*x1555
    x1856 = x1157*x79
    x1857 = x1142*x193
    x1858 = x16*x195
    x1859 = x16*x197
    x1860 = x1071*x1772 + x1147*x1605 + x1147*x1610 + x1149*x380 + x1153*x382 + x1156*x1607 + x1156*x1611 + x1157*x1267 + x1157*x1612 + x1158*x1636 + x1158*x1637 + x1158*x1638 + x1159*x1614 + x1159*x1616 + x1159*x1617 - x1576 - x1600 - x1601 + x1818*x943 + x1856 + x1857 + x1858*x373 + x1859*x379 + x225 + x227
    x1861 = x168*x453 + x170*x461 + x176*x459 + x440
    x1862 = x209*(-x1182*x450 - x1183*x446 - x1184*x442)
    x1863 = x163*x1862
    x1864 = x1287 + x264*x453 + x269*x459 + x275*x461
    x1865 = x1862*x292
    x1866 = x1629 + x349*x453 + x354*x461 + x359*x459
    x1867 = x1862*x370
    x1868 = x11**(mpmath.mpf(-5)/mpmath.mpf(2))
    x1869 = 3*n0
    x1870 = x1868*(-x1869 + x83)
    x1871 = x1870*x387
    x1872 = x213*x4
    x1873 = x1871*x1872
    x1874 = x1871*x8
    x1875 = x1874*x94
    x1876 = x1874*x215
    x1877 = x1871*x4
    x1878 = x1877*x89
    x1879 = x16*x970
    x1880 = x1879 - x400
    x1881 = x389*x4
    x1882 = x1881*x2
    x1883 = -x1882 + x395
    x1884 = x1880 + x1883
    x1885 = x1871*x6
    x1886 = x1885*x215
    x1887 = x106*x1877
    x1888 = x13*x43
    x1889 = x1877*x1888
    x1890 = x1885*x94
    x1891 = x16*x803
    x1892 = -x1891 + x416
    x1893 = x13*x1881
    x1894 = x1893 - x419
    x1895 = x1892 + x1894
    x1896 = x387*x399
    x1897 = 2*x1896
    x1898 = x16*x390
    x1899 = 2*x1898
    x1900 = -x1897 + x1899
    x1901 = x1874*x1888
    x1902 = x1885*x89
    x1903 = x1885*x213
    x1904 = x106*x1874
    x1905 = x2*x803
    x1906 = x1905 - x410
    x1907 = x13*x970
    x1908 = -x1907 + x406
    x1909 = x1906 + x1908
    x1910 = x2*x390
    x1911 = 2*x1910
    x1912 = x387*x409
    x1913 = 2*x1912
    x1914 = -x1911 + x1913
    x1915 = x13*x453
    x1916 = 2*x462
    x1917 = x2*x459
    x1918 = x16*x461
    x1919 = x1862*x451
    x1920 = -x1879 + x400
    x1921 = x1882 - x395
    x1922 = x1920 + x1921
    x1923 = -x1905 + x410
    x1924 = x1907 - x406
    x1925 = x1923 + x1924
    x1926 = x1911 - x1913
    x1927 = x1891 - x416
    x1928 = -x1893 + x419
    x1929 = x1927 + x1928
    x1930 = x1897 - x1899
    x1931 = x402*x453 + x414*x461 + x423*x459 + x59*(-x1901 - x1902 + x1903 + x1904 + x1925 + x1926) + x69*(-x1886 - x1887 + x1889 + x1890 + x1929 + x1930) + x76*(-x1873 - x1875 + x1876 + x1878 + x1922)
    x1932 = x1870*x465
    x1933 = x1872*x1932
    x1934 = x1932*x8
    x1935 = x1934*x94
    x1936 = x1934*x215
    x1937 = x1932*x4
    x1938 = x1937*x89
    x1939 = x1896 - x1898
    x1940 = x1932*x6
    x1941 = x1940*x215
    x1942 = x106*x1937
    x1943 = x1888*x1937
    x1944 = x1940*x94
    x1945 = x16*x466
    x1946 = x399*x465
    x1947 = x1945 - x1946
    x1948 = x1888*x1934
    x1949 = x1940*x89
    x1950 = x1940*x213
    x1951 = x106*x1934
    x1952 = x13*x390
    x1953 = x387*x405
    x1954 = x1952 - x1953
    x1955 = x409*x465
    x1956 = x2*x466
    x1957 = x1955 - x1956
    x1958 = x1954 + x1957
    x1959 = -x1945 + x1946
    x1960 = -x1896 + x1898
    x1961 = -x1952 + x1953
    x1962 = -x1955 + x1956
    x1963 = x1961 + x1962
    x1964 = x453*x473 + x459*x479 + x461*x486 + x59*(-x1948 - x1949 + x1950 + x1951 + x1963) + x69*(-x1941 - x1942 + x1943 + x1944 + x1959) + x76*(-x1933 - x1935 + x1936 + x1938 + x1960)
    x1965 = x1862*x510
    x1966 = x13*x462
    x1967 = x2*x462
    x1968 = x16*x462
    x1969 = x1915*x520 + x1917*x520 + x1918*x520 + x1966*x512 + x1967*x517 + x1968*x519
    x1970 = x1870*x523
    x1971 = x1872*x1970
    x1972 = x1970*x8
    x1973 = x1972*x94
    x1974 = x1972*x215
    x1975 = x1970*x4
    x1976 = x1975*x89
    x1977 = x1910 - x1912
    x1978 = x1970*x6
    x1979 = x1978*x215
    x1980 = x106*x1975
    x1981 = x1888*x1975
    x1982 = x1978*x94
    x1983 = x16*x524
    x1984 = x399*x523
    x1985 = x1983 - x1984
    x1986 = x1961 + x1985
    x1987 = x1888*x1972
    x1988 = x1978*x89
    x1989 = x1978*x213
    x1990 = x106*x1972
    x1991 = x409*x523
    x1992 = x2*x524
    x1993 = x1991 - x1992
    x1994 = -x1991 + x1992
    x1995 = -x1910 + x1912
    x1996 = -x1983 + x1984
    x1997 = x1954 + x1996
    x1998 = x453*x531 + x459*x542 + x461*x537 + x59*(-x1987 - x1988 + x1989 + x1990 + x1994) + x69*(-x1979 - x1980 + x1981 + x1982 + x1997) + x76*(-x1971 - x1973 + x1974 + x1976 + x1995)
    x1999 = x1862*x561
    x2000 = x1915*x569 + x1917*x569 + x1918*x569 + x1966*x563 + x1967*x567 + x1968*x568
    x2001 = x427*x608
    x2002 = x425*x606
    x2003 = x387*x393
    x2004 = x2003*x8
    x2005 = -x580
    x2006 = x425*x612
    x2007 = x432*x608
    x2008 = x387*x394
    x2009 = -x2008
    x2010 = x432*x606
    x2011 = x427*x612
    x2012 = x59*(x2004 + x2005 + x2006 - x2007) + x69*(x2009 + x2010 - x2011 + x584) + x76*(x2001 - x2002)
    x2013 = x2012 + x453*x586 + x459*x604 + x461*x596
    x2014 = x1862*x631
    x2015 = -x584
    x2016 = -x2004
    x2017 = x100*(-x2001 + x2002) + x120*(x2008 - x2010 + x2011 + x2015) + x142*(-x2006 + x2007 + x2016 + x580) + x1915*x642 + x1917*x642 + x1918*x642 + x1966*x633 + x1967*x639 + x1968*x641
    x2018 = x427*x675
    x2019 = x425*x673
    x2020 = x432*x673
    x2021 = x427*x678
    x2022 = -x650
    x2023 = x425*x678
    x2024 = x432*x675
    x2025 = -x50
    x2026 = x2003*x6
    x2027 = x2025 - x2026
    x2028 = x59*(x2022 + x2023 - x2024 + x2027) + x69*(x2020 - x2021 + x654) + x76*(x2008 + x2018 - x2019)
    x2029 = x2028 + x453*x656 + x459*x663 + x461*x671
    x2030 = x1862*x694
    x2031 = -x654
    x2032 = x2026 + x50
    x2033 = x100*(x2009 - x2018 + x2019) + x120*(-x2020 + x2021 + x2031) + x142*(-x2023 + x2024 + x2032 + x650) + x1915*x705 + x1917*x705 + x1918*x705 + x1966*x696 + x1967*x702 + x1968*x704
    x2034 = x427*x735
    x2035 = x425*x733
    x2036 = -x713
    x2037 = x425*x738
    x2038 = x432*x735
    x2039 = x432*x733
    x2040 = x427*x738
    x2041 = x59*(x2036 + x2037 - x2038) + x69*(x2032 + x2039 - x2040 + x717) + x76*(x2016 + x2034 - x2035)
    x2042 = x2041 + x453*x719 + x459*x731 + x461*x726
    x2043 = x1862*x750
    x2044 = -x717
    x2045 = x100*(x2004 - x2034 + x2035) + x120*(x2027 - x2039 + x2040 + x2044) + x142*(-x2037 + x2038 + x713) + x1915*x758 + x1917*x758 + x1918*x758 + x1966*x752 + x1967*x756 + x1968*x757
    x2046 = x1870*x6
    x2047 = x1872*x2046
    x2048 = x1870*x777
    x2049 = x2048*x94
    x2050 = x2048*x215
    x2051 = x2046*x4
    x2052 = x2051*x89
    x2053 = x427*x942
    x2054 = x427*x775
    x2055 = x2053 - x2054
    x2056 = x425*x784
    x2057 = x425*x944
    x2058 = x2056 - x2057
    x2059 = x1922 + x2055 + x2058
    x2060 = 2*n0
    x2061 = x2060 + x763
    x2062 = x16*x389
    x2063 = -x2060 + x762
    x2064 = x1870*x7
    x2065 = x2064*x215
    x2066 = x2064*x94
    x2067 = x106*x2051
    x2068 = x1888*x2051
    x2069 = x427*x797
    x2070 = x427*x936
    x2071 = x432*x944
    x2072 = x432*x784
    x2073 = x13*x39
    x2074 = x2073 - x844
    x2075 = x1939 + x2009 + x397
    x2076 = x1928 + x2069 - x2070 + x2071 - x2072 + x2074 + x2075
    x2077 = x2*x389
    x2078 = x2064*x89
    x2079 = x2064*x213
    x2080 = x1888*x2048
    x2081 = x106*x2048
    x2082 = x425*x936
    x2083 = x425*x797
    x2084 = x432*x775
    x2085 = x432*x942
    x2086 = x20*x765
    x2087 = -x2086 + x847
    x2088 = x1977 + x2004 + x431
    x2089 = x1924 + x2082 - x2083 + x2084 - x2085 + x2087 + x2088
    x2090 = (mpmath.mpf(1)/mpmath.mpf(2))*x392 + (mpmath.mpf(1)/mpmath.mpf(2))*x396 - mpmath.mpf(1)/mpmath.mpf(2)*x398 - mpmath.mpf(1)/mpmath.mpf(2)*x401
    x2091 = 2*x2057
    x2092 = 2*x2050
    x2093 = 2*x2052
    x2094 = 2*x2054
    x2095 = 2*x2053
    x2096 = 2*x2047
    x2097 = 2*x2049
    x2098 = 2*x2056
    x2099 = 2*x395
    x2100 = 2*x1882
    x2101 = -x2099 + x2100
    x2102 = 2*x1879
    x2103 = 2*x400
    x2104 = -x2102 + x2103
    x2105 = (mpmath.mpf(1)/mpmath.mpf(2))*x412
    x2106 = (mpmath.mpf(1)/mpmath.mpf(2))*x51
    x2107 = x2105 - x2106
    x2108 = x2107 + (mpmath.mpf(1)/mpmath.mpf(2))*x404 + (mpmath.mpf(1)/mpmath.mpf(2))*x407 - mpmath.mpf(1)/mpmath.mpf(2)*x408 - mpmath.mpf(1)/mpmath.mpf(2)*x411
    x2109 = (mpmath.mpf(1)/mpmath.mpf(2))*x67
    x2110 = (mpmath.mpf(1)/mpmath.mpf(2))*x421
    x2111 = x2109 - x2110
    x2112 = x2111 + (mpmath.mpf(1)/mpmath.mpf(2))*x415 + (mpmath.mpf(1)/mpmath.mpf(2))*x417 - mpmath.mpf(1)/mpmath.mpf(2)*x418 - mpmath.mpf(1)/mpmath.mpf(2)*x420
    x2113 = 4*n0
    x2114 = -x2113 + x908
    x2115 = x2113 + x909
    x2116 = 2*x391
    x2117 = 2*x2004
    x2118 = 2*x2086
    x2119 = 2*x847
    x2120 = -x2118 + x2119
    x2121 = 2*x406
    x2122 = 2*x1907
    x2123 = -x2121 + x2122
    x2124 = 2*x2008
    x2125 = 2*x397
    x2126 = 2*x1893
    x2127 = 2*x419
    x2128 = -x2126 + x2127
    x2129 = 2*x844
    x2130 = 2*x2073
    x2131 = -x2129 + x2130
    x2132 = x2090*x850 + x2108*x888 + x2112*x905 + x851*(-x2091 - x2092 - x2093 - x2094 + x2095 + x2096 + x2097 + x2098 + x2101 + x2104) + x906*(x1926 + x2077*x2114 + 2*x2078 - 2*x2079 + 2*x2080 - 2*x2081 + 2*x2082 - 2*x2083 + 2*x2084 - 2*x2085 + x2115*x409 - x2116 + x2117 + x2120 + x2123) + x920*(x1930 + x2062*x2115 + 2*x2065 - 2*x2066 + 2*x2067 - 2*x2068 + 2*x2069 - 2*x2070 + 2*x2071 - 2*x2072 + x2114*x399 - x2124 + x2125 + x2128 + x2131)
    x2133 = x1862*x930
    x2134 = x463*x69
    x2135 = x463*x59
    x2136 = x1858*x461 + x1915*x941 + x1917*x941 + x1918*x941 + x1966*x932 + x1967*x939 + x1968*x940 + x2134*x942 + x2135*x944 + x453*x934 - x454 - x455 + x459*x938 + x463*x937
    x2137 = x1870*x9
    x2138 = x2137*x94
    x2139 = x2137*x215
    x2140 = x1870*x8
    x2141 = x1872*x2140
    x2142 = x2140*x4
    x2143 = x2142*x89
    x2144 = x1060*x427
    x2145 = x427*x953
    x2146 = x425*x960
    x2147 = x1071*x425
    x2148 = x1960 + x2008 + x456
    x2149 = x2144 - x2145 + x2146 - x2147 + x2148
    x2150 = x106*x2142
    x2151 = x1888*x2142
    x2152 = -x2053 + x2054
    x2153 = x1071*x432
    x2154 = x432*x960
    x2155 = x2*x39
    x2156 = x2155 - x996
    x2157 = x2153 - x2154 + x2156
    x2158 = x1880 + x2152 + x2157
    x2159 = x1888*x2137
    x2160 = x106*x2137
    x2161 = x2048*x89
    x2162 = x2048*x213
    x2163 = x432*x953
    x2164 = x1060*x432
    x2165 = x425*x942
    x2166 = x425*x775
    x2167 = x1961 + x2027 + x403 + x44
    x2168 = x409*x8
    x2169 = x2*x970
    x2170 = x1013 - x1015 + x2168 - x2169
    x2171 = x2163 - x2164 + x2165 - x2166 + x2167 + x2170
    x2172 = 2*x2151
    x2173 = 2*x2154
    x2174 = 2*x2153
    x2175 = 2*x2150
    x2176 = 2*x996
    x2177 = 2*x2155
    x2178 = -x2176 + x2177
    x2179 = x2102 - x2103
    x2180 = 2*x1952
    x2181 = 2*x2026
    x2182 = 2*x403
    x2183 = 2*x1953
    x2184 = 2*x50
    x2185 = -x2184
    x2186 = x1040 + x2185
    x2187 = 2*x1015
    x2188 = 2*x1013
    x2189 = 2*x2169
    x2190 = 2*x2168
    x2191 = -x2187 + x2188 - x2189 + x2190
    x2192 = x1001*x2112 + x1024*x2090 + x1035*x2108 + x851*(x1900 + x2124 - x2125 + 2*x2138 - 2*x2139 + 2*x2141 - 2*x2143 + 2*x2144 - 2*x2145 + 2*x2146 - 2*x2147) + x906*(2*x2159 - 2*x2160 + 2*x2161 - 2*x2162 + 2*x2163 - 2*x2164 + 2*x2165 - 2*x2166 - x2180 - x2181 + x2182 + x2183 + x2186 + x2191) + x920*(x2092 + x2094 - x2095 - x2097 - x2172 - x2173 + x2174 + x2175 + x2178 + x2179)
    x2193 = x1051*x1862
    x2194 = x189*x463
    x2195 = x1055*x1966 + x1057*x459 + x1061*x463 + x1064*x1967 + x1067*x1968 + x1068*x1915 + x1068*x1917 + x1068*x1918 + x1069*x2194 + x1071*x2135 - x1290 - x1291 + x1859*x461 + x453*x938
    x2196 = x10*x1870
    x2197 = x213*x2196
    x2198 = x2196*x89
    x2199 = x2142*x94
    x2200 = x2142*x215
    x2201 = x1080*x425
    x2202 = x1152*x425
    x2203 = x1071*x427
    x2204 = x427*x960
    x2205 = x1995 + x2016 + x391
    x2206 = x2201 - x2202 + x2203 - x2204 + x2205
    x2207 = x106*x2196
    x2208 = x1888*x2196
    x2209 = x2051*x215
    x2210 = x2051*x94
    x2211 = x1152*x432
    x2212 = x1080*x432
    x2213 = x427*x784
    x2214 = x427*x944
    x2215 = x1292 + x1954 + x2032 + x498
    x2216 = x16*x1881
    x2217 = x1108 - x1116 - x1120 + x2216
    x2218 = x2211 - x2212 + x2213 - x2214 + x2215 + x2217
    x2219 = -x2056 + x2057
    x2220 = -x2155 + x996
    x2221 = -x2153 + x2154 + x2220
    x2222 = x1883 + x2219 + x2221
    x2223 = x2176 - x2177
    x2224 = x2099 - x2100
    x2225 = x1041 + x2184
    x2226 = 2*x1116
    x2227 = 2*x1108
    x2228 = 2*x1120
    x2229 = 2*x2216
    x2230 = -x2226 + x2227 - x2228 + x2229
    x2231 = x1105*x2108 + x1122*x2090 + x1133*x2112 + x851*(x1914 + x2116 - x2117 + 2*x2197 - 2*x2198 + 2*x2199 - 2*x2200 + 2*x2201 - 2*x2202 + 2*x2203 - 2*x2204) + x906*(x2091 + x2093 - x2096 - x2098 + x2172 + x2173 - x2174 - x2175 + x2223 + x2224) + x920*(x2180 + x2181 - x2182 - x2183 + 2*x2207 - 2*x2208 + 2*x2209 - 2*x2210 + 2*x2211 - 2*x2212 + 2*x2213 - 2*x2214 + x2225 + x2230)
    x2232 = x1142*x1862
    x2233 = x1071*x2134 + x1147*x1966 + x1149*x461 + x1153*x463 + x1156*x1967 + x1157*x1968 + x1158*x1915 + x1158*x1917 + x1158*x1918 - x1632 - x1633 + x1858*x453 + x1859*x459 + x2194*x943
    x2234 = x168*x512 + x170*x519 + x176*x517 + x501
    x2235 = x209*(-x1182*x503 - x1183*x507 - x1184*x509)
    x2236 = x163*x2235
    x2237 = x1303 + x264*x512 + x269*x517 + x275*x519
    x2238 = x2235*x292
    x2239 = x1648 + x349*x512 + x354*x519 + x359*x517
    x2240 = x2235*x370
    x2241 = 3*n1
    x2242 = x1868*(x1162 - x2241)
    x2243 = x2242*x387
    x2244 = x1872*x2243
    x2245 = x2243*x8
    x2246 = x2245*x94
    x2247 = x215*x2245
    x2248 = x2243*x4
    x2249 = x2248*x89
    x2250 = x2243*x6
    x2251 = x215*x2250
    x2252 = x106*x2248
    x2253 = x1888*x2248
    x2254 = x2250*x94
    x2255 = x1888*x2245
    x2256 = x2250*x89
    x2257 = x213*x2250
    x2258 = x106*x2245
    x2259 = x402*x512 + x414*x519 + x423*x517 + x59*(x1963 - x2255 - x2256 + x2257 + x2258) + x69*(x1959 - x2251 - x2252 + x2253 + x2254) + x76*(x1960 - x2244 - x2246 + x2247 + x2249)
    x2260 = x2235*x451
    x2261 = x2242*x465
    x2262 = x2261*x6
    x2263 = x215*x2262
    x2264 = x2261*x4
    x2265 = x106*x2264
    x2266 = x1888*x2264
    x2267 = x2262*x94
    x2268 = x1872*x2261
    x2269 = x2261*x8
    x2270 = x2269*x94
    x2271 = x215*x2269
    x2272 = x2264*x89
    x2273 = 2*x1945
    x2274 = 2*x1946
    x2275 = -x2273 + x2274
    x2276 = x1888*x2269
    x2277 = x2262*x89
    x2278 = x213*x2262
    x2279 = x106*x2269
    x2280 = x405*x465
    x2281 = 2*x2280
    x2282 = x13*x466
    x2283 = 2*x2282
    x2284 = -x2281 + x2283
    x2285 = x2*x520
    x2286 = x13*x520
    x2287 = x16*x520
    x2288 = x2235*x510
    x2289 = x2281 - x2283
    x2290 = x2273 - x2274
    x2291 = x473*x512 + x479*x517 + x486*x519 + x59*(x1925 - x2276 - x2277 + x2278 + x2279 + x2289) + x69*(x1929 - x2263 - x2265 + x2266 + x2267) + x76*(x1922 - x2268 - x2270 + x2271 + x2272 + x2290)
    x2292 = x2242*x523
    x2293 = x1872*x2292
    x2294 = x2292*x8
    x2295 = x2294*x94
    x2296 = x215*x2294
    x2297 = x2292*x4
    x2298 = x2297*x89
    x2299 = x1962 + x1996
    x2300 = x2292*x6
    x2301 = x215*x2300
    x2302 = x106*x2297
    x2303 = x1888*x2297
    x2304 = x2300*x94
    x2305 = x2280 - x2282
    x2306 = x1888*x2294
    x2307 = x2300*x89
    x2308 = x213*x2300
    x2309 = x106*x2294
    x2310 = x13*x524
    x2311 = x405*x523
    x2312 = x2310 - x2311
    x2313 = -x2310 + x2311
    x2314 = -x2280 + x2282
    x2315 = x1957 + x1985
    x2316 = x512*x531 + x517*x542 + x519*x537 + x59*(-x2306 - x2307 + x2308 + x2309 + x2313) + x69*(-x2301 - x2302 + x2303 + x2304 + x2314) + x76*(-x2293 - x2295 + x2296 + x2298 + x2315)
    x2317 = x2235*x561
    x2318 = x13*x512
    x2319 = x2*x517
    x2320 = x16*x519
    x2321 = x2285*x567 + x2286*x563 + x2287*x568 + x2318*x569 + x2319*x569 + x2320*x569
    x2322 = x394*x465
    x2323 = -x2322
    x2324 = x493*x606
    x2325 = x490*x612
    x2326 = x490*x608
    x2327 = x488*x606
    x2328 = x488*x612
    x2329 = x493*x608
    x2330 = x393*x465
    x2331 = x2330*x8
    x2332 = x2331 + x50
    x2333 = x59*(x2328 - x2329 + x2332 + x588) + x69*(x2323 + x2324 - x2325) + x76*(x2015 + x2326 - x2327)
    x2334 = x2333 + x512*x586 + x517*x604 + x519*x596
    x2335 = x2235*x631
    x2336 = -x588
    x2337 = x2025 - x2331
    x2338 = x100*(-x2326 + x2327 + x584) + x120*(x2322 - x2324 + x2325) + x142*(-x2328 + x2329 + x2336 + x2337) + x2285*x639 + x2286*x633 + x2287*x641 + x2318*x642 + x2319*x642 + x2320*x642
    x2339 = x493*x673
    x2340 = x490*x678
    x2341 = x490*x675
    x2342 = x488*x673
    x2343 = x2330*x6
    x2344 = -x2343
    x2345 = x488*x678
    x2346 = x493*x675
    x2347 = x59*(x2344 + x2345 - x2346 + x661) + x69*(x2339 - x2340) + x76*(x2031 + x2322 + x2341 - x2342)
    x2348 = x2347 + x512*x656 + x517*x663 + x519*x671
    x2349 = x2235*x694
    x2350 = -x661
    x2351 = x100*(x2323 - x2341 + x2342 + x654) + x120*(-x2339 + x2340) + x142*(x2343 - x2345 + x2346 + x2350) + x2285*x702 + x2286*x696 + x2287*x704 + x2318*x705 + x2319*x705 + x2320*x705
    x2352 = x493*x733
    x2353 = x490*x738
    x2354 = x488*x738
    x2355 = x493*x735
    x2356 = x490*x735
    x2357 = x488*x733
    x2358 = x59*(x2354 - x2355 + x721) + x69*(x2343 + x2352 - x2353) + x76*(x2044 + x2337 + x2356 - x2357)
    x2359 = x2358 + x512*x719 + x517*x731 + x519*x726
    x2360 = x2235*x750
    x2361 = -x721
    x2362 = x100*(x2332 - x2356 + x2357 + x717) + x120*(x2344 - x2352 + x2353) + x142*(-x2354 + x2355 + x2361) + x2285*x756 + x2286*x752 + x2287*x757 + x2318*x758 + x2319*x758 + x2320*x758
    x2363 = x2242*x6
    x2364 = x1872*x2363
    x2365 = x2242*x777
    x2366 = x2365*x94
    x2367 = x215*x2365
    x2368 = x2363*x4
    x2369 = x2368*x89
    x2370 = x490*x942
    x2371 = x490*x775
    x2372 = x2370 - x2371
    x2373 = x488*x784
    x2374 = x488*x944
    x2375 = -x2073 + x844
    x2376 = x2373 - x2374 + x2375
    x2377 = x1892 + x2372 + x2376
    x2378 = x2242*x7
    x2379 = x215*x2378
    x2380 = x2378*x94
    x2381 = x106*x2368
    x2382 = x1888*x2368
    x2383 = x490*x797
    x2384 = x490*x936
    x2385 = x493*x944
    x2386 = x493*x784
    x2387 = x1959 + x2323 + x470
    x2388 = x2383 - x2384 + x2385 - x2386 + x2387
    x2389 = x2378*x89
    x2390 = x213*x2378
    x2391 = x1888*x2365
    x2392 = x106*x2365
    x2393 = x488*x936
    x2394 = x488*x797
    x2395 = x493*x775
    x2396 = x493*x942
    x2397 = x1962 + x2332 + x495 + x498
    x2398 = x13*x803
    x2399 = x405*x6
    x2400 = x2398 - x2399 - x874 + x876
    x2401 = x2393 - x2394 + x2395 - x2396 + x2397 + x2400
    x2402 = -x2109 + x2110
    x2403 = x2402 + (mpmath.mpf(1)/mpmath.mpf(2))*x468 + (mpmath.mpf(1)/mpmath.mpf(2))*x469 - mpmath.mpf(1)/mpmath.mpf(2)*x471 - mpmath.mpf(1)/mpmath.mpf(2)*x472
    x2404 = 2*x2322
    x2405 = 2*x470
    x2406 = 2*x2374
    x2407 = 2*x2367
    x2408 = 2*x2369
    x2409 = 2*x2371
    x2410 = 2*x2370
    x2411 = 2*x2364
    x2412 = 2*x2366
    x2413 = 2*x2373
    x2414 = x2129 - x2130
    x2415 = 2*x1891
    x2416 = 2*x416
    x2417 = -x2415 + x2416
    x2418 = (mpmath.mpf(1)/mpmath.mpf(2))*x474 + (mpmath.mpf(1)/mpmath.mpf(2))*x475 - mpmath.mpf(1)/mpmath.mpf(2)*x477 - mpmath.mpf(1)/mpmath.mpf(2)*x478
    x2419 = (mpmath.mpf(1)/mpmath.mpf(2))*x57
    x2420 = (mpmath.mpf(1)/mpmath.mpf(2))*x484
    x2421 = x2419 - x2420
    x2422 = x2421 + (mpmath.mpf(1)/mpmath.mpf(2))*x480 + (mpmath.mpf(1)/mpmath.mpf(2))*x481 - mpmath.mpf(1)/mpmath.mpf(2)*x482 - mpmath.mpf(1)/mpmath.mpf(2)*x483
    x2423 = 2*x467
    x2424 = 2*x1955
    x2425 = 2*x1956
    x2426 = 2*x2331
    x2427 = 2*x874
    x2428 = 2*x876
    x2429 = 2*x2399
    x2430 = 2*x2398
    x2431 = -x2427 + x2428 - x2429 + x2430
    x2432 = x2403*x850 + x2418*x905 + x2422*x888 + x851*(-x2406 - x2407 - x2408 - x2409 + x2410 + x2411 + x2412 + x2413 + x2414 + x2417) + x906*(x2225 + 2*x2389 - 2*x2390 + 2*x2391 - 2*x2392 + 2*x2393 - 2*x2394 + 2*x2395 - 2*x2396 - x2423 - x2424 + x2425 + x2426 + x2431) + x920*(x2275 + 2*x2379 - 2*x2380 + 2*x2381 - 2*x2382 + 2*x2383 - 2*x2384 + 2*x2385 - 2*x2386 - x2404 + x2405)
    x2433 = x2235*x930
    x2434 = x521*x69
    x2435 = x521*x59
    x2436 = x1858*x519 + x2285*x939 + x2286*x932 + x2287*x940 + x2318*x941 + x2319*x941 + x2320*x941 + x2434*x942 + x2435*x944 + x512*x934 - x513 - x514 + x517*x938 + x521*x937
    x2437 = 2*n1
    x2438 = x1446 - x2437
    x2439 = x1447 + x2437
    x2440 = x2242*x9
    x2441 = x2440*x94
    x2442 = x215*x2440
    x2443 = x2242*x8
    x2444 = x1872*x2443
    x2445 = x2443*x4
    x2446 = x2445*x89
    x2447 = x1060*x490
    x2448 = x490*x953
    x2449 = x488*x960
    x2450 = x1071*x488
    x2451 = x1947 + x2322 + x515
    x2452 = x1921 + x2220 + x2447 - x2448 + x2449 - x2450 + x2451
    x2453 = x106*x2445
    x2454 = x1888*x2445
    x2455 = -x2370 + x2371
    x2456 = x1071*x493
    x2457 = x493*x960
    x2458 = x2456 - x2457
    x2459 = x1929 + x2455 + x2458
    x2460 = x13*x389
    x2461 = x1888*x2440
    x2462 = x106*x2440
    x2463 = x2365*x89
    x2464 = x213*x2365
    x2465 = x493*x953
    x2466 = x1060*x493
    x2467 = x488*x942
    x2468 = x488*x775
    x2469 = x2086 - x847
    x2470 = x2305 + x2344 + x476
    x2471 = x1923 + x2465 - x2466 + x2467 - x2468 + x2469 + x2470
    x2472 = 2*x2454
    x2473 = 2*x2457
    x2474 = 2*x2456
    x2475 = 2*x2453
    x2476 = x2415 - x2416
    x2477 = 4*n1
    x2478 = x1488 + x2477
    x2479 = x1486 - x2477
    x2480 = 2*x2343
    x2481 = 2*x476
    x2482 = x2118 - x2119
    x2483 = 2*x1905
    x2484 = 2*x410
    x2485 = -x2483 + x2484
    x2486 = x1001*x2418 + x1024*x2403 + x1035*x2422 + x851*(x2062*x2479 + x2101 + x2223 + x2290 + x2404 - x2405 + 2*x2441 - 2*x2442 + 2*x2444 - 2*x2446 + 2*x2447 - 2*x2448 + 2*x2449 - 2*x2450 + x2478*x399) + x906*(x2289 + x2460*x2478 + 2*x2461 - 2*x2462 + 2*x2463 - 2*x2464 + 2*x2465 - 2*x2466 + 2*x2467 - 2*x2468 + x2479*x405 - x2480 + x2481 + x2482 + x2485) + x920*(x2128 + x2407 + x2409 - x2410 - x2412 - x2472 - x2473 + x2474 + x2475 + x2476)
    x2487 = x1051*x2235
    x2488 = x189*x521
    x2489 = x1055*x2286 + x1057*x517 + x1061*x521 + x1064*x2285 + x1067*x2287 + x1068*x2318 + x1068*x2319 + x1068*x2320 + x1069*x2488 + x1071*x2435 - x1306 - x1307 + x1859*x519 + x512*x938
    x2490 = x10*x2242
    x2491 = x213*x2490
    x2492 = x2490*x89
    x2493 = x2445*x94
    x2494 = x215*x2445
    x2495 = x1080*x488
    x2496 = x1152*x488
    x2497 = x1071*x490
    x2498 = x490*x960
    x2499 = x1957 + x2337 + x44 + x467
    x2500 = -x1108 + x1116 + x1120 - x2216
    x2501 = x2495 - x2496 + x2497 - x2498 + x2499 + x2500
    x2502 = x106*x2490
    x2503 = x1888*x2490
    x2504 = x215*x2368
    x2505 = x2368*x94
    x2506 = x1152*x493
    x2507 = x1080*x493
    x2508 = x490*x784
    x2509 = x490*x944
    x2510 = x1308 + x2314 + x2343
    x2511 = x2506 - x2507 + x2508 - x2509 + x2510
    x2512 = -x2456 + x2457
    x2513 = x2074 - x2373 + x2374
    x2514 = x1894 + x2512 + x2513
    x2515 = x2126 - x2127
    x2516 = x2226 - x2227 + x2228 - x2229
    x2517 = x1105*x2422 + x1122*x2403 + x1133*x2418 + x851*(x2186 + x2423 + x2424 - x2425 - x2426 + 2*x2491 - 2*x2492 + 2*x2493 - 2*x2494 + 2*x2495 - 2*x2496 + 2*x2497 - 2*x2498 + x2516) + x906*(x2131 + x2406 + x2408 - x2411 - x2413 + x2472 + x2473 - x2474 - x2475 + x2515) + x920*(x2284 + x2480 - x2481 + 2*x2502 - 2*x2503 + 2*x2504 - 2*x2505 + 2*x2506 - 2*x2507 + 2*x2508 - 2*x2509)
    x2518 = x1142*x2235
    x2519 = x1071*x2434 + x1147*x2286 + x1149*x519 + x1153*x521 + x1156*x2285 + x1157*x2287 + x1158*x2318 + x1158*x2319 + x1158*x2320 - x1651 - x1652 + x1858*x512 + x1859*x517 + x2488*x943
    x2520 = x168*x563 + x170*x568 + x176*x567 + x554
    x2521 = x209*(-x1182*x558 - x1183*x556 - x1184*x560)
    x2522 = x163*x2521
    x2523 = x1316 + x264*x563 + x269*x567 + x275*x568
    x2524 = x2521*x292
    x2525 = x1660 + x349*x563 + x354*x568 + x359*x567
    x2526 = x2521*x370
    x2527 = 3*n2
    x2528 = x1868*(x1535 - x2527)
    x2529 = x2528*x387
    x2530 = x1872*x2529
    x2531 = x2529*x8
    x2532 = x2531*x94
    x2533 = x215*x2531
    x2534 = x2529*x4
    x2535 = x2534*x89
    x2536 = x2529*x6
    x2537 = x215*x2536
    x2538 = x106*x2534
    x2539 = x1888*x2534
    x2540 = x2536*x94
    x2541 = x1888*x2531
    x2542 = x2536*x89
    x2543 = x213*x2536
    x2544 = x106*x2531
    x2545 = x402*x563 + x414*x568 + x423*x567 + x59*(x1994 - x2541 - x2542 + x2543 + x2544) + x69*(x1997 - x2537 - x2538 + x2539 + x2540) + x76*(x1995 - x2530 - x2532 + x2533 + x2535)
    x2546 = x2521*x451
    x2547 = x2528*x465
    x2548 = x1872*x2547
    x2549 = x2547*x8
    x2550 = x2549*x94
    x2551 = x215*x2549
    x2552 = x2547*x4
    x2553 = x2552*x89
    x2554 = x2547*x6
    x2555 = x215*x2554
    x2556 = x106*x2552
    x2557 = x1888*x2552
    x2558 = x2554*x94
    x2559 = x1888*x2549
    x2560 = x2554*x89
    x2561 = x213*x2554
    x2562 = x106*x2549
    x2563 = x473*x563 + x479*x567 + x486*x568 + x59*(x2313 - x2559 - x2560 + x2561 + x2562) + x69*(x2314 - x2555 - x2556 + x2557 + x2558) + x76*(x2315 - x2548 - x2550 + x2551 + x2553)
    x2564 = x2521*x510
    x2565 = x2528*x523
    x2566 = x2565*x8
    x2567 = x1888*x2566
    x2568 = x2565*x6
    x2569 = x2568*x89
    x2570 = x213*x2568
    x2571 = x106*x2566
    x2572 = x1872*x2565
    x2573 = x2566*x94
    x2574 = x215*x2566
    x2575 = x2565*x4
    x2576 = x2575*x89
    x2577 = 2*x1991
    x2578 = 2*x1992
    x2579 = -x2577 + x2578
    x2580 = x215*x2568
    x2581 = x106*x2575
    x2582 = x1888*x2575
    x2583 = x2568*x94
    x2584 = 2*x2310
    x2585 = 2*x2311
    x2586 = -x2584 + x2585
    x2587 = x16*x569
    x2588 = x13*x569
    x2589 = x2*x569
    x2590 = x2521*x561
    x2591 = x2584 - x2585
    x2592 = x2577 - x2578
    x2593 = x531*x563 + x537*x568 + x542*x567 + x59*(x1925 - x2567 - x2569 + x2570 + x2571) + x69*(x1929 - x2580 - x2581 + x2582 + x2583 + x2591) + x76*(x1922 - x2572 - x2573 + x2574 + x2576 + x2592)
    x2594 = x393*x523
    x2595 = x2594*x8
    x2596 = x544*x612
    x2597 = x549*x608
    x2598 = x546*x608
    x2599 = x544*x606
    x2600 = x549*x606
    x2601 = x546*x612
    x2602 = x394*x523
    x2603 = x2025 - x2602
    x2604 = x59*(x2595 + x2596 - x2597) + x69*(x2336 + x2600 - x2601 + x2603) + x76*(x2598 - x2599 + x580)
    x2605 = x2604 + x563*x586 + x567*x604 + x568*x596
    x2606 = x2521*x631
    x2607 = x2602 + x50
    x2608 = -x2595
    x2609 = x13*x563
    x2610 = x2*x567
    x2611 = x16*x568
    x2612 = x100*(x2005 - x2598 + x2599) + x120*(-x2600 + x2601 + x2607 + x588) + x142*(-x2596 + x2597 + x2608) + x2587*x641 + x2588*x633 + x2589*x639 + x2609*x642 + x2610*x642 + x2611*x642
    x2613 = x2594*x6
    x2614 = -x2613
    x2615 = x544*x678
    x2616 = x549*x675
    x2617 = x549*x673
    x2618 = x546*x678
    x2619 = x546*x675
    x2620 = x544*x673
    x2621 = x59*(x2614 + x2615 - x2616) + x69*(x2350 + x2617 - x2618) + x76*(x2607 + x2619 - x2620 + x650)
    x2622 = x2621 + x563*x656 + x567*x663 + x568*x671
    x2623 = x2521*x694
    x2624 = x100*(x2022 + x2603 - x2619 + x2620) + x120*(-x2617 + x2618 + x661) + x142*(x2613 - x2615 + x2616) + x2587*x704 + x2588*x696 + x2589*x702 + x2609*x705 + x2610*x705 + x2611*x705
    x2625 = x544*x738
    x2626 = x549*x735
    x2627 = x549*x733
    x2628 = x546*x738
    x2629 = x546*x735
    x2630 = x544*x733
    x2631 = x59*(x2625 - x2626) + x69*(x2361 + x2613 + x2627 - x2628) + x76*(x2608 + x2629 - x2630 + x713)
    x2632 = x2631 + x563*x719 + x567*x731 + x568*x726
    x2633 = x2521*x750
    x2634 = x100*(x2036 + x2595 - x2629 + x2630) + x120*(x2614 - x2627 + x2628 + x721) + x142*(-x2625 + x2626) + x2587*x757 + x2588*x752 + x2589*x756 + x2609*x758 + x2610*x758 + x2611*x758
    x2635 = x2528*x6
    x2636 = x1872*x2635
    x2637 = x2528*x777
    x2638 = x2637*x94
    x2639 = x215*x2637
    x2640 = x2635*x4
    x2641 = x2640*x89
    x2642 = x544*x784
    x2643 = x544*x944
    x2644 = x2642 - x2643
    x2645 = x546*x942
    x2646 = x546*x775
    x2647 = x2469 + x2645 - x2646
    x2648 = x1906 + x2644 + x2647
    x2649 = x2528*x7
    x2650 = x215*x2649
    x2651 = x2649*x94
    x2652 = x106*x2640
    x2653 = x1888*x2640
    x2654 = x546*x797
    x2655 = x546*x936
    x2656 = x549*x944
    x2657 = x549*x784
    x2658 = -x2398 + x2399 + x874 - x876
    x2659 = x1996 + x2603 + x44 + x528
    x2660 = x2654 - x2655 + x2656 - x2657 + x2658 + x2659
    x2661 = x2649*x89
    x2662 = x213*x2649
    x2663 = x1888*x2637
    x2664 = x106*x2637
    x2665 = x544*x936
    x2666 = x544*x797
    x2667 = x549*x775
    x2668 = x549*x942
    x2669 = x1994 + x2595 + x548
    x2670 = x2665 - x2666 + x2667 - x2668 + x2669
    x2671 = -x2105 + x2106
    x2672 = x2671 + (mpmath.mpf(1)/mpmath.mpf(2))*x526 + (mpmath.mpf(1)/mpmath.mpf(2))*x527 - mpmath.mpf(1)/mpmath.mpf(2)*x529 - mpmath.mpf(1)/mpmath.mpf(2)*x530
    x2673 = 2*x525
    x2674 = 2*x2595
    x2675 = 2*x2643
    x2676 = 2*x2639
    x2677 = 2*x2641
    x2678 = 2*x2646
    x2679 = 2*x2645
    x2680 = 2*x2636
    x2681 = 2*x2638
    x2682 = 2*x2642
    x2683 = x2483 - x2484
    x2684 = (mpmath.mpf(1)/mpmath.mpf(2))*x533 + (mpmath.mpf(1)/mpmath.mpf(2))*x534 - mpmath.mpf(1)/mpmath.mpf(2)*x535 - mpmath.mpf(1)/mpmath.mpf(2)*x536
    x2685 = -x2419 + x2420
    x2686 = x2685 + (mpmath.mpf(1)/mpmath.mpf(2))*x538 + (mpmath.mpf(1)/mpmath.mpf(2))*x539 - mpmath.mpf(1)/mpmath.mpf(2)*x540 - mpmath.mpf(1)/mpmath.mpf(2)*x541
    x2687 = 2*x1983
    x2688 = 2*x2602
    x2689 = 2*x528
    x2690 = 2*x1984
    x2691 = x2427 - x2428 + x2429 - x2430
    x2692 = x2672*x850 + x2684*x888 + x2686*x905 + x851*(x2482 - x2675 - x2676 - x2677 - x2678 + x2679 + x2680 + x2681 + x2682 + x2683) + x906*(x2579 + 2*x2661 - 2*x2662 + 2*x2663 - 2*x2664 + 2*x2665 - 2*x2666 + 2*x2667 - 2*x2668 - x2673 + x2674) + x920*(x2186 + 2*x2650 - 2*x2651 + 2*x2652 - 2*x2653 + 2*x2654 - 2*x2655 + 2*x2656 - 2*x2657 - x2687 - x2688 + x2689 + x2690 + x2691)
    x2693 = x2521*x930
    x2694 = x570*x69
    x2695 = x570*x59
    x2696 = x1858*x568 + x2587*x940 + x2588*x932 + x2589*x939 + x2609*x941 + x2610*x941 + x2611*x941 + x2694*x942 + x2695*x944 + x563*x934 - x564 - x565 + x567*x938 + x570*x937
    x2697 = x2528*x9
    x2698 = x2697*x94
    x2699 = x215*x2697
    x2700 = x2528*x8
    x2701 = x1872*x2700
    x2702 = x2700*x4
    x2703 = x2702*x89
    x2704 = x1060*x546
    x2705 = x546*x953
    x2706 = x544*x960
    x2707 = x1071*x544
    x2708 = x1985 + x2607 + x498 + x566
    x2709 = -x1013 + x1015 - x2168 + x2169
    x2710 = x2704 - x2705 + x2706 - x2707 + x2708 + x2709
    x2711 = x106*x2702
    x2712 = x1888*x2702
    x2713 = x1071*x549
    x2714 = x549*x960
    x2715 = x2713 - x2714
    x2716 = x2087 - x2645 + x2646
    x2717 = x1908 + x2715 + x2716
    x2718 = x1888*x2697
    x2719 = x106*x2697
    x2720 = x2637*x89
    x2721 = x213*x2637
    x2722 = x549*x953
    x2723 = x1060*x549
    x2724 = x544*x942
    x2725 = x544*x775
    x2726 = x2313 + x2614 + x532
    x2727 = x2722 - x2723 + x2724 - x2725 + x2726
    x2728 = 2*x2613
    x2729 = 2*x532
    x2730 = 2*x2712
    x2731 = 2*x2714
    x2732 = 2*x2713
    x2733 = 2*x2711
    x2734 = x2121 - x2122
    x2735 = x2187 - x2188 + x2189 - x2190
    x2736 = x1001*x2686 + x1024*x2672 + x1035*x2684 + x851*(x2225 + x2687 + x2688 - x2689 - x2690 + 2*x2698 - 2*x2699 + 2*x2701 - 2*x2703 + 2*x2704 - 2*x2705 + 2*x2706 - 2*x2707 + x2735) + x906*(x2586 + 2*x2718 - 2*x2719 + 2*x2720 - 2*x2721 + 2*x2722 - 2*x2723 + 2*x2724 - 2*x2725 - x2728 + x2729) + x920*(x2120 + x2676 + x2678 - x2679 - x2681 - x2730 - x2731 + x2732 + x2733 + x2734)
    x2737 = x1051*x2521
    x2738 = x189*x570
    x2739 = x1055*x2588 + x1057*x567 + x1061*x570 + x1064*x2589 + x1067*x2587 + x1068*x2609 + x1068*x2610 + x1068*x2611 + x1069*x2738 + x1071*x2695 - x1319 - x1320 + x1859*x568 + x563*x938
    x2740 = 2*n2
    x2741 = x1822 + x2740
    x2742 = x1821 - x2740
    x2743 = x10*x2528
    x2744 = x213*x2743
    x2745 = x2743*x89
    x2746 = x2702*x94
    x2747 = x215*x2702
    x2748 = x1080*x544
    x2749 = x1152*x544
    x2750 = x1071*x546
    x2751 = x546*x960
    x2752 = x1993 + x2608 + x525
    x2753 = x1920 + x2156 + x2748 - x2749 + x2750 - x2751 + x2752
    x2754 = x106*x2743
    x2755 = x1888*x2743
    x2756 = x215*x2640
    x2757 = x2640*x94
    x2758 = x1152*x549
    x2759 = x1080*x549
    x2760 = x546*x784
    x2761 = x546*x944
    x2762 = x1321 + x2312 + x2613
    x2763 = x1927 + x2375 + x2758 - x2759 + x2760 - x2761 + x2762
    x2764 = -x2642 + x2643
    x2765 = -x2713 + x2714
    x2766 = x1925 + x2764 + x2765
    x2767 = 4*n2
    x2768 = x1850 - x2767
    x2769 = x1851 + x2767
    x2770 = x1105*x2684 + x1122*x2672 + x1133*x2686 + x851*(x2077*x2769 + x2104 + x2178 + x2592 + x2673 - x2674 + 2*x2744 - 2*x2745 + 2*x2746 - 2*x2747 + 2*x2748 - 2*x2749 + 2*x2750 - 2*x2751 + x2768*x409) + x906*(x2123 + x2485 + x2675 + x2677 - x2680 - x2682 + x2730 + x2731 - x2732 - x2733) + x920*(x2414 + x2460*x2768 + x2476 + x2591 + x2728 - x2729 + 2*x2754 - 2*x2755 + 2*x2756 - 2*x2757 + 2*x2758 - 2*x2759 + 2*x2760 - 2*x2761 + x2769*x405)
    x2771 = x1142*x2521
    x2772 = x1071*x2694 + x1147*x2588 + x1149*x568 + x1153*x570 + x1156*x2589 + x1157*x2587 + x1158*x2609 + x1158*x2610 + x1158*x2611 - x1663 - x1664 + x1858*x563 + x1859*x567 + x2738*x943
    x2773 = x168*x633 + x170*x641 + x176*x639 + x620
    x2774 = x209*(-x1182*x630 - x1183*x626 - x1184*x622)
    x2775 = x163*x2774
    x2776 = x1334 + x264*x633 + x269*x639 + x275*x641
    x2777 = x2774*x292
    x2778 = x1677 + x349*x633 + x354*x641 + x359*x639
    x2779 = x2774*x370
    x2780 = x2012 + x402*x633 + x414*x641 + x423*x639
    x2781 = x2774*x451
    x2782 = x2333 + x473*x633 + x479*x639 + x486*x641
    x2783 = x2774*x510
    x2784 = x2604 + x531*x633 + x537*x641 + x542*x639
    x2785 = x2774*x561
    x2786 = x30**(mpmath.mpf(-5)/mpmath.mpf(2))
    x2787 = 3*o0
    x2788 = x2786*(-x2787 + x83)
    x2789 = x2788*x572
    x2790 = x215*x24
    x2791 = x2789*x2790
    x2792 = x2789*x28
    x2793 = x2792*x92
    x2794 = x213*x2792
    x2795 = x2789*x86
    x2796 = x24*x2795
    x2797 = x24*x578
    x2798 = x2797*x4
    x2799 = x24*x574
    x2800 = x16*x2799
    x2801 = x2798 - x2800
    x2802 = x28*x574
    x2803 = x2*x2802
    x2804 = x28*x578
    x2805 = x2804*x8
    x2806 = x2803 - x2805
    x2807 = x2801 + x2806
    x2808 = x1888*x2792
    x2809 = x25*x2795
    x2810 = x25*x2789
    x2811 = x215*x2810
    x2812 = x101*x2792
    x2813 = x16*x801
    x2814 = x4*x843
    x2815 = x2813 - x2814
    x2816 = x2804*x6
    x2817 = x13*x2802
    x2818 = x2816 - x2817
    x2819 = x2815 + x2818
    x2820 = x16*x575
    x2821 = 2*x2820
    x2822 = x4*x579
    x2823 = 2*x2822
    x2824 = -x2821 + x2823
    x2825 = x213*x2810
    x2826 = x24*x2789
    x2827 = x101*x2826
    x2828 = x1888*x2826
    x2829 = x2810*x92
    x2830 = x8*x843
    x2831 = x2*x801
    x2832 = x2830 - x2831
    x2833 = x13*x2799
    x2834 = x2797*x6
    x2835 = x2833 - x2834
    x2836 = x2832 + x2835
    x2837 = x579*x8
    x2838 = 2*x2837
    x2839 = x2*x575
    x2840 = 2*x2839
    x2841 = -x2838 + x2840
    x2842 = x13*x642
    x2843 = x2*x642
    x2844 = x16*x642
    x2845 = x2774*x631
    x2846 = -x2798 + x2800
    x2847 = -x2803 + x2805
    x2848 = x2846 + x2847
    x2849 = -x2830 + x2831
    x2850 = -x2833 + x2834
    x2851 = x2849 + x2850
    x2852 = x2838 - x2840
    x2853 = -x2813 + x2814
    x2854 = -x2816 + x2817
    x2855 = x2853 + x2854
    x2856 = x2821 - x2823
    x2857 = x586*x633 + x59*(-x2825 - x2827 + x2828 + x2829 + x2851 + x2852) + x596*x641 + x604*x639 + x69*(-x2808 - x2809 + x2811 + x2812 + x2855 + x2856) + x76*(-x2791 - x2793 + x2794 + x2796 + x2848)
    x2858 = x2788*x645
    x2859 = x2790*x2858
    x2860 = x28*x2858
    x2861 = x2860*x92
    x2862 = x213*x2860
    x2863 = x2858*x86
    x2864 = x24*x2863
    x2865 = x2820 - x2822
    x2866 = x1888*x2860
    x2867 = x25*x2863
    x2868 = x25*x2858
    x2869 = x215*x2868
    x2870 = x101*x2860
    x2871 = x4*x649
    x2872 = x16*x646
    x2873 = x2871 - x2872
    x2874 = x213*x2868
    x2875 = x24*x2858
    x2876 = x101*x2875
    x2877 = x1888*x2875
    x2878 = x2868*x92
    x2879 = x579*x6
    x2880 = x13*x575
    x2881 = x2879 - x2880
    x2882 = x2*x646
    x2883 = x649*x8
    x2884 = x2882 - x2883
    x2885 = x2881 + x2884
    x2886 = -x2871 + x2872
    x2887 = -x2820 + x2822
    x2888 = -x2879 + x2880
    x2889 = -x2882 + x2883
    x2890 = x2888 + x2889
    x2891 = x59*(-x2874 - x2876 + x2877 + x2878 + x2890) + x633*x656 + x639*x663 + x641*x671 + x69*(-x2866 - x2867 + x2869 + x2870 + x2886) + x76*(-x2859 - x2861 + x2862 + x2864 + x2887)
    x2892 = x2774*x694
    x2893 = x13*x633
    x2894 = x2*x639
    x2895 = x16*x641
    x2896 = x2842*x696 + x2843*x702 + x2844*x704 + x2893*x705 + x2894*x705 + x2895*x705
    x2897 = x2788*x708
    x2898 = x2790*x2897
    x2899 = x28*x2897
    x2900 = x2899*x92
    x2901 = x213*x2899
    x2902 = x2897*x86
    x2903 = x24*x2902
    x2904 = x2837 - x2839
    x2905 = x1888*x2899
    x2906 = x25*x2902
    x2907 = x25*x2897
    x2908 = x215*x2907
    x2909 = x101*x2899
    x2910 = x4*x712
    x2911 = x16*x709
    x2912 = x2910 - x2911
    x2913 = x2888 + x2912
    x2914 = x213*x2907
    x2915 = x24*x2897
    x2916 = x101*x2915
    x2917 = x1888*x2915
    x2918 = x2907*x92
    x2919 = x2*x709
    x2920 = x712*x8
    x2921 = x2919 - x2920
    x2922 = -x2919 + x2920
    x2923 = -x2837 + x2839
    x2924 = -x2910 + x2911
    x2925 = x2881 + x2924
    x2926 = x59*(-x2914 - x2916 + x2917 + x2918 + x2922) + x633*x719 + x639*x731 + x641*x726 + x69*(-x2905 - x2906 + x2908 + x2909 + x2925) + x76*(-x2898 - x2900 + x2901 + x2903 + x2923)
    x2927 = x2774*x750
    x2928 = x2842*x752 + x2843*x756 + x2844*x757 + x2893*x758 + x2894*x758 + x2895*x758
    x2929 = x25*x2788
    x2930 = x2790*x2929
    x2931 = x28*x2929
    x2932 = x2931*x92
    x2933 = x213*x2931
    x2934 = x24*x2929
    x2935 = x2934*x86
    x2936 = x606*x778
    x2937 = x606*x942
    x2938 = x2936 - x2937
    x2939 = x608*x944
    x2940 = x608*x782
    x2941 = x2939 - x2940
    x2942 = x2848 + x2938 + x2941
    x2943 = 2*o0
    x2944 = -x2943 + x762
    x2945 = x16*x574
    x2946 = x2943 + x763
    x2947 = x4*x578
    x2948 = x26*x2788
    x2949 = x2948*x86
    x2950 = x215*x2948
    x2951 = x1888*x2931
    x2952 = x101*x2931
    x2953 = x606*x936
    x2954 = x606*x795
    x2955 = x612*x782
    x2956 = x612*x944
    x2957 = x394*x6
    x2958 = x13*x33
    x2959 = x2957 - x2958
    x2960 = x2865 + x584 + x611
    x2961 = x2854 + x2953 - x2954 + x2955 - x2956 + x2959 + x2960
    x2962 = x2*x574
    x2963 = x578*x8
    x2964 = x213*x2948
    x2965 = x2948*x92
    x2966 = x101*x2934
    x2967 = x1888*x2934
    x2968 = x608*x795
    x2969 = x608*x936
    x2970 = x612*x942
    x2971 = x612*x778
    x2972 = x32*x765
    x2973 = x393*x777
    x2974 = x2972 - x2973
    x2975 = x2005 + x2904 + x582
    x2976 = x2850 + x2968 - x2969 + x2970 - x2971 + x2974 + x2975
    x2977 = (mpmath.mpf(1)/mpmath.mpf(2))*x577 + (mpmath.mpf(1)/mpmath.mpf(2))*x581 - mpmath.mpf(1)/mpmath.mpf(2)*x583 - mpmath.mpf(1)/mpmath.mpf(2)*x585
    x2978 = 2*x2937
    x2979 = 2*x2933
    x2980 = 2*x2940
    x2981 = 2*x2935
    x2982 = 2*x2939
    x2983 = 2*x2930
    x2984 = 2*x2936
    x2985 = 2*x2932
    x2986 = 2*x2803
    x2987 = 2*x2805
    x2988 = -x2986 + x2987
    x2989 = 2*x2798
    x2990 = 2*x2800
    x2991 = -x2989 + x2990
    x2992 = (mpmath.mpf(1)/mpmath.mpf(2))*x593
    x2993 = (mpmath.mpf(1)/mpmath.mpf(2))*x594
    x2994 = x2992 - x2993
    x2995 = x2994 + (mpmath.mpf(1)/mpmath.mpf(2))*x587 + (mpmath.mpf(1)/mpmath.mpf(2))*x589 - mpmath.mpf(1)/mpmath.mpf(2)*x591 - mpmath.mpf(1)/mpmath.mpf(2)*x592
    x2996 = (mpmath.mpf(1)/mpmath.mpf(2))*x601
    x2997 = (mpmath.mpf(1)/mpmath.mpf(2))*x602
    x2998 = x2996 - x2997
    x2999 = x2998 + (mpmath.mpf(1)/mpmath.mpf(2))*x597 + (mpmath.mpf(1)/mpmath.mpf(2))*x598 - mpmath.mpf(1)/mpmath.mpf(2)*x599 - mpmath.mpf(1)/mpmath.mpf(2)*x600
    x3000 = 4*o0
    x3001 = x3000 + x909
    x3002 = -x3000 + x908
    x3003 = 2*x580
    x3004 = 2*x582
    x3005 = 2*x2973
    x3006 = 2*x2972
    x3007 = -x3005 + x3006
    x3008 = 2*x2833
    x3009 = 2*x2834
    x3010 = -x3008 + x3009
    x3011 = 2*x576
    x3012 = 2*x584
    x3013 = 2*x2816
    x3014 = 2*x2817
    x3015 = -x3013 + x3014
    x3016 = 2*x2958
    x3017 = 2*x2957
    x3018 = -x3016 + x3017
    x3019 = x2977*x850 + x2995*x888 + x2999*x905 + x851*(-x2978 - x2979 - x2980 - x2981 + x2982 + x2983 + x2984 + x2985 + x2988 + x2991) + x906*(x2852 + x2962*x3001 + x2963*x3002 + 2*x2964 - 2*x2965 + 2*x2966 - 2*x2967 + 2*x2968 - 2*x2969 + 2*x2970 - 2*x2971 - x3003 + x3004 + x3007 + x3010) + x920*(x2856 + x2945*x3002 + x2947*x3001 + 2*x2949 - 2*x2950 + 2*x2951 - 2*x2952 + 2*x2953 - 2*x2954 + 2*x2955 - 2*x2956 - x3011 + x3012 + x3015 + x3018)
    x3020 = x2774*x930
    x3021 = x643*x69
    x3022 = x59*x643
    x3023 = x1858*x641 + x2842*x932 + x2843*x939 + x2844*x940 + x2893*x941 + x2894*x941 + x2895*x941 + x3021*x942 + x3022*x944 + x633*x934 - x634 - x635 + x639*x938 + x643*x937
    x3024 = x27*x2788
    x3025 = x215*x3024
    x3026 = x3024*x86
    x3027 = x2788*x959
    x3028 = x3027*x92
    x3029 = x213*x3027
    x3030 = x606*x955
    x3031 = x1060*x606
    x3032 = x1071*x608
    x3033 = x608*x957
    x3034 = x2015 + x2887 + x576
    x3035 = x3030 - x3031 + x3032 - x3033 + x3034
    x3036 = x1888*x3027
    x3037 = x101*x3027
    x3038 = -x2936 + x2937
    x3039 = x612*x957
    x3040 = x1071*x612
    x3041 = x394*x8
    x3042 = x2*x33
    x3043 = x3041 - x3042
    x3044 = x3039 - x3040 + x3043
    x3045 = x2801 + x3038 + x3044
    x3046 = x101*x3024
    x3047 = x1888*x3024
    x3048 = x213*x2934
    x3049 = x2934*x92
    x3050 = x1060*x612
    x3051 = x612*x955
    x3052 = x608*x778
    x3053 = x608*x942
    x3054 = x2*x2799
    x3055 = x2797*x8
    x3056 = x1010 - x1017 + x3054 - x3055
    x3057 = x50 + x700
    x3058 = x1328 + x2888 + x3057 + x588
    x3059 = x3050 - x3051 + x3052 - x3053 + x3056 + x3058
    x3060 = 2*x3040
    x3061 = 2*x3037
    x3062 = 2*x3036
    x3063 = 2*x3039
    x3064 = 2*x3042
    x3065 = 2*x3041
    x3066 = -x3064 + x3065
    x3067 = x2989 - x2990
    x3068 = 2*x590
    x3069 = 2*x2879
    x3070 = 2*x2880
    x3071 = 2*x588
    x3072 = x1134 + x2184
    x3073 = 2*x1017
    x3074 = 2*x1010
    x3075 = 2*x3055
    x3076 = 2*x3054
    x3077 = -x3073 + x3074 - x3075 + x3076
    x3078 = x1001*x2999 + x1024*x2977 + x1035*x2995 + x851*(x2824 + x3011 - x3012 + 2*x3025 - 2*x3026 + 2*x3028 - 2*x3029 + 2*x3030 - 2*x3031 + 2*x3032 - 2*x3033) + x906*(2*x3046 - 2*x3047 + 2*x3048 - 2*x3049 + 2*x3050 - 2*x3051 + 2*x3052 - 2*x3053 - x3068 - x3069 + x3070 + x3071 + x3072 + x3077) + x920*(x2978 + x2981 - x2983 - x2984 - x3060 - x3061 + x3062 + x3063 + x3066 + x3067)
    x3079 = x1051*x2774
    x3080 = x189*x643
    x3081 = x1055*x2842 + x1057*x639 + x1061*x643 + x1064*x2843 + x1067*x2844 + x1068*x2893 + x1068*x2894 + x1068*x2895 + x1069*x3080 + x1071*x3022 - x1337 - x1338 + x1859*x641 + x633*x938
    x3082 = x2788*x29
    x3083 = x3082*x92
    x3084 = x213*x3082
    x3085 = x215*x3027
    x3086 = x3027*x86
    x3087 = x1152*x608
    x3088 = x1078*x608
    x3089 = x606*x957
    x3090 = x1071*x606
    x3091 = x2923 + x580 + x637
    x3092 = x3087 - x3088 + x3089 - x3090 + x3091
    x3093 = x1888*x3082
    x3094 = x101*x3082
    x3095 = x2931*x86
    x3096 = x215*x2931
    x3097 = x1078*x612
    x3098 = x1152*x612
    x3099 = x606*x944
    x3100 = x606*x782
    x3101 = x2804*x4
    x3102 = x16*x2802
    x3103 = x1110 - x1113 + x3101 - x3102
    x3104 = x2025 + x47
    x3105 = x2336 + x2881 + x3104 + x590
    x3106 = x3097 - x3098 + x3099 - x3100 + x3103 + x3105
    x3107 = -x2939 + x2940
    x3108 = -x3041 + x3042
    x3109 = -x3039 + x3040 + x3108
    x3110 = x2806 + x3107 + x3109
    x3111 = x3064 - x3065
    x3112 = x2986 - x2987
    x3113 = x1042 + x2185
    x3114 = 2*x1113
    x3115 = 2*x1110
    x3116 = 2*x3102
    x3117 = 2*x3101
    x3118 = -x3114 + x3115 - x3116 + x3117
    x3119 = x1105*x2995 + x1122*x2977 + x1133*x2999 + x851*(x2841 + x3003 - x3004 + 2*x3083 - 2*x3084 + 2*x3085 - 2*x3086 + 2*x3087 - 2*x3088 + 2*x3089 - 2*x3090) + x906*(x2979 + x2980 - x2982 - x2985 + x3060 + x3061 - x3062 - x3063 + x3111 + x3112) + x920*(x3068 + x3069 - x3070 - x3071 + 2*x3093 - 2*x3094 + 2*x3095 - 2*x3096 + 2*x3097 - 2*x3098 + 2*x3099 - 2*x3100 + x3113 + x3118)
    x3120 = x1142*x2774
    x3121 = x1071*x3021 + x1147*x2842 + x1149*x641 + x1153*x643 + x1156*x2843 + x1157*x2844 + x1158*x2893 + x1158*x2894 + x1158*x2895 - x1680 - x1681 + x1858*x633 + x1859*x639 + x3080*x943
    x3122 = x168*x696 + x170*x704 + x176*x702 + x685
    x3123 = x209*(-x1182*x687 - x1183*x691 - x1184*x693)
    x3124 = x163*x3123
    x3125 = x1350 + x264*x696 + x269*x702 + x275*x704
    x3126 = x292*x3123
    x3127 = x1691 + x349*x696 + x354*x704 + x359*x702
    x3128 = x3123*x370
    x3129 = x2028 + x402*x696 + x414*x704 + x423*x702
    x3130 = x3123*x451
    x3131 = x2347 + x473*x696 + x479*x702 + x486*x704
    x3132 = x3123*x510
    x3133 = x2621 + x531*x696 + x537*x704 + x542*x702
    x3134 = x3123*x561
    x3135 = 3*o1
    x3136 = x2786*(x1162 - x3135)
    x3137 = x3136*x572
    x3138 = x2790*x3137
    x3139 = x28*x3137
    x3140 = x3139*x92
    x3141 = x213*x3139
    x3142 = x3137*x86
    x3143 = x24*x3142
    x3144 = x1888*x3139
    x3145 = x25*x3142
    x3146 = x25*x3137
    x3147 = x215*x3146
    x3148 = x101*x3139
    x3149 = x213*x3146
    x3150 = x24*x3137
    x3151 = x101*x3150
    x3152 = x1888*x3150
    x3153 = x3146*x92
    x3154 = x586*x696 + x59*(x2890 - x3149 - x3151 + x3152 + x3153) + x596*x704 + x604*x702 + x69*(x2886 - x3144 - x3145 + x3147 + x3148) + x76*(x2887 - x3138 - x3140 + x3141 + x3143)
    x3155 = x3123*x631
    x3156 = x3136*x645
    x3157 = x28*x3156
    x3158 = x1888*x3157
    x3159 = x3156*x86
    x3160 = x25*x3159
    x3161 = x25*x3156
    x3162 = x215*x3161
    x3163 = x101*x3157
    x3164 = x2790*x3156
    x3165 = x3157*x92
    x3166 = x213*x3157
    x3167 = x24*x3159
    x3168 = 2*x2871
    x3169 = 2*x2872
    x3170 = -x3168 + x3169
    x3171 = x213*x3161
    x3172 = x24*x3156
    x3173 = x101*x3172
    x3174 = x1888*x3172
    x3175 = x3161*x92
    x3176 = x13*x646
    x3177 = 2*x3176
    x3178 = x6*x649
    x3179 = 2*x3178
    x3180 = -x3177 + x3179
    x3181 = x2*x702
    x3182 = 2*x705
    x3183 = x13*x696
    x3184 = x16*x704
    x3185 = x3123*x694
    x3186 = x3177 - x3179
    x3187 = x3168 - x3169
    x3188 = x59*(x2851 - x3171 - x3173 + x3174 + x3175 + x3186) + x656*x696 + x663*x702 + x671*x704 + x69*(x2855 - x3158 - x3160 + x3162 + x3163) + x76*(x2848 - x3164 - x3165 + x3166 + x3167 + x3187)
    x3189 = x3136*x708
    x3190 = x2790*x3189
    x3191 = x28*x3189
    x3192 = x3191*x92
    x3193 = x213*x3191
    x3194 = x3189*x86
    x3195 = x24*x3194
    x3196 = x2889 + x2924
    x3197 = x1888*x3191
    x3198 = x25*x3194
    x3199 = x25*x3189
    x3200 = x215*x3199
    x3201 = x101*x3191
    x3202 = x3176 - x3178
    x3203 = x213*x3199
    x3204 = x24*x3189
    x3205 = x101*x3204
    x3206 = x1888*x3204
    x3207 = x3199*x92
    x3208 = x6*x712
    x3209 = x13*x709
    x3210 = x3208 - x3209
    x3211 = -x3208 + x3209
    x3212 = -x3176 + x3178
    x3213 = x2884 + x2912
    x3214 = x59*(-x3203 - x3205 + x3206 + x3207 + x3211) + x69*(-x3197 - x3198 + x3200 + x3201 + x3212) + x696*x719 + x702*x731 + x704*x726 + x76*(-x3190 - x3192 + x3193 + x3195 + x3213)
    x3215 = x3123*x750
    x3216 = x13*x705
    x3217 = x2*x705
    x3218 = x16*x705
    x3219 = x3181*x758 + x3183*x758 + x3184*x758 + x3216*x752 + x3217*x756 + x3218*x757
    x3220 = x25*x3136
    x3221 = x2790*x3220
    x3222 = x28*x3220
    x3223 = x3222*x92
    x3224 = x213*x3222
    x3225 = x24*x3220
    x3226 = x3225*x86
    x3227 = x673*x778
    x3228 = x673*x942
    x3229 = x3227 - x3228
    x3230 = x675*x944
    x3231 = x675*x782
    x3232 = -x2957 + x2958
    x3233 = x3230 - x3231 + x3232
    x3234 = x2815 + x3229 + x3233
    x3235 = x26*x3136
    x3236 = x3235*x86
    x3237 = x215*x3235
    x3238 = x1888*x3222
    x3239 = x101*x3222
    x3240 = x673*x936
    x3241 = x673*x795
    x3242 = x678*x782
    x3243 = x678*x944
    x3244 = x2886 + x654 + x677
    x3245 = x3240 - x3241 + x3242 - x3243 + x3244
    x3246 = x213*x3235
    x3247 = x3235*x92
    x3248 = x101*x3225
    x3249 = x1888*x3225
    x3250 = x675*x795
    x3251 = x675*x936
    x3252 = x678*x942
    x3253 = x678*x778
    x3254 = x2022 + x2889 + x3104 + x652
    x3255 = x6*x843
    x3256 = x13*x801
    x3257 = x3255 - x3256 - x870 + x878
    x3258 = x3250 - x3251 + x3252 - x3253 + x3254 + x3257
    x3259 = -x2996 + x2997
    x3260 = x3259 + (mpmath.mpf(1)/mpmath.mpf(2))*x648 + (mpmath.mpf(1)/mpmath.mpf(2))*x651 - mpmath.mpf(1)/mpmath.mpf(2)*x653 - mpmath.mpf(1)/mpmath.mpf(2)*x655
    x3261 = 2*x647
    x3262 = 2*x654
    x3263 = 2*x3228
    x3264 = 2*x3224
    x3265 = 2*x3231
    x3266 = 2*x3226
    x3267 = 2*x3230
    x3268 = 2*x3221
    x3269 = 2*x3227
    x3270 = 2*x3223
    x3271 = x3016 - x3017
    x3272 = 2*x2814
    x3273 = 2*x2813
    x3274 = -x3272 + x3273
    x3275 = (mpmath.mpf(1)/mpmath.mpf(2))*x658 + (mpmath.mpf(1)/mpmath.mpf(2))*x659 - mpmath.mpf(1)/mpmath.mpf(2)*x660 - mpmath.mpf(1)/mpmath.mpf(2)*x662
    x3276 = (mpmath.mpf(1)/mpmath.mpf(2))*x668
    x3277 = (mpmath.mpf(1)/mpmath.mpf(2))*x669
    x3278 = x3276 - x3277
    x3279 = x3278 + (mpmath.mpf(1)/mpmath.mpf(2))*x664 + (mpmath.mpf(1)/mpmath.mpf(2))*x665 - mpmath.mpf(1)/mpmath.mpf(2)*x666 - mpmath.mpf(1)/mpmath.mpf(2)*x667
    x3280 = 2*x2882
    x3281 = 2*x650
    x3282 = 2*x652
    x3283 = 2*x2883
    x3284 = 2*x870
    x3285 = 2*x878
    x3286 = 2*x3256
    x3287 = 2*x3255
    x3288 = -x3284 + x3285 - x3286 + x3287
    x3289 = x3260*x850 + x3275*x905 + x3279*x888 + x851*(-x3263 - x3264 - x3265 - x3266 + x3267 + x3268 + x3269 + x3270 + x3271 + x3274) + x906*(x3113 + 2*x3246 - 2*x3247 + 2*x3248 - 2*x3249 + 2*x3250 - 2*x3251 + 2*x3252 - 2*x3253 - x3280 - x3281 + x3282 + x3283 + x3288) + x920*(x3170 + 2*x3236 - 2*x3237 + 2*x3238 - 2*x3239 + 2*x3240 - 2*x3241 + 2*x3242 - 2*x3243 - x3261 + x3262)
    x3290 = x3123*x930
    x3291 = x69*x706
    x3292 = x59*x706
    x3293 = x1858*x704 + x3181*x941 + x3183*x941 + x3184*x941 + x3216*x932 + x3217*x939 + x3218*x940 + x3291*x942 + x3292*x944 + x696*x934 - x697 - x698 + x702*x938 + x706*x937
    x3294 = 2*o1
    x3295 = x1447 + x3294
    x3296 = x1446 - x3294
    x3297 = x27*x3136
    x3298 = x215*x3297
    x3299 = x3297*x86
    x3300 = x3136*x959
    x3301 = x3300*x92
    x3302 = x213*x3300
    x3303 = x673*x955
    x3304 = x1060*x673
    x3305 = x1071*x675
    x3306 = x675*x957
    x3307 = x2031 + x2873 + x647
    x3308 = x2847 + x3108 + x3303 - x3304 + x3305 - x3306 + x3307
    x3309 = x1888*x3300
    x3310 = x101*x3300
    x3311 = -x3227 + x3228
    x3312 = x678*x957
    x3313 = x1071*x678
    x3314 = x3312 - x3313
    x3315 = x2855 + x3311 + x3314
    x3316 = x13*x574
    x3317 = x578*x6
    x3318 = x101*x3297
    x3319 = x1888*x3297
    x3320 = x213*x3225
    x3321 = x3225*x92
    x3322 = x1060*x678
    x3323 = x678*x955
    x3324 = x675*x778
    x3325 = x675*x942
    x3326 = -x2972 + x2973
    x3327 = x1345 + x3202 + x661
    x3328 = x2849 + x3322 - x3323 + x3324 - x3325 + x3326 + x3327
    x3329 = 2*x3313
    x3330 = 2*x3310
    x3331 = 2*x3309
    x3332 = 2*x3312
    x3333 = x3272 - x3273
    x3334 = 4*o1
    x3335 = x1486 - x3334
    x3336 = x1488 + x3334
    x3337 = 2*x657
    x3338 = 2*x661
    x3339 = x3005 - x3006
    x3340 = 2*x2830
    x3341 = 2*x2831
    x3342 = -x3340 + x3341
    x3343 = x1001*x3275 + x1024*x3260 + x1035*x3279 + x851*(x2945*x3336 + x2947*x3335 + x2988 + x3111 + x3187 + x3261 - x3262 + 2*x3298 - 2*x3299 + 2*x3301 - 2*x3302 + 2*x3303 - 2*x3304 + 2*x3305 - 2*x3306) + x906*(x3186 + x3316*x3335 + x3317*x3336 + 2*x3318 - 2*x3319 + 2*x3320 - 2*x3321 + 2*x3322 - 2*x3323 + 2*x3324 - 2*x3325 - x3337 + x3338 + x3339 + x3342) + x920*(x3015 + x3263 + x3266 - x3268 - x3269 - x3329 - x3330 + x3331 + x3332 + x3333)
    x3344 = x1051*x3123
    x3345 = x189*x706
    x3346 = x1055*x3216 + x1057*x702 + x1061*x706 + x1064*x3217 + x1067*x3218 + x1068*x3181 + x1068*x3183 + x1068*x3184 + x1069*x3345 + x1071*x3292 - x1353 - x1354 + x1859*x704 + x696*x938
    x3347 = x29*x3136
    x3348 = x3347*x92
    x3349 = x213*x3347
    x3350 = x215*x3300
    x3351 = x3300*x86
    x3352 = x1152*x675
    x3353 = x1078*x675
    x3354 = x673*x957
    x3355 = x1071*x673
    x3356 = x2884 + x3057 + x650 + x699
    x3357 = -x1110 + x1113 - x3101 + x3102
    x3358 = x3352 - x3353 + x3354 - x3355 + x3356 + x3357
    x3359 = x1888*x3347
    x3360 = x101*x3347
    x3361 = x3222*x86
    x3362 = x215*x3222
    x3363 = x1078*x678
    x3364 = x1152*x678
    x3365 = x673*x944
    x3366 = x673*x782
    x3367 = x2350 + x3212 + x657
    x3368 = x3363 - x3364 + x3365 - x3366 + x3367
    x3369 = -x3312 + x3313
    x3370 = x2959 - x3230 + x3231
    x3371 = x2818 + x3369 + x3370
    x3372 = x3013 - x3014
    x3373 = x3114 - x3115 + x3116 - x3117
    x3374 = x1105*x3279 + x1122*x3260 + x1133*x3275 + x851*(x3072 + x3280 + x3281 - x3282 - x3283 + 2*x3348 - 2*x3349 + 2*x3350 - 2*x3351 + 2*x3352 - 2*x3353 + 2*x3354 - 2*x3355 + x3373) + x906*(x3018 + x3264 + x3265 - x3267 - x3270 + x3329 + x3330 - x3331 - x3332 + x3372) + x920*(x3180 + x3337 - x3338 + 2*x3359 - 2*x3360 + 2*x3361 - 2*x3362 + 2*x3363 - 2*x3364 + 2*x3365 - 2*x3366)
    x3375 = x1142*x3123
    x3376 = x1071*x3291 + x1147*x3216 + x1149*x704 + x1153*x706 + x1156*x3217 + x1157*x3218 + x1158*x3181 + x1158*x3183 + x1158*x3184 - x1694 - x1695 + x1858*x696 + x1859*x702 + x3345*x943
    x3377 = x168*x752 + x170*x757 + x176*x756 + x743
    x3378 = x209*(-x1182*x747 - x1183*x745 - x1184*x749)
    x3379 = x163*x3378
    x3380 = x1364 + x264*x752 + x269*x756 + x275*x757
    x3381 = x292*x3378
    x3382 = x1704 + x349*x752 + x354*x757 + x359*x756
    x3383 = x3378*x370
    x3384 = x2041 + x402*x752 + x414*x757 + x423*x756
    x3385 = x3378*x451
    x3386 = x2358 + x473*x752 + x479*x756 + x486*x757
    x3387 = x3378*x510
    x3388 = x2631 + x531*x752 + x537*x757 + x542*x756
    x3389 = x3378*x561
    x3390 = 3*o2
    x3391 = x2786*(x1535 - x3390)
    x3392 = x3391*x572
    x3393 = x2790*x3392
    x3394 = x28*x3392
    x3395 = x3394*x92
    x3396 = x213*x3394
    x3397 = x3392*x86
    x3398 = x24*x3397
    x3399 = x1888*x3394
    x3400 = x25*x3397
    x3401 = x25*x3392
    x3402 = x215*x3401
    x3403 = x101*x3394
    x3404 = x213*x3401
    x3405 = x24*x3392
    x3406 = x101*x3405
    x3407 = x1888*x3405
    x3408 = x3401*x92
    x3409 = x586*x752 + x59*(x2922 - x3404 - x3406 + x3407 + x3408) + x596*x757 + x604*x756 + x69*(x2925 - x3399 - x3400 + x3402 + x3403) + x76*(x2923 - x3393 - x3395 + x3396 + x3398)
    x3410 = x3378*x631
    x3411 = x3391*x645
    x3412 = x2790*x3411
    x3413 = x28*x3411
    x3414 = x3413*x92
    x3415 = x213*x3413
    x3416 = x3411*x86
    x3417 = x24*x3416
    x3418 = x1888*x3413
    x3419 = x25*x3416
    x3420 = x25*x3411
    x3421 = x215*x3420
    x3422 = x101*x3413
    x3423 = x213*x3420
    x3424 = x24*x3411
    x3425 = x101*x3424
    x3426 = x1888*x3424
    x3427 = x3420*x92
    x3428 = x59*(x3211 - x3423 - x3425 + x3426 + x3427) + x656*x752 + x663*x756 + x671*x757 + x69*(x3212 - x3418 - x3419 + x3421 + x3422) + x76*(x3213 - x3412 - x3414 + x3415 + x3417)
    x3429 = x3378*x694
    x3430 = x3391*x708
    x3431 = x25*x3430
    x3432 = x213*x3431
    x3433 = x24*x3430
    x3434 = x101*x3433
    x3435 = x1888*x3433
    x3436 = x3431*x92
    x3437 = x2790*x3430
    x3438 = x28*x3430
    x3439 = x3438*x92
    x3440 = x213*x3438
    x3441 = x3430*x86
    x3442 = x24*x3441
    x3443 = 2*x2919
    x3444 = 2*x2920
    x3445 = -x3443 + x3444
    x3446 = x1888*x3438
    x3447 = x25*x3441
    x3448 = x215*x3431
    x3449 = x101*x3438
    x3450 = 2*x3208
    x3451 = 2*x3209
    x3452 = -x3450 + x3451
    x3453 = x16*x758
    x3454 = x13*x758
    x3455 = x2*x758
    x3456 = x3378*x750
    x3457 = x3450 - x3451
    x3458 = x3443 - x3444
    x3459 = x59*(x2851 - x3432 - x3434 + x3435 + x3436) + x69*(x2855 - x3446 - x3447 + x3448 + x3449 + x3457) + x719*x752 + x726*x757 + x731*x756 + x76*(x2848 - x3437 - x3439 + x3440 + x3442 + x3458)
    x3460 = x25*x3391
    x3461 = x2790*x3460
    x3462 = x28*x3460
    x3463 = x3462*x92
    x3464 = x213*x3462
    x3465 = x24*x3460
    x3466 = x3465*x86
    x3467 = x735*x944
    x3468 = x735*x782
    x3469 = x3467 - x3468
    x3470 = x733*x778
    x3471 = x733*x942
    x3472 = x3326 + x3470 - x3471
    x3473 = x2832 + x3469 + x3472
    x3474 = x26*x3391
    x3475 = x3474*x86
    x3476 = x215*x3474
    x3477 = x1888*x3462
    x3478 = x101*x3462
    x3479 = x733*x936
    x3480 = x733*x795
    x3481 = x738*x782
    x3482 = x738*x944
    x3483 = -x3255 + x3256 + x870 - x878
    x3484 = x2924 + x3057 + x717 + x740
    x3485 = x3479 - x3480 + x3481 - x3482 + x3483 + x3484
    x3486 = x213*x3474
    x3487 = x3474*x92
    x3488 = x101*x3465
    x3489 = x1888*x3465
    x3490 = x735*x795
    x3491 = x735*x936
    x3492 = x738*x942
    x3493 = x738*x778
    x3494 = x2036 + x2922 + x715
    x3495 = x3490 - x3491 + x3492 - x3493 + x3494
    x3496 = -x2992 + x2993
    x3497 = x3496 + (mpmath.mpf(1)/mpmath.mpf(2))*x711 + (mpmath.mpf(1)/mpmath.mpf(2))*x714 - mpmath.mpf(1)/mpmath.mpf(2)*x716 - mpmath.mpf(1)/mpmath.mpf(2)*x718
    x3498 = 2*x713
    x3499 = 2*x715
    x3500 = 2*x3471
    x3501 = 2*x3464
    x3502 = 2*x3468
    x3503 = 2*x3466
    x3504 = 2*x3467
    x3505 = 2*x3461
    x3506 = 2*x3470
    x3507 = 2*x3463
    x3508 = x3340 - x3341
    x3509 = (mpmath.mpf(1)/mpmath.mpf(2))*x720 + (mpmath.mpf(1)/mpmath.mpf(2))*x722 - mpmath.mpf(1)/mpmath.mpf(2)*x724 - mpmath.mpf(1)/mpmath.mpf(2)*x725
    x3510 = -x3276 + x3277
    x3511 = x3510 + (mpmath.mpf(1)/mpmath.mpf(2))*x727 + (mpmath.mpf(1)/mpmath.mpf(2))*x728 - mpmath.mpf(1)/mpmath.mpf(2)*x729 - mpmath.mpf(1)/mpmath.mpf(2)*x730
    x3512 = 2*x710
    x3513 = 2*x2910
    x3514 = 2*x2911
    x3515 = 2*x717
    x3516 = x3284 - x3285 + x3286 - x3287
    x3517 = x3497*x850 + x3509*x888 + x3511*x905 + x851*(x3339 - x3500 - x3501 - x3502 - x3503 + x3504 + x3505 + x3506 + x3507 + x3508) + x906*(x3445 + 2*x3486 - 2*x3487 + 2*x3488 - 2*x3489 + 2*x3490 - 2*x3491 + 2*x3492 - 2*x3493 - x3498 + x3499) + x920*(x3072 + 2*x3475 - 2*x3476 + 2*x3477 - 2*x3478 + 2*x3479 - 2*x3480 + 2*x3481 - 2*x3482 - x3512 - x3513 + x3514 + x3515 + x3516)
    x3518 = x3378*x930
    x3519 = x13*x752
    x3520 = x2*x756
    x3521 = x16*x757
    x3522 = x69*x759
    x3523 = x59*x759
    x3524 = x1858*x757 + x3453*x940 + x3454*x932 + x3455*x939 + x3519*x941 + x3520*x941 + x3521*x941 + x3522*x942 + x3523*x944 + x752*x934 - x753 - x754 + x756*x938 + x759*x937
    x3525 = x27*x3391
    x3526 = x215*x3525
    x3527 = x3525*x86
    x3528 = x3391*x959
    x3529 = x3528*x92
    x3530 = x213*x3528
    x3531 = x733*x955
    x3532 = x1060*x733
    x3533 = x1071*x735
    x3534 = x735*x957
    x3535 = x2044 + x2912 + x3104 + x710
    x3536 = -x1010 + x1017 - x3054 + x3055
    x3537 = x3531 - x3532 + x3533 - x3534 + x3535 + x3536
    x3538 = x1888*x3528
    x3539 = x101*x3528
    x3540 = x738*x957
    x3541 = x1071*x738
    x3542 = x3540 - x3541
    x3543 = x2974 - x3470 + x3471
    x3544 = x2835 + x3542 + x3543
    x3545 = x101*x3525
    x3546 = x1888*x3525
    x3547 = x213*x3465
    x3548 = x3465*x92
    x3549 = x1060*x738
    x3550 = x738*x955
    x3551 = x735*x778
    x3552 = x735*x942
    x3553 = x1359 + x3211 + x721
    x3554 = x3549 - x3550 + x3551 - x3552 + x3553
    x3555 = 2*x723
    x3556 = 2*x721
    x3557 = 2*x3541
    x3558 = 2*x3539
    x3559 = 2*x3538
    x3560 = 2*x3540
    x3561 = x3008 - x3009
    x3562 = x3073 - x3074 + x3075 - x3076
    x3563 = x1001*x3511 + x1024*x3497 + x1035*x3509 + x851*(x3113 + x3512 + x3513 - x3514 - x3515 + 2*x3526 - 2*x3527 + 2*x3529 - 2*x3530 + 2*x3531 - 2*x3532 + 2*x3533 - 2*x3534 + x3562) + x906*(x3452 + 2*x3545 - 2*x3546 + 2*x3547 - 2*x3548 + 2*x3549 - 2*x3550 + 2*x3551 - 2*x3552 - x3555 + x3556) + x920*(x3007 + x3500 + x3503 - x3505 - x3506 - x3557 - x3558 + x3559 + x3560 + x3561)
    x3564 = x1051*x3378
    x3565 = x189*x759
    x3566 = x1055*x3454 + x1057*x756 + x1061*x759 + x1064*x3455 + x1067*x3453 + x1068*x3519 + x1068*x3520 + x1068*x3521 + x1069*x3565 + x1071*x3523 - x1367 - x1368 + x1859*x757 + x752*x938
    x3567 = 2*o2
    x3568 = x1821 - x3567
    x3569 = x1822 + x3567
    x3570 = x29*x3391
    x3571 = x3570*x92
    x3572 = x213*x3570
    x3573 = x215*x3528
    x3574 = x3528*x86
    x3575 = x1152*x735
    x3576 = x1078*x735
    x3577 = x733*x957
    x3578 = x1071*x733
    x3579 = x2921 + x713 + x755
    x3580 = x2846 + x3043 + x3575 - x3576 + x3577 - x3578 + x3579
    x3581 = x1888*x3570
    x3582 = x101*x3570
    x3583 = x3462*x86
    x3584 = x215*x3462
    x3585 = x1078*x738
    x3586 = x1152*x738
    x3587 = x733*x944
    x3588 = x733*x782
    x3589 = x2361 + x3210 + x723
    x3590 = x2853 + x3232 + x3585 - x3586 + x3587 - x3588 + x3589
    x3591 = -x3467 + x3468
    x3592 = -x3540 + x3541
    x3593 = x2851 + x3591 + x3592
    x3594 = 4*o2
    x3595 = x1851 + x3594
    x3596 = x1850 - x3594
    x3597 = x1105*x3509 + x1122*x3497 + x1133*x3511 + x851*(x2962*x3596 + x2963*x3595 + x2991 + x3066 + x3458 + x3498 - x3499 + 2*x3571 - 2*x3572 + 2*x3573 - 2*x3574 + 2*x3575 - 2*x3576 + 2*x3577 - 2*x3578) + x906*(x3010 + x3342 + x3501 + x3502 - x3504 - x3507 + x3557 + x3558 - x3559 - x3560) + x920*(x3271 + x3316*x3595 + x3317*x3596 + x3333 + x3457 + x3555 - x3556 + 2*x3581 - 2*x3582 + 2*x3583 - 2*x3584 + 2*x3585 - 2*x3586 + 2*x3587 - 2*x3588)
    x3598 = x1142*x3378
    x3599 = x1071*x3522 + x1147*x3454 + x1149*x757 + x1153*x759 + x1156*x3455 + x1157*x3453 + x1158*x3519 + x1158*x3520 + x1158*x3521 - x1707 - x1708 + x1858*x752 + x1859*x756 + x3565*x943
    x3600 = -x83
    x3601 = x81*(x3600 + x82)
    x3602 = x0*x3601
    x3603 = x3602*x87
    x3604 = x16*x3602
    x3605 = x3604*x89
    x3606 = x3604*x92
    x3607 = x3602*x94
    x3608 = x2*x3607
    x3609 = x101*x3604
    x3610 = x13*x3607
    x3611 = x13*x3602
    x3612 = x3611*x86
    x3613 = x106*x3604
    x3614 = x3611*x92
    x3615 = x2*x3602
    x3616 = x106*x3615
    x3617 = x101*x3615
    x3618 = x3602*x769
    x3619 = x168*x932 + x170*x940 + x176*x939 + x59*(x1084 + x135 + x1477 + x1758 - x3614 - x3616 + x3617 + x3618 - x812 + x813 - x814 + x815) + x69*(x113 + x1382 + x1424 - x3609 - x3610 + x3612 + x3613 - x796 + x798 - x799 + x800 + x962) + x76*(x1101 - x3603 - x3605 + x3606 + x3608 + x966 + x99)
    x3620 = x209*(-x1182*x905 - x1183*x888 - x1184*x850)
    x3621 = x163*x3620
    x3622 = x231*x3601
    x3623 = x3622*x87
    x3624 = x16*x3622
    x3625 = x3624*x89
    x3626 = x3624*x92
    x3627 = x3622*x94
    x3628 = x2*x3627
    x3629 = x101*x3624
    x3630 = x13*x3627
    x3631 = x13*x3622
    x3632 = x3631*x86
    x3633 = x106*x3624
    x3634 = x3631*x92
    x3635 = x2*x3622
    x3636 = x106*x3635
    x3637 = x101*x3635
    x3638 = x3622*x769
    x3639 = x264*x932 + x269*x939 + x275*x940 + x59*(-x1400 + x1401 - x1402 + x1403 + x1510 + x1734 - x3634 - x3636 + x3637 + x3638) + x69*(-x1390 + x1391 - x1392 + x1393 + x1460 - x3629 - x3630 + x3632 + x3633) + x76*(x1464 + x1524 + x184 - x3623 - x3625 + x3626 + x3628)
    x3640 = x292*x3620
    x3641 = x319*x3601
    x3642 = x3641*x87
    x3643 = x16*x3641
    x3644 = x3643*x89
    x3645 = x3643*x92
    x3646 = x3641*x94
    x3647 = x2*x3646
    x3648 = x101*x3643
    x3649 = x13*x3646
    x3650 = x13*x3641
    x3651 = x3650*x86
    x3652 = x106*x3643
    x3653 = x3650*x92
    x3654 = x2*x3641
    x3655 = x106*x3654
    x3656 = x101*x3654
    x3657 = x3641*x769
    x3658 = x349*x932 + x354*x940 + x359*x939 + x59*(-x1740 + x1741 - x1742 + x1743 + x1834 - x3653 - x3655 + x3656 + x3657) + x69*(x1407 - x1729 + x1730 - x1731 + x1732 + x1785 - x3648 - x3649 + x3651 + x3652) + x76*(x1793 + x180 + x1846 - x3642 - x3644 + x3645 + x3647)
    x3659 = x3620*x370
    x3660 = x1868*(x1869 + x3600)
    x3661 = x3660*x387
    x3662 = x1872*x3661
    x3663 = x3661*x8
    x3664 = x3663*x94
    x3665 = x215*x3663
    x3666 = x3661*x4
    x3667 = x3666*x89
    x3668 = x3661*x6
    x3669 = x215*x3668
    x3670 = x106*x3666
    x3671 = x1888*x3666
    x3672 = x3668*x94
    x3673 = x1888*x3663
    x3674 = x3668*x89
    x3675 = x213*x3668
    x3676 = x106*x3663
    x3677 = x402*x932 + x414*x940 + x423*x939 + x59*(x1908 - x2082 + x2083 - x2084 + x2085 + x2205 + x2469 + x2683 - x3673 - x3674 + x3675 + x3676) + x69*(x1894 - x2069 + x2070 - x2071 + x2072 + x2148 + x2375 + x2417 - x3669 - x3670 + x3671 + x3672) + x76*(x1884 + x2152 + x2219 - x3662 - x3664 + x3665 + x3667)
    x3678 = x3620*x451
    x3679 = x3660*x465
    x3680 = x1872*x3679
    x3681 = x3679*x8
    x3682 = x3681*x94
    x3683 = x215*x3681
    x3684 = x3679*x4
    x3685 = x3684*x89
    x3686 = x3679*x6
    x3687 = x215*x3686
    x3688 = x106*x3684
    x3689 = x1888*x3684
    x3690 = x3686*x94
    x3691 = x1888*x3681
    x3692 = x3686*x89
    x3693 = x213*x3686
    x3694 = x106*x3681
    x3695 = x473*x932 + x479*x939 + x486*x940 + x59*(-x2393 + x2394 - x2395 + x2396 + x2499 + x2658 - x3691 - x3692 + x3693 + x3694) + x69*(-x2383 + x2384 - x2385 + x2386 + x2451 - x3687 - x3688 + x3689 + x3690) + x76*(x1927 + x2455 + x2513 - x3680 - x3682 + x3683 + x3685)
    x3696 = x3620*x510
    x3697 = x3660*x523
    x3698 = x1872*x3697
    x3699 = x3697*x8
    x3700 = x3699*x94
    x3701 = x215*x3699
    x3702 = x3697*x4
    x3703 = x3702*x89
    x3704 = x3697*x6
    x3705 = x215*x3704
    x3706 = x106*x3702
    x3707 = x1888*x3702
    x3708 = x3704*x94
    x3709 = x1888*x3699
    x3710 = x3704*x89
    x3711 = x213*x3704
    x3712 = x106*x3699
    x3713 = x531*x932 + x537*x940 + x542*x939 + x59*(-x2665 + x2666 - x2667 + x2668 + x2752 - x3709 - x3710 + x3711 + x3712) + x69*(x2400 - x2654 + x2655 - x2656 + x2657 + x2708 - x3705 - x3706 + x3707 + x3708) + x76*(x1923 + x2716 + x2764 - x3698 - x3700 + x3701 + x3703)
    x3714 = x3620*x561
    x3715 = x2786*(x2787 + x3600)
    x3716 = x3715*x572
    x3717 = x2790*x3716
    x3718 = x28*x3716
    x3719 = x3718*x92
    x3720 = x213*x3718
    x3721 = x3716*x86
    x3722 = x24*x3721
    x3723 = x1888*x3718
    x3724 = x25*x3721
    x3725 = x25*x3716
    x3726 = x215*x3725
    x3727 = x101*x3718
    x3728 = x213*x3725
    x3729 = x24*x3716
    x3730 = x101*x3729
    x3731 = x1888*x3729
    x3732 = x3725*x92
    x3733 = x586*x932 + x59*(x2835 - x2968 + x2969 - x2970 + x2971 + x3091 + x3326 + x3508 - x3728 - x3730 + x3731 + x3732) + x596*x940 + x604*x939 + x69*(x2818 - x2953 + x2954 - x2955 + x2956 + x3034 + x3232 + x3274 - x3723 - x3724 + x3726 + x3727) + x76*(x2807 + x3038 + x3107 - x3717 - x3719 + x3720 + x3722)
    x3734 = x3620*x631
    x3735 = x3715*x645
    x3736 = x2790*x3735
    x3737 = x28*x3735
    x3738 = x3737*x92
    x3739 = x213*x3737
    x3740 = x3735*x86
    x3741 = x24*x3740
    x3742 = x1888*x3737
    x3743 = x25*x3740
    x3744 = x25*x3735
    x3745 = x215*x3744
    x3746 = x101*x3737
    x3747 = x213*x3744
    x3748 = x24*x3735
    x3749 = x101*x3748
    x3750 = x1888*x3748
    x3751 = x3744*x92
    x3752 = x59*(-x3250 + x3251 - x3252 + x3253 + x3356 + x3483 - x3747 - x3749 + x3750 + x3751) + x656*x932 + x663*x939 + x671*x940 + x69*(-x3240 + x3241 - x3242 + x3243 + x3307 - x3742 - x3743 + x3745 + x3746) + x76*(x2853 + x3311 + x3370 - x3736 - x3738 + x3739 + x3741)
    x3753 = x3620*x694
    x3754 = x3715*x708
    x3755 = x2790*x3754
    x3756 = x28*x3754
    x3757 = x3756*x92
    x3758 = x213*x3756
    x3759 = x3754*x86
    x3760 = x24*x3759
    x3761 = x1888*x3756
    x3762 = x25*x3759
    x3763 = x25*x3754
    x3764 = x215*x3763
    x3765 = x101*x3756
    x3766 = x213*x3763
    x3767 = x24*x3754
    x3768 = x101*x3767
    x3769 = x1888*x3767
    x3770 = x3763*x92
    x3771 = x59*(-x3490 + x3491 - x3492 + x3493 + x3579 - x3766 - x3768 + x3769 + x3770) + x69*(x3257 - x3479 + x3480 - x3481 + x3482 + x3535 - x3761 - x3762 + x3764 + x3765) + x719*x932 + x726*x940 + x731*x939 + x76*(x2849 + x3543 + x3591 - x3755 - x3757 + x3758 + x3760)
    x3772 = x3620*x750
    x3773 = x3601*x765
    x3774 = x3773*x86
    x3775 = x16*x3601
    x3776 = x3775*x769
    x3777 = x3660*x6
    x3778 = x1872*x3777
    x3779 = x25*x3715
    x3780 = x2790*x3779
    x3781 = x3660*x777
    x3782 = x3781*x94
    x3783 = x28*x3779
    x3784 = x3783*x92
    x3785 = x13*x3775
    x3786 = x3785*x92
    x3787 = x3773*x94
    x3788 = x215*x3781
    x3789 = x213*x3783
    x3790 = x3777*x4
    x3791 = x3790*x89
    x3792 = x24*x3779
    x3793 = x3792*x86
    x3794 = x778*x944
    x3795 = 2*x3794
    x3796 = x784*x942
    x3797 = 2*x3796
    x3798 = x775*x782
    x3799 = 2*x3798
    x3800 = x782*x942
    x3801 = 2*x3800
    x3802 = x775*x944
    x3803 = 2*x3802
    x3804 = x778*x784
    x3805 = 2*x3804
    x3806 = x1884 + x2807 + x99
    x3807 = x14*x3601
    x3808 = x3807*x94
    x3809 = x3660*x7
    x3810 = x215*x3809
    x3811 = x26*x3715
    x3812 = x3811*x86
    x3813 = x3807*x86
    x3814 = x3809*x94
    x3815 = x215*x3811
    x3816 = 2*x936
    x3817 = 2*x795
    x3818 = 2*x797
    x3819 = x101*x3785
    x3820 = x1888*x3783
    x3821 = x106*x3790
    x3822 = x106*x3785
    x3823 = x1888*x3790
    x3824 = x101*x3783
    x3825 = x114 + x1895 + x2819
    x3826 = x1421 + x2414 + x3271
    x3827 = x3807*x92
    x3828 = x3809*x89
    x3829 = x213*x3811
    x3830 = x3807*x89
    x3831 = x213*x3809
    x3832 = x3811*x92
    x3833 = x106*x3773
    x3834 = x1888*x3781
    x3835 = x101*x3792
    x3836 = x101*x3773
    x3837 = x1888*x3792
    x3838 = x106*x3781
    x3839 = x136 + x1909 + x2836
    x3840 = x1492 + x2482 + x3339
    x3841 = 2*x932
    x3842 = (mpmath.mpf(1)/mpmath.mpf(2))*x823
    x3843 = (mpmath.mpf(1)/mpmath.mpf(2))*x825
    x3844 = (mpmath.mpf(1)/mpmath.mpf(2))*x827
    x3845 = (mpmath.mpf(1)/mpmath.mpf(2))*x829
    x3846 = (mpmath.mpf(1)/mpmath.mpf(2))*x831
    x3847 = (mpmath.mpf(1)/mpmath.mpf(2))*x833
    x3848 = (mpmath.mpf(1)/mpmath.mpf(2))*x835
    x3849 = (mpmath.mpf(1)/mpmath.mpf(2))*x837
    x3850 = (mpmath.mpf(1)/mpmath.mpf(2))*x839
    x3851 = (mpmath.mpf(1)/mpmath.mpf(2))*x841
    x3852 = (mpmath.mpf(1)/mpmath.mpf(2))*x845
    x3853 = (mpmath.mpf(1)/mpmath.mpf(2))*x848
    x3854 = -x3842 + x3843 + x3844 - x3845 - x3846 + x3847 + x3848 - x3849 - x3850 + x3851 - x3852 + x3853
    x3855 = x1746 + x2671 + x3496 + (mpmath.mpf(1)/mpmath.mpf(2))*x871 + (mpmath.mpf(1)/mpmath.mpf(2))*x873 + (mpmath.mpf(1)/mpmath.mpf(2))*x875 - mpmath.mpf(1)/mpmath.mpf(2)*x877 - mpmath.mpf(1)/mpmath.mpf(2)*x879 - mpmath.mpf(1)/mpmath.mpf(2)*x881 + (mpmath.mpf(1)/mpmath.mpf(2))*x882 + (mpmath.mpf(1)/mpmath.mpf(2))*x883 + (mpmath.mpf(1)/mpmath.mpf(2))*x884 - mpmath.mpf(1)/mpmath.mpf(2)*x885 - mpmath.mpf(1)/mpmath.mpf(2)*x886 - mpmath.mpf(1)/mpmath.mpf(2)*x887
    x3856 = x1409 + x2402 + x3259 + (mpmath.mpf(1)/mpmath.mpf(2))*x893 + (mpmath.mpf(1)/mpmath.mpf(2))*x894 + (mpmath.mpf(1)/mpmath.mpf(2))*x895 - mpmath.mpf(1)/mpmath.mpf(2)*x896 - mpmath.mpf(1)/mpmath.mpf(2)*x897 - mpmath.mpf(1)/mpmath.mpf(2)*x898 + (mpmath.mpf(1)/mpmath.mpf(2))*x899 + (mpmath.mpf(1)/mpmath.mpf(2))*x900 + (mpmath.mpf(1)/mpmath.mpf(2))*x901 - mpmath.mpf(1)/mpmath.mpf(2)*x902 - mpmath.mpf(1)/mpmath.mpf(2)*x903 - mpmath.mpf(1)/mpmath.mpf(2)*x904
    x3857 = 2*x3786
    x3858 = 2*x3787
    x3859 = 2*x3788
    x3860 = 2*x3789
    x3861 = 2*x3791
    x3862 = 2*x3793
    x3863 = 2*x3774
    x3864 = 2*x3776
    x3865 = 2*x3778
    x3866 = 2*x3780
    x3867 = 2*x3782
    x3868 = 2*x3784
    x3869 = x1009 + x1107 + x2179 + x2224 + x3067 + x3112
    x3870 = 4*x2972
    x3871 = 4*x816
    x3872 = 4*x847
    x3873 = 4*x2086
    x3874 = 4*x817
    x3875 = 4*x2973
    x3876 = 4*x936
    x3877 = 4*x795
    x3878 = 4*x797
    x3879 = x1758 + x1811 + x2683 + x2734 + x3508 + x3561
    x3880 = 4*x2073
    x3881 = 4*x802
    x3882 = 4*x2957
    x3883 = 4*x2958
    x3884 = 4*x804
    x3885 = 4*x844
    x3886 = x1424 + x1526 + x2417 + x2515 + x3274 + x3372
    x3887 = x3854*x850 + x3855*x888 + x3856*x905 + x851*(-4*x3794 - 4*x3796 - 4*x3798 + 4*x3800 + 4*x3802 + 4*x3804 - x3857 - x3858 - x3859 - x3860 - x3861 - x3862 + x3863 + x3864 + x3865 + x3866 + x3867 + x3868 + x3869) + x906*(x126*x910 + x128*x911 + x2077*x2115 + x2114*x409 + x2962*x3002 + x2963*x3001 + 2*x3827 + 2*x3828 + 2*x3829 - 2*x3830 - 2*x3831 - 2*x3832 + 2*x3833 + 2*x3834 + 2*x3835 - 2*x3836 - 2*x3837 - 2*x3838 - x3870 - x3871 - x3872 + x3873 + x3874 + x3875 - x3876*x775 + x3876*x778 + x3877*x775 - x3877*x942 - x3878*x778 + x3878*x942 + x3879) + x920*(x2062*x2114 + x21*x910 + x2115*x399 + x2945*x3001 + x2947*x3002 + x36*x911 + 2*x3808 + 2*x3810 + 2*x3812 - 2*x3813 - 2*x3814 - 2*x3815 + 2*x3819 + 2*x3820 + 2*x3821 - 2*x3822 - 2*x3823 - 2*x3824 - x3876*x782 + x3876*x784 - x3877*x784 + x3877*x944 + x3878*x782 - x3878*x944 - x3880 - x3881 - x3882 + x3883 + x3884 + x3885 + x3886)
    x3888 = x164*x937
    x3889 = 2*x938
    x3890 = 2*x1858
    x3891 = x13*x941
    x3892 = x2*x939
    x3893 = 2*x941
    x3894 = x16*x940
    x3895 = x3620*x930
    x3896 = x69*x942
    x3897 = 2*x945
    x3898 = x59*x944
    x3899 = x15*x3601
    x3900 = x3899*x86
    x3901 = x3660*x9
    x3902 = x3901*x94
    x3903 = x27*x3715
    x3904 = x215*x3903
    x3905 = x3899*x94
    x3906 = x215*x3901
    x3907 = x3903*x86
    x3908 = x2*x3775
    x3909 = x3908*x89
    x3910 = x3660*x8
    x3911 = x1872*x3910
    x3912 = x3715*x959
    x3913 = x3912*x92
    x3914 = x3908*x92
    x3915 = x213*x3912
    x3916 = x3910*x4
    x3917 = x3916*x89
    x3918 = x1060*x782
    x3919 = x784*x955
    x3920 = x944*x953
    x3921 = x1060*x784
    x3922 = x944*x955
    x3923 = x782*x953
    x3924 = x942*x957
    x3925 = x1071*x775
    x3926 = x778*x960
    x3927 = x1071*x778
    x3928 = x942*x960
    x3929 = x775*x957
    x3930 = x3924 + x3925 + x3926 - x3927 - x3928 - x3929
    x3931 = x184 + x1927 + x2074 + x2853 + x2959 + x3918 + x3919 + x3920 - x3921 - x3922 - x3923 + x3930 + x805
    x3932 = x101*x3908
    x3933 = x1888*x3912
    x3934 = x106*x3916
    x3935 = x106*x3908
    x3936 = x1888*x3916
    x3937 = x101*x3912
    x3938 = x936*x960
    x3939 = x1071*x795
    x3940 = x797*x957
    x3941 = x936*x957
    x3942 = x795*x960
    x3943 = x1071*x797
    x3944 = x3794 + x3796 + x3798 - x3800 - x3802 - x3804
    x3945 = x1102 + x177 + x1920 + x2220 + x2846 + x3108 + x3938 + x3939 + x3940 - x3941 - x3942 - x3943 + x3944
    x3946 = x106*x3899
    x3947 = x1888*x3901
    x3948 = x101*x3903
    x3949 = x101*x3899
    x3950 = x106*x3901
    x3951 = x1888*x3903
    x3952 = x3773*x92
    x3953 = x213*x3792
    x3954 = x3781*x89
    x3955 = x3773*x89
    x3956 = x213*x3781
    x3957 = x3792*x92
    x3958 = x936*x955
    x3959 = x1060*x797
    x3960 = x795*x953
    x3961 = x936*x953
    x3962 = x1060*x795
    x3963 = x797*x955
    x3964 = x1734 + x1786 + x2658 + x2709 + x3483 + x3536 + x3958 + x3959 + x3960 - x3961 - x3962 - x3963
    x3965 = 2*x3921
    x3966 = 2*x3922
    x3967 = 2*x3923
    x3968 = 2*x3918
    x3969 = 2*x3919
    x3970 = 2*x3920
    x3971 = x2131 + x3018 + x928
    x3972 = 2*x3927
    x3973 = 2*x3928
    x3974 = 2*x3929
    x3975 = 2*x3924
    x3976 = 2*x3925
    x3977 = 2*x3926
    x3978 = -x3972 - x3973 - x3974 + x3975 + x3976 + x3977
    x3979 = x1484 + x2476 + x3333 - x3965 - x3966 - x3967 + x3968 + x3969 + x3970 + x3971 + x3978
    x3980 = 2*x3935
    x3981 = 2*x3936
    x3982 = 2*x3937
    x3983 = 2*x3932
    x3984 = 2*x3933
    x3985 = 2*x3934
    x3986 = 2*x3941
    x3987 = 2*x3942
    x3988 = 2*x3943
    x3989 = 2*x3938
    x3990 = 2*x3939
    x3991 = 2*x3940
    x3992 = x1106 + x2223 + x3111
    x3993 = x3795 + x3797 + x3799 - x3801 - x3803 - x3805
    x3994 = x2104 + x2991 - x3986 - x3987 - x3988 + x3989 + x3990 + x3991 + x3992 + x3993 + x865
    x3995 = x1766 + x1812 + x2691 + x2735 + x3516 + x3562 + 2*x3958 + 2*x3959 + 2*x3960 - 2*x3961 - 2*x3962 - 2*x3963
    x3996 = x1001*x3856 + x1024*x3854 + x1035*x3855 + x851*(2*x3900 + 2*x3902 + 2*x3904 - 2*x3905 - 2*x3906 - 2*x3907 + 2*x3909 + 2*x3911 + 2*x3913 - 2*x3914 - 2*x3915 - 2*x3917 + x3979) + x906*(2*x3946 + 2*x3947 + 2*x3948 - 2*x3949 - 2*x3950 - 2*x3951 + 2*x3952 + 2*x3953 + 2*x3954 - 2*x3955 - 2*x3956 - 2*x3957 + x3995) + x920*(x3858 + x3859 + x3862 - x3863 - x3866 - x3867 - x3980 - x3981 - x3982 + x3983 + x3984 + x3985 + x3994)
    x3997 = x1051*x3620
    x3998 = x13*x932
    x3999 = x2*x941
    x4000 = x16*x941
    x4001 = x189*x945
    x4002 = x1071*x945
    x4003 = x1051*x3888 + x1055*x3891 + x1055*x934 - x1056 + x1057*x939 - x1058 - x1059 + x1061*x945 + x1064*x3999 + x1064*x938 + x1067*x1858 + x1067*x4000 + x1068*x3892 + x1068*x3894 + x1068*x3998 + x1069*x4001 + x1070*x3896 + x1070*x3898 - x1441 - x1442 - x1443 + x1859*x940 + x4002*x59 + x932*x938
    x4004 = x17*x3601
    x4005 = x4004*x89
    x4006 = x10*x3660
    x4007 = x213*x4006
    x4008 = x29*x3715
    x4009 = x4008*x92
    x4010 = x4004*x92
    x4011 = x4006*x89
    x4012 = x213*x4008
    x4013 = x3775*x87
    x4014 = x215*x3912
    x4015 = x3916*x94
    x4016 = x3908*x94
    x4017 = x215*x3916
    x4018 = x3912*x86
    x4019 = x1152*x775
    x4020 = x1078*x942
    x4021 = x1080*x778
    x4022 = x1152*x778
    x4023 = x1078*x775
    x4024 = x1080*x942
    x4025 = x1071*x782
    x4026 = x944*x960
    x4027 = x784*x957
    x4028 = x944*x957
    x4029 = x1071*x784
    x4030 = x782*x960
    x4031 = x4025 + x4026 + x4027 - x4028 - x4029 - x4030
    x4032 = x180 + x1923 + x2087 + x2849 + x2974 + x4019 + x4020 + x4021 - x4022 - x4023 - x4024 + x4031 + x818
    x4033 = x101*x4004
    x4034 = x106*x4006
    x4035 = x1888*x4008
    x4036 = x106*x4004
    x4037 = x1888*x4006
    x4038 = x101*x4008
    x4039 = x3785*x94
    x4040 = x215*x3790
    x4041 = x3783*x86
    x4042 = x3785*x86
    x4043 = x215*x3783
    x4044 = x3790*x94
    x4045 = x1080*x936
    x4046 = x1152*x795
    x4047 = x1078*x797
    x4048 = x1078*x936
    x4049 = x1152*x797
    x4050 = x1080*x795
    x4051 = x1407 + x1511 + x2400 + x2500 + x3257 + x3357 + x4045 + x4046 + x4047 - x4048 - x4049 - x4050
    x4052 = x178 + x1921 + x2156 + x2847 + x3043 - x3938 - x3939 - x3940 + x3941 + x3942 + x3943 + x3944 + x972
    x4053 = 2*x4022
    x4054 = 2*x4023
    x4055 = 2*x4024
    x4056 = 2*x4019
    x4057 = 2*x4020
    x4058 = 2*x4021
    x4059 = x2120 + x3007 + x916
    x4060 = 2*x4028
    x4061 = 2*x4029
    x4062 = 2*x4030
    x4063 = 2*x4025
    x4064 = 2*x4026
    x4065 = 2*x4027
    x4066 = -x4060 - x4061 - x4062 + x4063 + x4064 + x4065
    x4067 = x1495 + x2485 + x3342 - x4053 - x4054 - x4055 + x4056 + x4057 + x4058 + x4059 + x4066
    x4068 = x1008 + x2178 + x3066
    x4069 = x2101 + x2988 + x3986 + x3987 + x3988 - x3989 - x3990 - x3991 + x3993 + x4068 + x862
    x4070 = x1438 + x1527 + x2431 + x2516 + x3288 + x3373 + 2*x4045 + 2*x4046 + 2*x4047 - 2*x4048 - 2*x4049 - 2*x4050
    x4071 = x1105*x3855 + x1122*x3854 + x1133*x3856 + x851*(2*x4005 + 2*x4007 + 2*x4009 - 2*x4010 - 2*x4011 - 2*x4012 + 2*x4013 + 2*x4014 + 2*x4015 - 2*x4016 - 2*x4017 - 2*x4018 + x4067) + x906*(x3857 + x3860 + x3861 - x3864 - x3865 - x3868 + x3980 + x3981 + x3982 - x3983 - x3984 - x3985 + x4069) + x920*(2*x4033 + 2*x4034 + 2*x4035 - 2*x4036 - 2*x4037 - 2*x4038 + 2*x4039 + 2*x4040 + 2*x4041 - 2*x4042 - 2*x4043 - 2*x4044 + x4070)
    x4072 = x1142*x3620
    x4073 = x1142*x3888 + x1147*x3891 + x1147*x934 - x1148 + x1149*x940 - x1150 - x1151 + x1153*x945 + x1156*x3999 + x1156*x938 + x1157*x1858 + x1157*x4000 + x1158*x3892 + x1158*x3894 + x1158*x3998 + x1159*x3896 + x1159*x3898 - x1769 - x1770 - x1771 + x1858*x932 + x1859*x939 + x4001*x943 + x4002*x69
    x4074 = -x1162
    x4075 = x81*(x1161 + x4074)
    x4076 = x0*x4075
    x4077 = x4076*x87
    x4078 = x16*x4076
    x4079 = x4078*x89
    x4080 = x4078*x92
    x4081 = x4076*x94
    x4082 = x2*x4081
    x4083 = x101*x4078
    x4084 = x13*x4081
    x4085 = x13*x4076
    x4086 = x4085*x86
    x4087 = x106*x4078
    x4088 = x4085*x92
    x4089 = x2*x4076
    x4090 = x106*x4089
    x4091 = x101*x4089
    x4092 = x4076*x769
    x4093 = x1055*x168 + x1064*x176 + x1067*x170 + x59*(x1094 + x1786 - x4088 - x4090 + x4091 + x4092 - x979 + x980 - x981 + x982) + x69*(x1103 + x177 - x4083 - x4084 + x4086 + x4087 + x780) + x76*(-x4077 - x4079 + x4080 + x4082 + x806 - x954 + x956 - x958 + x961)
    x4094 = x209*(-x1001*x1182 - x1024*x1184 - x1035*x1183)
    x4095 = x163*x4094
    x4096 = x231*x4075
    x4097 = x4096*x87
    x4098 = x16*x4096
    x4099 = x4098*x89
    x4100 = x4098*x92
    x4101 = x4096*x94
    x4102 = x2*x4101
    x4103 = x101*x4098
    x4104 = x13*x4101
    x4105 = x13*x4096
    x4106 = x4105*x86
    x4107 = x106*x4098
    x4108 = x4105*x92
    x4109 = x2*x4096
    x4110 = x106*x4109
    x4111 = x101*x4109
    x4112 = x4096*x769
    x4113 = x1055*x264 + x1064*x269 + x1067*x275 + x59*(x130 - x1473 + x1474 - x1475 + x1476 + x1521 + x1811 - x4108 - x4110 + x4111 + x4112 + x818) + x69*(x114 + x1379 + x1523 - x4103 - x4104 + x4106 + x4107) + x76*(x1009 + x1394 - x1456 + x1457 - x1458 + x1459 - x4097 - x4099 + x4100 + x4102 + x972 + x98)
    x4114 = x292*x4094
    x4115 = x319*x4075
    x4116 = x4115*x87
    x4117 = x16*x4115
    x4118 = x4117*x89
    x4119 = x4117*x92
    x4120 = x4115*x94
    x4121 = x2*x4120
    x4122 = x101*x4117
    x4123 = x13*x4120
    x4124 = x13*x4115
    x4125 = x4124*x86
    x4126 = x106*x4117
    x4127 = x4124*x92
    x4128 = x2*x4115
    x4129 = x106*x4128
    x4130 = x101*x4128
    x4131 = x4115*x769
    x4132 = x1055*x349 + x1064*x359 + x1067*x354 + x59*(-x1799 + x1800 - x1801 + x1802 + x1844 - x4127 - x4129 + x4130 + x4131) + x69*(x1722 + x181 + x1847 - x4122 - x4123 + x4125 + x4126) + x76*(x1733 - x1781 + x1782 - x1783 + x1784 - x4116 - x4118 + x4119 + x4121 + x988)
    x4133 = x370*x4094
    x4134 = x1868*(x2241 + x4074)
    x4135 = x387*x4134
    x4136 = x1872*x4135
    x4137 = x4135*x8
    x4138 = x4137*x94
    x4139 = x215*x4137
    x4140 = x4*x4135
    x4141 = x4140*x89
    x4142 = x4135*x6
    x4143 = x215*x4142
    x4144 = x106*x4140
    x4145 = x1888*x4140
    x4146 = x4142*x94
    x4147 = x1888*x4137
    x4148 = x4142*x89
    x4149 = x213*x4142
    x4150 = x106*x4137
    x4151 = x1055*x402 + x1064*x423 + x1067*x414 + x59*(-x2163 + x2164 - x2165 + x2166 + x2215 + x2709 - x4147 - x4148 + x4149 + x4150) + x69*(x1920 + x2055 + x2221 - x4143 - x4144 + x4145 + x4146) + x76*(x2075 - x2144 + x2145 - x2146 + x2147 - x4136 - x4138 + x4139 + x4141)
    x4152 = x4094*x451
    x4153 = x4134*x465
    x4154 = x1872*x4153
    x4155 = x4153*x8
    x4156 = x4155*x94
    x4157 = x215*x4155
    x4158 = x4*x4153
    x4159 = x4158*x89
    x4160 = x4153*x6
    x4161 = x215*x4160
    x4162 = x106*x4158
    x4163 = x1888*x4158
    x4164 = x4160*x94
    x4165 = x1888*x4155
    x4166 = x4160*x89
    x4167 = x213*x4160
    x4168 = x106*x4155
    x4169 = x1055*x473 + x1064*x479 + x1067*x486 + x59*(x1906 + x2087 - x2465 + x2466 - x2467 + x2468 + x2510 + x2734 - x4165 - x4166 + x4167 + x4168) + x69*(x1895 + x2372 + x2512 - x4161 - x4162 + x4163 + x4164) + x76*(x1883 + x2156 + x2179 + x2387 - x2447 + x2448 - x2449 + x2450 - x4154 - x4156 + x4157 + x4159)
    x4170 = x4094*x510
    x4171 = x4134*x523
    x4172 = x1872*x4171
    x4173 = x4171*x8
    x4174 = x4173*x94
    x4175 = x215*x4173
    x4176 = x4*x4171
    x4177 = x4176*x89
    x4178 = x4171*x6
    x4179 = x215*x4178
    x4180 = x106*x4176
    x4181 = x1888*x4176
    x4182 = x4178*x94
    x4183 = x1888*x4173
    x4184 = x4178*x89
    x4185 = x213*x4178
    x4186 = x106*x4173
    x4187 = x1055*x531 + x1064*x542 + x1067*x537 + x59*(-x2722 + x2723 - x2724 + x2725 + x2762 - x4183 - x4184 + x4185 + x4186) + x69*(x1924 + x2647 + x2765 - x4179 - x4180 + x4181 + x4182) + x76*(x2170 + x2659 - x2704 + x2705 - x2706 + x2707 - x4172 - x4174 + x4175 + x4177)
    x4188 = x4094*x561
    x4189 = x2786*(x3135 + x4074)
    x4190 = x4189*x572
    x4191 = x2790*x4190
    x4192 = x28*x4190
    x4193 = x4192*x92
    x4194 = x213*x4192
    x4195 = x4190*x86
    x4196 = x24*x4195
    x4197 = x1888*x4192
    x4198 = x25*x4195
    x4199 = x25*x4190
    x4200 = x215*x4199
    x4201 = x101*x4192
    x4202 = x213*x4199
    x4203 = x24*x4190
    x4204 = x101*x4203
    x4205 = x1888*x4203
    x4206 = x4199*x92
    x4207 = x1055*x586 + x1064*x604 + x1067*x596 + x59*(-x3050 + x3051 - x3052 + x3053 + x3105 + x3536 - x4202 - x4204 + x4205 + x4206) + x69*(x2846 + x2938 + x3109 - x4197 - x4198 + x4200 + x4201) + x76*(x2960 - x3030 + x3031 - x3032 + x3033 - x4191 - x4193 + x4194 + x4196)
    x4208 = x4094*x631
    x4209 = x4189*x645
    x4210 = x2790*x4209
    x4211 = x28*x4209
    x4212 = x4211*x92
    x4213 = x213*x4211
    x4214 = x4209*x86
    x4215 = x24*x4214
    x4216 = x1888*x4211
    x4217 = x25*x4214
    x4218 = x25*x4209
    x4219 = x215*x4218
    x4220 = x101*x4211
    x4221 = x213*x4218
    x4222 = x24*x4209
    x4223 = x101*x4222
    x4224 = x1888*x4222
    x4225 = x4218*x92
    x4226 = x1055*x656 + x1064*x663 + x1067*x671 + x59*(x2832 + x2974 - x3322 + x3323 - x3324 + x3325 + x3367 + x3561 - x4221 - x4223 + x4224 + x4225) + x69*(x2819 + x3229 + x3369 - x4216 - x4217 + x4219 + x4220) + x76*(x2806 + x3043 + x3067 + x3244 - x3303 + x3304 - x3305 + x3306 - x4210 - x4212 + x4213 + x4215)
    x4227 = x4094*x694
    x4228 = x4189*x708
    x4229 = x2790*x4228
    x4230 = x28*x4228
    x4231 = x4230*x92
    x4232 = x213*x4230
    x4233 = x4228*x86
    x4234 = x24*x4233
    x4235 = x1888*x4230
    x4236 = x25*x4233
    x4237 = x25*x4228
    x4238 = x215*x4237
    x4239 = x101*x4230
    x4240 = x213*x4237
    x4241 = x24*x4228
    x4242 = x101*x4241
    x4243 = x1888*x4241
    x4244 = x4237*x92
    x4245 = x1055*x719 + x1064*x731 + x1067*x726 + x59*(-x3549 + x3550 - x3551 + x3552 + x3589 - x4240 - x4242 + x4243 + x4244) + x69*(x2850 + x3472 + x3592 - x4235 - x4236 + x4238 + x4239) + x76*(x3056 + x3484 - x3531 + x3532 - x3533 + x3534 - x4229 - x4231 + x4232 + x4234)
    x4246 = x4094*x750
    x4247 = x4075*x765
    x4248 = x4247*x86
    x4249 = x16*x4075
    x4250 = x4249*x769
    x4251 = x4134*x6
    x4252 = x1872*x4251
    x4253 = x25*x4189
    x4254 = x2790*x4253
    x4255 = x4134*x777
    x4256 = x4255*x94
    x4257 = x28*x4253
    x4258 = x4257*x92
    x4259 = x13*x4249
    x4260 = x4259*x92
    x4261 = x4247*x94
    x4262 = x215*x4255
    x4263 = x213*x4257
    x4264 = x4*x4251
    x4265 = x4264*x89
    x4266 = x24*x4253
    x4267 = x4266*x86
    x4268 = x14*x4075
    x4269 = x4268*x94
    x4270 = x4134*x7
    x4271 = x215*x4270
    x4272 = x26*x4189
    x4273 = x4272*x86
    x4274 = x4268*x86
    x4275 = x4270*x94
    x4276 = x215*x4272
    x4277 = x101*x4259
    x4278 = x1888*x4257
    x4279 = x106*x4264
    x4280 = x106*x4259
    x4281 = x1888*x4264
    x4282 = x101*x4257
    x4283 = x4268*x92
    x4284 = x4270*x89
    x4285 = x213*x4272
    x4286 = x4268*x89
    x4287 = x213*x4270
    x4288 = x4272*x92
    x4289 = x106*x4247
    x4290 = x1888*x4255
    x4291 = x101*x4266
    x4292 = x101*x4247
    x4293 = x1888*x4266
    x4294 = x106*x4255
    x4295 = (mpmath.mpf(1)/mpmath.mpf(2))*x990
    x4296 = (mpmath.mpf(1)/mpmath.mpf(2))*x992
    x4297 = (mpmath.mpf(1)/mpmath.mpf(2))*x1062
    x4298 = (mpmath.mpf(1)/mpmath.mpf(2))*x1063
    x4299 = (mpmath.mpf(1)/mpmath.mpf(2))*x997
    x4300 = (mpmath.mpf(1)/mpmath.mpf(2))*x999
    x4301 = x3842 - x3843 - x3848 + x3849 + x3850 - x3853 + x4295 - x4296 - x4297 + x4298 + x4299 - x4300
    x4302 = (mpmath.mpf(1)/mpmath.mpf(2))*x1011 + (mpmath.mpf(1)/mpmath.mpf(2))*x1012 + (mpmath.mpf(1)/mpmath.mpf(2))*x1014 - mpmath.mpf(1)/mpmath.mpf(2)*x1016 - mpmath.mpf(1)/mpmath.mpf(2)*x1018 - mpmath.mpf(1)/mpmath.mpf(2)*x1019 + (mpmath.mpf(1)/mpmath.mpf(2))*x1020 + (mpmath.mpf(1)/mpmath.mpf(2))*x1021 - mpmath.mpf(1)/mpmath.mpf(2)*x1022 - mpmath.mpf(1)/mpmath.mpf(2)*x1023 - mpmath.mpf(1)/mpmath.mpf(2)*x1053 + (mpmath.mpf(1)/mpmath.mpf(2))*x1054 + x2111 + x2998 + x891
    x4303 = (mpmath.mpf(1)/mpmath.mpf(2))*x1025 + (mpmath.mpf(1)/mpmath.mpf(2))*x1026 + (mpmath.mpf(1)/mpmath.mpf(2))*x1027 - mpmath.mpf(1)/mpmath.mpf(2)*x1028 - mpmath.mpf(1)/mpmath.mpf(2)*x1029 - mpmath.mpf(1)/mpmath.mpf(2)*x1030 + (mpmath.mpf(1)/mpmath.mpf(2))*x1031 + (mpmath.mpf(1)/mpmath.mpf(2))*x1032 - mpmath.mpf(1)/mpmath.mpf(2)*x1033 - mpmath.mpf(1)/mpmath.mpf(2)*x1034 - mpmath.mpf(1)/mpmath.mpf(2)*x1065 + (mpmath.mpf(1)/mpmath.mpf(2))*x1066 + x1760 + x2685 + x3510
    x4304 = 2*x4260
    x4305 = 2*x4261
    x4306 = 2*x4262
    x4307 = 2*x4263
    x4308 = 2*x4265
    x4309 = 2*x4267
    x4310 = 2*x4248
    x4311 = 2*x4250
    x4312 = 2*x4252
    x4313 = 2*x4254
    x4314 = 2*x4256
    x4315 = 2*x4258
    x4316 = x4301*x905 + x4302*x850 + x4303*x888 + x851*(x3979 - x4304 - x4305 - x4306 - x4307 - x4308 - x4309 + x4310 + x4311 + x4312 + x4313 + x4314 + x4315) + x906*(x3995 + 2*x4283 + 2*x4284 + 2*x4285 - 2*x4286 - 2*x4287 - 2*x4288 + 2*x4289 + 2*x4290 + 2*x4291 - 2*x4292 - 2*x4293 - 2*x4294) + x920*(x3994 + 2*x4269 + 2*x4271 + 2*x4273 - 2*x4274 - 2*x4275 - 2*x4276 + 2*x4277 + 2*x4278 + 2*x4279 - 2*x4280 - 2*x4281 - 2*x4282)
    x4317 = x4094*x930
    x4318 = x15*x4075
    x4319 = x4318*x86
    x4320 = x4134*x9
    x4321 = x4320*x94
    x4322 = x27*x4189
    x4323 = x215*x4322
    x4324 = x4318*x94
    x4325 = x215*x4320
    x4326 = x4322*x86
    x4327 = 2*x1060
    x4328 = 2*x955
    x4329 = 2*x953
    x4330 = x2*x4249
    x4331 = x4330*x89
    x4332 = x4134*x8
    x4333 = x1872*x4332
    x4334 = x4189*x959
    x4335 = x4334*x92
    x4336 = x4330*x92
    x4337 = x213*x4334
    x4338 = x4*x4332
    x4339 = x4338*x89
    x4340 = x101*x4330
    x4341 = x1888*x4334
    x4342 = x106*x4338
    x4343 = x106*x4330
    x4344 = x1888*x4338
    x4345 = x101*x4334
    x4346 = x106*x4318
    x4347 = x1888*x4320
    x4348 = x101*x4322
    x4349 = x101*x4318
    x4350 = x106*x4320
    x4351 = x1888*x4322
    x4352 = x4247*x92
    x4353 = x213*x4266
    x4354 = x4255*x89
    x4355 = x4247*x89
    x4356 = x213*x4255
    x4357 = x4266*x92
    x4358 = 2*x1064
    x4359 = 2*x4343
    x4360 = 2*x4344
    x4361 = 2*x4345
    x4362 = 2*x4340
    x4363 = 2*x4341
    x4364 = 2*x4342
    x4365 = 4*x1060
    x4366 = 4*x955
    x4367 = 4*x953
    x4368 = 4*x3042
    x4369 = 4*x971
    x4370 = 4*x996
    x4371 = 4*x2155
    x4372 = 4*x969
    x4373 = 4*x3041
    x4374 = x1001*x4301 + x1024*x4302 + x1035*x4303 + x851*(-x1071*x4366 + x1071*x4367 + x1487*x21 + x1489*x36 + x2062*x2478 + x2479*x399 + x2945*x3335 + x2947*x3336 + x3869 + 2*x4319 + 2*x4321 + 2*x4323 - 2*x4324 - 2*x4325 - 2*x4326 + 2*x4331 + 2*x4333 + 2*x4335 - 2*x4336 - 2*x4337 - 2*x4339 + x4365*x957 - x4365*x960 + x4366*x960 - x4367*x957 - x4368 - x4369 - x4370 + x4371 + x4372 + x4373) + x906*(x131*x1489 + x133*x1487 + x2460*x2479 + x2478*x405 + x3316*x3336 + x3317*x3335 + x3870 + x3871 + x3872 - x3873 - x3874 - x3875 + x3879 + 2*x4346 + 2*x4347 + 2*x4348 - 2*x4349 - 2*x4350 - 2*x4351 + 2*x4352 + 2*x4353 + 2*x4354 - 2*x4355 - 2*x4356 - 2*x4357 + x4365*x775 - x4365*x778 - x4366*x775 + x4366*x942 + x4367*x778 - x4367*x942) + x920*(x3886 - 4*x3924 - 4*x3925 - 4*x3926 + 4*x3927 + 4*x3928 + 4*x3929 + x4305 + x4306 + x4309 - x4310 - x4313 - x4314 - x4359 - x4360 - x4361 + x4362 + x4363 + x4364)
    x4375 = 2*x1070
    x4376 = 2*x1859
    x4377 = x1055*x13
    x4378 = 2*x1068
    x4379 = x1068*x2
    x4380 = x1067*x16
    x4381 = x1051*x4094
    x4382 = x1069*x189
    x4383 = x1071*x59
    x4384 = x17*x4075
    x4385 = x4384*x89
    x4386 = x10*x4134
    x4387 = x213*x4386
    x4388 = x29*x4189
    x4389 = x4388*x92
    x4390 = x4384*x92
    x4391 = x4386*x89
    x4392 = x213*x4388
    x4393 = x4249*x87
    x4394 = x215*x4334
    x4395 = x4338*x94
    x4396 = x4330*x94
    x4397 = x215*x4338
    x4398 = x4334*x86
    x4399 = x1060*x1078
    x4400 = x1152*x953
    x4401 = x1080*x955
    x4402 = x1060*x1080
    x4403 = x1152*x955
    x4404 = x1078*x953
    x4405 = x1099 + x2170 + x2217 + x3056 + x3103 + x4399 + x4400 + x4401 - x4402 - x4403 - x4404 + x988
    x4406 = x101*x4384
    x4407 = x106*x4386
    x4408 = x1888*x4388
    x4409 = x106*x4384
    x4410 = x1888*x4386
    x4411 = x101*x4388
    x4412 = x4259*x94
    x4413 = x215*x4264
    x4414 = x4257*x86
    x4415 = x4259*x86
    x4416 = x215*x4257
    x4417 = x4264*x94
    x4418 = x1477 + x181 + x1924 + x2469 + x2850 + x3326 - x4019 - x4020 - x4021 + x4022 + x4023 + x4024 + x4031
    x4419 = x1382 + x185 + x1928 + x2375 + x2854 + x3232 - x3918 - x3919 - x3920 + x3921 + x3922 + x3923 + x3930
    x4420 = x2123 + x3010 + x3840 + x4053 + x4054 + x4055 - x4056 - x4057 - x4058 + x4066 + x919
    x4421 = x2128 + x3015 + x3826 + x3965 + x3966 + x3967 - x3968 - x3969 - x3970 + x3978 + x925
    x4422 = x1048 + x1140 + x2191 + x2230 + x3077 + x3118 + 2*x4399 + 2*x4400 + 2*x4401 - 2*x4402 - 2*x4403 - 2*x4404
    x4423 = x1105*x4303 + x1122*x4302 + x1133*x4301 + x851*(2*x4385 + 2*x4387 + 2*x4389 - 2*x4390 - 2*x4391 - 2*x4392 + 2*x4393 + 2*x4394 + 2*x4395 - 2*x4396 - 2*x4397 - 2*x4398 + x4422) + x906*(x4304 + x4307 + x4308 - x4311 - x4312 - x4315 + x4359 + x4360 + x4361 - x4362 - x4363 - x4364 + x4421) + x920*(2*x4406 + 2*x4407 + 2*x4408 - 2*x4409 - 2*x4410 - 2*x4411 + 2*x4412 + 2*x4413 + 2*x4414 - 2*x4415 - 2*x4416 - 2*x4417 + x4420)
    x4424 = x1142*x4094
    x4425 = x1147*x13
    x4426 = x1158*x2
    x4427 = x1157*x16
    x4428 = x189*x943
    x4429 = x1071*x69
    x4430 = x1055*x1858 + x1057*x1156 + x1061*x1159 + x1064*x1859 + x1064*x4426 + x1067*x1149 + x1068*x4425 + x1068*x4427 + x1070*x1153 + x1070*x4428 + x1070*x4429 + x1147*x938 + x1156*x4379 + x1157*x1859 + x1158*x4377 + x1158*x4380 + x1159*x4382 + x1159*x4383 - x1530 - x1531 - x1532 - x1815 - x1816 - x1817
    x4431 = -x1535
    x4432 = x81*(x1534 + x4431)
    x4433 = x0*x4432
    x4434 = x4433*x87
    x4435 = x16*x4433
    x4436 = x4435*x89
    x4437 = x4435*x92
    x4438 = x4433*x94
    x4439 = x2*x4438
    x4440 = x101*x4435
    x4441 = x13*x4438
    x4442 = x13*x4433
    x4443 = x4442*x86
    x4444 = x106*x4435
    x4445 = x4442*x92
    x4446 = x2*x4433
    x4447 = x106*x4446
    x4448 = x101*x4446
    x4449 = x4433*x769
    x4450 = x1147*x168 + x1156*x176 + x1157*x170 + x59*(x178 - x4445 - x4447 + x4448 + x4449 + x786 + x973) + x69*(-x1090 + x1091 - x1092 + x1093 + x1511 - x4440 - x4441 + x4443 + x4444 + x983) + x76*(-x1079 + x1081 - x1082 + x1083 - x4434 - x4436 + x4437 + x4439 + x819)
    x4451 = x209*(-x1105*x1183 - x1122*x1184 - x1133*x1182)
    x4452 = x163*x4451
    x4453 = x231*x4432
    x4454 = x4453*x87
    x4455 = x16*x4453
    x4456 = x4455*x89
    x4457 = x4455*x92
    x4458 = x4453*x94
    x4459 = x2*x4458
    x4460 = x101*x4455
    x4461 = x13*x4458
    x4462 = x13*x4453
    x4463 = x4462*x86
    x4464 = x106*x4455
    x4465 = x4462*x92
    x4466 = x2*x4453
    x4467 = x106*x4466
    x4468 = x101*x4466
    x4469 = x4453*x769
    x4470 = x1147*x264 + x1156*x269 + x1157*x275 + x59*(x1383 + x1467 + x185 - x4465 - x4467 + x4468 + x4469) + x69*(x1478 - x1517 + x1518 - x1519 + x1520 - x4460 - x4461 + x4463 + x4464) + x76*(x1099 + x1404 - x1506 + x1507 - x1508 + x1509 - x4454 - x4456 + x4457 + x4459)
    x4471 = x292*x4451
    x4472 = x319*x4432
    x4473 = x4472*x87
    x4474 = x16*x4472
    x4475 = x4474*x89
    x4476 = x4474*x92
    x4477 = x4472*x94
    x4478 = x2*x4477
    x4479 = x101*x4474
    x4480 = x13*x4477
    x4481 = x13*x4472
    x4482 = x4481*x86
    x4483 = x106*x4474
    x4484 = x4481*x92
    x4485 = x2*x4472
    x4486 = x106*x4485
    x4487 = x101*x4485
    x4488 = x4472*x769
    x4489 = x1147*x349 + x1156*x359 + x1157*x354 + x59*(x136 + x1719 + x1792 - x4484 - x4486 + x4487 + x4488) + x69*(x110 + x1526 + x1803 - x1840 + x1841 - x1842 + x1843 - x4479 - x4480 + x4482 + x4483 + x805) + x76*(x1102 + x1107 + x1744 - x1830 + x1831 - x1832 + x1833 - x4473 - x4475 + x4476 + x4478 + x97)
    x4490 = x370*x4451
    x4491 = x1868*(x2527 + x4431)
    x4492 = x387*x4491
    x4493 = x1872*x4492
    x4494 = x4492*x8
    x4495 = x4494*x94
    x4496 = x215*x4494
    x4497 = x4*x4492
    x4498 = x4497*x89
    x4499 = x4492*x6
    x4500 = x215*x4499
    x4501 = x106*x4497
    x4502 = x1888*x4497
    x4503 = x4499*x94
    x4504 = x1888*x4494
    x4505 = x4499*x89
    x4506 = x213*x4499
    x4507 = x106*x4494
    x4508 = x1147*x402 + x1156*x423 + x1157*x414 + x59*(x1921 + x2058 + x2157 - x4504 - x4505 + x4506 + x4507) + x69*(x2167 - x2211 + x2212 - x2213 + x2214 + x2500 - x4500 - x4501 + x4502 + x4503) + x76*(x2088 - x2201 + x2202 - x2203 + x2204 - x4493 - x4495 + x4496 + x4498)
    x4509 = x4451*x451
    x4510 = x4491*x465
    x4511 = x1872*x4510
    x4512 = x4510*x8
    x4513 = x4512*x94
    x4514 = x215*x4512
    x4515 = x4*x4510
    x4516 = x4515*x89
    x4517 = x4510*x6
    x4518 = x215*x4517
    x4519 = x106*x4515
    x4520 = x1888*x4515
    x4521 = x4517*x94
    x4522 = x1888*x4512
    x4523 = x4517*x89
    x4524 = x213*x4517
    x4525 = x106*x4512
    x4526 = x1147*x473 + x1156*x479 + x1157*x486 + x59*(x1928 + x2376 + x2458 - x4522 - x4523 + x4524 + x4525) + x69*(x2470 - x2506 + x2507 - x2508 + x2509 - x4518 - x4519 + x4520 + x4521) + x76*(x2217 + x2397 - x2495 + x2496 - x2497 + x2498 - x4511 - x4513 + x4514 + x4516)
    x4527 = x4451*x510
    x4528 = x4491*x523
    x4529 = x1872*x4528
    x4530 = x4528*x8
    x4531 = x4530*x94
    x4532 = x215*x4530
    x4533 = x4*x4528
    x4534 = x4533*x89
    x4535 = x4528*x6
    x4536 = x215*x4535
    x4537 = x106*x4533
    x4538 = x1888*x4533
    x4539 = x4535*x94
    x4540 = x1888*x4530
    x4541 = x4535*x89
    x4542 = x213*x4535
    x4543 = x106*x4530
    x4544 = x1147*x531 + x1156*x542 + x1157*x537 + x59*(x1909 + x2644 + x2715 - x4540 - x4541 + x4542 + x4543) + x69*(x1892 + x2074 + x2515 + x2726 - x2758 + x2759 - x2760 + x2761 - x4536 - x4537 + x4538 + x4539) + x76*(x1880 + x2220 + x2224 + x2669 - x2748 + x2749 - x2750 + x2751 - x4529 - x4531 + x4532 + x4534)
    x4545 = x4451*x561
    x4546 = x2786*(x3390 + x4431)
    x4547 = x4546*x572
    x4548 = x2790*x4547
    x4549 = x28*x4547
    x4550 = x4549*x92
    x4551 = x213*x4549
    x4552 = x4547*x86
    x4553 = x24*x4552
    x4554 = x1888*x4549
    x4555 = x25*x4552
    x4556 = x25*x4547
    x4557 = x215*x4556
    x4558 = x101*x4549
    x4559 = x213*x4556
    x4560 = x24*x4547
    x4561 = x101*x4560
    x4562 = x1888*x4560
    x4563 = x4556*x92
    x4564 = x1147*x586 + x1156*x604 + x1157*x596 + x59*(x2847 + x2941 + x3044 - x4559 - x4561 + x4562 + x4563) + x69*(x3058 - x3097 + x3098 - x3099 + x3100 + x3357 - x4554 - x4555 + x4557 + x4558) + x76*(x2975 - x3087 + x3088 - x3089 + x3090 - x4548 - x4550 + x4551 + x4553)
    x4565 = x4451*x631
    x4566 = x4546*x645
    x4567 = x2790*x4566
    x4568 = x28*x4566
    x4569 = x4568*x92
    x4570 = x213*x4568
    x4571 = x4566*x86
    x4572 = x24*x4571
    x4573 = x1888*x4568
    x4574 = x25*x4571
    x4575 = x25*x4566
    x4576 = x215*x4575
    x4577 = x101*x4568
    x4578 = x213*x4575
    x4579 = x24*x4566
    x4580 = x101*x4579
    x4581 = x1888*x4579
    x4582 = x4575*x92
    x4583 = x1147*x656 + x1156*x663 + x1157*x671 + x59*(x2854 + x3233 + x3314 - x4578 - x4580 + x4581 + x4582) + x69*(x3327 - x3363 + x3364 - x3365 + x3366 - x4573 - x4574 + x4576 + x4577) + x76*(x3103 + x3254 - x3352 + x3353 - x3354 + x3355 - x4567 - x4569 + x4570 + x4572)
    x4584 = x4451*x694
    x4585 = x4546*x708
    x4586 = x2790*x4585
    x4587 = x28*x4585
    x4588 = x4587*x92
    x4589 = x213*x4587
    x4590 = x4585*x86
    x4591 = x24*x4590
    x4592 = x1888*x4587
    x4593 = x25*x4590
    x4594 = x25*x4585
    x4595 = x215*x4594
    x4596 = x101*x4587
    x4597 = x213*x4594
    x4598 = x24*x4585
    x4599 = x101*x4598
    x4600 = x1888*x4598
    x4601 = x4594*x92
    x4602 = x1147*x719 + x1156*x731 + x1157*x726 + x59*(x2836 + x3469 + x3542 - x4597 - x4599 + x4600 + x4601) + x69*(x2815 + x2959 + x3372 + x3553 - x3585 + x3586 - x3587 + x3588 - x4592 - x4593 + x4595 + x4596) + x76*(x2801 + x3108 + x3112 + x3494 - x3575 + x3576 - x3577 + x3578 - x4586 - x4588 + x4589 + x4591)
    x4603 = x4451*x750
    x4604 = x4432*x765
    x4605 = x4604*x86
    x4606 = x16*x4432
    x4607 = x4606*x769
    x4608 = x4491*x6
    x4609 = x1872*x4608
    x4610 = x25*x4546
    x4611 = x2790*x4610
    x4612 = x4491*x777
    x4613 = x4612*x94
    x4614 = x28*x4610
    x4615 = x4614*x92
    x4616 = x13*x4606
    x4617 = x4616*x92
    x4618 = x4604*x94
    x4619 = x215*x4612
    x4620 = x213*x4614
    x4621 = x4*x4608
    x4622 = x4621*x89
    x4623 = x24*x4610
    x4624 = x4623*x86
    x4625 = x14*x4432
    x4626 = x4625*x94
    x4627 = x4491*x7
    x4628 = x215*x4627
    x4629 = x26*x4546
    x4630 = x4629*x86
    x4631 = x4625*x86
    x4632 = x4627*x94
    x4633 = x215*x4629
    x4634 = x101*x4616
    x4635 = x1888*x4614
    x4636 = x106*x4621
    x4637 = x106*x4616
    x4638 = x1888*x4621
    x4639 = x101*x4614
    x4640 = x4625*x92
    x4641 = x4627*x89
    x4642 = x213*x4629
    x4643 = x4625*x89
    x4644 = x213*x4627
    x4645 = x4629*x92
    x4646 = x106*x4604
    x4647 = x1888*x4612
    x4648 = x101*x4623
    x4649 = x101*x4604
    x4650 = x1888*x4623
    x4651 = x106*x4612
    x4652 = (mpmath.mpf(1)/mpmath.mpf(2))*x1109 + (mpmath.mpf(1)/mpmath.mpf(2))*x1111 + (mpmath.mpf(1)/mpmath.mpf(2))*x1112 - mpmath.mpf(1)/mpmath.mpf(2)*x1114 - mpmath.mpf(1)/mpmath.mpf(2)*x1115 - mpmath.mpf(1)/mpmath.mpf(2)*x1117 + (mpmath.mpf(1)/mpmath.mpf(2))*x1118 - mpmath.mpf(1)/mpmath.mpf(2)*x1119 - mpmath.mpf(1)/mpmath.mpf(2)*x1121 - mpmath.mpf(1)/mpmath.mpf(2)*x1144 + (mpmath.mpf(1)/mpmath.mpf(2))*x1145 + (mpmath.mpf(1)/mpmath.mpf(2))*x1146 + x2107 + x2994 + x868
    x4653 = -x3844 + x3845 + x3846 - x3847 - x3851 + x3852 - x4295 + x4296 + x4297 - x4298 - x4299 + x4300
    x4654 = (mpmath.mpf(1)/mpmath.mpf(2))*x1123 + (mpmath.mpf(1)/mpmath.mpf(2))*x1124 + (mpmath.mpf(1)/mpmath.mpf(2))*x1125 - mpmath.mpf(1)/mpmath.mpf(2)*x1126 - mpmath.mpf(1)/mpmath.mpf(2)*x1127 - mpmath.mpf(1)/mpmath.mpf(2)*x1128 + (mpmath.mpf(1)/mpmath.mpf(2))*x1129 + (mpmath.mpf(1)/mpmath.mpf(2))*x1130 - mpmath.mpf(1)/mpmath.mpf(2)*x1131 - mpmath.mpf(1)/mpmath.mpf(2)*x1132 - mpmath.mpf(1)/mpmath.mpf(2)*x1154 + (mpmath.mpf(1)/mpmath.mpf(2))*x1155 + x1428 + x2421 + x3278
    x4655 = 2*x4617
    x4656 = 2*x4618
    x4657 = 2*x4619
    x4658 = 2*x4620
    x4659 = 2*x4622
    x4660 = 2*x4624
    x4661 = 2*x4605
    x4662 = 2*x4607
    x4663 = 2*x4609
    x4664 = 2*x4611
    x4665 = 2*x4613
    x4666 = 2*x4615
    x4667 = x4652*x850 + x4653*x888 + x4654*x905 + x851*(x4067 - x4655 - x4656 - x4657 - x4658 - x4659 - x4660 + x4661 + x4662 + x4663 + x4664 + x4665 + x4666) + x906*(x4069 + 2*x4640 + 2*x4641 + 2*x4642 - 2*x4643 - 2*x4644 - 2*x4645 + 2*x4646 + 2*x4647 + 2*x4648 - 2*x4649 - 2*x4650 - 2*x4651) + x920*(x4070 + 2*x4626 + 2*x4628 + 2*x4630 - 2*x4631 - 2*x4632 - 2*x4633 + 2*x4634 + 2*x4635 + 2*x4636 - 2*x4637 - 2*x4638 - 2*x4639)
    x4668 = x4451*x930
    x4669 = x15*x4432
    x4670 = x4669*x86
    x4671 = x4491*x9
    x4672 = x4671*x94
    x4673 = x27*x4546
    x4674 = x215*x4673
    x4675 = x4669*x94
    x4676 = x215*x4671
    x4677 = x4673*x86
    x4678 = x2*x4606
    x4679 = x4678*x89
    x4680 = x4491*x8
    x4681 = x1872*x4680
    x4682 = x4546*x959
    x4683 = x4682*x92
    x4684 = x4678*x92
    x4685 = x213*x4682
    x4686 = x4*x4680
    x4687 = x4686*x89
    x4688 = x101*x4678
    x4689 = x1888*x4682
    x4690 = x106*x4686
    x4691 = x106*x4678
    x4692 = x1888*x4686
    x4693 = x101*x4682
    x4694 = x106*x4669
    x4695 = x1888*x4671
    x4696 = x101*x4673
    x4697 = x101*x4669
    x4698 = x106*x4671
    x4699 = x1888*x4673
    x4700 = x4604*x92
    x4701 = x213*x4623
    x4702 = x4612*x89
    x4703 = x4604*x89
    x4704 = x213*x4612
    x4705 = x4623*x92
    x4706 = 2*x4691
    x4707 = 2*x4692
    x4708 = 2*x4693
    x4709 = 2*x4688
    x4710 = 2*x4689
    x4711 = 2*x4690
    x4712 = x1001*x4654 + x1024*x4652 + x1035*x4653 + x851*(x4422 + 2*x4670 + 2*x4672 + 2*x4674 - 2*x4675 - 2*x4676 - 2*x4677 + 2*x4679 + 2*x4681 + 2*x4683 - 2*x4684 - 2*x4685 - 2*x4687) + x906*(x4421 + 2*x4694 + 2*x4695 + 2*x4696 - 2*x4697 - 2*x4698 - 2*x4699 + 2*x4700 + 2*x4701 + 2*x4702 - 2*x4703 - 2*x4704 - 2*x4705) + x920*(x4420 + x4656 + x4657 + x4660 - x4661 - x4664 - x4665 - x4706 - x4707 - x4708 + x4709 + x4710 + x4711)
    x4713 = x1051*x4451
    x4714 = x17*x4432
    x4715 = x4714*x89
    x4716 = x10*x4491
    x4717 = x213*x4716
    x4718 = x29*x4546
    x4719 = x4718*x92
    x4720 = x4714*x92
    x4721 = x4716*x89
    x4722 = x213*x4718
    x4723 = 2*x1152
    x4724 = 2*x1078
    x4725 = 2*x1080
    x4726 = x4606*x87
    x4727 = x215*x4682
    x4728 = x4686*x94
    x4729 = x4678*x94
    x4730 = x215*x4686
    x4731 = x4682*x86
    x4732 = x101*x4714
    x4733 = x106*x4716
    x4734 = x1888*x4718
    x4735 = x106*x4714
    x4736 = x1888*x4716
    x4737 = x101*x4718
    x4738 = x4616*x94
    x4739 = x215*x4621
    x4740 = x4614*x86
    x4741 = x4616*x86
    x4742 = x215*x4614
    x4743 = x4621*x94
    x4744 = 4*x1152
    x4745 = 4*x1078
    x4746 = 4*x1080
    x4747 = x1105*x4653 + x1122*x4652 + x1133*x4654 + x851*(x1071*x4745 - x1071*x4746 + x126*x1853 + x128*x1852 + x2077*x2768 + x2769*x409 + x2962*x3595 + x2963*x3596 + x3869 + x4368 + x4369 + x4370 - x4371 - x4372 - x4373 + 2*x4715 + 2*x4717 + 2*x4719 - 2*x4720 - 2*x4721 - 2*x4722 + 2*x4726 + 2*x4727 + 2*x4728 - 2*x4729 - 2*x4730 - 2*x4731 - x4744*x957 + x4744*x960 - x4745*x960 + x4746*x957) + x906*(x3879 - 4*x4025 - 4*x4026 - 4*x4027 + 4*x4028 + 4*x4029 + 4*x4030 + x4655 + x4658 + x4659 - x4662 - x4663 - x4666 + x4706 + x4707 + x4708 - x4709 - x4710 - x4711) + x920*(x131*x1853 + x133*x1852 + x2460*x2769 + x2768*x405 + x3316*x3596 + x3317*x3595 + x3880 + x3881 + x3882 - x3883 - x3884 - x3885 + x3886 + 2*x4732 + 2*x4733 + 2*x4734 - 2*x4735 - 2*x4736 - 2*x4737 + 2*x4738 + 2*x4739 + 2*x4740 - 2*x4741 - 2*x4742 - 2*x4743 + x4744*x782 - x4744*x784 + x4745*x784 - x4745*x944 - x4746*x782 + x4746*x944)
    x4748 = 2*x1159
    x4749 = 2*x1158
    x4750 = x1142*x4451

    return np.array([x100*(x88 + x91 - x93 - x96 + x99) + x120*(x102 + x103 - x105 - x107 + x114 + x119) + x122*x207 + x142*(x121 + x123 - x124 - x125 + x136 + x141) + 2*x145 + 2*x167 + 2*x172*x200 + 2*x174*x198 + x188*x190 + x188*x192 + x188*x194 + 2*x196*x42 + x201*x203 + x203*x204 + x203*x205 + x206*x85 + x208*x90 + x211*x212 + x211*x214 + x211*x216 + x218*x220 + x220*x222 + x220*x224 + x230 + 2*x80, x100*(x233 + x235 - x236 - x238 + x239) + x120*(x240 + x241 - x243 - x244 + x247) + x142*(x248 + x250 - x251 - x252 + x259) + x190*x281 + x192*x281 + x194*x281 + x206*x232 + x207*x249 + x208*x234 + x212*x293 + x214*x293 + x216*x293 + x318, x100*(x321 + x323 - x324 - x326 + x327) + x120*(x328 + x329 - x331 - x332 + x336) + x142*(x337 + x339 - x340 - x341 + x344) + x190*x364 + x192*x364 + x194*x364 + x206*x320 + x207*x338 + x208*x322 + x212*x371 + x214*x371 + x216*x371 + x386, x190*x441 + x192*x441 + x194*x441 + x212*x452 + x214*x452 + x216*x452 + x464, x190*x502 + x192*x502 + x194*x502 + x212*x511 + x214*x511 + x216*x511 + x522, x190*x555 + x192*x555 + x194*x555 + x212*x562 + x214*x562 + x216*x562 + x571, x190*x621 + x192*x621 + x194*x621 + x212*x632 + x214*x632 + x216*x632 + x644, x190*x686 + x192*x686 + x194*x686 + x212*x695 + x214*x695 + x216*x695 + x707, x190*x744 + x192*x744 + x194*x744 + x212*x751 + x214*x751 + x216*x751 + x760, x100*(x767 + x770 - x772 - x773 + x787) + x120*(x21*x788 + x36*x764 + x790 - x792 + x793 - x794 + x807) + x142*(x126*x788 + x128*x764 + x808 - x809 + x810 - x811 + x820) + x144*x764 + x190*x929 + x192*x929 + x194*x929 + x207*x766 + x208*x771 + x212*x931 + x214*x931 + x216*x931 + x789*x821 + x946, x100*(x948 - x949 + x951 - x952 + x963) + x1049*x190 + x1049*x192 + x1049*x194 + x1050*x84 + x1052*x212 + x1052*x214 + x1052*x216 + x1072 + x120*(-x767 + x773 + x964 - x965 + x974) + x142*(x975 - x976 + x977 - x978 + x989) + x207*x947 + x208*x950, x100*(x1074 - x1075 + x1076 - x1077 + x1085) + x1073*x208 + x1141*x190 + x1141*x192 + x1141*x194 + x1143*x212 + x1143*x214 + x1143*x216 + x1160 + x120*(x1086 - x1087 + x1088 - x1089 + x1100) + x142*(x1104 - x770 + x772 - x964 + x965) + x206*x768 + x207*x950, x100*(x1165 + x1167 - x1168 - x1170 + x239) + x1164*x206 + x1166*x208 + x1177*x207 + x1181*x190 + x1181*x192 + x1181*x194 + x1186*x212 + x1186*x214 + x1186*x216 + x120*(x1171 + x1172 - x1174 - x1175 + x247) + x142*(x1176 + x1178 - x1179 - x1180 + x259) + x318, x100*(x1189 + x1191 - x1192 - x1194 + x1197 + x99) + 2*x1187 + x1188*x206 + x1190*x208 + x120*(x114 + x1198 + x1199 - x1201 - x1202) + x1204*x207 + 2*x1213 + 2*x1214 + x1217*x190 + x1217*x192 + x1217*x194 + x1218*x1219 + x1219*x1224 + x1220*x1221 + x1221*x1225 + x1222*x1223 + x1223*x1226 + x1227*x212 + x1227*x214 + x1227*x216 + x1228*x1229 + x1229*x1230 + x1229*x1231 + x142*(x1203 + x1205 - x1206 - x1207 + x1212 + x136) + x230, x100*(x1233 + x1235 - x1236 - x1238 + x1239) + x120*(x1240 + x1241 - x1243 - x1244 + x1245) + x1232*x206 + x1234*x208 + x1247*x207 + x1257*x190 + x1257*x192 + x1257*x194 + x1258*x212 + x1258*x214 + x1258*x216 + x1274 + x142*(x1246 + x1248 - x1249 - x1250 + x1253), x1288*x190 + x1288*x192 + x1288*x194 + x1289*x212 + x1289*x214 + x1289*x216 + x1294, x1304*x190 + x1304*x192 + x1304*x194 + x1305*x212 + x1305*x214 + x1305*x216 + x1309, x1317*x190 + x1317*x192 + x1317*x194 + x1318*x212 + x1318*x214 + x1318*x216 + x1322, x1335*x190 + x1335*x192 + x1335*x194 + x1336*x212 + x1336*x214 + x1336*x216 + x1341, x1351*x190 + x1351*x192 + x1351*x194 + x1352*x212 + x1352*x214 + x1352*x216 + x1356, x1365*x190 + x1365*x192 + x1365*x194 + x1366*x212 + x1366*x214 + x1366*x216 + x1369, x100*(x1371 + x1373 - x1375 - x1376 + x1384) + x120*(x1386 - x1387 + x1388 - x1389 + x1395) + x1370*x207 + x1374*x208 + x1385*x821 + x142*(x1396 - x1397 + x1398 - x1399 + x1408) + x1439*x190 + x1439*x192 + x1439*x194 + x1440*x212 + x1440*x214 + x1440*x216 + x1444, x100*(x1448*x21 + x1449*x36 + x1451 - x1452 + x1454 - x1455 + x1461) + x1050*x1163 + x120*(-x1371 + x1376 + x1462 - x1463 + x1468) + x142*(x131*x1449 + x133*x1448 + x1469 - x1470 + x1471 - x1472 + x1479) + x1448*x226 + x1450*x207 + x1453*x208 + x1496*x190 + x1496*x192 + x1496*x194 + x1497*x212 + x1497*x214 + x1497*x216 + x1500, x100*(x1502 - x1503 + x1504 - x1505 + x1512) + x120*(x1513 - x1514 + x1515 - x1516 + x1522) + x1372*x206 + x142*(-x1373 + x1375 - x1462 + x1463 + x1525) + x1453*x207 + x1501*x208 + x1528*x190 + x1528*x192 + x1528*x194 + x1529*x212 + x1529*x214 + x1529*x216 + x1533, x100*(x1538 + x1540 - x1541 - x1543 + x327) + x120*(x1544 + x1545 - x1547 - x1548 + x336) + x142*(x1549 + x1551 - x1552 - x1553 + x344) + x1537*x206 + x1539*x208 + x1550*x207 + x1554*x190 + x1554*x192 + x1554*x194 + x1556*x212 + x1556*x214 + x1556*x216 + x386, x100*(x1239 + x1558 + x1560 - x1561 - x1563) + x120*(x1245 + x1564 + x1565 - x1567 - x1568) + x1274 + x142*(x1253 + x1569 + x1571 - x1572 - x1573) + x1557*x206 + x1559*x208 + x1570*x207 + x1574*x190 + x1574*x192 + x1574*x194 + x1575*x212 + x1575*x214 + x1575*x216, x100*(x1578 + x1580 - x1581 - x1583 + x1586 + x99) + x120*(x114 + x1587 + x1588 - x1590 - x1591 + x1594) + x1267*x1609 + x142*(x136 + x1595 + x1597 - x1598 - x1599) + 2*x1576 + x1577*x206 + x1579*x208 + x1596*x207 + 2*x1600 + 2*x1601 + x1604*x190 + x1604*x192 + x1604*x194 + x1605*x1606 + x1606*x1610 + x1607*x1608 + x1608*x1611 + x1609*x1612 + x1613*x212 + x1613*x214 + x1613*x216 + x1614*x1615 + x1615*x1616 + x1615*x1617 + x230, x1630*x190 + x1630*x192 + x1630*x194 + x1631*x212 + x1631*x214 + x1631*x216 + x1639, x1649*x190 + x1649*x192 + x1649*x194 + x1650*x212 + x1650*x214 + x1650*x216 + x1653, x1661*x190 + x1661*x192 + x1661*x194 + x1662*x212 + x1662*x214 + x1662*x216 + x1665, x1678*x190 + x1678*x192 + x1678*x194 + x1679*x212 + x1679*x214 + x1679*x216 + x1683, x1692*x190 + x1692*x192 + x1692*x194 + x1693*x212 + x1693*x214 + x1693*x216 + x1697, x1705*x190 + x1705*x192 + x1705*x194 + x1706*x212 + x1706*x214 + x1706*x216 + x1709, x100*(x1711 + x1713 - x1715 - x1716 + x1723) + x120*(x1725 - x1726 + x1727 - x1728 + x1735) + x142*(x1736 - x1737 + x1738 - x1739 + x1745) + x1710*x207 + x1714*x208 + x1724*x821 + x1767*x190 + x1767*x192 + x1767*x194 + x1768*x212 + x1768*x214 + x1768*x216 + x1774, x100*(x1776 - x1777 + x1779 - x1780 + x1787) + x1050*x1536 + x120*(-x1711 + x1716 + x1788 - x1789 + x1794) + x142*(x1795 - x1796 + x1797 - x1798 + x1804) + x1775*x207 + x1778*x208 + x1813*x190 + x1813*x192 + x1813*x194 + x1814*x212 + x1814*x214 + x1814*x216 + x1819, x100*(x126*x1823 + x128*x1824 + x1826 - x1827 + x1828 - x1829 + x1835) + x120*(x131*x1823 + x133*x1824 + x1836 - x1837 + x1838 - x1839 + x1845) + x142*(-x1713 + x1715 - x1788 + x1789 + x1848) + x1712*x206 + x1778*x207 + x1823*x228 + x1825*x208 + x1854*x190 + x1854*x192 + x1854*x194 + x1855*x212 + x1855*x214 + x1855*x216 + x1860, x1861*x190 + x1861*x192 + x1861*x194 + x1863*x212 + x1863*x214 + x1863*x216 + x464, x1294 + x1864*x190 + x1864*x192 + x1864*x194 + x1865*x212 + x1865*x214 + x1865*x216, x1639 + x1866*x190 + x1866*x192 + x1866*x194 + x1867*x212 + x1867*x214 + x1867*x216, x100*(x1873 + x1875 - x1876 - x1878 + x1884) + x120*(x1886 + x1887 - x1889 - x1890 + x1895 + x1900) + x142*(x1901 + x1902 - x1903 - x1904 + x1909 + x1914) + x190*x1931 + x1915*x1916 + x1916*x1917 + x1916*x1918 + x1919*x212 + x1919*x214 + x1919*x216 + x192*x1931 + x1931*x194, x100*(x1933 + x1935 - x1936 - x1938 + x1939) + x120*(x1941 + x1942 - x1943 - x1944 + x1947) + x142*(x1948 + x1949 - x1950 - x1951 + x1958) + x190*x1964 + x192*x1964 + x194*x1964 + x1965*x212 + x1965*x214 + x1965*x216 + x1969, x100*(x1971 + x1973 - x1974 - x1976 + x1977) + x120*(x1979 + x1980 - x1981 - x1982 + x1986) + x142*(x1987 + x1988 - x1989 - x1990 + x1993) + x190*x1998 + x192*x1998 + x194*x1998 + x1999*x212 + x1999*x214 + x1999*x216 + x2000, x190*x2013 + x192*x2013 + x194*x2013 + x2014*x212 + x2014*x214 + x2014*x216 + x2017, x190*x2029 + x192*x2029 + x194*x2029 + x2030*x212 + x2030*x214 + x2030*x216 + x2033, x190*x2042 + x192*x2042 + x194*x2042 + x2043*x212 + x2043*x214 + x2043*x216 + x2045, x100*(x2047 + x2049 - x2050 - x2052 + x2059) + x120*(x2061*x2062 + x2063*x399 + x2065 - x2066 + x2067 - x2068 + x2076) + x142*(x2061*x409 + x2063*x2077 + x2078 - x2079 + x2080 - x2081 + x2089) + x190*x2132 + x192*x2132 + x194*x2132 + x212*x2133 + x2133*x214 + x2133*x216 + x2136, x100*(x2138 - x2139 + x2141 - x2143 + x2149) + x120*(-x2049 + x2050 + x2150 - x2151 + x2158) + x142*(x2159 - x2160 + x2161 - x2162 + x2171) + x190*x2192 + x192*x2192 + x194*x2192 + x212*x2193 + x214*x2193 + x216*x2193 + x2195, x100*(x2197 - x2198 + x2199 - x2200 + x2206) + x120*(x2207 - x2208 + x2209 - x2210 + x2218) + x142*(-x2047 + x2052 - x2150 + x2151 + x2222) + x190*x2231 + x192*x2231 + x194*x2231 + x212*x2232 + x214*x2232 + x216*x2232 + x2233, x190*x2234 + x192*x2234 + x194*x2234 + x212*x2236 + x214*x2236 + x216*x2236 + x522, x1309 + x190*x2237 + x192*x2237 + x194*x2237 + x212*x2238 + x214*x2238 + x216*x2238, x1653 + x190*x2239 + x192*x2239 + x194*x2239 + x212*x2240 + x214*x2240 + x216*x2240, x100*(x1939 + x2244 + x2246 - x2247 - x2249) + x120*(x1947 + x2251 + x2252 - x2253 - x2254) + x142*(x1958 + x2255 + x2256 - x2257 - x2258) + x190*x2259 + x192*x2259 + x194*x2259 + x1969 + x212*x2260 + x214*x2260 + x216*x2260, x100*(x1884 + x2268 + x2270 - x2271 - x2272 + x2275) + x120*(x1895 + x2263 + x2265 - x2266 - x2267) + x142*(x1909 + x2276 + x2277 - x2278 - x2279 + x2284) + x190*x2291 + x192*x2291 + x194*x2291 + x212*x2288 + x214*x2288 + x216*x2288 + 2*x2285*x517 + 2*x2286*x512 + 2*x2287*x519, x100*(x2293 + x2295 - x2296 - x2298 + x2299) + x120*(x2301 + x2302 - x2303 - x2304 + x2305) + x142*(x2306 + x2307 - x2308 - x2309 + x2312) + x190*x2316 + x192*x2316 + x194*x2316 + x212*x2317 + x214*x2317 + x216*x2317 + x2321, x190*x2334 + x192*x2334 + x194*x2334 + x212*x2335 + x214*x2335 + x216*x2335 + x2338, x190*x2348 + x192*x2348 + x194*x2348 + x212*x2349 + x214*x2349 + x216*x2349 + x2351, x190*x2359 + x192*x2359 + x194*x2359 + x212*x2360 + x214*x2360 + x216*x2360 + x2362, x100*(x2364 + x2366 - x2367 - x2369 + x2377) + x120*(x2379 - x2380 + x2381 - x2382 + x2388) + x142*(x2389 - x2390 + x2391 - x2392 + x2401) + x190*x2432 + x192*x2432 + x194*x2432 + x212*x2433 + x214*x2433 + x216*x2433 + x2436, x100*(x2062*x2438 + x2439*x399 + x2441 - x2442 + x2444 - x2446 + x2452) + x120*(-x2366 + x2367 + x2453 - x2454 + x2459) + x142*(x2438*x405 + x2439*x2460 + x2461 - x2462 + x2463 - x2464 + x2471) + x190*x2486 + x192*x2486 + x194*x2486 + x212*x2487 + x214*x2487 + x216*x2487 + x2489, x100*(x2491 - x2492 + x2493 - x2494 + x2501) + x120*(x2502 - x2503 + x2504 - x2505 + x2511) + x142*(-x2364 + x2369 - x2453 + x2454 + x2514) + x190*x2517 + x192*x2517 + x194*x2517 + x212*x2518 + x214*x2518 + x216*x2518 + x2519, x190*x2520 + x192*x2520 + x194*x2520 + x212*x2522 + x214*x2522 + x216*x2522 + x571, x1322 + x190*x2523 + x192*x2523 + x194*x2523 + x212*x2524 + x214*x2524 + x216*x2524, x1665 + x190*x2525 + x192*x2525 + x194*x2525 + x212*x2526 + x214*x2526 + x216*x2526, x100*(x1977 + x2530 + x2532 - x2533 - x2535) + x120*(x1986 + x2537 + x2538 - x2539 - x2540) + x142*(x1993 + x2541 + x2542 - x2543 - x2544) + x190*x2545 + x192*x2545 + x194*x2545 + x2000 + x212*x2546 + x214*x2546 + x216*x2546, x100*(x2299 + x2548 + x2550 - x2551 - x2553) + x120*(x2305 + x2555 + x2556 - x2557 - x2558) + x142*(x2312 + x2559 + x2560 - x2561 - x2562) + x190*x2563 + x192*x2563 + x194*x2563 + x212*x2564 + x214*x2564 + x216*x2564 + x2321, x100*(x1884 + x2572 + x2573 - x2574 - x2576 + x2579) + x120*(x1895 + x2580 + x2581 - x2582 - x2583 + x2586) + x142*(x1909 + x2567 + x2569 - x2570 - x2571) + x190*x2593 + x192*x2593 + x194*x2593 + x212*x2590 + x214*x2590 + x216*x2590 + 2*x2587*x568 + 2*x2588*x563 + 2*x2589*x567, x190*x2605 + x192*x2605 + x194*x2605 + x212*x2606 + x214*x2606 + x216*x2606 + x2612, x190*x2622 + x192*x2622 + x194*x2622 + x212*x2623 + x214*x2623 + x216*x2623 + x2624, x190*x2632 + x192*x2632 + x194*x2632 + x212*x2633 + x214*x2633 + x216*x2633 + x2634, x100*(x2636 + x2638 - x2639 - x2641 + x2648) + x120*(x2650 - x2651 + x2652 - x2653 + x2660) + x142*(x2661 - x2662 + x2663 - x2664 + x2670) + x190*x2692 + x192*x2692 + x194*x2692 + x212*x2693 + x214*x2693 + x216*x2693 + x2696, x100*(x2698 - x2699 + x2701 - x2703 + x2710) + x120*(-x2638 + x2639 + x2711 - x2712 + x2717) + x142*(x2718 - x2719 + x2720 - x2721 + x2727) + x190*x2736 + x192*x2736 + x194*x2736 + x212*x2737 + x214*x2737 + x216*x2737 + x2739, x100*(x2077*x2741 + x2742*x409 + x2744 - x2745 + x2746 - x2747 + x2753) + x120*(x2460*x2742 + x2741*x405 + x2754 - x2755 + x2756 - x2757 + x2763) + x142*(-x2636 + x2641 - x2711 + x2712 + x2766) + x190*x2770 + x192*x2770 + x194*x2770 + x212*x2771 + x214*x2771 + x216*x2771 + x2772, x190*x2773 + x192*x2773 + x194*x2773 + x212*x2775 + x214*x2775 + x216*x2775 + x644, x1341 + x190*x2776 + x192*x2776 + x194*x2776 + x212*x2777 + x214*x2777 + x216*x2777, x1683 + x190*x2778 + x192*x2778 + x194*x2778 + x212*x2779 + x214*x2779 + x216*x2779, x190*x2780 + x192*x2780 + x194*x2780 + x2017 + x212*x2781 + x214*x2781 + x216*x2781, x190*x2782 + x192*x2782 + x194*x2782 + x212*x2783 + x214*x2783 + x216*x2783 + x2338, x190*x2784 + x192*x2784 + x194*x2784 + x212*x2785 + x214*x2785 + x216*x2785 + x2612, x100*(x2791 + x2793 - x2794 - x2796 + x2807) + x120*(x2808 + x2809 - x2811 - x2812 + x2819 + x2824) + x142*(x2825 + x2827 - x2828 - x2829 + x2836 + x2841) + x190*x2857 + x192*x2857 + x194*x2857 + x212*x2845 + x214*x2845 + x216*x2845 + 2*x2842*x633 + 2*x2843*x639 + 2*x2844*x641, x100*(x2859 + x2861 - x2862 - x2864 + x2865) + x120*(x2866 + x2867 - x2869 - x2870 + x2873) + x142*(x2874 + x2876 - x2877 - x2878 + x2885) + x190*x2891 + x192*x2891 + x194*x2891 + x212*x2892 + x214*x2892 + x216*x2892 + x2896, x100*(x2898 + x2900 - x2901 - x2903 + x2904) + x120*(x2905 + x2906 - x2908 - x2909 + x2913) + x142*(x2914 + x2916 - x2917 - x2918 + x2921) + x190*x2926 + x192*x2926 + x194*x2926 + x212*x2927 + x214*x2927 + x216*x2927 + x2928, x100*(x2930 + x2932 - x2933 - x2935 + x2942) + x120*(x2944*x2945 + x2946*x2947 + x2949 - x2950 + x2951 - x2952 + x2961) + x142*(x2944*x2963 + x2946*x2962 + x2964 - x2965 + x2966 - x2967 + x2976) + x190*x3019 + x192*x3019 + x194*x3019 + x212*x3020 + x214*x3020 + x216*x3020 + x3023, x100*(x3025 - x3026 + x3028 - x3029 + x3035) + x120*(-x2930 + x2935 + x3036 - x3037 + x3045) + x142*(x3046 - x3047 + x3048 - x3049 + x3059) + x190*x3078 + x192*x3078 + x194*x3078 + x212*x3079 + x214*x3079 + x216*x3079 + x3081, x100*(x3083 - x3084 + x3085 - x3086 + x3092) + x120*(x3093 - x3094 + x3095 - x3096 + x3106) + x142*(-x2932 + x2933 - x3036 + x3037 + x3110) + x190*x3119 + x192*x3119 + x194*x3119 + x212*x3120 + x214*x3120 + x216*x3120 + x3121, x190*x3122 + x192*x3122 + x194*x3122 + x212*x3124 + x214*x3124 + x216*x3124 + x707, x1356 + x190*x3125 + x192*x3125 + x194*x3125 + x212*x3126 + x214*x3126 + x216*x3126, x1697 + x190*x3127 + x192*x3127 + x194*x3127 + x212*x3128 + x214*x3128 + x216*x3128, x190*x3129 + x192*x3129 + x194*x3129 + x2033 + x212*x3130 + x214*x3130 + x216*x3130, x190*x3131 + x192*x3131 + x194*x3131 + x212*x3132 + x214*x3132 + x216*x3132 + x2351, x190*x3133 + x192*x3133 + x194*x3133 + x212*x3134 + x214*x3134 + x216*x3134 + x2624, x100*(x2865 + x3138 + x3140 - x3141 - x3143) + x120*(x2873 + x3144 + x3145 - x3147 - x3148) + x142*(x2885 + x3149 + x3151 - x3152 - x3153) + x190*x3154 + x192*x3154 + x194*x3154 + x212*x3155 + x214*x3155 + x216*x3155 + x2896, x100*(x2807 + x3164 + x3165 - x3166 - x3167 + x3170) + x120*(x2819 + x3158 + x3160 - x3162 - x3163) + x142*(x2836 + x3171 + x3173 - x3174 - x3175 + x3180) + x190*x3188 + x192*x3188 + x194*x3188 + x212*x3185 + x214*x3185 + x216*x3185 + x3181*x3182 + x3182*x3183 + x3182*x3184, x100*(x3190 + x3192 - x3193 - x3195 + x3196) + x120*(x3197 + x3198 - x3200 - x3201 + x3202) + x142*(x3203 + x3205 - x3206 - x3207 + x3210) + x190*x3214 + x192*x3214 + x194*x3214 + x212*x3215 + x214*x3215 + x216*x3215 + x3219, x100*(x3221 + x3223 - x3224 - x3226 + x3234) + x120*(x3236 - x3237 + x3238 - x3239 + x3245) + x142*(x3246 - x3247 + x3248 - x3249 + x3258) + x190*x3289 + x192*x3289 + x194*x3289 + x212*x3290 + x214*x3290 + x216*x3290 + x3293, x100*(x2945*x3295 + x2947*x3296 + x3298 - x3299 + x3301 - x3302 + x3308) + x120*(-x3221 + x3226 + x3309 - x3310 + x3315) + x142*(x3295*x3317 + x3296*x3316 + x3318 - x3319 + x3320 - x3321 + x3328) + x190*x3343 + x192*x3343 + x194*x3343 + x212*x3344 + x214*x3344 + x216*x3344 + x3346, x100*(x3348 - x3349 + x3350 - x3351 + x3358) + x120*(x3359 - x3360 + x3361 - x3362 + x3368) + x142*(-x3223 + x3224 - x3309 + x3310 + x3371) + x190*x3374 + x192*x3374 + x194*x3374 + x212*x3375 + x214*x3375 + x216*x3375 + x3376, x190*x3377 + x192*x3377 + x194*x3377 + x212*x3379 + x214*x3379 + x216*x3379 + x760, x1369 + x190*x3380 + x192*x3380 + x194*x3380 + x212*x3381 + x214*x3381 + x216*x3381, x1709 + x190*x3382 + x192*x3382 + x194*x3382 + x212*x3383 + x214*x3383 + x216*x3383, x190*x3384 + x192*x3384 + x194*x3384 + x2045 + x212*x3385 + x214*x3385 + x216*x3385, x190*x3386 + x192*x3386 + x194*x3386 + x212*x3387 + x214*x3387 + x216*x3387 + x2362, x190*x3388 + x192*x3388 + x194*x3388 + x212*x3389 + x214*x3389 + x216*x3389 + x2634, x100*(x2904 + x3393 + x3395 - x3396 - x3398) + x120*(x2913 + x3399 + x3400 - x3402 - x3403) + x142*(x2921 + x3404 + x3406 - x3407 - x3408) + x190*x3409 + x192*x3409 + x194*x3409 + x212*x3410 + x214*x3410 + x216*x3410 + x2928, x100*(x3196 + x3412 + x3414 - x3415 - x3417) + x120*(x3202 + x3418 + x3419 - x3421 - x3422) + x142*(x3210 + x3423 + x3425 - x3426 - x3427) + x190*x3428 + x192*x3428 + x194*x3428 + x212*x3429 + x214*x3429 + x216*x3429 + x3219, x100*(x2807 + x3437 + x3439 - x3440 - x3442 + x3445) + x120*(x2819 + x3446 + x3447 - x3448 - x3449 + x3452) + x142*(x2836 + x3432 + x3434 - x3435 - x3436) + x190*x3459 + x192*x3459 + x194*x3459 + x212*x3456 + x214*x3456 + x216*x3456 + 2*x3453*x757 + 2*x3454*x752 + 2*x3455*x756, x100*(x3461 + x3463 - x3464 - x3466 + x3473) + x120*(x3475 - x3476 + x3477 - x3478 + x3485) + x142*(x3486 - x3487 + x3488 - x3489 + x3495) + x190*x3517 + x192*x3517 + x194*x3517 + x212*x3518 + x214*x3518 + x216*x3518 + x3524, x100*(x3526 - x3527 + x3529 - x3530 + x3537) + x120*(-x3461 + x3466 + x3538 - x3539 + x3544) + x142*(x3545 - x3546 + x3547 - x3548 + x3554) + x190*x3563 + x192*x3563 + x194*x3563 + x212*x3564 + x214*x3564 + x216*x3564 + x3566, x100*(x2962*x3568 + x2963*x3569 + x3571 - x3572 + x3573 - x3574 + x3580) + x120*(x3316*x3569 + x3317*x3568 + x3581 - x3582 + x3583 - x3584 + x3590) + x142*(-x3463 + x3464 - x3538 + x3539 + x3593) + x190*x3597 + x192*x3597 + x194*x3597 + x212*x3598 + x214*x3598 + x216*x3598 + x3599, x100*(x3603 + x3605 - x3606 - x3608 + x787) + x120*(x1484 + x3609 + x3610 - x3612 - x3613 + x807) + x142*(x1495 + x3614 + x3616 - x3617 - x3618 + x820) + x190*x3619 + x192*x3619 + x194*x3619 + x206*x3602 + x207*x3615 + x208*x3604 + x212*x3621 + x214*x3621 + x216*x3621 + 2*x225 + x946, x100*(x1384 + x3623 + x3625 - x3626 - x3628) + x120*(x1395 + x3629 + x3630 - x3632 - x3633) + x142*(x1408 + x3634 + x3636 - x3637 - x3638) + x1444 + x190*x3639 + x192*x3639 + x194*x3639 + x206*x3622 + x207*x3635 + x208*x3624 + x212*x3640 + x214*x3640 + x216*x3640, x100*(x1723 + x3642 + x3644 - x3645 - x3647) + x120*(x1735 + x3648 + x3649 - x3651 - x3652) + x142*(x1745 + x3653 + x3655 - x3656 - x3657) + x1774 + x190*x3658 + x192*x3658 + x194*x3658 + x206*x3641 + x207*x3654 + x208*x3643 + x212*x3659 + x214*x3659 + x216*x3659, x100*(x2059 + x3662 + x3664 - x3665 - x3667) + x120*(x2076 + x2476 + x3669 + x3670 - x3671 - x3672) + x142*(x2089 + x2485 + x3673 + x3674 - x3675 - x3676) + x190*x3677 + x192*x3677 + x194*x3677 + x212*x3678 + x2136 + x214*x3678 + x216*x3678, x100*(x2377 + x3680 + x3682 - x3683 - x3685) + x120*(x2388 + x3687 + x3688 - x3689 - x3690) + x142*(x2401 + x3691 + x3692 - x3693 - x3694) + x190*x3695 + x192*x3695 + x194*x3695 + x212*x3696 + x214*x3696 + x216*x3696 + x2436, x100*(x2648 + x3698 + x3700 - x3701 - x3703) + x120*(x2660 + x3705 + x3706 - x3707 - x3708) + x142*(x2670 + x3709 + x3710 - x3711 - x3712) + x190*x3713 + x192*x3713 + x194*x3713 + x212*x3714 + x214*x3714 + x216*x3714 + x2696, x100*(x2942 + x3717 + x3719 - x3720 - x3722) + x120*(x2961 + x3333 + x3723 + x3724 - x3726 - x3727) + x142*(x2976 + x3342 + x3728 + x3730 - x3731 - x3732) + x190*x3733 + x192*x3733 + x194*x3733 + x212*x3734 + x214*x3734 + x216*x3734 + x3023, x100*(x3234 + x3736 + x3738 - x3739 - x3741) + x120*(x3245 + x3742 + x3743 - x3745 - x3746) + x142*(x3258 + x3747 + x3749 - x3750 - x3751) + x190*x3752 + x192*x3752 + x194*x3752 + x212*x3753 + x214*x3753 + x216*x3753 + x3293, x100*(x3473 + x3755 + x3757 - x3758 - x3760) + x120*(x3485 + x3761 + x3762 - x3764 - x3765) + x142*(x3495 + x3766 + x3768 - x3769 - x3770) + x190*x3771 + x192*x3771 + x194*x3771 + x212*x3772 + x214*x3772 + x216*x3772 + x3524, x100*(x3774 + x3776 + x3778 + x3780 + x3782 + x3784 - x3786 - x3787 - x3788 - x3789 - x3791 - x3793 - x3795 - x3797 - x3799 + x3801 + x3803 + x3805 + x3806) + x120*(x2061*x399 + x2062*x2063 + x21*x764 + x2944*x2947 + x2945*x2946 + x36*x788 + x3808 + x3810 + x3812 - x3813 - x3814 - x3815 - x3816*x782 + x3816*x784 - x3817*x784 + x3817*x944 + x3818*x782 - x3818*x944 + x3819 + x3820 + x3821 - x3822 - x3823 - x3824 + x3825 + x3826) + x142*(x126*x764 + x128*x788 + x2061*x2077 + x2063*x409 + x2944*x2962 + x2946*x2963 - x3816*x775 + x3816*x778 + x3817*x775 - x3817*x942 - x3818*x778 + x3818*x942 + x3827 + x3828 + x3829 - x3830 - x3831 - x3832 + x3833 + x3834 + x3835 - x3836 - x3837 - x3838 + x3839 + x3840) + x144*x788 + x190*x3887 + x192*x3887 + x194*x3887 + x207*x3773 + x208*x3785 + x212*x3895 + x214*x3895 + x216*x3895 + x230 + x3807*x821 + x3841*x3891 + x3841*x934 + 2*x3888*x930 + x3889*x939 + x3890*x940 + x3892*x3893 + x3893*x3894 + x3896*x3897 + x3897*x3898 - 2*x933 - 2*x935, x100*(x3900 + x3902 + x3904 - x3905 - x3906 - x3907 + x3909 + x3911 + x3913 - x3914 - x3915 - x3917 + x3931) + x1050*x3601 + x120*(-x3774 - x3780 - x3782 + x3787 + x3788 + x3793 + x3932 + x3933 + x3934 - x3935 - x3936 - x3937 + x3945) + x142*(x3946 + x3947 + x3948 - x3949 - x3950 - x3951 + x3952 + x3953 + x3954 - x3955 - x3956 - x3957 + x3964) + x190*x3996 + x192*x3996 + x194*x3996 + x207*x3899 + x208*x3908 + x212*x3997 + x214*x3997 + x216*x3997 + x4003, x100*(x4005 + x4007 + x4009 - x4010 - x4011 - x4012 + x4013 + x4014 + x4015 - x4016 - x4017 - x4018 + x4032) + x120*(x4033 + x4034 + x4035 - x4036 - x4037 - x4038 + x4039 + x4040 + x4041 - x4042 - x4043 - x4044 + x4051) + x142*(-x3776 - x3778 - x3784 + x3786 + x3789 + x3791 - x3932 - x3933 - x3934 + x3935 + x3936 + x3937 + x4052) + x190*x4071 + x192*x4071 + x194*x4071 + x206*x3775 + x207*x3908 + x208*x4004 + x212*x4072 + x214*x4072 + x216*x4072 + x4073, x100*(x4077 + x4079 - x4080 - x4082 + x963) + x1072 + x120*(x4083 + x4084 - x4086 - x4087 + x974) + x142*(x4088 + x4090 - x4091 - x4092 + x989) + x190*x4093 + x192*x4093 + x194*x4093 + x206*x4076 + x207*x4089 + x208*x4078 + x212*x4095 + x214*x4095 + x216*x4095, x100*(x1461 + x4097 + x4099 - x4100 - x4102 + x865) + x120*(x1468 + x4103 + x4104 - x4106 - x4107) + x142*(x1479 + x4108 + x4110 - x4111 - x4112 + x919) + x1500 + x190*x4113 + x192*x4113 + x194*x4113 + x206*x4096 + x207*x4109 + x208*x4098 + x212*x4114 + x214*x4114 + x216*x4114 + 2*x227, x100*(x1787 + x4116 + x4118 - x4119 - x4121) + x120*(x1794 + x4122 + x4123 - x4125 - x4126) + x142*(x1804 + x4127 + x4129 - x4130 - x4131) + x1819 + x190*x4132 + x192*x4132 + x194*x4132 + x206*x4115 + x207*x4128 + x208*x4117 + x212*x4133 + x214*x4133 + x216*x4133, x100*(x2149 + x4136 + x4138 - x4139 - x4141) + x120*(x2158 + x4143 + x4144 - x4145 - x4146) + x142*(x2171 + x4147 + x4148 - x4149 - x4150) + x190*x4151 + x192*x4151 + x194*x4151 + x212*x4152 + x214*x4152 + x216*x4152 + x2195, x100*(x2104 + x2452 + x4154 + x4156 - x4157 - x4159) + x120*(x2459 + x4161 + x4162 - x4163 - x4164) + x142*(x2123 + x2471 + x4165 + x4166 - x4167 - x4168) + x190*x4169 + x192*x4169 + x194*x4169 + x212*x4170 + x214*x4170 + x216*x4170 + x2489, x100*(x2710 + x4172 + x4174 - x4175 - x4177) + x120*(x2717 + x4179 + x4180 - x4181 - x4182) + x142*(x2727 + x4183 + x4184 - x4185 - x4186) + x190*x4187 + x192*x4187 + x194*x4187 + x212*x4188 + x214*x4188 + x216*x4188 + x2739, x100*(x3035 + x4191 + x4193 - x4194 - x4196) + x120*(x3045 + x4197 + x4198 - x4200 - x4201) + x142*(x3059 + x4202 + x4204 - x4205 - x4206) + x190*x4207 + x192*x4207 + x194*x4207 + x212*x4208 + x214*x4208 + x216*x4208 + x3081, x100*(x2991 + x3308 + x4210 + x4212 - x4213 - x4215) + x120*(x3315 + x4216 + x4217 - x4219 - x4220) + x142*(x3010 + x3328 + x4221 + x4223 - x4224 - x4225) + x190*x4226 + x192*x4226 + x194*x4226 + x212*x4227 + x214*x4227 + x216*x4227 + x3346, x100*(x3537 + x4229 + x4231 - x4232 - x4234) + x120*(x3544 + x4235 + x4236 - x4238 - x4239) + x142*(x3554 + x4240 + x4242 - x4243 - x4244) + x190*x4245 + x192*x4245 + x194*x4245 + x212*x4246 + x214*x4246 + x216*x4246 + x3566, x100*(x3931 + x4248 + x4250 + x4252 + x4254 + x4256 + x4258 - x4260 - x4261 - x4262 - x4263 - x4265 - x4267) + x120*(x3945 + x4269 + x4271 + x4273 - x4274 - x4275 - x4276 + x4277 + x4278 + x4279 - x4280 - x4281 - x4282) + x142*(x3964 + x4283 + x4284 + x4285 - x4286 - x4287 - x4288 + x4289 + x4290 + x4291 - x4292 - x4293 - x4294) + x190*x4316 + x192*x4316 + x194*x4316 + x207*x4247 + x208*x4259 + x212*x4317 + x214*x4317 + x216*x4317 + x4003 + x4268*x821, x100*(-x1071*x4328 + x1071*x4329 + x1448*x36 + x1449*x21 + x2062*x2439 + x2438*x399 + x2945*x3296 + x2947*x3295 + x3806 + x4068 + x4319 + x4321 + x4323 - x4324 - x4325 - x4326 + x4327*x957 - x4327*x960 + x4328*x960 - x4329*x957 + x4331 + x4333 + x4335 - x4336 - x4337 - x4339) + x1050*x4075 + x1055*x3889 + x1057*x4358 + x1061*x4375 + x1067*x4376 + x120*(x3825 + x3972 + x3973 + x3974 - x3975 - x3976 - x3977 - x4248 - x4254 - x4256 + x4261 + x4262 + x4267 + x4340 + x4341 + x4342 - x4343 - x4344 - x4345) + x142*(x131*x1448 + x133*x1449 + x2438*x2460 + x2439*x405 + x3295*x3316 + x3296*x3317 + x3839 + x4059 + x4327*x775 - x4327*x778 - x4328*x775 + x4328*x942 + x4329*x778 - x4329*x942 + x4346 + x4347 + x4348 - x4349 - x4350 - x4351 + x4352 + x4353 + x4354 - x4355 - x4356 - x4357) + x1449*x226 - 2*x1498 - 2*x1499 + x190*x4374 + x192*x4374 + x194*x4374 + x207*x4318 + x208*x4330 + x212*x4381 + x214*x4381 + x216*x4381 + x230 + x4358*x4379 + x4375*x4382 + x4375*x4383 + x4377*x4378 + x4378*x4380, x100*(x4385 + x4387 + x4389 - x4390 - x4391 - x4392 + x4393 + x4394 + x4395 - x4396 - x4397 - x4398 + x4405) + x120*(x4406 + x4407 + x4408 - x4409 - x4410 - x4411 + x4412 + x4413 + x4414 - x4415 - x4416 - x4417 + x4418) + x142*(-x4250 - x4252 - x4258 + x4260 + x4263 + x4265 - x4340 - x4341 - x4342 + x4343 + x4344 + x4345 + x4419) + x190*x4423 + x192*x4423 + x194*x4423 + x206*x4249 + x207*x4330 + x208*x4384 + x212*x4424 + x214*x4424 + x216*x4424 + x4430, x100*(x1085 + x4434 + x4436 - x4437 - x4439) + x1160 + x120*(x1100 + x4440 + x4441 - x4443 - x4444) + x142*(x1104 + x4445 + x4447 - x4448 - x4449) + x190*x4450 + x192*x4450 + x194*x4450 + x206*x4433 + x207*x4446 + x208*x4435 + x212*x4452 + x214*x4452 + x216*x4452, x100*(x1512 + x4454 + x4456 - x4457 - x4459) + x120*(x1522 + x4460 + x4461 - x4463 - x4464) + x142*(x1525 + x4465 + x4467 - x4468 - x4469) + x1533 + x190*x4470 + x192*x4470 + x194*x4470 + x206*x4453 + x207*x4466 + x208*x4455 + x212*x4471 + x214*x4471 + x216*x4471, x100*(x1835 + x4473 + x4475 - x4476 - x4478 + x862) + x120*(x1845 + x4479 + x4480 - x4482 - x4483 + x925) + x142*(x1848 + x4484 + x4486 - x4487 - x4488) + x1860 + x190*x4489 + x192*x4489 + x194*x4489 + x206*x4472 + x207*x4485 + x208*x4474 + x212*x4490 + x214*x4490 + x216*x4490 + 2*x229, x100*(x2206 + x4493 + x4495 - x4496 - x4498) + x120*(x2218 + x4500 + x4501 - x4502 - x4503) + x142*(x2222 + x4504 + x4505 - x4506 - x4507) + x190*x4508 + x192*x4508 + x194*x4508 + x212*x4509 + x214*x4509 + x216*x4509 + x2233, x100*(x2501 + x4511 + x4513 - x4514 - x4516) + x120*(x2511 + x4518 + x4519 - x4520 - x4521) + x142*(x2514 + x4522 + x4523 - x4524 - x4525) + x190*x4526 + x192*x4526 + x194*x4526 + x212*x4527 + x214*x4527 + x216*x4527 + x2519, x100*(x2101 + x2753 + x4529 + x4531 - x4532 - x4534) + x120*(x2128 + x2763 + x4536 + x4537 - x4538 - x4539) + x142*(x2766 + x4540 + x4541 - x4542 - x4543) + x190*x4544 + x192*x4544 + x194*x4544 + x212*x4545 + x214*x4545 + x216*x4545 + x2772, x100*(x3092 + x4548 + x4550 - x4551 - x4553) + x120*(x3106 + x4554 + x4555 - x4557 - x4558) + x142*(x3110 + x4559 + x4561 - x4562 - x4563) + x190*x4564 + x192*x4564 + x194*x4564 + x212*x4565 + x214*x4565 + x216*x4565 + x3121, x100*(x3358 + x4567 + x4569 - x4570 - x4572) + x120*(x3368 + x4573 + x4574 - x4576 - x4577) + x142*(x3371 + x4578 + x4580 - x4581 - x4582) + x190*x4583 + x192*x4583 + x194*x4583 + x212*x4584 + x214*x4584 + x216*x4584 + x3376, x100*(x2988 + x3580 + x4586 + x4588 - x4589 - x4591) + x120*(x3015 + x3590 + x4592 + x4593 - x4595 - x4596) + x142*(x3593 + x4597 + x4599 - x4600 - x4601) + x190*x4602 + x192*x4602 + x194*x4602 + x212*x4603 + x214*x4603 + x216*x4603 + x3599, x100*(x4032 + x4605 + x4607 + x4609 + x4611 + x4613 + x4615 - x4617 - x4618 - x4619 - x4620 - x4622 - x4624) + x120*(x4051 + x4626 + x4628 + x4630 - x4631 - x4632 - x4633 + x4634 + x4635 + x4636 - x4637 - x4638 - x4639) + x142*(x4052 + x4640 + x4641 + x4642 - x4643 - x4644 - x4645 + x4646 + x4647 + x4648 - x4649 - x4650 - x4651) + x190*x4667 + x192*x4667 + x194*x4667 + x207*x4604 + x208*x4616 + x212*x4668 + x214*x4668 + x216*x4668 + x4073 + x4625*x821, x100*(x4405 + x4670 + x4672 + x4674 - x4675 - x4676 - x4677 + x4679 + x4681 + x4683 - x4684 - x4685 - x4687) + x1050*x4432 + x120*(x4418 - x4605 - x4611 - x4613 + x4618 + x4619 + x4624 + x4688 + x4689 + x4690 - x4691 - x4692 - x4693) + x142*(x4419 + x4694 + x4695 + x4696 - x4697 - x4698 - x4699 + x4700 + x4701 + x4702 - x4703 - x4704 - x4705) + x190*x4712 + x192*x4712 + x194*x4712 + x207*x4669 + x208*x4678 + x212*x4713 + x214*x4713 + x216*x4713 + x4430, x100*(x1071*x4724 - x1071*x4725 + x126*x1824 + x128*x1823 + x2077*x2742 + x2741*x409 + x2962*x3569 + x2963*x3568 + x3806 + x3992 + x4715 + x4717 + x4719 - x4720 - x4721 - x4722 - x4723*x957 + x4723*x960 - x4724*x960 + x4725*x957 + x4726 + x4727 + x4728 - x4729 - x4730 - x4731) + x1147*x3890 + 2*x1149*x1157 + x1153*x4748 + x1156*x4376 + 2*x1156*x4426 + x120*(x131*x1824 + x133*x1823 + x2460*x2741 + x2742*x405 + x3316*x3568 + x3317*x3569 + x3825 + x3971 + x4723*x782 - x4723*x784 + x4724*x784 - x4724*x944 - x4725*x782 + x4725*x944 + x4732 + x4733 + x4734 - x4735 - x4736 - x4737 + x4738 + x4739 + x4740 - x4741 - x4742 - x4743) + x142*(x3839 + x4060 + x4061 + x4062 - x4063 - x4064 - x4065 - x4607 - x4609 - x4615 + x4617 + x4620 + x4622 - x4688 - x4689 - x4690 + x4691 + x4692 + x4693) + x1824*x228 - 2*x1856 - 2*x1857 + x190*x4747 + x192*x4747 + x194*x4747 + x206*x4606 + x207*x4678 + x208*x4714 + x212*x4750 + x214*x4750 + x216*x4750 + x230 + x4425*x4749 + x4427*x4749 + x4428*x4748 + x4429*x4748], dtype=np.float64)


def q_ld(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Displacement"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -m1 + n1
    x3 = -m0 + n0
    x4 = -m2 + n2
    x5 = 1/mpmath.sqrt(x2**2 + x3**2 + x4**2)
    x6 = -p1*x4*x5 + p2*x2*x5
    x7 = -o1
    x8 = m1 + x7
    x9 = -o2
    x10 = m2 + x9
    x11 = x3*x5
    x12 = p0*x5
    x13 = p1*x11 - x12*x2
    x14 = -p2*x11 + x12*x4
    x15 = 1/mpmath.sqrt(x13**2 + x14**2 + x6**2)
    x16 = x15/mpmath.sqrt(x1**2 + x10**2 + x8**2)
    x17 = n0 + x0
    x18 = n1 + x7
    x19 = n2 + x9
    x20 = x15/mpmath.sqrt(x17**2 + x18**2 + x19**2)

    return x1*x16*x6 + x10*x13*x16 + x13*x19*x20 + x14*x16*x8 + x14*x18*x20 + x17*x20*x6


def dq_ld(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Displacement, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -m1
    x1 = n1 + x0
    x2 = -m0
    x3 = n0 + x2
    x4 = x3**2
    x5 = x1**2
    x6 = -m2
    x7 = n2 + x6
    x8 = x7**2
    x9 = x4 + x5 + x8
    x10 = 1/mpmath.sqrt(x9)
    x11 = p2*x10
    x12 = p1*x10
    x13 = x1*x11 - x12*x7
    x14 = -o0
    x15 = m0 + x14
    x16 = x15**2
    x17 = -o1
    x18 = m1 + x17
    x19 = x18**2
    x20 = -o2
    x21 = m2 + x20
    x22 = x21**2
    x23 = x16 + x19 + x22
    x24 = 1/mpmath.sqrt(x23)
    x25 = p0*x10
    x26 = -x1*x25 + x12*x3
    x27 = -x11*x3 + x25*x7
    x28 = x13**2 + x26**2 + x27**2
    x29 = 1/mpmath.sqrt(x28)
    x30 = x24*x29
    x31 = x13*x30
    x32 = o0 + x2
    x33 = x23**(mpmath.mpf(-3)/mpmath.mpf(2))
    x34 = x13*x29
    x35 = x33*x34
    x36 = x15*x35
    x37 = x27*x29
    x38 = x33*x37
    x39 = x18*x38
    x40 = x26*x29
    x41 = x33*x40
    x42 = x21*x41
    x43 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x44 = x3*x43
    x45 = x1*x44
    x46 = p2*x45
    x47 = x44*x7
    x48 = p1*x47
    x49 = x46 - x48
    x50 = x15*x30
    x51 = n0 + x14
    x52 = x51**2
    x53 = n1 + x17
    x54 = x53**2
    x55 = n2 + x20
    x56 = x55**2
    x57 = x52 + x54 + x56
    x58 = 1/mpmath.sqrt(x57)
    x59 = x29*x58
    x60 = x51*x59
    x61 = x4*x43
    x62 = p2*x61
    x63 = p0*x47
    x64 = x11 - x62 + x63
    x65 = x18*x30
    x66 = x53*x59
    x67 = -x12
    x68 = p1*x61
    x69 = p0*x45
    x70 = x67 + x68 - x69
    x71 = x21*x30
    x72 = x55*x59
    x73 = x28**(mpmath.mpf(-3)/mpmath.mpf(2))
    x74 = 2*x48
    x75 = 2*x46
    x76 = (mpmath.mpf(1)/mpmath.mpf(2))*x13
    x77 = 2*x12
    x78 = -x77
    x79 = (mpmath.mpf(1)/mpmath.mpf(2))*x26
    x80 = 2*x11
    x81 = (mpmath.mpf(1)/mpmath.mpf(2))*x27
    x82 = x73*(-x76*(-x74 + x75) - x79*(2*x68 - 2*x69 + x78) - x81*(-2*x62 + 2*x63 + x80))
    x83 = x24*x82
    x84 = x13*x15
    x85 = x18*x27
    x86 = x21*x26
    x87 = x58*x82
    x88 = x13*x51
    x89 = x27*x53
    x90 = x26*x55
    x91 = x27*x30
    x92 = o1 + x0
    x93 = x1*x43
    x94 = x7*x93
    x95 = p0*x94
    x96 = -x46 + x95
    x97 = x43*x5
    x98 = p0*x97
    x99 = p1*x45
    x100 = x25 - x98 + x99
    x101 = -x11
    x102 = p2*x97
    x103 = p1*x94
    x104 = x101 + x102 - x103
    x105 = 2*x95
    x106 = 2*x25
    x107 = -x80
    x108 = x73*(-x76*(2*x102 - 2*x103 + x107) - x79*(x106 - 2*x98 + 2*x99) - x81*(x105 - x75))
    x109 = x108*x24
    x110 = x108*x58
    x111 = x26*x30
    x112 = o2 + x6
    x113 = x48 - x95
    x114 = x43*x8
    x115 = p1*x114
    x116 = p2*x94
    x117 = -x115 + x116 + x12
    x118 = -x25
    x119 = p0*x114
    x120 = p2*x47
    x121 = x118 + x119 - x120
    x122 = -x106
    x123 = x73*(-x76*(-2*x115 + 2*x116 + x77) - x79*(-x105 + x74) - x81*(2*x119 - 2*x120 + x122))
    x124 = x123*x24
    x125 = x123*x58
    x126 = x13*x59
    x127 = x57**(mpmath.mpf(-3)/mpmath.mpf(2))
    x128 = x127*x34
    x129 = x127*x37
    x130 = x51*x53
    x131 = x127*x40
    x132 = x131*x55
    x133 = x27*x59
    x134 = x26*x59
    x135 = x128*x51
    x136 = x129*x53
    x137 = -n0
    x138 = o0 + x137
    x139 = m0 + x137
    x140 = p2*x139
    x141 = x140*x93
    x142 = p1*x139
    x143 = x43*x7
    x144 = x142*x143
    x145 = x141 - x144
    x146 = x142*x44
    x147 = p0*x139
    x148 = x147*x93
    x149 = x12 + x146 - x148
    x150 = x143*x147
    x151 = x140*x44
    x152 = x101 + x150 - x151
    x153 = x73*(-x76*(2*x141 - 2*x144) - x79*(2*x146 - 2*x148 + x77) - x81*(x107 + 2*x150 - 2*x151))
    x154 = x153*x24
    x155 = x153*x58
    x156 = -n1
    x157 = o1 + x156
    x158 = m1 + x156
    x159 = x143*x158
    x160 = p0*x159
    x161 = p2*x158
    x162 = x161*x44
    x163 = x160 - x162
    x164 = x161*x93
    x165 = p1*x159
    x166 = x11 + x164 - x165
    x167 = p1*x44
    x168 = x158*x167
    x169 = p0*x93
    x170 = x158*x169
    x171 = x118 + x168 - x170
    x172 = x73*(-x76*(2*x164 - 2*x165 + x80) - x79*(x122 + 2*x168 - 2*x170) - x81*(2*x160 - 2*x162))
    x173 = x172*x24
    x174 = x172*x58
    x175 = -n2
    x176 = o2 + x175
    x177 = m2 + x175
    x178 = x167*x177
    x179 = x169*x177
    x180 = x178 - x179
    x181 = x143*x177
    x182 = p0*x181
    x183 = p2*x177
    x184 = x183*x44
    x185 = x182 - x184 + x25
    x186 = x183*x93
    x187 = p1*x181
    x188 = x186 - x187 + x67
    x189 = x73*(-x76*(2*x186 - 2*x187 + x78) - x79*(2*x178 - 2*x179) - x81*(x106 + 2*x182 - 2*x184))
    x190 = x189*x24
    x191 = x189*x58

    return np.array([x31 + x32*x36 + x32*x39 + x32*x42 + x49*x50 + x49*x60 + x64*x65 + x64*x66 + x70*x71 + x70*x72 + x83*x84 + x83*x85 + x83*x86 + x87*x88 + x87*x89 + x87*x90, x100*x71 + x100*x72 + x104*x50 + x104*x60 + x109*x84 + x109*x85 + x109*x86 + x110*x88 + x110*x89 + x110*x90 + x36*x92 + x39*x92 + x42*x92 + x65*x96 + x66*x96 + x91, x111 + x112*x36 + x112*x39 + x112*x42 + x113*x71 + x113*x72 + x117*x50 + x117*x60 + x121*x65 + x121*x66 + x124*x84 + x124*x85 + x124*x86 + x125*x88 + x125*x89 + x125*x90, -x126 + x128*x52 + x129*x130 + x132*x51 + x15*x39 + x15*x42 + x16*x35 - x31, x128*x130 + x129*x54 + x132*x53 - x133 + x18*x36 + x18*x42 + x19*x38 - x91, -x111 + x131*x56 - x134 + x135*x55 + x136*x55 + x21*x36 + x21*x39 + x22*x41, x126 + x132*x138 + x135*x138 + x136*x138 + x145*x50 + x145*x60 + x149*x71 + x149*x72 + x152*x65 + x152*x66 + x154*x84 + x154*x85 + x154*x86 + x155*x88 + x155*x89 + x155*x90, x132*x157 + x133 + x135*x157 + x136*x157 + x163*x65 + x163*x66 + x166*x50 + x166*x60 + x171*x71 + x171*x72 + x173*x84 + x173*x85 + x173*x86 + x174*x88 + x174*x89 + x174*x90, x132*x176 + x134 + x135*x176 + x136*x176 + x180*x71 + x180*x72 + x185*x65 + x185*x66 + x188*x50 + x188*x60 + x190*x84 + x190*x85 + x190*x86 + x191*x88 + x191*x89 + x191*x90], dtype=np.float64)


def d2q_ld(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Displacement, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -m0
    x1 = n0 + x0
    x2 = -m1
    x3 = n1 + x2
    x4 = x1**2
    x5 = x3**2
    x6 = -m2
    x7 = n2 + x6
    x8 = x7**2
    x9 = x4 + x5 + x8
    x10 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x11 = p2*x10
    x12 = x11*x3
    x13 = x1*x12
    x14 = x10*x7
    x15 = p1*x14
    x16 = x1*x15
    x17 = x13 - x16
    x18 = -o0
    x19 = m0 + x18
    x20 = x19**2
    x21 = -o1
    x22 = m1 + x21
    x23 = x22**2
    x24 = -o2
    x25 = m2 + x24
    x26 = x25**2
    x27 = x20 + x23 + x26
    x28 = 1/mpmath.sqrt(x27)
    x29 = 1/mpmath.sqrt(x9)
    x30 = p1*x29
    x31 = x1*x30
    x32 = p0*x29
    x33 = x3*x32
    x34 = x31 - x33
    x35 = x32*x7
    x36 = p2*x29
    x37 = x1*x36
    x38 = x35 - x37
    x39 = x3*x36
    x40 = x30*x7
    x41 = x39 - x40
    x42 = x34**2 + x38**2 + x41**2
    x43 = 1/mpmath.sqrt(x42)
    x44 = x28*x43
    x45 = x17*x44
    x46 = x9**(mpmath.mpf(-5)/mpmath.mpf(2))
    x47 = 3*m0
    x48 = -x47
    x49 = 3*n0
    x50 = x46*(x48 + x49)
    x51 = x1*x50
    x52 = p2*x3
    x53 = x51*x52
    x54 = x51*x7
    x55 = p1*x54
    x56 = -x12
    x57 = x15 + x56
    x58 = x53 - x55 + x57
    x59 = x19*x44
    x60 = 2*m0
    x61 = 2*n0
    x62 = -x61
    x63 = x60 + x62
    x64 = x11*x63
    x65 = x4*x50
    x66 = p2*x65
    x67 = p0*x54
    x68 = x1*x11
    x69 = p0*x14
    x70 = -x69
    x71 = x68 + x70
    x72 = -x64 - x66 + x67 + x71
    x73 = x22*x44
    x74 = p1*x10
    x75 = x63*x74
    x76 = p1*x65
    x77 = p0*x3
    x78 = x51*x77
    x79 = x1*x74
    x80 = -x79
    x81 = p0*x10
    x82 = x3*x81
    x83 = x80 + x82
    x84 = x75 + x76 - x78 + x83
    x85 = x25*x44
    x86 = n0 + x18
    x87 = x86**2
    x88 = n1 + x21
    x89 = x88**2
    x90 = n2 + x24
    x91 = x90**2
    x92 = x87 + x89 + x91
    x93 = 1/mpmath.sqrt(x92)
    x94 = x43*x93
    x95 = x86*x94
    x96 = x88*x94
    x97 = x90*x94
    x98 = o0 + x0
    x99 = x27**(mpmath.mpf(-3)/mpmath.mpf(2))
    x100 = x43*x99
    x101 = x100*x41
    x102 = x101*x98
    x103 = 2*x16
    x104 = 2*x13
    x105 = -x103 + x104
    x106 = x105*x41
    x107 = 2*x30
    x108 = -x107
    x109 = x4*x74
    x110 = 2*x82
    x111 = -x1*x110 + x108 + 2*x109
    x112 = x111*x34
    x113 = 2*x36
    x114 = x11*x4
    x115 = 2*x69
    x116 = x1*x115 + x113 - 2*x114
    x117 = x116*x38
    x118 = -mpmath.mpf(1)/mpmath.mpf(2)*x106 - mpmath.mpf(1)/mpmath.mpf(2)*x112 - mpmath.mpf(1)/mpmath.mpf(2)*x117
    x119 = x42**(mpmath.mpf(-3)/mpmath.mpf(2))
    x120 = x119*x28
    x121 = x120*x41
    x122 = x118*x121
    x123 = (mpmath.mpf(1)/mpmath.mpf(2))*x16
    x124 = (mpmath.mpf(1)/mpmath.mpf(2))*x13
    x125 = x123 - x124
    x126 = (mpmath.mpf(1)/mpmath.mpf(2))*x30
    x127 = x1*x82
    x128 = -mpmath.mpf(1)/mpmath.mpf(2)*x109 + x126 + (mpmath.mpf(1)/mpmath.mpf(2))*x127
    x129 = (mpmath.mpf(1)/mpmath.mpf(2))*x36
    x130 = -x129
    x131 = x1*x69
    x132 = (mpmath.mpf(1)/mpmath.mpf(2))*x114 + x130 - mpmath.mpf(1)/mpmath.mpf(2)*x131
    x133 = -mpmath.mpf(1)/mpmath.mpf(2)*x39 + (mpmath.mpf(1)/mpmath.mpf(2))*x40
    x134 = 2*x55
    x135 = 2*x53
    x136 = 2*x12
    x137 = -x136
    x138 = 2*x15
    x139 = x137 + x138
    x140 = -mpmath.mpf(1)/mpmath.mpf(2)*x31 + (mpmath.mpf(1)/mpmath.mpf(2))*x33
    x141 = 2*x79
    x142 = -x141
    x143 = x110 + x142
    x144 = -mpmath.mpf(1)/mpmath.mpf(2)*x35 + (mpmath.mpf(1)/mpmath.mpf(2))*x37
    x145 = 2*x68
    x146 = -x115
    x147 = x145 + x146
    x148 = x105*x125 + x111*x128 + x116*x132 + x133*(-x134 + x135 + x139) + x140*(x143 + 2*x75 + 2*x76 - 2*x78) + x144*(x147 - 2*x64 - 2*x66 + 2*x67)
    x149 = x19*x41
    x150 = x120*x149
    x151 = x120*x38
    x152 = x151*x22
    x153 = x120*x34
    x154 = x153*x25
    x155 = x119*x93
    x156 = x155*x41
    x157 = x156*x86
    x158 = x155*x38
    x159 = x158*x88
    x160 = x155*x34
    x161 = x160*x90
    x162 = x100*x19
    x163 = x162*x98
    x164 = 2*x17
    x165 = x100*x22
    x166 = x165*x98
    x167 = -x114 + x131 + x36
    x168 = 2*x167
    x169 = x100*x25
    x170 = x169*x98
    x171 = -x30
    x172 = x109 - x127 + x171
    x173 = 2*x172
    x174 = x120*x19
    x175 = x118*x164
    x176 = x120*x22
    x177 = x118*x168
    x178 = x120*x25
    x179 = x118*x173
    x180 = x155*x86
    x181 = x155*x88
    x182 = x155*x90
    x183 = 3*o0
    x184 = x43/x27**(mpmath.mpf(5)/mpmath.mpf(2))
    x185 = x184*(x183 + x48)
    x186 = x185*x98
    x187 = x22*x38
    x188 = x25*x34
    x189 = x42**(mpmath.mpf(-5)/mpmath.mpf(2))
    x190 = x189*(-mpmath.mpf(3)/mpmath.mpf(2)*x106 - mpmath.mpf(3)/mpmath.mpf(2)*x112 - mpmath.mpf(3)/mpmath.mpf(2)*x117)
    x191 = x190*x28
    x192 = x149*x191
    x193 = x118*x38
    x194 = x193*x22
    x195 = x118*x34
    x196 = x191*x25
    x197 = x190*x93
    x198 = x41*x86
    x199 = x197*x198
    x200 = x197*x88
    x201 = x197*x90
    x202 = x118*x119
    x203 = x149*x99
    x204 = x202*x203
    x205 = 2*x98
    x206 = x119*x193
    x207 = x206*x99
    x208 = x207*x22
    x209 = x119*x195
    x210 = x25*x99
    x211 = x210*x98
    x212 = x100*x149
    x213 = x100*x38
    x214 = x213*x22
    x215 = x100*x34
    x216 = x215*x25
    x217 = -x212 - x214 - x216
    x218 = -x68
    x219 = x5*x50
    x220 = p2*x219
    x221 = x50*x7
    x222 = p1*x3
    x223 = x221*x222
    x224 = x218 + x220 - x223
    x225 = x221*x77
    x226 = x12 + x225 - x53
    x227 = p0*x219
    x228 = x222*x51
    x229 = x1*x81
    x230 = x3*x74
    x231 = -x230
    x232 = x229 + x231
    x233 = -x227 + x228 + x232
    x234 = x115*x3
    x235 = -x104 + x234
    x236 = -x113
    x237 = x11*x5
    x238 = -x138*x3 + x236 + 2*x237
    x239 = -x145
    x240 = 2*x225
    x241 = 2*x32
    x242 = x5*x81
    x243 = x141*x3 + x241 - 2*x242
    x244 = 2*x230
    x245 = -x244
    x246 = 2*x229
    x247 = x245 + x246
    x248 = x125*x238 + x128*x243 + x132*x235 + x133*(2*x220 - 2*x223 + x239) + x140*(-2*x227 + 2*x228 + x247) + x144*(-x135 + x136 + x240)
    x249 = o1 + x2
    x250 = x185*x249
    x251 = (mpmath.mpf(1)/mpmath.mpf(2))*x38
    x252 = (mpmath.mpf(1)/mpmath.mpf(2))*x34
    x253 = (mpmath.mpf(1)/mpmath.mpf(2))*x41
    x254 = -x235*x251 - x238*x253 - x243*x252
    x255 = x187*x191
    x256 = x254*x34
    x257 = x200*x38
    x258 = x167*x44
    x259 = -x36
    x260 = x15*x3
    x261 = x237 + x259 - x260
    x262 = x261*x44
    x263 = x213*x98
    x264 = x101*x249
    x265 = x120*x193
    x266 = x121*x254
    x267 = x162*x17
    x268 = x3*x69
    x269 = -x13 + x268
    x270 = x165*x167
    x271 = x3*x79
    x272 = -x242 + x271 + x32
    x273 = x169*x172
    x274 = x17*x254
    x275 = x118*x261
    x276 = x118*x269
    x277 = x167*x254
    x278 = x118*x272
    x279 = x172*x254
    x280 = x119*x254
    x281 = x280*x98
    x282 = x187*x99
    x283 = x119*x256
    x284 = x209*x210
    x285 = x163*x261 + x166*x269 + x170*x272 + x174*x274 + x174*x275 + x176*x276 + x176*x277 + x178*x278 + x178*x279 + x180*x274 + x180*x275 + x181*x276 + x181*x277 + x182*x278 + x182*x279 + x203*x281 + x204*x249 + x208*x249 + x211*x283 + x249*x267 + x249*x270 + x249*x273 + x249*x284 + x258 + x262 + x263 + x264 + x265 + x266 + x281*x282
    x286 = x50*x8
    x287 = p1*x286
    x288 = x221*x52
    x289 = -x287 + x288 + x79
    x290 = p0*x286
    x291 = p2*x54
    x292 = p2*x14
    x293 = -x229
    x294 = x292 + x293
    x295 = x290 - x291 + x294
    x296 = -x15
    x297 = -x225 + x296 + x55
    x298 = x103 - x234
    x299 = x74*x8
    x300 = x292*x3
    x301 = x107 - 2*x299 + 2*x300
    x302 = -x138
    x303 = -x241
    x304 = x8*x81
    x305 = x1*x292
    x306 = x303 + 2*x304 - 2*x305
    x307 = -x246
    x308 = 2*x292
    x309 = x307 + x308
    x310 = x125*x301 + x128*x298 + x132*x306 + x133*(x141 - 2*x287 + 2*x288) + x140*(x134 - x240 + x302) + x144*(2*x290 - 2*x291 + x309)
    x311 = o2 + x6
    x312 = x185*x311
    x313 = -x251*x306 - x252*x298 - x253*x301
    x314 = x313*x34
    x315 = -x299 + x30 + x300
    x316 = x315*x44
    x317 = x172*x44
    x318 = x215*x98
    x319 = x101*x311
    x320 = x120*x195
    x321 = x121*x313
    x322 = -x32
    x323 = x304 - x305 + x322
    x324 = x16 - x268
    x325 = x17*x313
    x326 = x118*x315
    x327 = x167*x313
    x328 = x118*x323
    x329 = x118*x324
    x330 = x172*x313
    x331 = x119*x313
    x332 = x331*x98
    x333 = x119*x314
    x334 = x163*x315 + x166*x323 + x170*x324 + x174*x325 + x174*x326 + x176*x327 + x176*x328 + x178*x329 + x178*x330 + x180*x325 + x180*x326 + x181*x327 + x181*x328 + x182*x329 + x182*x330 + x203*x332 + x204*x311 + x208*x311 + x211*x333 + x267*x311 + x270*x311 + x273*x311 + x282*x332 + x284*x311 + x316 + x317 + x318 + x319 + x320 + x321
    x335 = 2*o0
    x336 = -x335
    x337 = x20*x41
    x338 = x185*x19
    x339 = x17*x94
    x340 = x100*x20
    x341 = x92**(mpmath.mpf(-3)/mpmath.mpf(2))
    x342 = x341*x43
    x343 = x342*x87
    x344 = x118*x156
    x345 = x337*x99
    x346 = x41*x87
    x347 = x341*x346
    x348 = x162*x22
    x349 = x172*x25
    x350 = x342*x86
    x351 = x350*x88
    x352 = x172*x90
    x353 = x341*x86
    x354 = x206*x88
    x355 = x209*x90
    x356 = -x102 - x122 + x162*x349 + x167*x348 + x167*x351 + x17*x340 + x17*x343 + x19*x208 + x19*x284 + x202*x345 + x202*x347 + x214 + x216 - x339 - x344 + x350*x352 + x353*x354 + x353*x355 - x45
    x357 = x23*x38
    x358 = x185*x22
    x359 = x167*x94
    x360 = x100*x23
    x361 = x342*x89
    x362 = x101*x22
    x363 = x155*x193
    x364 = x341*x89
    x365 = x342*x88
    x366 = x341*x88
    x367 = x198*x202
    x368 = x165*x349 + x167*x360 + x167*x361 + x17*x351 + x204*x22 + x206*x364 + x207*x23 + x22*x267 + x22*x284 - x258 - x263 - x265 + x352*x365 + x355*x366 - x359 + x362 - x363 + x366*x367
    x369 = x26*x34
    x370 = x185*x25
    x371 = x172*x94
    x372 = x100*x26
    x373 = x342*x91
    x374 = x101*x25
    x375 = x155*x195
    x376 = x26*x99
    x377 = x341*x91
    x378 = x17*x350
    x379 = x167*x365
    x380 = x341*x90
    x381 = x172*x372 + x172*x373 + x204*x25 + x208*x25 + x209*x376 + x209*x377 + x25*x267 + x25*x270 - x317 - x318 - x320 + x354*x380 + x367*x380 - x371 + x374 - x375 + x378*x90 + x379*x90
    x382 = -n0
    x383 = m0 + x382
    x384 = x383*x50
    x385 = x384*x52
    x386 = x221*x383
    x387 = p1*x386
    x388 = x12 + x296
    x389 = x385 - x387 + x388
    x390 = p0*x386
    x391 = x383*x51
    x392 = p2*x391
    x393 = x11*x383
    x394 = x393 + x69
    x395 = x239 + x390 - x392 + x394
    x396 = p1*x391
    x397 = x384*x77
    x398 = -x82
    x399 = x383*x74
    x400 = -x399
    x401 = x398 + x400
    x402 = x141 + x396 - x397 + x401
    x403 = x136*x383 - x138*x383
    x404 = x107 - x110*x383 + x141*x383
    x405 = x115*x383 - x145*x383 + x236
    x406 = x136 + x302
    x407 = -x110
    x408 = 2*x399
    x409 = -x408
    x410 = x407 + x409
    x411 = 2*x393
    x412 = x115 + x411
    x413 = x125*x403 + x128*x404 + x132*x405 + x133*(2*x385 - 2*x387 + x406) + x140*(2*x396 - 2*x397 + x410 + 4*x79) + x144*(2*x390 - 2*x392 + x412 - 4*x68)
    x414 = -x251*x405 - x252*x404 - x253*x403
    x415 = x188*x191
    x416 = x201*x34
    x417 = x12*x383
    x418 = x15*x383
    x419 = x417 - x418
    x420 = x419*x44
    x421 = x121*x414
    x422 = x383*x69
    x423 = x383*x68
    x424 = x259 + x422 - x423
    x425 = x383*x79
    x426 = x383*x82
    x427 = x30 + x425 - x426
    x428 = x118*x419
    x429 = x17*x414
    x430 = x167*x414
    x431 = x118*x424
    x432 = x118*x427
    x433 = x172*x414
    x434 = o0 + x382
    x435 = x342*x352
    x436 = x119*x414
    x437 = x436*x98
    x438 = x188*x99
    x439 = x341*x434
    x440 = x163*x419 + x166*x424 + x170*x427 + x174*x428 + x174*x429 + x176*x430 + x176*x431 + x178*x432 + x178*x433 + x180*x428 + x180*x429 + x181*x430 + x181*x431 + x182*x432 + x182*x433 + x203*x437 + x282*x437 + x339 + x344 + x354*x439 + x355*x439 + x367*x439 + x378*x434 + x379*x434 + x420 + x421 + x434*x435 + x437*x438
    x441 = -n1
    x442 = m1 + x441
    x443 = x442*x50
    x444 = x443*x52
    x445 = x221*x442
    x446 = p1*x445
    x447 = x444 - x446 + x68
    x448 = x11*x442
    x449 = p0*x445
    x450 = x442*x51
    x451 = p2*x450
    x452 = x448 + x449 - x451
    x453 = p1*x450
    x454 = x443*x77
    x455 = x442*x74
    x456 = -x455
    x457 = x293 + x456
    x458 = x453 - x454 + x457
    x459 = x115*x442 - x145*x442
    x460 = x113 + x136*x442 - x138*x442
    x461 = 2*x448
    x462 = -x110*x442 + x141*x442 + x303
    x463 = 2*x455
    x464 = -x463
    x465 = x307 + x464
    x466 = x125*x460 + x128*x462 + x132*x459 + x133*(x145 + 2*x444 - 2*x446) + x140*(2*x453 - 2*x454 + x465) + x144*(2*x449 - 2*x451 + x461)
    x467 = -x251*x459 - x252*x462 - x253*x460
    x468 = x12*x442
    x469 = x15*x442
    x470 = x36 + x468 - x469
    x471 = x44*x470
    x472 = x121*x467
    x473 = x442*x69
    x474 = x442*x68
    x475 = x473 - x474
    x476 = x442*x79
    x477 = x442*x82
    x478 = x322 + x476 - x477
    x479 = x17*x467
    x480 = x118*x470
    x481 = x118*x475
    x482 = x167*x467
    x483 = x118*x478
    x484 = x172*x467
    x485 = o1 + x441
    x486 = x119*x467
    x487 = x486*x98
    x488 = x341*x485
    x489 = x163*x470 + x166*x475 + x170*x478 + x174*x479 + x174*x480 + x176*x481 + x176*x482 + x178*x483 + x178*x484 + x180*x479 + x180*x480 + x181*x481 + x181*x482 + x182*x483 + x182*x484 + x203*x487 + x282*x487 + x354*x488 + x355*x488 + x359 + x363 + x367*x488 + x378*x485 + x379*x485 + x435*x485 + x438*x487 + x471 + x472
    x490 = -n2
    x491 = m2 + x490
    x492 = x491*x50
    x493 = x492*x52
    x494 = x221*x491
    x495 = p1*x494
    x496 = x493 - x495 + x80
    x497 = p0*x494
    x498 = x491*x51
    x499 = p2*x498
    x500 = x11*x491
    x501 = x229 + x500
    x502 = x497 - x499 + x501
    x503 = x491*x74
    x504 = -x503
    x505 = p1*x498
    x506 = x492*x77
    x507 = x504 + x505 - x506
    x508 = -x110*x491 + x141*x491
    x509 = x108 + x136*x491 - x138*x491
    x510 = 2*x503
    x511 = -x510
    x512 = x115*x491 - x145*x491 + x241
    x513 = 2*x500
    x514 = x246 + x513
    x515 = x125*x509 + x128*x508 + x132*x512 + x133*(x142 + 2*x493 - 2*x495) + x140*(2*x505 - 2*x506 + x511) + x144*(2*x497 - 2*x499 + x514)
    x516 = -x251*x512 - x252*x508 - x253*x509
    x517 = x12*x491
    x518 = x15*x491
    x519 = x171 + x517 - x518
    x520 = x44*x519
    x521 = x121*x516
    x522 = x491*x69
    x523 = x491*x68
    x524 = x32 + x522 - x523
    x525 = x491*x79
    x526 = x491*x82
    x527 = x525 - x526
    x528 = x17*x516
    x529 = x118*x519
    x530 = x118*x524
    x531 = x167*x516
    x532 = x118*x527
    x533 = x172*x516
    x534 = o2 + x490
    x535 = x119*x516
    x536 = x535*x98
    x537 = x341*x534
    x538 = x163*x519 + x166*x524 + x170*x527 + x174*x528 + x174*x529 + x176*x530 + x176*x531 + x178*x532 + x178*x533 + x180*x528 + x180*x529 + x181*x530 + x181*x531 + x182*x532 + x182*x533 + x203*x536 + x282*x536 + x354*x537 + x355*x537 + x367*x537 + x371 + x375 + x378*x534 + x379*x534 + x435*x534 + x438*x536 + x520 + x521
    x539 = 3*m1
    x540 = -x539
    x541 = 3*n1
    x542 = x46*(x540 + x541)
    x543 = x1*x542
    x544 = x52*x543
    x545 = x543*x7
    x546 = p1*x545
    x547 = x218 + x544 - x546
    x548 = x4*x542
    x549 = p2*x548
    x550 = p0*x545
    x551 = x12 - x549 + x550
    x552 = p1*x548
    x553 = x543*x77
    x554 = x232 + x552 - x553
    x555 = (mpmath.mpf(1)/mpmath.mpf(2))*x268
    x556 = x124 - x555
    x557 = x129 - mpmath.mpf(1)/mpmath.mpf(2)*x237 + (mpmath.mpf(1)/mpmath.mpf(2))*x260
    x558 = 2*x546
    x559 = 2*x544
    x560 = (mpmath.mpf(1)/mpmath.mpf(2))*x32
    x561 = -x560
    x562 = (mpmath.mpf(1)/mpmath.mpf(2))*x242 - mpmath.mpf(1)/mpmath.mpf(2)*x271 + x561
    x563 = x105*x557 + x111*x562 + x116*x556 + x133*(x239 - x558 + x559) + x140*(x247 + 2*x552 - 2*x553) + x144*(x136 - 2*x549 + 2*x550)
    x564 = 3*o1
    x565 = x184*(x540 + x564)
    x566 = x565*x98
    x567 = (mpmath.mpf(3)/mpmath.mpf(2))*x38
    x568 = (mpmath.mpf(3)/mpmath.mpf(2))*x34
    x569 = (mpmath.mpf(3)/mpmath.mpf(2))*x41
    x570 = x189*(-x235*x567 - x238*x569 - x243*x568)
    x571 = x28*x570
    x572 = x149*x571
    x573 = x25*x571
    x574 = x570*x93
    x575 = x198*x574
    x576 = x574*x88
    x577 = x574*x90
    x578 = x269*x44
    x579 = 2*m1
    x580 = 2*n1
    x581 = -x580
    x582 = x579 + x581
    x583 = x11*x582
    x584 = x5*x542
    x585 = p2*x584
    x586 = x542*x7
    x587 = x222*x586
    x588 = x57 + x583 + x585 - x587
    x589 = x586*x77
    x590 = -x544 + x589 + x71
    x591 = x582*x81
    x592 = p0*x584
    x593 = x222*x543
    x594 = -x591 - x592 + x593 + x83
    x595 = x213*x249
    x596 = x151*x254
    x597 = 2*x589
    x598 = x133*(x139 + 2*x583 + 2*x585 - 2*x587) + x140*(x143 - 2*x591 - 2*x592 + 2*x593) + x144*(x147 - x559 + x597) + x235*x556 + x238*x557 + x243*x562
    x599 = x162*x249
    x600 = 2*x261
    x601 = x165*x249
    x602 = 2*x269
    x603 = x169*x249
    x604 = 2*x272
    x605 = x254*x600
    x606 = x254*x602
    x607 = x254*x604
    x608 = x249*x565
    x609 = x187*x571
    x610 = x38*x576
    x611 = x203*x280
    x612 = 2*x249
    x613 = x280*x282
    x614 = x210*x283
    x615 = x542*x8
    x616 = p1*x615
    x617 = x52*x586
    x618 = -x292
    x619 = x230 + x618
    x620 = -x616 + x617 + x619
    x621 = p0*x615
    x622 = p2*x545
    x623 = x398 + x621 - x622
    x624 = x546 - x589 + x69
    x625 = -x308
    x626 = x244 + x625
    x627 = x133*(-2*x616 + 2*x617 + x626) + x140*(x115 + x558 - x597) + x144*(x407 + 2*x621 - 2*x622) + x298*x562 + x301*x557 + x306*x556
    x628 = x311*x565
    x629 = x272*x44
    x630 = x323*x44
    x631 = x215*x249
    x632 = x213*x311
    x633 = x151*x313
    x634 = x120*x256
    x635 = x162*x261
    x636 = x165*x269
    x637 = x169*x311
    x638 = x254*x315
    x639 = x261*x313
    x640 = x269*x313
    x641 = x254*x323
    x642 = x254*x324
    x643 = x272*x313
    x644 = x249*x331
    x645 = x280*x311
    x646 = x210*x333
    x647 = x174*x638 + x174*x639 + x176*x640 + x176*x641 + x178*x642 + x178*x643 + x180*x638 + x180*x639 + x181*x640 + x181*x641 + x182*x642 + x182*x643 + x203*x644 + x203*x645 + x249*x646 + x272*x637 + x282*x644 + x282*x645 + x311*x614 + x311*x635 + x311*x636 + x315*x599 + x323*x601 + x324*x603 + x629 + x630 + x631 + x632 + x633 + x634
    x648 = x19*x565
    x649 = x261*x94
    x650 = x19*x213
    x651 = x156*x254
    x652 = x25*x272
    x653 = x272*x90
    x654 = x280*x38
    x655 = x353*x88
    x656 = x283*x90
    x657 = x162*x652 + x19*x613 + x19*x614 + x261*x340 + x261*x343 - x262 - x264 - x266 + x269*x348 + x269*x351 + x280*x345 + x280*x347 + x350*x653 + x353*x656 - x649 + x650 - x651 + x654*x655
    x658 = 2*o1
    x659 = -x658
    x660 = x22*x565
    x661 = x269*x94
    x662 = x158*x254
    x663 = x357*x99
    x664 = x364*x38
    x665 = x198*x280
    x666 = x165*x652 + x212 + x216 + x22*x611 + x22*x614 + x261*x348 + x261*x351 + x269*x360 + x269*x361 + x280*x663 + x280*x664 + x365*x653 + x366*x656 + x366*x665 - x578 - x595 - x596 - x661 - x662
    x667 = x25*x565
    x668 = x272*x94
    x669 = x213*x25
    x670 = x155*x256
    x671 = x261*x350
    x672 = x269*x365
    x673 = x366*x654
    x674 = x25*x611 + x25*x613 + x25*x635 + x25*x636 + x272*x372 + x272*x373 + x283*x376 + x283*x377 + x380*x665 - x629 - x631 - x634 - x668 + x669 - x670 + x671*x90 + x672*x90 + x673*x90
    x675 = -x393
    x676 = x383*x542
    x677 = x52*x676
    x678 = x383*x586
    x679 = p1*x678
    x680 = x675 + x677 - x679
    x681 = p0*x678
    x682 = x383*x543
    x683 = p2*x682
    x684 = x56 + x681 - x683
    x685 = p1*x682
    x686 = x676*x77
    x687 = x383*x81
    x688 = x230 + x687
    x689 = x685 - x686 + x688
    x690 = -x411
    x691 = 2*x687
    x692 = x244 + x691
    x693 = x133*(2*x677 - 2*x679 + x690) + x140*(2*x685 - 2*x686 + x692) + x144*(x137 + 2*x681 - 2*x683) + x403*x557 + x404*x562 + x405*x556
    x694 = x188*x571
    x695 = x34*x577
    x696 = x424*x44
    x697 = x151*x414
    x698 = x254*x419
    x699 = x261*x414
    x700 = x269*x414
    x701 = x254*x424
    x702 = x272*x414
    x703 = x254*x427
    x704 = x342*x653
    x705 = x249*x436
    x706 = x283*x380
    x707 = x174*x698 + x174*x699 + x176*x700 + x176*x701 + x178*x702 + x178*x703 + x180*x698 + x180*x699 + x181*x700 + x181*x701 + x182*x702 + x182*x703 + x203*x705 + x282*x705 + x419*x599 + x424*x601 + x427*x603 + x434*x671 + x434*x672 + x434*x673 + x434*x704 + x434*x706 + x438*x705 + x439*x665 + x649 + x651 + x696 + x697
    x708 = x442*x542
    x709 = x52*x708
    x710 = x442*x586
    x711 = p1*x710
    x712 = -x448
    x713 = x296 + x712
    x714 = x136 + x709 - x711 + x713
    x715 = p0*x710
    x716 = x442*x543
    x717 = p2*x716
    x718 = x218 + x69
    x719 = x715 - x717 + x718
    x720 = p1*x716
    x721 = x708*x77
    x722 = x442*x81
    x723 = x722 + x79
    x724 = x407 + x720 - x721 + x723
    x725 = x115 + x239
    x726 = 2*x722
    x727 = x141 + x726
    x728 = -x461
    x729 = x302 + x728
    x730 = x133*(4*x12 + 2*x709 - 2*x711 + x729) + x140*(2*x720 - 2*x721 + x727 - 4*x82) + x144*(2*x715 - 2*x717 + x725) + x459*x556 + x460*x557 + x462*x562
    x731 = x44*x475
    x732 = x151*x467
    x733 = x254*x470
    x734 = x261*x467
    x735 = x254*x475
    x736 = x269*x467
    x737 = x272*x467
    x738 = x254*x478
    x739 = x249*x486
    x740 = x174*x733 + x174*x734 + x176*x735 + x176*x736 + x178*x737 + x178*x738 + x180*x733 + x180*x734 + x181*x735 + x181*x736 + x182*x737 + x182*x738 + x203*x739 + x282*x739 + x438*x739 + x470*x599 + x475*x601 + x478*x603 + x485*x671 + x485*x672 + x485*x673 + x485*x704 + x485*x706 + x488*x665 + x661 + x662 + x731 + x732
    x741 = x491*x542
    x742 = x52*x741
    x743 = x491*x586
    x744 = p1*x743
    x745 = -x500
    x746 = x231 + x745
    x747 = x742 - x744 + x746
    x748 = p0*x743
    x749 = x491*x543
    x750 = p2*x749
    x751 = x748 - x750 + x82
    x752 = x491*x81
    x753 = p1*x749
    x754 = x741*x77
    x755 = x752 + x753 - x754
    x756 = 2*x752
    x757 = -x513
    x758 = x245 + x757
    x759 = x133*(2*x742 - 2*x744 + x758) + x140*(2*x753 - 2*x754 + x756) + x144*(x110 + 2*x748 - 2*x750) + x508*x562 + x509*x557 + x512*x556
    x760 = x44*x524
    x761 = x151*x516
    x762 = x254*x519
    x763 = x261*x516
    x764 = x269*x516
    x765 = x254*x524
    x766 = x254*x527
    x767 = x272*x516
    x768 = x249*x535
    x769 = x174*x762 + x174*x763 + x176*x764 + x176*x765 + x178*x766 + x178*x767 + x180*x762 + x180*x763 + x181*x764 + x181*x765 + x182*x766 + x182*x767 + x203*x768 + x282*x768 + x438*x768 + x519*x599 + x524*x601 + x527*x603 + x534*x671 + x534*x672 + x534*x673 + x534*x704 + x534*x706 + x537*x665 + x668 + x670 + x760 + x761
    x770 = 3*m2
    x771 = -x770
    x772 = 3*n2
    x773 = x46*(x771 + x772)
    x774 = x1*x773
    x775 = x52*x774
    x776 = x7*x774
    x777 = p1*x776
    x778 = x775 - x777 + x79
    x779 = x4*x773
    x780 = p2*x779
    x781 = p0*x776
    x782 = x294 - x780 + x781
    x783 = p1*x779
    x784 = x77*x774
    x785 = x296 + x783 - x784
    x786 = -x123 + x555
    x787 = -x126
    x788 = (mpmath.mpf(1)/mpmath.mpf(2))*x299 - mpmath.mpf(1)/mpmath.mpf(2)*x300 + x787
    x789 = 2*x777
    x790 = 2*x775
    x791 = -mpmath.mpf(1)/mpmath.mpf(2)*x304 + (mpmath.mpf(1)/mpmath.mpf(2))*x305 + x560
    x792 = x105*x788 + x111*x786 + x116*x791 + x133*(x141 - x789 + x790) + x140*(x302 + 2*x783 - 2*x784) + x144*(x309 - 2*x780 + 2*x781)
    x793 = 3*o2
    x794 = x184*(x771 + x793)
    x795 = x794*x98
    x796 = x189*(-x298*x568 - x301*x569 - x306*x567)
    x797 = x28*x796
    x798 = x149*x797
    x799 = x25*x797
    x800 = x796*x93
    x801 = x198*x800
    x802 = x800*x88
    x803 = x800*x90
    x804 = x5*x773
    x805 = p2*x804
    x806 = x7*x773
    x807 = x222*x806
    x808 = x619 + x805 - x807
    x809 = x77*x806
    x810 = x398 - x775 + x809
    x811 = p0*x804
    x812 = x222*x774
    x813 = x69 - x811 + x812
    x814 = 2*x809
    x815 = x133*(x626 + 2*x805 - 2*x807) + x140*(x115 - 2*x811 + 2*x812) + x144*(x407 - x790 + x814) + x235*x791 + x238*x788 + x243*x786
    x816 = x249*x794
    x817 = x187*x797
    x818 = x38*x802
    x819 = x324*x44
    x820 = 2*m2
    x821 = 2*n2
    x822 = -x821
    x823 = x820 + x822
    x824 = x74*x823
    x825 = x773*x8
    x826 = p1*x825
    x827 = x52*x806
    x828 = x57 - x824 - x826 + x827
    x829 = x81*x823
    x830 = p0*x825
    x831 = p2*x776
    x832 = x71 + x829 + x830 - x831
    x833 = x777 - x809 + x83
    x834 = x215*x311
    x835 = x120*x314
    x836 = x133*(x139 - 2*x824 - 2*x826 + 2*x827) + x140*(x143 + x789 - x814) + x144*(x147 + 2*x829 + 2*x830 - 2*x831) + x298*x786 + x301*x788 + x306*x791
    x837 = x162*x311
    x838 = 2*x315
    x839 = x165*x311
    x840 = 2*x323
    x841 = 2*x324
    x842 = x313*x838
    x843 = x313*x840
    x844 = x313*x841
    x845 = x311*x794
    x846 = x203*x331
    x847 = 2*x311
    x848 = x282*x331
    x849 = x19*x794
    x850 = x315*x94
    x851 = x19*x215
    x852 = x156*x313
    x853 = x25*x324
    x854 = x324*x90
    x855 = x331*x38
    x856 = x333*x90
    x857 = x162*x853 + x19*x646 + x19*x848 + x315*x340 + x315*x343 - x316 - x319 - x321 + x323*x348 + x323*x351 + x331*x345 + x331*x347 + x350*x854 + x353*x856 + x655*x855 - x850 + x851 - x852
    x858 = x22*x794
    x859 = x323*x94
    x860 = x215*x22
    x861 = x158*x313
    x862 = x198*x331
    x863 = x165*x853 + x22*x646 + x22*x846 + x315*x348 + x315*x351 + x323*x360 + x323*x361 + x331*x663 + x331*x664 + x365*x854 + x366*x856 + x366*x862 - x630 - x632 - x633 - x859 + x860 - x861
    x864 = 2*o2
    x865 = -x864
    x866 = x25*x794
    x867 = x324*x94
    x868 = x155*x314
    x869 = x162*x25
    x870 = x165*x25
    x871 = x315*x350
    x872 = x323*x365
    x873 = x366*x855
    x874 = x212 + x214 + x25*x846 + x25*x848 + x315*x869 + x323*x870 + x324*x372 + x324*x373 + x333*x376 + x333*x377 + x380*x862 - x819 - x834 - x835 - x867 - x868 + x871*x90 + x872*x90 + x873*x90
    x875 = x383*x773
    x876 = x52*x875
    x877 = x383*x806
    x878 = p1*x877
    x879 = x399 + x876 - x878
    x880 = p0*x877
    x881 = x383*x774
    x882 = p2*x881
    x883 = -x687
    x884 = x618 + x883
    x885 = x880 - x882 + x884
    x886 = p1*x881
    x887 = x77*x875
    x888 = x15 + x886 - x887
    x889 = -x691
    x890 = x625 + x889
    x891 = x133*(x408 + 2*x876 - 2*x878) + x140*(x138 + 2*x886 - 2*x887) + x144*(2*x880 - 2*x882 + x890) + x403*x788 + x404*x786 + x405*x791
    x892 = x188*x797
    x893 = x34*x803
    x894 = x427*x44
    x895 = x153*x414
    x896 = x313*x419
    x897 = x315*x414
    x898 = x323*x414
    x899 = x313*x424
    x900 = x324*x414
    x901 = x313*x427
    x902 = x342*x854
    x903 = x311*x436
    x904 = x333*x380
    x905 = x174*x896 + x174*x897 + x176*x898 + x176*x899 + x178*x900 + x178*x901 + x180*x896 + x180*x897 + x181*x898 + x181*x899 + x182*x900 + x182*x901 + x203*x903 + x282*x903 + x419*x837 + x424*x839 + x427*x637 + x434*x871 + x434*x872 + x434*x873 + x434*x902 + x434*x904 + x438*x903 + x439*x862 + x850 + x852 + x894 + x895
    x906 = x442*x773
    x907 = x52*x906
    x908 = x442*x806
    x909 = p1*x908
    x910 = x292 + x455
    x911 = x907 - x909 + x910
    x912 = -x722
    x913 = p0*x908
    x914 = x442*x774
    x915 = p2*x914
    x916 = x912 + x913 - x915
    x917 = p1*x914
    x918 = x77*x906
    x919 = x70 + x917 - x918
    x920 = -x726
    x921 = x308 + x463
    x922 = x133*(2*x907 - 2*x909 + x921) + x140*(x146 + 2*x917 - 2*x918) + x144*(2*x913 - 2*x915 + x920) + x459*x791 + x460*x788 + x462*x786
    x923 = x44*x478
    x924 = x153*x467
    x925 = x315*x467
    x926 = x313*x470
    x927 = x313*x475
    x928 = x323*x467
    x929 = x324*x467
    x930 = x313*x478
    x931 = x311*x486
    x932 = x174*x925 + x174*x926 + x176*x927 + x176*x928 + x178*x929 + x178*x930 + x180*x925 + x180*x926 + x181*x927 + x181*x928 + x182*x929 + x182*x930 + x203*x931 + x282*x931 + x438*x931 + x470*x837 + x475*x839 + x478*x637 + x485*x871 + x485*x872 + x485*x873 + x485*x902 + x485*x904 + x488*x862 + x859 + x861 + x923 + x924
    x933 = x491*x773
    x934 = x52*x933
    x935 = x491*x806
    x936 = p1*x935
    x937 = x12 + x503
    x938 = x302 + x934 - x936 + x937
    x939 = p0*x935
    x940 = x491*x774
    x941 = p2*x940
    x942 = -x752
    x943 = x218 + x942
    x944 = x115 + x939 - x941 + x943
    x945 = p1*x940
    x946 = x77*x933
    x947 = x398 + x79
    x948 = x945 - x946 + x947
    x949 = x141 + x407
    x950 = -x756
    x951 = x239 + x950
    x952 = x136 + x510
    x953 = x133*(-4*x15 + 2*x934 - 2*x936 + x952) + x140*(2*x945 - 2*x946 + x949) + x144*(4*x69 + 2*x939 - 2*x941 + x951) + x508*x786 + x509*x788 + x512*x791
    x954 = x44*x527
    x955 = x153*x516
    x956 = x315*x516
    x957 = x313*x519
    x958 = x313*x524
    x959 = x323*x516
    x960 = x313*x527
    x961 = x324*x516
    x962 = x311*x535
    x963 = x174*x956 + x174*x957 + x176*x958 + x176*x959 + x178*x960 + x178*x961 + x180*x956 + x180*x957 + x181*x958 + x181*x959 + x182*x960 + x182*x961 + x203*x962 + x282*x962 + x438*x962 + x519*x837 + x524*x839 + x527*x637 + x534*x871 + x534*x872 + x534*x873 + x534*x902 + x534*x904 + x537*x862 + x867 + x868 + x954 + x955
    x964 = -x183
    x965 = x184*(x47 + x964)
    x966 = x965*x98
    x967 = x249*x965
    x968 = x311*x965
    x969 = -x60
    x970 = x342*x41
    x971 = x43/x92**(mpmath.mpf(5)/mpmath.mpf(2))
    x972 = x971*(x49 + x964)
    x973 = x19*x965
    x974 = x86*x972
    x975 = x38*x88
    x976 = x34*x90
    x977 = x86*x970
    x978 = x342*x38
    x979 = x88*x978
    x980 = x34*x342
    x981 = x90*x980
    x982 = -x977 - x979 - x981
    x983 = x217 + x982
    x984 = x38*x89
    x985 = x22*x965
    x986 = x88*x972
    x987 = x86*x978
    x988 = x88*x970
    x989 = -x362 - x650 - x987 - x988
    x990 = x34*x91
    x991 = x25*x965
    x992 = x90*x972
    x993 = x86*x980
    x994 = x90*x970
    x995 = -x374 - x851 - x993 - x994
    x996 = x434*x972
    x997 = x419*x94
    x998 = x434*x970
    x999 = x156*x414
    x1000 = x350*x90
    x1001 = x19*x436
    x1002 = x38*x655
    x1003 = x353*x976
    x1004 = x1000*x427 + x1001*x282 + x1001*x438 + x1002*x436 + x1003*x436 + x340*x419 + x343*x419 + x345*x436 + x347*x436 + x348*x424 + x351*x424 - x420 - x421 + x427*x869 + x979 + x981 - x997 - x998 - x999
    x1005 = x485*x972
    x1006 = x470*x94
    x1007 = x485*x970
    x1008 = x156*x467
    x1009 = x19*x486
    x1010 = x1000*x478 + x1002*x486 + x1003*x486 - x1006 - x1007 - x1008 + x1009*x282 + x1009*x438 + x340*x470 + x343*x470 + x345*x486 + x347*x486 + x348*x475 + x351*x475 - x471 - x472 + x478*x869 + x987
    x1011 = x534*x972
    x1012 = x519*x94
    x1013 = x534*x970
    x1014 = x156*x516
    x1015 = x19*x535
    x1016 = x1000*x527 + x1002*x535 + x1003*x535 - x1012 - x1013 - x1014 + x1015*x282 + x1015*x438 + x340*x519 + x343*x519 + x345*x535 + x347*x535 + x348*x524 + x351*x524 - x520 - x521 + x527*x869 + x993
    x1017 = -x564
    x1018 = x184*(x1017 + x539)
    x1019 = x1018*x98
    x1020 = x1018*x249
    x1021 = x1018*x311
    x1022 = x971*(x1017 + x541)
    x1023 = x1018*x19
    x1024 = x1022*x86
    x1025 = -x579
    x1026 = x1018*x22
    x1027 = x1022*x88
    x1028 = x1018*x25
    x1029 = x1022*x90
    x1030 = x88*x980
    x1031 = x90*x978
    x1032 = -x1030 - x1031 - x669 - x860
    x1033 = x1022*x434
    x1034 = x424*x94
    x1035 = x434*x978
    x1036 = x158*x414
    x1037 = x365*x90
    x1038 = x22*x436
    x1039 = x366*x436
    x1040 = -x1034 - x1035 - x1036 + x1037*x427 + x1038*x203 + x1038*x438 + x1039*x198 + x1039*x976 + x348*x419 + x351*x419 + x360*x424 + x361*x424 + x427*x870 + x436*x663 + x436*x664 - x696 - x697 + x988
    x1041 = x1022*x485
    x1042 = x475*x94
    x1043 = x485*x978
    x1044 = x158*x467
    x1045 = x22*x486
    x1046 = x366*x486
    x1047 = x1037*x478 - x1042 - x1043 - x1044 + x1045*x203 + x1045*x438 + x1046*x198 + x1046*x976 + x348*x470 + x351*x470 + x360*x475 + x361*x475 + x478*x870 + x486*x663 + x486*x664 - x731 - x732 + x977 + x981
    x1048 = x1022*x534
    x1049 = x524*x94
    x1050 = x534*x978
    x1051 = x158*x516
    x1052 = x22*x535
    x1053 = x366*x535
    x1054 = x1030 + x1037*x527 - x1049 - x1050 - x1051 + x1052*x203 + x1052*x438 + x1053*x198 + x1053*x976 + x348*x519 + x351*x519 + x360*x524 + x361*x524 + x527*x870 + x535*x663 + x535*x664 - x760 - x761
    x1055 = -x793
    x1056 = x184*(x1055 + x770)
    x1057 = x1056*x98
    x1058 = x1056*x249
    x1059 = x1056*x311
    x1060 = x971*(x1055 + x772)
    x1061 = x1056*x19
    x1062 = x1060*x86
    x1063 = x1056*x22
    x1064 = x1060*x88
    x1065 = -x820
    x1066 = x1056*x25
    x1067 = x1060*x90
    x1068 = x1060*x434
    x1069 = x427*x94
    x1070 = x434*x980
    x1071 = x160*x414
    x1072 = x369*x99
    x1073 = x34*x377
    x1074 = x25*x436
    x1075 = x198*x380
    x1076 = x38*x90
    x1077 = x1000*x419 + x1037*x424 + x1039*x1076 - x1069 - x1070 - x1071 + x1072*x436 + x1073*x436 + x1074*x203 + x1074*x282 + x1075*x436 + x372*x427 + x373*x427 + x419*x869 + x424*x870 - x894 - x895 + x994
    x1078 = x1060*x485
    x1079 = x478*x94
    x1080 = x485*x980
    x1081 = x160*x467
    x1082 = x25*x486
    x1083 = x1000*x470 + x1031 + x1037*x475 + x1046*x1076 + x1072*x486 + x1073*x486 + x1075*x486 - x1079 - x1080 - x1081 + x1082*x203 + x1082*x282 + x372*x478 + x373*x478 + x470*x869 + x475*x870 - x923 - x924
    x1084 = x1060*x534
    x1085 = x527*x94
    x1086 = x534*x980
    x1087 = x160*x516
    x1088 = x25*x535
    x1089 = x1000*x519 + x1037*x524 + x1053*x1076 + x1072*x535 + x1073*x535 + x1075*x535 - x1085 - x1086 - x1087 + x1088*x203 + x1088*x282 + x372*x527 + x373*x527 + x519*x869 + x524*x870 - x954 - x955 + x977 + x979
    x1090 = -x49
    x1091 = x46*(x1090 + x47)
    x1092 = x1*x1091
    x1093 = x1092*x52
    x1094 = x1092*x7
    x1095 = p1*x1094
    x1096 = x1093 - x1095 + x388
    x1097 = x61 + x969
    x1098 = x1097*x11
    x1099 = x1091*x4
    x1100 = p2*x1099
    x1101 = p0*x1094
    x1102 = -x1098 - x1100 + x1101 + x394
    x1103 = x1097*x74
    x1104 = p1*x1099
    x1105 = x1092*x77
    x1106 = x1103 + x1104 - x1105 + x401
    x1107 = -mpmath.mpf(1)/mpmath.mpf(2)*x417 + (mpmath.mpf(1)/mpmath.mpf(2))*x418
    x1108 = -mpmath.mpf(1)/mpmath.mpf(2)*x425 + (mpmath.mpf(1)/mpmath.mpf(2))*x426 + x787
    x1109 = x129 - mpmath.mpf(1)/mpmath.mpf(2)*x422 + (mpmath.mpf(1)/mpmath.mpf(2))*x423
    x1110 = 2*x1095
    x1111 = 2*x1093
    x1112 = x105*x1107 + x1108*x111 + x1109*x116 + x133*(-x1110 + x1111 + x406) + x140*(2*x1103 + 2*x1104 - 2*x1105 + x410) + x144*(-2*x1098 - 2*x1100 + 2*x1101 + x412)
    x1113 = x189*(-x403*x569 - x404*x568 - x405*x567)
    x1114 = x1113*x28
    x1115 = x1114*x149
    x1116 = x1114*x25
    x1117 = x1113*x93
    x1118 = x1117*x198
    x1119 = x193*x88
    x1120 = x1117*x90
    x1121 = x1091*x5
    x1122 = p2*x1121
    x1123 = x1091*x7
    x1124 = x1123*x222
    x1125 = x1122 - x1124 + x675
    x1126 = x1123*x77
    x1127 = -x1093 + x1126 + x56
    x1128 = p0*x1121
    x1129 = x1092*x222
    x1130 = -x1128 + x1129 + x688
    x1131 = 2*x1126
    x1132 = x1107*x238 + x1108*x243 + x1109*x235 + x133*(2*x1122 - 2*x1124 + x690) + x140*(-2*x1128 + 2*x1129 + x692) + x144*(-x1111 + x1131 + x137)
    x1133 = x1114*x187
    x1134 = x1117*x975
    x1135 = x1091*x8
    x1136 = p1*x1135
    x1137 = x1123*x52
    x1138 = -x1136 + x1137 + x399
    x1139 = p0*x1135
    x1140 = p2*x1094
    x1141 = x1139 - x1140 + x884
    x1142 = x1095 - x1126 + x15
    x1143 = x1107*x301 + x1108*x298 + x1109*x306 + x133*(-2*x1136 + 2*x1137 + x408) + x140*(x1110 - x1131 + x138) + x144*(2*x1139 - 2*x1140 + x890)
    x1144 = x971*(x1090 + x183)
    x1145 = x1144*x86
    x1146 = x1144*x88
    x1147 = x1144*x90
    x1148 = x1091*x383
    x1149 = x1148*x52
    x1150 = x1123*x383
    x1151 = p1*x1150
    x1152 = x1149 - x1151 + x57
    x1153 = p0*x1150
    x1154 = x1092*x383
    x1155 = p2*x1154
    x1156 = x1153 - x1155 + x690 + x71
    x1157 = p1*x1154
    x1158 = x1148*x77
    x1159 = x1157 - x1158 + x408 + x83
    x1160 = x1107*x403 + x1108*x404 + x1109*x405 + x133*(2*x1149 - 2*x1151 + x139) + x140*(2*x1157 - 2*x1158 + x143 + 4*x399) + x144*(2*x1153 - 2*x1155 + x147 - 4*x393)
    x1161 = 2*x414
    x1162 = x1161*x419
    x1163 = x1161*x424
    x1164 = x1161*x427
    x1165 = x350*x434
    x1166 = x365*x434
    x1167 = x342*x90
    x1168 = x1167*x434
    x1169 = x1114*x188
    x1170 = x1144*x434
    x1171 = x1117*x976
    x1172 = x198*x439
    x1173 = 2*x436
    x1174 = x38*x434
    x1175 = x34*x380
    x1176 = x1175*x434
    x1177 = x1091*x442
    x1178 = x1177*x52
    x1179 = x1123*x442
    x1180 = p1*x1179
    x1181 = x1178 - x1180 + x393
    x1182 = p0*x1179
    x1183 = x1092*x442
    x1184 = p2*x1183
    x1185 = x1182 - x1184 + x712
    x1186 = p1*x1183
    x1187 = x1177*x77
    x1188 = x455 + x883
    x1189 = x1186 - x1187 + x1188
    x1190 = x463 + x889
    x1191 = x1107*x460 + x1108*x462 + x1109*x459 + x133*(2*x1178 - 2*x1180 + x411) + x140*(2*x1186 - 2*x1187 + x1190) + x144*(2*x1182 - 2*x1184 + x728)
    x1192 = x1144*x485
    x1193 = x419*x467
    x1194 = x414*x470
    x1195 = x414*x475
    x1196 = x424*x467
    x1197 = x427*x467
    x1198 = x414*x478
    x1199 = x350*x419
    x1200 = x365*x424
    x1201 = x1167*x427
    x1202 = x198*x436
    x1203 = x1039*x38
    x1204 = x1175*x436
    x1205 = x1006 + x1007 + x1008 + x1034 + x1035 + x1036 + x1046*x1174 + x1165*x470 + x1166*x475 + x1168*x478 + x1172*x486 + x1176*x486 + x1193*x174 + x1193*x180 + x1194*x174 + x1194*x180 + x1195*x176 + x1195*x181 + x1196*x176 + x1196*x181 + x1197*x178 + x1197*x182 + x1198*x178 + x1198*x182 + x1199*x485 + x1200*x485 + x1201*x485 + x1202*x488 + x1203*x485 + x1204*x485
    x1206 = x1091*x491
    x1207 = x1206*x52
    x1208 = x1123*x491
    x1209 = p1*x1208
    x1210 = x1207 - x1209 + x400
    x1211 = p0*x1208
    x1212 = x1092*x491
    x1213 = p2*x1212
    x1214 = x687 + x745
    x1215 = x1211 - x1213 + x1214
    x1216 = p1*x1212
    x1217 = x1206*x77
    x1218 = x1216 - x1217 + x503
    x1219 = x691 + x757
    x1220 = x1107*x509 + x1108*x508 + x1109*x512 + x133*(2*x1207 - 2*x1209 + x409) + x140*(2*x1216 - 2*x1217 + x510) + x144*(2*x1211 - 2*x1213 + x1219)
    x1221 = x1144*x534
    x1222 = x419*x516
    x1223 = x414*x519
    x1224 = x414*x524
    x1225 = x424*x516
    x1226 = x414*x527
    x1227 = x427*x516
    x1228 = x1012 + x1013 + x1014 + x1053*x1174 + x1069 + x1070 + x1071 + x1165*x519 + x1166*x524 + x1168*x527 + x1172*x535 + x1176*x535 + x1199*x534 + x1200*x534 + x1201*x534 + x1202*x537 + x1203*x534 + x1204*x534 + x1222*x174 + x1222*x180 + x1223*x174 + x1223*x180 + x1224*x176 + x1224*x181 + x1225*x176 + x1225*x181 + x1226*x178 + x1226*x182 + x1227*x178 + x1227*x182
    x1229 = -x541
    x1230 = x46*(x1229 + x539)
    x1231 = x1*x1230
    x1232 = x1231*x52
    x1233 = x1231*x7
    x1234 = p1*x1233
    x1235 = x1232 - x1234 + x68
    x1236 = x1230*x4
    x1237 = p2*x1236
    x1238 = p0*x1233
    x1239 = -x1237 + x1238 + x448
    x1240 = p1*x1236
    x1241 = x1231*x77
    x1242 = x1240 - x1241 + x457
    x1243 = -mpmath.mpf(1)/mpmath.mpf(2)*x473 + (mpmath.mpf(1)/mpmath.mpf(2))*x474
    x1244 = x130 - mpmath.mpf(1)/mpmath.mpf(2)*x468 + (mpmath.mpf(1)/mpmath.mpf(2))*x469
    x1245 = 2*x1234
    x1246 = 2*x1232
    x1247 = -mpmath.mpf(1)/mpmath.mpf(2)*x476 + (mpmath.mpf(1)/mpmath.mpf(2))*x477 + x560
    x1248 = x105*x1244 + x111*x1247 + x116*x1243 + x133*(-x1245 + x1246 + x145) + x140*(2*x1240 - 2*x1241 + x465) + x144*(-2*x1237 + 2*x1238 + x461)
    x1249 = x189*(-x459*x567 - x460*x569 - x462*x568)
    x1250 = x1249*x28
    x1251 = x1250*x149
    x1252 = x1250*x25
    x1253 = x1249*x93
    x1254 = x1253*x198
    x1255 = x1253*x90
    x1256 = x1025 + x580
    x1257 = x11*x1256
    x1258 = x1230*x5
    x1259 = p2*x1258
    x1260 = x1230*x7
    x1261 = x1260*x222
    x1262 = x1257 + x1259 - x1261 + x713
    x1263 = x1260*x77
    x1264 = -x1232 + x1263 + x718
    x1265 = x1256*x81
    x1266 = p0*x1258
    x1267 = x1231*x222
    x1268 = -x1265 - x1266 + x1267 + x723
    x1269 = 2*x1263
    x1270 = x1243*x235 + x1244*x238 + x1247*x243 + x133*(2*x1257 + 2*x1259 - 2*x1261 + x729) + x140*(-2*x1265 - 2*x1266 + 2*x1267 + x727) + x144*(-x1246 + x1269 + x725)
    x1271 = x1250*x187
    x1272 = x1253*x975
    x1273 = x1230*x8
    x1274 = p1*x1273
    x1275 = x1260*x52
    x1276 = -x1274 + x1275 + x910
    x1277 = p0*x1273
    x1278 = p2*x1233
    x1279 = x1277 - x1278 + x912
    x1280 = x1234 - x1263 + x70
    x1281 = x1243*x306 + x1244*x301 + x1247*x298 + x133*(-2*x1274 + 2*x1275 + x921) + x140*(x1245 - x1269 + x146) + x144*(2*x1277 - 2*x1278 + x920)
    x1282 = x971*(x1229 + x564)
    x1283 = x1282*x86
    x1284 = x1282*x88
    x1285 = x1282*x90
    x1286 = x1230*x383
    x1287 = x1286*x52
    x1288 = x1260*x383
    x1289 = p1*x1288
    x1290 = x1287 - x1289 + x393
    x1291 = p0*x1288
    x1292 = x1231*x383
    x1293 = p2*x1292
    x1294 = x1291 - x1293 + x712
    x1295 = p1*x1292
    x1296 = x1286*x77
    x1297 = x1188 + x1295 - x1296
    x1298 = x1243*x405 + x1244*x403 + x1247*x404 + x133*(2*x1287 - 2*x1289 + x411) + x140*(x1190 + 2*x1295 - 2*x1296) + x144*(2*x1291 - 2*x1293 + x728)
    x1299 = x1250*x188
    x1300 = x1282*x434
    x1301 = x1253*x976
    x1302 = x1230*x442
    x1303 = x1302*x52
    x1304 = x1260*x442
    x1305 = p1*x1304
    x1306 = x1303 - x1305 + x461 + x57
    x1307 = p0*x1304
    x1308 = x1231*x442
    x1309 = p2*x1308
    x1310 = x1307 - x1309 + x71
    x1311 = p1*x1308
    x1312 = x1302*x77
    x1313 = x1311 - x1312 + x83 + x920
    x1314 = x1243*x459 + x1244*x460 + x1247*x462 + x133*(2*x1303 - 2*x1305 + x139 + 4*x448) + x140*(2*x1311 - 2*x1312 + x143 - 4*x722) + x144*(2*x1307 - 2*x1309 + x147)
    x1315 = 2*x467
    x1316 = x1315*x470
    x1317 = x1315*x475
    x1318 = x1315*x478
    x1319 = x350*x485
    x1320 = x365*x485
    x1321 = x1167*x485
    x1322 = x1282*x485
    x1323 = x198*x488
    x1324 = 2*x486
    x1325 = x38*x485
    x1326 = x1175*x485
    x1327 = x1230*x491
    x1328 = x1327*x52
    x1329 = x1260*x491
    x1330 = p1*x1329
    x1331 = x456 + x500
    x1332 = x1328 - x1330 + x1331
    x1333 = p0*x1329
    x1334 = x1231*x491
    x1335 = p2*x1334
    x1336 = x1333 - x1335 + x722
    x1337 = p1*x1334
    x1338 = x1327*x77
    x1339 = x1337 - x1338 + x942
    x1340 = x464 + x513
    x1341 = x1243*x512 + x1244*x509 + x1247*x508 + x133*(2*x1328 - 2*x1330 + x1340) + x140*(2*x1337 - 2*x1338 + x950) + x144*(2*x1333 - 2*x1335 + x726)
    x1342 = x1282*x534
    x1343 = x470*x516
    x1344 = x467*x519
    x1345 = x475*x516
    x1346 = x467*x524
    x1347 = x467*x527
    x1348 = x478*x516
    x1349 = x350*x534
    x1350 = x365*x534
    x1351 = x1167*x534
    x1352 = x198*x537
    x1353 = x38*x534
    x1354 = x1175*x534
    x1355 = x1046*x1353 + x1049 + x1050 + x1051 + x1053*x1325 + x1079 + x1080 + x1081 + x1319*x519 + x1320*x524 + x1321*x527 + x1323*x535 + x1326*x535 + x1343*x174 + x1343*x180 + x1344*x174 + x1344*x180 + x1345*x176 + x1345*x181 + x1346*x176 + x1346*x181 + x1347*x178 + x1347*x182 + x1348*x178 + x1348*x182 + x1349*x470 + x1350*x475 + x1351*x478 + x1352*x486 + x1354*x486
    x1356 = -x772
    x1357 = x46*(x1356 + x770)
    x1358 = x1*x1357
    x1359 = x1358*x52
    x1360 = x1358*x7
    x1361 = p1*x1360
    x1362 = x1359 - x1361 + x80
    x1363 = x1357*x4
    x1364 = p2*x1363
    x1365 = p0*x1360
    x1366 = -x1364 + x1365 + x501
    x1367 = p1*x1363
    x1368 = x1358*x77
    x1369 = x1367 - x1368 + x504
    x1370 = -mpmath.mpf(1)/mpmath.mpf(2)*x525 + (mpmath.mpf(1)/mpmath.mpf(2))*x526
    x1371 = x126 - mpmath.mpf(1)/mpmath.mpf(2)*x517 + (mpmath.mpf(1)/mpmath.mpf(2))*x518
    x1372 = 2*x1361
    x1373 = 2*x1359
    x1374 = -mpmath.mpf(1)/mpmath.mpf(2)*x522 + (mpmath.mpf(1)/mpmath.mpf(2))*x523 + x561
    x1375 = x105*x1371 + x111*x1370 + x116*x1374 + x133*(-x1372 + x1373 + x142) + x140*(2*x1367 - 2*x1368 + x511) + x144*(-2*x1364 + 2*x1365 + x514)
    x1376 = x189*(-x508*x568 - x509*x569 - x512*x567)
    x1377 = x1376*x28
    x1378 = x1377*x149
    x1379 = x1377*x25
    x1380 = x1376*x93
    x1381 = x1380*x198
    x1382 = x1380*x90
    x1383 = x1357*x5
    x1384 = p2*x1383
    x1385 = x1357*x7
    x1386 = x1385*x222
    x1387 = x1384 - x1386 + x746
    x1388 = x1385*x77
    x1389 = -x1359 + x1388 + x82
    x1390 = p0*x1383
    x1391 = x1358*x222
    x1392 = -x1390 + x1391 + x752
    x1393 = 2*x1388
    x1394 = x133*(2*x1384 - 2*x1386 + x758) + x1370*x243 + x1371*x238 + x1374*x235 + x140*(-2*x1390 + 2*x1391 + x756) + x144*(x110 - x1373 + x1393)
    x1395 = x1377*x187
    x1396 = x1380*x975
    x1397 = x1065 + x821
    x1398 = x1397*x74
    x1399 = x1357*x8
    x1400 = p1*x1399
    x1401 = x1385*x52
    x1402 = -x1398 - x1400 + x1401 + x937
    x1403 = x1397*x81
    x1404 = p0*x1399
    x1405 = p2*x1360
    x1406 = x1403 + x1404 - x1405 + x943
    x1407 = x1361 - x1388 + x947
    x1408 = x133*(-2*x1398 - 2*x1400 + 2*x1401 + x952) + x1370*x298 + x1371*x301 + x1374*x306 + x140*(x1372 - x1393 + x949) + x144*(2*x1403 + 2*x1404 - 2*x1405 + x951)
    x1409 = x971*(x1356 + x793)
    x1410 = x1409*x86
    x1411 = x1409*x88
    x1412 = x1409*x90
    x1413 = x1357*x383
    x1414 = x1413*x52
    x1415 = x1385*x383
    x1416 = p1*x1415
    x1417 = x1414 - x1416 + x400
    x1418 = p0*x1415
    x1419 = x1358*x383
    x1420 = p2*x1419
    x1421 = x1214 + x1418 - x1420
    x1422 = p1*x1419
    x1423 = x1413*x77
    x1424 = x1422 - x1423 + x503
    x1425 = x133*(2*x1414 - 2*x1416 + x409) + x1370*x404 + x1371*x403 + x1374*x405 + x140*(2*x1422 - 2*x1423 + x510) + x144*(x1219 + 2*x1418 - 2*x1420)
    x1426 = x1377*x188
    x1427 = x1409*x434
    x1428 = x1380*x976
    x1429 = x1357*x442
    x1430 = x1429*x52
    x1431 = x1385*x442
    x1432 = p1*x1431
    x1433 = x1331 + x1430 - x1432
    x1434 = p0*x1431
    x1435 = x1358*x442
    x1436 = p2*x1435
    x1437 = x1434 - x1436 + x722
    x1438 = p1*x1435
    x1439 = x1429*x77
    x1440 = x1438 - x1439 + x942
    x1441 = x133*(x1340 + 2*x1430 - 2*x1432) + x1370*x462 + x1371*x460 + x1374*x459 + x140*(2*x1438 - 2*x1439 + x950) + x144*(2*x1434 - 2*x1436 + x726)
    x1442 = x1409*x485
    x1443 = x1357*x491
    x1444 = x1443*x52
    x1445 = x1385*x491
    x1446 = p1*x1445
    x1447 = x1444 - x1446 + x511 + x57
    x1448 = p0*x1445
    x1449 = x1358*x491
    x1450 = p2*x1449
    x1451 = x1448 - x1450 + x71 + x756
    x1452 = p1*x1449
    x1453 = x1443*x77
    x1454 = x1452 - x1453 + x83
    x1455 = x133*(x139 + 2*x1444 - 2*x1446 - 4*x503) + x1370*x508 + x1371*x509 + x1374*x512 + x140*(x143 + 2*x1452 - 2*x1453) + x144*(2*x1448 - 2*x1450 + x147 + 4*x752)
    x1456 = 2*x516
    x1457 = x1456*x519
    x1458 = x1456*x524
    x1459 = x1456*x527
    x1460 = x1409*x534
    x1461 = 2*x535

    return np.array([2*x102 + x118*x192 + x118*x199 + 2*x122 + x148*x150 + x148*x152 + x148*x154 + x148*x157 + x148*x159 + x148*x161 + x149*x186 + x163*x164 + x166*x168 + x170*x173 + x174*x175 + x175*x180 + x176*x177 + x177*x181 + x178*x179 + x179*x182 + x186*x187 + x186*x188 + x191*x194 + x193*x200 + x195*x196 + x195*x201 + x204*x205 + x205*x208 + 2*x209*x211 + x217 + 2*x45 + x58*x59 + x58*x95 + x72*x73 + x72*x96 + x84*x85 + x84*x97, x149*x250 + x150*x248 + x152*x248 + x154*x248 + x157*x248 + x159*x248 + x161*x248 + x187*x250 + x188*x250 + x192*x254 + x196*x256 + x199*x254 + x201*x256 + x224*x59 + x224*x95 + x226*x73 + x226*x96 + x233*x85 + x233*x97 + x254*x255 + x254*x257 + x285, x149*x312 + x150*x310 + x152*x310 + x154*x310 + x157*x310 + x159*x310 + x161*x310 + x187*x312 + x188*x312 + x192*x313 + x196*x314 + x199*x313 + x201*x314 + x255*x313 + x257*x313 + x289*x59 + x289*x95 + x295*x73 + x295*x96 + x297*x85 + x297*x97 + x334, x101*(x336 + x60) + x185*x337 + x187*x338 + x188*x338 + x356, x149*x358 + x185*x357 + x188*x358 + x368, x149*x370 + x185*x369 + x187*x370 + x381, x150*x413 + x152*x413 + x154*x413 + x157*x413 + x159*x413 + x161*x413 + x192*x414 + x199*x414 + x255*x414 + x257*x414 + x389*x59 + x389*x95 + x395*x73 + x395*x96 + x402*x85 + x402*x97 + x414*x415 + x414*x416 + x440, x150*x466 + x152*x466 + x154*x466 + x157*x466 + x159*x466 + x161*x466 + x192*x467 + x199*x467 + x255*x467 + x257*x467 + x415*x467 + x416*x467 + x447*x59 + x447*x95 + x452*x73 + x452*x96 + x458*x85 + x458*x97 + x489, x150*x515 + x152*x515 + x154*x515 + x157*x515 + x159*x515 + x161*x515 + x192*x516 + x199*x516 + x255*x516 + x257*x516 + x415*x516 + x416*x516 + x496*x59 + x496*x95 + x502*x73 + x502*x96 + x507*x85 + x507*x97 + x538, x118*x572 + x118*x575 + x149*x566 + x150*x563 + x152*x563 + x154*x563 + x157*x563 + x159*x563 + x161*x563 + x187*x566 + x188*x566 + x193*x576 + x194*x571 + x195*x573 + x195*x577 + x285 + x547*x59 + x547*x95 + x551*x73 + x551*x96 + x554*x85 + x554*x97, x149*x608 + x150*x598 + x152*x598 + x154*x598 + x157*x598 + x159*x598 + x161*x598 + x174*x605 + x176*x606 + x178*x607 + x180*x605 + x181*x606 + x182*x607 + x187*x608 + x188*x608 + x217 + x254*x572 + x254*x575 + x254*x609 + x254*x610 + x256*x573 + x256*x577 + 2*x578 + x588*x59 + x588*x95 + x590*x73 + x590*x96 + x594*x85 + x594*x97 + 2*x595 + 2*x596 + x599*x600 + x601*x602 + x603*x604 + x611*x612 + x612*x613 + x612*x614, x149*x628 + x150*x627 + x152*x627 + x154*x627 + x157*x627 + x159*x627 + x161*x627 + x187*x628 + x188*x628 + x313*x572 + x313*x575 + x313*x609 + x313*x610 + x314*x573 + x314*x577 + x59*x620 + x620*x95 + x623*x73 + x623*x96 + x624*x85 + x624*x97 + x647, x187*x648 + x188*x648 + x337*x565 + x657, x149*x660 + x188*x660 + x213*(x579 + x659) + x357*x565 + x666, x149*x667 + x187*x667 + x369*x565 + x674, x150*x693 + x152*x693 + x154*x693 + x157*x693 + x159*x693 + x161*x693 + x414*x572 + x414*x575 + x414*x609 + x414*x610 + x414*x694 + x414*x695 + x59*x680 + x680*x95 + x684*x73 + x684*x96 + x689*x85 + x689*x97 + x707, x150*x730 + x152*x730 + x154*x730 + x157*x730 + x159*x730 + x161*x730 + x467*x572 + x467*x575 + x467*x609 + x467*x610 + x467*x694 + x467*x695 + x59*x714 + x714*x95 + x719*x73 + x719*x96 + x724*x85 + x724*x97 + x740, x150*x759 + x152*x759 + x154*x759 + x157*x759 + x159*x759 + x161*x759 + x516*x572 + x516*x575 + x516*x609 + x516*x610 + x516*x694 + x516*x695 + x59*x747 + x73*x751 + x747*x95 + x751*x96 + x755*x85 + x755*x97 + x769, x118*x798 + x118*x801 + x149*x795 + x150*x792 + x152*x792 + x154*x792 + x157*x792 + x159*x792 + x161*x792 + x187*x795 + x188*x795 + x193*x802 + x194*x797 + x195*x799 + x195*x803 + x334 + x59*x778 + x73*x782 + x778*x95 + x782*x96 + x785*x85 + x785*x97, x149*x816 + x150*x815 + x152*x815 + x154*x815 + x157*x815 + x159*x815 + x161*x815 + x187*x816 + x188*x816 + x254*x798 + x254*x801 + x254*x817 + x254*x818 + x256*x799 + x256*x803 + x59*x808 + x647 + x73*x810 + x808*x95 + x810*x96 + x813*x85 + x813*x97, x149*x845 + x150*x836 + x152*x836 + x154*x836 + x157*x836 + x159*x836 + x161*x836 + x174*x842 + x176*x843 + x178*x844 + x180*x842 + x181*x843 + x182*x844 + x187*x845 + x188*x845 + x217 + x313*x798 + x313*x801 + x313*x817 + x313*x818 + x314*x799 + x314*x803 + x59*x828 + x637*x841 + x646*x847 + x73*x832 + 2*x819 + x828*x95 + x832*x96 + x833*x85 + x833*x97 + 2*x834 + 2*x835 + x837*x838 + x839*x840 + x846*x847 + x847*x848, x187*x849 + x188*x849 + x337*x794 + x857, x149*x858 + x188*x858 + x357*x794 + x863, x149*x866 + x187*x866 + x215*(x820 + x865) + x369*x794 + x874, x150*x891 + x152*x891 + x154*x891 + x157*x891 + x159*x891 + x161*x891 + x414*x798 + x414*x801 + x414*x817 + x414*x818 + x414*x892 + x414*x893 + x59*x879 + x73*x885 + x85*x888 + x879*x95 + x885*x96 + x888*x97 + x905, x150*x922 + x152*x922 + x154*x922 + x157*x922 + x159*x922 + x161*x922 + x467*x798 + x467*x801 + x467*x817 + x467*x818 + x467*x892 + x467*x893 + x59*x911 + x73*x916 + x85*x919 + x911*x95 + x916*x96 + x919*x97 + x932, x150*x953 + x152*x953 + x154*x953 + x157*x953 + x159*x953 + x161*x953 + x516*x798 + x516*x801 + x516*x817 + x516*x818 + x516*x892 + x516*x893 + x59*x938 + x73*x944 + x85*x948 + x938*x95 + x944*x96 + x948*x97 + x963, x149*x966 + x187*x966 + x188*x966 + 2*x212 + x356, x149*x967 + x187*x967 + x188*x967 + x657, x149*x968 + x187*x968 + x188*x968 + x857, x101*(x335 + x969) + x187*x973 + x188*x973 + x337*x965 + x346*x972 + x970*(x335 + x62) + x974*x975 + x974*x976 + x983, x149*x985 + x188*x985 + x198*x986 + x357*x965 + x972*x984 + x976*x986 + x989, x149*x991 + x187*x991 + x198*x992 + x369*x965 + x972*x990 + x975*x992 + x995, x1004 + x198*x996 + x975*x996 + x976*x996 + 2*x977, x1005*x198 + x1005*x975 + x1005*x976 + x1010, x1011*x198 + x1011*x975 + x1011*x976 + x1016, x1019*x149 + x1019*x187 + x1019*x188 + x368, x1020*x149 + x1020*x187 + x1020*x188 + 2*x214 + x666, x1021*x149 + x1021*x187 + x1021*x188 + x863, x1018*x337 + x1022*x346 + x1023*x187 + x1023*x188 + x1024*x975 + x1024*x976 + x989, x1018*x357 + x1022*x984 + x1026*x149 + x1026*x188 + x1027*x198 + x1027*x976 + x213*(x1025 + x658) + x978*(x581 + x658) + x983, x1018*x369 + x1022*x990 + x1028*x149 + x1028*x187 + x1029*x198 + x1029*x975 + x1032, x1033*x198 + x1033*x975 + x1033*x976 + x1040, x1041*x198 + x1041*x975 + x1041*x976 + x1047 + 2*x979, x1048*x198 + x1048*x975 + x1048*x976 + x1054, x1057*x149 + x1057*x187 + x1057*x188 + x381, x1058*x149 + x1058*x187 + x1058*x188 + x674, x1059*x149 + x1059*x187 + x1059*x188 + 2*x216 + x874, x1056*x337 + x1060*x346 + x1061*x187 + x1061*x188 + x1062*x975 + x1062*x976 + x995, x1032 + x1056*x357 + x1060*x984 + x1063*x149 + x1063*x188 + x1064*x198 + x1064*x976, x1056*x369 + x1060*x990 + x1066*x149 + x1066*x187 + x1067*x198 + x1067*x975 + x215*(x1065 + x864) + x980*(x822 + x864) + x983, x1068*x198 + x1068*x975 + x1068*x976 + x1077, x1078*x198 + x1078*x975 + x1078*x976 + x1083, x1084*x198 + x1084*x975 + x1084*x976 + x1089 + 2*x981, x1096*x59 + x1096*x95 + x1102*x73 + x1102*x96 + x1106*x85 + x1106*x97 + x1112*x150 + x1112*x152 + x1112*x154 + x1112*x157 + x1112*x159 + x1112*x161 + x1114*x194 + x1115*x118 + x1116*x195 + x1117*x1119 + x1118*x118 + x1120*x195 + x440, x1115*x254 + x1116*x256 + x1118*x254 + x1120*x256 + x1125*x59 + x1125*x95 + x1127*x73 + x1127*x96 + x1130*x85 + x1130*x97 + x1132*x150 + x1132*x152 + x1132*x154 + x1132*x157 + x1132*x159 + x1132*x161 + x1133*x254 + x1134*x254 + x707, x1115*x313 + x1116*x314 + x1118*x313 + x1120*x314 + x1133*x313 + x1134*x313 + x1138*x59 + x1138*x95 + x1141*x73 + x1141*x96 + x1142*x85 + x1142*x97 + x1143*x150 + x1143*x152 + x1143*x154 + x1143*x157 + x1143*x159 + x1143*x161 + x905, x1004 + x1144*x346 + x1145*x975 + x1145*x976 + x970*(x336 + x61), x1040 + x1144*x984 + x1146*x198 + x1146*x976, x1077 + x1144*x990 + x1147*x198 + x1147*x975, 2*x1039*x1174 + x1115*x414 + x1118*x414 + x1133*x414 + x1134*x414 + x1152*x59 + x1152*x95 + x1156*x73 + x1156*x96 + x1159*x85 + x1159*x97 + x1160*x150 + x1160*x152 + x1160*x154 + x1160*x157 + x1160*x159 + x1160*x161 + x1162*x174 + x1162*x180 + x1163*x176 + x1163*x181 + x1164*x178 + x1164*x182 + 2*x1165*x419 + 2*x1166*x424 + 2*x1168*x427 + x1169*x414 + x1170*x198 + x1170*x975 + x1170*x976 + x1171*x414 + x1172*x1173 + x1173*x1176 + x982 + 2*x997 + 2*x998 + 2*x999, x1115*x467 + x1118*x467 + x1133*x467 + x1134*x467 + x1169*x467 + x1171*x467 + x1181*x59 + x1181*x95 + x1185*x73 + x1185*x96 + x1189*x85 + x1189*x97 + x1191*x150 + x1191*x152 + x1191*x154 + x1191*x157 + x1191*x159 + x1191*x161 + x1192*x198 + x1192*x975 + x1192*x976 + x1205, x1115*x516 + x1118*x516 + x1133*x516 + x1134*x516 + x1169*x516 + x1171*x516 + x1210*x59 + x1210*x95 + x1215*x73 + x1215*x96 + x1218*x85 + x1218*x97 + x1220*x150 + x1220*x152 + x1220*x154 + x1220*x157 + x1220*x159 + x1220*x161 + x1221*x198 + x1221*x975 + x1221*x976 + x1228, x1119*x1253 + x118*x1251 + x118*x1254 + x1235*x59 + x1235*x95 + x1239*x73 + x1239*x96 + x1242*x85 + x1242*x97 + x1248*x150 + x1248*x152 + x1248*x154 + x1248*x157 + x1248*x159 + x1248*x161 + x1250*x194 + x1252*x195 + x1255*x195 + x489, x1251*x254 + x1252*x256 + x1254*x254 + x1255*x256 + x1262*x59 + x1262*x95 + x1264*x73 + x1264*x96 + x1268*x85 + x1268*x97 + x1270*x150 + x1270*x152 + x1270*x154 + x1270*x157 + x1270*x159 + x1270*x161 + x1271*x254 + x1272*x254 + x740, x1251*x313 + x1252*x314 + x1254*x313 + x1255*x314 + x1271*x313 + x1272*x313 + x1276*x59 + x1276*x95 + x1279*x73 + x1279*x96 + x1280*x85 + x1280*x97 + x1281*x150 + x1281*x152 + x1281*x154 + x1281*x157 + x1281*x159 + x1281*x161 + x932, x1010 + x1282*x346 + x1283*x975 + x1283*x976, x1047 + x1282*x984 + x1284*x198 + x1284*x976 + x978*(x580 + x659), x1083 + x1282*x990 + x1285*x198 + x1285*x975, x1205 + x1251*x414 + x1254*x414 + x1271*x414 + x1272*x414 + x1290*x59 + x1290*x95 + x1294*x73 + x1294*x96 + x1297*x85 + x1297*x97 + x1298*x150 + x1298*x152 + x1298*x154 + x1298*x157 + x1298*x159 + x1298*x161 + x1299*x414 + x1300*x198 + x1300*x975 + x1300*x976 + x1301*x414, 2*x1042 + 2*x1043 + 2*x1044 + 2*x1046*x1325 + x1251*x467 + x1254*x467 + x1271*x467 + x1272*x467 + x1299*x467 + x1301*x467 + x1306*x59 + x1306*x95 + x1310*x73 + x1310*x96 + x1313*x85 + x1313*x97 + x1314*x150 + x1314*x152 + x1314*x154 + x1314*x157 + x1314*x159 + x1314*x161 + x1316*x174 + x1316*x180 + x1317*x176 + x1317*x181 + x1318*x178 + x1318*x182 + 2*x1319*x470 + 2*x1320*x475 + 2*x1321*x478 + x1322*x198 + x1322*x975 + x1322*x976 + x1323*x1324 + x1324*x1326 + x982, x1251*x516 + x1254*x516 + x1271*x516 + x1272*x516 + x1299*x516 + x1301*x516 + x1332*x59 + x1332*x95 + x1336*x73 + x1336*x96 + x1339*x85 + x1339*x97 + x1341*x150 + x1341*x152 + x1341*x154 + x1341*x157 + x1341*x159 + x1341*x161 + x1342*x198 + x1342*x975 + x1342*x976 + x1355, x1119*x1380 + x118*x1378 + x118*x1381 + x1362*x59 + x1362*x95 + x1366*x73 + x1366*x96 + x1369*x85 + x1369*x97 + x1375*x150 + x1375*x152 + x1375*x154 + x1375*x157 + x1375*x159 + x1375*x161 + x1377*x194 + x1379*x195 + x1382*x195 + x538, x1378*x254 + x1379*x256 + x1381*x254 + x1382*x256 + x1387*x59 + x1387*x95 + x1389*x73 + x1389*x96 + x1392*x85 + x1392*x97 + x1394*x150 + x1394*x152 + x1394*x154 + x1394*x157 + x1394*x159 + x1394*x161 + x1395*x254 + x1396*x254 + x769, x1378*x313 + x1379*x314 + x1381*x313 + x1382*x314 + x1395*x313 + x1396*x313 + x1402*x59 + x1402*x95 + x1406*x73 + x1406*x96 + x1407*x85 + x1407*x97 + x1408*x150 + x1408*x152 + x1408*x154 + x1408*x157 + x1408*x159 + x1408*x161 + x963, x1016 + x1409*x346 + x1410*x975 + x1410*x976, x1054 + x1409*x984 + x1411*x198 + x1411*x976, x1089 + x1409*x990 + x1412*x198 + x1412*x975 + x980*(x821 + x865), x1228 + x1378*x414 + x1381*x414 + x1395*x414 + x1396*x414 + x1417*x59 + x1417*x95 + x1421*x73 + x1421*x96 + x1424*x85 + x1424*x97 + x1425*x150 + x1425*x152 + x1425*x154 + x1425*x157 + x1425*x159 + x1425*x161 + x1426*x414 + x1427*x198 + x1427*x975 + x1427*x976 + x1428*x414, x1355 + x1378*x467 + x1381*x467 + x1395*x467 + x1396*x467 + x1426*x467 + x1428*x467 + x1433*x59 + x1433*x95 + x1437*x73 + x1437*x96 + x1440*x85 + x1440*x97 + x1441*x150 + x1441*x152 + x1441*x154 + x1441*x157 + x1441*x159 + x1441*x161 + x1442*x198 + x1442*x975 + x1442*x976, 2*x1053*x1353 + 2*x1085 + 2*x1086 + 2*x1087 + 2*x1349*x519 + 2*x1350*x524 + 2*x1351*x527 + x1352*x1461 + x1354*x1461 + x1378*x516 + x1381*x516 + x1395*x516 + x1396*x516 + x1426*x516 + x1428*x516 + x1447*x59 + x1447*x95 + x1451*x73 + x1451*x96 + x1454*x85 + x1454*x97 + x1455*x150 + x1455*x152 + x1455*x154 + x1455*x157 + x1455*x159 + x1455*x161 + x1457*x174 + x1457*x180 + x1458*x176 + x1458*x181 + x1459*x178 + x1459*x182 + x1460*x198 + x1460*x975 + x1460*x976 + x982], dtype=np.float64)


