# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import numpy
import numpy.typing
import typing

def asymmetric_cauchy_central_moment(start_position: builtins.float, beta: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of asymmetric Cauchy process.
    """

def asymmetric_cauchy_eatamsd(start_position: builtins.float, beta: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the ensemble average of the time-averaged mean square displacement of asymmetric Cauchy process.
    """

def asymmetric_cauchy_fpt(start_position: builtins.float, beta: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of asymmetric Cauchy process.
    """

def asymmetric_cauchy_fpt_central_moment(start_position: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of asymmetric Cauchy process.
    """

def asymmetric_cauchy_fpt_raw_moment(start_position: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of asymmetric Cauchy process.
    """

def asymmetric_cauchy_occupation_time(start_position: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of asymmetric Cauchy process.
    """

def asymmetric_cauchy_occupation_time_central_moment(start_position: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of asymmetric Cauchy process.
    """

def asymmetric_cauchy_occupation_time_raw_moment(start_position: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of asymmetric Cauchy process.
    """

def asymmetric_cauchy_raw_moment(start_position: builtins.float, beta: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of asymmetric Cauchy process.
    """

def asymmetric_cauchy_simulate(start_position: builtins.float, beta: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate asymmetric Cauchy process.
    """

def asymmetric_cauchy_tamsd(start_position: builtins.float, beta: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean square displacement of asymmetric Cauchy process.
    """

def asymmetric_levy_eatamsd(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of AsymmetricLevy process.
    """

def asymmetric_levy_fpt(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of AsymmetricLevy process.
    """

def asymmetric_levy_fpt_central_moment(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of AsymmetricLevy process.
    """

def asymmetric_levy_fpt_raw_moment(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of AsymmetricLevy process.
    """

def asymmetric_levy_occupation_time(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of AsymmetricLevy process.
    """

def asymmetric_levy_occupation_time_central_moment(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of AsymmetricLevy process.
    """

def asymmetric_levy_occupation_time_raw_moment(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of AsymmetricLevy process.
    """

def asymmetric_levy_simulate(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate AsymmetricLevy process.
    """

def asymmetric_levy_tamsd(start_position: builtins.float, alpha: builtins.float, beta: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of AsymmetricLevy process.
    """

def bb_central_moment(duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Brownian bridge.
    """

def bb_eatamsd(duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the ensemble average of the time-averaged mean square displacement of Brownian bridge.
    """

def bb_fpt(time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Brownian bridge.
    """

def bb_fpt_central_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Brownian bridge.
    """

def bb_fpt_raw_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Brownian bridge.
    """

def bb_mean(duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Brownian bridge.
    """

def bb_msd(duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Brownian bridge.
    """

def bb_occupation_time(domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Brownian bridge.
    """

def bb_occupation_time_central_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Brownian bridge.
    """

def bb_occupation_time_raw_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Brownian bridge.
    """

def bb_raw_moment(duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Brownian bridge.
    """

def bb_simulate(duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Brownian bridge.
    """

def bb_tamsd(duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean square displacement of Brownian bridge.
    """

def be_central_moment(duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Brownian excursion.
    """

def be_eatamsd(duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the ensemble average of the time-averaged mean square displacement of Brownian excursion.
    """

def be_fpt(time_step: builtins.float, domain: tuple[builtins.float, builtins.float]) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Brownian excursion.
    """

def be_fpt_central_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Brownian excursion.
    """

def be_fpt_raw_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Brownian excursion.
    """

def be_mean(duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Brownian excursion.
    """

def be_msd(duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Brownian excursion.
    """

def be_occupation_time(domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Brownian excursion.
    """

def be_occupation_time_central_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Brownian excursion.
    """

def be_occupation_time_raw_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Brownian excursion.
    """

def be_raw_moment(duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Brownian excursion.
    """

def be_simulate(duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Brownian excursion.
    """

def be_tamsd(duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean square displacement of Brownian excursion.
    """

def bm_central_moment(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Brownian motion.
    """

def bm_eatamsd(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the ensemble average of the time-averaged mean square displacement of Brownian motion.
    """

def bm_fpt(start_position: builtins.float, diffusion_coefficient: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Brownian motion.
    """

def bm_fpt_central_moment(start_position: builtins.float, diffusion_coefficient: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Brownian motion.
    """

def bm_fpt_raw_moment(start_position: builtins.float, diffusion_coefficient: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Brownian motion.
    """

def bm_mean(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Brownian motion.
    """

def bm_msd(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Brownian motion.
    """

def bm_occupation_time(start_position: builtins.float, diffusion_coefficient: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Brownian motion.
    """

def bm_occupation_time_central_moment(start_position: builtins.float, diffusion_coefficient: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Brownian motion.
    """

def bm_occupation_time_raw_moment(start_position: builtins.float, diffusion_coefficient: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Brownian motion.
    """

def bm_raw_moment(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Brownian motion.
    """

def bm_simulate(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Brownian motion.
    """

def bm_tamsd(start_position: builtins.float, diffusion_coefficient: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean square displacement of Brownian motion.
    """

def bool_rand(p: builtins.float = 0.5) -> builtins.bool: ...

def bool_rands(n: builtins.int, /, p: builtins.float = 0.5) -> typing.Annotated[numpy.typing.NDArray[numpy.bool], typing.Literal["N"]]: ...

def cauchy_central_moment(start_position: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Cauchy process.
    """

def cauchy_eatamsd(start_position: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the ensemble average of the time-averaged mean square displacement of Cauchy process.
    """

def cauchy_fpt(start_position: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Cauchy process.
    """

def cauchy_fpt_central_moment(start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Cauchy process.
    """

def cauchy_fpt_raw_moment(start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Cauchy process.
    """

def cauchy_occupation_time(start_position: builtins.float, domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Cauchy process.
    """

def cauchy_occupation_time_central_moment(start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Cauchy process.
    """

def cauchy_occupation_time_raw_moment(start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Cauchy process.
    """

def cauchy_raw_moment(start_position: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Cauchy process.
    """

def cauchy_simulate(start_position: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Cauchy process.
    """

def cauchy_tamsd(start_position: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean square displacement of Cauchy process.
    """

def ctrw_central_moment(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of CTRW.
    """

def ctrw_fpt(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of CTRW.
    """

def ctrw_fpt_central_moment(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of CTRW.
    """

def ctrw_fpt_raw_moment(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of CTRW.
    """

def ctrw_mean(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, duration: builtins.float, particles: builtins.int) -> builtins.float:
    r"""
    Get the mean of CTRW.
    """

def ctrw_msd(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, duration: builtins.float, particles: builtins.int) -> builtins.float:
    r"""
    Get the msd of CTRW.
    """

def ctrw_occupation_time(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of CTRW.
    """

def ctrw_occupation_time_central_moment(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of the occupation time of CTRW.
    """

def ctrw_occupation_time_raw_moment(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of CTRW.
    """

def ctrw_raw_moment(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of CTRW.
    """

def ctrw_simulate_duration(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, duration: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate CTRW.
    """

def ctrw_simulate_step(alpha: builtins.float, beta: builtins.float, start_position: builtins.float, num_step: builtins.int) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate CTRW.
    """

def eatamsd(simulate_fn: typing.Any, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float: ...

def exp_rand(scale: builtins.float = 1.0) -> builtins.float: ...

def exp_rands(n: builtins.int, /, scale: builtins.float = 1.0) -> numpy.typing.NDArray[numpy.float64]: ...

def fbm_central_moment(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of FBm.
    """

def fbm_eatamsd(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of FBm.
    """

def fbm_fpt(start_position: builtins.float, hurst_exponent: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of FBm.
    """

def fbm_fpt_central_moment(start_position: builtins.float, hurst_exponent: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of FBm.
    """

def fbm_fpt_raw_moment(start_position: builtins.float, hurst_exponent: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of FBm.
    """

def fbm_mean(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of FBm.
    """

def fbm_msd(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of FBm.
    """

def fbm_occupation_time(start_position: builtins.float, hurst_exponent: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of FBm.
    """

def fbm_occupation_time_central_moment(start_position: builtins.float, hurst_exponent: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of FBm.
    """

def fbm_occupation_time_raw_moment(start_position: builtins.float, hurst_exponent: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of FBm.
    """

def fbm_raw_moment(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of FBm.
    """

def fbm_simulate(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate FBm.
    """

def fbm_tamsd(start_position: builtins.float, hurst_exponent: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of FBm.
    """

def gamma_central_moment(shape: builtins.float, rate: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Gamma.
    """

def gamma_eatamsd(shape: builtins.float, rate: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of Gamma.
    """

def gamma_fpt(shape: builtins.float, rate: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Gamma.
    """

def gamma_fpt_central_moment(shape: builtins.float, rate: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Gamma.
    """

def gamma_fpt_raw_moment(shape: builtins.float, rate: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Gamma.
    """

def gamma_mean(shape: builtins.float, rate: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Gamma.
    """

def gamma_msd(shape: builtins.float, rate: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Gamma.
    """

def gamma_occupation_time(shape: builtins.float, rate: builtins.float, domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Gamma.
    """

def gamma_occupation_time_central_moment(shape: builtins.float, rate: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Gamma.
    """

def gamma_occupation_time_raw_moment(shape: builtins.float, rate: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Gamma.
    """

def gamma_raw_moment(shape: builtins.float, rate: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Gamma.
    """

def gamma_simulate(shape: builtins.float, rate: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Gamma.
    """

def gamma_tamsd(shape: builtins.float, rate: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of Gamma.
    """

def gb_central_moment(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Geometric Brownian Motion.
    """

def gb_eatamsd(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of Geometric Brownian Motion.
    """

def gb_fpt(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Geometric Brownian Motion.
    """

def gb_fpt_central_moment(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Geometric Brownian Motion.
    """

def gb_fpt_raw_moment(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Geometric Brownian Motion.
    """

def gb_mean(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Geometric Brownian Motion.
    """

def gb_msd(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Geometric Brownian Motion.
    """

def gb_occupation_time(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Geometric Brownian Motion.
    """

def gb_occupation_time_central_moment(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Geometric Brownian Motion.
    """

def gb_occupation_time_raw_moment(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Geometric Brownian Motion.
    """

def gb_raw_moment(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Geometric Brownian Motion.
    """

def gb_simulate(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Geometric Brownian Motion.
    """

def gb_tamsd(start_position: builtins.float, mu: builtins.float, sigma: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of Geometric Brownian Motion.
    """

def generalized_langevin_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of GeneralizedLangevin process.
    """

def generalized_langevin_eatamsd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of GeneralizedLangevin process.
    """

def generalized_langevin_fpt(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of GeneralizedLangevin process.
    """

def generalized_langevin_fpt_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of GeneralizedLangevin process.
    """

def generalized_langevin_fpt_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of GeneralizedLangevin process.
    """

def generalized_langevin_mean(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of GeneralizedLangevin process.
    """

def generalized_langevin_msd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of GeneralizedLangevin process.
    """

def generalized_langevin_occupation_time(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of GeneralizedLangevin process.
    """

def generalized_langevin_occupation_time_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of GeneralizedLangevin process.
    """

def generalized_langevin_occupation_time_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of GeneralizedLangevin process.
    """

def generalized_langevin_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of GeneralizedLangevin process.
    """

def generalized_langevin_simulate(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Py function wrapper for GeneralizedLangevin simulation
    """

def generalized_langevin_tamsd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of GeneralizedLangevin process.
    """

def inv_subordinator_central_moment(alpha: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of inverse subordinator process.
    """

def inv_subordinator_fpt(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of inverse subordinator process.
    """

def inv_subordinator_fpt_central_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of inverse subordinator process.
    """

def inv_subordinator_fpt_raw_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of inverse subordinator process.
    """

def inv_subordinator_occupation_time(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of inverse subordinator process.
    """

def inv_subordinator_occupation_time_central_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of the occupation time of inverse subordinator process.
    """

def inv_subordinator_occupation_time_raw_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of inverse subordinator process.
    """

def inv_subordinator_raw_moment(alpha: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of inverse subordinator process.
    """

def inv_subordinator_simulate(alpha: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate inverse subordinator process.
    """

def langevin_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of Langevin process.
    """

def langevin_eatamsd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of Langevin process.
    """

def langevin_fpt(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Langevin process.
    """

def langevin_fpt_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Langevin process.
    """

def langevin_fpt_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Langevin process.
    """

def langevin_mean(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Langevin process.
    """

def langevin_msd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Langevin process.
    """

def langevin_occupation_time(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Langevin process.
    """

def langevin_occupation_time_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Langevin process.
    """

def langevin_occupation_time_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Langevin process.
    """

def langevin_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of Langevin process.
    """

def langevin_simulate(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Langevin process.
    """

def langevin_tamsd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of Langevin process.
    """

def levy_eatamsd(start_position: builtins.float, alpha: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of Levy process.
    """

def levy_fpt(start_position: builtins.float, alpha: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Levy process.
    """

def levy_fpt_central_moment(start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Levy process.
    """

def levy_fpt_raw_moment(start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Levy process.
    """

def levy_occupation_time(start_position: builtins.float, alpha: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Levy process.
    """

def levy_occupation_time_central_moment(start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Levy process.
    """

def levy_occupation_time_raw_moment(start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Levy process.
    """

def levy_simulate(start_position: builtins.float, alpha: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Levy process.
    """

def levy_tamsd(start_position: builtins.float, alpha: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of Levy process.
    """

def levy_walk_central_moment(alpha: builtins.float, velocity: builtins.float, start_position: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Levy walk.
    """

def levy_walk_fpt(alpha: builtins.float, velocity: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Levy walk.
    """

def levy_walk_mean(alpha: builtins.float, velocity: builtins.float, start_position: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Levy walk.
    """

def levy_walk_msd(alpha: builtins.float, velocity: builtins.float, start_position: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Levy walk.
    """

def levy_walk_raw_moment(alpha: builtins.float, velocity: builtins.float, start_position: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Levy walk.
    """

def levy_walk_simulate(alpha: builtins.float, velocity: builtins.float, start_position: builtins.float, duration: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Levy walk.
    """

def mean(simulate_fn: typing.Any, duration: builtins.float, time_step: builtins.float, particles: builtins.int) -> builtins.float: ...

def meander_central_moment(duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Brownian meander.
    """

def meander_eatamsd(duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the ensemble average of the time-averaged mean square displacement of Brownian meander.
    """

def meander_fpt(time_step: builtins.float, domain: tuple[builtins.float, builtins.float]) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Brownian meander.
    """

def meander_fpt_central_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Brownian meander.
    """

def meander_fpt_raw_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Brownian meander.
    """

def meander_mean(duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Brownian meander.
    """

def meander_msd(duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Brownian meander.
    """

def meander_occupation_time(domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Brownian meander.
    """

def meander_occupation_time_central_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Brownian meander.
    """

def meander_occupation_time_raw_moment(domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Brownian meander.
    """

def meander_raw_moment(duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Brownian meander.
    """

def meander_simulate(duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Brownian meander.
    """

def meander_tamsd(duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean square displacement of Brownian meander.
    """

def moment(simulate_fn: typing.Any, central: builtins.bool, order: builtins.int, duration: builtins.float, time_step: builtins.float, particles: builtins.int) -> builtins.float: ...

def msd(simulate_fn: typing.Any, duration: builtins.float, time_step: builtins.float, particles: builtins.int) -> builtins.float: ...

def normal_rand(mu: builtins.float = 0.0, sigma: builtins.float = 1.0) -> builtins.float: ...

def normal_rands(n: builtins.int, /, mu: builtins.float = 0.0, sigma: builtins.float = 1.0) -> numpy.typing.NDArray[numpy.float64]: ...

def ou_central_moment(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Ornstein-Uhlenbeck process.
    """

def ou_eatamsd(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of Ornstein-Uhlenbeck process.
    """

def ou_fpt(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, time_step: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Ornstein-Uhlenbeck process.
    """

def ou_fpt_central_moment(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Ornstein-Uhlenbeck process.
    """

def ou_fpt_raw_moment(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Ornstein-Uhlenbeck process.
    """

def ou_mean(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of Ornstein-Uhlenbeck process.
    """

def ou_msd(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of Ornstein-Uhlenbeck process.
    """

def ou_occupation_time(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Ornstein-Uhlenbeck process.
    """

def ou_occupation_time_central_moment(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Ornstein-Uhlenbeck process.
    """

def ou_occupation_time_raw_moment(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, domain: tuple[builtins.float, builtins.float], order: builtins.int, particles: builtins.int, time_step: builtins.float, duration: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Ornstein-Uhlenbeck process.
    """

def ou_raw_moment(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Ornstein-Uhlenbeck process.
    """

def ou_simulate(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Ornstein-Uhlenbeck process.
    """

def ou_tamsd(theta: builtins.float, sigma: builtins.float, start_position: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of Ornstein-Uhlenbeck process.
    """

def poisson_central_moment(lambda_: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of Poisson process.
    """

def poisson_fpt(lambda_: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of Poisson process.
    """

def poisson_fpt_central_moment(lambda_: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of Poisson process.
    """

def poisson_fpt_raw_moment(lambda_: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of Poisson process.
    """

def poisson_mean(lambda_: builtins.float, duration: builtins.float, particles: builtins.int) -> builtins.float:
    r"""
    Get the mean of Poisson process.
    """

def poisson_msd(lambda_: builtins.float, duration: builtins.float, particles: builtins.int) -> builtins.float:
    r"""
    Get the msd of Poisson process.
    """

def poisson_occupation_time(lambda_: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of Poisson process.
    """

def poisson_occupation_time_central_moment(lambda_: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of the occupation time of Poisson process.
    """

def poisson_occupation_time_raw_moment(lambda_: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of Poisson process.
    """

def poisson_rand(lambda_: builtins.float = 1.0) -> builtins.int: ...

def poisson_rands(n: builtins.int, /, lambda_: builtins.float = 1.0) -> typing.Annotated[numpy.typing.NDArray[numpy.uintp], typing.Literal["N"]]: ...

def poisson_raw_moment(lambda_: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of Poisson process.
    """

def poisson_simulate_duration(lambda_: builtins.float, duration: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Poisson process.
    """

def poisson_simulate_step(lambda_: builtins.float, num_step: builtins.int) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate Poisson process.
    """

def skew_stable_rand(alpha: builtins.float) -> builtins.float: ...

def skew_stable_rands(n: builtins.int, alpha: builtins.float) -> numpy.typing.NDArray[numpy.float64]: ...

def stable_rand(alpha: builtins.float, beta: builtins.float, /, sigma: builtins.float = 1.0, mu: builtins.float = 0.0) -> builtins.float: ...

def stable_rands(n: builtins.int, /, alpha: builtins.float, beta: builtins.float, sigma: builtins.float = 1.0, mu: builtins.float = 0.0) -> numpy.typing.NDArray[numpy.float64]: ...

def subordinated_langevin_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of SubordinatedLangevin process.
    """

def subordinated_langevin_eatamsd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, delta: builtins.float, particles: builtins.int, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the effective time-averaged mean squared displacement of SubordinatedLangevin process.
    """

def subordinated_langevin_fpt(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of SubordinatedLangevin process.
    """

def subordinated_langevin_fpt_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of SubordinatedLangevin process.
    """

def subordinated_langevin_fpt_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of SubordinatedLangevin process.
    """

def subordinated_langevin_mean(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the mean of SubordinatedLangevin process.
    """

def subordinated_langevin_msd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the msd of SubordinatedLangevin process.
    """

def subordinated_langevin_occupation_time(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of SubordinatedLangevin process.
    """

def subordinated_langevin_occupation_time_central_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the central moment of the occupation time of SubordinatedLangevin process.
    """

def subordinated_langevin_occupation_time_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of SubordinatedLangevin process.
    """

def subordinated_langevin_raw_moment(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, order: builtins.int, particles: builtins.int, time_step: builtins.float) -> builtins.float:
    r"""
    Get the raw moment of SubordinatedLangevin process.
    """

def subordinated_langevin_simulate(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate SubordinatedLangevin process.
    """

def subordinated_langevin_tamsd(drift_func: typing.Any, diffusion_func: typing.Any, start_position: builtins.float, alpha: builtins.float, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float:
    r"""
    Get the time-averaged mean squared displacement of SubordinatedLangevin process.
    """

def subordinator_fpt(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float) -> typing.Optional[builtins.float]:
    r"""
    Get the first passage time of subordinator process.
    """

def subordinator_fpt_central_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> typing.Optional[builtins.float]:
    r"""
    Get the central moment of the first passage time of subordinator process.
    """

def subordinator_fpt_raw_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], max_duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> typing.Optional[builtins.float]:
    r"""
    Get the raw moment of the first passage time of subordinator process.
    """

def subordinator_occupation_time(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float) -> builtins.float:
    r"""
    Get the occupation time of subordinator process.
    """

def subordinator_occupation_time_central_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the central moment of the occupation time of subordinator process.
    """

def subordinator_occupation_time_raw_moment(alpha: builtins.float, domain: tuple[builtins.float, builtins.float], duration: builtins.float, time_step: builtins.float, order: builtins.int, particles: builtins.int) -> builtins.float:
    r"""
    Get the raw moment of the occupation time of subordinator process.
    """

def subordinator_simulate(alpha: builtins.float, duration: builtins.float, time_step: builtins.float) -> tuple[numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]]:
    r"""
    Simulate subordinator process.
    """

def tamsd(simulate_fn: typing.Any, duration: builtins.float, delta: builtins.float, time_step: builtins.float, quad_order: builtins.int) -> builtins.float: ...

def uniform_rand_float(low: builtins.float = 0.0, high: builtins.float = 1.0, /, end: builtins.bool = False) -> builtins.float: ...

def uniform_rand_int(low: builtins.int, high: builtins.int, /, end: builtins.bool = False) -> builtins.int: ...

def uniform_rands_float(n: builtins.int, /, low: builtins.float = 0.0, high: builtins.float = 1.0, end: builtins.bool = False) -> numpy.typing.NDArray[numpy.float64]: ...

def uniform_rands_int(n: builtins.int, low: builtins.int, high: builtins.int, /, end: builtins.bool = False) -> numpy.typing.NDArray[numpy.int64]: ...

