/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.DeferredBlob;
import com.teradata.jdbc.DeferredClob;
import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXField;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ParameterProperties {
    private DataInfoField[] dataInfoFields;
    private ArrayList parameterSets;
    private int numberOfOutParams = 0;
    private int parameterSetIndex = 0;
    private int m_nDataInfoSize = 0;
    private List m_listMarkerIndexes = new ArrayList();
    private String m_sAlteredSql;
    private String m_sOriginalSql;
    protected TDSession m_session;
    protected boolean m_bUseDataInfoX;
    private ParameterSet m_currentParamSet;
    private DataInfoField[] m_aCurrentDataInfoFields;
    private int m_nNumOfParamsAndAttributes;
    private boolean m_bProcessingArrayElements;

    private ParameterProperties() {
    }

    public static ParameterSet createParameterSetForIndicData(int n) {
        ParameterProperties parameterProperties = new ParameterProperties();
        ParameterSet parameterSet = parameterProperties.createParameterSet(n);
        return parameterSet;
    }

    public static ParameterProperties createParameterPropertiesForParameterMarkers(String string, TDSession tDSession) {
        int n;
        ParameterProperties parameterProperties = new ParameterProperties();
        parameterProperties.m_sAlteredSql = string;
        parameterProperties.m_sOriginalSql = string;
        parameterProperties.m_session = tDSession;
        parameterProperties.m_bUseDataInfoX = tDSession.getConfigResponse().isMultiPartProtocolSupported();
        int n2 = 0;
        while ((n = ComUtil.indexOf(string, "?", n2)) >= 0) {
            parameterProperties.m_listMarkerIndexes.add(new Integer(n));
            n2 = n + "?".length();
        }
        parameterProperties.initParamProperties(parameterProperties.m_listMarkerIndexes.size(), null, false, false);
        return parameterProperties;
    }

    public static ParameterProperties createParameterPropertiesForAttributes(ParameterProperties parameterProperties, DataInfoField[] dataInfoFieldArray, int n) {
        ParameterProperties parameterProperties2 = new ParameterProperties();
        parameterProperties2.m_session = parameterProperties.m_session;
        parameterProperties2.m_bUseDataInfoX = parameterProperties.m_bUseDataInfoX;
        parameterProperties2.m_bProcessingArrayElements = parameterProperties.m_bProcessingArrayElements;
        Integer n2 = new Integer(0);
        for (int i = 0; i < n; ++i) {
            parameterProperties2.m_listMarkerIndexes.add(n2);
        }
        parameterProperties2.initParamProperties(n, dataInfoFieldArray, false, false);
        return parameterProperties2;
    }

    public static ParameterProperties createParameterPropertiesForArrayElements(ParameterProperties parameterProperties, int n, boolean bl) {
        ParameterProperties parameterProperties2 = new ParameterProperties();
        parameterProperties2.m_session = parameterProperties.m_session;
        parameterProperties2.m_bUseDataInfoX = parameterProperties.m_bUseDataInfoX;
        parameterProperties2.m_bProcessingArrayElements = true;
        Integer n2 = new Integer(0);
        parameterProperties2.m_listMarkerIndexes.add(n2);
        parameterProperties2.initParamProperties(n, null, true, bl);
        return parameterProperties2;
    }

    private void initParamProperties(int n, DataInfoField[] dataInfoFieldArray, boolean bl, boolean bl2) {
        if (this.m_session.getLog().isDebugEnabled()) {
            this.m_session.getLog().debug("initParamProperties: m_listMarkerIndexes=" + this.m_listMarkerIndexes);
        }
        this.m_aCurrentDataInfoFields = new DataInfoField[this.m_listMarkerIndexes.size()];
        for (int i = 0; i < this.m_aCurrentDataInfoFields.length; ++i) {
            this.m_aCurrentDataInfoFields[i] = this.m_bProcessingArrayElements && dataInfoFieldArray != null && i < dataInfoFieldArray.length ? dataInfoFieldArray[i] : (this.m_bUseDataInfoX ? new DataInfoXField() : new DataInfoField());
        }
        this.m_currentParamSet = new ParameterSet(n);
        this.m_currentParamSet.setIsArrayElements(bl);
        this.m_currentParamSet.setParentArrayNullValue(bl2);
    }

    public int getNumberOfInAndInOutParams() {
        return this.getNumOfParams() - this.getNumberOfOutParams();
    }

    public void addParameterSet(ParameterSet parameterSet) {
        if (this.parameterSets == null) {
            this.parameterSets = new ArrayList();
        }
        this.parameterSets.add(parameterSet);
    }

    public ParameterSet getParameterSet(int n) throws SQLException {
        if (n < 0 || n >= this.parameterSets.size()) {
            throw ErrorFactory.makeDriverJDBCException("TJ371", n, this.parameterSets.size());
        }
        return (ParameterSet)this.parameterSets.get(n);
    }

    public ParameterSet getParameterSet() throws SQLException {
        return this.getParameterSet(this.parameterSetIndex);
    }

    public ArrayList getParameterSets() {
        return this.parameterSets;
    }

    public int getParameterSetIndex() {
        return this.parameterSetIndex;
    }

    public void setNextParameterSet() {
        ++this.parameterSetIndex;
    }

    public void resetParameterSetIndex() {
        this.parameterSetIndex = 0;
    }

    public int numberOfParamSets() {
        if (this.parameterSets != null) {
            return this.parameterSets.size();
        }
        return 0;
    }

    public int numberOfParamSetsLeft() {
        if (this.parameterSets != null) {
            return this.parameterSets.size() - this.parameterSetIndex;
        }
        return 0;
    }

    public int getDataSize(int n) throws SQLException {
        return this.getParameterSet(n).getDataSize() + this.getParameterSet(n).getNullIndicatorBitsSize();
    }

    public int getDataSize() throws SQLException {
        return this.getDataSize(this.parameterSetIndex);
    }

    public DataInfoField getCurrentDataInfoField(int n) {
        return this.m_aCurrentDataInfoFields[this.getCurrentParamSet().isArrayElements() ? 0 : n - 1];
    }

    public DataInfoField[] getCurrentDataInfoFields() {
        return this.m_aCurrentDataInfoFields;
    }

    public DataInfoField getDataInfoField(int n) {
        return this.dataInfoFields[n - 1];
    }

    public DataInfoField[] getDataInfoFields() {
        return this.dataInfoFields;
    }

    public void clear() {
        this.dataInfoFields = null;
        this.parameterSets = null;
        this.resetParameterSetIndex();
    }

    public void setDataInfoField(int n, int n2, long l, int n3, int n4, int n5, short s, String string, short s2, int[] nArray, boolean bl) throws SQLException {
        this.verifyParamMarker(n);
        if (this.dataInfoFields == null) {
            this.dataInfoFields = new DataInfoField[this.getNumOfParams()];
        }
        this.dataInfoFields[n - 1] = bl ? new DataInfoXField(n2, l, n3, n4, string, s2, nArray, this.m_session.isArrayDataTypeSupported()) : new DataInfoField(n2, l, n3, n4, string, s2, nArray, this.m_session.isArrayDataTypeSupported());
        this.dataInfoFields[n - 1].setSignificantDigits(n5);
        this.dataInfoFields[n - 1].setNumberOfIntervalDigits(s);
    }

    public int getDataInfoSize() {
        return this.m_nDataInfoSize;
    }

    public int getNumberOfOutParams() {
        return this.numberOfOutParams;
    }

    public void setNumberOfOutParams(int n) {
        this.numberOfOutParams = n;
    }

    public void adjustParameters(TDSession tDSession) throws SQLException {
        ArrayList arrayList = this.getParameterSets();
        for (int i = 0; i < arrayList.size(); ++i) {
            ParameterSet parameterSet = (ParameterSet)arrayList.get(i);
            this.validateAndAdjustParameterSet(parameterSet, this.dataInfoFields, tDSession);
        }
    }

    public void validateAndAdjustParameterSet(ParameterSet parameterSet, DataInfoField[] dataInfoFieldArray, TDSession tDSession) throws SQLException {
        block9: for (int i = 1; parameterSet != null && dataInfoFieldArray != null && i <= parameterSet.getNumberOfParamValues(); ++i) {
            DataInfoField dataInfoField = dataInfoFieldArray[parameterSet.isArrayElements() ? 0 : i - 1];
            switch (parameterSet.getSqlType(i)) {
                case 421: {
                    if (parameterSet.getOutParamSqlType(i) == 1 || parameterSet.getOutParamSqlType(i) == 12 || parameterSet.getOutParamSqlType(i) == -1 || dataInfoFieldArray[i - 1].getType() == 449) {
                        this.convertStreamToVarChar(parameterSet, tDSession, i, dataInfoField);
                        continue block9;
                    }
                    this.convertStreamToClob(parameterSet, i, tDSession, dataInfoField, parameterSet.getSqlType(i));
                    continue block9;
                }
                case 857: 
                case 889: {
                    this.convertStreamToClob(parameterSet, i, tDSession, dataInfoField, parameterSet.getSqlType(i));
                    continue block9;
                }
                case 449: 
                case 453: {
                    if (parameterSet.getOutParamSqlType(i) != 2005) continue block9;
                    throw ErrorFactory.makeDriverJDBCException("TJ497", String.valueOf(i));
                }
                case 405: {
                    if (parameterSet.getOutParamSqlType(i) == -2 || parameterSet.getOutParamSqlType(i) == -3 || parameterSet.getOutParamSqlType(i) == -4 || dataInfoFieldArray[i - 1].getType() == 689) {
                        this.convertStreamToVarByte(parameterSet, i, dataInfoField);
                        continue block9;
                    }
                    this.convertStreamToBlob(parameterSet, i, tDSession, dataInfoField);
                    continue block9;
                }
                case 869: {
                    this.convertStreamToBlob(parameterSet, i, tDSession, dataInfoField);
                    continue block9;
                }
                case 689: 
                case 693: {
                    if (parameterSet.getOutParamSqlType(i) != 2004) continue block9;
                    throw ErrorFactory.makeDriverJDBCException("TJ498", String.valueOf(i));
                }
                case 441: 
                case 505: 
                case 509: {
                    this.validateAndAdjustParameterSet(parameterSet.getAttributeParamSet(i), dataInfoField.getAttributeFieldArray(), tDSession);
                }
            }
        }
    }

    private void convertStreamToClob(ParameterSet parameterSet, int n, TDSession tDSession, DataInfoField dataInfoField, int n2) throws SQLException {
        Reader reader = (Reader)parameterSet.getValue(n);
        if (reader == null) {
            return;
        }
        boolean bl = n2 == 857;
        int n3 = parameterSet.getServerCharsetCode(n) == 1 ? tDSession.getConfigResponse().getMaxJsonLatinCharCount() : tDSession.getConfigResponse().getMaxJsonUnicodeCharCount();
        int n4 = n2 == 889 ? n3 : 2097088000;
        dataInfoField.setLength(n4);
        int n5 = tDSession.registerDeferredLob(new DeferredClob(reader, parameterSet.getLength(n), n, parameterSet.getColumnIndex(n), parameterSet.getAppMethodNames(n), tDSession, bl));
        byte[] byArray = ByteConverter.putInt(n5);
        parameterSet.setBinaryValue(n, byArray);
    }

    private void convertStreamToBlob(ParameterSet parameterSet, int n, TDSession tDSession, DataInfoField dataInfoField) throws SQLException {
        InputStream inputStream = (InputStream)parameterSet.getValue(n);
        if (inputStream == null) {
            return;
        }
        dataInfoField.setLength(2097088000);
        int n2 = tDSession.registerDeferredLob(new DeferredBlob(inputStream, parameterSet.getLength(n)));
        byte[] byArray = ByteConverter.putInt(n2);
        parameterSet.setBinaryValue(n, byArray);
    }

    private void convertStreamToVarChar(ParameterSet parameterSet, GenericTeradataConnection genericTeradataConnection, int n, DataInfoField dataInfoField) throws SQLException {
        int n2 = parameterSet.getLength(n);
        Reader reader = (Reader)parameterSet.getValue(n);
        dataInfoField.setType(449);
        parameterSet.setSqlType(n, 449);
        if (reader == null) {
            parameterSet.setLength(n, 0);
            parameterSet.setBinaryValue(n, new byte[2]);
            return;
        }
        try {
            int n3 = n2 >= 64000 ? 64001 : n2;
            char[] cArray = new char[n3];
            int n4 = reader.read(cArray, 0, cArray.length);
            if (n4 == -1) {
                parameterSet.setLength(n, 0);
                parameterSet.setBinaryValue(n, new byte[2]);
                return;
            }
            Encoder encoder = new Encoder(genericTeradataConnection, false);
            ByteBuffer byteBuffer = ByteBuffer.allocate(64000);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, n4);
            try {
                if (encoder.beginEncodeStream(charBuffer, byteBuffer, n, -1, null, 1L)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ715", String.valueOf(n));
                }
            }
            catch (SQLException sQLException) {
                long l = 0L;
                while (n2 != n4 && (l = reader.skip(n2 - n4)) != 0L) {
                    n4 = (int)((long)n4 + l);
                }
                throw sQLException;
            }
            n2 = byteBuffer.position();
            byte[] byArray = new byte[n2 + 2];
            ByteConverter.putShort(byArray, 0, (short)n2);
            byteBuffer.rewind();
            byteBuffer.get(byArray, 2, n2);
            if (dataInfoField.getLength() < (long)n2) {
                dataInfoField.setLength(n2);
            }
            parameterSet.setLength(n, n2);
            parameterSet.setBinaryValue(n, byArray);
        }
        catch (IOException iOException) {
            throw ErrorFactory.makeDriverJDBCException("TJ490", Integer.toString(n), iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertStreamToVarByte(ParameterSet parameterSet, int n, DataInfoField dataInfoField) throws SQLException {
        int n2 = parameterSet.getLength(n);
        InputStream inputStream = (InputStream)parameterSet.getValue(n);
        dataInfoField.setType(689);
        parameterSet.setSqlType(n, 689);
        if (inputStream == null) {
            parameterSet.setLength(n, 0);
            parameterSet.setBinaryValue(n, new byte[2]);
            return;
        }
        try {
            Object object;
            byte[] byArray;
            if (n2 == 0) {
                byArray = new byte[]{};
            } else {
                object = new ByteArrayOutputStream(n2);
                try {
                    this.readBinaryStream(n, inputStream, (ByteArrayOutputStream)object, n2);
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)object).close();
                }
                n2 = byArray.length;
                if (n2 > 64000) {
                    throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(n2));
                }
            }
            object = new byte[n2 + 2];
            ByteConverter.putShort((byte[])object, 0, (short)n2);
            System.arraycopy(byArray, 0, object, 2, n2);
            if (dataInfoField.getLength() < (long)n2) {
                dataInfoField.setLength(n2);
            }
            parameterSet.setLength(n, n2);
            parameterSet.setBinaryValue(n, (byte[])object);
        }
        catch (IOException iOException) {
            throw ErrorFactory.makeDriverJDBCException("TJ490", Integer.toString(n), iOException.getMessage());
        }
    }

    private void readBinaryStream(int n, InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, int n2) throws IOException, SQLException {
        long l = 0L;
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray, 0, n2);
        while (n3 != -1) {
            byteArrayOutputStream.write(byArray, 0, n3);
            if ((l += (long)n3) >= (long)n2) break;
            n3 = inputStream.read(byArray, 0, n2);
        }
        byteArrayOutputStream.flush();
    }

    public void clearCurrentParameters() {
        for (int i = 0; i < this.m_aCurrentDataInfoFields.length; ++i) {
            this.m_aCurrentDataInfoFields[i].clear();
        }
        this.m_currentParamSet.clear();
    }

    protected String getSql() {
        return this.m_sAlteredSql;
    }

    public String getOriginalSql() {
        return this.m_sOriginalSql;
    }

    protected int getNumOfParams() {
        return this.m_listMarkerIndexes.size();
    }

    public int getNumOfOutOnlyParams() {
        int n = 0;
        int n2 = 0;
        for (int i = this.getNumOfParams(); i > 0; --i) {
            if (this.m_currentParamSet.getParamType(i) != 2) continue;
            ++n2;
        }
        n = n2;
        return n;
    }

    public int verifyOutParam(int n) throws SQLException {
        if (n < 1 || n > this.getNumOfParams()) {
            throw ErrorFactory.makeDriverJDBCException("TJ181", n);
        }
        ParameterSet parameterSet = this.getCurrentParamSet();
        int n2 = this.getNumOfParams();
        int[] nArray = new int[n2];
        int n3 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = parameterSet.getParamType(i + 1) == 2 || parameterSet.getParamType(i + 1) == 3 ? n3++ : -1;
        }
        if (nArray[n - 1] == -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ181", n);
        }
        return nArray[n - 1];
    }

    public void verifyParamMarker(int n) throws SQLException {
        if (n < 1 || n > (this.m_currentParamSet.isArrayElements() && n > 1 ? this.m_currentParamSet.getNumberOfParamValues() : this.getNumOfParams())) {
            throw ErrorFactory.makeDriverJDBCException("TJ169", n, this.m_currentParamSet.isArrayElements() ? this.m_currentParamSet.getNumberOfParamValues() : this.getNumOfParams());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getOutParams(String string) throws SQLException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string.substring(0, 4).equalsIgnoreCase("CALL")) {
            return;
        }
        int n = "CALL".length() + 1;
        int n2 = TDStatement.endOfWordIndex(string.substring(n));
        TDResultSet tDResultSet = this.m_session.executeSessionRequest("getOutParams", true, "HELP PROCEDURE " + string.substring(n, n2 + n), true);
        try {
            while (tDResultSet.next()) {
                if (!String.valueOf(tDResultSet.getObject(16)).trim().equals("O")) continue;
                object = String.valueOf(tDResultSet.getObject(1));
                object = ("x" + (String)object).trim().substring(1);
                object = "\"" + ((String)object).replaceAll("\"", "\"\"") + "\"";
                arrayList.add(object);
            }
        }
        finally {
            try {
                tDResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        if (arrayList.size() != this.getNumberOfOutParams()) {
            throw ErrorFactory.makeDriverJDBCException("TJ434", arrayList.size(), this.getNumberOfOutParams());
        }
        object = arrayList.iterator();
        for (int i = 1; i <= this.m_currentParamSet.getNumberOfParamValues(); ++i) {
            if (this.m_currentParamSet.getParamType(i) != 2) continue;
            this.m_currentParamSet.setOutParamName(i, (String)object.next());
        }
    }

    public void replaceOutParams() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_sOriginalSql);
        for (int i = this.getNumOfParams(); i > 0; --i) {
            if (this.m_currentParamSet.getParamType(i) != 2) continue;
            if (this.m_currentParamSet.getOutParamName(i) == null) {
                this.getOutParams(this.m_sOriginalSql);
            }
            int n = (Integer)this.m_listMarkerIndexes.get(i - 1);
            stringBuffer.setCharAt(n, ' ');
            stringBuffer.insert(n + 1, this.m_currentParamSet.getOutParamName(i));
        }
        this.m_sAlteredSql = stringBuffer.toString();
    }

    public ParameterSet getCurrentParamSet() {
        return this.m_currentParamSet;
    }

    public void setCurrentParamSet(ParameterSet parameterSet) {
        this.m_currentParamSet = parameterSet;
    }

    public void setCurrentParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4, long l) throws SQLException {
        if (this.m_bProcessingArrayElements) {
            int n5 = this.m_currentParamSet.isArrayElements() ? 0 : n - 1;
            this.m_aCurrentDataInfoFields[n5].setType(n2);
            this.m_aCurrentDataInfoFields[n5].setAdjustedPrec(n3);
            this.m_aCurrentDataInfoFields[n5].setAdjustedScale(n4, this.m_bUseDataInfoX, this.m_session.isLargeDecimalAndBigIntSupported());
            this.m_aCurrentDataInfoFields[n5].setAdjustedLength(l);
        } else {
            this.m_aCurrentDataInfoFields[n - 1].setPrecision(n3);
            this.m_aCurrentDataInfoFields[n - 1].setScale(n4);
            this.m_aCurrentDataInfoFields[n - 1].setType(n2);
            this.m_aCurrentDataInfoFields[n - 1].setLength(l);
        }
        if (this.m_currentParamSet.getNumberOfParamValues() > 0) {
            this.m_currentParamSet.setParameter(n, object, byArray, n2, bl, n3, n4);
        }
    }

    public void setDeferredLobParameter(int n, int n2, String[] stringArray, Object object, int n3, int n4, int n5) throws SQLException {
        this.setCurrentParameter(n, object, null, n3, false, 0, 0, 0L);
        this.m_currentParamSet.setLength(n, n4);
        this.m_currentParamSet.setColumnIndex(n, n2);
        this.m_currentParamSet.setAppMethodNames(n, stringArray);
        this.m_currentParamSet.setMetadataItemNumber(n, n5);
    }

    public void setDecimalParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4, int n5) throws SQLException {
        if (this.m_bProcessingArrayElements) {
            this.m_aCurrentDataInfoFields[this.m_currentParamSet.isArrayElements() ? 0 : n - 1].setAdjustedSignificantDigits(n5);
        } else {
            this.m_aCurrentDataInfoFields[n - 1].setSignificantDigits(n5);
        }
        this.setCurrentParameter(n, object, byArray, n2, bl, n3, n4, this.composeDataInfoDecimalLength(n3, n4));
    }

    private long composeDataInfoDecimalLength(int n, int n2) {
        return this.m_bUseDataInfoX ? ComUtil.makeDataInfoXDecLength(n, n2) : (long)ComUtil.makeDataInfoDecLength((short)n, (byte)n2);
    }

    public void setIntervalParameter(int n, Object object, byte[] byArray, int n2, boolean bl, short s, short s2, int n3) throws SQLException {
        int n4 = this.m_bProcessingArrayElements && this.m_currentParamSet.isArrayElements() ? 0 : n - 1;
        this.m_aCurrentDataInfoFields[n4].setNumberOfIntervalDigits(s);
        this.setCurrentParameter(n, object, byArray, n2, bl, 0, s2, n3);
    }

    public String buildStatement() throws SQLException {
        if (!this.m_session.outParamArgSupported()) {
            this.replaceOutParams();
        }
        if (this.getNumOfParams() > 0) {
            this.setNumOfParamsAndAttributes(this.calculateTotalNumberOfParams(this.getCurrentDataInfoFields(), true));
            this.setDataInfo(this.m_currentParamSet);
            this.validateAndAdjustParameterSet(this.m_currentParamSet, this.getDataInfoFields(), this.m_session);
            for (int i = 1; i <= this.m_currentParamSet.getNumberOfParamValues(); ++i) {
                if (this.m_currentParamSet.getSqlType(i) != 505 && this.m_currentParamSet.getSqlType(i) != 509) continue;
                this.checkForAdjustments(this.m_currentParamSet.getAttributeParamSet(i), this.getDataInfoField(i).getAttributeFieldArray(), this.getDataInfoField(i).getFullyQualifiedTypeName());
            }
            this.addParameterSet(this.m_currentParamSet);
        }
        return this.getSql();
    }

    public void addBatchData() throws SQLException {
        if (this.getNumOfParams() > 0) {
            int n = this.getCurrentParamSet().getUnsetParameter();
            if (n != 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ184", n);
            }
            ParameterSet parameterSet = new ParameterSet(this.getCurrentParamSet());
            this.setDataInfo(parameterSet);
            this.setNumOfParamsAndAttributes(this.calculateTotalNumberOfParams(this.dataInfoFields, true));
            this.addParameterSet(parameterSet);
        }
    }

    public void clearBatchData() {
        this.clearCurrentParameters();
        this.clear();
    }

    public String buildBatchStatement() throws SQLException {
        if (this.getNumOfParams() > 0) {
            if (this.numberOfParamSets() == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ689");
            }
            this.adjustParameters(this.m_session);
            for (int i = 0; i < this.parameterSets.size(); ++i) {
                this.checkForAdjustments((ParameterSet)this.parameterSets.get(i), this.getDataInfoFields(), null);
            }
        }
        return this.getSql();
    }

    private void setDataInfo(ParameterSet parameterSet) throws SQLException {
        int n;
        if (this.getNumOfParams() > 0) {
            n = parameterSet.getUnsetParameter();
            if (n != 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ184", n);
            }
            this.setNumberOfOutParams(this.getNumOfOutOnlyParams());
            parameterSet.createNullIndicatorBitArray();
        }
        if (this.getDataInfoFields() == null) {
            n = 0;
            boolean bl = this.m_session.isStatementInfoRequestSupported();
            for (int i = 1; i <= this.getNumOfParams(); ++i) {
                this.setDataInfoField(i, this.getCurrentDataInfoField(i).getType(), this.getCurrentDataInfoField(i).getLength(), this.getCurrentDataInfoField(i).getScale(), this.getCurrentDataInfoField(i).getPrecision(), this.getCurrentDataInfoField(i).getSignificantDigits(), this.getCurrentDataInfoField(i).getNumberOfIntervalDigits(), this.getCurrentDataInfoField(i).getFullyQualifiedTypeName(), this.getCurrentDataInfoField(i).getServerDataType(), this.getCurrentDataInfoField(i).getArrayCardinalities(), this.m_bUseDataInfoX);
                if (this.getCurrentDataInfoField(i).isStruct() || this.getCurrentDataInfoField(i).isArray()) {
                    n += this.getCurrentDataInfoField(i).getStructSize(Encoder.encodeStringParameter(this.m_session, i, this.getCurrentDataInfoField(i).getFullyQualifiedTypeName()).length);
                    n += this.getDataInfoField(i).copyAttributeInfo(this.getCurrentDataInfoField(i).getAttributeFieldArray(), (short)1, this.m_session);
                    continue;
                }
                n += bl ? 16 : this.getCurrentDataInfoField(i).getSize();
            }
            this.m_nDataInfoSize = n;
        } else {
            for (n = 1; n <= this.getNumOfParams(); ++n) {
                this.dataInfoFields[n - 1].setAdjustedType(n, null, 0, this.m_aCurrentDataInfoFields[n - 1]);
                this.dataInfoFields[n - 1].setAdjustedSignificantDigits(this.m_aCurrentDataInfoFields[n - 1].getSignificantDigits());
                this.dataInfoFields[n - 1].setAdjustedPrec(this.m_aCurrentDataInfoFields[n - 1].getPrecision());
                this.dataInfoFields[n - 1].setAdjustedLength(this.m_aCurrentDataInfoFields[n - 1].getLength());
                this.dataInfoFields[n - 1].setAdjustedArrayCardinalities(n, this.m_aCurrentDataInfoFields[n - 1].getArrayCardinalities());
                this.dataInfoFields[n - 1].setAdjustedScale(this.m_aCurrentDataInfoFields[n - 1].getScale(), this.m_bUseDataInfoX, this.m_session.isLargeDecimalAndBigIntSupported());
                if (!this.dataInfoFields[n - 1].isStruct() && !this.dataInfoFields[n - 1].isArray()) continue;
                this.dataInfoFields[n - 1].setAdjustedAttributes(n, this.getCurrentDataInfoField(n).getAttributeFieldArray(), this.m_bUseDataInfoX, this.m_session.isLargeDecimalAndBigIntSupported());
            }
        }
    }

    private void checkForAdjustments(ParameterSet parameterSet, DataInfoField[] dataInfoFieldArray, String string) throws SQLException {
        block11: for (int i = 1; dataInfoFieldArray != null && parameterSet != null && i <= parameterSet.getNumberOfParamValues(); ++i) {
            DataInfoField dataInfoField = dataInfoFieldArray[parameterSet.isArrayElements() ? 0 : i - 1];
            switch (parameterSet.getSqlType(i)) {
                case 484: 
                case 485: {
                    if (dataInfoField.getType() == 605) {
                        if (parameterSet.isNullValue(i)) {
                            parameterSet.setParameter(i, null, new byte[]{0}, 605, true, 0, 0);
                            continue block11;
                        }
                        if (dataInfoField.getFullyQualifiedTypeName() == null || dataInfoField.getFullyQualifiedTypeName().length() == 0) {
                            throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ643", String.valueOf(parameterSet.getSqlType(i)), String.valueOf(dataInfoField.getType()), String.valueOf(i), dataInfoField.getFullyQualifiedTypeName().length() > 0 ? string : JDBC4Constants.getTDTypeName(dataInfoField.getServerDataType()), String.valueOf(i));
                    }
                    if (parameterSet.getValue(i) == null || parameterSet.getScale(i) == dataInfoField.getScale()) continue block11;
                    parameterSet.resetDecimal(i, dataInfoField.getScale());
                    continue block11;
                }
                case 452: 
                case 453: 
                case 760: 
                case 761: 
                case 764: 
                case 765: 
                case 768: 
                case 769: 
                case 772: 
                case 773: {
                    if (parameterSet.isNullValue(i) && parameterSet.getLength(i) != (int)dataInfoField.getLength()) {
                        parameterSet.resetToSpaces(i, (int)dataInfoField.getLength());
                        continue block11;
                    }
                    if (parameterSet.getScale(i) == dataInfoField.getScale()) continue block11;
                    parameterSet.resetTimeAndTimestamp(i, dataInfoField.getScale());
                    continue block11;
                }
                case 692: 
                case 693: {
                    if (parameterSet.getLength(i) == (int)dataInfoField.getLength()) continue block11;
                    parameterSet.resetFixedWidthBytes(i, (int)dataInfoField.getLength());
                    continue block11;
                }
                case 440: 
                case 441: 
                case 504: 
                case 505: 
                case 508: 
                case 509: {
                    this.checkForAdjustments(parameterSet.getAttributeParamSet(i), dataInfoField.getAttributeFieldArray(), dataInfoField.getFullyQualifiedTypeName());
                    continue block11;
                }
                case 405: {
                    if (dataInfoField.getType() != 409) continue block11;
                    if (parameterSet.isNullValue(i)) {
                        parameterSet.setParameter(i, new Integer(0), new byte[]{0, 0}, 2004, true, 0, 0);
                        continue block11;
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                }
                case 421: {
                    if (dataInfoField.getType() != 425) continue block11;
                    if (parameterSet.isNullValue(i)) {
                        parameterSet.setParameter(i, new Integer(0), new byte[]{0, 0}, 2005, true, 0, 0);
                        continue block11;
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                }
                case 889: {
                    if (dataInfoField.getType() != 885) continue block11;
                    if (parameterSet.isNullValue(i)) {
                        parameterSet.setParameter(i, new Integer(0), new byte[]{0, 0}, 1111, true, 0, 0);
                        continue block11;
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                }
                case 857: 
                case 869: {
                    if (dataInfoField.getType() != 873 && dataInfoField.getType() != 861) continue block11;
                    if (parameterSet.isNullValue(i)) {
                        parameterSet.setParameter(i, new Integer(0), new byte[]{0, 0}, 2009, true, 0, 0);
                        continue block11;
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                }
                case 449: {
                    if (JDBC4Constants.isIntervalType(dataInfoField.getType())) {
                        if (parameterSet.isNullValue(i)) {
                            parameterSet.resetToSpaces(i, (int)dataInfoField.getLength());
                            continue block11;
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                    }
                    if (dataInfoField.getType() != 889) continue block11;
                    if (parameterSet.isNullValue(i)) {
                        parameterSet.setParameter(i, new Integer(0), new byte[]{0, 0, 0, 0}, 1111, true, 0, 0);
                        continue block11;
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ229", i, parameterSet.getSqlType(i), dataInfoField.getType());
                }
            }
        }
    }

    private int calculateTotalNumberOfParams(DataInfoField[] dataInfoFieldArray, boolean bl) {
        int n = dataInfoFieldArray == null ? 0 : dataInfoFieldArray.length;
        for (int i = 0; dataInfoFieldArray != null && i < dataInfoFieldArray.length; ++i) {
            if (!dataInfoFieldArray[i].isStruct() && (!bl || !dataInfoFieldArray[i].isArray())) continue;
            n += this.calculateTotalNumberOfParams(dataInfoFieldArray[i].getAttributeFieldArray(), bl);
        }
        return n;
    }

    public ParameterSet createParameterSet(int n) {
        return new ParameterSet(n);
    }

    public void setNumOfParamsAndAttributes(int n) {
        this.m_nNumOfParamsAndAttributes = n;
    }

    public int getNumOfParamsAndAttributes() {
        return this.m_nNumOfParamsAndAttributes;
    }

    private static void setNullIndicatorBitWithinArray(int n, byte[] byArray) {
        int n2 = 1 << 7 - (n - 1) % 8;
        int n3 = (n + 7) / 8 - 1;
        byArray[n3] = (byte)(byArray[n3] | (byte)n2);
    }

    protected boolean processingArrayElements() {
        return this.m_bProcessingArrayElements;
    }

    public class ParameterSet {
        private int m_nByteCountForNullIndicatorBits;
        private byte[] m_abyNullIndicatorBits;
        private Object[] m_aoValues;
        private boolean[] m_abNullValues;
        private int[] m_anPrecs;
        private int[] m_anScales;
        private int[] m_anSqlTypes;
        private int[] m_anOutParamSqlTypes;
        private int[] m_anLengths;
        private byte[][] m_abyBinaryValues;
        private int[] m_anParamTypes;
        private String[] m_asOutParamNames = null;
        private ParameterSet[] m_aAttributeParamSets;
        private boolean m_bArrayElements = false;
        private int m_nArrayNumOfElementsAndAttributes = 0;
        private boolean m_bArrayParentIsNull = false;
        private byte[] m_abyServerCharsetCodes;
        private int[] m_anMetadataItemNumbers;
        private int[] m_anColumnIndexes;
        private int[] m_anArrayParameterIndexes;
        private int[][] m_aanArrayElementIndexes;
        private String[][] m_aasAppMethodNames;
        public static final int IN = 1;
        public static final int OUT = 2;
        public static final int INOUT = 3;
        public static final int NONE = 4;
        private static final int SIZEOF_ARRAY_LENGTH = 2;

        public ParameterSet(int n) {
            this.m_nByteCountForNullIndicatorBits = (n + 7) / 8;
            this.initParams(n);
        }

        public ParameterSet(ParameterSet parameterSet) {
            this.initParams(parameterSet.getNumberOfParamValues());
            System.arraycopy(parameterSet.m_aoValues, 0, this.m_aoValues, 0, this.m_aoValues.length);
            System.arraycopy(parameterSet.m_abNullValues, 0, this.m_abNullValues, 0, this.m_abNullValues.length);
            System.arraycopy(parameterSet.m_anPrecs, 0, this.m_anPrecs, 0, this.m_anPrecs.length);
            System.arraycopy(parameterSet.m_anScales, 0, this.m_anScales, 0, this.m_anScales.length);
            System.arraycopy(parameterSet.m_anSqlTypes, 0, this.m_anSqlTypes, 0, this.m_anSqlTypes.length);
            System.arraycopy(parameterSet.m_anOutParamSqlTypes, 0, this.m_anOutParamSqlTypes, 0, this.m_anOutParamSqlTypes.length);
            System.arraycopy(parameterSet.m_anLengths, 0, this.m_anLengths, 0, this.m_anLengths.length);
            System.arraycopy(parameterSet.m_anParamTypes, 0, this.m_anParamTypes, 0, this.m_anParamTypes.length);
            System.arraycopy(parameterSet.m_abyBinaryValues, 0, this.m_abyBinaryValues, 0, this.m_abyBinaryValues.length);
            System.arraycopy(parameterSet.m_asOutParamNames, 0, this.m_asOutParamNames, 0, this.m_asOutParamNames.length);
            System.arraycopy(parameterSet.m_abyServerCharsetCodes, 0, this.m_abyServerCharsetCodes, 0, this.m_abyServerCharsetCodes.length);
            System.arraycopy(parameterSet.m_anMetadataItemNumbers, 0, this.m_anMetadataItemNumbers, 0, this.m_anMetadataItemNumbers.length);
            System.arraycopy(parameterSet.m_anColumnIndexes, 0, this.m_anColumnIndexes, 0, this.m_anColumnIndexes.length);
            System.arraycopy(parameterSet.m_anArrayParameterIndexes, 0, this.m_anArrayParameterIndexes, 0, this.m_anArrayParameterIndexes.length);
            System.arraycopy(parameterSet.m_aanArrayElementIndexes, 0, this.m_aanArrayElementIndexes, 0, this.m_aanArrayElementIndexes.length);
            System.arraycopy(parameterSet.m_aasAppMethodNames, 0, this.m_aasAppMethodNames, 0, this.m_aasAppMethodNames.length);
            this.m_nArrayNumOfElementsAndAttributes = parameterSet.m_nArrayNumOfElementsAndAttributes;
            this.m_bArrayElements = parameterSet.m_bArrayElements;
            this.m_nByteCountForNullIndicatorBits = parameterSet.m_nByteCountForNullIndicatorBits;
            this.m_abyNullIndicatorBits = parameterSet.m_abyNullIndicatorBits;
            this.m_bArrayParentIsNull = parameterSet.m_bArrayParentIsNull;
            for (int i = 1; i <= this.m_aAttributeParamSets.length; ++i) {
                if (!parameterSet.isStruct(i) && !parameterSet.isArray(i)) continue;
                this.m_aAttributeParamSets[i - 1] = new ParameterSet(parameterSet.getAttributeParamSet(i));
            }
        }

        private void initParams(int n) {
            this.m_aoValues = new Object[n];
            this.m_abNullValues = new boolean[n];
            this.m_anPrecs = new int[n];
            this.m_anScales = new int[n];
            this.m_anSqlTypes = new int[n];
            this.m_anOutParamSqlTypes = new int[n];
            this.m_anLengths = new int[n];
            this.m_anParamTypes = new int[n];
            this.m_abyBinaryValues = new byte[n][];
            this.m_asOutParamNames = new String[n];
            this.m_abyServerCharsetCodes = new byte[n];
            this.m_anMetadataItemNumbers = new int[n];
            this.m_aAttributeParamSets = new ParameterSet[n];
            this.m_anColumnIndexes = new int[n];
            this.m_anArrayParameterIndexes = new int[n];
            this.m_aanArrayElementIndexes = new int[n][];
            this.m_aasAppMethodNames = new String[n][];
            for (int i = 0; i < n; ++i) {
                this.m_anParamTypes[i] = 4;
                this.m_anSqlTypes[i] = 0;
                this.m_anColumnIndexes[i] = -1;
                this.m_anArrayParameterIndexes[i] = -1;
            }
        }

        public void setParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4) {
            if (this.m_aoValues.length == 0) {
                return;
            }
            this.m_aoValues[n - 1] = object;
            this.m_anSqlTypes[n - 1] = n2;
            this.m_abNullValues[n - 1] = bl;
            this.m_anPrecs[n - 1] = n3;
            this.m_anScales[n - 1] = n4;
            this.m_abyBinaryValues[n - 1] = byArray;
            this.m_anLengths[n - 1] = byArray != null ? byArray.length : 0;
            this.setParamType(n, 1);
        }

        public void setParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4, int n5, String string, int n6) {
            if (this.m_aoValues.length == 0) {
                return;
            }
            this.m_aoValues[n - 1] = object;
            this.m_anSqlTypes[n - 1] = n2;
            this.m_abNullValues[n - 1] = bl;
            this.m_anPrecs[n - 1] = n3;
            this.m_anScales[n - 1] = n4;
            this.m_abyBinaryValues[n - 1] = byArray;
            this.m_anLengths[n - 1] = n6;
            this.m_asOutParamNames[n - 1] = string;
            this.setParamType(n, n5);
        }

        public int getUnsetParameter() {
            for (int i = 0; i < this.m_anSqlTypes.length; ++i) {
                if (this.m_anParamTypes[i] != 4) continue;
                return i + 1;
            }
            return 0;
        }

        public void clear() {
            for (int i = 1; i <= this.getNumberOfParamValues(); ++i) {
                this.clearParameter(i);
            }
            ParameterProperties.this.numberOfOutParams = 0;
            this.m_abyNullIndicatorBits = new byte[this.m_nByteCountForNullIndicatorBits];
        }

        public void clearParameter(int n) {
            this.m_aAttributeParamSets[--n] = null;
            this.m_aoValues[n] = null;
            this.m_abNullValues[n] = false;
            this.m_anPrecs[n] = 0;
            this.m_anScales[n] = 0;
            this.m_anSqlTypes[n] = 0;
            this.m_anOutParamSqlTypes[n] = 0;
            this.m_anLengths[n] = 0;
            this.m_anParamTypes[n] = 4;
            this.m_abyBinaryValues[n] = null;
            this.m_asOutParamNames[n] = null;
            this.m_abyServerCharsetCodes[n] = 0;
            this.m_anMetadataItemNumbers[n] = 0;
            this.m_bArrayElements = false;
            this.m_bArrayParentIsNull = false;
            this.m_anColumnIndexes[n] = -1;
            this.m_anArrayParameterIndexes[n] = -1;
            this.m_aanArrayElementIndexes[n] = null;
            this.m_aasAppMethodNames[n] = null;
        }

        public int getNumberOfParamValues() {
            return this.m_aoValues.length;
        }

        public int getNumberOfOutParams() {
            return ParameterProperties.this.numberOfOutParams;
        }

        public void setNullIndicatorBits(byte[] byArray) {
            this.m_nByteCountForNullIndicatorBits = byArray.length;
            this.m_abyNullIndicatorBits = new byte[this.m_nByteCountForNullIndicatorBits];
            System.arraycopy(byArray, 0, this.m_abyNullIndicatorBits, 0, this.m_nByteCountForNullIndicatorBits);
        }

        public byte[] getNullIndicatorBits() {
            return this.m_abyNullIndicatorBits;
        }

        public int getDataSize() {
            return this.internalGetDataSize(this);
        }

        private int internalGetDataSize(ParameterSet parameterSet) {
            int n = 0;
            for (int i = 1; i <= parameterSet.getNumberOfParamValues(); ++i) {
                if (parameterSet.getParamType(i) == 2) continue;
                n += parameterSet.getBinaryValue(i).length;
                if (!parameterSet.isStruct(i) && !parameterSet.isArray(i)) continue;
                n += this.internalGetDataSize(parameterSet.getAttributeParamSet(i));
            }
            return n + (parameterSet.isArrayElements() ? 2 + (!parameterSet.isParentArrayNull() ? 4 + parameterSet.getNullIndicatorBitsSize() : 0) : 0);
        }

        public short getArrayDataSize() {
            return (short)(!this.m_bArrayElements || this.isParentArrayNull() ? 0 : this.internalGetDataSize(this) - 2);
        }

        public int getSlobLength(int n, int n2, ArrayList arrayList) throws SQLException {
            return this.getSlobLength(this, n, n2, arrayList);
        }

        private int getSlobLength(ParameterSet parameterSet, int n, int n2, ArrayList arrayList) throws SQLException {
            int n3 = 0;
            for (int i = 0; i < parameterSet.getNumberOfParamValues(); ++i) {
                Object object;
                long l;
                int n4;
                if (parameterSet.isStruct(i + 1)) {
                    n4 = this.getSlobLength(parameterSet.getAttributeParamSet(i + 1), n, n2, arrayList);
                    n3 += n4;
                    n -= n4;
                }
                if (parameterSet.isNullValue(i + 1) || !JDBC4Constants.isDeferredLobType(parameterSet.m_anSqlTypes[i]) || parameterSet.m_anLengths[i] > ParameterProperties.this.m_session.getURLParameters().getSlobTransmitThreshold() || (long)n < (l = (long)parameterSet.m_anLengths[i] * (long)(n4 = ParameterProperties.this.m_session.getCharsetInfo().getMaxBytePerCharacter()) + (long)n2)) continue;
                int n5 = ByteBuffer.wrap(parameterSet.m_abyBinaryValues[i]).getInt();
                try {
                    object = ParameterProperties.this.m_session.getDeferredLob(n5);
                    l = ((DeferredLob)object).readDeferredLob(parameterSet.m_anLengths[i] * n4);
                }
                catch (IOException iOException) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ804", iOException.getMessage());
                    sQLException.initCause(iOException);
                    throw sQLException;
                }
                object = new int[]{n5, parameterSet.m_anMetadataItemNumbers[i]};
                arrayList.add(object);
                n3 += (int)l + n2;
                n -= (int)l + n2;
            }
            return n3;
        }

        public int getNullIndicatorBitsSize() {
            return this.m_nByteCountForNullIndicatorBits;
        }

        protected void createNullIndicatorBitArray() {
            int n = this.m_bArrayElements ? this.m_nArrayNumOfElementsAndAttributes : ParameterProperties.this.calculateTotalNumberOfParams(ParameterProperties.this.getCurrentDataInfoFields(), false) - ParameterProperties.this.getNumOfOutOnlyParams();
            this.m_nByteCountForNullIndicatorBits = (n + 7) / 8;
            this.m_abyNullIndicatorBits = new byte[this.m_nByteCountForNullIndicatorBits];
            int n2 = 0;
            for (int i = 1; i <= this.getNumberOfParamValues(); ++i) {
                if (this.getParamType(i) == 2) continue;
                ++n2;
                if (this.isNullValue(i)) {
                    ParameterProperties.setNullIndicatorBitWithinArray(n2, this.m_abyNullIndicatorBits);
                }
                if (!this.isStruct(i)) continue;
                n2 = this.setNullAttributes(this.getAttributeParamSet(i), this.m_abyNullIndicatorBits, n2);
            }
        }

        private int setNullAttributes(ParameterSet parameterSet, byte[] byArray, int n) {
            for (int i = 1; i <= parameterSet.getNumberOfParamValues(); ++i) {
                ++n;
                if (parameterSet.isNullValue(i)) {
                    ParameterProperties.setNullIndicatorBitWithinArray(n, byArray);
                }
                if (!parameterSet.isStruct(i)) continue;
                n = this.setNullAttributes(parameterSet.getAttributeParamSet(i), byArray, n);
            }
            return n;
        }

        public void resetDecimal(int n, int n2) {
            this.m_aoValues[n - 1] = n2 < this.m_anScales[n - 1] ? ComUtil.adjustScale((BigDecimal)this.m_aoValues[n - 1], this.m_anScales[n - 1], n2) : ((BigDecimal)this.m_aoValues[n - 1]).movePointRight(n2 - this.m_anScales[n - 1]);
            this.m_anScales[n - 1] = n2;
            if (this.m_abyBinaryValues[n - 1].length == 16) {
                ByteConverter.bigIntToByteArray(((BigDecimal)this.m_aoValues[n - 1]).toBigInteger(), this.m_abyBinaryValues[n - 1], 0);
            } else {
                ByteConverter.putLong(this.m_abyBinaryValues[n - 1], 0, ((BigDecimal)this.m_aoValues[n - 1]).longValue());
            }
        }

        public void resetTimeAndTimestamp(int n, int n2) throws SQLException {
            if (!(this.m_aoValues[n - 1] instanceof Time) && !(this.m_aoValues[n - 1] instanceof Timestamp)) {
                return;
            }
            String string = Decoder.decodeStringParameter(ParameterProperties.this.m_session, this.m_abyBinaryValues[n - 1]);
            String string2 = this.getTimeAndTimestampTrailingZeros(n, n2, string);
            if (string.length() >= 6 && (string.charAt(string.length() - 6) == '+' || string.charAt(string.length() - 6) == '-')) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.insert(string.length() - 6, string2);
                this.m_abyBinaryValues[n - 1] = Encoder.encodeStringParameter(ParameterProperties.this.m_session, n, stringBuffer.toString());
            } else {
                this.m_abyBinaryValues[n - 1] = Encoder.encodeStringParameter(ParameterProperties.this.m_session, n, string.concat(string2));
            }
            this.m_anLengths[n - 1] = this.m_abyBinaryValues[n - 1].length;
        }

        private void resetFixedWidthBytes(int n, int n2) {
            byte[] byArray = this.m_abyBinaryValues[n - 1];
            byte[] byArray2 = new byte[n2];
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, byArray2.length));
            }
            this.m_aoValues[n - 1] = byArray2;
            this.m_abyBinaryValues[n - 1] = byArray2;
            this.m_anLengths[n - 1] = byArray2.length;
        }

        public void resetToSpaces(int n, int n2) throws SQLException {
            this.m_abyBinaryValues[n - 1] = TDPreparedStatement.spacesForNullValue(n, true, n2, ParameterProperties.this.m_session);
            this.m_anLengths[n - 1] = this.m_abyBinaryValues[n - 1].length;
        }

        private String getTimeAndTimestampTrailingZeros(int n, int n2, String string) throws SQLException {
            char[] cArray;
            int n3 = n2 - this.m_anScales[n - 1];
            if (string.indexOf(".") >= 0) {
                cArray = new char[n3];
                for (int i = 0; i < n3; ++i) {
                    cArray[i] = 48;
                }
            } else {
                cArray = new char[n3 + 1];
                cArray[0] = 46;
                for (int i = 1; i <= n3; ++i) {
                    cArray[i] = 48;
                }
            }
            return new String(cArray);
        }

        public Object getValue(int n) {
            return this.m_aoValues[n - 1];
        }

        public byte[] getBinaryValue(int n) {
            return this.m_abyBinaryValues[n - 1];
        }

        public void setBinaryValue(int n, byte[] byArray) {
            this.m_abyBinaryValues[n - 1] = byArray;
            this.setParamType(n, 1);
        }

        public boolean isNullValue(int n) {
            return this.m_abNullValues[n - 1];
        }

        public void setSqlType(int n, int n2) {
            this.m_anSqlTypes[n - 1] = n2;
        }

        public int getSqlType(int n) {
            return this.m_anSqlTypes[n - 1];
        }

        public int getOutParamSqlType(int n) {
            return this.m_anOutParamSqlTypes[n - 1];
        }

        public void setOutParamSqlType(int n, int n2) {
            this.m_anOutParamSqlTypes[n - 1] = n2;
        }

        public void setOutParamName(int n, String string) {
            this.m_asOutParamNames[n - 1] = string;
        }

        public String getOutParamName(int n) {
            return this.m_asOutParamNames[n - 1];
        }

        public byte getServerCharsetCode(int n) {
            return this.m_abyServerCharsetCodes[n - 1];
        }

        public void setServerCharsetCode(int n, byte by) {
            this.m_abyServerCharsetCodes[n - 1] = by;
        }

        public void setParamType(int n, int n2) {
            if (this.m_anParamTypes[n - 1] == n2) {
                return;
            }
            if (this.m_anParamTypes[n - 1] == 4) {
                this.m_anParamTypes[n - 1] = n2;
            } else if (this.m_anParamTypes[n - 1] == 1 && n2 == 2 || this.m_anParamTypes[n - 1] == 2 && n2 == 1 || n2 == 3) {
                this.m_anParamTypes[n - 1] = 3;
            }
        }

        public int getParamType(int n) {
            return this.m_anParamTypes[n - 1];
        }

        public int getPrec(int n) {
            return this.m_anPrecs[n - 1];
        }

        public int getScale(int n) {
            return this.m_anScales[n - 1];
        }

        public int getLength(int n) {
            return this.m_anLengths[n - 1];
        }

        public void setLength(int n, int n2) {
            this.m_anLengths[n - 1] = n2;
        }

        public void setAttributeParamSet(int n, ParameterSet parameterSet) {
            if (this.m_aAttributeParamSets.length == 0) {
                return;
            }
            this.m_aAttributeParamSets[n - 1] = parameterSet;
        }

        public ParameterSet getAttributeParamSet(int n) {
            return this.m_aAttributeParamSets[n - 1];
        }

        public boolean isStruct(int n) {
            return this.m_anSqlTypes[n - 1] == 441;
        }

        public int getArrayNumOfElementsAndAttributes() {
            return this.m_nArrayNumOfElementsAndAttributes;
        }

        public void calculateAndSetArrayElementsAndAttributes() {
            this.m_nArrayNumOfElementsAndAttributes = this.isArrayElements() ? ParameterProperties.this.calculateTotalNumberOfParams(ParameterProperties.this.m_aCurrentDataInfoFields, true) * this.getNumberOfParamValues() : 0;
        }

        public void setIsArrayElements(boolean bl) {
            this.m_bArrayElements = bl;
        }

        public boolean isArrayElements() {
            return this.m_bArrayElements;
        }

        public void setParentArrayNullValue(boolean bl) {
            this.m_bArrayParentIsNull = bl;
        }

        public boolean isParentArrayNull() {
            return this.m_bArrayParentIsNull;
        }

        public boolean isArray(int n) {
            return this.m_anSqlTypes[n - 1] == 505 || this.m_anSqlTypes[n - 1] == 509;
        }

        public int getColumnIndex(int n) {
            return this.m_anColumnIndexes[n - 1];
        }

        public void setColumnIndex(int n, int n2) {
            this.m_anColumnIndexes[n - 1] = n2;
        }

        public int getArrayParameterIndex(int n) {
            return this.m_anArrayParameterIndexes[n - 1];
        }

        public void setArrayParameterIndex(int n, int n2) {
            this.m_anArrayParameterIndexes[n - 1] = n2;
        }

        public int[] getArrayElementIndex(int n) {
            return this.m_aanArrayElementIndexes[n - 1];
        }

        public void setArrayElementIndex(int n, int[] nArray) {
            this.m_aanArrayElementIndexes[n - 1] = nArray;
        }

        private String[] getAppMethodNames(int n) {
            return this.m_aasAppMethodNames[n - 1];
        }

        private void setAppMethodNames(int n, String[] stringArray) {
            this.m_aasAppMethodNames[n - 1] = stringArray;
        }

        protected void setMetadataItemNumber(int n, int n2) {
            this.m_anMetadataItemNumbers[n - 1] = n2;
        }
    }
}

