"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const devEnv = {
            account: process.env.CDK_DEFAULT_ACCOUNT,
            region: process.env.CDK_DEFAULT_REGION,
        };
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'ecr-public-gc', { env: devEnv });
        this.stack = [stack];
        new _1.TidyUp(stack, 'TidyUp', {
            repository: [
                'vscode',
                'gitpod-workspace',
                'github-codespace',
            ],
            schedule: events.Schedule.cron({ hour: '*/4', minute: '0' }),
        });
        app.synth();
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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