# coding: utf-8

"""
    perceptic-core-server API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1-SNAPSHOT
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from perceptic_core_client.models.schedule_trigger import ScheduleTrigger
from typing import Optional, Set
from typing_extensions import Self

class CreateIndexingScheduleRequest(BaseModel):
    """
    CreateIndexingScheduleRequest
    """ # noqa: E501
    name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="Display name for the schedule")
    description: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = Field(default=None, description="Optional description of the schedule's purpose")
    indexer_rid: StrictStr = Field(description="RID of the indexer to use", alias="indexerRid")
    target_uri: StrictStr = Field(description="URI of folder or filesystem to index", alias="targetUri")
    namespace: Annotated[str, Field(strict=True)] = Field(description="Namespace for indexing")
    target_minimum_version: Optional[StrictInt] = Field(default=None, description="Minimum indexer version required", alias="targetMinimumVersion")
    indexing_settings: Optional[Dict[str, Any]] = Field(default=None, description="Indexer-specific settings", alias="indexingSettings")
    trigger: ScheduleTrigger
    enabled: Optional[StrictBool] = Field(default=None, description="Whether the schedule is enabled")
    __properties: ClassVar[List[str]] = ["name", "description", "indexerRid", "targetUri", "namespace", "targetMinimumVersion", "indexingSettings", "trigger", "enabled"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\S", value):
            raise ValueError(r"must validate the regular expression /\S/")
        return value

    @field_validator('namespace')
    def namespace_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\S", value):
            raise ValueError(r"must validate the regular expression /\S/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateIndexingScheduleRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of trigger
        if self.trigger:
            _dict['trigger'] = self.trigger.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateIndexingScheduleRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "indexerRid": obj.get("indexerRid"),
            "targetUri": obj.get("targetUri"),
            "namespace": obj.get("namespace"),
            "targetMinimumVersion": obj.get("targetMinimumVersion"),
            "indexingSettings": obj.get("indexingSettings"),
            "trigger": ScheduleTrigger.from_dict(obj["trigger"]) if obj.get("trigger") is not None else None,
            "enabled": obj.get("enabled")
        })
        return _obj


