# -*- coding: utf-8 -*-
"""
Created on Thu Aug 23 14:26:41 2018

@author: yoelr
"""
from .. import Unit

__all__ = ('Mixer',)

class Mixer(Unit):
    """
    Create a mixer that mixes any number of streams together.
    
    Parameters
    ----------
    ins :
        Inlet streams to be mixed.
    outs :
        Mixed outlet stream.
    Examples
    --------
    Mix two streams:
    
    >>> from biosteam import units
    >>> import thermosteam as tmo
    >>> chemicals = tmo.Chemicals(['Ethanol', 'Water'])
    >>> tmo.settings.set_thermo(chemicals)
    >>> s1 = tmo.Stream('s1', Water=20, T=350)
    >>> s2 = tmo.Stream('s2', Ethanol=30, T=300)
    >>> M1 = units.Mixer('M1', ins=(s1, s2), outs='s3')
    >>> M1.simulate()
    >>> M1.show()
    Mixer: M1
    ins...
    [0] s1
        phase: 'l', T: 350 K, P: 101325 Pa
        flow (kmol/hr): Water  20
    [1] s2
        phase: 'l', T: 300 K, P: 101325 Pa
        flow (kmol/hr): Ethanol  30
    outs...
    [0] s3
        phase: 'l', T: 315.11 K, P: 101325 Pa
        flow (kmol/hr): Ethanol  30
                        Water    20
    
    
    """
    _has_cost = False
    _N_outs = 1
    _N_ins = 5
    _ins_size_is_fixed = False
    
    def _run(self):
        s_out, = self.outs
        s_out.mix_from(self.ins)
