# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-08 18:19
from __future__ import unicode_literals

from django.db import migrations, models
from six.moves.urllib_parse import urljoin, urlsplit  # pylint: disable=import-error
import django_extensions.db.fields
import model_utils.fields


def add_user_to_uri(apps, schema_editor):
    Formula = apps.get_model('formulas', 'Formula')

    for formula in Formula.objects.all():
        if not formula.git_username:
            continue

        url_bits = urlsplit(formula.uri)

        # rebuild the uri with the username in it
        formula.uri = urljoin((
            url_bits.scheme,
            '{}:{}'.format(formula.git_username, url_bits.netloc),
            url_bits.path,
            url_bits.query,
            url_bits.fragment,
        ))

        formula.save()


def remove_user_from_uri(apps, schema_editor):
    Formula = apps.get_model('formulas', 'Formula')

    for formula in Formula.objects.all():
        url_bits = urlsplit(formula.uri)

        # don't do it if it's an ssh formula
        if 'ssh' in url_bits.scheme:
            continue

        if url_bits.username:
            formula.git_username = url_bits.username

            if url_bits.port:
                new_netloc = '{}:{}'.format(url_bits.hostname, url_bits.port)
            else:
                new_netloc = url_bits.hostname

            formula.uri = urljoin((
                url_bits.scheme,
                new_netloc,
                url_bits.path,
                url_bits.query,
                url_bits.fragment,
            ))

            formula.save()


class Migration(migrations.Migration):

    dependencies = [
        ('formulas', '0001_0_8_initial'),
    ]

    operations = [
        migrations.AlterField(
            model_name='formula',
            name='created',
            field=django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='formula',
            name='modified',
            field=django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified'),
        ),
        migrations.AlterField(
            model_name='formula',
            name='status',
            field=model_utils.fields.StatusField(default='error', max_length=100, no_check_for_status=True, verbose_name='status'),
        ),
        migrations.AlterField(
            model_name='formulacomponent',
            name='created',
            field=django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='formulacomponent',
            name='modified',
            field=django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified'),
        ),
        migrations.RunPython(add_user_to_uri, remove_user_from_uri),
        migrations.RemoveField(
            model_name='formula',
            name='access_token',
        ),
        migrations.RemoveField(
            model_name='formula',
            name='git_username',
        ),
        migrations.AddField(
            model_name='formula',
            name='ssh_private_key',
            field=models.TextField(blank=True, verbose_name='SSH Private Key'),
        ),
    ]
