# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-11-14 22:13
from __future__ import unicode_literals

from django.db import migrations


def master_to_base(apps, schema_migration):
    """
    Convert all formula versions that are 'master' to 'base' instead
    since that what is required by the salt gitfs
    """
    FormulaVersion = apps.get_model('formulas', 'FormulaVersion')

    for v in FormulaVersion.objects.all():
        if v.version == 'master':
            v.version = 'base'
            v.save()


def base_to_master(apps, schema_migration):
    """
    **This is for the reverse migration**
    Convert all formula versions that are 'base' to 'master', since 'base' was not a valid
    version prior to using the salt gitfs
    """
    FormulaVersion = apps.get_model('formulas', 'FormulaVersion')

    for v in FormulaVersion.objects.all():
        if v.version == 'base':
            v.version = 'master'
            v.save()


class Migration(migrations.Migration):

    dependencies = [
        ('formulas', '0004_0_8_0_migrations'),
    ]

    operations = [
        migrations.RunPython(master_to_base, base_to_master),
    ]
