# -*- coding: utf-8 -*-
# Generated by Django 1.9.10 on 2016-10-26 20:07
from __future__ import unicode_literals

import json
import os

import django.core.files.base
from django.db import migrations


def delete_top_files(apps, schema_migration):
    Stack = apps.get_model('stacks', 'Stack')

    # Delete all the top files.
    for stack in Stack.objects.all():
        if os.path.exists(stack.top_file.path):
            os.remove(stack.top_file.path)


def get_properties(stack):
    if not stack.props_file:
        return {}
    with open(stack.props_file.path, 'r') as f:
        return json.load(f)


def set_properties(stack, props):
    props_json = json.dumps(props, indent=4)
    if not stack.props_file:
        stack.props_file.save('stack.props', django.core.files.base.ContentFile(props_json))
    else:
        with open(stack.props_file.path, 'w') as f:
            f.write(props_json)


def props_file_to_db(apps, schema_migration):
    Stack = apps.get_model('stacks', 'Stack')

    for stack in Stack.objects.all():
        # Grab the properties from the file and save them to the database
        stack.properties = get_properties(stack)
        stack.save()


def db_to_props_file(apps, schema_migration):
    Stack = apps.get_model('stacks', 'Stack')

    for stack in Stack.objects.all():
        # Grab the properties from the database and save them to the filesystem
        set_properties(stack, stack.properties)
        stack.save()


class Migration(migrations.Migration):

    dependencies = [
        ('stacks', '0005_0_8_0_migrations'),
    ]

    operations = [
        migrations.RunPython(delete_top_files, lambda a, s: None),
        # Then copy everything from all the props files into the properties field
        migrations.RunPython(props_file_to_db, db_to_props_file),
    ]
