# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-08 18:19
from __future__ import unicode_literals

from django.db import migrations


def forwards_func(apps, schema_editor):
    Volume = apps.get_model('volumes', 'Volume')

    # Get the blueprint volume from the host def
    for volume in Volume.objects.all():
        for blueprint_volume in volume.host.blueprint_host_definition.volumes.all():
            if blueprint_volume.snapshot == volume.snapshot:
                volume.blueprint_volume = blueprint_volume
                volume.save()


def reverse_func(apps, schema_editor):
    Volume = apps.get_model('volumes', 'Volume')

    # Just put the snapshot back in place
    for volume in Volume.objects.all():
        snapshot = volume.blueprint_volume.snapshot

        if snapshot is None:
            # If the snapshot is null, just delete this volume... it's an invalid configuration
            # going backwards.
            volume.delete()
            continue

        volume.snapshot = snapshot
        volume.hostname = volume.host.hostname
        volume.device = volume.blueprint_volume.device
        volume.mount_point = volume.blueprint_volume.mount_point
        volume.save()


class Migration(migrations.Migration):

    dependencies = [
        ('volumes', '0002_0_8_0_migrations'),
    ]

    operations = [
        # Set the appropriate fields
        migrations.RunPython(forwards_func, reverse_func),
    ]
