# -*- coding: utf-8 -*-
# Generated by Django 1.9.10 on 2016-10-03 20:46
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import stackdio.core.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('core', '0002_0_8_0_migrations'),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('sent', models.BooleanField(default=False, verbose_name='Sent')),
                ('failed_count', models.PositiveIntegerField(default=0, verbose_name='Failed Count')),
                ('object_id', models.PositiveIntegerField()),
                ('auth_object_id', models.PositiveIntegerField()),
                ('auth_object_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.ContentType')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.ContentType')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event')),
            ],
            options={
                'ordering': ('-modified', '-created'),
                'abstract': False,
                'get_latest_by': 'modified',
            },
        ),
        migrations.CreateModel(
            name='NotificationChannel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('auth_object_id', models.PositiveIntegerField()),
                ('auth_object_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('events', models.ManyToManyField(related_name='channels', to='core.Event')),
            ],
        ),
        migrations.CreateModel(
            name='NotificationHandler',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('notifier', models.CharField(max_length=256, verbose_name='Notifier')),
                ('options', stackdio.core.fields.JSONField(verbose_name='Options')),
                ('verified', models.BooleanField(default=False, verbose_name='Verified')),
                ('disabled', models.BooleanField(default=False, verbose_name='Disabled')),
                ('channel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='handlers', to='notifications.NotificationChannel')),
            ],
        ),
        migrations.CreateModel(
            name='SubscribedObjectProxy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.AddField(
            model_name='notificationchannel',
            name='subscribed_object_proxies',
            field=models.ManyToManyField(related_name='channels', to='notifications.SubscribedObjectProxy'),
        ),
        migrations.AddField(
            model_name='notification',
            name='handler',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notifications.NotificationHandler'),
        ),
        migrations.AlterUniqueTogether(
            name='subscribedobjectproxy',
            unique_together=set([('content_type', 'object_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='notificationchannel',
            unique_together=set([('name', 'auth_object_content_type', 'auth_object_id')]),
        ),
    ]
