/*!
  * Copyright 2017,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","underscore","knockout","bootbox","moment","utils/utils"],function(e,t,a,s,r,o){"use strict";function n(e,t){var s=!1;"string"==typeof e&&(s=!0,e={name:e,url:"/api/environments/"+e+"/"}),this.raw=e,this.parent=t,this.id=e.name,this.detailUrl="/environments/"+this.id+"/",this.name=a.observable(),this.description=a.observable(),this.orchestrateSlsPath=a.observable(),this.labelList=a.observable(),this.createUsers=a.observable(),this.activity=a.observable(),this.health=a.observable(),this.labelClass=a.observable(),this.healthLabelClass=a.observable(),this.properties=a.observable({}),this.components=a.observableArray([]),this.availableActions=a.observableArray([]),this.formulaVersions=a.observableArray([]),this.latestLogs=a.observableArray([]),this.historicalLogs=a.observableArray([]),s?this.waiting=this.reload():this._process(e)}return n.constructor=n,n.prototype.actionMessages={orchestrate:"This will re-run all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.","propagate-ssh":'This will create new users for everyone with "ssh" permission.',provision:"This will re-run core provisioning, in addition to re-running all of your custom formula components.  This may overwrite anything you have manually changed on your hosts."},n.prototype._processActivity=function(e){switch(this.activity(e),e){case"idle":this.labelClass("label-success");break;case"launching":case"provisioning":case"orchestrating":case"resuming":case"pausing":case"executing":case"terminating":this.labelClass("label-warning");break;case"queued":case"paused":case"terminated":this.labelClass("label-info");break;case"dead":this.labelClass("label-danger");break;case"unknown":default:this.labelClass("label-default")}},n.prototype._processHealth=function(e){switch(this.health(e),e){case"healthy":this.healthLabelClass("label-success");break;case"unstable":this.healthLabelClass("label-warning");break;case"unhealthy":this.healthLabelClass("label-danger");break;case"unknown":default:this.healthLabelClass("label-default")}},n.prototype._process=function(e){this.name(e.name),this.description(e.description),this.labelList(e.label_list),this.createUsers(e.create_users),this.orchestrateSlsPath(e.orchestrate_sls_path),this._processActivity(e.activity),this._processHealth(e.health)},n.prototype.reload=function(){var t=this;return e.ajax({method:"GET",url:this.raw.url}).done(function(e){t.raw=e,t._process(e)})},n.prototype.loadProperties=function(){var t=this;return this.raw.hasOwnProperty("properties")||(this.raw.properties=this.raw.url+"properties/"),e.ajax({method:"GET",url:this.raw.properties}).done(function(e){t.properties(e)})},n.prototype.saveProperties=function(){e.ajax({method:"PUT",url:this.raw.properties,data:JSON.stringify(this.properties())}).done(function(e){o.growlAlert("Successfully saved environment properties!","success")}).fail(function(e){var t;try{var a=JSON.parse(e.responseText);t=a.properties.join("<br>")}catch(e){t="Oops... there was a server error."}t+="  Your properties were not saved.",o.growlAlert(t,"danger")})},n.prototype.save=function(){var t=this,a=["name","description","create_users","orchestrate_sls_path"];a.forEach(function(t){var a=e("#"+t);a.removeClass("has-error"),a.find(".help-block").remove()}),e.ajax({method:"PUT",url:t.raw.url,data:JSON.stringify({name:t.name(),description:t.description(),create_users:t.createUsers(),orchestrate_sls_path:t.orchestrateSlsPath()})}).done(function(e){o.growlAlert("Successfully saved environment!","success");try{t.parent.environmentName(e.name)}catch(e){}}).fail(function(e){o.parseSaveError(e,"environment",a)})},n.prototype.delete=function(){var t=this,a=this.name();s.confirm({name:"Confirm delete of <strong>"+a+"</strong>",message:"Are you sure you want to delete <strong>"+a+"</strong>?",buttons:{confirm:{label:"Delete",className:"btn-danger"}},callback:function(a){a&&e.ajax({method:"DELETE",url:t.raw.url}).done(function(){"/environments/"!==window.location.pathname?window.location="/environments/":t.parent&&"function"==typeof t.parent.reload&&t.parent.reload()}).fail(function(e){var t;try{var a=JSON.parse(e.responseText);t=a.detail.join("<br>")}catch(e){t="Oops... there was a server error.  This has been reported to your administrators."}s.alert({name:"Error deleting environment",message:t})})}})},n.prototype.refreshActivity=function(){var t=this;return e.ajax({method:"GET",url:t.raw.url}).done(function(e){t.raw=e,t._processActivity(e.activity),t._processHealth(e.health)}).fail(function(e){403==e.status&&window.location.reload(!0)})},n.prototype.loadAvailableActions=function(){var t=this;this.raw.hasOwnProperty("action")||(this.raw.action=this.url+"action/"),e.ajax({method:"GET",url:this.raw.action}).done(function(e){t.availableActions(e.available_actions);try{t.parent.actionMap[t.id]=e.available_actions}catch(e){}})},n.prototype.runSingleSls=function(a,r){var n=this,i=t.escape(n.name());s.confirm({title:"Confirm component run for <strong>"+i+"</strong>",message:"Are you sure you want to run "+a+" on "+i+"?",buttons:{confirm:{label:"Run",className:"btn-primary"}},callback:function(t){if(t){var i={component:a};r&&(i.host_target=r),e.ajax({method:"POST",url:n.raw.action,data:JSON.stringify({action:"single-sls",args:[i]})}).done(function(){n.parent&&"function"==typeof n.parent.reload&&n.parent.reload(),o.growlAlert("Triggered "+a+".","success")}).fail(function(e){var t;try{var a=JSON.parse(e.responseText);t=a.action.join("<br>")}catch(e){t="Oops... there was a server error.  This has been reported to your administrators."}s.alert({title:"Error running component",message:t})})}}})},n.prototype.performAction=function(a){var r=this,o=t.escape(r.name()),n=this.actionMessages.hasOwnProperty(a)?this.actionMessages[a]:"";s.confirm({title:"Confirm action for <strong>"+o+"</strong>",message:'Are you sure you want to perform the "'+a+'" action on <strong>'+o+"</strong>?<br>"+n,buttons:{confirm:{label:a.capitalize().replace("_"," "),className:"btn-primary"}},callback:function(t){t&&e.ajax({method:"POST",url:r.raw.action,data:JSON.stringify({action:a})}).done(function(){r.parent&&"function"==typeof r.parent.reload?r.parent.reload():r.reload()}).fail(function(e){var t;try{var r=JSON.parse(e.responseText);t=r.action.join("<br>")}catch(e){t="Oops... there was a server error.  This has been reported to your administrators."}s.alert({title:'Error performing the "'+a+'" action',message:t})})}})},n.prototype._processStatus=function(e){switch(e.status){case"queued":e.statusPanel="panel-info",e.statusLabel="label-info";break;case"running":e.statusPanel="panel-warning",e.statusLabel="label-warning";break;case"succeeded":e.statusPanel="panel-success",e.statusLabel="label-success";break;case"failed":e.statusPanel="panel-danger",e.statusLabel="label-danger";break;case"cancelled":case"unknown":default:e.statusPanel="panel-default",e.statusLabel="label-default"}},n.prototype._processHostHealth=function(e){switch(e.health){case"healthy":e.healthPanel="panel-success",e.healthLabel="label-success";break;case"unstable":e.healthPanel="panel-warning",e.healthLabel="label-warning";break;case"unhealthy":e.healthPanel="panel-danger",e.healthLabel="label-danger";break;case"unknown":default:e.healthPanel="panel-default",e.healthLabel="label-default"}},n.prototype.loadComponents=function(){var t=this;return this.raw.hasOwnProperty("components")||(this.raw.components=this.raw.url+"components/"),e.ajax({method:"GET",url:this.raw.components}).done(function(e){e.results.forEach(function(e){e.htmlId=e.sls_path.replace(/\./g,"-"),e.hosts.forEach(function(e){e.timestamp=r(e.timestamp),t._processStatus(e),t._processHostHealth(e)}),t._processStatus(e),t._processHostHealth(e)}),t.components(e.results)})},n.prototype.loadLogs=function(){var t=this;this.raw.hasOwnProperty("logs")||(this.raw.logs=this.raw.url+"logs/"),e.ajax({method:"GET",url:this.raw.logs}).done(function(e){var a=[];for(var s in e.latest)e.latest.hasOwnProperty(s)&&a.push({text:s,type:"item",url:e.latest[s]});t.latestLogs(a);var r=[];e.historical.forEach(function(e){var t=e.split("/");r.push({text:t[t.length-1],type:"item",url:e})}),t.historicalLogs(r)})},n});