/*!
  * Copyright 2017,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","underscore","knockout","bootbox","utils/utils","models/component"],function(t,e,r,a,s,o){"use strict";function i(t,e){var a=!1;"string"==typeof t&&(t=parseInt(t)),"number"==typeof t&&(a=!0,t={id:t,url:"/api/formulas/"+t+"/",valid_versions:"/api/formulas/"+t+"/valid_versions/"}),this.raw=t,this.parent=e,this.id=t.id,this.detailUrl="/formulas/"+this.id+"/",this.title=r.observable(),this.description=r.observable(),this.uri=r.observable(),this.sshPrivateKey=r.observable(),this.rootPath=r.observable(),this.status=r.observable(),this.statusDetail=r.observable(),this.labelClass=r.observable(),this.properties=r.observable({}),this.components=r.observableArray([]),this.validVersions=r.observableArray([]),this.availableActions=r.observableArray([]),a?this.waiting=this.reload():this._process(t)}return i.constructor=i,i.prototype.actionMessages={update:"This will update your formula to the most recent commit on the main branch."},i.prototype._process=function(t){switch(this.title(t.title),this.description(t.description),this.uri(t.uri),this.rootPath(t.root_path),this.status(t.status),this.statusDetail(t.status_detail),t.status){case"complete":this.labelClass("label-success");break;case"importing":this.labelClass("label-warning");break;case"error":this.labelClass("label-danger");break;default:this.labelClass("label-default")}},i.prototype.reload=function(){var e=this;return t.ajax({method:"GET",url:this.raw.url}).done(function(t){e.raw=t,e._process(t)}).fail(function(t){403==t.status&&window.location.reload(!0)})},i.prototype.loadProperties=function(){var e=this;return this.raw.hasOwnProperty("properties")||(this.raw.properties=this.raw.url+"properties/"),t.ajax({method:"GET",url:this.raw.properties}).done(function(t){e.properties(t)})},i.prototype.loadComponents=function(){var e=this;this.raw.hasOwnProperty("components")||(this.raw.components=this.raw.url+"components/"),t.ajax({method:"GET",url:this.raw.components}).done(function(t){e.components(t.results.map(function(t){return new o(t,e.parent,e)}))})},i.prototype.loadValidVersions=function(){var e=this;this.raw.hasOwnProperty("valid_versions")||(this.raw.valid_versions=this.raw.url+"valid_versions/"),t.ajax({method:"GET",url:this.raw.valid_versions}).done(function(t){e.validVersions(t.results)})},i.prototype.loadAvailableActions=function(){var e=this;this.raw.hasOwnProperty("action")||(this.raw.action=this.url+"action/"),t.ajax({method:"GET",url:this.raw.action}).done(function(t){e.availableActions(t.available_actions);try{e.parent.actionMap[e.id]=t.available_actions}catch(t){}})},i.prototype.performAction=function(r){var s=this,o=e.escape(s.title()),i=this.actionMessages.hasOwnProperty(r)?this.actionMessages[r]:"";a.confirm({title:"Confirm action for <strong>"+o+"</strong>",message:'Are you sure you want to perform the "'+r+'" action on <strong>'+o+"</strong>?<br>"+i,buttons:{confirm:{label:r.capitalize().replace("_"," "),className:"btn-primary"}},callback:function(e){e&&t.ajax({method:"POST",url:s.raw.action,data:JSON.stringify({action:r})}).done(function(){s.parent&&"function"==typeof s.parent.reload?s.parent.reload():s.reload()}).fail(function(t){var e;try{var s=JSON.parse(t.responseText);e=s.action.join("<br>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}a.alert({title:'Error performing the "'+r+'" action',message:e})})}})},i.prototype.save=function(){var e=this,r=["ssh_private_key","uri"];r.forEach(function(e){var r=t("#"+e);r.removeClass("has-error"),r.find(".help-block").remove()}),t.ajax({method:"PUT",url:e.raw.url,data:JSON.stringify({uri:e.uri(),ssh_private_key:e.sshPrivateKey()})}).done(function(t){s.growlAlert("Successfully saved formula!","success")}).fail(function(t){s.parseSaveError(t,"formula",r)})},i.prototype.delete=function(){var e=this,r=this.title();a.confirm({title:"Confirm delete of <strong>"+r+"</strong>",message:"Are you sure you want to delete <strong>"+r+"</strong>?",buttons:{confirm:{label:"Delete",className:"btn-danger"}},callback:function(r){r&&t.ajax({method:"DELETE",url:e.raw.url}).done(function(){"/formulas/"!==window.location.pathname?window.location="/formulas/":e.parent&&"function"==typeof e.parent.reload&&e.parent.reload()}).fail(function(t){var e;try{var r=JSON.parse(t.responseText);e=r.detail.join("<br>"),Object.keys(r).indexOf("blueprints")>=0&&(e+="<br><br>Blueprints:<ul><li>"+r.blueprints.join("</li><li>")+"</li></ul>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}a.alert({title:"Error deleting formula",message:e})})}})},i});