import { aws_cloudfront, aws_lambda } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { BaseEdgeConstruct } from './base-edge-construct';
import { IEdgeLambda } from './edge-lambda';
import { IEdgeRole } from './edge-role';
import { Configuration } from './with-configuration';
export interface CommonEdgeFunctionProps {
    /**
     * The name of the parameter.
     */
    readonly parameterName?: string;
    readonly edgeRole?: IEdgeRole;
}
export interface EdgeFunctionProps extends CommonEdgeFunctionProps {
    readonly configuration: Configuration;
    readonly code: aws_lambda.Code;
    readonly name: string;
    readonly eventType: aws_cloudfront.LambdaEdgeEventType;
}
export declare class EdgeFunction extends BaseEdgeConstruct implements IEdgeLambda {
    readonly edgeRole: IEdgeRole;
    readonly eventType: aws_cloudfront.LambdaEdgeEventType;
    readonly functionVersion: aws_lambda.IVersion;
    constructor(scope: Construct, id: string, props: EdgeFunctionProps);
}
