# Copyright (C) 2012-2018 The python-bitcoinlib developers
#
# This file is part of python-bitcoinlib.
#
# It is subject to the license terms in the LICENSE file found in the top-level
# directory of this distribution.
#
# No part of python-bitcoinlib, including this file, may be copied, modified,
# propagated, or distributed except according to the terms contained in the
# LICENSE file.

from __future__ import absolute_import, division, print_function, unicode_literals

import omnicore.core

# Note that setup.py can break if __init__.py imports any external
# dependencies, as these might not be installed when setup.py runs. In this
# case __version__ could be moved to a separate version.py and imported here.
__version__ = "0.0.1"


class MainParams(omnicore.core.CoreMainParams):
    MESSAGE_START = b"\xf9\xbe\xb4\xd9"
    DEFAULT_PORT = 8333
    RPC_PORT = 8332
    DNS_SEEDS = (
        ("omnicore.sipa.be", "seed.omnicore.sipa.be"),
        ("bluematt.me", "dnsseed.bluematt.me"),
        ("dashjr.org", "dnsseed.omnicore.dashjr.org"),
        ("bitcoinstats.com", "seed.bitcoinstats.com"),
        ("xf2.org", "bitseed.xf2.org"),
        ("omnicore.jonasschnelli.ch", "seed.omnicore.jonasschnelli.ch"),
    )
    BASE58_PREFIXES = {"PUBKEY_ADDR": 0, "SCRIPT_ADDR": 5, "SECRET_KEY": 128}
    BECH32_HRP = "bc"


class TestNetParams(omnicore.core.CoreTestNetParams):
    MESSAGE_START = b"\x0b\x11\x09\x07"
    DEFAULT_PORT = 18333
    RPC_PORT = 18332
    DNS_SEEDS = (
        ("testnetbitcoin.jonasschnelli.ch", "testnet-seed.omnicore.jonasschnelli.ch"),
        ("petertodd.org", "seed.tbtc.petertodd.org"),
        ("bluematt.me", "testnet-seed.bluematt.me"),
        ("omnicore.schildbach.de", "testnet-seed.omnicore.schildbach.de"),
    )
    BASE58_PREFIXES = {"PUBKEY_ADDR": 111, "SCRIPT_ADDR": 196, "SECRET_KEY": 239}
    BECH32_HRP = "tb"


class RegTestParams(omnicore.core.CoreRegTestParams):
    MESSAGE_START = b"\xfa\xbf\xb5\xda"
    DEFAULT_PORT = 18444
    RPC_PORT = 18443
    DNS_SEEDS = ()
    BASE58_PREFIXES = {"PUBKEY_ADDR": 111, "SCRIPT_ADDR": 196, "SECRET_KEY": 239}
    BECH32_HRP = "bcrt"


"""Master global setting for what chain params we're using.

However, don't set this directly, use SelectParams() instead so as to set the
omnicore.core.params correctly too.
"""
# params = omnicore.core.coreparams = MainParams()
params = MainParams()


def SelectParams(name):
    """Select the chain parameters to use

    name is one of 'mainnet', 'testnet', or 'regtest'

    Default chain is 'mainnet'
    """
    global params
    omnicore.core._SelectCoreParams(name)
    if name == "mainnet":
        params = omnicore.core.coreparams = MainParams()
    elif name == "testnet":
        params = omnicore.core.coreparams = TestNetParams()
    elif name == "regtest":
        params = omnicore.core.coreparams = RegTestParams()
    else:
        raise ValueError("Unknown chain %r" % name)
