#
# Copyright (C) 2021-2022 by AyiinXd@Github, < https://github.com/AyiinXd >.
#
# This file is part of < https://github.com/AyiinXd/AyiinMusicBot > project,
# and is released under the "GNU v3.0 License Agreement".
# Please see < https://github.com/AyiinXd/AyiinMusicBot/blob/master/LICENSE >
#
# All rights reserved.

import os
import re
import textwrap

import aiofiles
import aiohttp
from PIL import (Image, ImageDraw, ImageEnhance, ImageFilter,
                 ImageFont, ImageOps)
from youtubesearchpython.__future__ import VideosSearch

import fipper


class ThumbnailSong:
    def changeImageSize(self: 'fipper.Client', maxWidth, maxHeight, image):
        widthRatio = maxWidth / image.size[0]
        heightRatio = maxHeight / image.size[1]
        newWidth = int(widthRatio * image.size[0])
        newHeight = int(heightRatio * image.size[1])
        newImage = image.resize((newWidth, newHeight))
        return newImage


    async def gen_thumb(
        self: 'fipper.Client',
        videoid,
        user_id,
        queue: bool = None
    ):
        if not os.path.isdir('cache/'):
            os.makedirs('cache/')

        if os.path.isfile(f"cache/{videoid}.png"):
            os.remove(f"cache/{videoid}.png")

        url = f"https://www.youtube.com/watch?v={videoid}"
        try:
            results = VideosSearch(url, limit=1)
            for result in (await results.next())["result"]:
                try:
                    title = result["title"]
                    title = re.sub("\\W+", " ", title)
                    title = title.title()
                except BaseException:
                    title = "Unsupported Title"
                try:
                    duration = result["duration"]
                except BaseException:
                    duration = "Unknown Mins"
                thumbnail = result["thumbnails"][0]["url"].split("?")[0]

            async with aiohttp.ClientSession() as session:
                async with session.get(thumbnail) as resp:
                    if resp.status == 200:
                        f = await aiofiles.open(
                            f"cache/thumb{videoid}.png", mode="wb"
                        )
                        await f.write(await resp.read())
                        await f.close()

            try:
                f_name = (await self.get_users(user_id)).username
                photos = [p async for p in self.get_chat_photos(user_id)]
                wxy = await self.download_media(photos[0].file_id, file_name=f'{user_id}.jpg')
            except:
                f_name = user_id
                photos = [p async for p in self.get_chat_photos("me")]
                wxy = await self.download_media(photos[0].file_id, file_name=f'{self.me.id}.jpg')

            youtube = Image.open(f"cache/thumb{videoid}.png")
            pp = Image.open(wxy)
            image1 = self.changeImageSize(1280, 720, youtube)
            image2 = image1.convert("RGBA")
            background = image2.filter(filter=ImageFilter.BoxBlur(30))
            enhancer = ImageEnhance.Brightness(background)
            background = enhancer.enhance(0.6)
            Xcenter = youtube.width / 2
            Ycenter = youtube.height / 2
            x1 = Xcenter - 250
            y1 = Ycenter - 250
            x2 = Xcenter + 250
            y2 = Ycenter + 250
            logo = youtube.crop((x1, y1, x2, y2))
            logo.thumbnail((520, 520), Image.LANCZOS)
            logo = ImageOps.expand(logo, border=10, fill="gainsboro")
            background.paste(logo, (50, 100))
            pp.thumbnail((125, 125), Image.LANCZOS)
            pepe = ImageOps.expand(pp, border=10, fill="gainsboro")
            background.paste(pepe, (460, 70))
            draw = ImageDraw.Draw(background)
            font = ImageFont.truetype("assets/font2.ttf", 40)
            font2 = ImageFont.truetype("assets/font2.ttf", 70)
            arial = ImageFont.truetype("assets/font2.ttf", 30)
            name_font = ImageFont.truetype("assets/font.ttf", 35)
            para = textwrap.wrap(title, width=32)
            j = 0
            type_play = "IN QUEUE" if queue else "NOW PLAYING"
            draw.text(
                (30, 5), f"{self.me.first_name.upper()} MUSIC", fill="white", font=name_font
            )
            draw.text(
                (600, 210),
                type_play,
                fill="white",
                stroke_width=2,
                stroke_fill="white",
                font=font2,
            )
            for line in para:
                if j == 1:
                    j += 1
                    draw.text(
                        (600, 345),
                        f"{line}",
                        fill="white",
                        stroke_width=1,
                        stroke_fill="white",
                        font=font,
                    )
                if j == 0:
                    j += 1
                    draw.text(
                        (600, 300),
                        f"{line}",
                        fill="white",
                        stroke_width=1,
                        stroke_fill="white",
                        font=font,
                    )

            draw.text(
                (600, 500),
                f"Duration : {duration[:23]} Mins",
                (255, 255, 255),
                font=arial,
            )
            draw.text(
                (600, 540),
                f"Request  : {f_name}",
                (255, 255, 255),
                font=arial,
            )
            try:
                os.remove(f"cache/thumb{videoid}.png")
            except BaseException:
                pass
            background.save(f"cache/{videoid}.png")
            return f"cache/{videoid}.png"
        except BaseException:
            return 'https://telegra.ph/file/e944cf18658f481083b1e.jpg'
