# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-07-08T18:21:47+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional, Union

from pydantic import BaseModel, Field


class Environment(BaseModel):
    env_key: str = Field(..., title="Env Key")
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(..., title="Description")
    default_version: Optional[str] = Field(..., title="Default Version")
    versions: Dict[str, str] = Field(..., title="Versions")


class Instance(BaseModel):
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    status: str = Field(..., title="Status")
    subdomain: str = Field(..., title="Subdomain")
    created_at: str = Field(..., title="Created At")
    updated_at: str = Field(..., title="Updated At")
    terminated_at: Optional[str] = Field(None, title="Terminated At")
    team_id: str = Field(..., title="Team Id")
    region: str = Field(..., title="Region")


class InstanceRequest(BaseModel):
    env_key: str = Field(..., title="Env Key")
    version: Optional[str] = Field(None, title="Version")
    region: Optional[str] = Field("us-east-2", title="Region")
    seed: Optional[int] = Field(None, title="Seed")
    timestamp: Optional[int] = Field(None, title="Timestamp")
    p_error: Optional[float] = Field(None, title="P Error")
    avg_latency: Optional[float] = Field(None, title="Avg Latency")
    run_id: Optional[str] = Field(None, title="Run Id")
    task_id: Optional[str] = Field(None, title="Task Id")


class InstanceStatus(Enum):
    pending = "pending"
    running = "running"
    stopped = "stopped"
    error = "error"


class ManagerURLs(BaseModel):
    api: str = Field(..., title="Api")
    docs: str = Field(..., title="Docs")
    reset: str = Field(..., title="Reset")
    diff: str = Field(..., title="Diff")
    snapshot: str = Field(..., title="Snapshot")
    execute_verifier_function: str = Field(..., title="Execute Verifier Function")
    execute_verifier_function_with_upload: str = Field(
        ..., title="Execute Verifier Function With Upload"
    )


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class InstanceURLs(BaseModel):
    root: str = Field(..., title="Root")
    app: str = Field(..., title="App")
    api: Optional[str] = Field(None, title="Api")
    health: Optional[str] = Field(None, title="Health")
    api_docs: Optional[str] = Field(None, title="Api Docs")
    manager: ManagerURLs


class InstanceResponse(BaseModel):
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    status: str = Field(..., title="Status")
    subdomain: str = Field(..., title="Subdomain")
    created_at: str = Field(..., title="Created At")
    updated_at: str = Field(..., title="Updated At")
    terminated_at: Optional[str] = Field(None, title="Terminated At")
    team_id: str = Field(..., title="Team Id")
    region: str = Field(..., title="Region")
    urls: InstanceURLs
    health: Optional[bool] = Field(None, title="Health")


class InstanceRecord(BaseModel):
    instance_id: str
    env_key: str
    version: str
    status: str
    subdomain: str
    created_at: str
    updated_at: str
    terminated_at: Optional[str] = None
    team_id: str
    region: str
