import { IUserPool, IUserPoolClient } from 'aws-cdk-lib/aws-cognito';
import { IResource, Resource } from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { IPolicyStore } from './policy-store';
export interface CognitoUserPoolConfiguration {
    /**
     * Client identifiers.
     *
     * @default - empty list.
     */
    readonly clientIds?: string[];
    /**
     * Cognito User Pool.
     *
     * @default - no Cognito User Pool
     */
    readonly userPool: IUserPool;
}
export interface IdentitySourceConfiguration {
    /**
     * Cognito User Pool Configuration.
     *
     * @attribute
     */
    readonly cognitoUserPoolConfiguration: CognitoUserPoolConfiguration;
}
export interface IIdentitySource extends IResource {
    /**
     * Identity Source ARN.
     *
     * @attribute
     */
    readonly identitySourceArn: string;
    /**
     * Identity Source identifier.
     *
     * @attribute
     */
    readonly identitySourceId: string;
}
declare abstract class IdentitySourceBase extends Resource implements IIdentitySource {
    abstract readonly identitySourceArn: string;
    abstract readonly identitySourceId: string;
}
export interface IdentitySourceAttributes {
    /**
     * The identity Source ARN.
     *
     * @attribute
     */
    readonly identitySourceArn?: string;
    /**
     * The identity Source identifier
     *
     * @attribute
     */
    readonly identitySourceId?: string;
}
export interface IdentitySourceProps {
    /**
     *  Identity Source configuration.
     */
    readonly configuration: IdentitySourceConfiguration;
    /**
     * Policy Store in which you want to store this identity source
     *
     */
    readonly policyStore: IPolicyStore;
    /**
     * Principal entity type
     *
     * @default - No principal entity type for the identity source.
     */
    readonly principalEntityType?: string;
}
export declare class IdentitySource extends IdentitySourceBase {
    /**
     * Create an Identity Source from its ARN
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param identitySourceArn The Identity Source ARN.
     */
    static fromIdentitySourceArn(scope: Construct, id: string, identitySourceArn: string): IIdentitySource;
    /**
     * Creates Identity Source from its attributes
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs An `IdentitySourceAttributes` object.
     */
    static fromIdentitySourceAttributes(scope: Construct, id: string, attrs: IdentitySourceAttributes): IIdentitySource;
    /**
     * Create an Identity Source from its identifier
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param identitySourceId The Identity Source identifier.
     */
    static fromIdentitySourceId(scope: Construct, id: string, identitySourceId: string): IIdentitySource;
    private readonly identitySource;
    readonly clientIds: string[];
    readonly discoveryUrl: string;
    readonly identitySourceArn: string;
    readonly identitySourceId: string;
    readonly openIdIssuer: string;
    readonly userPoolArn: string;
    readonly policyStore: IPolicyStore;
    constructor(scope: Construct, id: string, props: IdentitySourceProps);
    /**
     * Add a User Pool Client
     *
     * @param userPoolClient The User Pool Client Construct.
     */
    addUserPoolClient(userPoolClient: IUserPoolClient): void;
}
export {};
