"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Statement = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/*
 * Represents a Cedar Statement (Schema or Policy).
 */
class Statement {
    /**
     * Inline statement for policy
     * @returns `InlineStatement` with inline statement.
     * @param statement The actual statement
     */
    static fromInline(statement) {
        if (statement.length === 0) {
            throw new Error('Statement cannot be empty');
        }
        return statement;
    }
    /**
     * Loads the statement from a local disk path.
     * @returns `DirectoryStatement` with statement from file path.
     * @param path A path with the policy statement
     */
    static fromFile(path) {
        if (path.length === 0) {
            throw new Error('Path cannot be empty');
        }
        return (0, fs_1.readFileSync)(path, 'utf-8');
    }
}
exports.Statement = Statement;
_a = JSII_RTTI_SYMBOL_1;
Statement[_a] = { fqn: "@cdklabs/cdk-verified-permissions.Statement", version: "0.0.1-alpha.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhdGVtZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3N0YXRlbWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDJCQUFrQztBQUNsQzs7R0FFRztBQUNILE1BQWEsU0FBUztJQUNwQjs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFpQjtRQUN4QyxJQUFJLFNBQVMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQzFCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkJBQTJCLENBQUMsQ0FBQztTQUM5QztRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFZO1FBQ2pDLElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDckIsTUFBTSxJQUFJLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1NBQ3pDO1FBQ0QsT0FBTyxJQUFBLGlCQUFZLEVBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3JDLENBQUM7O0FBdkJILDhCQXdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHJlYWRGaWxlU3luYyB9IGZyb20gJ2ZzJztcbi8qXG4gKiBSZXByZXNlbnRzIGEgQ2VkYXIgU3RhdGVtZW50IChTY2hlbWEgb3IgUG9saWN5KS5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0YXRlbWVudCB7XG4gIC8qKlxuICAgKiBJbmxpbmUgc3RhdGVtZW50IGZvciBwb2xpY3lcbiAgICogQHJldHVybnMgYElubGluZVN0YXRlbWVudGAgd2l0aCBpbmxpbmUgc3RhdGVtZW50LlxuICAgKiBAcGFyYW0gc3RhdGVtZW50IFRoZSBhY3R1YWwgc3RhdGVtZW50XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21JbmxpbmUoc3RhdGVtZW50OiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIGlmIChzdGF0ZW1lbnQubGVuZ3RoID09PSAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1N0YXRlbWVudCBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICB9XG4gICAgcmV0dXJuIHN0YXRlbWVudDtcbiAgfVxuXG4gIC8qKlxuICAgKiBMb2FkcyB0aGUgc3RhdGVtZW50IGZyb20gYSBsb2NhbCBkaXNrIHBhdGguXG4gICAqIEByZXR1cm5zIGBEaXJlY3RvcnlTdGF0ZW1lbnRgIHdpdGggc3RhdGVtZW50IGZyb20gZmlsZSBwYXRoLlxuICAgKiBAcGFyYW0gcGF0aCBBIHBhdGggd2l0aCB0aGUgcG9saWN5IHN0YXRlbWVudFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRmlsZShwYXRoOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIGlmIChwYXRoLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdQYXRoIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgIH1cbiAgICByZXR1cm4gcmVhZEZpbGVTeW5jKHBhdGgsICd1dGYtOCcpO1xuICB9XG59XG4iXX0=