from setuptools import setup, find_packages

setup(
    name="absorptionlib",
    version="1.0.0",
    packages=find_packages(),  # Automatically finds the `propertiesNaOH` package
    install_requires=[
        'numpy',
        'matplotlib',
        'pyXSteam',  # For the pyXSteam package
    ],
    author="Dorian Höffner",
    author_email="dorian.hoeffner@tu-berlin.de",
    description="A package for substance properties for absorption systems",
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    #url="https://github.com/dorianhoeffner/propertiesNaOH",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
)
