from django import template
from wagtail.models import Site

register = template.Library()


@register.simple_tag(takes_context=True)
def get_site_root(context):
    if not context.get("request"):
        return None
    return Site.find_for_request(context["request"]).root_page
