/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.ant.verify;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.LdcInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.TryCatchBlockNode;
import com.singularity.asm.org.objectweb.asm.tree.TypeInsnNode;
import com.singularity.ee.ant.verify.ExcludedClassName;
import com.singularity.ee.ant.verify.JarFileNameProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class VerifyJarDependencies
extends Task {
    private Map<String, ClassNode> mapOfBootClasses;
    private Set<String> setOfNonBootClasses;
    private int numClassesWithNonBootReferences;
    private Map<String, Integer> allNonBootClassesReferenced;
    private final List<ExcludedClassName> excludedClasses;
    private static Set<String> foreignClassNames;
    private final List<JarFileNameProvider> bootJars = new ArrayList<JarFileNameProvider>();
    private final List<JarFileNameProvider> nonBootJars = new ArrayList<JarFileNameProvider>();
    private boolean warnMode;
    List<File> listOfBootFiles;
    List<File> listOfNonBootFiles;

    public VerifyJarDependencies() {
        this.excludedClasses = new ArrayList<ExcludedClassName>();
    }

    public void execute() throws BuildException {
        this.listOfBootFiles = this.createFileList(this.bootJars);
        this.listOfNonBootFiles = this.createFileList(this.nonBootJars);
        try {
            this.setOfNonBootClasses = this.createSetOfAllClassNames(this.listOfNonBootFiles);
            this.mapOfBootClasses = this.createMapOfBootClasses(this.listOfBootFiles);
            this.scanBootClasses();
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new BuildException((Throwable)e);
        }
    }

    private List<File> createFileList(Collection<JarFileNameProvider> fileNameList) {
        ArrayList<File> returnList = new ArrayList<File>(fileNameList.size());
        for (JarFileNameProvider nextFileNameProvider : fileNameList) {
            File nextFile = new File(nextFileNameProvider.getString());
            if (!nextFile.exists() || nextFile.isDirectory()) continue;
            returnList.add(nextFile);
        }
        return returnList;
    }

    public JarFileNameProvider createBootJar() {
        JarFileNameProvider newBootJar = new JarFileNameProvider();
        this.bootJars.add(newBootJar);
        return newBootJar;
    }

    public JarFileNameProvider createNonBootJar() {
        JarFileNameProvider newNonBootJar = new JarFileNameProvider();
        this.nonBootJars.add(newNonBootJar);
        return newNonBootJar;
    }

    public void setWarnMode(String warnModeString) {
        this.warnMode = Boolean.parseBoolean(warnModeString);
    }

    public ExcludedClassName createExcludedClassName() {
        ExcludedClassName excludedClassName = new ExcludedClassName();
        this.excludedClasses.add(excludedClassName);
        return excludedClassName;
    }

    private Set<String> createSetOfAllClassNames(Collection<File> files) throws IOException {
        HashSet<String> returnSet = new HashSet<String>();
        for (File file : files) {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.endsWith(".class")) continue;
                returnSet.add(entryName.substring(0, entryName.length() - 6));
            }
        }
        return returnSet;
    }

    private Map<String, ClassNode> createMapOfBootClasses(Collection<File> files) throws IOException {
        HashMap<String, ClassNode> returnMap = new HashMap<String, ClassNode>();
        for (File file : files) {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.endsWith(".class")) continue;
                returnMap.put(entryName.substring(0, entryName.length() - 6), this.createClassNode(entry, jarFile));
            }
        }
        return returnMap;
    }

    private ClassNode createClassNode(JarEntry entry, JarFile jarFile) throws IOException {
        InputStream is = jarFile.getInputStream(entry);
        ClassReader reader = new ClassReader(is);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private void scanBootClasses() throws BuildException {
        this.allNonBootClassesReferenced = new TreeMap<String, Integer>();
        for (ClassNode classNode : this.mapOfBootClasses.values()) {
            this.scanBootClass(classNode);
        }
        String message = String.format("Number of classes with non-boot references is %d", this.numClassesWithNonBootReferences);
        System.out.println(message);
        if (this.allNonBootClassesReferenced.size() > 0) {
            System.out.println("All non-boot classes referenced:");
            for (Map.Entry<String, Integer> entry : this.allNonBootClassesReferenced.entrySet()) {
                System.out.println("    " + entry.getKey() + " " + entry.getValue());
            }
            if (!this.warnMode) {
                throw new BuildException(message);
            }
        }
    }

    private void scanBootClass(ClassNode classNode) {
        if (!this.matchesExcludedClass(classNode.name)) {
            foreignClassNames = new TreeSet<String>();
            this.scanClassAncestors(classNode);
            this.scanFields(classNode);
            this.scanMethods(classNode);
            this.printClassReferenceSet(classNode.name, "non-boot singularity", foreignClassNames);
            this.merge(this.allNonBootClassesReferenced, foreignClassNames);
            if (foreignClassNames.size() > 0) {
                ++this.numClassesWithNonBootReferences;
            }
        }
    }

    private boolean matchesExcludedClass(String className) {
        boolean bReturn = false;
        for (ExcludedClassName nextStringProvider : this.excludedClasses) {
            String nextClassRegex = nextStringProvider.getString();
            if (!className.matches(nextClassRegex)) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    private void printClassReferenceSet(String className, String classType, Set<String> classNames) {
        if (classNames.size() > 0) {
            System.out.println(String.format("Class %s references the following %s classes:", className, classType));
            for (String nextClassName : classNames) {
                System.out.println("    " + nextClassName);
            }
            System.out.println("\n");
        }
    }

    private void merge(Map<String, Integer> mergeInto, Set<String> mergeFrom) {
        for (String nextClassName : mergeFrom) {
            Integer integer = mergeInto.get(nextClassName);
            if (integer == null) {
                integer = 0;
            }
            integer = integer + 1;
            mergeInto.put(nextClassName, integer);
        }
    }

    private void scanClassAncestors(ClassNode classNode) {
        List interfaceNameList;
        if (classNode.superName != null && classNode.superName.length() > 0) {
            Type superClassType = Type.getObjectType((String)classNode.superName);
            this.testIfForeignType(superClassType);
        }
        if ((interfaceNameList = classNode.interfaces) != null) {
            for (String nextInterface : interfaceNameList) {
                Type interfaceClassType = Type.getObjectType((String)nextInterface);
                this.testIfForeignType(interfaceClassType);
            }
        }
    }

    private void scanFields(ClassNode classNode) {
        List listOfFields = classNode.fields;
        for (FieldNode fieldNode : listOfFields) {
            Type type = Type.getType((String)fieldNode.desc);
            this.testIfForeignType(type);
        }
    }

    private void scanMethods(ClassNode classNode) {
        List methodList = classNode.methods;
        if (methodList != null) {
            for (MethodNode methodNode : methodList) {
                this.scanMethod(methodNode);
            }
        }
    }

    private void scanMethod(MethodNode methodNode) {
        InsnList instructions;
        List tryCatchBlocks;
        List exceptions = methodNode.exceptions;
        if (exceptions != null) {
            for (Object nextException : exceptions) {
                Type exceptionClassType = Type.getObjectType((String)nextException);
                this.testIfForeignType(exceptionClassType);
            }
        }
        if ((tryCatchBlocks = methodNode.tryCatchBlocks) != null) {
            for (TryCatchBlockNode nextTryCatch : tryCatchBlocks) {
                String catchTypeName = nextTryCatch.type;
                if (catchTypeName == null || catchTypeName.length() <= 0) continue;
                Type catchType = Type.getObjectType((String)catchTypeName);
                this.testIfForeignType(catchType);
            }
        }
        if (methodNode.desc != null && methodNode.desc.length() > 0) {
            Type returnType = Type.getReturnType((String)methodNode.desc);
            this.testIfForeignType(returnType);
            Type[] argTypes = Type.getArgumentTypes((String)methodNode.desc);
            if (argTypes != null) {
                for (Type argType : argTypes) {
                    this.testIfForeignType(argType);
                }
            }
        }
        if ((instructions = methodNode.instructions) != null) {
            this.scanInstructions(instructions);
        }
    }

    private void scanInstructions(InsnList instructions) {
        for (AbstractInsnNode nextInst : instructions) {
            switch (nextInst.getType()) {
                case 4: {
                    this.scanFieldInsn((FieldInsnNode)nextInst);
                    break;
                }
                case 3: {
                    this.scanTypeInsn((TypeInsnNode)nextInst);
                    break;
                }
                case 5: {
                    this.scanMethodInsn((MethodInsnNode)nextInst);
                    break;
                }
                case 9: {
                    this.scanLdcInsn((LdcInsnNode)nextInst);
                    break;
                }
            }
        }
    }

    private void scanFieldInsn(FieldInsnNode fieldInsn) {
        Type fieldType = Type.getObjectType((String)fieldInsn.owner);
        this.testIfForeignType(fieldType);
    }

    private void scanTypeInsn(TypeInsnNode typeInsn) {
        Type type = Type.getObjectType((String)typeInsn.desc);
        this.testIfForeignType(type);
    }

    private void scanMethodInsn(MethodInsnNode methodInsn) {
        Type methodType = Type.getObjectType((String)methodInsn.owner);
        this.testIfForeignType(methodType);
    }

    private void scanLdcInsn(LdcInsnNode ldcInsn) {
        if (ldcInsn.cst instanceof Type) {
            this.testIfForeignType((Type)ldcInsn.cst);
        }
    }

    private void testIfForeignType(Type type) {
        if (type != null && (type.getSort() == 10 || type.getSort() == 9)) {
            if (type.getSort() == 9 && (type = type.getElementType()).getSort() != 10) {
                return;
            }
            String className = type.getInternalName();
            if (className != null && this.setOfNonBootClasses.contains(className = className.replace('.', '/'))) {
                foreignClassNames.add(className);
            }
        }
    }
}

