/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import com.singularity.ee.util.security.credentialstore.EncryptionCommon;
import com.singularity.ee.util.security.credentialstore.KeyStoreManager;
import com.singularity.ee.util.security.credentialstore.exception.CryptoOperationFailureException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

public class KeyStoreBasedEncryptionWrapper {
    private SecretKey secretKey;

    @Deprecated
    public KeyStoreBasedEncryptionWrapper(String keyStoreFilename, char[] keyStorePassword) throws IOException, GeneralSecurityException {
        this(keyStoreFilename, keyStorePassword, "JCEKS");
    }

    @Deprecated
    public KeyStoreBasedEncryptionWrapper(String keyStoreFilename, char[] keyStorePassword, String keyStoreFormat) throws IOException, GeneralSecurityException {
        KeyStoreManager keyStoreManager = new KeyStoreManager(keyStoreFilename, keyStorePassword, keyStoreFormat);
        this.secretKey = keyStoreManager.getSecretKey();
        if (this.secretKey == null) {
            throw new CryptoOperationFailureException("SecretKey not initialized.");
        }
    }

    KeyStoreBasedEncryptionWrapper(String keyStoreFilename, String keyStorePassword) throws IOException, GeneralSecurityException {
        this(keyStoreFilename, keyStorePassword.toCharArray(), "JCEKS");
    }

    KeyStoreBasedEncryptionWrapper(String keyStoreFilename, String keyStorePassword, String keyStoreFormat) throws IOException, GeneralSecurityException {
        this(keyStoreFilename, keyStorePassword.toCharArray(), keyStoreFormat);
    }

    public String encryptPlainTextString(String plainText) throws CryptoOperationFailureException {
        try {
            return EncryptionCommon.encryptPlainTextString(plainText, this.secretKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoOperationFailureException("Failed to encrypt: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public String decryptCipherTextString(String cipherText) throws CryptoOperationFailureException {
        try {
            return EncryptionCommon.decryptCipherTextString(cipherText, this.secretKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoOperationFailureException("Failed to decrypt: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

