/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import com.singularity.ee.util.security.credentialstore.EncryptionCommon;
import com.singularity.ee.util.security.credentialstore.exception.MachineBoundSeedGenerationException;
import com.singularity.ee.util.security.credentialstore.exception.ObfuscationOperationFailureException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public final class ObfuscationWrapper {
    private static final String PREFIX_USE_MACHINE_BOUND_SEED = "m_";
    private static final String PREFIX_USE_SHARABLE_SEED = "s_";
    private static final String METHOD_NAME_GET_HARDWARE_ADDRESS = "getHardwareAddress";
    private static final long SEED_ONE = 25214903917L;
    private static final long SEED_TWO = 2587540296L;
    private static final int SIZEOF_LONG_IN_BYTES = 8;

    private ObfuscationWrapper() {
    }

    private static SecretKey generateSecretKey(boolean useMachineBoundSeed) throws GeneralSecurityException {
        long longSeed = 25214903917L;
        if (useMachineBoundSeed) {
            longSeed ^= ObfuscationWrapper.generateMachineSpecificSeed();
        }
        Random randomNoGenerator = new Random(longSeed ^= ObfuscationWrapper.generateSharableSeed());
        byte[] randomBytes = new byte[32];
        randomNoGenerator.nextBytes(randomBytes);
        DESedeKeySpec desEdeKeySpec = new DESedeKeySpec(randomBytes);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
        return keyFactory.generateSecret(desEdeKeySpec);
    }

    public static String obfuscateString(String plainText, boolean useMachineBoundSeed) throws ObfuscationOperationFailureException {
        SecretKey secretKey = null;
        try {
            secretKey = ObfuscationWrapper.generateSecretKey(useMachineBoundSeed);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ObfuscationOperationFailureException("Failed to generate SecretKey: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        String prefix = useMachineBoundSeed ? PREFIX_USE_MACHINE_BOUND_SEED : PREFIX_USE_SHARABLE_SEED;
        try {
            return prefix + EncryptionCommon.encryptPlainTextString(plainText, secretKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ObfuscationOperationFailureException("Failed to obfuscate: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public static String deobfuscateString(String obfuscatedText) throws ObfuscationOperationFailureException {
        String prefix = null;
        try {
            prefix = obfuscatedText.substring(0, PREFIX_USE_MACHINE_BOUND_SEED.length());
        }
        catch (RuntimeException runtimeException) {
            throw new ObfuscationOperationFailureException("Failed to deobfuscate:  Incorrectly formatted obfuscated text.");
        }
        boolean useMachineBoundSeed = false;
        if (prefix.equals(PREFIX_USE_MACHINE_BOUND_SEED)) {
            useMachineBoundSeed = true;
        } else if (!prefix.equals(PREFIX_USE_SHARABLE_SEED)) {
            throw new ObfuscationOperationFailureException("Failed to deobfuscate:  Incorrectly formatted obfuscated text");
        }
        SecretKey secretKey = null;
        try {
            secretKey = ObfuscationWrapper.generateSecretKey(useMachineBoundSeed);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ObfuscationOperationFailureException("Failed to generate SecretKey: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        try {
            return EncryptionCommon.decryptCipherTextString(obfuscatedText.substring(prefix.length()), secretKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ObfuscationOperationFailureException("Failed to deobfuscate: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private static long convertMACAddressToLong(byte[] macAddressBytes) {
        long longValue = 0L;
        for (byte macAddressByte : macAddressBytes) {
            longValue = (longValue << 8) + (long)(macAddressByte & 0xFF);
        }
        return longValue;
    }

    private static byte[] XORAllMacAddresses() throws MachineBoundSeedGenerationException {
        byte[] resultByteArray = null;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(networkInterfaces)) {
                Class<NetworkInterface> networkInterfaceClass = NetworkInterface.class;
                Method getNetworkInterfacesMethod = null;
                byte[] macAddressByteArray = null;
                try {
                    getNetworkInterfacesMethod = networkInterfaceClass.getDeclaredMethod(METHOD_NAME_GET_HARDWARE_ADDRESS, null);
                    macAddressByteArray = (byte[])getNetworkInterfacesMethod.invoke((Object)netint, (Object[])null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new MachineBoundSeedGenerationException("Machine-bound seed generation supported with Java 6 and higher only");
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new MachineBoundSeedGenerationException("Machine-bound seed generation supported with Java 6 and higher only");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new MachineBoundSeedGenerationException("Machine-bound seed generation supported with Java 6 and higher only");
                }
                if (macAddressByteArray == null) continue;
                if (resultByteArray == null) {
                    resultByteArray = new byte[8];
                }
                int loopTripCount = Math.min(resultByteArray.length, macAddressByteArray.length);
                for (int i = 0; i < loopTripCount; ++i) {
                    int n = i;
                    resultByteArray[n] = (byte)(resultByteArray[n] ^ macAddressByteArray[i]);
                }
            }
        }
        catch (SocketException socketException) {
            resultByteArray = null;
        }
        return resultByteArray;
    }

    private static long generateMachineSpecificSeed() throws MachineBoundSeedGenerationException {
        long longSeed = 0L;
        byte[] macAddressAccumulation = ObfuscationWrapper.XORAllMacAddresses();
        if (macAddressAccumulation != null) {
            longSeed = ObfuscationWrapper.convertMACAddressToLong(macAddressAccumulation);
        }
        return longSeed;
    }

    private static long generateSharableSeed() {
        return 2587540296L;
    }
}

