/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;

public class BoundedConcurrentHashMap<K, V>
extends ADConcurrentHashMap<K, V>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private static final float BOUNDS_BUFFER_PCT = 0.1f;
    private final BoundsEnforcer boundsEnforcer;

    public BoundedConcurrentHashMap(int initialCapacity, int upperLimit) {
        super(initialCapacity);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int upperLimit, BoundsPolicy policy) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withPolicy(policy).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int initialCapacity, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        super(initialCapacity);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int upperLimit, BoundsPolicy policy, ICustomAction action, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withPolicy(policy).withAction(action).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int upperLimit, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int upperLimit, BoundsPolicy policy, String serviceName, String propertyName, IAgentSchedulerManager schedulerManager) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public BoundedConcurrentHashMap(int initialCapacity, int upperLimit, String serviceName, String propertyName) {
        super(initialCapacity);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public void _resize(int newLimit) {
    }

    public V put(K k, V v) {
        Object returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.put(k, v);
        }
        return (V)returnValue;
    }

    public V putIfAbsent(K k, V v) {
        Object returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.putIfAbsent(k, v);
        }
        return (V)returnValue;
    }

    public int getCurrentSize() {
        return this.fastApproximateSize();
    }

    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

