/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.agent.util.bounded.collections.IBoundsOverFlowHandler;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import java.util.EnumSet;

public class BoundedConcurrentReferenceHashMap<K, V>
extends AdaptableConcurrentHashMap<K, V>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private final BoundsEnforcer boundsEnforcer;
    private static final float BOUNDS_BUFFER_PCT = 0.1f;

    BoundedConcurrentReferenceHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, AdaptableConcurrentHashMap.ReferenceType keyType, AdaptableConcurrentHashMap.ReferenceType valueType, AdaptableConcurrentHashMap.StaleEntryListener staleListener, EnumSet<AdaptableConcurrentHashMap.Option> options, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName, IBoundsOverFlowHandler boundsOverFlowHandler) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options, staleListener);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection(this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).withBoundsOverFlowHandler(boundsOverFlowHandler).build();
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    @Override
    public V put(K k, V v) {
        V returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.put(k, v);
        }
        return returnValue;
    }

    @Override
    public V putIfAbsent(K k, V v) {
        V returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.putIfAbsent(k, v);
        }
        return returnValue;
    }

    public void _resize(int newLimit) {
        this.purgeStaleEntries();
    }

    public int getCurrentSize() {
        return this.fastApproximateSize();
    }

    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

