/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentReferenceHashMap;
import com.singularity.ee.agent.util.bounded.collections.BoundsOverFlowHandlerDelegate;
import com.singularity.ee.agent.util.bounded.collections.IBoundsOverFlowHandler;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.bounded.BoundedCollectionLimits;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import java.util.EnumSet;

public class BoundedConcurrentReferenceHashMapBuilder<K, V> {
    private int initialCapacity = 16;
    private float loadFactor = 0.75f;
    private int upperLimit = 500;
    private BoundsPolicy policy;
    private String serviceName;
    private String propertyName;
    private int concurrencyLevel = 16;
    private AdaptableConcurrentHashMap.ReferenceType keyType = AdaptableConcurrentHashMap.ReferenceType.WEAK;
    private AdaptableConcurrentHashMap.ReferenceType valueType = AdaptableConcurrentHashMap.ReferenceType.STRONG;
    private EnumSet<AdaptableConcurrentHashMap.Option> options;
    private AdaptableConcurrentHashMap.StaleEntryListener staleEntryListener;
    private IBoundsOverFlowHandler boundsOverFlowHandler;

    public BoundedConcurrentReferenceHashMapBuilder() {
        this.policy = BoundedCollectionLimits.DEFAULT_BOUNDS_POLICY;
        this.boundsOverFlowHandler = BoundsOverFlowHandlerDelegate.getInstance();
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withUpperLimit(int upperLimit) {
        this.upperLimit = upperLimit;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withPolicy(BoundsPolicy policy) {
        this.policy = policy;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withKeyType(AdaptableConcurrentHashMap.ReferenceType keyType) {
        this.keyType = keyType;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withValueType(AdaptableConcurrentHashMap.ReferenceType valueType) {
        this.valueType = valueType;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withOptions(EnumSet<AdaptableConcurrentHashMap.Option> options) {
        this.options = options;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withStaleEntryListener(AdaptableConcurrentHashMap.StaleEntryListener staleEntryListener) {
        this.staleEntryListener = staleEntryListener;
        return this;
    }

    public BoundedConcurrentReferenceHashMapBuilder<K, V> withBoundsOverFlowHandler(IBoundsOverFlowHandler boundsOverFlowHandler) {
        this.boundsOverFlowHandler = boundsOverFlowHandler;
        return this;
    }

    public BoundedConcurrentReferenceHashMap<K, V> build() {
        return new BoundedConcurrentReferenceHashMap(this.initialCapacity, this.loadFactor, this.concurrencyLevel, this.keyType, this.valueType, this.staleEntryListener, this.options, this.upperLimit, this.policy, this.serviceName, this.propertyName, this.boundsOverFlowHandler);
    }
}

