/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentReferenceHashMap;
import com.singularity.ee.agent.util.bounded.collections.BoundsOverFlowHandlerDelegate;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import java.util.EnumSet;

public class BoundedConcurrentWeakHashMap<K, V>
extends BoundedConcurrentReferenceHashMap<K, V> {
    public BoundedConcurrentWeakHashMap(IAgentSchedulerManager schedulerManager, long period, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName, ILogger logger) {
        super(16, 0.75f, 16, AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK, null, EnumSet.of(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS), upperLimit, policy, serviceName, propertyName, BoundsOverFlowHandlerDelegate.getInstance());
        schedulerManager.getAgentGlobalScheduler().scheduleAtFixedRate((IAgentRunnable)new MapCleaner(this, logger), period, period, AgentTimeUnit.SECONDS);
    }

    private static final class MapCleaner
    implements IAgentRunnable {
        private final AdaptableConcurrentHashMap hashMap;
        private final ILogger logger;

        public MapCleaner(AdaptableConcurrentHashMap hashMap, ILogger logger) {
            this.hashMap = hashMap;
            this.logger = logger;
        }

        public void run() {
            boolean isTracing = this.logger.isTraceEnabled();
            int sizeBefore = 0;
            if (isTracing) {
                sizeBefore = this.hashMap.fastApproximateSize();
            }
            this.hashMap.purgeStaleEntries();
            if (isTracing) {
                this.logger.trace("Purged [" + (sizeBefore - this.hashMap.fastApproximateSize()) + "] stale entries");
            }
        }
    }
}

