/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentReferenceHashMap;
import com.singularity.ee.agent.util.bounded.collections.BoundsOverFlowHandlerDelegate;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import java.util.EnumSet;

public class BoundedConcurrentWeakKeyIdentityHashMap<K, V>
extends BoundedConcurrentReferenceHashMap<K, V> {
    private static final long DEFAULT_PERIOD = 30L;
    private static final BoundsPolicy DEFAULT_BOUNDS_POLICY = BoundsPolicy.WARN_IF_BOUND_EXCEEDED;

    public BoundedConcurrentWeakKeyIdentityHashMap(IAgentSchedulerManager schedulerManager, int upperLimit, String serviceName, String propertyName, AdaptableConcurrentHashMap.StaleEntryListener<V> changeListener, ILogger logger) {
        this(schedulerManager, 30L, upperLimit, DEFAULT_BOUNDS_POLICY, serviceName, propertyName, changeListener, logger);
    }

    public BoundedConcurrentWeakKeyIdentityHashMap(IAgentSchedulerManager schedulerManager, long period, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName, AdaptableConcurrentHashMap.StaleEntryListener<V> changeListener, ILogger logger) {
        super(16, 0.75f, 16, AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.STRONG, changeListener, EnumSet.of(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS), upperLimit, policy, serviceName, propertyName, BoundsOverFlowHandlerDelegate.getInstance());
        schedulerManager.getAgentGlobalScheduler().scheduleAtFixedRate((IAgentRunnable)new WeakReferenceValueReaper(this, logger), period, period, AgentTimeUnit.SECONDS);
    }

    private static final class WeakReferenceValueReaper
    implements IAgentRunnable {
        private final AdaptableConcurrentHashMap hashMap;
        private final ILogger logger;

        private WeakReferenceValueReaper(AdaptableConcurrentHashMap hashMap, ILogger logger) {
            this.hashMap = hashMap;
            this.logger = logger;
        }

        public void run() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Purging [" + this.hashMap.fastApproximateSize() + "] stale entries");
            }
            this.hashMap.purgeStaleEntries();
        }
    }
}

