/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcerPropertyListener;
import com.singularity.ee.agent.util.bounded.collections.BoundsOverFlowHandlerDelegate;
import com.singularity.ee.agent.util.bounded.collections.IBoundsOverFlowHandler;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.collections.bounded.BoundedCollectionLimits;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.string.StringRegexOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.util.HashMap;
import java.util.Map;

public class BoundsEnforcer
extends SharedBoundsEnforcer {
    protected static IADLogger logger = ADLoggerFactory.getLogger((String)"com.singularity.util.boundedcollections.BoundsEnforcer");
    private static volatile Map<String, Integer> NODE_PROPERTIES = null;
    private final IBoundsOverFlowHandler boundsOverFlowHandler;
    protected static final String DEFAULT_POLICY_PROP_NAME = "bounded-collections-policy-override";
    private static final BoundsEnforcerPropertyListener propertyListener = BoundsEnforcerPropertyListener.getInstance();
    private final String serviceName;
    private final String overridePropertyName;
    private final ThreadLocal<Boolean> recursionGuard = new ThreadLocal();

    public static void updateNodeProperties(Map<String, String> updatedNodeProperties) {
        HashMap<String, Integer> localMap = new HashMap<String, Integer>();
        for (String key : updatedNodeProperties.keySet()) {
            String value = updatedNodeProperties.get(key);
            try {
                if (!key.startsWith("Tx-")) continue;
                int intValue = Integer.parseInt(value);
                localMap.put(key, intValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        NODE_PROPERTIES = localMap.size() > 0 ? localMap : null;
    }

    private static int getNodeProperty(String overridePropertyName, int upperLimit) {
        if (NODE_PROPERTIES != null) {
            Integer i;
            Map<String, Integer> map = NODE_PROPERTIES;
            if (map != null && (i = map.get(overridePropertyName)) != null) {
                return i;
            }
            return upperLimit;
        }
        return upperLimit;
    }

    private BoundsEnforcer(IBoundedCollection collection, int upperLimit, BoundsPolicy policy, ICustomAction action, String serviceName, String overridePropertyName, IBoundsOverFlowHandler boundsOverFlowHandler) {
        super(collection, upperLimit, policy, action);
        this.boundsOverFlowHandler = boundsOverFlowHandler;
        this.setLogger((ILogger)logger);
        this.serviceName = serviceName;
        this.overridePropertyName = overridePropertyName;
        if (serviceName != null && overridePropertyName != null) {
            if (overridePropertyName.startsWith("Tx-")) {
                int nodePropertyUpperLimit = BoundsEnforcer.getNodeProperty(overridePropertyName, upperLimit);
                if (nodePropertyUpperLimit != upperLimit) {
                    this.setNewLimit(nodePropertyUpperLimit);
                }
            } else {
                String propValue = SystemUtils.getProperty((String)overridePropertyName);
                if (propValue != null) {
                    this.servicePropertyChanged(propValue);
                }
                propertyListener.registerPropertyListener(serviceName, overridePropertyName, this);
            }
        }
    }

    void servicePropertyChanged(String newPropertyValue) {
        String[] parsedProp = StringRegexOperations.split((String)newPropertyValue, (String)",");
        if (parsedProp.length >= 1) {
            if (parsedProp[0].length() > 0) {
                int newUpperLimit = StringOperations.safeParseInteger((String)parsedProp[0], (int)this.upperLimit);
                this.setNewLimit(newUpperLimit);
            }
            if (parsedProp.length >= 2 && parsedProp[1].length() > 0) {
                BoundsPolicy newPolicy = BoundsEnforcer.parseBoundsPolicyString((String)parsedProp[1]);
                this.setNewPolicy(newPolicy);
            }
        }
    }

    public String getBoundsPropertyName() {
        return this.overridePropertyName;
    }

    public String getBoundsServiceName() {
        return this.serviceName;
    }

    static void setOverrideProperty(String overidePropertyString) {
        if (overidePropertyString == null || overidePropertyString.length() == 0) {
            BoundsEnforcer.setOverridePolicy(null);
        } else {
            BoundsPolicy newPolicy = BoundsEnforcer.parseBoundsPolicyString((String)overidePropertyString);
            if (newPolicy != null) {
                BoundsEnforcer.setOverridePolicy((BoundsPolicy)newPolicy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean warnUpperLimitExceeded(BoundsPolicy policy) {
        Boolean recursiveEntry;
        boolean bReturn = super.warnUpperLimitExceeded(policy);
        if (bReturn && ((recursiveEntry = this.recursionGuard.get()) == null || !recursiveEntry.booleanValue())) {
            this.recursionGuard.set(true);
            try {
                this.boundsOverFlowHandler.onCollectionOverFlow(this);
            }
            finally {
                this.recursionGuard.set(false);
            }
        }
        return bReturn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.serviceName != null && this.overridePropertyName != null) {
            sb.append(" with service name ").append(this.serviceName).append(" and property name ").append(this.overridePropertyName);
        }
        return sb.toString();
    }

    public static class Builder {
        private IBoundedCollection collection;
        private int upperLimit;
        private BoundsPolicy policy = BoundedCollectionLimits.DEFAULT_BOUNDS_POLICY;
        private String serviceName;
        private String overridePropertyName;
        private IBoundsOverFlowHandler boundsOverFlowHandler = BoundsOverFlowHandlerDelegate.getInstance();
        private ICustomAction action;

        public Builder withCollection(IBoundedCollection collection) {
            this.collection = collection;
            return this;
        }

        public Builder withUpperLimit(int upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        public Builder withPolicy(BoundsPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder withOverridePropertyName(String overridePropertyName) {
            this.overridePropertyName = overridePropertyName;
            return this;
        }

        public Builder withBoundsOverFlowHandler(IBoundsOverFlowHandler boundsOverFlowHandler) {
            this.boundsOverFlowHandler = boundsOverFlowHandler;
            return this;
        }

        public Builder withAction(ICustomAction action) {
            this.action = action;
            return this;
        }

        public BoundsEnforcer build() {
            return new BoundsEnforcer(this.collection, this.upperLimit, this.policy, this.action, this.serviceName, this.overridePropertyName, this.boundsOverFlowHandler);
        }
    }

    static class ServiceProperty {
        String serviceName;
        String propName;
        private final int hashValue;

        ServiceProperty(String serviceName, String propName) {
            this.serviceName = serviceName;
            this.propName = propName;
            this.hashValue = serviceName.hashCode() ^ propName.hashCode();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof ServiceProperty) {
                ServiceProperty other = (ServiceProperty)o;
                bReturn = this.hashValue == other.hashValue && this.serviceName.equals(other.serviceName) && this.propName.equals(other.propName);
            }
            return bReturn;
        }
    }
}

