/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.cache;

import com.singularity.ee.agent.util.cache.ILRUCacheDeletionAdvisor;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class LRUCacheBase<K, V> {
    protected static IADLogger logger = ADLoggerFactory.getLogger((String)"com.singularity.LRUCacheBase");
    static final long DEFAULT_MONITOR_FREQUENCY = 300L;
    static long currentMonitorFrequency = 300L;
    protected final ConcurrentMap<Key, ValueWrapper> wrappedMap = this.createWrappedMap();
    private Lock manageLock = new ReentrantLock();
    private int maxSize;
    private int freePctIfMaxReached;
    private String nameOfCache;
    private volatile int numInserts;
    private volatile int numRemoves;
    private volatile int numGets;
    private volatile int numCacheHits;
    private volatile int numManagedRemoves;
    protected boolean periodicMaintenanceScheduled;
    private long maxInactiveTime;
    private ILRUCacheDeletionAdvisor<K, V> deletionAdvisor;
    static List<WeakReference<? extends LRUCacheBase>> listOfCaches;
    private static Monitor monitor;
    private final IAgentAtomicLong valueTouchIndex;

    protected LRUCacheBase(int maxSize, int freePctIfMaxReached, String nameOfCache, long maxInactiveTime, IAgentScheduledExecutorService scheduler) {
        this(maxSize, freePctIfMaxReached, nameOfCache, maxInactiveTime, null, scheduler, null);
    }

    protected LRUCacheBase(int maxSize, int freePctIfMaxReached, String nameOfCache, long maxInactiveTime, IAgentScheduledThreadPoolExecutor agentGlobalScheduler) {
        this(maxSize, freePctIfMaxReached, nameOfCache, maxInactiveTime, null, agentGlobalScheduler);
    }

    protected LRUCacheBase(int maxSize, int freePctIfMaxReached, String nameOfCache, long maxInactiveTime, ILRUCacheDeletionAdvisor<K, V> deletionAdvisor, IAgentScheduledThreadPoolExecutor agentGlobalScheduler) {
        this(maxSize, freePctIfMaxReached, nameOfCache, maxInactiveTime, deletionAdvisor, (IAgentScheduledExecutorService)agentGlobalScheduler, null);
    }

    protected LRUCacheBase(int maxSize, int freePctIfMaxReached, String nameOfCache, long maxInactiveTime, ILRUCacheDeletionAdvisor<K, V> deletionAdvisor, IAgentScheduledExecutorService agentGlobalScheduler, MonitorCallback callback) {
        this.maxSize = maxSize;
        this.freePctIfMaxReached = freePctIfMaxReached;
        this.nameOfCache = nameOfCache;
        this.maxInactiveTime = maxInactiveTime;
        this.deletionAdvisor = deletionAdvisor;
        this.valueTouchIndex = new AgentAtomicLongImpl();
        if (maxInactiveTime > 0L) {
            LRUCacheBase.registerCacheToBeMonitored(this, agentGlobalScheduler, callback);
            this.periodicMaintenanceScheduled = true;
        }
    }

    long getNextTouchIndex() {
        return this.valueTouchIndex.incrementAndGet();
    }

    protected ValueWrapper getValueWrapper(K actualKey, V actualValue) {
        return new ValueWrapper(actualValue, this.getKey(actualKey));
    }

    protected abstract Key getKey(K var1);

    protected ConcurrentHashMap<Key, ValueWrapper> createWrappedMap() {
        return new ConcurrentHashMap<Key, ValueWrapper>();
    }

    public void insert(K actualKey, V value) {
        ValueWrapper valueWrapper = this.getValueWrapper(actualKey, value);
        this.wrappedMap.put(valueWrapper.getKey(), valueWrapper);
        ++this.numInserts;
        this.manage();
    }

    public V putIfAbsent(K actualKey, V value) {
        V returnObject = null;
        ValueWrapper valueWrapper = this.getValueWrapper(actualKey, value);
        ValueWrapper existingValue = this.wrappedMap.putIfAbsent(valueWrapper.getKey(), valueWrapper);
        if (existingValue != null) {
            returnObject = existingValue.getActualValue();
        } else {
            ++this.numInserts;
            this.manage();
        }
        return returnObject;
    }

    public void remove(K key) {
        this.wrappedMap.remove(this.getKey(key));
        ++this.numRemoves;
    }

    public V get(K actualKey) {
        Key key = this.getKey(actualKey);
        ValueWrapper valueWrapper = (ValueWrapper)this.wrappedMap.get(key);
        ++this.numGets;
        if (valueWrapper != null) {
            valueWrapper.timeLastTouched = System.currentTimeMillis();
            valueWrapper.touchIndex = this.getNextTouchIndex();
            ++this.numCacheHits;
            return valueWrapper.getActualValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manage() {
        block9: {
            if (this.maxSize > 0 && this.wrappedMap.size() > this.maxSize && this.manageLock.tryLock()) {
                try {
                    if (this.maxSize <= 0 || this.wrappedMap.size() <= this.maxSize) break block9;
                    Set<ValueWrapper> setOfValues = this.getSortedSet();
                    int target = (100 - this.freePctIfMaxReached) * this.maxSize / 100;
                    int currentMapSize = this.wrappedMap.size();
                    Iterator<ValueWrapper> iter = setOfValues.iterator();
                    boolean atLeastOneEntryProtected = false;
                    while (iter.hasNext()) {
                        ValueWrapper nextValue = iter.next();
                        boolean shouldDelete = true;
                        if (this.deletionAdvisor != null) {
                            shouldDelete = this.deletionAdvisor.shouldDelete(nextValue.getKey().getActualKey(), nextValue.getActualValue());
                        }
                        if (shouldDelete) {
                            iter.remove();
                            if (this.wrappedMap.remove(nextValue.getKey()) == null) continue;
                            ++this.numManagedRemoves;
                            if (--currentMapSize > target) continue;
                            break;
                        }
                        atLeastOneEntryProtected = true;
                    }
                    if (currentMapSize <= target || !atLeastOneEntryProtected) break block9;
                    for (ValueWrapper nextValue : setOfValues) {
                        if (this.wrappedMap.remove(nextValue.getKey()) == null) continue;
                        ++this.numManagedRemoves;
                        if (--currentMapSize > target) continue;
                        break;
                    }
                }
                finally {
                    this.manageLock.unlock();
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.debug(this.toString());
        }
    }

    private Set<ValueWrapper> getSortedSet() {
        return new TreeSet<ValueWrapper>(this.wrappedMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOld() {
        this.performAdditionalMaintenance();
        if (this.maxInactiveTime != 0L && this.wrappedMap.size() > 0 && this.manageLock.tryLock()) {
            try {
                Set<ValueWrapper> setOfValues = this.getSortedSet();
                long currentTime = System.currentTimeMillis();
                for (ValueWrapper nextValue : setOfValues) {
                    if (currentTime - nextValue.timeLastTouched > this.maxInactiveTime) {
                        Key key = nextValue.getKey();
                        if (this.deletionAdvisor != null && !this.deletionAdvisor.shouldDelete(key.getActualKey(), nextValue.getActualValue()) || this.wrappedMap.remove(key) == null) continue;
                        ++this.numManagedRemoves;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.manageLock.unlock();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.debug(this.toString());
        }
    }

    protected void performAdditionalMaintenance() {
    }

    public int size() {
        return this.wrappedMap.size();
    }

    private static synchronized void registerCacheToBeMonitored(LRUCacheBase cache, IAgentScheduledExecutorService agentGlobalScheduler, MonitorCallback callback) {
        if (listOfCaches == null) {
            listOfCaches = new ArrayList<WeakReference<? extends LRUCacheBase>>();
            monitor = new Monitor(agentGlobalScheduler, callback);
            monitor.schedule();
        }
        listOfCaches.add(new WeakReference<LRUCacheBase>(cache));
    }

    static synchronized void maintainCaches() {
        if (listOfCaches != null) {
            Iterator<WeakReference<? extends LRUCacheBase>> iter = listOfCaches.iterator();
            while (iter.hasNext()) {
                LRUCacheBase nextCache = (LRUCacheBase)iter.next().get();
                if (nextCache == null) {
                    iter.remove();
                    continue;
                }
                nextCache.removeOld();
            }
        }
    }

    public static synchronized int getNumberOfManagedCaches() {
        int count = 0;
        if (listOfCaches != null) {
            Iterator<WeakReference<? extends LRUCacheBase>> iter = listOfCaches.iterator();
            while (iter.hasNext()) {
                LRUCacheBase nextCache = (LRUCacheBase)iter.next().get();
                if (nextCache == null) {
                    iter.remove();
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    public static long getMonitorFrequency() {
        return currentMonitorFrequency;
    }

    public static void setDefaultMonitorFrequency(long newMonitorFrequency) {
        if (currentMonitorFrequency != newMonitorFrequency) {
            currentMonitorFrequency = newMonitorFrequency;
            if (monitor != null) {
                monitor.reschedule();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.nameOfCache != null) {
            sb.append("  Name of cache = ").append(this.nameOfCache);
        }
        sb.append("  current size = ").append(Integer.toString(this.wrappedMap.size()));
        sb.append("  number of inserts = ").append(Integer.toString(this.numInserts));
        sb.append("  number of explicit removes = ").append(Integer.toString(this.numRemoves));
        sb.append("  number of gets = ").append(Integer.toString(this.numGets));
        sb.append("  number of cache hits = ").append(Integer.toString(this.numCacheHits));
        sb.append("  number of old elements removed = ").append(Integer.toString(this.numManagedRemoves));
        int cacheHitRatio = this.numGets != 0 ? 100 * this.numCacheHits / this.numGets : 0;
        sb.append("  cache hit percent = ").append(Integer.toString(cacheHitRatio)).append("%");
        return sb.toString();
    }

    public static interface MonitorCallback {
        public void call();
    }

    private static class Monitor
    implements IAgentRunnable {
        private final IAgentScheduledExecutorService agentGlobalScheduler;
        private final MonitorCallback callback;
        private IAgentScheduledFuture future;

        Monitor(IAgentScheduledExecutorService agentGlobalScheduler, MonitorCallback callback) {
            this.agentGlobalScheduler = agentGlobalScheduler;
            this.callback = callback;
        }

        public void run() {
            LRUCacheBase.maintainCaches();
            if (this.callback != null) {
                this.callback.call();
            }
        }

        void reschedule() {
            if (this.future != null) {
                this.future.cancel(false);
                this.schedule();
            }
        }

        void schedule() {
            this.future = this.agentGlobalScheduler.scheduleAtFixedRate((IAgentRunnable)this, currentMonitorFrequency, currentMonitorFrequency, AgentTimeUnit.SECONDS);
        }
    }

    class ValueWrapper
    implements Comparable<ValueWrapper> {
        protected V wrappedValue;
        protected Key key;
        long timeLastTouched;
        long touchIndex;

        protected ValueWrapper(V value, Key key) {
            this.wrappedValue = value;
            this.key = key;
            this.timeLastTouched = System.currentTimeMillis();
            this.touchIndex = LRUCacheBase.this.getNextTouchIndex();
        }

        Key getKey() {
            return this.key;
        }

        V getActualValue() {
            return this.wrappedValue;
        }

        @Override
        public int compareTo(ValueWrapper other) {
            int i = this.touchIndex < other.touchIndex ? -1 : 1;
            return i;
        }
    }

    abstract class Key {
        protected Key() {
        }

        abstract K getActualKey();

        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }
}

