/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtil {
    private static final int MIN_BUFFER_SIZE_TO_USE = 1024;

    private static byte[] streamToBytes(InputStream is) throws IOException {
        int bytesRead;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int remaining = bis.available();
        byte[] buffer = new byte[Math.max(remaining, 1024)];
        while ((bytesRead = bis.read(buffer)) > 0) {
            baos.write(buffer, 0, bytesRead);
        }
        bis.close();
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] getClassBytes(ClassLoader classLoader, String className) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = classLoader.getResourceAsStream(resourceName);
        return StreamUtil.streamToBytes(is);
    }

    public static byte[] getClassBytes(Class clazz) throws IOException {
        return StreamUtil.getClassBytes(clazz.getClassLoader(), clazz.getName());
    }
}

