/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.LogLevel;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AsyncLogger
implements ILogger,
IAgentRunnable {
    final IADLogger wrappedLogger;
    private final BlockingQueue<QueuedMessage> queuedMessages;
    private final IAgentScheduledExecutorService threadPoolExecutor;
    private volatile IAgentScheduledFuture future;

    public AsyncLogger(IADLogger wrappedLogger, IAgentScheduledExecutorService threadPoolExecutor) {
        this.wrappedLogger = wrappedLogger;
        this.threadPoolExecutor = threadPoolExecutor;
        this.queuedMessages = new LinkedBlockingQueue<QueuedMessage>();
    }

    public void debug(String msg) {
        this.queueMessage(msg, LogLevel.DEBUG);
    }

    public void debug(String msg, Throwable t) {
        this.queueMessage(msg, LogLevel.DEBUG, t);
    }

    public void error(String msg) {
        this.queueMessage(msg, LogLevel.ERROR);
    }

    public void error(String msg, Throwable t) {
        this.queueMessage(msg, LogLevel.ERROR, t);
    }

    public void fatal(String msg) {
        this.queueMessage(msg, LogLevel.FATAL);
    }

    public void fatal(String msg, Throwable t) {
        this.queueMessage(msg, LogLevel.FATAL, t);
    }

    public void info(String msg) {
        this.queueMessage(msg, LogLevel.INFO);
    }

    public void info(String msg, Throwable t) {
        this.queueMessage(msg, LogLevel.INFO, t);
    }

    public void trace(String msg) {
        this.queueMessage(msg, LogLevel.TRACE);
    }

    public void trace(String msg, Throwable t) {
        this.queueMessage(msg, LogLevel.TRACE, t);
    }

    public void warn(String msg) {
        this.queueMessage(msg, LogLevel.WARN);
    }

    public void warn(String msg, Throwable t) {
        this.queueMessage(msg, LogLevel.WARN, t);
    }

    public boolean isDebugEnabled() {
        return this.wrappedLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.wrappedLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.wrappedLogger.isTraceEnabled();
    }

    private void queueMessage(String message, LogLevel logLevel) {
        this.queueMessage(message, logLevel, null);
    }

    private void queueMessage(String message, LogLevel logLevel, Throwable throwable) {
        this.queuedMessages.offer(new QueuedMessage(message, logLevel, throwable));
        this.schedule();
    }

    private synchronized void schedule() {
        if (this.future == null && this.queuedMessages.size() > 0) {
            this.future = this.threadPoolExecutor.schedule((IAgentRunnable)this, 0L, AgentTimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList listOfMessages = new ArrayList(this.queuedMessages.size());
        while (true) {
            this.queuedMessages.drainTo(listOfMessages);
            if (listOfMessages.size() == 0) break;
            for (QueuedMessage nextMessage : listOfMessages) {
                nextMessage.writeMessage();
            }
            listOfMessages.clear();
        }
        AsyncLogger asyncLogger = this;
        synchronized (asyncLogger) {
            this.future = null;
            this.schedule();
        }
    }

    private class QueuedMessage {
        private final String message;
        private final LogLevel logLevel;
        private final Throwable throwable;

        QueuedMessage(String message, LogLevel logLevel, Throwable throwable) {
            this.message = message;
            this.logLevel = logLevel;
            this.throwable = throwable;
        }

        void writeMessage() {
            if (AsyncLogger.this.wrappedLogger != null) {
                switch (this.logLevel) {
                    case TRACE: {
                        if (this.throwable != null) {
                            AsyncLogger.this.wrappedLogger.trace(this.message, this.throwable);
                            break;
                        }
                        AsyncLogger.this.wrappedLogger.trace(this.message);
                        break;
                    }
                    case DEBUG: {
                        if (this.throwable != null) {
                            AsyncLogger.this.wrappedLogger.debug(this.message, this.throwable);
                            break;
                        }
                        AsyncLogger.this.wrappedLogger.debug(this.message);
                        break;
                    }
                    case INFO: {
                        if (this.throwable != null) {
                            AsyncLogger.this.wrappedLogger.info(this.message, this.throwable);
                            break;
                        }
                        AsyncLogger.this.wrappedLogger.info(this.message);
                        break;
                    }
                    case WARN: {
                        if (this.throwable != null) {
                            AsyncLogger.this.wrappedLogger.warn(this.message, this.throwable);
                            break;
                        }
                        AsyncLogger.this.wrappedLogger.warn(this.message);
                        break;
                    }
                    case ERROR: {
                        if (this.throwable != null) {
                            AsyncLogger.this.wrappedLogger.error(this.message, this.throwable);
                            break;
                        }
                        AsyncLogger.this.wrappedLogger.error(this.message);
                        break;
                    }
                    case FATAL: {
                        if (this.throwable != null) {
                            AsyncLogger.this.wrappedLogger.fatal(this.message, this.throwable);
                            break;
                        }
                        AsyncLogger.this.wrappedLogger.fatal(this.message);
                    }
                }
            }
        }
    }
}

