/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.tasks;

import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class BatchTask
implements IAgentRunnable {
    private static final int DEFAULT_BATCH_PROCESSING_TIME_MS = 100;
    public static final int DEFAULT_HEARTBEAT_MS = 10000;
    protected int heartbeatMs = 10000;
    protected String taskName;
    private boolean scheduled;
    private long batchProcessingTimeMs = 100L;
    private final IAgentScheduledThreadPoolExecutor scheduler;

    public abstract IADLogger getLogger();

    public BatchTask(IAgentScheduledThreadPoolExecutor scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized void ping() {
        boolean isDebug = this.getLogger().isDebugEnabled();
        if (isDebug) {
            this.getLogger().debug("Pinging batch task: " + this.getClass().getSimpleName());
        }
        if (!this.scheduled) {
            if (isDebug) {
                this.getLogger().debug("Running batch task: " + this.getClass().getSimpleName());
            }
            this.run();
        } else if (isDebug) {
            this.getLogger().debug("Batch task already scheduled: " + this.getClass().getSimpleName());
        }
    }

    protected abstract void prepareOnce();

    public abstract void runOnce();

    public abstract boolean isDoneProcessing();

    public synchronized void run() {
        this.prepareOnce();
        boolean isDebug = this.getLogger().isDebugEnabled();
        if (isDebug) {
            this.getLogger().debug("In batch task run: " + this.getClass().getSimpleName());
        }
        long intervalStopTimeNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.batchProcessingTimeMs);
        while (this.isValidWorkInterval(intervalStopTimeNs) && !this.isDoneProcessing()) {
            this.runOnce();
        }
        if (isDebug) {
            this.getLogger().debug("Exited batch task run loop, isDoneProcessing -> " + this.isDoneProcessing());
        }
        this.scheduled = false;
        if (!this.isDoneProcessing()) {
            if (isDebug) {
                this.getLogger().debug("Scheduling batch task to run again: " + this.getClass().getSimpleName());
            }
            this.scheduler.schedule((IAgentRunnable)this, (long)this.heartbeatMs, AgentTimeUnit.MILLISECONDS);
            this.scheduled = true;
        }
    }

    private boolean isValidWorkInterval(long intervalStopTimeNs) {
        long nanoTime = System.nanoTime();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Current nano time: " + nanoTime + ", intervalStopTimeNs: " + intervalStopTimeNs);
        }
        return intervalStopTimeNs > nanoTime;
    }
}

