/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.thread;

import com.singularity.ee.util.exceptionop.ExceptionOperations;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.thread.DeadlockSummary;
import com.singularity.ee.util.thread.IRequestThread;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThreadUtil {
    public static final String NEW_LINE = "\n";
    public static final String SINGULARITY_PKG = "singularity";
    public static final String THREAD_CLASS = "java.lang.Thread";
    public static final String GET_STACKTRACE_METHOD = "getStackTrace";
    private static final Class[] emptyClsArr = new Class[0];
    private static final Object[] emptyObjArr = new Object[0];
    public static final String THREAD_GET_STACK_TRACE_RETURNED_NULL = "thread.getStackTrace() returned null!";

    public static String getStackSummary(Thread thread) {
        StackTraceElement[] arr = thread.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("Thread Name:").append(thread.getName()).append(NEW_LINE);
        sb.append("ID:").append(thread.getId()).append(NEW_LINE);
        sb.append("Time:").append(new Date(System.currentTimeMillis())).append(NEW_LINE);
        sb.append("State:").append((Object)thread.getState()).append(NEW_LINE);
        sb.append("Priority:").append(thread.getPriority()).append(NEW_LINE).append(NEW_LINE);
        sb.append(ThreadUtil.getStackSummary(arr));
        sb.append(NEW_LINE);
        return sb.toString();
    }

    public static String getUnfilteredADStackSummary(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return THREAD_GET_STACK_TRACE_RETURNED_NULL;
        }
        return ThreadUtil.getStackSummary(stackTrace, false);
    }

    public static String getStackSummary(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return THREAD_GET_STACK_TRACE_RETURNED_NULL;
        }
        return ThreadUtil.getStackSummary(stackTrace, true);
    }

    private static String getStackSummary(StackTraceElement[] stackTrace, boolean filterSingularityPkg) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement anArr : stackTrace) {
            if (anArr.getClassName().equals(THREAD_CLASS) && anArr.getMethodName().equals(GET_STACKTRACE_METHOD) || filterSingularityPkg && anArr.getClassName().contains(SINGULARITY_PKG)) continue;
            sb.append(anArr).append(NEW_LINE);
        }
        return sb.toString();
    }

    public static DeadlockSummary getDeadlockSummaryForThread(long threadID, Thread thread, ThreadMXBean threadMBean) {
        ThreadInfo threadInfo = threadMBean.getThreadInfo(threadID);
        StringBuilder sb = new StringBuilder();
        sb.append("Name[").append(threadInfo.getThreadName()).append("]").append("Thread ID[").append(threadID).append("]\n");
        sb.append("Deadlocked on Lock[").append(threadInfo.getLockName()).append("] held by thread [").append(threadInfo.getLockOwnerName()).append("] Thread ID[").append(threadInfo.getLockOwnerId()).append("]\n");
        sb.append("Thread stack [\n\n").append(ThreadUtil.getUnfilteredADStackSummary(thread.getStackTrace())).append("]\n");
        return new DeadlockSummary(threadInfo.getThreadName(), sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Thread> findAllByID(Set<Long> ids) {
        HashMap<Long, Thread> foundThreads = new HashMap<Long, Thread>();
        try {
            Method getThreadsMethod = Thread.class.getDeclaredMethod("getThreads", emptyClsArr);
            getThreadsMethod.setAccessible(true);
            Object threads = getThreadsMethod.invoke(null, emptyObjArr);
            if (threads != null) {
                int len = Array.getLength(threads);
                for (int i = 0; i < len; ++i) {
                    Thread thread = (Thread)Array.get(threads, i);
                    if (!ids.contains(thread.getId())) continue;
                    foundThreads.put(thread.getId(), thread);
                }
            }
        }
        catch (Exception exception) {
            if (foundThreads.isEmpty()) {
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (!ids.contains(thread.getId())) continue;
                    foundThreads.put(thread.getId(), thread);
                }
            }
        }
        finally {
            if (foundThreads.isEmpty()) {
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (!ids.contains(thread.getId())) continue;
                    foundThreads.put(thread.getId(), thread);
                }
            }
        }
        return foundThreads;
    }

    public static String processStackDump(int maxStackDepth) {
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        boolean notFirst = false;
        for (StackTraceElement traceElement : traceElements) {
            String traceElementString = traceElement.toString();
            if (traceElementString.contains(SINGULARITY_PKG)) continue;
            if (i > 0) {
                if (notFirst) {
                    sb.append('\t').append("at ");
                } else {
                    notFirst = true;
                }
                sb.append(traceElementString).append(NEW_LINE);
            }
            if (++i > maxStackDepth) break;
        }
        return sb.toString();
    }

    public static StackTraceElement[] getStackTrace(IRequestThread context) {
        return ThreadUtil.getStackTrace(context, false, null, null, null, null);
    }

    public static StackTraceElement[] getStackTrace(IRequestThread context, boolean requiresAsyncRootNodeInCallGraph, String classNameAnchorForCustomRootNodeInCallGraph, String methodNameAnchorForCustomRootNodeInCallGraph, String entryClass, String entryMethod) {
        if (requiresAsyncRootNodeInCallGraph) {
            String clsNameToInsertAfter = classNameAnchorForCustomRootNodeInCallGraph;
            String methodNameToInsertAfter = methodNameAnchorForCustomRootNodeInCallGraph;
            StackTraceElement[] stack = context.getOwnerThread().getStackTrace();
            int matchIndex = -1;
            for (int i = 0; i < stack.length; ++i) {
                if (!stack[i].getClassName().equals(clsNameToInsertAfter) || !stack[i].getMethodName().equals(methodNameToInsertAfter)) continue;
                matchIndex = i;
                break;
            }
            if (matchIndex != -1) {
                StackTraceElement[] newStack = new StackTraceElement[matchIndex + 1 + 1];
                for (int i = 0; i <= matchIndex; ++i) {
                    newStack[i] = stack[i];
                }
                newStack[matchIndex + 1] = new StackTraceElement(entryClass, entryMethod, "", -1);
                return newStack;
            }
        }
        return context.getOwnerThread().getStackTrace();
    }

    public static StackTraceElement[] getStackTrace(Thread t) {
        return t.getStackTrace();
    }

    public static StackTraceElement[] getStackTrace(Throwable t) {
        return ExceptionOperations.getStackTrace((Throwable)t);
    }

    public static StackTraceElement[] getStackTraceOptimized(Throwable t, int stackDepth) {
        return ExceptionOperations.getStackTraceOptimized((Throwable)t, (int)stackDepth, null);
    }

    public static StackTraceElement[] getStackTraceOptimized(Throwable t, int stackDepth, ILogger logger) {
        return ExceptionOperations.getStackTraceOptimized((Throwable)t, (int)stackDepth, (ILogger)logger);
    }

    public static String getName(Thread t) {
        return t.getName();
    }

    public static long getThreadId(Thread thread) {
        return thread.getId();
    }

    public static Thread getCurrentThread() {
        return Thread.currentThread();
    }

    public static long getCurrentThreadId() {
        return Thread.currentThread().getId();
    }

    public static void interruptCurrentThread() {
        Thread.currentThread().interrupt();
    }

    public static String getStackSummaryForWalker(StackTraceElement[] currentDump) {
        return ThreadUtil.getStackSummary(currentDump);
    }

    public static void printStackTrace(Throwable t) {
        t.printStackTrace(System.err);
    }
}

