/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.collections.ExpandableArray;
import java.lang.reflect.Array;

public class SlowWriteExpandableArray<T>
implements ExpandableArray<T> {
    private static final int INITIAL_SIZE = 128;
    private static final int INCREMENT_SIZE = 64;
    private volatile T[] array;

    @Override
    public T get(int index) {
        return this.array[index];
    }

    @Override
    public synchronized void put(int index, T value) {
        if (this.array == null) {
            this.createArray(value);
        }
        if (index >= this.array.length) {
            this.expandArray(value, index);
        }
        this.array[index] = value;
    }

    private void createArray(T value) {
        Object[] toSet = (Object[])Array.newInstance(value.getClass(), 128);
        this.array = toSet;
    }

    private void expandArray(T value, int index) {
        int increment = this.array.length - index + 64;
        Object[] toSet = (Object[])Array.newInstance(value.getClass(), this.array.length + increment);
        System.arraycopy(this.array, 0, toSet, 0, this.array.length);
        this.array = toSet;
    }

    @Override
    public int size() {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }
}

