/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.dtobootimpl;

import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.dtobootimpl.ExtendedStringMatchBootTypes;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.spi.IStringTokenizer;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class StringMatchBoot {
    public static final StringMatchBoot ALWAYS_MATCH = new StringMatchBoot(true);
    private StringMatchBootType matchType;
    private String matchPattern;
    private boolean inverse;
    private String[] inList;
    public static final String INLIST_DELIMITER = ",";
    private transient boolean alwaysMatch;
    private transient Pattern regexPattern;
    private transient Set<String> inListSet = null;
    private String extendedMatchType;
    private String extendedMatchPattern;
    int[] regexGroups;
    private int[] intMatchPattern;

    public StringMatchBoot() {
    }

    public StringMatchBoot(boolean alwaysMatch) {
        this.alwaysMatch = alwaysMatch;
    }

    public StringMatchBoot(StringMatchBootType matchType, String matchPattern) {
        this(EnumHelper.getName((Enum)matchType, (Enum)matchType), matchPattern);
        this.setMatchType(matchType);
        this.setMatchPattern(matchPattern);
    }

    public StringMatchBoot(String matchType, String matchPattern) {
        this.setExtendedMatchType(matchType);
        this.setExtendedMatchPattern(matchPattern);
    }

    public StringMatchBoot(StringMatchBootType matchType, String matchString, boolean inverse) {
        this(matchType, matchString);
        this.inverse = inverse;
    }

    public StringMatchBoot deepCopy() {
        StringMatchBoot copy = new StringMatchBoot();
        copy.setMatchType(this.getMatchType());
        copy.setMatchPattern(this.getMatchPattern());
        copy.setInverse(this.isInverse());
        copy.setExtendedMatchType(this.getExtendedMatchType());
        copy.setExtendedMatchPattern(this.getExtendedMatchPattern());
        copy.setRegexGroups(this.getRegexGroups());
        String[] inList = this.getInList();
        if (inList != null) {
            ArrayList<String> copyInList = new ArrayList<String>();
            for (String inStr : inList) {
                copyInList.add(inStr);
            }
            copy.setInList((String[])CollectionHelper.collectionToArray(copyInList, (Object[])new String[copyInList.size()]));
        }
        return copy;
    }

    public StringMatchBootType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(StringMatchBootType matchType) {
        this.matchType = matchType;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public void setMatchPattern(String matchPattern) {
        if (this.matchType == StringMatchBootType.REGEX) {
            this.regexPattern = Pattern.compile(matchPattern);
        }
        if (this.matchType == StringMatchBootType.INLIST) {
            IStringTokenizer tokenizer = StringOperations.createStringTokenizer((String)matchPattern, (String)INLIST_DELIMITER);
            this.inList = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.inList[i++] = tokenizer.nextToken().trim();
            }
        }
        this.matchPattern = matchPattern;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public boolean equals(Object o) {
        if (o == null && !this.matchType.equals((Object)StringMatchBootType.NOT_EMPTY)) {
            return true;
        }
        if (!(o instanceof StringMatchBoot)) {
            return false;
        }
        StringMatchBoot other = (StringMatchBoot)o;
        if (this.extendedMatchPattern != null ? other.extendedMatchPattern == null || !this.extendedMatchPattern.equals(other.extendedMatchPattern) : other.extendedMatchPattern != null) {
            return false;
        }
        if (this.extendedMatchType != null ? other.extendedMatchType == null || !this.extendedMatchType.equals(other.extendedMatchType) : other.extendedMatchType != null) {
            return false;
        }
        return this.inverse == other.isInverse();
    }

    public static boolean safeEquals(StringMatchBoot match1, StringMatchBoot match2) {
        if (match1 == null) {
            return match2 == null;
        }
        return match2 == null ? false : match1.equals(match2);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.extendedMatchType == null ? -1 : this.extendedMatchType.hashCode());
        result = 37 * result + Boolean.valueOf(this.inverse).hashCode();
        result = 37 * result + (this.extendedMatchPattern == null ? -1 : this.extendedMatchPattern.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SM");
        if (this.extendedMatchType != null) {
            sb.append("{ex_type=").append(this.extendedMatchType);
            sb.append(", ex_pattern='").append(this.extendedMatchPattern).append('\'');
        }
        if (this.matchType != null) {
            sb.append(", type=").append((Object)this.matchType);
            sb.append(", pattern='").append(this.matchPattern).append('\'');
        }
        if (this.inverse) {
            sb.append(", inverse=").append(this.inverse);
        }
        if (this.inList != null) {
            sb.append(", inList=").append(CollectionHelper.asList((Object[])this.inList).toString());
        }
        if (this.alwaysMatch) {
            sb.append(", alwaysMatch=").append(this.alwaysMatch);
        }
        if (this.regexPattern != null) {
            sb.append(", regexPattern=").append(this.regexPattern);
        }
        if (this.regexGroups != null) {
            sb.append(", regexGroups=").append(CollectionHelper.intArrayToString((int[])this.regexGroups));
        }
        if (this.intMatchPattern != null) {
            sb.append(", intMatchPattern=").append(CollectionHelper.intArrayToString((int[])this.parseIntMatchPattern()));
        }
        sb.append('}');
        return sb.toString();
    }

    public String[] getInList() {
        return this.inList;
    }

    public void setInList(String[] inList) {
        this.inList = inList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchString(String inputString) {
        boolean match;
        if (this.alwaysMatch) {
            return true;
        }
        if (this.extendedMatchType != null && ExtendedStringMatchBootTypes.isExtendedStringMatchType(this.extendedMatchType)) {
            if (inputString == null) {
                match = false;
            } else if (this.extendedMatchType.equals("RANGE")) {
                match = this.matchRange(inputString);
            } else if (this.extendedMatchType.equals("LE")) {
                match = this.matchLessThan(inputString, true);
            } else if (this.extendedMatchType.equals("LT")) {
                match = this.matchLessThan(inputString, false);
            } else if (this.extendedMatchType.equals("GE")) {
                match = this.matchGreaterThan(inputString, true);
            } else if (this.extendedMatchType.equals("GT")) {
                match = this.matchGreaterThan(inputString, false);
            } else {
                if (!this.extendedMatchType.equals("REGEX_VALUE")) throw new IllegalStateException("Extended match type " + (Object)((Object)this.matchType) + " not supported");
                match = this.regexPattern.matcher(inputString).matches();
            }
        } else {
            if (this.matchType == null && this.extendedMatchType != null) {
                this.matchType = (StringMatchBootType)EnumHelper.getEnum(StringMatchBootType.class, (String)this.extendedMatchType);
            }
            if (this.matchPattern == null && this.extendedMatchPattern != null) {
                this.matchPattern = this.extendedMatchPattern;
            }
            if (this.matchType != StringMatchBootType.NOT_EMPTY && this.matchPattern == null) {
                return false;
            }
            if (inputString == null) {
                match = false;
            } else {
                switch (this.matchType) {
                    case STARTSWITH: {
                        match = this.matchStartsWith(inputString);
                        break;
                    }
                    case ENDSWITH: {
                        match = this.matchEndsWith(inputString);
                        break;
                    }
                    case CONTAINS: {
                        match = this.matchContains(inputString);
                        break;
                    }
                    case EQUALS: {
                        match = this.matchEquals(inputString);
                        break;
                    }
                    case REGEX: {
                        match = this.matchRegex(inputString);
                        break;
                    }
                    case INLIST: {
                        match = this.matchInList(inputString);
                        break;
                    }
                    case NOT_EMPTY: {
                        match = this.checkIfNotEmptyWithoutNullCheck(inputString);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("String match type " + (Object)((Object)this.matchType) + " not supported");
                    }
                }
            }
        }
        if (!this.inverse) return match;
        if (match) return false;
        return true;
    }

    private boolean checkIfNotEmptyWithoutNullCheck(String inputString) {
        return inputString.length() != 0;
    }

    private boolean matchGreaterThan(String inputString, boolean orEquals) {
        int[] intMatchPattern = this.parseIntMatchPattern();
        try {
            if (!orEquals) {
                return Integer.parseInt(inputString) > intMatchPattern[0];
            }
            return Integer.parseInt(inputString) >= intMatchPattern[0];
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matchLessThan(String inputString, boolean orEquals) {
        int[] intMatchPattern = this.parseIntMatchPattern();
        try {
            if (!orEquals) {
                return Integer.parseInt(inputString) < intMatchPattern[0];
            }
            return Integer.parseInt(inputString) <= intMatchPattern[0];
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matchRange(String inputString) {
        int[] intMatchPattern = this.parseIntMatchPattern();
        try {
            int value = Integer.parseInt(inputString);
            return value >= intMatchPattern[0] && value <= intMatchPattern[1];
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matchStartsWith(String inputString) {
        return inputString.startsWith(this.matchPattern);
    }

    private boolean matchEndsWith(String inputString) {
        return inputString.endsWith(this.matchPattern);
    }

    private boolean matchContains(String inputString) {
        return inputString.contains(this.matchPattern);
    }

    private boolean matchEquals(String inputString) {
        return this.matchPattern.equals(inputString);
    }

    private boolean matchRegex(String inputString) {
        if (this.regexPattern == null) {
            this.regexPattern = Pattern.compile(this.matchPattern);
        }
        return StringRegexOperations.regexFind((Pattern)this.regexPattern, (String)inputString);
    }

    private boolean matchInList(String inputString) {
        if (this.inListSet == null) {
            HashSet<String> inListSetLocal = new HashSet<String>();
            CollectionHelper.addAll(inListSetLocal, (Object[])this.inList);
            this.inListSet = inListSetLocal;
        }
        return this.inListSet.contains(inputString);
    }

    public boolean isEmptyPattern() {
        return this.matchPattern == null || this.matchPattern.trim().length() == 0;
    }

    public static boolean isEmpty(StringMatchBoot match) {
        return match == null || match.isEmptyPattern() && match.getMatchType() != StringMatchBootType.NOT_EMPTY;
    }

    public String getExtendedMatchType() {
        return this.extendedMatchType;
    }

    public void setExtendedMatchType(String extendedMatchType) {
        this.extendedMatchType = extendedMatchType;
        if (extendedMatchType == null) {
            return;
        }
        if (!ExtendedStringMatchBootTypes.isExtendedStringMatchType(extendedMatchType)) {
            this.matchType = (StringMatchBootType)EnumHelper.getEnum(StringMatchBootType.class, (String)extendedMatchType);
            if (this.extendedMatchPattern != null) {
                this.matchPattern = this.extendedMatchPattern;
            }
        }
    }

    public int[] getRegexGroups() {
        return this.regexGroups;
    }

    public void setRegexGroups(int[] regexGroups) {
        this.regexGroups = regexGroups;
    }

    public String getExtendedMatchPattern() {
        return this.extendedMatchPattern;
    }

    public void setExtendedMatchPattern(String extendedMatchPattern) {
        this.extendedMatchPattern = extendedMatchPattern;
        if (extendedMatchPattern == null) {
            return;
        }
        if (!ExtendedStringMatchBootTypes.isExtendedStringMatchType(this.extendedMatchType)) {
            this.matchPattern = extendedMatchPattern;
        }
        if (this.extendedMatchType == null) {
            return;
        }
        if (this.extendedMatchType.equals("REGEX") || this.extendedMatchType.equals("REGEX_VALUE")) {
            this.regexPattern = Pattern.compile(extendedMatchPattern);
        } else if (this.extendedMatchType.equals("INLIST")) {
            IStringTokenizer tokenizer = StringOperations.createStringTokenizer((String)extendedMatchPattern, (String)INLIST_DELIMITER);
            this.inList = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.inList[i++] = tokenizer.nextToken().trim();
            }
        } else if (this.extendedMatchType.equals("RANGE") || this.extendedMatchType.equals("LT") || this.extendedMatchType.equals("LE") || this.extendedMatchType.equals("GT") || this.extendedMatchType.equals("GE")) {
            this.parseIntMatchPattern();
        }
    }

    public int[] parseIntMatchPattern() {
        if (this.intMatchPattern == null && this.extendedMatchType != null) {
            int[] lintMatchPattern;
            if (this.extendedMatchType.equals("RANGE")) {
                String[] split = StringRegexOperations.split((String)this.extendedMatchPattern, (String)"-", (int)2);
                lintMatchPattern = new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1])};
            } else {
                lintMatchPattern = new int[]{Integer.parseInt(this.extendedMatchPattern)};
            }
            this.intMatchPattern = lintMatchPattern;
            return lintMatchPattern;
        }
        return this.intMatchPattern;
    }
}

