/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.properties;

import com.singularity.ee.util.logging.ILogger;
import java.util.Map;

public final class PropertyReader {
    private final Map<String, String> properties;

    public PropertyReader(Map<String, String> properties) {
        this.properties = properties;
    }

    public int getMaxIntProperty(String propertyName, int defaultValue, ILogger logger) {
        return Math.max(this.getIntProperty(propertyName, defaultValue, logger), defaultValue);
    }

    public int getIntProperty(String propertyName, int defaultValue, ILogger logger) {
        String prop = this.properties.get(propertyName);
        if (prop == null || prop.trim().length() == 0) {
            logger.debug("Configuration property " + propertyName + " is not specified. Using default value of " + defaultValue);
            return defaultValue;
        }
        try {
            int val = Integer.parseInt(prop);
            logger.debug("Configuration property " + propertyName + " set to " + val);
            return val;
        }
        catch (NumberFormatException e) {
            logger.info("Specified value " + prop + " for configuration property " + propertyName + " is not valid. Using default value of " + defaultValue);
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String propertyName, boolean defaultValue, ILogger logger) {
        String prop = this.properties.get(propertyName);
        if (prop == null || prop.trim().length() == 0) {
            logger.debug("Configuration property " + propertyName + " is not specified. Using default value of " + defaultValue);
            return defaultValue;
        }
        try {
            boolean val = Boolean.parseBoolean(prop);
            logger.debug("Configuration property " + propertyName + " set to " + val);
            return val;
        }
        catch (NumberFormatException e) {
            logger.info("Specified value " + prop + " for configuration property " + propertyName + " is not valid. Using default value of " + defaultValue);
            return defaultValue;
        }
    }

    public String getStringProperty(String propertyName, String defaultValue, ILogger logger) {
        String prop = this.properties.get(propertyName);
        if (prop == null || prop.trim().length() == 0) {
            logger.debug("Configuration property " + propertyName + " is not specified. Using default value of " + defaultValue);
            return defaultValue;
        }
        logger.info("Configuration property " + propertyName + " set to " + prop);
        return prop;
    }

    public String getStringProperty(String propertyName, ILogger logger) {
        String prop = this.properties.get(propertyName);
        return prop;
    }
}

