/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.reflect;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.reflect.DataGathererErrorCheck;
import com.singularity.ee.util.reflect.IJDKSpecificPermissionObtainer;
import com.singularity.ee.util.string.StringOperations;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AgentReflectionUtility {
    private static final IADLogger logger = ADLoggerFactory.getLogger((String)"com.singularity.AgentReflectionUtility");
    private static final char DOT_SEPARATOR = '.';
    private static final Object NO_METHOD = new Object();
    private static final int MAX_ARG_TYPES_TO_SEARCH = 10;
    private final IJDKSpecificPermissionObtainer permissionObtainer;
    private Map<String, Class[]> paramCache = new ConcurrentHashMap<String, Class[]>();
    private Map<String, Object[]> valuesCache = new ConcurrentHashMap<String, Object[]>();
    private Map<String, String[]> chainCache = new ConcurrentHashMap<String, String[]>();
    private AdaptableConcurrentHashMap<Class, AdaptableConcurrentHashMap<String, Object>> getterCache = new AdaptableConcurrentHashMap();

    public AgentReflectionUtility(IJDKSpecificPermissionObtainer permissionObtainer) {
        this.permissionObtainer = permissionObtainer;
    }

    public Object invokeSimpleGetterRecursiveWithString(Object target, String getterChain) throws ReflectionException {
        return this.invokeSimpleGetterRecursiveWithString(target, getterChain, null);
    }

    public Object invokeSimpleGetterRecursiveWithString(Object target, String getterChain, DataGathererErrorCheck result) throws ReflectionException {
        return this.invokeSimpleGetterRecursiveWithStringInternal(target, getterChain, result, true);
    }

    private Object invokeSimpleGetterRecursiveWithStringInternal(Object target, String getterChain, DataGathererErrorCheck result, boolean shouldLog) throws ReflectionException {
        if (getterChain == null) {
            return null;
        }
        String[] methodList = this.chainCache.get(getterChain);
        if (methodList == null) {
            methodList = this.parseGetterChainMethods(getterChain);
            this.chainCache.put(getterChain, methodList);
        }
        return this.invokeSimpleGetterRecursiveWithStringParamInternal(target, methodList, result, shouldLog);
    }

    private Object invokeSimpleGetterRecursiveWithStringParamInternal(Object target, String[] methodList, DataGathererErrorCheck result, boolean shouldLog) throws ReflectionException {
        if (logger.isTraceEnabled()) {
            logger.trace("Invoking getter-chain [" + Arrays.toString(methodList) + "]");
        }
        Object returnVal = null;
        for (String method : methodList) {
            if (target == null) {
                if (result != null) {
                    result.setValid(false);
                    result.setErrorMessage("CANNOT EVALUATE: No target specified");
                }
                return null;
            }
            if (method.equals("this")) {
                returnVal = target;
            } else if (method.equals("length") && target.getClass().isArray()) {
                returnVal = Array.getLength(target);
            } else if (method.startsWith("[") && method.endsWith("]") && target.getClass().isArray()) {
                String[] indices = method.substring(1, method.length() - 1).split(",");
                try {
                    if (indices.length == 1) {
                        returnVal = this.getIndexedObjectFromUnknownArray(target, Integer.parseInt(indices[0].trim()));
                    }
                    StringBuilder builder = new StringBuilder();
                    for (int n = 0; n < indices.length; ++n) {
                        int index = Integer.parseInt(indices[n].trim());
                        builder.append(String.valueOf(this.getIndexedObjectFromUnknownArray(target, index)));
                    }
                    returnVal = builder.toString();
                }
                catch (ClassCastException e) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Error retrieving target, array expected and received [" + target.getClass() + "]");
                    }
                    return null;
                }
            } else {
                Object cachedMethod = this.getMethodOrField(target, method, shouldLog, result);
                if (cachedMethod == null) {
                    if (result != null && result.isValid()) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Invalid getter chain specified");
                    }
                    return null;
                }
                try {
                    if (cachedMethod instanceof Method) {
                        Object[] arrayParamStr;
                        this.permissionObtainer.getAccessToClass(((Method)cachedMethod).getDeclaringClass());
                        int braceBeginIndex = method.indexOf(40);
                        returnVal = braceBeginIndex > 0 ? ((arrayParamStr = this.getParamObjectList(method, braceBeginIndex)).length > 0 ? ((Method)cachedMethod).invoke(target, arrayParamStr) : ((Method)cachedMethod).invoke(target, new Object[0])) : ((Method)cachedMethod).invoke(target, new Object[0]);
                    } else if (cachedMethod instanceof Field) {
                        this.permissionObtainer.getAccessToClass(((Field)cachedMethod).getDeclaringClass());
                        returnVal = ((Field)cachedMethod).get(target);
                    }
                }
                catch (IllegalAccessException e) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE");
                    }
                    return null;
                }
                catch (InvocationTargetException e) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Invalid getter chain");
                    }
                    return null;
                }
            }
            target = returnVal;
        }
        return returnVal;
    }

    public Object getMethodOrField(Object target, String method) {
        return this.getMethodOrField(target, method, false, null);
    }

    private Object getMethodOrField(Object target, String method, boolean logErrors, DataGathererErrorCheck result) {
        AdaptableConcurrentHashMap<String, Object> cacheForClass;
        Object found;
        block28: {
            int braceBeginIndex;
            if (target == null || method == null) {
                if (result != null) {
                    result.setValid(false);
                    result.setErrorMessage("CANNOT EVALUATE: No target or method specified - target = [" + target + "], method = [" + method + "]");
                }
                return null;
            }
            found = null;
            cacheForClass = this.getterCache.get(target.getClass());
            if (cacheForClass != null) {
                Object methodOrField = cacheForClass.get(method);
                if (methodOrField != null && methodOrField != NO_METHOD) {
                    return methodOrField;
                }
                if (methodOrField != null && methodOrField == NO_METHOD) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Could not find specified method = [" + method + "]");
                    }
                    return null;
                }
            }
            if ((braceBeginIndex = method.indexOf(40)) > 0) {
                String methodName = method.substring(0, braceBeginIndex);
                Class[] classArray = this.getParamClassList(method, braceBeginIndex);
                if (classArray.length > 0) {
                    try {
                        found = this.findMethodWithSpecifiedClassLoader(methodName, target, classArray);
                    }
                    catch (ReflectionException e) {
                        if (result != null) {
                            result.setValid(false);
                            result.setErrorMessage("CANNOT EVALUATE: Could not find specified method");
                        }
                        if (logErrors) {
                            logger.error("No method named [" + methodName + "] with a parameters " + StringOperations.classArrayToString((Class[])classArray) + " found in class [" + target.getClass().getName() + "]. This error will not be repeated.", (Throwable)e);
                        }
                        break block28;
                    }
                }
                try {
                    found = this.findMethodWithSpecifiedClassLoader(methodName, target, null);
                }
                catch (ReflectionException e) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Could not find specified method");
                    }
                    if (logErrors) {
                        logger.error("No method named [" + methodName + "] with no parameters found in class [" + target.getClass().getName() + "]. This error will not be repeated.", (Throwable)e);
                    }
                    break block28;
                }
            }
            try {
                found = this.getDeclaredField(target.getClass(), method, true);
            }
            catch (NoSuchFieldException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No field named [" + method + "] found in class [" + target.getClass().getName() + "]. This error will not be repeated. Will look for a method instead.", (Throwable)e);
                }
                try {
                    found = this.findMethodWithSpecifiedClassLoader(method, target, null);
                }
                catch (ReflectionException e2) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("No field or no-parameter method named [" + method + "] found in class (This was done after the field check) [" + target.getClass().getName() + "]. This error will not be repeated.");
                    }
                    if (logErrors) {
                        logger.error("No field or no-parameter method named [" + method + "] found in class (This was done after the field check) [" + target.getClass().getName() + "]. This error will not be repeated.", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                if (result != null) {
                    result.setValid(false);
                    result.setErrorMessage("No field or no-parameter method named [" + method + "] found in class [" + target.getClass().getName() + "]. This error will not be repeated. Will look for a method instead.");
                }
                if (!logErrors) break block28;
                logger.error("No field or no-parameter method named [" + method + "] found in class [" + target.getClass().getName() + "]. This error will not be repeated. Will look for a method instead.", t);
            }
        }
        if (found == null) {
            found = NO_METHOD;
        }
        if (cacheForClass == null) {
            cacheForClass = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.STRONG, AdaptableConcurrentHashMap.ReferenceType.WEAK);
            AdaptableConcurrentHashMap<String, Object> present = this.getterCache.putIfAbsent(target.getClass(), cacheForClass);
            if (present != null) {
                cacheForClass = present;
            }
        }
        cacheForClass.put(method, found);
        return found != NO_METHOD ? found : null;
    }

    public Field getDeclaredField(Class cls, String fieldName, boolean scanSuperClass) throws NoSuchFieldException {
        Field field = null;
        if (scanSuperClass) {
            while (cls != null) {
                try {
                    field = cls.getDeclaredField(fieldName);
                    if (field != null) {
                        break;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                cls = cls.getSuperclass();
            }
            if (field == null) {
                throw new NoSuchFieldException();
            }
            this.permissionObtainer.getAccessToClass(field.getDeclaringClass());
            field.setAccessible(true);
            return field;
        }
        field = cls.getDeclaredField(fieldName);
        this.permissionObtainer.getAccessToClass(cls);
        field.setAccessible(true);
        return field;
    }

    public Method findMethodWithSpecifiedClassLoader(String methodName, Object target, Class[] paramClassList) throws ReflectionException {
        try {
            return this.getMethodWithSpecifiedClassLoader(methodName, target, paramClassList);
        }
        catch (ReflectionException e) {
            return this.getDeclaredMethodWithSpecifiedClassLoader(methodName, target, paramClassList);
        }
    }

    private Method getMethodWithSpecifiedClassLoader(String methodName, Object obj, Class ... parameterTypes) throws ReflectionException {
        Class<?> cls = null;
        if (obj == null) {
            throw new ReflectionException("Object is null, cannot lookup method using its classLoader");
        }
        String className = obj.getClass().getName();
        try {
            cls = obj.getClass();
            this.permissionObtainer.getAccessToClass(cls);
            Method m = cls.getMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            if (parameterTypes != null && parameterTypes.length > 0) {
                try {
                    Method m = this.getMethodWithSpecifiedClassLoaderWithSuperParms(cls, methodName, false, parameterTypes);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception e1) {
                    logger.error(String.format("Exception %s caught in getMethodWithSpecifiedClassLoader()", e1), (Throwable)e1);
                }
            }
            throw new ReflectionException("No method by name [" + methodName + "] found in class [" + className + "]", e);
        }
        catch (Throwable t) {
            throw new ReflectionException("Error while trying to get method by name [" + methodName + "] found in class [" + className + "]", t);
        }
    }

    public Method getDeclaredMethodWithSpecifiedClassLoader(String methodName, Object obj, Class ... parameterTypes) throws ReflectionException {
        return this.getDeclaredMethodWithSpecifiedClassLoader(obj.getClass().getName(), methodName, obj, parameterTypes);
    }

    public Method getDeclaredMethodWithSpecifiedClassLoader(String className, String methodName, Object obj, Class ... parameterTypes) throws ReflectionException {
        if (obj == null) {
            throw new ReflectionException("Object is null, cannot lookup method using its classLoader");
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className, true, obj.getClass().getClassLoader());
            this.permissionObtainer.getAccessToClass(cls);
            Method m = cls.getDeclaredMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Error in loading class [" + className + "] with loader [" + obj.getClass().getClassLoader() + "].", e);
        }
        catch (NoSuchMethodException e) {
            if (parameterTypes != null && parameterTypes.length > 0) {
                try {
                    Method m = this.getMethodWithSpecifiedClassLoaderWithSuperParms(cls, methodName, true, parameterTypes);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception e1) {
                    logger.error(String.format("Exception %s caught in getDeclaredMethodWithSpecifiedClassLoader()", e1), (Throwable)e1);
                }
            }
            throw new ReflectionException("No method named [" + methodName + "] with parameter(s) " + StringOperations.classArrayToString((Class[])parameterTypes) + " found in class [" + className + "].", e);
        }
    }

    private Method getMethodWithSpecifiedClassLoaderWithSuperParms(Class<?> clazz, String methodName, boolean getDeclaredMethod, Class ... parameterTypes) throws Exception {
        Method returnMethod = null;
        HashSet<ArgTypes> setOfAllArgTypes = new HashSet<ArgTypes>();
        this.getAllPossibleArgTypes(0, parameterTypes, setOfAllArgTypes);
        for (ArgTypes nextArgType : setOfAllArgTypes) {
            try {
                this.permissionObtainer.getAccessToClass(clazz);
                returnMethod = getDeclaredMethod ? clazz.getDeclaredMethod(methodName, nextArgType.argTypes) : clazz.getMethod(methodName, nextArgType.argTypes);
                returnMethod.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return returnMethod;
    }

    private void getAllPossibleArgTypes(int varyIndex, Class<?>[] initialArgTypes, Set<ArgTypes> addToSet) {
        Class<?>[] newArgTypes = AgentReflectionUtility.copyArgTypes(initialArgTypes);
        while (newArgTypes[varyIndex].getSuperclass() != null && addToSet.size() < 10) {
            newArgTypes[varyIndex] = newArgTypes[varyIndex].getSuperclass();
            addToSet.add(new ArgTypes(newArgTypes));
            if (varyIndex >= newArgTypes.length - 1) continue;
            this.getAllPossibleArgTypes(varyIndex + 1, newArgTypes, addToSet);
        }
        if (varyIndex < initialArgTypes.length - 1 && addToSet.size() < 10) {
            this.getAllPossibleArgTypes(varyIndex + 1, initialArgTypes, addToSet);
        }
    }

    public String[] parseGetterChainMethods(String getterChain) {
        ArrayList<String> parsedList = new ArrayList<String>();
        boolean escaped = false;
        boolean inParan = false;
        int prevSplit = 0;
        int splits = 0;
        for (int i = 0; i < getterChain.length(); ++i) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (getterChain.charAt(i) == '(') {
                inParan = true;
            }
            if (getterChain.charAt(i) == ')') {
                inParan = false;
                continue;
            }
            if (getterChain.charAt(i) == '\\') {
                escaped = true;
                continue;
            }
            if (inParan || '.' != getterChain.charAt(i)) continue;
            parsedList.add(getterChain.substring(prevSplit, i).trim());
            prevSplit = i + 1;
            ++splits;
        }
        parsedList.add(getterChain.substring(prevSplit, getterChain.length()).trim());
        return parsedList.toArray(new String[parsedList.size()]);
    }

    private Object getIndexedObjectFromUnknownArray(Object inputArray, int index) throws ClassCastException {
        Object result = null;
        if (Object.class.isAssignableFrom(inputArray.getClass().getComponentType())) {
            Object[] inputObjects = (Object[])inputArray;
            result = this.safeArrayIdx(inputObjects, index);
        } else if (inputArray instanceof int[]) {
            int[] array = (int[])inputArray;
            result = index >= 0 && index < array.length ? new Integer(array[index]) : null;
        } else if (inputArray instanceof byte[]) {
            byte[] array = (byte[])inputArray;
            result = index >= 0 && index < array.length ? new Byte(array[index]) : null;
        } else if (inputArray instanceof short[]) {
            short[] array = (short[])inputArray;
            result = index >= 0 && index < array.length ? new Short(array[index]) : null;
        } else if (inputArray instanceof long[]) {
            long[] array = (long[])inputArray;
            result = index >= 0 && index < array.length ? new Long(array[index]) : null;
        } else if (inputArray instanceof float[]) {
            float[] array = (float[])inputArray;
            result = index >= 0 && index < array.length ? new Float(array[index]) : null;
        } else if (inputArray instanceof double[]) {
            double[] array = (double[])inputArray;
            result = index >= 0 && index < array.length ? new Double(array[index]) : null;
        } else if (inputArray instanceof char[]) {
            char[] array = (char[])inputArray;
            result = index >= 0 && index < array.length ? new Character(array[index]) : null;
        } else if (inputArray instanceof boolean[]) {
            boolean[] array = (boolean[])inputArray;
            result = index >= 0 && index < array.length ? new Boolean(array[index]) : null;
        }
        return result;
    }

    public Class[] getParamClassList(String arrayParamStr, int braceIndex) {
        Class[] paramsList = this.paramCache.get(arrayParamStr);
        if (paramsList == null) {
            this.parseParams(arrayParamStr, braceIndex);
            paramsList = this.paramCache.get(arrayParamStr);
        }
        return paramsList;
    }

    public Object[] getParamObjectList(String arrayParamStr, int braceIndex) {
        Object[] objectList = this.valuesCache.get(arrayParamStr);
        if (objectList == null) {
            this.parseParams(arrayParamStr, braceIndex);
            objectList = this.valuesCache.get(arrayParamStr);
        }
        return objectList;
    }

    private void parseParams(String paramStr, int braceIndex) {
        ArrayList<Class<Float>> paramsList = new ArrayList<Class<Float>>();
        ArrayList<Float> valuesList = new ArrayList<Float>();
        char[] arrayParamStr = paramStr.toCharArray();
        int length = arrayParamStr.length;
        int i = braceIndex + 1;
        while (i < length) {
            Object value;
            Class<Object> clazz;
            StringBuilder sb = new StringBuilder();
            int classEnd = 0;
            int valueBegin = 0;
            int valueEnd = 0;
            int ch = 0;
            while (i < length) {
                ch = arrayParamStr[i];
                ++i;
                if (ch == 44 || ch == 41) break;
                if (Character.isWhitespace((char)ch)) {
                    if (sb.length() <= 0) continue;
                    sb.append((char)ch);
                    continue;
                }
                if (ch == 47 && valueBegin == 0) {
                    classEnd = sb.length();
                    sb.append((char)ch);
                    while (i < length && Character.isWhitespace(arrayParamStr[i])) {
                        sb.append(arrayParamStr[i]);
                        ++i;
                    }
                    valueEnd = valueBegin = sb.length();
                    continue;
                }
                if (ch == 92 && i < length) {
                    ch = arrayParamStr[i];
                    ++i;
                    switch (ch) {
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 116: {
                            ch = 9;
                        }
                    }
                }
                sb.append((char)ch);
                valueEnd = sb.length();
            }
            if (valueEnd == 0 && ch != 44 && paramsList.isEmpty()) break;
            String parsedString = sb.toString();
            String className = parsedString.substring(0, classEnd).toLowerCase().trim();
            String valueString = parsedString.substring(valueBegin, valueEnd);
            if (className.equals("float")) {
                clazz = Float.TYPE;
                value = Float.valueOf(Float.parseFloat(valueString));
            } else if (className.equals("boolean")) {
                clazz = Boolean.class;
                value = Boolean.parseBoolean(valueString);
            } else if (className.equals("bool")) {
                clazz = Boolean.TYPE;
                value = Boolean.parseBoolean(valueString);
            } else if (className.equals("int")) {
                clazz = Integer.TYPE;
                value = Integer.parseInt(valueString);
            } else if (className.equals("long")) {
                clazz = Long.TYPE;
                value = Long.parseLong(valueString);
            } else if (className.equals("object")) {
                clazz = Object.class;
                value = valueString;
            } else if (className.equals("string")) {
                clazz = String.class;
                value = valueString;
            } else {
                clazz = String.class;
                value = parsedString.substring(0, valueEnd);
            }
            paramsList.add(clazz);
            valuesList.add((Float)value);
        }
        this.paramCache.put(paramStr, paramsList.toArray(new Class[paramsList.size()]));
        this.valuesCache.put(paramStr, valuesList.toArray(new Object[valuesList.size()]));
    }

    private Object safeArrayIdx(Object[] array, int index) {
        Object obj = null;
        if (index >= 0 && index < array.length) {
            obj = array[index];
        }
        return obj;
    }

    private static Class<?>[] copyArgTypes(Class<?>[] argTypeArray) {
        Class[] argTypes = new Class[argTypeArray.length];
        System.arraycopy(argTypeArray, 0, argTypes, 0, argTypes.length);
        return argTypes;
    }

    public void flushCaches() {
        this.getterCache.clear();
        this.paramCache.clear();
        this.valuesCache.clear();
    }

    private class ArgTypes {
        final Class<?>[] argTypes;
        private final int hashValue;

        ArgTypes(Class<?>[] argTypes) {
            this.argTypes = AgentReflectionUtility.copyArgTypes(argTypes);
            int hashValue = 0;
            for (Class<?> nextType : this.argTypes) {
                hashValue ^= nextType.hashCode();
            }
            this.hashValue = hashValue;
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof ArgTypes) {
                ArgTypes other = (ArgTypes)o;
                if (this.hashValue == other.hashValue && this.argTypes.length == other.argTypes.length) {
                    bReturn = true;
                    for (int i = 0; i < this.argTypes.length && bReturn; ++i) {
                        bReturn = this.argTypes[i] == other.argTypes[i];
                    }
                }
            }
            return bReturn;
        }
    }
}

