/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgParser {
    private static final String BOOLEAN_FLAG_DUMMY_VALUE = "True";
    private final Set<String> requiredArgs;
    private final Set<String> booleanFlags;
    private final Map<String, String> optionalArgs;

    public ArgParser(Set<String> requiredArgs, Set<String> booleanFlags, Map<String, String> optionalArgs) {
        this.requiredArgs = requiredArgs;
        this.booleanFlags = booleanFlags;
        this.optionalArgs = optionalArgs;
    }

    public static ArgParserBuilder withRequired(String arg) {
        return new ArgParserBuilder().withRequired(arg);
    }

    public static ArgParserBuilder withBooleanFlag(String arg) {
        return new ArgParserBuilder().withBooleanFlag(arg);
    }

    public static ArgParserBuilder withOptional(String arg, String defaultValue) {
        return new ArgParserBuilder().withOptional(arg, defaultValue);
    }

    public Map<String, String> parse(String[] args) throws IllegalArgumentException {
        if (args.length < this.requiredArgs.size() * 2) {
            throw new IllegalArgumentException("Too little arguments");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        int argumentIdx = 0;
        while (argumentIdx < args.length) {
            String option = args[argumentIdx].toLowerCase();
            if (this.requiredArgs.contains(option) || this.optionalArgs.containsKey(option)) {
                if (argumentIdx + 1 >= args.length) {
                    throw new IllegalArgumentException("No value for flag " + option);
                }
                String value = args[argumentIdx + 1];
                String oldVal = properties.put(option, value);
                if (oldVal != null) {
                    throw new IllegalArgumentException("Duplicate flag " + option);
                }
                argumentIdx += 2;
                continue;
            }
            if (this.booleanFlags.contains(option)) {
                properties.put(option, BOOLEAN_FLAG_DUMMY_VALUE);
                ++argumentIdx;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized flag " + option);
        }
        this.checkIfAllRequiredArgsAreSet(properties);
        this.addDefaultValuesForUnsetOptionalArguments(properties);
        return properties;
    }

    private void checkIfAllRequiredArgsAreSet(Map<String, String> properties) {
        for (String requiredArg : this.requiredArgs) {
            if (properties.containsKey(requiredArg)) continue;
            throw new IllegalArgumentException("Flag " + requiredArg + " is required.");
        }
    }

    private void addDefaultValuesForUnsetOptionalArguments(Map<String, String> properties) {
        for (Map.Entry<String, String> optionalArg : this.optionalArgs.entrySet()) {
            if (properties.containsKey(optionalArg.getKey())) continue;
            properties.put(optionalArg.getKey(), optionalArg.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArgParserBuilder {
        private final Set<String> requiredArgs = new HashSet<String>();
        private final Set<String> booleanFlags = new HashSet<String>();
        private final Map<String, String> optionalArgs = new HashMap<String, String>();

        public ArgParserBuilder withRequired(String arg) {
            if (!this.isUnique(arg = arg.toLowerCase())) {
                throw new RuntimeException("Argument " + arg + " is not unique.");
            }
            this.requiredArgs.add(arg);
            return this;
        }

        public ArgParserBuilder withBooleanFlag(String arg) {
            if (!this.isUnique(arg = arg.toLowerCase())) {
                throw new RuntimeException("Argument " + arg + " is not unique.");
            }
            this.booleanFlags.add(arg);
            return this;
        }

        public ArgParserBuilder withOptional(String arg, String defaultValue) {
            if (!this.isUnique(arg = arg.toLowerCase())) {
                throw new RuntimeException("Argument " + arg + " is not unique.");
            }
            this.optionalArgs.put(arg, defaultValue);
            return this;
        }

        private boolean isUnique(String arg) {
            return !this.requiredArgs.contains(arg) && !this.optionalArgs.containsKey(arg) && !this.booleanFlags.contains(arg);
        }

        public Map<String, String> parse(String[] args) {
            return this.build().parse(args);
        }

        public ArgParser build() {
            return new ArgParser(this.requiredArgs, this.booleanFlags, this.optionalArgs);
        }
    }
}

