/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import com.singularity.ee.util.security.credentialstore.impl.EncryptionSchemeCBCWithPKCS5Padding;
import com.singularity.ee.util.security.credentialstore.impl.EncryptionSchemeLegacy;
import com.singularity.ee.util.security.credentialstore.impl.IEncryption;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.crypto.SecretKey;

final class EncryptionCommon {
    private static final String PREFIX_SCHEME_ID_EMPTY = "";
    private static final String PREFIX_SCHEME_ID_001 = "-001-";
    private static final int ENCRYPTION_SCHEME_PREFIX_LENGTH = 5;
    private static final EncryptionSchemeType latestEncryptionScheme = EncryptionSchemeType.ENCRYPTION_SCHEME_CBC_PKCS5PADDING;
    private static final HashMap<String, EncryptionSchemeType> encryptionIdToSchemeTypeMap;
    private static final HashMap<EncryptionSchemeType, IEncryption> encryptionSchemeTypeToEncryptionSchemeMap;

    EncryptionCommon() {
    }

    static String decryptCipherTextString(String cipherText, SecretKey secretKey) throws GeneralSecurityException {
        IEncryption chosenEncryptionScheme;
        if (cipherText == null) {
            return null;
        }
        try {
            String encryptionSchemePrefix = cipherText.substring(0, 5);
            EncryptionSchemeType encryptionSchemeType = encryptionIdToSchemeTypeMap.get(encryptionSchemePrefix);
            chosenEncryptionScheme = encryptionSchemeTypeToEncryptionSchemeMap.get((Object)encryptionSchemeType);
        }
        catch (Exception x) {
            return encryptionSchemeTypeToEncryptionSchemeMap.get((Object)EncryptionSchemeType.ENCRYPTION_SCHEME_LEGACY).decrypt(cipherText, secretKey);
        }
        try {
            return chosenEncryptionScheme.decrypt(cipherText, secretKey);
        }
        catch (Exception x) {
            return encryptionSchemeTypeToEncryptionSchemeMap.get((Object)EncryptionSchemeType.ENCRYPTION_SCHEME_LEGACY).decrypt(cipherText, secretKey);
        }
    }

    static String encryptPlainTextString(String plainText, SecretKey secretKey) throws GeneralSecurityException {
        return encryptionSchemeTypeToEncryptionSchemeMap.get((Object)latestEncryptionScheme).encrypt(plainText, secretKey);
    }

    static {
        encryptionSchemeTypeToEncryptionSchemeMap = new HashMap();
        encryptionSchemeTypeToEncryptionSchemeMap.put(EncryptionSchemeType.ENCRYPTION_SCHEME_LEGACY, new EncryptionSchemeLegacy(PREFIX_SCHEME_ID_EMPTY));
        encryptionSchemeTypeToEncryptionSchemeMap.put(EncryptionSchemeType.ENCRYPTION_SCHEME_CBC_PKCS5PADDING, new EncryptionSchemeCBCWithPKCS5Padding(PREFIX_SCHEME_ID_001));
        encryptionIdToSchemeTypeMap = new HashMap();
        encryptionIdToSchemeTypeMap.put(PREFIX_SCHEME_ID_EMPTY, EncryptionSchemeType.ENCRYPTION_SCHEME_LEGACY);
        encryptionIdToSchemeTypeMap.put(PREFIX_SCHEME_ID_001, EncryptionSchemeType.ENCRYPTION_SCHEME_CBC_PKCS5PADDING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EncryptionSchemeType {
        ENCRYPTION_SCHEME_LEGACY,
        ENCRYPTION_SCHEME_CBC_PKCS5PADDING;

    }
}

