/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import com.singularity.ee.util.security.credentialstore.ArgParser;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapperFactory;
import com.singularity.ee.util.security.credentialstore.KeyStoreHelper;
import com.singularity.ee.util.security.credentialstore.KeyStoreManager;
import com.singularity.ee.util.security.credentialstore.ObfuscationWrapper;
import com.singularity.ee.util.security.credentialstore.exception.CryptoOperationFailureException;
import com.singularity.ee.util.security.credentialstore.exception.ObfuscationOperationFailureException;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import sun.security.jca.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureCredentialStore {
    private static final String ACTION_VALIDATE_KEYSTORE = "validate_ks";
    private static final String ACTION_GENERATE_KEYSTORE = "generate_ks";
    private static final String ACTION_ENCRYPT_TEXT = "encrypt";
    private static final String ACTION_OBFUSCATE_TEXT = "obfuscate";
    private static final String OPTION_KEYSTORE_PASSWORD = "-storepass";
    private static final String OPTION_KEYSTORE_FILENAME = "-filename";
    private static final String OPTION_KEYSTORE_FORMAT = "-format";
    private static final String OPTION_PLAINTEXT = "-plaintext";
    private static final String OPTION_MACHINEBOUND = "-machinebound";
    private static final int FAILURE_EXIT_CODE = 1;
    private static final int SUCCESS_EXIT_CODE = 0;

    static void showUsage(PrintStream printStream) {
        printStream.println("Here are possible command line options:");
        printStream.println("SecureCredentialStore validate_ks -filename <filename> -storepass <keyStorepassword> [-format <keyStoreFormat>]");
        printStream.println("SecureCredentialStore generate_ks -filename <filename> -storepass <keyStorepassword> [-format <keyStoreFormat>]");
        printStream.println("SecureCredentialStore encrypt -filename <filename> -storepass <keyStorepassword> -plaintext <PLAIN-TEXT> [-format <keyStoreFormat>]");
        printStream.println("SecureCredentialStore obfuscate -plaintext <PLAIN-TEXT> -machinebound");
        printStream.println("SecureCredentialStore obfuscate -plaintext <PLAIN-TEXT>");
    }

    static boolean performValidateKeyStore(String[] args, PrintStream printStream) {
        Map<String, String> parsedArgs;
        try {
            parsedArgs = ArgParser.withRequired(OPTION_KEYSTORE_PASSWORD).withRequired(OPTION_KEYSTORE_FILENAME).withOptional(OPTION_KEYSTORE_FORMAT, "JCEKS").parse(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            SecureCredentialStore.showUsage(printStream);
            return false;
        }
        String keyStorePassword = parsedArgs.get(OPTION_KEYSTORE_PASSWORD);
        String keyStoreFilename = parsedArgs.get(OPTION_KEYSTORE_FILENAME);
        String keyStoreFormat = parsedArgs.get(OPTION_KEYSTORE_FORMAT);
        boolean keyStoreAlreadyExists = KeyStoreHelper.checkIfKeyStoreFileExists(keyStoreFilename);
        if (!keyStoreAlreadyExists) {
            printStream.println("Invalid KeyStore: " + keyStoreFilename);
            return false;
        }
        boolean isKeyStoreInitialized = false;
        try {
            isKeyStoreInitialized = KeyStoreManager.checkIfValidKeyStoreExists(keyStoreFilename, keyStorePassword.toCharArray(), keyStoreFormat);
            printStream.println("Found Valid KeyStore: " + keyStoreFilename);
        }
        catch (IOException ioException) {
            printStream.println("Existing KeyStore file: " + keyStoreFilename + " is not properly initialized.");
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            printStream.println("Failed to fetch SecretKey from existing KeyStore file: " + keyStoreFilename + " Perhaps, it is not properly initialized.");
            return false;
        }
        if (isKeyStoreInitialized) {
            printStream.println("Existing KeyStore file: " + keyStoreFilename + " is properly initialized.");
            return true;
        }
        printStream.println("Existing KeyStore file: " + keyStoreFilename + " is not properly initialized.");
        return false;
    }

    static boolean performGenerateKeyStore(String[] args, PrintStream printStream) {
        Map<String, String> parsedArgs;
        try {
            parsedArgs = ArgParser.withRequired(OPTION_KEYSTORE_PASSWORD).withRequired(OPTION_KEYSTORE_FILENAME).withOptional(OPTION_KEYSTORE_FORMAT, "JCEKS").parse(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            SecureCredentialStore.showUsage(printStream);
            return false;
        }
        String keyStorePassword = parsedArgs.get(OPTION_KEYSTORE_PASSWORD);
        String keyStoreFilename = parsedArgs.get(OPTION_KEYSTORE_FILENAME);
        String keyStoreFormat = parsedArgs.get(OPTION_KEYSTORE_FORMAT);
        boolean keyStoreAlreadyExists = KeyStoreHelper.checkIfKeyStoreFileExists(keyStoreFilename);
        if (keyStoreAlreadyExists) {
            printStream.println("Already Exists KeyStore file: " + keyStoreFilename);
            return false;
        }
        boolean newKeyStoreInitialized = false;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreManager.createNewKeyStoreInstance(keyStoreFormat, keyStorePassword.toCharArray());
        }
        catch (GeneralSecurityException generalSecurityException) {
            printStream.println("Failed to create new instance of KeyStore. Reason: " + generalSecurityException.getMessage());
            SecureCredentialStore.printSuitableKeyStoreFormats(keyStorePassword);
            return false;
        }
        SecretKey secretKey = null;
        try {
            secretKey = KeyStoreManager.createNewSecretKeyInStoreInstance(keyStore, keyStorePassword.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            printStream.println("Failed to create new SecretKey in the new KeyStore instance. Reason: " + keyStoreException.getMessage());
            SecureCredentialStore.printSuitableKeyStoreFormats(keyStorePassword);
            return false;
        }
        try {
            newKeyStoreInitialized = KeyStoreManager.saveKeyStoreObjectInFileSystem(keyStore, keyStoreFilename, keyStorePassword.toCharArray());
        }
        catch (IOException ioException) {
            printStream.println("Failed to properly create and initialize new KeyStore file: " + keyStoreFilename + " Reason: " + ioException.getMessage());
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            printStream.println("Failed to properly create and initialize new KeyStore file: " + keyStoreFilename + " Reason: " + generalSecurityException.getMessage());
            return false;
        }
        if (newKeyStoreInitialized) {
            printStream.println("Successfully created and initialized new KeyStore file: " + keyStoreFilename);
        } else {
            printStream.println("Failed to create and initialize new KeyStore file: " + keyStoreFilename);
        }
        boolean isKeyStoreInitialized = false;
        try {
            isKeyStoreInitialized = KeyStoreManager.checkIfValidKeyStoreExists(keyStoreFilename, keyStorePassword.toCharArray(), keyStoreFormat);
        }
        catch (IOException ioException) {
            printStream.println("Verification - New KeyStore file: " + keyStoreFilename + " is not properly initialized.");
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            printStream.println("Failed to fetch SecretKey from existing KeyStore file: " + keyStoreFilename + " Perhaps, it is not properly initialized.");
            return false;
        }
        if (isKeyStoreInitialized) {
            printStream.println("Verification - New KeyStore file: " + keyStoreFilename + " is properly initialized.");
            return true;
        }
        printStream.println("VERIFICATION FAILURE - New KeyStore file: " + keyStoreFilename + " is not properly initialized.");
        return false;
    }

    private static void printSuitableKeyStoreFormats(String keyStorePassword) {
        Set<String> suitableKeyStoreFormats = SecureCredentialStore.getSuitableKeyStoreFormats(keyStorePassword);
        System.out.println("Available Keystore formats that allow symmetric keys:");
        for (String suitableKeyStoreFormat : suitableKeyStoreFormats) {
            System.out.println(suitableKeyStoreFormat);
        }
    }

    private static Set<String> getSuitableKeyStoreFormats(String keyStorePassword) {
        HashSet<String> suitableKeyStoreFormats = new HashSet<String>();
        for (Provider provider : Providers.getProviderList().providers()) {
            IdentityHashMap<Provider.Service, KeyStore> instances = new IdentityHashMap<Provider.Service, KeyStore>();
            for (Provider.Service service : provider.getServices()) {
                if (!service.getType().equals("KeyStore")) continue;
                try {
                    KeyStore instance = KeyStore.getInstance(service.getAlgorithm());
                    instance.load(null, keyStorePassword.toCharArray());
                    instances.put(service, instance);
                }
                catch (Exception instance) {}
            }
            for (Map.Entry entry : instances.entrySet()) {
                Provider.Service service = (Provider.Service)entry.getKey();
                KeyStore keyStore = (KeyStore)entry.getValue();
                try {
                    KeyStoreManager.createNewSecretKeyInStoreInstance(keyStore, keyStorePassword.toCharArray());
                    suitableKeyStoreFormats.add(service.getAlgorithm());
                }
                catch (KeyStoreException keyStoreException) {}
            }
        }
        return suitableKeyStoreFormats;
    }

    static boolean performEncryptPlainText(String[] args, PrintStream printStream) {
        Map<String, String> parsedArgs;
        try {
            parsedArgs = ArgParser.withRequired(OPTION_KEYSTORE_PASSWORD).withRequired(OPTION_KEYSTORE_FILENAME).withRequired(OPTION_PLAINTEXT).withOptional(OPTION_KEYSTORE_FORMAT, "JCEKS").parse(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            SecureCredentialStore.showUsage(printStream);
            return false;
        }
        String keyStorePassword = parsedArgs.get(OPTION_KEYSTORE_PASSWORD);
        String keyStoreFilename = parsedArgs.get(OPTION_KEYSTORE_FILENAME);
        String keyStoreFormat = parsedArgs.get(OPTION_KEYSTORE_FORMAT);
        String plainText = parsedArgs.get(OPTION_PLAINTEXT);
        boolean keyStoreAlreadyExists = KeyStoreHelper.checkIfKeyStoreFileExists(keyStoreFilename);
        if (!keyStoreAlreadyExists) {
            printStream.println("Invalid KeyStore: " + keyStoreFilename);
            return false;
        }
        KeyStoreBasedEncryptionWrapper ksBasedEncryption = null;
        try {
            ksBasedEncryption = new KeyStoreBasedEncryptionWrapperFactory().createWithClearTextPassword(keyStoreFilename, keyStorePassword, keyStoreFormat);
        }
        catch (IOException ioException) {
            String plainTextKeyStorePassword = keyStorePassword;
            try {
                plainTextKeyStorePassword = ObfuscationWrapper.deobfuscateString(keyStorePassword);
            }
            catch (ObfuscationOperationFailureException obfuscationOperationFailureException) {
                // empty catch block
            }
            try {
                ksBasedEncryption = new KeyStoreBasedEncryptionWrapperFactory().createWithClearTextPassword(keyStoreFilename, plainTextKeyStorePassword, keyStoreFormat);
            }
            catch (IOException nestedIoException) {
                printStream.println("Failed to access a properly initialized KeyStore: " + keyStoreFilename + " Reason: " + ioException.getMessage());
                return false;
            }
            catch (GeneralSecurityException generalSecurityException) {
                printStream.println("Failed to Validate Crypto aspects of the KeyStore: " + keyStoreFilename + " Reason: " + generalSecurityException.getMessage());
                return false;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            printStream.println("Failed to Validate Crypto aspects of the KeyStore: " + keyStoreFilename + " Reason: " + generalSecurityException.getMessage());
            return false;
        }
        try {
            String cipherText = ksBasedEncryption.encryptPlainTextString(plainText);
            String originalPlainText = ksBasedEncryption.decryptCipherTextString(cipherText);
            if (!plainText.equals(originalPlainText)) {
                printStream.println("Internal verification error - Encryption framework is either compromised or failing.");
                return false;
            }
            printStream.println(cipherText);
            return true;
        }
        catch (CryptoOperationFailureException cryptoOperationFailureException) {
            printStream.println("Failed to encrypt the plainText: " + plainText + " Reason: " + cryptoOperationFailureException.getMessage());
            return false;
        }
    }

    static boolean performObfuscatePlainText(String[] args, PrintStream printStream) {
        Map<String, String> parsedArgs;
        try {
            parsedArgs = ArgParser.withRequired(OPTION_PLAINTEXT).withBooleanFlag(OPTION_MACHINEBOUND).parse(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            SecureCredentialStore.showUsage(printStream);
            return false;
        }
        String plainText = parsedArgs.get(OPTION_PLAINTEXT);
        boolean isMachineBound = parsedArgs.containsKey(OPTION_MACHINEBOUND);
        try {
            String cipherText = ObfuscationWrapper.obfuscateString(plainText, isMachineBound);
            String originalPlainText = ObfuscationWrapper.deobfuscateString(cipherText);
            if (!plainText.equals(originalPlainText)) {
                printStream.println("Internal verification Error - Obfuscation framework is either compromised or failing.");
                return false;
            }
            printStream.println(cipherText);
            return true;
        }
        catch (ObfuscationOperationFailureException obfuscationOperationFailureException) {
            printStream.println("Failed to encrypt the plainText: " + plainText + " Reason: " + obfuscationOperationFailureException.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        PrintStream printStream = System.out;
        if (args.length < 2) {
            SecureCredentialStore.showUsage(printStream);
            System.exit(1);
            return;
        }
        boolean isSuccessful = false;
        String actionToPerform = args[0].toLowerCase();
        String[] justArgs = SecureCredentialStore.justArgs(args);
        if (actionToPerform.equals(ACTION_VALIDATE_KEYSTORE)) {
            isSuccessful = SecureCredentialStore.performValidateKeyStore(justArgs, printStream);
        } else if (actionToPerform.equals(ACTION_GENERATE_KEYSTORE)) {
            isSuccessful = SecureCredentialStore.performGenerateKeyStore(justArgs, printStream);
        } else if (actionToPerform.equals(ACTION_ENCRYPT_TEXT)) {
            isSuccessful = SecureCredentialStore.performEncryptPlainText(justArgs, printStream);
        } else if (actionToPerform.equals(ACTION_OBFUSCATE_TEXT)) {
            isSuccessful = SecureCredentialStore.performObfuscatePlainText(justArgs, printStream);
        } else {
            SecureCredentialStore.showUsage(printStream);
        }
        System.exit(isSuccessful ? 0 : 1);
    }

    private static String[] justArgs(String[] args) {
        String[] justArgs = new String[args.length - 1];
        System.arraycopy(args, 1, justArgs, 0, args.length - 1);
        return justArgs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Identity<T> {
        private final T obj;

        Identity(T obj) {
            this.obj = obj;
        }

        public static <T> Identity<T> of(T obj) {
            return new Identity<T>(obj);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identity identity = (Identity)o;
            return this.obj == identity.obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }
}

