/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.HashMap;
import java.util.Map;
import org.zeromq.ZConfig;
import org.zeromq.ZMQ;

public class ZCert {
    private byte[] public_key;
    private byte[] secret_key;
    private String public_txt;
    private String secret_txt;
    private Map<String, String> metadata = new HashMap<String, String>();

    public ZCert(String publicKey) {
        if (publicKey.length() == 32) {
            this.public_key = publicKey.getBytes();
            this.public_txt = ZMQ.Curve.z85Encode(this.public_key);
        } else {
            this.public_key = ZMQ.Curve.z85Decode(publicKey);
            this.public_txt = publicKey;
        }
    }

    public ZCert() {
        ZMQ.Curve.KeyPair keypair = ZMQ.Curve.generateKeyPair();
        this.public_key = ZMQ.Curve.z85Decode(keypair.publicKey);
        this.public_txt = keypair.publicKey;
        this.secret_key = ZMQ.Curve.z85Decode(keypair.secretKey);
        this.secret_txt = keypair.secretKey;
    }

    public byte[] getPublicKey() {
        return this.public_key;
    }

    public byte[] getSecretKey() {
        return this.secret_key;
    }

    public String getPublicKeyAsZ85() {
        return this.public_txt;
    }

    public String getSecretKeyAsZ85() {
        return this.secret_txt;
    }

    public void setMeta(String key, String value) {
        this.metadata.put(key, value);
    }

    private void metaToZConfig(Map<String, String> meta, ZConfig zconf) {
        for (String key : meta.keySet()) {
            zconf.putValue("metadata/" + key, meta.get(key));
        }
    }

    public void savePublic(String filename) {
        ZConfig zconf = new ZConfig("root", null);
        this.metaToZConfig(this.metadata, zconf);
        zconf.addComment("   ZeroMQ CURVE Public Certificate");
        zconf.addComment("   Exchange securely, or use a secure mechanism to verify the contents");
        zconf.addComment("   of this file after exchange. Store public certificates in your home");
        zconf.addComment("   directory, in the .curve subdirectory.");
        zconf.putValue("/curve/public-key", this.public_txt);
        zconf.save(filename);
    }

    public void saveSecret(String filename) {
        ZConfig zconf = new ZConfig("root", null);
        this.metaToZConfig(this.metadata, zconf);
        zconf.addComment("   ZeroMQ CURVE **Secret** Certificate");
        zconf.addComment("   DO NOT PROVIDE THIS FILE TO OTHER USERS nor change its permissions.");
        zconf.putValue("/curve/public-key", this.public_txt);
        zconf.putValue("/curve/secret-key", this.secret_txt);
        zconf.save(filename);
    }
}

