/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.zeromq.ZConfig;
import org.zeromq.ZMQ;

public class ZCertStore {
    private String location;
    private long modified;
    private int certCount;
    private int fileSize;
    private int tempCounter;
    private boolean fileCheckRunning = false;
    private boolean requestStopThread = false;
    private Set<String> publicKeys = new HashSet<String>();

    public ZCertStore(String location) {
        this.loadFiles(location);
    }

    private void traverseDirectory(String path, IFileVisitor visitor) {
        File root = new File(path);
        this.traverseDirectory(root, visitor);
    }

    private void traverseDirectory(File root, IFileVisitor visitor) {
        if (!root.exists()) {
            throw new RuntimeException("There is no path:" + root.getPath());
        }
        if (!root.isDirectory()) {
            throw new RuntimeException("Path:" + root.getPath() + " is not a directory!");
        }
        for (File f : root.listFiles()) {
            if (f.isFile()) {
                visitor.handleFile(f);
                continue;
            }
            if (f.isDirectory()) {
                visitor.handleDir(f);
                this.traverseDirectory(f, visitor);
                continue;
            }
            System.out.println("WARNING:" + f + " is neither file nor directory? This shouldn't happen....SKIPPING");
        }
    }

    public boolean containsPublicKey(byte[] publicKey) {
        if (publicKey.length != 32) {
            throw new RuntimeException("publickey needs to have a size of 32bytes. got only " + publicKey.length);
        }
        String z85Key = ZMQ.Curve.z85Encode(publicKey);
        return this.containsPublicKey(z85Key);
    }

    public boolean containsPublicKey(String publicKey) {
        if (publicKey.length() != 40) {
            throw new RuntimeException("z85 publickeys should have a length of 40bytes but got " + publicKey.length());
        }
        if (!this.isCheckThreadRunning()) {
            this.checkAndReload();
        }
        return this.publicKeys.contains(publicKey);
    }

    private void loadFiles(String directory) {
        this.publicKeys.clear();
        this.certCount = 0;
        this.location = directory;
        File f = new File(directory);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (f.isDirectory()) {
            this.modified = f.lastModified();
        }
        this.fileSize = f.list().length;
        this.traverseDirectory(directory, new IFileVisitor(){

            @Override
            public void handleFile(File f) {
                try {
                    ZConfig zconf = ZConfig.load(f.getAbsolutePath());
                    String publicKey = zconf.getValue("curve/public-key");
                    if (publicKey == null) {
                        System.out.println("Warning!! File has no curve/public-key-element: " + f.getAbsolutePath() + " SKIPPING!");
                        return;
                    }
                    if (publicKey.length() == 32) {
                        publicKey = ZMQ.Curve.z85Encode(publicKey.getBytes());
                    }
                    ZCertStore.this.publicKeys.add(publicKey);
                    ZCertStore.this.certCount++;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void handleDir(File f) {
                ZCertStore.this.fileSize = ZCertStore.this.fileSize + f.list().length;
            }
        });
    }

    public int getAmountCertificates() {
        if (!this.isCheckThreadRunning()) {
            this.checkAndReload();
        }
        return this.publicKeys.size();
    }

    private boolean directoryModified(String path) {
        File f = new File(path);
        return f.exists() && f.isDirectory() && f.lastModified() != this.modified;
    }

    public boolean checkCertFolderForChanges() {
        if (this.directoryModified(this.location)) {
            return true;
        }
        File f = new File(this.location);
        if (!f.exists()) {
            return true;
        }
        this.tempCounter = f.list().length;
        this.traverseDirectory(f, new IFileVisitor(){

            @Override
            public void handleFile(File f) {
            }

            @Override
            public void handleDir(File f) {
                ZCertStore.this.tempCounter = ZCertStore.this.tempCounter + f.list().length;
            }
        });
        return this.tempCounter != this.fileSize;
    }

    public void checkAndReload() {
        this.checkAndReload(false);
    }

    public void checkAndReload(boolean force) {
        if (force || this.checkCertFolderForChanges()) {
            this.loadFiles(this.location);
        }
    }

    public void startCheckThread(final int checkTime) {
        if (this.fileCheckRunning) {
            return;
        }
        this.fileCheckRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (ZCertStore.this.fileCheckRunning && !ZCertStore.this.requestStopThread) {
                    ZCertStore.this.checkAndReload();
                    try {
                        Thread.sleep(checkTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ZCertStore.this.fileCheckRunning = false;
                ZCertStore.this.requestStopThread = false;
            }
        }).start();
    }

    public void stopCheckThread() {
        this.requestStopThread = true;
    }

    public boolean isCheckThreadRunning() {
        return this.fileCheckRunning;
    }

    private static interface IFileVisitor {
        public void handleFile(File var1);

        public void handleDir(File var1);
    }
}

