/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZConfig {
    private static final Pattern PTRN_CONTAINER = Pattern.compile("^( *)([0-9a-zA-Z\\$\\-_@\\.&\\+\\/]+)( *#.*)?$");
    private static final Pattern PTRN_KEYVALUE = Pattern.compile("^( *)([0-9a-zA-Z\\$\\-_@\\.&\\+\\/]+) = ((\"|')(.*)(\\4)|(.*?))(#.*)?$");
    private static int currentLineNr = 0;
    private String name;
    private String value;
    private ZConfig parent;
    private HashMap<String, ZConfig> childMap = new HashMap();
    private List<String> comments = new LinkedList<String>();

    public ZConfig(String name, ZConfig parent) {
        this.parent = parent;
        this.setName(name);
    }

    public void setName(String name) {
        if (this.parent != null) {
            if (this.name != null) {
                this.parent.childMap.remove(name);
            }
            this.parent.childMap.put(name, this);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(String path) {
        return this.getValue(path, null);
    }

    public String getValue(String path, String defaultValue) {
        String[] pathElements = path.split("/");
        ZConfig current = this;
        for (String pathElem : pathElements) {
            if (pathElem.isEmpty() || (current = current.childMap.get(pathElem)) != null) continue;
            return defaultValue;
        }
        return current.value;
    }

    public boolean pathExists(String path) {
        String[] pathElements = path.split("/");
        ZConfig current = this;
        for (String pathElem : pathElements) {
            if (pathElem.isEmpty() || (current = current.childMap.get(pathElem)) != null) continue;
            return false;
        }
        return true;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public ZConfig putValue(String path, String value) {
        String[] pathElements = path.split("/");
        ZConfig current = this;
        for (String pathElement : pathElements) {
            if (pathElement.isEmpty()) continue;
            ZConfig container = current.childMap.get(pathElement);
            if (container == null) {
                container = new ZConfig(pathElement, current);
            }
            current = container;
        }
        current.value = value;
        return current;
    }

    private void setValue(String value) {
        this.value = value;
    }

    private static void visit(ZConfig startNode, IVisitor handler, Object context, int level) {
        handler.handleNode(startNode, context, level);
        for (ZConfig node : startNode.childMap.values()) {
            ZConfig.visit(node, handler, context, level + 1);
        }
    }

    public void save(String filename) {
        final StringBuffer result = new StringBuffer();
        ZConfig.visit(this, new IVisitor(){

            @Override
            public void handleNode(ZConfig node, Object ctx, int level) {
                if (node.comments.size() > 0) {
                    for (String comment : node.comments) {
                        result.append("# ").append(comment).append('\n');
                    }
                    result.append("\n");
                }
                if (level > 0) {
                    String prefix = level > 1 ? String.format("%" + (level - 1) * 4 + "s", " ") : "";
                    result.append(prefix);
                    if (node.value == null) {
                        result.append(node.name).append("\n");
                    } else {
                        result.append(String.format("%s = \"%s\"\n", node.name, node.value));
                    }
                }
            }
        }, null, 0);
        if (filename.equals("-")) {
            System.out.println(result.toString());
        } else {
            try {
                File file = new File(filename);
                if (file.exists()) {
                    file.delete();
                } else {
                    try {
                        file.getParentFile().mkdirs();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                FileWriter writer = new FileWriter(file);
                writer.write(result.toString());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ZConfig load(String filename) {
        try {
            String line;
            currentLineNr = 0;
            ZConfig result = new ZConfig("root", null);
            ArrayList<String> content = new ArrayList<String>();
            BufferedReader fr = new BufferedReader(new FileReader(filename));
            while ((line = fr.readLine()) != null) {
                if (line.matches("^ *#.*|^ *[0-9]+.*") || line.isEmpty()) continue;
                content.add(line);
            }
            fr.close();
            ZConfig.processLoad(result, content, 0);
            return result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void processLoad(ZConfig node, List<String> content, int currentLevel) {
        while (currentLineNr < content.size()) {
            String currentLine = content.get(currentLineNr);
            Matcher container = PTRN_CONTAINER.matcher(currentLine);
            if (container.find()) {
                int containerLevel = container.group(1).length() / 4;
                if (containerLevel > currentLevel) {
                    throw new RuntimeException("Level mismatch in line:" + currentLine);
                }
                if (containerLevel < currentLevel) break;
                ++currentLineNr;
                String containerName = container.group(2);
                ZConfig zcontainer = new ZConfig(containerName, node);
                ZConfig.processLoad(zcontainer, content, currentLevel + 1);
                continue;
            }
            Matcher keyvalue = PTRN_KEYVALUE.matcher(currentLine);
            if (keyvalue.find()) {
                int containerLevel = keyvalue.group(1).length() / 4;
                if (containerLevel != currentLevel) {
                    throw new RuntimeException("Level mismatch in line:" + currentLine);
                }
                ++currentLineNr;
                String key = keyvalue.group(2);
                String value = keyvalue.group(5);
                if (value == null) {
                    value = keyvalue.group(7);
                }
                if (value != null) {
                    value = value.trim();
                }
                ZConfig zkeyvalue = new ZConfig(key, node);
                zkeyvalue.setValue(value);
                continue;
            }
            throw new RuntimeException("Couldn't process line:" + currentLine);
        }
    }

    public static interface IVisitor {
        public void handleNode(ZConfig var1, Object var2, int var3);
    }
}

